/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import jd.util.StringUtil;

public class VerboseLog
extends PrintWriter {
    private long startTime_;
    private String modelName_ = "???";
    public final Timing modelTiming = new Timing();
    public final Timing transformTiming = new Timing();
    public final Timing prepareTiming = new Timing();

    public VerboseLog() {
        this(System.err);
    }

    public VerboseLog(OutputStream outputStream) {
        super(outputStream, true);
    }

    public void setModelName(String string) {
        this.modelName_ = string;
    }

    public void printMessage(String string, String string2) {
        this.print(StringUtil.fillupRight(string, 20));
        this.print("= ");
        this.println(string2);
    }

    public void printObject(String string, Object object) {
        String string2 = object == null ? "[null]" : object.getClass().getName();
        this.printMessage(string, string2);
    }

    public void startTimer() {
        this.startTime_ = System.currentTimeMillis();
    }

    public void printTiming() {
        this.printTiming(this.prepareTiming, "prepare stylesheet", null);
        this.printTiming(this.modelTiming, "read xml input", "using " + this.modelName_ + " tree model");
        this.printTiming(this.transformTiming, "transform input", null);
    }

    private void printTiming(Timing timing, String string, String string2) {
        String string3 = timing.totalTime_ + " ms";
        String string4 = null;
        if (timing.count_ > 1) {
            string4 = timing.count_ + " times";
        }
        if (string2 != null) {
            String string5 = string4 = string4 != null ? string4 + ", " + string2 : string2;
        }
        if (string4 != null) {
            string3 = string3 + " (" + string4 + ')';
        }
        this.printMessage(string, string3);
    }

    public void printMemory(long l) {
        long l2 = l / 1024L;
        String string = String.valueOf((double)l2 / 1024.0);
        int n = string.indexOf(46);
        if (string.length() > n + 4) {
            string = string.substring(0, n + 4);
        }
        this.printMessage("max memory usage", string + " MB");
    }

    public static class Timing {
        private int count_;
        private long startTime_;
        private long totalTime_;

        public void startTimer() {
            this.startTime_ = System.currentTimeMillis();
        }

        public void stopTimer() {
            this.totalTime_ += System.currentTimeMillis() - this.startTime_;
            ++this.count_;
        }
    }
}

