/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.IOException;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.attributes.LocalVariableCommonAttribute;
import org.gjt.jclasslib.structures.attributes.LocalVariableTypeTableEntry;

public class LocalVariableTypeTableAttribute
extends LocalVariableCommonAttribute {
    public static final String ATTRIBUTE_NAME = "LocalVariableTypeTable";

    public LocalVariableTypeTableEntry[] getLocalVariableTypeTable() {
        return (LocalVariableTypeTableEntry[])this.localVariableTable;
    }

    public void setLocalVariableTypeTable(LocalVariableTypeTableEntry[] localVariableTypeTableEntryArray) {
        this.localVariableTable = localVariableTypeTableEntryArray;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        super.read(dataInput);
        int n = dataInput.readUnsignedShort();
        this.localVariableTable = new LocalVariableTypeTableEntry[n];
        for (int i = 0; i < n; ++i) {
            this.localVariableTable[i] = LocalVariableTypeTableEntry.create(dataInput, this.classFile);
        }
        if (this.debug) {
            this.debug("read ");
        }
    }

    public int getAttributeLength() {
        return 2 + this.getLength(this.localVariableTable) * 10;
    }

    protected void debug(String string) {
        super.debug(string + "LocalVariableTypeTable attribute with " + this.getLength(this.localVariableTable) + " entries");
    }
}

