/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.rose.internal;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.exception.LicenseException;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.compare.DifferenceDescriptor;
import com.metamatrix.modeler.compare.DifferenceProcessor;
import com.metamatrix.modeler.compare.DifferenceReport;
import com.metamatrix.modeler.compare.MergeProcessor;
import com.metamatrix.modeler.compare.ModelerComparePlugin;
import com.metamatrix.modeler.compare.processor.DifferenceProcessorImpl;
import com.metamatrix.modeler.compare.processor.MergeProcessorImpl;
import com.metamatrix.modeler.compare.selector.EmfResourceSelector;
import com.metamatrix.modeler.compare.selector.ModelSelector;
import com.metamatrix.modeler.compare.selector.TransientModelSelector;
import com.metamatrix.modeler.compare.util.CompareUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.TransactionRunnable;
import com.metamatrix.modeler.core.refactor.OrganizeImportCommand;
import com.metamatrix.modeler.core.refactor.OrganizeImportHandler;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.core.resource.xmi.MtkXmiResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.rose.internal.IAmbiguousReference;
import com.metamatrix.rose.internal.IMessage;
import com.metamatrix.rose.internal.IMessageListener;
import com.metamatrix.rose.internal.IRoseConstants;
import com.metamatrix.rose.internal.IRoseHandler;
import com.metamatrix.rose.internal.IUnit;
import com.metamatrix.rose.internal.impl.AmbiguousReference;
import com.metamatrix.rose.internal.impl.Message;
import com.metamatrix.rose.internal.impl.Unit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.importer.rose.builder.RoseVisitor;
import org.eclipse.emf.importer.rose.builder.RoseWalker;
import org.eclipse.emf.importer.rose.parser.RoseLexer;
import org.eclipse.emf.importer.rose.parser.RoseLoader;
import org.eclipse.emf.importer.rose.parser.RoseNode;
import org.eclipse.emf.importer.rose.parser.RoseParser;
import org.eclipse.emf.importer.rose.parser.Util;
import org.eclipse.emf.importer.util.ImporterUtil;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;

public final class RoseImporter
implements FileUtils.Constants,
IRoseConstants,
ModelerCore.ILicense,
StringUtil.Constants {
    private static final String CAPABILITY = "Importer/Rose";
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$rose$internal$RoseImporter == null ? (class$com$metamatrix$rose$internal$RoseImporter = RoseImporter.class$("com.metamatrix.rose.internal.RoseImporter")) : class$com$metamatrix$rose$internal$RoseImporter));
    private static final String CLOSED_PROJECT_MESSAGE_ID = "closedProjectMessage";
    private static final String DIFFERENT_METAMODEL_MESSAGE_ID = "differentMetamodelMessage";
    private static final String FINISH_PARSING_MESSAGE = "finishParsingMessage";
    private static final String FOLDER_MESSAGE_ID = "folderMessage";
    private static final String IO_EXCEPTION_MESSAGE_ID = "ioExceptionMessage";
    private static final String LOADING_UNIT_MESSAGE_ID = "loadingUnitMessage";
    private static final String MISSING_FOLDER_MESSAGE_ID = "missingFolderMessage";
    private static final String NOT_MODEL_MESSAGE_ID = "notModelMessage";
    private static final String NO_UNITS_SELECTED_MESSAGE = RoseImporter.getString("noUnitsSelectedMessage");
    private static final String PARSING_UNIT_MESSAGE_ID = "parsingUnitMessage";
    private static final String PATH_NOT_FOUND_MESSAGE = RoseImporter.getString("pathNotFoundMessage");
    private static final String PATH_UNRESOLVABLE_MESSAGE = RoseImporter.getString("pathUnresolvableMessage");
    private static final String READ_ONLY_MESSAGE_ID = "readOnlyMessage";
    private static final String START_PARSING_MESSAGE = "startParsingMessage";
    private static Boolean licensed;
    private Map pathMap = new HashMap();
    private Unit unit;
    private List sourceMsgListener = new ArrayList();
    private List selectedUnits = new ArrayList();
    private List targetProblems = new ArrayList();
    private List parseProblems = new ArrayList();
    private int ambiguousRefs;
    private IRoseHandler handler;
    private Map diffProcMap = new HashMap();
    private List matcherFactories = ModelerComparePlugin.createEObjectMatcherFactories();
    private URIConverter uriConverter = ImporterUtil.createResourceSet().getURIConverter();
    static /* synthetic */ Class class$com$metamatrix$rose$internal$RoseImporter;

    private static String getString(String id) {
        return IRoseConstants.UTIL.getString(I18N_PREFIX + id);
    }

    private static String getString(String id, Object parameter) {
        return IRoseConstants.UTIL.getString(I18N_PREFIX + id, parameter);
    }

    private static String getString(String id, Object parameter1, Object parameter2) {
        return IRoseConstants.UTIL.getString(I18N_PREFIX + id, parameter1, parameter2);
    }

    private static String getString(String id, Object parameter1, Object parameter2, Object parameter3) {
        return IRoseConstants.UTIL.getString(I18N_PREFIX + id, parameter1, parameter2, parameter3);
    }

    public RoseImporter(IRoseHandler handler) throws LicenseException {
        ArgCheck.isNotNull((Object)handler);
        if (licensed == null) {
            try {
                LicensePlugin.checkLicense((String)"Modeler", (String)"5.0");
                licensed = LicensePlugin.isCapabilityLicensed((String)"Modeler", (String)CAPABILITY, (String)"5.0") ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (CoreException err) {
                licensed = Boolean.FALSE;
            }
        }
        if (!licensed.booleanValue()) {
            throw new LicenseException();
        }
        handler.initialize(this.matcherFactories);
        this.handler = handler;
    }

    public void addUnitSourceMessageListener(IMessageListener listener) {
        ArgCheck.isNotNull((Object)listener);
        this.sourceMsgListener.add(listener);
    }

    public boolean ambiguousReferencesResolved() {
        return this.ambiguousRefs == 0;
    }

    public List getAmbiguousReferences() {
        return this.handler.getAmbiguousReferences();
    }

    public List getParseProblems() {
        return Collections.unmodifiableList(this.parseProblems);
    }

    public Map getPathMap() {
        return Collections.unmodifiableMap(this.pathMap);
    }

    public List getSelectedUnits() {
        return Collections.unmodifiableList(this.selectedUnits);
    }

    public IUnit getUnitWithMostSevereTargetProblem() {
        return this.targetProblems.isEmpty() ? null : (IUnit)this.targetProblems.get(0);
    }

    public void removeUnitSourceMessageListener(IMessageListener listener) {
        ArgCheck.isNotNull((Object)listener);
        this.sourceMsgListener.remove(listener);
    }

    private void garbageCollect() {
        System.gc();
        Thread.yield();
    }

    public List generateDifferenceReports(IProgressMonitor monitor) {
        if (this.ambiguousRefs > 0) {
            return Collections.EMPTY_LIST;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<DifferenceReport> rpts = new ArrayList<DifferenceReport>(this.diffProcMap.size());
        Iterator iter = this.diffProcMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            DifferenceProcessorImpl diffProc = (DifferenceProcessorImpl)entry.getValue();
            diffProc.addEObjectMatcherFactories(this.matcherFactories);
            IStatus status = diffProc.execute(monitor);
            if (status.isOK()) {
                DifferenceReport rpt = diffProc.getDifferenceReport();
                rpt.setTitle(rpt.getResultUri());
                CompareUtil.skipDeletesOfStandardContainers((DifferenceReport)rpt);
                this.handler.differenceReportGenerated((List)rpt.getMapping().getNested());
                rpts.add(rpt);
                continue;
            }
            this.parseProblems.add(new Message(status.getSeverity(), status.getMessage(), status.getException(), (Object)diffProc));
            IRoseConstants.UTIL.log(status);
        }
        this.garbageCollect();
        return Collections.unmodifiableList(rpts);
    }

    protected List getRoots(DifferenceProcessorImpl processor) throws ModelerCoreException {
        return processor.getAfterSelector().getRootObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List importModels(IProgressMonitor monitor) {
        this.handler.cleanup();
        this.garbageCollect();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProgressMonitor finalMon = monitor;
        ArrayList<Message> problems = new ArrayList<Message>();
        ArrayList<Resource> resrcs = new ArrayList<Resource>(this.diffProcMap.size());
        Iterator iter = this.diffProcMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            DifferenceProcessorImpl diffProc = (DifferenceProcessorImpl)entry.getValue();
            if (!this.shouldMergeModels((DifferenceProcessor)diffProc)) continue;
            MergeProcessorImpl mergeProc = new MergeProcessorImpl(diffProc, null, true);
            EmfResourceSelector targetSelector = (EmfResourceSelector)diffProc.getBeforeSelector();
            TransactionRunnable op = new TransactionRunnable((MergeProcessor)mergeProc, finalMon, diffProc){
                private final /* synthetic */ MergeProcessor val$mergeProc;
                private final /* synthetic */ IProgressMonitor val$finalMon;
                private final /* synthetic */ DifferenceProcessorImpl val$diffProc;
                {
                    this.val$mergeProc = val$mergeProc;
                    this.val$finalMon = val$finalMon;
                    this.val$diffProc = val$diffProc;
                }

                public Object run(UnitOfWork work) {
                    IStatus status = this.val$mergeProc.execute(this.val$finalMon);
                    RoseImporter.this.handler.modelsMerged((List)this.val$diffProc.getDifferenceReport().getMapping().getNested());
                    return status;
                }
            };
            try {
                Resource resrc = targetSelector.getResource();
                IStatus status = (IStatus)ModelerCore.getModelEditor().executeAsTransaction(op, null, true, (Object)this);
                if (status.isOK()) {
                    resrcs.add(resrc);
                    continue;
                }
                problems.add(new Message(status.getSeverity(), status.getMessage(), status.getException(), (Object)resrc));
                IRoseConstants.UTIL.log(status);
            }
            catch (Exception err) {
                problems.add(new Message((Throwable)err));
                IRoseConstants.UTIL.log((Throwable)err);
            }
            finally {
                mergeProc.close();
            }
        }
        ArrayList<ModelResource> models = new ArrayList<ModelResource>(this.diffProcMap.size());
        this.diffProcMap.clear();
        String uri = this.handler.getPrimaryMetamodelUri();
        ModelType type = this.handler.getModelType();
        this.handler = null;
        this.garbageCollect();
        Iterator iter2 = resrcs.iterator();
        while (iter2.hasNext()) {
            Resource resrc = (Resource)iter2.next();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resrc.getURI().toFileString()));
            try {
                ModelResource model = ModelerCore.create((IFile)file);
                models.add(model);
                EList contents = model.getEmfResource().getContents();
                Iterator objIter = new ArrayList(resrc.getContents()).iterator();
                while (objIter.hasNext()) {
                    Object obj = objIter.next();
                    if (obj instanceof ModelAnnotation) continue;
                    contents.add(obj);
                }
                ModelAnnotation annotation = model.getModelAnnotation();
                annotation.setPrimaryMetamodelUri(uri);
                annotation.setModelType(type);
                if (resrc instanceof ModelResourceImpl) {
                    ((ModelResourceImpl)resrc).setModelType(type);
                }
                this.garbageCollect();
                model.save(monitor, true);
            }
            catch (CoreException err) {
                problems.add(new Message((Throwable)err));
                IRoseConstants.UTIL.log((Throwable)err);
            }
        }
        OrganizeImportCommand cmd = new OrganizeImportCommand();
        cmd.setHandler(new OrganizeImportHandler(){

            public Object choose(List options) {
                return null;
            }
        });
        Iterator iter3 = models.iterator();
        while (iter3.hasNext()) {
            ModelResource model = (ModelResource)iter3.next();
            try {
                cmd.setResource(model.getEmfResource());
                cmd.execute(monitor);
                this.garbageCollect();
                model.save(monitor, true);
                model.getResource().getParent().refreshLocal(2, monitor);
            }
            catch (CoreException err) {
                problems.add(new Message((Throwable)err));
                IRoseConstants.UTIL.log((Throwable)err);
            }
        }
        this.garbageCollect();
        return problems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public IUnit loadUnit(String path, IProgressMonitor monitor) {
        Unit unit;
        RoseLoader loader;
        block17: {
            String qualifier;
            block15: {
                IUnit iUnit;
                block16: {
                    ArgCheck.isNotEmpty((String)path);
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(RoseImporter.getString(LOADING_UNIT_MESSAGE_ID, path), -1);
                    this.selectedUnits.clear();
                    this.targetProblems.clear();
                    loader = null;
                    loader = new RoseLoader(path, this.uriConverter);
                    if (loader.isValid()) break block15;
                    iUnit = null;
                    Object var11_7 = null;
                    if (loader == null) break block16;
                    try {
                        loader.close();
                    }
                    catch (IOException err) {
                        IRoseConstants.UTIL.log((Throwable)err);
                    }
                }
                monitor.done();
                this.garbageCollect();
                return iUnit;
            }
            RoseParser parser = new RoseParser(new RoseLexer(loader), true, true);
            parser.parse();
            RoseNode node = parser.getModelTree();
            if (node == null) {
                String msg = IRoseConstants.UTIL.getString("RoseImporter.no_nodes");
                throw new MetaMatrixRuntimeException(msg);
            }
            if ("".equals(node.getKey()) && Util.getType((String)node.getValue()).equals("Class_Category")) {
                this.unit = new Unit(Util.getName((String)node.getValue()), path);
                qualifier = Util.getName((String)node.getValue());
            } else {
                int startNdx = path.lastIndexOf(File.separatorChar);
                int endNdx = path.lastIndexOf(46);
                String name = path.substring(startNdx + 1, endNdx >= 0 ? endNdx : path.length());
                this.unit = new Unit(name, path);
                qualifier = null;
            }
            this.unit.setResolvedPath(path);
            this.unit.setRootRoseNode(node);
            new UnitBuilder().traverse(qualifier, node, this.unit);
            this.updateUnitSourceStatus(4, NO_UNITS_SELECTED_MESSAGE, null);
            unit = this.unit;
            Object var11_8 = null;
            if (loader == null) break block17;
            try {
                loader.close();
            }
            catch (IOException err) {
                IRoseConstants.UTIL.log((Throwable)err);
            }
        }
        monitor.done();
        this.garbageCollect();
        return unit;
        catch (Exception notPossible) {
            IUnit iUnit;
            block18: {
                try {
                    this.fireUnitSourceMessage(notPossible);
                    IRoseConstants.UTIL.log((Throwable)notPossible);
                    iUnit = null;
                    Object var11_9 = null;
                    if (loader == null) break block18;
                }
                catch (Throwable throwable) {
                    Object var11_10 = null;
                    if (loader != null) {
                        try {
                            loader.close();
                        }
                        catch (IOException err) {
                            IRoseConstants.UTIL.log((Throwable)err);
                        }
                    }
                    monitor.done();
                    this.garbageCollect();
                    throw throwable;
                }
                try {
                    loader.close();
                }
                catch (IOException err) {
                    IRoseConstants.UTIL.log((Throwable)err);
                }
            }
            monitor.done();
            this.garbageCollect();
            return iUnit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadUnit(IUnit unit, IProgressMonitor monitor) {
        block30: {
            block25: {
                block29: {
                    block24: {
                        block28: {
                            block23: {
                                block21: {
                                    block22: {
                                        ArgCheck.isNotNull((Object)unit);
                                        if (monitor == null) {
                                            monitor = new NullProgressMonitor();
                                        }
                                        monitor.beginTask(RoseImporter.getString("loadingUnitMessage", unit.getQualifiedName()), -1);
                                        unitImpl = (Unit)unit;
                                        loader = null;
                                        try {
                                            try {
                                                if (unit.isLoaded()) {
                                                    var8_5 = null;
                                                    if (loader == null) break block21;
                                                    break block22;
                                                }
                                                if (!unit.exists()) {
                                                    this.updateUnitSourceStatus(unit.getSourceStatus(), unit.getSourceMessage(), unitImpl);
                                                    break block23;
                                                }
                                                loader = new RoseLoader(unit.getResolvedPath(), this.uriConverter);
                                                if (!loader.isValid()) {
                                                    this.updateUnitSourceStatus(4, RoseImporter.getString("ioExceptionMessage", unit.getQualifiedName()), unitImpl);
                                                    break block24;
                                                }
                                                parser = new RoseParser(new RoseLexer(loader), true, true);
                                                parser.parse();
                                                node = parser.getModelTree();
                                                unitImpl.setRootRoseNode(node);
                                                UnitBuilder.access$200(new UnitBuilder(), Util.getName((String)node.getValue()), node, unitImpl);
                                                break block25;
                                            }
                                            catch (Exception notPossible) {
                                                this.fireUnitSourceMessage(notPossible);
                                                IRoseConstants.UTIL.log((Throwable)notPossible);
                                                var8_9 = null;
                                                if (loader != null) {
                                                    try {
                                                        loader.close();
                                                    }
                                                    catch (IOException err) {
                                                        IRoseConstants.UTIL.log((Throwable)err);
                                                    }
                                                }
                                                monitor.done();
                                                this.garbageCollect();
                                                return;
                                            }
                                        }
                                        catch (Throwable var7_20) {
                                            block27: {
                                                var8_10 = null;
                                                if (loader != null) {
                                                    ** try [egrp 2[TRYBLOCK] [10 : 239->247)] { 
lbl49:
                                                    // 1 sources

                                                    loader.close();
                                                    break block27;
lbl51:
                                                    // 1 sources

                                                    catch (IOException err) {
                                                        IRoseConstants.UTIL.log((Throwable)err);
                                                    }
                                                }
                                            }
                                            monitor.done();
                                            this.garbageCollect();
                                            throw var7_20;
                                        }
                                    }
                                    ** try [egrp 2[TRYBLOCK] [10 : 239->247)] { 
lbl59:
                                    // 1 sources

                                    loader.close();
                                    break block21;
lbl61:
                                    // 1 sources

                                    catch (IOException err) {
                                        IRoseConstants.UTIL.log((Throwable)err);
                                    }
                                }
                                monitor.done();
                                this.garbageCollect();
                                return;
                            }
                            var8_6 = null;
                            if (loader != null) {
                                ** try [egrp 2[TRYBLOCK] [10 : 239->247)] { 
lbl71:
                                // 1 sources

                                loader.close();
                                break block28;
lbl73:
                                // 1 sources

                                catch (IOException err) {
                                    IRoseConstants.UTIL.log((Throwable)err);
                                }
                            }
                        }
                        monitor.done();
                        this.garbageCollect();
                        return;
                    }
                    var8_7 = null;
                    if (loader != null) {
                        ** try [egrp 2[TRYBLOCK] [10 : 239->247)] { 
lbl83:
                        // 1 sources

                        loader.close();
                        break block29;
lbl85:
                        // 1 sources

                        catch (IOException err) {
                            IRoseConstants.UTIL.log((Throwable)err);
                        }
                    }
                }
                monitor.done();
                this.garbageCollect();
                return;
            }
            var8_8 = null;
            if (loader != null) {
                ** try [egrp 2[TRYBLOCK] [10 : 239->247)] { 
lbl95:
                // 1 sources

                loader.close();
                break block30;
lbl97:
                // 1 sources

                catch (IOException err) {
                    IRoseConstants.UTIL.log((Throwable)err);
                }
            }
        }
        monitor.done();
        this.garbageCollect();
    }

    public void mapPath(String variable, String path) {
        ArgCheck.isNotNull((Object)variable);
        this.pathMap.put(variable, path);
        if (this.unit != null) {
            this.resolvePath(this.unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parseSelectedUnits(IProgressMonitor monitor) {
        if (this.selectedUnits.isEmpty()) {
            this.parseProblems.add(new Message(4, NO_UNITS_SELECTED_MESSAGE));
            return Collections.EMPTY_LIST;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(START_PARSING_MESSAGE, -1);
        try {
            this.parseProblems.clear();
            this.handler.clear();
            this.diffProcMap.clear();
            this.handler.parsingStarting(monitor);
            if (monitor.isCanceled()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            List units = this.getSelectedUnits();
            this.parseUnits(units, new ArrayList(units), monitor);
            monitor.setTaskName(FINISH_PARSING_MESSAGE);
            ArrayList<List> roots = new ArrayList<List>(this.diffProcMap.size());
            Iterator iter = this.diffProcMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                DifferenceProcessorImpl proc = (DifferenceProcessorImpl)entry.getValue();
                try {
                    roots.add(this.getRoots(proc));
                }
                catch (ModelerCoreException err) {
                    this.parseProblems.add(new Message((Throwable)err));
                    IRoseConstants.UTIL.log((Throwable)err);
                }
            }
            this.handler.parsingFinished(roots);
            this.parseProblems.addAll(this.handler.getProblems());
            this.ambiguousRefs = this.handler.getAmbiguousReferences().size();
            List list = this.getParseProblems();
            return list;
        }
        finally {
            monitor.done();
            this.garbageCollect();
        }
    }

    public boolean resolveAmbiguousReference(IAmbiguousReference reference, Object element) {
        AmbiguousReference ref;
        String type;
        Object referencer;
        block4: {
            String text;
            block3: {
                ArgCheck.isNotNull((Object)reference);
                referencer = reference.getReferencer();
                type = reference.getType();
                String name = reference.getName();
                text = this.handler.getUnresolvableReferenceMessage(referencer, type, name);
                ref = (AmbiguousReference)reference;
                if (element != null) break block3;
                boolean found = false;
                Iterator iter = this.parseProblems.iterator();
                while (iter.hasNext()) {
                    IMessage msg = (IMessage)iter.next();
                    if (msg.getType() != 2 || referencer != msg.getObject() || !text.equals(msg.getText())) continue;
                    found = true;
                    break;
                }
                if (found) break block4;
                this.handler.createMissingObject(type, referencer, ref.getQuid(), name);
                this.parseProblems.add(new Message(2, text, referencer));
                break block4;
            }
            Iterator iter = this.parseProblems.iterator();
            while (iter.hasNext()) {
                IMessage msg = (IMessage)iter.next();
                if (msg.getType() != 2 || referencer != msg.getObject() || !text.equals(msg.getText())) continue;
                iter.remove();
                break;
            }
        }
        ref.setReferencedObject(element);
        this.handler.resolveReference(referencer, element, type, ref.getReferencerQuid());
        if (this.ambiguousRefs > 0) {
            --this.ambiguousRefs;
        }
        return this.ambiguousRefs == 0;
    }

    public void setUnitModelFolder(IUnit unit, IContainer folder) {
        Unit unitImpl = (Unit)unit;
        unitImpl.setModelFolder(folder);
        this.updateUnitTargetStatus(unitImpl);
    }

    public void setUnitModelName(IUnit unit, String name) {
        Unit unitImpl = (Unit)unit;
        unitImpl.setModelName(name);
        this.updateUnitTargetStatus(unitImpl);
    }

    public void setUnitSelected(IUnit unit, boolean selected) {
        if (unit.isSelected() == selected) {
            return;
        }
        Unit unitImpl = (Unit)unit;
        unitImpl.setSelected(selected);
        IUnit unitAncestor = unit.getContainingUnit();
        if (selected) {
            int ndx = -1;
            IUnit ancestor = unit.getContainingUnit();
            if (ancestor != null) {
                List siblings = ancestor.getContainedUnits();
                int unitNdx = siblings.indexOf(unit);
                while (ndx < 0 && unitNdx > 0) {
                    ndx = this.selectedUnits.indexOf(siblings.get(--unitNdx));
                }
                if (ndx < 0) {
                    do {
                        ndx = this.selectedUnits.indexOf(ancestor);
                        ancestor = ancestor.getContainingUnit();
                    } while (ndx < 0 && ancestor != null);
                }
            }
            if (ndx < 0) {
                if (unitAncestor != null) {
                    this.selectedUnits.add(unit);
                } else {
                    this.selectedUnits.add(0, unit);
                }
            } else {
                this.selectedUnits.add(ndx + 1, unit);
            }
            this.updateUnitTargetStatus(unitImpl);
        } else {
            this.selectedUnits.remove(unit);
            this.targetProblems.remove(unit);
        }
    }

    private void fireUnitSourceMessage(int status, String message, Unit unit) {
        this.fireUnitSourceMessage((IMessage)new Message(status, message, (Object)unit));
    }

    private void fireUnitSourceMessage(Throwable error) {
        this.fireUnitSourceMessage((IMessage)new Message(error));
    }

    private void fireUnitSourceMessage(IMessage message) {
        Iterator iter = this.sourceMsgListener.iterator();
        while (iter.hasNext()) {
            ((IMessageListener)iter.next()).messageSent(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseUnits(List units, List unparsedUnits, IProgressMonitor monitor) {
        iter = units.iterator();
        while (iter.hasNext() != false) {
            block19: {
                if (monitor.isCanceled()) {
                    return;
                }
                unit = (Unit)iter.next();
                if (!unparsedUnits.contains(unit) || unparsedUnits.contains(unit.getContainingUnit())) continue;
                if (!unit.isLoaded()) {
                    this.loadUnit((IUnit)unit, null);
                    if (!unit.isLoaded()) {
                        this.parseProblems.add(new Message(4, unit.getSourceMessage(), (Object)unit));
                        continue;
                    }
                }
                monitor.setTaskName(RoseImporter.getString("parsingUnitMessage", unit.getQualifiedName()));
                if (unit.getTargetStatus() == 4) {
                    this.parseProblems.add(new Message(4, unit.getTargetMessage(), (Object)unit));
                    continue;
                }
                loader = null;
                try {
                    block20: {
                        loader = new RoseLoader(unit.getResolvedPath(), this.uriConverter);
                        if (loader.isValid()) break block20;
                        msg = new Message(4, RoseImporter.getString("ioExceptionMessage", unit.getQualifiedName()), (Object)unit);
                        this.parseProblems.add(msg);
                        var16_16 = null;
                        if (loader == null) continue;
                        ** GOTO lbl84
                    }
                    name = unit.getModelName();
                    if (!name.endsWith(".xmi")) {
                        name = name + ".xmi";
                    }
                    path = null;
                    container = unit.getModelFolder();
                    if (container instanceof IProject) {
                        path = container.getFullPath().append(name);
                    } else {
                        folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(unit.getModelFolder().getFullPath());
                        path = folder.getFullPath().append(name);
                    }
                    diffProc = (DifferenceProcessorImpl)this.diffProcMap.get(path);
                    if (diffProc == null) {
                        uri = URI.createURI((String)path.toString());
                        srcSelector = new TransientModelSelector(uri);
                        srcSelector.open();
                        resrc = new MtkXmiResourceImpl(uri);
                        ModelerCore.getModelContainer().getResources().add((Object)resrc);
                        targetSelector = new EmfResourceSelector((Resource)resrc);
                        targetSelector.open();
                        diffProc = new DifferenceProcessorImpl((ModelSelector)targetSelector, (ModelSelector)srcSelector);
                        this.diffProcMap.put(path, diffProc);
                    }
                    roots = this.getRoots(diffProc);
                    this.handler.unitParsingStarting(unit, roots);
                    parser = new RoseParser(new RoseLexer(loader), true, true);
                    parser.parse();
                    new RoseWalker(parser.getModelTree()).traverse((RoseVisitor)this.handler);
                    this.handler.unitParsingFinished(monitor);
                    ** GOTO lbl90
                }
                catch (Exception err) {
                    this.parseProblems.add(new Message((Throwable)err, (Object)unit));
                    IRoseConstants.UTIL.log((Throwable)err);
                    var16_16 = null;
                    if (loader != null) {
                        try {
                            loader.close();
                        }
                        catch (IOException err) {
                            IRoseConstants.UTIL.log((Throwable)err);
                        }
                    }
                    break block19;
                }
                {
                    catch (Throwable var15_18) {
                        var16_16 = null;
                        if (loader == null) throw var15_18;
                        ** try [egrp 2[TRYBLOCK] [6 : 610->618)] { 
lbl79:
                        // 1 sources

                        loader.close();
                        throw var15_18;
lbl81:
                        // 1 sources

                        catch (IOException err) {
                            IRoseConstants.UTIL.log((Throwable)err);
                        }
                        throw var15_18;
                    }
lbl84:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [6 : 610->618)] { 
lbl85:
                    // 1 sources

                    loader.close();
lbl87:
                    // 1 sources

                    catch (IOException err) {
                        IRoseConstants.UTIL.log((Throwable)err);
                    }
                    continue;
lbl90:
                    // 1 sources

                    var16_16 = null;
                    if (loader == null) break block19;
                    ** try [egrp 2[TRYBLOCK] [6 : 610->618)] { 
lbl93:
                    // 1 sources

                    loader.close();
lbl95:
                    // 1 sources

                    catch (IOException err) {}
                    IRoseConstants.UTIL.log((Throwable)err);
                }
            }
            unparsedUnits.remove(unit);
            this.parseUnits(unit.getContainedUnits(), unparsedUnits, monitor);
        }
    }

    private void resolvePath(Unit unit) {
        int ndx;
        String remainingPath = unit.getUnresolvedPath();
        String path = "";
        while ((ndx = remainingPath.indexOf(File.separator)) >= 0) {
            String folder = remainingPath.substring(0, ndx);
            if (folder.startsWith("$")) {
                String var = folder.substring(1);
                String val = (String)this.pathMap.get(var);
                if (val == null) {
                    folder = null;
                    this.pathMap.put(var, "&");
                } else {
                    folder = val;
                }
            }
            if (folder != null && !FileUtils.Constants.CURRENT_FOLDER_SYMBOL.equals(folder) && !"&".equals(folder)) {
                path = path + folder + File.separator;
            }
            remainingPath = remainingPath.substring(ndx + 1);
        }
        if ((path = path + remainingPath).indexOf(58) == -1 && !path.startsWith(File.separator)) {
            String basePath = unit.getContainingUnit().getResolvedPath();
            basePath = basePath.substring(0, basePath.lastIndexOf(File.separator) + 1);
            path = basePath + path;
        }
        boolean didExist = unit.exists();
        unit.setResolvedPath(path);
        if (!unit.exists()) {
            if (unit.getUnresolvedPath().indexOf("$") >= 0) {
                this.updateUnitSourceStatus(2, PATH_UNRESOLVABLE_MESSAGE, unit);
            } else {
                this.updateUnitSourceStatus(4, PATH_NOT_FOUND_MESSAGE, unit);
            }
        } else {
            Iterator iter = unit.getContainedUnits().iterator();
            while (iter.hasNext()) {
                Unit child = (Unit)iter.next();
                if (child.getUnresolvedPath().indexOf("$") < 0) continue;
                this.resolvePath(child);
            }
            if (!didExist) {
                this.updateUnitSourceStatus(0, null, unit);
            }
        }
    }

    private boolean shouldMergeModels(DifferenceProcessor theDiffProcessor) {
        boolean result = true;
        Mapping mapping = theDiffProcessor.getDifferenceReport().getMapping();
        MappingHelper helper = mapping.getHelper();
        if (helper != null && helper instanceof DifferenceDescriptor && ((DifferenceDescriptor)helper).isSkip()) {
            result = false;
        }
        return result;
    }

    public void synchronizePathsRelativeTo(IUnit theUnit) {
        IContainer folder;
        if (theUnit.exists() && (folder = theUnit.getModelFolder()) != null && this.selectedUnits.contains(theUnit)) {
            String folderTxt = new File(theUnit.getResolvedPath()).getParent();
            int nextPartIndex = folderTxt.length();
            Iterator itr = this.selectedUnits.iterator();
            while (itr.hasNext()) {
                String tmpFolderTxt;
                int index;
                IUnit selectedUnit = (IUnit)itr.next();
                if (selectedUnit == theUnit || !selectedUnit.exists() || (index = (tmpFolderTxt = new File(selectedUnit.getResolvedPath()).getParent()).indexOf(folderTxt)) != 0) continue;
                IContainer modelFolder = folder;
                if (!folderTxt.equals(tmpFolderTxt)) {
                    Path path = new Path(tmpFolderTxt.substring(nextPartIndex));
                    modelFolder = folder.getFolder((IPath)path);
                }
                this.setUnitModelFolder(selectedUnit, modelFolder);
            }
        }
    }

    private String toNativePath(String path) {
        path = Util.trimQuotes((String)path);
        path = Util.updateFileName((String)path, (String)"\\\\");
        path = Util.updateFileName((String)path, (String)"\\");
        path = Util.updateFileName((String)path, (String)"/");
        return path;
    }

    private void updateUnitSourceStatus(int status, String message, Unit unit) {
        if (unit != null) {
            unit.setLoadStatus(status);
            unit.setLoadMessage(message);
        }
        this.fireUnitSourceMessage(status, message, unit);
    }

    private void updateUnitTargetStatus(Unit unit) {
        this.updateUnitTargetStatus(0, null, unit);
        IContainer folder = unit.getModelFolder();
        if (folder == null) {
            this.updateUnitTargetStatus(4, RoseImporter.getString(MISSING_FOLDER_MESSAGE_ID, unit.getName()), unit);
        } else if (folder instanceof IProject && !((IProject)folder).isOpen()) {
            this.updateUnitTargetStatus(4, RoseImporter.getString(CLOSED_PROJECT_MESSAGE_ID, unit.getName(), folder.getFullPath().makeRelative()), unit);
        } else {
            IResource resrc = unit.getWorkspaceResource();
            if (resrc != null) {
                if (ModelUtil.isIResourceReadOnly((IResource)resrc)) {
                    this.updateUnitTargetStatus(4, RoseImporter.getString(READ_ONLY_MESSAGE_ID, unit.getName(), resrc.getFullPath()), unit);
                } else if (resrc instanceof IContainer) {
                    this.updateUnitTargetStatus(4, RoseImporter.getString(FOLDER_MESSAGE_ID, unit.getName(), resrc.getFullPath()), unit);
                } else if (!ModelUtil.isModelFile((IResource)resrc)) {
                    this.updateUnitTargetStatus(2, RoseImporter.getString(NOT_MODEL_MESSAGE_ID, unit.getName(), resrc.getFullPath()), unit);
                } else {
                    String uri = null;
                    try {
                        uri = ModelUtil.getModel((Object)resrc).getPrimaryMetamodelDescriptor().getNamespaceURI();
                    }
                    catch (ModelWorkspaceException err) {
                        IRoseConstants.UTIL.log((Throwable)err);
                    }
                    if (uri != null && !uri.equals(this.handler.getPrimaryMetamodelUri())) {
                        this.updateUnitTargetStatus(2, RoseImporter.getString(DIFFERENT_METAMODEL_MESSAGE_ID, unit.getName(), resrc.getFullPath(), uri), unit);
                    }
                }
            }
        }
    }

    private void updateUnitTargetStatus(int status, String message, Unit unit) {
        unit.setParseStatus(status);
        unit.setParseMessage(message);
        this.targetProblems.remove(unit);
        if (status == 0) {
            return;
        }
        int ndx = 0;
        Iterator iter = this.targetProblems.iterator();
        if (iter.hasNext()) {
            Unit problemUnit = (Unit)iter.next();
            while (problemUnit.getTargetStatus() > status) {
                ++ndx;
                if (!iter.hasNext()) break;
                problemUnit = (Unit)iter.next();
            }
            if (problemUnit.getTargetStatus() == status) {
                int selectionNdx = this.selectedUnits.indexOf(unit);
                while (problemUnit.getTargetStatus() == status && this.selectedUnits.indexOf(problemUnit) < selectionNdx) {
                    ++ndx;
                    if (!iter.hasNext()) break;
                    problemUnit = (Unit)iter.next();
                }
            }
        }
        this.targetProblems.add(ndx, unit);
    }

    public Collection testGetDifferenceProcessors() {
        return this.diffProcMap.values();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UnitBuilder {
        private static final String QUALIFIER_SEPARATOR = ".";

        private UnitBuilder() {
        }

        private void traverse(String qualifier, RoseNode node, Unit unit) {
            List nodes = node.getNodes();
            for (int ndx = 0; ndx < nodes.size(); ++ndx) {
                RoseNode child = (RoseNode)nodes.get(ndx);
                if (child.getRoseNodeType() == 2) {
                    this.traverseObject(qualifier, child, unit);
                    continue;
                }
                if (child.getRoseNodeType() != 3) continue;
                this.traverseList(qualifier, child, unit);
            }
        }

        private void traverseList(String qualifier, RoseNode node, Unit unit) {
            this.traverse(qualifier, node, unit);
        }

        private void traverseObject(String qualifier, RoseNode node, Unit unit) {
            String key = node.getKey();
            String type = Util.getType((String)node.getValue());
            String name = Util.getName((String)node.getValue());
            if ("root_category".equals(key) && "Class_Category".equals(type)) {
                this.traverse(qualifier, node, unit);
            } else if ("".equals(key) && "Class_Category".equals(type)) {
                if (node.findNodeWithKey("is_loaded") != null) {
                    String path = RoseImporter.this.toNativePath(node.findNodeWithKey("file_name").getValue());
                    Unit child = new Unit(name, path);
                    unit.addUnit(child);
                    RoseImporter.this.resolvePath(child);
                } else {
                    String qualifiedName = name;
                    if (qualifier != null) {
                        qualifiedName = qualifier + QUALIFIER_SEPARATOR + name;
                    }
                    this.traverse(qualifiedName, node, unit);
                }
            } else if ("Class".equals(type)) {
                String qualifiedName = qualifier == null ? name : qualifier + QUALIFIER_SEPARATOR + name;
                this.traverse(qualifiedName, node, unit);
            } else if ("Operation".equals(type) || "ClassAttribute".equals(type) || "Inheritance_Relationship".equals(type) || "Association".equals(type) || "Role".equals(type) || "Visibility_Relationship".equals(type) || "Uses_Relationship".equals(type)) {
                this.traverse(qualifier, node, unit);
            }
        }
    }
}

