/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.mapping.ui.choice;

import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.modeler.internal.mapping.factory.TreeMappingAdapter;
import com.metamatrix.modeler.internal.transformation.util.SymbolUUIDMappingVisitor;
import com.metamatrix.modeler.internal.transformation.util.TransformationHelper;
import com.metamatrix.modeler.internal.ui.explorer.ModelExplorerLabelProvider;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.mapping.choice.IChoiceObject;
import com.metamatrix.modeler.mapping.factory.IMappableTree;
import com.metamatrix.modeler.mapping.ui.PluginConstants;
import com.metamatrix.modeler.mapping.ui.UiConstants;
import com.metamatrix.modeler.mapping.ui.UiPlugin;
import com.metamatrix.modeler.mapping.ui.choice.BuilderTreeProvider;
import com.metamatrix.modeler.mapping.ui.choice.ChoiceCriteriaStrategy;
import com.metamatrix.modeler.mapping.ui.choice.ChoicePanel;
import com.metamatrix.modeler.mapping.ui.choice.CriteriaSourceViewerConfiguration;
import com.metamatrix.modeler.mapping.ui.choice.CriteriaTextViewer;
import com.metamatrix.modeler.mapping.ui.choice.actions.ClearCriteria;
import com.metamatrix.modeler.mapping.ui.choice.actions.HideExcludedOptions;
import com.metamatrix.modeler.mapping.ui.choice.actions.LaunchCriteriaBuilder;
import com.metamatrix.modeler.transformation.validation.TransformationValidator;
import com.metamatrix.query.internal.ui.builder.CriteriaBuilder;
import com.metamatrix.query.internal.ui.builder.util.ElementViewerFactory;
import com.metamatrix.query.internal.ui.builder.util.ICriteriaStrategy;
import com.metamatrix.query.internal.ui.sqleditor.sql.ColorManager;
import com.metamatrix.query.resolver.util.QueryValidationResult;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.navigator.DeepSpParameterPreOrderNavigator;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import com.metamatrix.ui.internal.util.WidgetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ChoicePanel
extends SashForm
implements ISelectionChangedListener,
SelectionListener,
UiConstants,
PluginConstants,
INotifyChangedListener {
    private static final int BUTTON_GRID_STYLE = 320;
    private static final String NEED_MAPPING_CLASS_TITLE = UiConstants.Util.getString("ChoicePanel.needMappingClass.title");
    private static final String NEED_MAPPING_CLASS_MSG = UiConstants.Util.getString("ChoicePanel.needMappingClass.text");
    private static final int ORDINAL_INDEX = 0;
    private static final int OPTION_NAME_INDEX = 1;
    private static final int INCLUDES_INDEX = 2;
    private static final int CRITERIA_INDEX = 3;
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ") ";
    private static final String COLON = ":";
    private IChoiceObject icoChoiceObject;
    private TreeMappingAdapter mappingAdapter;
    private IMappableTree mappableTree;
    private Composite pnlEditTabOuterComposite;
    private CTabFolder tabFolder;
    private CTabItem tiEditTab;
    private CTabItem tiSummaryTab;
    private CriteriaTextViewer svrSummarySource;
    protected static final int VERTICAL_RULER_WIDTH = 12;
    private Document docChoiceCriteria;
    private String NEWLINE = "\n";
    private String INDENT = "     ";
    private String DEFAULT = "Default";
    private String UNDEFINED = "<undefined>";
    private Composite pnlTableStuff;
    private Table tblOptionTable;
    private TableViewer tvOptionTableViewer;
    private Composite pnlRowMoveButtons;
    private Button btnUp;
    private Button btnDown;
    private CLabel lblDefaultTitle;
    private ComboContribution contDefaultComboBoxContribution;
    private LaunchCriteriaBuilder actLaunchCriteriaBuilder;
    private ClearCriteria actClearCriteria;
    private HideExcludedOptions actHideExcludedOptions;
    private ChoiceViewerFilter cvfExcludeFilter;
    private TableContentProvider cpChoiceContentProvider;
    private TableLabelProvider lpChoiceLabelProvider;
    private CriteriaSourceViewerConfiguration csvcViewerConfig;
    private ColorManager colorManager;
    private List lstReservedWords;
    private ModelExplorerLabelProvider melpAdHocLabelProvider;
    private String EMPTY_STRING = "";
    private String[] columnNames = new String[]{ORDINAL_COL_TEXT, NAME_COL_TEXT, INCLUDE_COL_TEXT, CRITERIA_COL_TEXT};
    private static final int LABEL_GRID_STYLE = 32;
    private static final String EDIT_TAB_TEXT = UiConstants.Util.getString("ChoicePanel.editTab.text");
    private static final String SUMMARY_TAB_TEXT = UiConstants.Util.getString("ChoicePanel.summaryTab.text");
    private static final String ORDINAL_COL_TEXT = UiConstants.Util.getString("ChoicePanel.ordinalCol.text");
    private static final String NAME_COL_TEXT = UiConstants.Util.getString("ChoicePanel.nameCol.text");
    private static final String INCLUDE_COL_TEXT = UiConstants.Util.getString("ChoicePanel.includeCol.text");
    private static final String CRITERIA_COL_TEXT = UiConstants.Util.getString("ChoicePanel.criteriaCol.text");
    private static final String UP_BUTTON_TEXT = UiConstants.Util.getString("ChoicePanel.upButton.text");
    private static final String UP_BUTTON_TOOLTIP = UiConstants.Util.getString("ChoicePanel.upButton.toolTip");
    private static final String DOWN_BUTTON_TEXT = UiConstants.Util.getString("ChoicePanel.downButton.text");
    private static final String DOWN_BUTTON_TOOLTIP = UiConstants.Util.getString("ChoicePanel.downButton.toolTip");
    private static final String EDIT_BUTTON_TOOLTIP = UiConstants.Util.getString("ChoicePanel.editButton.toolTip");
    private static final String CLEAR_BUTTON_TOOLTIP = UiConstants.Util.getString("ChoicePanel.clearButton.toolTip");
    private static final String HIDE_CHECKBOX_TOOLTIP = UiConstants.Util.getString("ChoicePanel.hideCheckbox.toolTip");
    private static final String DEFAULT_COMBOBOX_TEXT = UiConstants.Util.getString("ChoicePanel.defaultCombobox.text");
    private static final String DEFAULT_COMBOBOX_TOOLTIP = UiConstants.Util.getString("ChoicePanel.defaultCombobox.toolTip");

    public ChoicePanel(Composite parent, IChoiceObject ico) {
        super(parent, 512);
        this.icoChoiceObject = ico;
        this.init();
    }

    private void init() {
        this.createControl((Composite)this);
        this.setButtonStates();
        this.tblOptionTable.addSelectionListener((SelectionListener)this);
        this.tblOptionTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.icoChoiceObject != null) {
            this.refreshFromBusinessObject();
        }
    }

    private ModelExplorerLabelProvider getAdHocLabelProvider() {
        if (this.melpAdHocLabelProvider == null) {
            this.melpAdHocLabelProvider = new ModelExplorerLabelProvider();
        }
        return this.melpAdHocLabelProvider;
    }

    public void setBusinessObject(IChoiceObject icoChoice) {
        this.icoChoiceObject = icoChoice;
        this.refreshFromBusinessObject();
    }

    public IChoiceObject getChoiceObject() {
        return this.icoChoiceObject;
    }

    public IChoiceObject getChoiceObject2() {
        return this.icoChoiceObject;
    }

    public IChoiceObject getChoiceObject3() {
        return this.icoChoiceObject;
    }

    public void refreshFromBusinessObject() {
        if (!this.tvOptionTableViewer.getControl().isDisposed()) {
            Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void addNotifyChangedListener() {
        ModelUtilities.addNotifyChangedListener((INotifyChangedListener)this);
    }

    public void removeNotifyChangedListener() {
        ModelUtilities.removeNotifyChangedListener((INotifyChangedListener)this);
    }

    public void notifyChanged(Notification n) {
        this.refreshFromBusinessObject();
    }

    public void createControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        this.setLayoutData(gridData);
        this.tabFolder = new CTabFolder(parent, 1024);
        this.createEditTab(this.tabFolder);
        this.createSummaryTab(this.tabFolder);
        this.tabFolder.setSelection(0);
        this.pnlEditTabOuterComposite = new Composite((Composite)this.tabFolder, 0);
        gridLayout = new GridLayout();
        this.pnlEditTabOuterComposite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        this.createTableStuffPanel(this.pnlEditTabOuterComposite);
        this.tiEditTab.setControl((Control)this.pnlEditTabOuterComposite);
        this.tiSummaryTab.setControl(this.svrSummarySource.getControl());
        this.registerListeners();
    }

    private void createEditTab(CTabFolder parent) {
        this.tiEditTab = new CTabItem(parent, 0);
        this.tiEditTab.setText(EDIT_TAB_TEXT);
        this.tiEditTab.setToolTipText(EDIT_TAB_TEXT);
    }

    private void createSummaryTab(CTabFolder parent) {
        this.tiSummaryTab = new CTabItem(parent, 0);
        this.tiSummaryTab.setText(SUMMARY_TAB_TEXT);
        this.tiSummaryTab.setToolTipText(SUMMARY_TAB_TEXT);
        this.colorManager = new ColorManager();
        VerticalRuler verticalRuler = new VerticalRuler(12);
        int styles = 68162;
        this.lstReservedWords = this.getReservedWords();
        this.csvcViewerConfig = new CriteriaSourceViewerConfiguration(this.colorManager, this.lstReservedWords);
        this.svrSummarySource = new CriteriaTextViewer((Composite)parent, (IVerticalRuler)verticalRuler, styles, this.colorManager, this.csvcViewerConfig);
        this.csvcViewerConfig.setReservedWords(this.lstReservedWords);
        this.docChoiceCriteria = new Document();
        this.svrSummarySource.setDocument((IDocument)this.docChoiceCriteria);
        this.svrSummarySource.setEditable(false);
    }

    private void refreshChoiceSummaryPanel() {
        StringBuffer sbCriteria = new StringBuffer();
        this.docChoiceCriteria.set(this.EMPTY_STRING);
        Iterator it = this.icoChoiceObject.getOrderedOptions().iterator();
        while (it.hasNext()) {
            Object oOption = it.next();
            if (!this.icoChoiceObject.isIncluded(oOption)) continue;
            sbCriteria.append(this.getNameWithOrdinal(this.getRowForOption(oOption)) + COLON);
            sbCriteria.append(this.NEWLINE);
            sbCriteria.append(this.INDENT);
            String criteriaText = this.icoChoiceObject.getSqlCriteria(oOption);
            if (criteriaText != null && criteriaText.trim().length() > 0) {
                sbCriteria.append(criteriaText);
            } else {
                sbCriteria.append(this.UNDEFINED);
            }
            sbCriteria.append(this.NEWLINE);
        }
        sbCriteria.append(this.DEFAULT + COLON);
        sbCriteria.append(this.NEWLINE);
        sbCriteria.append(this.INDENT);
        if (this.icoChoiceObject.getDefaultOption() != null) {
            TableRow tb = this.getRowForOption(this.icoChoiceObject.getDefaultOption());
            if (tb != null) {
                String sName = this.getNameWithOrdinal(tb);
                sbCriteria.append(sName);
            } else if (!this.icoChoiceObject.getDefaultErrorMode().equals(this.EMPTY_STRING)) {
                sbCriteria.append(this.icoChoiceObject.getDefaultErrorMode());
            }
        } else if (!this.icoChoiceObject.getDefaultErrorMode().equals(this.EMPTY_STRING)) {
            sbCriteria.append(this.icoChoiceObject.getDefaultErrorMode());
        }
        this.docChoiceCriteria.set(sbCriteria.toString());
        this.csvcViewerConfig.setReservedWords(this.getReservedWords());
        this.svrSummarySource.refresh();
    }

    private void createTableStuffPanel(Composite parent) {
        this.pnlTableStuff = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.pnlTableStuff.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        this.pnlTableStuff.setLayoutData((Object)gridData);
        this.createTableViewerPanel(this.pnlTableStuff);
        this.createRowMoveButtonPanel(this.pnlTableStuff);
    }

    private void createTableViewerPanel(Composite parent) {
        this.createTable(parent);
        this.createTableViewer();
        this.cpChoiceContentProvider = new TableContentProvider(this);
        this.lpChoiceLabelProvider = new TableLabelProvider(this);
        this.tvOptionTableViewer.setContentProvider((IContentProvider)this.cpChoiceContentProvider);
        this.tvOptionTableViewer.setLabelProvider((IBaseLabelProvider)this.lpChoiceLabelProvider);
    }

    private void createTable(Composite parent) {
        int style = 68356;
        this.tblOptionTable = new Table(parent, style);
        TableLayout layout = new TableLayout();
        this.tblOptionTable.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        this.tblOptionTable.setLayoutData((Object)gridData);
        this.tblOptionTable.setLinesVisible(true);
        this.tblOptionTable.setHeaderVisible(true);
        TableColumn column1 = new TableColumn(this.tblOptionTable, 16384, 0);
        column1.setText(ORDINAL_COL_TEXT);
        ColumnWeightData weight = new ColumnWeightData(1);
        layout.addColumnData((ColumnLayoutData)weight);
        TableColumn column2 = new TableColumn(this.tblOptionTable, 16384, 1);
        column2.setText(NAME_COL_TEXT);
        weight = new ColumnWeightData(3);
        layout.addColumnData((ColumnLayoutData)weight);
        TableColumn column3 = new TableColumn(this.tblOptionTable, 16384, 2);
        column3.setText(INCLUDE_COL_TEXT);
        weight = new ColumnWeightData(1);
        layout.addColumnData((ColumnLayoutData)weight);
        TableColumn column4 = new TableColumn(this.tblOptionTable, 16384, 3);
        column4.setText(CRITERIA_COL_TEXT);
        weight = new ColumnWeightData(7);
        layout.addColumnData((ColumnLayoutData)weight);
    }

    private void createTableViewer() {
        this.tvOptionTableViewer = new TableViewer(this.tblOptionTable);
        this.tvOptionTableViewer.setUseHashlookup(true);
        this.tvOptionTableViewer.setColumnProperties(this.columnNames);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        editors[0] = null;
        editors[1] = null;
        editors[2] = null;
        editors[3] = null;
        this.tvOptionTableViewer.setCellEditors(editors);
        this.cvfExcludeFilter = new ChoiceViewerFilter(this);
        this.tvOptionTableViewer.addFilter((ViewerFilter)this.cvfExcludeFilter);
    }

    private void createRowMoveButtonPanel(Composite parent) {
        this.pnlRowMoveButtons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        this.pnlRowMoveButtons.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(1024);
        this.pnlRowMoveButtons.setLayoutData((Object)gridData);
        this.btnUp = WidgetFactory.createButton((Composite)this.pnlRowMoveButtons, (String)UP_BUTTON_TEXT, (int)320);
        this.btnUp.setImage(UiPlugin.getDefault().getImage("icons/full/clcl16/up.gif"));
        this.btnUp.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.btnUp.setToolTipText(UP_BUTTON_TOOLTIP);
        this.btnUp.setLayoutData((Object)new GridData(768));
        this.btnDown = WidgetFactory.createButton((Composite)this.pnlRowMoveButtons, (String)DOWN_BUTTON_TEXT, (int)320);
        this.btnDown.setImage(UiPlugin.getDefault().getImage("icons/full/clcl16/down.gif"));
        this.btnDown.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.btnDown.setLayoutData((Object)new GridData(768));
        this.btnDown.setToolTipText(DOWN_BUTTON_TOOLTIP);
    }

    private void registerListeners() {
    }

    private void upButtonPressed() {
        int iSelectedIndex = this.tblOptionTable.getSelectionIndex();
        Object oSelectedOption = this.getOptionForTableIndex(iSelectedIndex);
        int iChoiceObjectIndexForSelection = this.getIndexForOption(oSelectedOption);
        Object oTargetOption = this.getOptionForTableIndex(iSelectedIndex - 1);
        int iChoiceObjectIndexForTarget = this.getIndexForOption(oTargetOption);
        List lstOrderedOptions = this.icoChoiceObject.getOrderedOptions();
        lstOrderedOptions = this.swapOptions(lstOrderedOptions, iChoiceObjectIndexForSelection, iChoiceObjectIndexForTarget);
        this.icoChoiceObject.setOrderedOptions(lstOrderedOptions);
        this.tvOptionTableViewer.refresh();
        this.tvOptionTableViewer.getTable().setSelection(iSelectedIndex - 1);
        this.handleTableSelection();
        this.refreshChoiceSummaryPanel();
        this.setButtonStates();
    }

    private List swapOptions(List lstOrderedOptions, int iIndexA, int iIndexB) {
        Object[] oOrderedOptions = lstOrderedOptions.toArray();
        Object oHoldOption = oOrderedOptions[iIndexA];
        oOrderedOptions[iIndexA] = oOrderedOptions[iIndexB];
        oOrderedOptions[iIndexB] = oHoldOption;
        ArrayList<Object> aryl = new ArrayList<Object>(oOrderedOptions.length);
        int j = oOrderedOptions.length;
        for (int i = 0; i < j; ++i) {
            aryl.add(oOrderedOptions[i]);
        }
        return aryl;
    }

    private void downButtonPressed() {
        int iSelectedIndex = this.tblOptionTable.getSelectionIndex();
        Object oSelectedOption = this.getOptionForTableIndex(iSelectedIndex);
        int iChoiceObjectIndexForSelection = this.getIndexForOption(oSelectedOption);
        Object oTargetOption = this.getOptionForTableIndex(iSelectedIndex + 1);
        int iChoiceObjectIndexForTarget = this.getIndexForOption(oTargetOption);
        List lstOrderedOptions = this.icoChoiceObject.getOrderedOptions();
        lstOrderedOptions = this.swapOptions(lstOrderedOptions, iChoiceObjectIndexForSelection, iChoiceObjectIndexForTarget);
        this.icoChoiceObject.setOrderedOptions(lstOrderedOptions);
        this.tvOptionTableViewer.refresh();
        this.tvOptionTableViewer.getTable().setSelection(iSelectedIndex + 1);
        this.refreshChoiceSummaryPanel();
        this.setButtonStates();
    }

    private Object getOptionForTableIndex(int iIndex) {
        TableItem ti = this.tblOptionTable.getItem(iIndex);
        TableRow trRow = (TableRow)ti.getData();
        Object oOption = trRow.getOption();
        return oOption;
    }

    private int getIndexForOption(Object oOption) {
        return this.icoChoiceObject.getOrderedOptions().indexOf(oOption);
    }

    private Object getOptionForNameWithOrdinal(String sNameWithOrdinal) {
        for (int i = 0; i < this.tblOptionTable.getItemCount(); ++i) {
            TableItem ti = this.tblOptionTable.getItem(i);
            TableRow trRow = (TableRow)ti.getData();
            if (!this.getNameWithOrdinal(trRow).equals(sNameWithOrdinal)) continue;
            return trRow.getOption();
        }
        return null;
    }

    private TableRow getRowForOption(Object oOption) {
        for (int i = 0; i < this.tblOptionTable.getItemCount(); ++i) {
            TableItem ti = this.tblOptionTable.getItem(i);
            TableRow trRow = (TableRow)ti.getData();
            if (!trRow.isIncluded() || trRow.getOption() != oOption) continue;
            return trRow;
        }
        return null;
    }

    public String getNameWithOrdinal(TableRow trRow) {
        String sName = this.EMPTY_STRING;
        if (trRow != null) {
            String sCombinedName;
            Object oOption = trRow.getOption();
            String sOrdinal = trRow.getColumnText(0);
            String sOptionName = this.getAdHocLabelProvider().getText(oOption);
            sName = sCombinedName = LEFT_PAREN + sOrdinal + RIGHT_PAREN + sOptionName;
        }
        return sName;
    }

    private void handleTableSelection() {
        this.setButtonStates();
    }

    private void defaultComboboxPressed() {
        Combo cbx = this.getComboBoxContributionForDefault().getControl();
        int iSelectedIndex = cbx.getSelectionIndex();
        if (iSelectedIndex < 0) {
            return;
        }
        String sDefault = cbx.getItem(iSelectedIndex);
        if (this.getComboBoxContributionForDefault().isFoundInIncludedOptions(sDefault)) {
            this.icoChoiceObject.setDefaultOption(this.getOptionForNameWithOrdinal(sDefault));
            this.icoChoiceObject.setDefaultErrorMode(this.EMPTY_STRING);
        } else if (this.getComboBoxContributionForDefault().isFoundInErrorModeValues(sDefault)) {
            this.icoChoiceObject.setDefaultErrorMode(sDefault);
            this.icoChoiceObject.setDefaultOption(null);
        } else {
            this.icoChoiceObject.setDefaultOption(null);
            this.icoChoiceObject.setDefaultErrorMode(this.EMPTY_STRING);
        }
        this.refreshChoiceSummaryPanel();
    }

    private List getReservedWords() {
        ArrayList<String> aryl = new ArrayList<String>();
        Combo cbx = this.getComboBoxContributionForDefault().getControl();
        if (cbx == null || cbx.isDisposed()) {
            return aryl;
        }
        for (int i = 0; i < cbx.getItemCount(); ++i) {
            aryl.add(cbx.getItem(i));
        }
        aryl.add(this.DEFAULT + COLON);
        return aryl;
    }

    private List getIncludedOptions() {
        ArrayList arylIncluded = new ArrayList();
        Iterator it = this.icoChoiceObject.getOrderedOptions().iterator();
        while (it.hasNext()) {
            Object oOption = it.next();
            if (!this.icoChoiceObject.isIncluded(oOption)) continue;
            arylIncluded.add(oOption);
        }
        return arylIncluded;
    }

    public void contributeToolbarActions(ToolBarManager toolBarMgr) {
        toolBarMgr.removeAll();
        toolBarMgr.add((IContributionItem)new LabelContribution(this, DEFAULT_COMBOBOX_TEXT));
        toolBarMgr.add((IContributionItem)this.getComboBoxContributionForDefault());
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.add((IAction)this.getLaunchCriteriaBuilderAction());
        toolBarMgr.add((IAction)this.getClearCriteriaBuilderAction());
        toolBarMgr.add((IAction)this.getHideExcludedOptionsAction());
        toolBarMgr.update(true);
        this.setButtonStates();
    }

    private ComboContribution getComboBoxContributionForDefault() {
        if (this.contDefaultComboBoxContribution == null) {
            this.contDefaultComboBoxContribution = new ComboContribution(this);
        }
        return this.contDefaultComboBoxContribution;
    }

    private LaunchCriteriaBuilder getLaunchCriteriaBuilderAction() {
        if (this.actLaunchCriteriaBuilder == null) {
            this.actLaunchCriteriaBuilder = new LaunchCriteriaBuilder(this);
            this.actLaunchCriteriaBuilder.setToolTipText(EDIT_BUTTON_TOOLTIP);
        }
        return this.actLaunchCriteriaBuilder;
    }

    private ClearCriteria getClearCriteriaBuilderAction() {
        if (this.actClearCriteria == null) {
            this.actClearCriteria = new ClearCriteria(this);
            this.actClearCriteria.setToolTipText(CLEAR_BUTTON_TOOLTIP);
        }
        return this.actClearCriteria;
    }

    private HideExcludedOptions getHideExcludedOptionsAction() {
        if (this.actHideExcludedOptions == null) {
            this.actHideExcludedOptions = new HideExcludedOptions(this);
            this.actHideExcludedOptions.setToolTipText(HIDE_CHECKBOX_TOOLTIP);
        }
        return this.actHideExcludedOptions;
    }

    public boolean canLaunchCriteriaBuilder() {
        return this.tvOptionTableViewer.getTable().getSelectionCount() > 0;
    }

    public void launchCriteriaBuilder() {
        MappingClass mc = this.mappingAdapter.getMappingClass(this.icoChoiceObject.getChoice());
        if (mc == null) {
            for (EObject parent = this.icoChoiceObject.getParent(); parent != null && mc == null; parent = parent.eContainer()) {
                mc = this.mappingAdapter.getMappingClass(parent);
            }
        }
        if (mc == null) {
            Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)NEED_MAPPING_CLASS_TITLE, (String)NEED_MAPPING_CLASS_MSG);
            return;
        }
        new BuilderTreeProvider();
        ElementViewerFactory.setCriteriaStrategy((ICriteriaStrategy)new ChoiceCriteriaStrategy());
        ArrayList<MappingClass> lstMappingClassWrapper = new ArrayList<MappingClass>(1);
        lstMappingClassWrapper.addAll(this.getParentMappingClasses(mc));
        lstMappingClassWrapper.add(mc);
        ElementViewerFactory.setViewerInput(lstMappingClassWrapper);
        CriteriaBuilder builder = this.getCriteriaBuilder();
        String sSql = this.icoChoiceObject.getSqlCriteria(this.getSelectedOption());
        if (sSql != null && !sSql.trim().equals(this.EMPTY_STRING)) {
            builder.setLanguageObject((LanguageObject)this.getCommand(mc, sSql, false).getCriteria());
        } else {
            builder.setLanguageObject(null);
        }
        int status = builder.open();
        if (status == 0) {
            LanguageObject newCriteria = builder.getLanguageObject();
            String sqlCriteria = SQLStringVisitor.getSQLString((LanguageObject)newCriteria);
            newCriteria = this.getCommand(mc, sqlCriteria, false).getCriteria();
            this.updateCriteriaForSelectedRow(sqlCriteria, newCriteria);
        }
        this.getLaunchCriteriaBuilderAction().selectionChanged();
    }

    private Collection getParentMappingClasses(MappingClass mappingClass) {
        List parentMappingClasses;
        if (this.mappingAdapter != null && (parentMappingClasses = this.mappingAdapter.getParentMappingClasses(mappingClass, this.mappableTree, false)) != null && !parentMappingClasses.isEmpty()) {
            return parentMappingClasses;
        }
        return Collections.EMPTY_LIST;
    }

    public void setMappingAdapters(TreeMappingAdapter adapter, IMappableTree tree) {
        this.mappingAdapter = adapter;
        this.mappableTree = tree;
        MappingClass mc = this.mappingAdapter.getMappingClass(this.icoChoiceObject.getChoice());
        if (mc == null) {
            for (EObject eParent = this.icoChoiceObject.getParent(); eParent != null && mc == null; eParent = eParent.eContainer()) {
                mc = this.mappingAdapter.getMappingClass(eParent);
            }
        }
        if (mc != null) {
            SymbolUUIDMappingVisitor visitor = new SymbolUUIDMappingVisitor();
            Iterator iter = this.icoChoiceObject.getOrderedOptions().iterator();
            while (iter.hasNext()) {
                Criteria criteria;
                Object option = iter.next();
                String criteriaText = this.icoChoiceObject.getCriteria(option);
                if (criteriaText == null || criteriaText.trim().length() == 0) continue;
                if (criteriaText.indexOf("mmuuid") >= 0) {
                    visitor.convertToUUID(false);
                    criteria = this.getCommand(mc, criteriaText, true).getCriteria();
                    DeepSpParameterPreOrderNavigator.doVisit((LanguageObject)criteria, (LanguageVisitor)visitor);
                    this.icoChoiceObject.setSqlCriteria(option, criteria.toString());
                    continue;
                }
                this.icoChoiceObject.setSqlCriteria(option, criteriaText);
                visitor.convertToUUID(true);
                criteria = this.getCommand(mc, criteriaText, false).getCriteria();
                DeepSpParameterPreOrderNavigator.doVisit((LanguageObject)criteria, (LanguageVisitor)visitor);
                this.icoChoiceObject.setCriteria(option, criteria.toString());
            }
            this.tvOptionTableViewer.refresh();
        }
    }

    private Query getCommand(MappingClass mappingClass, String theCriteria, boolean isUuidSql) {
        String sql = "select * from " + TransformationHelper.getSqlEObjectFullName((EObject)mappingClass) + " where " + theCriteria;
        SqlTransformationMappingRoot mappingRoot = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)mappingClass);
        TransformationValidator validator = new TransformationValidator(mappingRoot, false);
        QueryValidationResult result = validator.validateSql(sql, 0, isUuidSql, false);
        return (Query)result.getCommand();
    }

    private CriteriaBuilder getCriteriaBuilder() {
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(shell);
        criteriaBuilder.create();
        return criteriaBuilder;
    }

    public boolean canClearCriteria() {
        String criteria;
        Object option = this.getSelectedOption();
        if (option != null && (criteria = this.icoChoiceObject.getSqlCriteria(option)) != null) {
            return criteria.trim().length() > 0;
        }
        return false;
    }

    public Object getSelectedOption() {
        Object oOption = null;
        TableItem[] tiArray = this.tblOptionTable.getSelection();
        if (tiArray != null && tiArray.length > 0) {
            TableItem tiSelected = tiArray[0];
            TableRow trRow = (TableRow)tiSelected.getData();
            oOption = trRow.getOption();
        }
        return oOption;
    }

    public void clearCriteria() {
        this.updateCriteriaForSelectedRow(this.EMPTY_STRING, null);
    }

    public void updateCriteriaForSelectedRow(String sCriteria, LanguageObject criteria) {
        int iSelectedIndex = this.tvOptionTableViewer.getTable().getSelectionIndex();
        if (iSelectedIndex < 0) {
            iSelectedIndex = 0;
        }
        Object oOption = this.getOptionForTableIndex(iSelectedIndex);
        this.icoChoiceObject.setSqlCriteria(oOption, sCriteria);
        if (criteria != null) {
            SymbolUUIDMappingVisitor visitor = new SymbolUUIDMappingVisitor();
            visitor.convertToUUID(true);
            DeepSpParameterPreOrderNavigator.doVisit((LanguageObject)criteria, (LanguageVisitor)visitor);
            this.icoChoiceObject.setCriteria(oOption, criteria.toString());
        }
        this.tvOptionTableViewer.refresh();
        this.tvOptionTableViewer.getTable().setSelection(iSelectedIndex);
        this.refreshChoiceSummaryPanel();
        this.getClearCriteriaBuilderAction().selectionChanged();
    }

    public boolean canHideExcludedOptions() {
        return true;
    }

    public void hideExcludedOptions() {
        this.cvfExcludeFilter.setFilterActive(true);
        this.tvOptionTableViewer.refresh();
        this.setButtonStates();
    }

    public void showExcludedOptions() {
        this.cvfExcludeFilter.setFilterActive(false);
        this.tvOptionTableViewer.refresh();
        this.setButtonStates();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setButtonStates();
        this.getLaunchCriteriaBuilderAction().selectionChanged();
        this.getClearCriteriaBuilderAction().selectionChanged();
    }

    private void setButtonStates() {
        ClearCriteria clearAction = this.getClearCriteriaBuilderAction();
        LaunchCriteriaBuilder builderAction = this.getLaunchCriteriaBuilderAction();
        if (ModelObjectUtilities.isReadOnly((EObject)this.getChoiceObject().getChoice())) {
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            clearAction.setEnabled(false);
            builderAction.setEnabled(false);
            if (this.getComboBoxContributionForDefault().getControl() != null && !this.getComboBoxContributionForDefault().getControl().isDisposed()) {
                this.getComboBoxContributionForDefault().getControl().setEnabled(false);
            }
            this.tblOptionTable.setEnabled(false);
        } else {
            int iSelectedIndex = this.tvOptionTableViewer.getTable().getSelectionIndex();
            if (iSelectedIndex > -1) {
                this.btnUp.setEnabled(iSelectedIndex > 0);
                this.btnDown.setEnabled(iSelectedIndex < this.tvOptionTableViewer.getTable().getItemCount() - 1);
            } else {
                this.btnUp.setEnabled(false);
                this.btnDown.setEnabled(false);
            }
            clearAction.selectionChanged();
            builderAction.selectionChanged();
            if (this.getComboBoxContributionForDefault().getControl() != null && !this.getComboBoxContributionForDefault().getControl().isDisposed()) {
                this.getComboBoxContributionForDefault().getControl().setEnabled(true);
            }
            this.tblOptionTable.setEnabled(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        CTabItem tiCurrSelection;
        if (e.getSource() == this.tblOptionTable) {
            this.handleTableSelection();
        } else if (e.getSource() == this.tabFolder && (tiCurrSelection = this.tabFolder.getSelection()) != this.tiEditTab && tiCurrSelection == this.tiSummaryTab) {
            this.refreshChoiceSummaryPanel();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    private void handleMouseEvent(MouseEvent theEvent) {
        if (this.icoChoiceObject == null) {
            return;
        }
        int selectedColumn = -1;
        int selectedRow = -1;
        TableItem[] selection = this.tblOptionTable.getSelection();
        if (selection.length > 0) {
            int numCols = this.tblOptionTable.getColumnCount();
            for (int i = 0; i < numCols; ++i) {
                Rectangle bounds = selection[0].getBounds(i);
                if (!bounds.contains(theEvent.x, theEvent.y)) continue;
                selectedColumn = i;
                break;
            }
            selectedRow = this.tblOptionTable.getSelectionIndex();
        }
        if (selectedColumn == 2) {
            TableItem[] tiArray = this.tblOptionTable.getSelection();
            TableItem tiSelected = tiArray[0];
            TableRow trRow = (TableRow)tiSelected.getData();
            Object oOption = trRow.getOption();
            if (this.icoChoiceObject.isIncluded(oOption)) {
                this.icoChoiceObject.setIncluded(oOption, false);
                if (this.icoChoiceObject.getDefaultOption() == oOption) {
                    this.icoChoiceObject.setDefaultOption(null);
                    this.getComboBoxContributionForDefault().getControl().clearSelection();
                }
            } else {
                this.icoChoiceObject.setIncluded(oOption, true);
            }
            this.getComboBoxContributionForDefault().loadItems();
        }
        this.tvOptionTableViewer.refresh();
        this.tvOptionTableViewer.getTable().setSelection(selectedRow);
        this.csvcViewerConfig.setReservedWords(this.getReservedWords());
        this.refreshChoiceSummaryPanel();
    }

    static /* synthetic */ void access$000(ChoicePanel x0, MouseEvent x1) {
        x0.handleMouseEvent(x1);
    }

    static /* synthetic */ IChoiceObject access$100(ChoicePanel x0) {
        return x0.icoChoiceObject;
    }

    static /* synthetic */ TableViewer access$200(ChoicePanel x0) {
        return x0.tvOptionTableViewer;
    }

    static /* synthetic */ ComboContribution access$300(ChoicePanel x0) {
        return x0.getComboBoxContributionForDefault();
    }

    static /* synthetic */ void access$400(ChoicePanel x0) {
        x0.refreshChoiceSummaryPanel();
    }

    static /* synthetic */ void access$500(ChoicePanel x0) {
        x0.setButtonStates();
    }

    static /* synthetic */ void access$600(ChoicePanel x0) {
        x0.upButtonPressed();
    }

    static /* synthetic */ void access$700(ChoicePanel x0) {
        x0.downButtonPressed();
    }

    static /* synthetic */ String access$800() {
        return DEFAULT_COMBOBOX_TOOLTIP;
    }

    static /* synthetic */ void access$1000(ChoicePanel x0) {
        x0.defaultComboboxPressed();
    }

    static /* synthetic */ String access$1100(ChoicePanel x0) {
        return x0.EMPTY_STRING;
    }

    static /* synthetic */ TableRow access$1200(ChoicePanel x0, Object x1) {
        return x0.getRowForOption(x1);
    }

    static /* synthetic */ List access$1300(ChoicePanel x0) {
        return x0.getIncludedOptions();
    }

    static /* synthetic */ CLabel access$1402(ChoicePanel x0, CLabel x1) {
        x0.lblDefaultTitle = x1;
        return x0.lblDefaultTitle;
    }

    static /* synthetic */ CLabel access$1400(ChoicePanel x0) {
        return x0.lblDefaultTitle;
    }

    static /* synthetic */ ModelExplorerLabelProvider access$1500(ChoicePanel x0) {
        return x0.getAdHocLabelProvider();
    }
}

