/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.tools.genericimport.ui.wizards;

import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.tools.genericimport.ui.GenericImportUiPlugin;
import com.metamatrix.modeler.tools.genericimport.ui.PluginConstants;
import com.metamatrix.modeler.tools.genericimport.ui.UiConstants;
import com.metamatrix.modeler.tools.genericimport.ui.util.GenericImportUtil;
import com.metamatrix.modeler.tools.genericimport.ui.wizards.GenericImportManager;
import com.metamatrix.modeler.tools.genericimport.ui.wizards.GenericImportProcessor;
import com.metamatrix.modeler.tools.genericimport.ui.wizards.VDBDefinitionPage;
import com.metamatrix.ui.internal.wizard.AbstractWizard;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImportGenericWizard
extends AbstractWizard
implements PluginConstants.Images,
IImportWizard,
StringUtil.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$tools$genericimport$ui$wizards$ImportGenericWizard == null ? (class$com$metamatrix$modeler$tools$genericimport$ui$wizards$ImportGenericWizard = ImportGenericWizard.class$("com.metamatrix.modeler.tools.genericimport.ui.wizards.ImportGenericWizard")) : class$com$metamatrix$modeler$tools$genericimport$ui$wizards$ImportGenericWizard));
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String TITLE = ImportGenericWizard.getString("title");
    private static final ImageDescriptor IMAGE = GenericImportUiPlugin.getDefault().getImageDescriptor("icons/full/wizban/import_project.gif");
    private static final String NOT_LICENSED_MSG = ImportGenericWizard.getString("notLicensedMessage");
    private static boolean importLicensed = true;
    private GenericImportManager importManager;
    private MultiStatus importStatus;
    private VDBDefinitionPage vdbDefinitionPage;
    static /* synthetic */ Class class$com$metamatrix$modeler$tools$genericimport$ui$wizards$ImportGenericWizard;

    private static String getString(String id) {
        return UiConstants.Util.getString(I18N_PREFIX + id);
    }

    public ImportGenericWizard() {
        super((AbstractUIPlugin)GenericImportUiPlugin.getDefault(), TITLE, IMAGE);
    }

    private Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }

    public void createPageControls(Composite pageContainer) {
        if (importLicensed) {
            IDialogSettings settings = this.getDialogSettings();
            try {
                settings.getInt(WIDTH);
                settings.getInt(HEIGHT);
            }
            catch (NumberFormatException e) {
                settings.put(WIDTH, 500);
                settings.put(HEIGHT, 500);
            }
            super.createPageControls(pageContainer);
        }
    }

    public boolean finish() {
        int statusMask;
        String dialogMessage;
        String dialogTitle;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                ImportGenericWizard.this.generateModels(monitor);
            }
        };
        try {
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(this.getShell());
            dlg.run(false, false, op);
        }
        catch (InterruptedException ignored) {
            GenericImportUtil.addStatus((MultiStatus)this.importStatus, (int)8, (String)ImportGenericWizard.getString("errorDialog.importInterrupted.message"));
        }
        catch (Exception err) {
            GenericImportUtil.addStatus((MultiStatus)this.importStatus, (int)4, (String)ImportGenericWizard.getString("errorDialog.importError.message"), (Throwable)err);
        }
        if (this.importStatus.getSeverity() == 4) {
            dialogTitle = ImportGenericWizard.getString("errorDialog.hasErrors.title");
            dialogMessage = ImportGenericWizard.getString("errorDialog.hasErrors.message");
            statusMask = 4;
        } else if (this.importStatus.getSeverity() == 2) {
            dialogTitle = ImportGenericWizard.getString("errorDialog.completed.title");
            dialogMessage = ImportGenericWizard.getString("errorDialog.hasWarnings.message");
            statusMask = 2;
        } else {
            dialogTitle = ImportGenericWizard.getString("errorDialog.completed.title");
            dialogMessage = ImportGenericWizard.getString("errorDialog.completedOK.Message");
            statusMask = 1;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)dialogMessage, (IStatus)this.importStatus, (int)statusMask);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModels(IProgressMonitor monitor) {
        Connection sqlConnection = this.importManager.getSQLConnection();
        String selectedVDBModel = this.importManager.getSelectedVDBModel();
        IContainer targetLocation = this.importManager.getTargetLocation();
        this.importStatus = new MultiStatus("com.metamatrix.modeler.tools.genericimport.ui", 0, ImportGenericWizard.getString("generateModels.statusTitle"), null);
        GenericImportProcessor importProcessor = new GenericImportProcessor(sqlConnection, selectedVDBModel, targetLocation, this.importStatus);
        boolean requiredStart = false;
        boolean succeeded = false;
        try {
            requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Generic Import Processing", (Object)((Object)this));
            importProcessor.process(monitor);
            succeeded = true;
        }
        catch (Exception ex) {
            String message = "Error processing the import";
            UiConstants.Util.log(4, (Throwable)ex, message);
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (importLicensed) {
            this.importManager = new GenericImportManager();
            this.vdbDefinitionPage = new VDBDefinitionPage(this.importManager);
            this.addPage((IWizardPage)this.vdbDefinitionPage);
        } else {
            WizardPage page = new WizardPage(ClassUtil.getSimpleClassName((Class)(class$com$metamatrix$modeler$tools$genericimport$ui$wizards$ImportGenericWizard == null ? (class$com$metamatrix$modeler$tools$genericimport$ui$wizards$ImportGenericWizard = ImportGenericWizard.class$("com.metamatrix.modeler.tools.genericimport.ui.wizards.ImportGenericWizard")) : class$com$metamatrix$modeler$tools$genericimport$ui$wizards$ImportGenericWizard)), TITLE, null){

                public void createControl(Composite parent) {
                    this.setControl((Control)ImportGenericWizard.this.createEmptyPageControl(parent));
                }
            };
            page.setMessage(NOT_LICENSED_MSG, 3);
            page.setPageComplete(false);
            this.addPage((IWizardPage)page);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

