/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreSwitch;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Artifact;
import org.eclipse.uml2.Association;
import org.eclipse.uml2.BehavioredClassifier;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Comment;
import org.eclipse.uml2.Constraint;
import org.eclipse.uml2.DataType;
import org.eclipse.uml2.DirectedRelationship;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Enumeration;
import org.eclipse.uml2.EnumerationLiteral;
import org.eclipse.uml2.Generalization;
import org.eclipse.uml2.Implementation;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.LiteralInteger;
import org.eclipse.uml2.LiteralUnlimitedNatural;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.MultiplicityElement;
import org.eclipse.uml2.NamedElement;
import org.eclipse.uml2.Namespace;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.PackageMerge;
import org.eclipse.uml2.PackageableElement;
import org.eclipse.uml2.Parameter;
import org.eclipse.uml2.ParameterDirectionKind;
import org.eclipse.uml2.PrimitiveType;
import org.eclipse.uml2.Profile;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.Signal;
import org.eclipse.uml2.Stereotype;
import org.eclipse.uml2.StructuralFeature;
import org.eclipse.uml2.StructuredClassifier;
import org.eclipse.uml2.Type;
import org.eclipse.uml2.TypedElement;
import org.eclipse.uml2.UML2Factory;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.ValueSpecification;
import org.eclipse.uml2.VisibilityKind;
import org.eclipse.uml2.util.UML2Switch;
import org.eclipse.uml2.util.UML2Util;

public class UML2Util {
    protected static boolean DEBUG = false;
    public static final String EMPTY_STRING = "";
    protected static final String LINE_SEPARATOR = System.getProperties().getProperty("line.separator");
    public static final String OPTION__DISCARD = "DISCARD";
    public static final String OPTION__IGNORE = "IGNORE";
    public static final String OPTION__PROCESS = "PROCESS";
    public static final String OPTION__REPORT = "REPORT";
    protected static final String ANNOTATION_SOURCE__DUPLICATES = "duplicates";
    protected static final String ANNOTATION_SOURCE__REDEFINES = "redefines";
    protected static final String ANNOTATION_SOURCE__SUBSETS = "subsets";
    protected static final String ANNOTATION_SOURCE__UNION = "union";
    protected static final String ENUMERATION_LITERAL_NAME__ATTRIBUTE = "Attribute";
    protected static final String ENUMERATION_LITERAL_NAME__ATTRIBUTE_WILDCARD = "AttributeWilcard";
    protected static final String ENUMERATION_LITERAL_NAME__ELEMENT = "Element";
    protected static final String ENUMERATION_LITERAL_NAME__ELEMENT_ONLY = "ElementOnly";
    protected static final String ENUMERATION_LITERAL_NAME__ELEMENT_WILDCARD = "ElementWildcard";
    protected static final String ENUMERATION_LITERAL_NAME__EMPTY = "Empty";
    protected static final String ENUMERATION_LITERAL_NAME__GROUP = "Group";
    protected static final String ENUMERATION_LITERAL_NAME__MIXED = "Mixed";
    protected static final String ENUMERATION_LITERAL_NAME__NONE = "None";
    protected static final String ENUMERATION_LITERAL_NAME__SIMPLE = "Simple";
    protected static final String ENUMERATION_LITERAL_NAME__READ_ONLY = "ReadOnly";
    protected static final String ENUMERATION_LITERAL_NAME__READ_ONLY_UNSETTABLE = "ReadOnlyUnsettable";
    protected static final String ENUMERATION_LITERAL_NAME__READ_WRITE = "ReadWrite";
    protected static final String ENUMERATION_LITERAL_NAME__READ_WRITE_UNSETTABLE = "ReadWriteUnsettable";
    protected static final String ENUMERATION_LITERAL_NAME__UNSPECIFIED = "Unspecified";
    protected static final String ENUMERATION_NAME__CONTENT_KIND = "ContentKind";
    protected static final String ENUMERATION_NAME__FEATURE_KIND = "FeatureKind";
    protected static final String ENUMERATION_NAME__VISIBILITY_KIND = "VisibilityKind";
    protected static final String PROPERTY_NAME__ATTRIBUTE_NAME = "attributeName";
    public static final String PROPERTY_NAME__BASE_PACKAGE = "basePackage";
    protected static final String PROPERTY_NAME__CLASS_NAME = "className";
    protected static final String PROPERTY_NAME__DATA_TYPE_NAME = "dataTypeName";
    protected static final String PROPERTY_NAME__ENUM_NAME = "enumName";
    protected static final String PROPERTY_NAME__ENUM_LITERAL_NAME = "enumLiteralName";
    protected static final String PROPERTY_NAME__INSTANCE_CLASS_NAME = "instanceClassName";
    protected static final String PROPERTY_NAME__IS_ID = "isID";
    protected static final String PROPERTY_NAME__IS_RESOLVE_PROXIES = "isResolveProxies";
    protected static final String PROPERTY_NAME__IS_TRANSIENT = "isTransient";
    protected static final String PROPERTY_NAME__IS_UNSETTABLE = "isUnsettable";
    protected static final String PROPERTY_NAME__IS_VOLATILE = "isVolatile";
    protected static final String PROPERTY_NAME__NS_PREFIX = "nsPrefix";
    protected static final String PROPERTY_NAME__NS_URI = "nsURI";
    protected static final String PROPERTY_NAME__OPERATION_NAME = "operationName";
    protected static final String PROPERTY_NAME__PACKAGE_NAME = "packageName";
    protected static final String PROPERTY_NAME__PARAMETER_NAME = "parameterName";
    public static final String PROPERTY_NAME__PREFIX = "prefix";
    protected static final String PROPERTY_NAME__REFERENCE_NAME = "referenceName";
    protected static final String PROPERTY_NAME__VISIBILITY = "visibility";
    protected static final String PROPERTY_NAME__XML_CONTENT_KIND = "xmlContentKind";
    protected static final String PROPERTY_NAME__XML_FEATURE_KIND = "xmlFeatureKind";
    protected static final String PROPERTY_NAME__XML_NAME = "xmlName";
    protected static final String PROPERTY_NAME__XML_NAMESPACE = "xmlNamespace";
    protected static final String STEREOTYPE_NAME__E_ATTRIBUTE = "EAttribute";
    protected static final String STEREOTYPE_NAME__E_CLASS = "EClass";
    protected static final String STEREOTYPE_NAME__E_DATA_TYPE = "EDataType";
    protected static final String STEREOTYPE_NAME__E_ENUM = "EEnum";
    protected static final String STEREOTYPE_NAME__E_ENUM_LITERAL = "EEnumLiteral";
    protected static final String STEREOTYPE_NAME__E_OPERATION = "EOperation";
    public static final String STEREOTYPE_NAME__E_PACKAGE = "EPackage";
    protected static final String STEREOTYPE_NAME__E_PARAMETER = "EParameter";
    protected static final String STEREOTYPE_NAME__E_REFERENCE = "EReference";
    static /* synthetic */ java.lang.Class class$0;
    static /* synthetic */ java.lang.Class class$1;
    static /* synthetic */ java.lang.Class class$2;
    static /* synthetic */ java.lang.Class class$3;
    static /* synthetic */ java.lang.Class class$4;

    protected UML2Util() {
    }

    protected static boolean safeEquals(Object thisObject, Object thatObject) {
        return thisObject == null ? thatObject == null : thisObject.equals(thatObject);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static EObject findEObject(Collection eObjects, EObjectMatcher filter) {
        Iterator i = eObjects.iterator();
        while (i.hasNext()) {
            EObject eObject = (EObject)i.next();
            if (!filter.matches(eObject)) continue;
            return eObject;
        }
        return null;
    }

    protected static EClassifier getCommonEType(EClassifier eType, final EClassifier otherEType) {
        if (eType.equals(otherEType)) {
            return eType;
        }
        return (EClassifier)new EcoreSwitch(){

            public Object caseEClassifier(EClassifier eClassifier) {
                return EcorePackage.eINSTANCE.getEObject();
            }

            public Object caseEClass(EClass eClass) {
                if (otherEType instanceof EClass) {
                    EClass otherEClass = (EClass)otherEType;
                    if (eClass.isSuperTypeOf(otherEClass)) {
                        return eClass;
                    }
                    if (otherEClass.isSuperTypeOf(eClass)) {
                        return otherEClass;
                    }
                    Iterator eAllSuperTypes = eClass.getEAllSuperTypes().iterator();
                    while (eAllSuperTypes.hasNext()) {
                        EClass eSuperType = (EClass)eAllSuperTypes.next();
                        if (!eSuperType.isSuperTypeOf(otherEClass)) continue;
                        return eSuperType;
                    }
                    Iterator otherEAllSuperTypes = otherEClass.getEAllSuperTypes().iterator();
                    while (otherEAllSuperTypes.hasNext()) {
                        EClass otherESuperType = (EClass)otherEAllSuperTypes.next();
                        if (!otherESuperType.isSuperTypeOf(eClass)) continue;
                        return otherESuperType;
                    }
                }
                return super.caseEClass(eClass);
            }

            public Object caseEDataType(EDataType eDataType) {
                return otherEType instanceof EDataType && eDataType.getInstanceClass().equals(((EDataType)otherEType).getInstanceClass()) ? eDataType : EcorePackage.eINSTANCE.getEJavaObject();
            }

            public Object caseEEnum(EEnum eEnum) {
                return otherEType instanceof EEnum ? EcorePackage.eINSTANCE.getEEnumerator() : EcorePackage.eINSTANCE.getEJavaObject();
            }
        }.doSwitch((EObject)eType);
    }

    protected static int getLesserLowerBound(int lowerBound, int otherLowerBound) {
        return Math.min(lowerBound, otherLowerBound);
    }

    protected static int getGreaterUpperBound(int upperBound, int otherUpperBound) {
        return -1 == upperBound || -1 == otherUpperBound ? -1 : Math.max(upperBound, otherUpperBound);
    }

    protected static Property getTaggedValueDefinition(Stereotype stereotype, final String propertyName) {
        return (Property)UML2Util.findEObject(stereotype.allFeatures(), new EObjectMatcher(){

            public boolean matches(EObject eObject) {
                return eObject instanceof Property && UML2Util.safeEquals(((Property)eObject).getName(), propertyName);
            }
        });
    }

    protected static Object getTaggedValue(Element element, String qualifiedStereotypeName, String propertyName) {
        Stereotype stereotype = element.getAppliedStereotype(qualifiedStereotypeName);
        return stereotype == null ? null : element.getValue(stereotype, propertyName);
    }

    protected static void setTaggedValue(Element element, Stereotype stereotype, String propertyName, Object value) {
        if (!element.isApplied(stereotype)) {
            Profile profile = stereotype.getProfile();
            if (!element.getNearestPackage().getAllAppliedProfiles().contains(profile)) {
                element.getModel().apply(profile);
            }
            element.apply(stereotype);
        }
        element.setValue(stereotype, propertyName, value);
    }

    protected static String getValidIdentifier(String name) {
        return UML2Util.appendValidIdentifier(new StringBuffer(), name).toString();
    }

    protected static StringBuffer appendValidIdentifier(StringBuffer validIdentifier, String name) {
        if (UML2Util.isEmpty(name)) {
            validIdentifier.append('_');
        } else {
            char char_0 = name.charAt(0);
            if (Character.isJavaIdentifierStart(char_0)) {
                validIdentifier.append(char_0);
            } else {
                validIdentifier.append('_');
                if (Character.isJavaIdentifierPart(char_0)) {
                    validIdentifier.append(char_0);
                }
            }
            int i = 1;
            while (i < name.length()) {
                char char_i = name.charAt(i);
                if (Character.isJavaIdentifierPart(char_i)) {
                    validIdentifier.append(char_i);
                }
                ++i;
            }
        }
        return validIdentifier;
    }

    public static String getQualifiedText(EObject eObject) {
        return UML2Util.getQualifiedText(eObject, QualifiedTextProvider.DEFAULT);
    }

    public static String getQualifiedText(EObject eObject, QualifiedTextProvider qualifiedTextProvider) {
        return UML2Util.appendQualifiedText(new StringBuffer(), eObject, qualifiedTextProvider).toString();
    }

    protected static StringBuffer appendQualifiedText(StringBuffer qualifiedText, EObject eObject, QualifiedTextProvider qualifiedTextProvider) {
        EObject eContainer = eObject.eContainer();
        if (eContainer != null) {
            UML2Util.appendQualifiedText(qualifiedText, eContainer, qualifiedTextProvider);
            if (qualifiedText.length() > 0) {
                qualifiedText.append(qualifiedTextProvider.getSeparator());
            }
        }
        return UML2Util.appendQualifiedTextSegment(qualifiedText, eObject, qualifiedTextProvider);
    }

    protected static StringBuffer appendQualifiedTextSegment(StringBuffer qualifiedText, EObject eObject, QualifiedTextProvider qualifiedTextProvider) {
        String text = qualifiedTextProvider.getText(eObject);
        if (!UML2Util.isEmpty(text)) {
            return qualifiedText.append(text);
        }
        qualifiedText.append('{');
        EStructuralFeature eContainingFeature = eObject.eContainingFeature();
        if (eContainingFeature != null) {
            qualifiedText.append(qualifiedTextProvider.getFeatureText(eContainingFeature));
            if (eContainingFeature.isMany()) {
                qualifiedText.append(' ');
                List list = (List)eObject.eContainer().eGet(eContainingFeature, false);
                qualifiedText.append('[');
                qualifiedText.append(list.indexOf(eObject));
                qualifiedText.append(']');
            }
            qualifiedText.append(' ');
        }
        qualifiedText.append(qualifiedTextProvider.getClassText(eObject));
        qualifiedText.append('}');
        return qualifiedText;
    }

    public static Collection findNamedElements(ResourceSet resourceSet, String qualifiedName) {
        return UML2Util.findNamedElements(resourceSet, qualifiedName, false);
    }

    public static Collection findNamedElements(ResourceSet resourceSet, String qualifiedName, boolean ignoreCase) {
        UniqueEList namedElements = new UniqueEList();
        Iterator resources = resourceSet.getResources().iterator();
        while (resources.hasNext()) {
            UML2Util.findNamedElements((Collection)((Resource)resources.next()).getContents(), qualifiedName, ignoreCase, UML2Package.eINSTANCE.getNamedElement(), (Collection)namedElements);
        }
        return namedElements;
    }

    public static Collection findNamedElements(ResourceSet resourceSet, String qualifiedName, boolean ignoreCase, EClass eClass) {
        UniqueEList namedElements = new UniqueEList();
        if (UML2Package.eINSTANCE.getNamedElement().isSuperTypeOf(eClass)) {
            Iterator resources = resourceSet.getResources().iterator();
            while (resources.hasNext()) {
                UML2Util.findNamedElements((Collection)((Resource)resources.next()).getContents(), qualifiedName, ignoreCase, eClass, (Collection)namedElements);
            }
        }
        return namedElements;
    }

    public static Collection findNamedElements(Resource resource, String qualifiedName) {
        return UML2Util.findNamedElements(resource, qualifiedName, false);
    }

    public static Collection findNamedElements(Resource resource, String qualifiedName, boolean ignoreCase) {
        return UML2Util.findNamedElements((Collection)resource.getContents(), qualifiedName, ignoreCase, UML2Package.eINSTANCE.getNamedElement(), (Collection)new UniqueEList());
    }

    public static Collection findNamedElements(Resource resource, String qualifiedName, boolean ignoreCase, EClass eClass) {
        UniqueEList namedElements = new UniqueEList();
        if (UML2Package.eINSTANCE.getNamedElement().isSuperTypeOf(eClass)) {
            UML2Util.findNamedElements((Collection)resource.getContents(), qualifiedName, ignoreCase, eClass, (Collection)namedElements);
        }
        return namedElements;
    }

    protected static Collection findNamedElements(Collection eObjects, String qualifiedName, boolean ignoreCase, EClass eClass, Collection namedElements) {
        int index = qualifiedName.indexOf("::");
        if (-1 == index) {
            Iterator members = EcoreUtil.getObjectsByType((Collection)eObjects, (EClassifier)eClass).iterator();
            while (members.hasNext()) {
                NamedElement member = (NamedElement)members.next();
                if (!(ignoreCase ? member.getName().equalsIgnoreCase(qualifiedName) : member.getName().equals(qualifiedName))) continue;
                namedElements.add(member);
            }
        } else {
            String name = qualifiedName.substring(0, index);
            qualifiedName = qualifiedName.substring(index + "::".length());
            Iterator namespaces = EcoreUtil.getObjectsByType((Collection)eObjects, (EClassifier)UML2Package.eINSTANCE.getNamespace()).iterator();
            while (namespaces.hasNext()) {
                Namespace namespace = (Namespace)namespaces.next();
                if (!(ignoreCase ? namespace.getName().equalsIgnoreCase(name) : namespace.getName().equals(name))) continue;
                UML2Util.findNamedElements((Collection)namespace.getMembers(), qualifiedName, ignoreCase, eClass, namedElements);
            }
        }
        return namedElements;
    }

    public static int getInstanceCount(ResourceSet resourceSet, EClassifier eClassifier) {
        return UML2Util.getInstanceCount((Iterator)resourceSet.getAllContents(), eClassifier);
    }

    public static int getInstanceCount(Resource resource, EClassifier eClassifier) {
        return UML2Util.getInstanceCount((Iterator)resource.getAllContents(), eClassifier);
    }

    public static int getInstanceCount(EObject eObject, EClassifier eClassifier) {
        return UML2Util.getInstanceCount((Iterator)eObject.eAllContents(), eClassifier);
    }

    public static int getInstanceCount(Iterator iterator, EClassifier eClassifier) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!eClassifier.isInstance(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    protected static EAnnotation createEAnnotation(EModelElement eModelElement, String source) {
        java.lang.Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = java.lang.Class.forName("org.eclipse.uml2.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(eModelElement)) {
            return ((Element)eModelElement).createEAnnotation(source);
        }
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setSource(source);
        eAnnotation.setEModelElement(eModelElement);
        return eAnnotation;
    }

    protected static EAnnotation getEAnnotation(EModelElement eModelElement, String source, boolean createOnDemand) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(source);
        return eAnnotation == null && createOnDemand ? UML2Util.createEAnnotation(eModelElement, source) : eAnnotation;
    }

    protected static void addConstraint(EModelElement eModelElement, String constraint) {
        if (!UML2Util.isEmpty(constraint)) {
            ArrayList<String> constraints = new ArrayList<String>(EcoreUtil.getConstraints((EModelElement)eModelElement));
            constraints.add(constraint);
            EcoreUtil.setConstraints((EModelElement)eModelElement, constraints);
        }
    }

    protected static void addDocumentation(EModelElement eModelElement, String text) {
        if (!UML2Util.isEmpty(text)) {
            String documentation = EcoreUtil.getDocumentation((EModelElement)eModelElement);
            EcoreUtil.setDocumentation((EModelElement)eModelElement, (String)(documentation == null ? text : String.valueOf(documentation) + LINE_SEPARATOR + text));
        }
    }

    protected static String getMessageSubstitution(Map context, Object object) {
        java.lang.Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = java.lang.Class.forName("org.eclipse.emf.ecore.EObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(object)) {
            Resource resource;
            String qualifiedName;
            EObject eObject = (EObject)object;
            java.lang.Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = java.lang.Class.forName("org.eclipse.uml2.NamedElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.isInstance(object) && !UML2Util.isEmpty(qualifiedName = ((NamedElement)object).getQualifiedName())) {
                return qualifiedName;
            }
            if (context != null) {
                QualifiedTextProvider qualifiedTestProvider;
                EValidator.SubstitutionLabelProvider substitutionLabelProvider;
                java.lang.Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = java.lang.Class.forName("org.eclipse.emf.ecore.EValidator$SubstitutionLabelProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((substitutionLabelProvider = (EValidator.SubstitutionLabelProvider)context.get(clazz3)) != null) {
                    return substitutionLabelProvider.getObjectLabel(eObject);
                }
                java.lang.Class<?> clazz4 = class$4;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$4 = java.lang.Class.forName("org.eclipse.uml2.util.UML2Util$QualifiedTextProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((qualifiedTestProvider = (QualifiedTextProvider)context.get(clazz4)) != null) {
                    return UML2Util.getQualifiedText(eObject, qualifiedTestProvider);
                }
            }
            if ((resource = eObject.eResource()) != null) {
                return String.valueOf(resource.getURI().lastSegment()) + '#' + resource.getURIFragment(eObject);
            }
            return EcoreUtil.getIdentification((EObject)((EObject)object));
        }
        return String.valueOf(object);
    }

    protected static Object[] getMessageSubstitutions(Map context, Object object0) {
        return new Object[]{UML2Util.getMessageSubstitution(context, object0)};
    }

    protected static Object[] getMessageSubstitutions(Map context, Object object0, Object object1) {
        return new Object[]{UML2Util.getMessageSubstitution(context, object0), UML2Util.getMessageSubstitution(context, object1)};
    }

    protected static Object[] getMessageSubstitutions(Map context, Object object0, Object object1, Object object2) {
        return new Object[]{UML2Util.getMessageSubstitution(context, object0), UML2Util.getMessageSubstitution(context, object1), UML2Util.getMessageSubstitution(context, object2)};
    }

    protected static Collection getRootContainers(Collection eObjects) {
        HashSet<EObject> rootContainers = new HashSet<EObject>();
        Iterator i = eObjects.iterator();
        while (i.hasNext()) {
            rootContainers.add(EcoreUtil.getRootContainer((EObject)((EObject)i.next())));
        }
        return rootContainers;
    }

    protected static TreeIterator getAllContents(EObject eObject, boolean includeRoot, final boolean defensiveCopy) {
        return new AbstractTreeIterator(eObject, includeRoot){

            protected Iterator getChildren(Object object) {
                return defensiveCopy ? new ArrayList(((EObject)object).eContents()).iterator() : ((EObject)object).eContents().iterator();
            }
        };
    }

    public static Package load(ResourceSet resourceSet, URI uri) {
        Package package_ = null;
        try {
            package_ = (Package)EcoreUtil.getObjectByType((Collection)resourceSet.getResource(uri, true).getContents(), (EClassifier)UML2Package.eINSTANCE.getPackage());
        }
        catch (WrappedException wrappedException) {}
        return package_;
    }

    protected static List getOwnedAttributes(Type type) {
        return (List)new UML2Switch(){

            public Object caseArtifact(Artifact artifact) {
                return artifact.getOwnedAttributes();
            }

            public Object caseDataType(DataType dataType) {
                return dataType.getOwnedAttributes();
            }

            public Object caseInterface(Interface interface_) {
                return interface_.getOwnedAttributes();
            }

            public Object caseSignal(Signal signal) {
                return signal.getOwnedAttributes();
            }

            public Object caseStructuredClassifier(StructuredClassifier structuredClassifier) {
                return structuredClassifier.getOwnedAttributes();
            }

            public Object doSwitch(EObject eObject) {
                return eObject == null ? null : super.doSwitch(eObject);
            }
        }.doSwitch((EObject)type);
    }

    protected static List getOwnedOperations(Type type) {
        return (List)new UML2Switch(){

            public Object caseArtifact(Artifact artifact) {
                return artifact.getOwnedOperations();
            }

            public Object caseClass(Class class_) {
                return class_.getOwnedOperations();
            }

            public Object caseDataType(DataType dataType) {
                return dataType.getOwnedOperations();
            }

            public Object caseInterface(Interface interface_) {
                return interface_.getOwnedOperations();
            }

            public Object doSwitch(EObject eObject) {
                return eObject == null ? null : super.doSwitch(eObject);
            }
        }.doSwitch((EObject)type);
    }

    public static Collection convertFromEcore(EPackage ePackage, Map options) {
        if (options == null) {
            options = new HashMap();
        }
        return UML2Util.convertFromEcore(ePackage, options, null, null);
    }

    public static Collection convertFromEcore(EPackage ePackage, Map options, DiagnosticChain diagnostics, Map context) {
        if (options == null) {
            options = new HashMap();
        }
        return new Ecore2UML2Converter().convert(Collections.singleton(ePackage), options, diagnostics, context);
    }

    public static Collection convertToEcore(Package package_, Map options) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (!options.containsKey("REDEFINING_OPERATIONS")) {
            options.put("REDEFINING_OPERATIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("REDEFINING_PROPERTIES")) {
            options.put("REDEFINING_PROPERTIES", OPTION__IGNORE);
        }
        if (!options.containsKey("SUBSETTING_PROPERTIES")) {
            options.put("SUBSETTING_PROPERTIES", OPTION__IGNORE);
        }
        if (!options.containsKey("UNION_PROPERTIES")) {
            options.put("UNION_PROPERTIES", OPTION__IGNORE);
        }
        if (!options.containsKey("DERIVED_FEATURES")) {
            options.put("DERIVED_FEATURES", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_OPERATIONS")) {
            options.put("DUPLICATE_OPERATIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_OPERATION_INHERITANCE")) {
            options.put("DUPLICATE_OPERATION_INHERITANCE", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_FEATURES")) {
            options.put("DUPLICATE_FEATURES", OPTION__IGNORE);
        }
        if (!options.containsKey("DUPLICATE_FEATURE_INHERITANCE")) {
            options.put("DUPLICATE_FEATURE_INHERITANCE", OPTION__IGNORE);
        }
        return UML2Util.convertToEcore(package_, options, null, null);
    }

    public static Collection convertToEcore(Package package_, Map options, DiagnosticChain diagnostics, Map context) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (!options.containsKey("REDEFINING_OPERATIONS")) {
            options.put("REDEFINING_OPERATIONS", OPTION__REPORT);
        }
        if (!options.containsKey("REDEFINING_PROPERTIES")) {
            options.put("REDEFINING_PROPERTIES", OPTION__REPORT);
        }
        if (!options.containsKey("SUBSETTING_PROPERTIES")) {
            options.put("SUBSETTING_PROPERTIES", OPTION__REPORT);
        }
        if (!options.containsKey("UNION_PROPERTIES")) {
            options.put("UNION_PROPERTIES", OPTION__REPORT);
        }
        if (!options.containsKey("DERIVED_FEATURES")) {
            options.put("DERIVED_FEATURES", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_OPERATIONS")) {
            options.put("DUPLICATE_OPERATIONS", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_OPERATION_INHERITANCE")) {
            options.put("DUPLICATE_OPERATION_INHERITANCE", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_FEATURES")) {
            options.put("DUPLICATE_FEATURES", OPTION__REPORT);
        }
        if (!options.containsKey("DUPLICATE_FEATURE_INHERITANCE")) {
            options.put("DUPLICATE_FEATURE_INHERITANCE", OPTION__REPORT);
        }
        return new UML22EcoreConverter().convert(Collections.singleton(package_), options, diagnostics, context);
    }

    public static void merge(Package package_, Map options) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (!options.containsKey("DIFFERENT_PROPERTY_STATICITY")) {
            options.put("DIFFERENT_PROPERTY_STATICITY", OPTION__IGNORE);
        }
        if (!options.containsKey("DIFFERENT_PROPERTY_UNIQUENESS")) {
            options.put("DIFFERENT_PROPERTY_UNIQUENESS", OPTION__IGNORE);
        }
        if (!options.containsKey("REDUNDANT_GENERALIZATIONS")) {
            options.put("REDUNDANT_GENERALIZATIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("IMPLICIT_REDEFINITIONS")) {
            options.put("IMPLICIT_REDEFINITIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("INVALID_REDEFINITIONS")) {
            options.put("INVALID_REDEFINITIONS", OPTION__IGNORE);
        }
        if (!options.containsKey("INVALID_SUBSETS")) {
            options.put("INVALID_SUBSETS", OPTION__IGNORE);
        }
        if (!options.containsKey("EMPTY_UNIONS")) {
            options.put("EMPTY_UNIONS", OPTION__IGNORE);
        }
        UML2Util.merge(package_, options, null, null);
    }

    public static void merge(Package package_, Map options, DiagnosticChain diagnostics, Map context) {
        if (options == null) {
            options = new HashMap<String, String>();
        }
        if (!options.containsKey("DIFFERENT_PROPERTY_STATICITY")) {
            options.put("DIFFERENT_PROPERTY_STATICITY", OPTION__REPORT);
        }
        if (!options.containsKey("DIFFERENT_PROPERTY_UNIQUENESS")) {
            options.put("DIFFERENT_PROPERTY_UNIQUENESS", OPTION__REPORT);
        }
        if (!options.containsKey("REDUNDANT_GENERALIZATIONS")) {
            options.put("REDUNDANT_GENERALIZATIONS", OPTION__REPORT);
        }
        if (!options.containsKey("IMPLICIT_REDEFINITIONS")) {
            options.put("IMPLICIT_REDEFINITIONS", OPTION__REPORT);
        }
        if (!options.containsKey("INVALID_REDEFINITIONS")) {
            options.put("INVALID_REDEFINITIONS", OPTION__REPORT);
        }
        if (!options.containsKey("INVALID_SUBSETS")) {
            options.put("INVALID_SUBSETS", OPTION__REPORT);
        }
        if (!options.containsKey("EMPTY_UNIONS")) {
            options.put("EMPTY_UNIONS", OPTION__REPORT);
        }
        new PackageMerger().merge(package_, options, diagnostics, context);
    }

    public static class QualifiedTextProvider {
        public static final QualifiedTextProvider DEFAULT = new QualifiedTextProvider();

        public String getText(EObject eObject) {
            return eObject instanceof NamedElement ? ((NamedElement)eObject).getName() : (eObject instanceof ENamedElement ? ((ENamedElement)eObject).getName() : UML2Util.EMPTY_STRING);
        }

        public String getSeparator() {
            return "::";
        }

        public String getFeatureText(EStructuralFeature eStructuralFeature) {
            return eStructuralFeature.getName();
        }

        public String getClassText(EObject eObject) {
            return eObject.eClass().getName();
        }
    }

    public static interface Converter {
        public Collection convert(Collection var1, Map var2, DiagnosticChain var3, Map var4);
    }

    public static class Ecore2UML2Converter
    extends EcoreSwitch
    implements Converter {
        public static final String OPTION__ECORE_TAGGED_VALUES = "ECORE_TAGGED_VALUES";
        public static final String OPTION__REDEFINES_ANNOTATIONS = "REDEFINES_ANNOTATIONS";
        public static final String OPTION__SUBSETS_ANNOTATIONS = "SUBSETS_ANNOTATIONS";
        public static final String OPTION__UNION_ANNOTATIONS = "UNION_ANNOTATIONS";
        private static final int DIAGNOSTIC_CODE_OFFSET = 3000;
        public static final int ECORE_TAGGED_VALUE = 3001;
        public static final int REDEFINES_ANNOTATION = 3002;
        public static final int SUBSETS_ANNOTATION = 3003;
        public static final int UNION_ANNOTATION = 3004;
        protected final Map eModelElementToElementMap = new HashMap();
        protected Collection ePackages = null;

        protected Model getEcorePrimitiveTypesLibrary(EModelElement eModelElement) {
            ResourceSet resourceSet;
            Resource resource = eModelElement.eResource();
            if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
                return (Model)UML2Util.load(resourceSet, URI.createURI((String)"pathmap://UML2_LIBRARIES/EcorePrimitiveTypes.library.uml2"));
            }
            return null;
        }

        protected PrimitiveType getEcorePrimitiveType(EModelElement eModelElement, String name) {
            Model ecorePrimitiveTypesLibrary = this.getEcorePrimitiveTypesLibrary(eModelElement);
            return ecorePrimitiveTypesLibrary != null ? (PrimitiveType)ecorePrimitiveTypesLibrary.getOwnedType(name) : null;
        }

        protected Type getType(EModelElement eModelElement, EClassifier eType) {
            Type type = null;
            if (eType != null) {
                String name = eType.getName();
                if (!UML2Util.isEmpty(name) && eType instanceof EDataType) {
                    type = this.getEcorePrimitiveType(eModelElement, name);
                }
                if (type == null) {
                    type = (Type)this.doSwitch((EObject)eType);
                }
            }
            return type;
        }

        protected Type getType(ETypedElement eTypedElement) {
            return this.getType((EModelElement)eTypedElement, eTypedElement.getEType());
        }

        public Object caseEAttribute(EAttribute eAttribute) {
            int lowerBound;
            Property property = UML2Factory.eINSTANCE.createProperty();
            this.eModelElementToElementMap.put(eAttribute, property);
            Classifier classifier = (Classifier)this.doSwitch((EObject)eAttribute.getEContainingClass());
            UML2Util.getOwnedAttributes(classifier).add(property);
            property.setName(eAttribute.getName());
            property.setIsReadOnly(!eAttribute.isChangeable());
            property.setIsDerived(eAttribute.isDerived());
            property.setType(this.getType((ETypedElement)eAttribute));
            property.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            int upperBound = eAttribute.getUpperBound();
            if (upperBound != -2 && upperBound != property.getUpper()) {
                property.setUpperBound(upperBound);
            }
            if ((lowerBound = eAttribute.getLowerBound()) != property.getLower()) {
                property.setLowerBound(lowerBound);
            }
            this.defaultCase((EObject)eAttribute);
            return property;
        }

        public Object caseEClass(EClass eClass) {
            Classifier classifier = eClass.isInterface() ? UML2Factory.eINSTANCE.createInterface() : UML2Factory.eINSTANCE.createClass();
            this.eModelElementToElementMap.put(eClass, classifier);
            Package package_ = (Package)this.doSwitch((EObject)eClass.getEPackage());
            package_.getOwnedMembers().add((Object)classifier);
            classifier.setName(eClass.getName());
            if (!eClass.isInterface()) {
                ((Class)classifier).setIsAbstract(eClass.isAbstract());
            }
            Iterator eSuperTypes = eClass.getESuperTypes().iterator();
            while (eSuperTypes.hasNext()) {
                EClass eSuperType = (EClass)eSuperTypes.next();
                if (eSuperType.isInterface()) {
                    ((BehavioredClassifier)classifier).createImplementation((Interface)this.doSwitch((EObject)eSuperType));
                    continue;
                }
                classifier.createGeneralization((Classifier)this.doSwitch((EObject)eSuperType));
            }
            this.defaultCase((EObject)eClass);
            return classifier;
        }

        public Object caseEDataType(EDataType eDataType) {
            PrimitiveType primitiveType = UML2Factory.eINSTANCE.createPrimitiveType();
            this.eModelElementToElementMap.put(eDataType, primitiveType);
            Package package_ = (Package)this.doSwitch((EObject)eDataType.getEPackage());
            package_.getOwnedMembers().add((Object)primitiveType);
            primitiveType.setName(eDataType.getName());
            this.defaultCase((EObject)eDataType);
            return primitiveType;
        }

        public Object caseEEnum(EEnum eEnum) {
            Enumeration enumeration = UML2Factory.eINSTANCE.createEnumeration();
            this.eModelElementToElementMap.put(eEnum, enumeration);
            Package package_ = (Package)this.doSwitch((EObject)eEnum.getEPackage());
            package_.getOwnedMembers().add((Object)enumeration);
            enumeration.setName(eEnum.getName());
            this.defaultCase((EObject)eEnum);
            return enumeration;
        }

        public Object caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
            EnumerationLiteral enumerationLiteral = UML2Factory.eINSTANCE.createEnumerationLiteral();
            this.eModelElementToElementMap.put(eEnumLiteral, enumerationLiteral);
            Enumeration enumeration = (Enumeration)this.doSwitch((EObject)eEnumLiteral.getEEnum());
            enumeration.getOwnedLiterals().add((Object)enumerationLiteral);
            enumerationLiteral.setName(eEnumLiteral.getName());
            this.defaultCase((EObject)eEnumLiteral);
            return enumerationLiteral;
        }

        public Object caseEModelElement(EModelElement eModelElement) {
            return eModelElement;
        }

        public Object caseEOperation(EOperation eOperation) {
            Operation operation = UML2Factory.eINSTANCE.createOperation();
            this.eModelElementToElementMap.put(eOperation, operation);
            Classifier classifier = (Classifier)this.doSwitch((EObject)eOperation.getEContainingClass());
            UML2Util.getOwnedOperations(classifier).add(operation);
            operation.setName(eOperation.getName());
            if (eOperation.getEType() != null) {
                Parameter parameter = operation.createReturnResult();
                parameter.setDirection(ParameterDirectionKind.RETURN_LITERAL);
                parameter.setType(this.getType((ETypedElement)eOperation));
            }
            Iterator eExceptions = eOperation.getEExceptions().iterator();
            while (eExceptions.hasNext()) {
                operation.getRaisedExceptions().add((Object)this.getType((EModelElement)eOperation, (EClassifier)eExceptions.next()));
            }
            operation.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            this.defaultCase((EObject)eOperation);
            return operation;
        }

        public Object caseEPackage(EPackage ePackage) {
            EPackage eSuperPackage;
            Package package_ = ePackage.getESuperPackage() == null ? UML2Factory.eINSTANCE.createModel() : UML2Factory.eINSTANCE.createPackage();
            this.eModelElementToElementMap.put(ePackage, package_);
            if (!this.ePackages.contains(ePackage) && (eSuperPackage = ePackage.getESuperPackage()) != null) {
                ((Package)this.doSwitch((EObject)eSuperPackage)).getOwnedMembers().add((Object)package_);
            }
            package_.setName(ePackage.getName());
            this.defaultCase((EObject)ePackage);
            return package_;
        }

        public Object caseEParameter(EParameter eParameter) {
            Parameter parameter = UML2Factory.eINSTANCE.createParameter();
            this.eModelElementToElementMap.put(eParameter, parameter);
            Operation operation = (Operation)this.doSwitch((EObject)eParameter.getEOperation());
            operation.getOwnedParameters().add((Object)parameter);
            parameter.setName(eParameter.getName());
            parameter.setType(this.getType((ETypedElement)eParameter));
            this.defaultCase((EObject)eParameter);
            return parameter;
        }

        public Object caseEReference(EReference eReference) {
            int end1LowerBound;
            EReference end1 = eReference.isContainer() ? eReference.getEOpposite() : eReference;
            EReference end2 = end1.getEOpposite();
            Property end1Property = UML2Factory.eINSTANCE.createProperty();
            this.eModelElementToElementMap.put(end1, end1Property);
            EClass end1EContainingClass = end1.getEContainingClass();
            Classifier end1Classifier = (Classifier)this.doSwitch((EObject)end1EContainingClass);
            UML2Util.getOwnedAttributes(end1Classifier).add(end1Property);
            Package package_ = (Package)this.doSwitch((EObject)end1EContainingClass.getEPackage());
            Association association = (Association)package_.createOwnedMember(UML2Package.eINSTANCE.getAssociation());
            end1Property.setName(end1.getName());
            end1Property.setAggregation(end1.isContainment() ? AggregationKind.COMPOSITE_LITERAL : AggregationKind.NONE_LITERAL);
            end1Property.setAssociation(association);
            end1Property.setIsDerived(end1.isDerived());
            end1Property.setIsOrdered(end1.isOrdered());
            end1Property.setIsReadOnly(!end1.isChangeable());
            int end1UpperBound = end1.getUpperBound();
            if (end1UpperBound != -2 && end1UpperBound != end1Property.getUpper()) {
                end1Property.setUpperBound(end1UpperBound);
            }
            if ((end1LowerBound = end1.getLowerBound()) != end1Property.getLower()) {
                end1Property.setLowerBound(end1LowerBound);
            }
            end1Property.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            Classifier end2Classifier = null;
            if (end2 == null) {
                end2Classifier = (Classifier)this.doSwitch((EObject)end1.getEType());
                association.createOwnedEnd(UML2Package.eINSTANCE.getProperty()).setType(end1Classifier);
            } else {
                int end2LowerBound;
                Property end2Property = UML2Factory.eINSTANCE.createProperty();
                this.eModelElementToElementMap.put(end2, end2Property);
                end2Classifier = (Classifier)this.doSwitch((EObject)end1.getEType());
                UML2Util.getOwnedAttributes(end2Classifier).add(end2Property);
                end2Property.setName(end2.getName());
                end2Property.setAssociation(association);
                end2Property.setIsDerived(end2.isDerived());
                end2Property.setIsOrdered(end1.isOrdered());
                end2Property.setIsReadOnly(!end2.isChangeable());
                int end2UpperBound = end2.getUpperBound();
                if (end2UpperBound != -2 && end2UpperBound != end2Property.getUpper()) {
                    end2Property.setUpperBound(end2UpperBound);
                }
                if ((end2LowerBound = end2.getLowerBound()) != end2Property.getLower()) {
                    end2Property.setLowerBound(end2LowerBound);
                }
                end2Property.setType(end1Classifier);
                end2Property.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            }
            end1Property.setType(end2Classifier);
            this.defaultCase((EObject)eReference);
            return end1Property;
        }

        public Object defaultCase(EObject eObject) {
            Iterator eContents = eObject.eContents().iterator();
            while (eContents.hasNext()) {
                this.doSwitch((EObject)eContents.next());
            }
            return super.defaultCase(eObject);
        }

        public Object doSwitch(EObject eObject) {
            Object element = this.eModelElementToElementMap.get(eObject);
            return element == null ? super.doSwitch(eObject) : element;
        }

        protected Profile getEcoreProfile(EModelElement eModelElement) {
            ResourceSet resourceSet;
            Resource resource = eModelElement.eResource();
            if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
                return (Profile)UML2Util.load(resourceSet, URI.createURI((String)"pathmap://UML2_PROFILES/Ecore.profile.uml2"));
            }
            return null;
        }

        protected Stereotype getEcoreStereotype(EModelElement eModelElement, String name) {
            Profile ecoreProfile = this.getEcoreProfile(eModelElement);
            return ecoreProfile != null ? ecoreProfile.getOwnedStereotype(name) : null;
        }

        protected void processEcoreTaggedValue(Element element, Stereotype stereotype, String propertyName, EModelElement eModelElement, EStructuralFeature eStructuralFeature, Map options, DiagnosticChain diagnostics, Map context) {
            Object value = null;
            if (eStructuralFeature != null) {
                value = eModelElement.eGet(eStructuralFeature);
                if (UML2Util.safeEquals(eStructuralFeature.getDefaultValue(), value)) {
                    return;
                }
            } else if (UML2Util.PROPERTY_NAME__XML_CONTENT_KIND == propertyName) {
                Enumeration contentKindEnumeration = (Enumeration)this.getEcoreProfile(eModelElement).getOwnedType(UML2Util.ENUMERATION_NAME__CONTENT_KIND);
                if (contentKindEnumeration != null) {
                    switch (ExtendedMetaData.INSTANCE.getContentKind((EClass)eModelElement)) {
                        case 1: {
                            value = contentKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__EMPTY);
                            break;
                        }
                        case 2: {
                            value = contentKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__SIMPLE);
                            break;
                        }
                        case 3: {
                            value = contentKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__MIXED);
                            break;
                        }
                        case 4: {
                            value = contentKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__ELEMENT_ONLY);
                        }
                    }
                }
                if (value == null) {
                    return;
                }
            } else if (UML2Util.PROPERTY_NAME__XML_FEATURE_KIND == propertyName) {
                Enumeration featureKindEnumeration = (Enumeration)this.getEcoreProfile(eModelElement).getOwnedType(UML2Util.ENUMERATION_NAME__FEATURE_KIND);
                if (featureKindEnumeration != null) {
                    switch (ExtendedMetaData.INSTANCE.getFeatureKind((EStructuralFeature)eModelElement)) {
                        case 1: {
                            value = featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__SIMPLE);
                            break;
                        }
                        case 2: {
                            value = featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__ATTRIBUTE);
                            break;
                        }
                        case 3: {
                            value = featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__ATTRIBUTE_WILDCARD);
                            break;
                        }
                        case 4: {
                            value = featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__ELEMENT);
                            break;
                        }
                        case 5: {
                            value = featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__ELEMENT_WILDCARD);
                            break;
                        }
                        case 6: {
                            value = featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__GROUP);
                        }
                    }
                }
                if (value == null) {
                    return;
                }
            } else if (UML2Util.PROPERTY_NAME__XML_NAME == propertyName) {
                if (eModelElement instanceof EClassifier) {
                    value = ExtendedMetaData.INSTANCE.getName((EClassifier)eModelElement);
                } else if (eModelElement instanceof EStructuralFeature) {
                    value = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)eModelElement);
                }
                if (UML2Util.safeEquals(((ENamedElement)eModelElement).getName(), value)) {
                    return;
                }
            } else if (UML2Util.PROPERTY_NAME__XML_NAMESPACE == propertyName) {
                value = ExtendedMetaData.INSTANCE.getNamespace((EStructuralFeature)eModelElement);
                if (value == null) {
                    return;
                }
            } else if (UML2Util.PROPERTY_NAME__VISIBILITY == propertyName) {
                Enumeration visibilityKindEnumeration = (Enumeration)this.getEcoreProfile(eModelElement).getOwnedType(UML2Util.ENUMERATION_NAME__VISIBILITY_KIND);
                if (visibilityKindEnumeration != null) {
                    eStructuralFeature = (EStructuralFeature)eModelElement;
                    if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)0)) {
                        value = visibilityKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__NONE);
                    } else if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1)) {
                        value = EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2) ? visibilityKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__READ_ONLY) : visibilityKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__READ_ONLY_UNSETTABLE);
                    } else if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3)) {
                        value = visibilityKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__READ_WRITE);
                    }
                }
                if (value == null) {
                    return;
                }
            }
            if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__ECORE_TAGGED_VALUES))) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 3001, UML2Plugin.INSTANCE.getString("_UI_Ecore2UML2Converter_ProcessEcoreTaggedValue_diagnostic", UML2Util.getMessageSubstitutions(context, element, UML2Util.getTaggedValueDefinition(stereotype, propertyName), value)), new Object[]{element}));
                }
                UML2Util.setTaggedValue(element, stereotype, propertyName, value);
            } else if (UML2Util.OPTION__REPORT.equals(options.get(OPTION__ECORE_TAGGED_VALUES)) && diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 3001, UML2Plugin.INSTANCE.getString("_UI_Ecore2UML2Converter_ReportEcoreTaggedValue_diagnostic", UML2Util.getMessageSubstitutions(context, element, UML2Util.getTaggedValueDefinition(stereotype, propertyName), value)), new Object[]{element}));
            }
        }

        protected void processEcoreTaggedValues(Package package_, EPackage ePackage, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype ePackageStereotype = this.getEcoreStereotype((EModelElement)ePackage, UML2Util.STEREOTYPE_NAME__E_PACKAGE);
            if (ePackageStereotype != null) {
                this.processEcoreTaggedValue(package_, ePackageStereotype, UML2Util.PROPERTY_NAME__NS_PREFIX, (EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsPrefix(), options, diagnostics, context);
                this.processEcoreTaggedValue(package_, ePackageStereotype, UML2Util.PROPERTY_NAME__NS_URI, (EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsURI(), options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(Classifier classifier, EClassifier eClassifier, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eClassifierStereotype = (Stereotype)new UML2Switch(this, eClassifier, options, diagnostics, context){
                final /* synthetic */ Ecore2UML2Converter this$1;
                private final /* synthetic */ EClassifier val$eClassifier;
                private final /* synthetic */ Map val$options;
                private final /* synthetic */ DiagnosticChain val$diagnostics;
                private final /* synthetic */ Map val$context;
                {
                    this.this$1 = ecore2UML2Converter;
                    this.val$eClassifier = eClassifier;
                    this.val$options = map;
                    this.val$diagnostics = diagnosticChain;
                    this.val$context = map2;
                }

                public Object caseClass(Class class_) {
                    Stereotype eClassStereotype = this.this$1.getEcoreStereotype((EModelElement)this.val$eClassifier, "EClass");
                    if (eClassStereotype != null) {
                        this.this$1.processEcoreTaggedValue(class_, eClassStereotype, "xmlContentKind", (EModelElement)this.val$eClassifier, null, this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eClassStereotype;
                }

                public Object caseInterface(Interface interface_) {
                    Stereotype eClassStereotype = this.this$1.getEcoreStereotype((EModelElement)this.val$eClassifier, "EClass");
                    if (eClassStereotype != null) {
                        this.this$1.processEcoreTaggedValue(interface_, eClassStereotype, "xmlContentKind", (EModelElement)this.val$eClassifier, null, this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eClassStereotype;
                }
            }.doSwitch((EObject)classifier);
            if (eClassifierStereotype != null) {
                this.processEcoreTaggedValue(classifier, eClassifierStereotype, UML2Util.PROPERTY_NAME__XML_NAME, (EModelElement)eClassifier, null, options, diagnostics, context);
                this.processEcoreTaggedValue(classifier, eClassifierStereotype, UML2Util.PROPERTY_NAME__INSTANCE_CLASS_NAME, (EModelElement)eClassifier, (EStructuralFeature)EcorePackage.eINSTANCE.getEClassifier_InstanceClassName(), options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(Property property, EStructuralFeature eStructuralFeature, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eStructuralFeatureStereotype = (Stereotype)new EcoreSwitch(this, property, options, diagnostics, context){
                final /* synthetic */ Ecore2UML2Converter this$1;
                private final /* synthetic */ Property val$property;
                private final /* synthetic */ Map val$options;
                private final /* synthetic */ DiagnosticChain val$diagnostics;
                private final /* synthetic */ Map val$context;
                {
                    this.this$1 = ecore2UML2Converter;
                    this.val$property = property;
                    this.val$options = map;
                    this.val$diagnostics = diagnosticChain;
                    this.val$context = map2;
                }

                public Object caseEAttribute(EAttribute eAttribute) {
                    Stereotype eAttributeStereotype = this.this$1.getEcoreStereotype((EModelElement)eAttribute, "EAttribute");
                    if (eAttributeStereotype != null) {
                        this.this$1.processEcoreTaggedValue(this.val$property, eAttributeStereotype, "isID", (EModelElement)eAttribute, (EStructuralFeature)EcorePackage.eINSTANCE.getEAttribute_ID(), this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eAttributeStereotype;
                }

                public Object caseEReference(EReference eReference) {
                    Stereotype eReferenceStereotype = this.this$1.getEcoreStereotype((EModelElement)eReference, "EReference");
                    if (eReferenceStereotype != null) {
                        this.this$1.processEcoreTaggedValue(this.val$property, eReferenceStereotype, "isResolveProxies", (EModelElement)eReference, (EStructuralFeature)EcorePackage.eINSTANCE.getEReference_ResolveProxies(), this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eReferenceStereotype;
                }
            }.doSwitch((EObject)eStructuralFeature);
            if (eStructuralFeatureStereotype != null) {
                this.processEcoreTaggedValue(property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__IS_TRANSIENT, (EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Transient(), options, diagnostics, context);
                this.processEcoreTaggedValue(property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__IS_UNSETTABLE, (EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Unsettable(), options, diagnostics, context);
                this.processEcoreTaggedValue(property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__IS_VOLATILE, (EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Volatile(), options, diagnostics, context);
                this.processEcoreTaggedValue(property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__XML_FEATURE_KIND, (EModelElement)eStructuralFeature, null, options, diagnostics, context);
                this.processEcoreTaggedValue(property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__XML_NAME, (EModelElement)eStructuralFeature, null, options, diagnostics, context);
                this.processEcoreTaggedValue(property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__XML_NAMESPACE, (EModelElement)eStructuralFeature, null, options, diagnostics, context);
                this.processEcoreTaggedValue(property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__VISIBILITY, (EModelElement)eStructuralFeature, null, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.eModelElementToElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getKey();
                new EcoreSwitch(this, entry, options, diagnostics, context){
                    final /* synthetic */ Ecore2UML2Converter this$1;
                    private final /* synthetic */ Map.Entry val$entry;
                    private final /* synthetic */ Map val$options;
                    private final /* synthetic */ DiagnosticChain val$diagnostics;
                    private final /* synthetic */ Map val$context;
                    {
                        this.this$1 = ecore2UML2Converter;
                        this.val$entry = entry;
                        this.val$options = map;
                        this.val$diagnostics = diagnosticChain;
                        this.val$context = map2;
                    }

                    public Object caseEClassifier(EClassifier eClassifier) {
                        this.this$1.processEcoreTaggedValues((Classifier)this.val$entry.getValue(), eClassifier, this.val$options, this.val$diagnostics, this.val$context);
                        return eClassifier;
                    }

                    public Object caseEPackage(EPackage ePackage) {
                        this.this$1.processEcoreTaggedValues((Package)this.val$entry.getValue(), ePackage, this.val$options, this.val$diagnostics, this.val$context);
                        return ePackage;
                    }

                    public Object caseEStructuralFeature(EStructuralFeature eStructuralFeature) {
                        this.this$1.processEcoreTaggedValues((Property)this.val$entry.getValue(), eStructuralFeature, this.val$options, this.val$diagnostics, this.val$context);
                        return eStructuralFeature;
                    }
                }.doSwitch((EObject)eModelElement);
            }
        }

        protected void processRedefinesAnnotations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.eModelElementToElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                EAnnotation redefinesEAnnotation;
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getKey();
                if (!(eModelElement instanceof ETypedElement) || (redefinesEAnnotation = UML2Util.getEAnnotation(eModelElement, UML2Util.ANNOTATION_SOURCE__REDEFINES, false)) == null) continue;
                TypedElement typedElement = (TypedElement)entry.getValue();
                Iterator references = redefinesEAnnotation.getReferences().iterator();
                while (references.hasNext()) {
                    TypedElement redefinedTypedElement = (TypedElement)this.eModelElementToElementMap.get(references.next());
                    if (redefinedTypedElement == null) continue;
                    if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__REDEFINES_ANNOTATIONS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 3002, UML2Plugin.INSTANCE.getString("_UI_Ecore2UML2Converter_ProcessRedefinesAnnotation_diagnostic", UML2Util.getMessageSubstitutions(context, typedElement, redefinedTypedElement)), new Object[]{typedElement, redefinedTypedElement}));
                        }
                        if (typedElement instanceof Property) {
                            ((Property)typedElement).getRedefinedProperties().add((Object)redefinedTypedElement);
                        }
                        if (!(typedElement instanceof Operation)) continue;
                        ((Operation)typedElement).getRedefinedOperations().add((Object)redefinedTypedElement);
                        continue;
                    }
                    if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__REDEFINES_ANNOTATIONS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 3002, UML2Plugin.INSTANCE.getString("_UI_Ecore2UML2Converter_ReportRedefinesAnnotation_diagnostic", UML2Util.getMessageSubstitutions(context, typedElement, redefinedTypedElement)), new Object[]{typedElement, redefinedTypedElement}));
                }
            }
        }

        protected void processSubsetsAnnotations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.eModelElementToElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                EAnnotation subsetsEAnnotation;
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getKey();
                if (!(eModelElement instanceof EStructuralFeature) || (subsetsEAnnotation = UML2Util.getEAnnotation(eModelElement, UML2Util.ANNOTATION_SOURCE__SUBSETS, false)) == null) continue;
                Property property = (Property)entry.getValue();
                Iterator references = subsetsEAnnotation.getReferences().iterator();
                while (references.hasNext()) {
                    Property subsettedProperty = (Property)this.eModelElementToElementMap.get(references.next());
                    if (subsettedProperty == null) continue;
                    if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__SUBSETS_ANNOTATIONS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 3003, UML2Plugin.INSTANCE.getString("_UI_Ecore2UML2Converter_ProcessSubsetsAnnotation_diagnostic", UML2Util.getMessageSubstitutions(context, property, subsettedProperty)), new Object[]{property, subsettedProperty}));
                        }
                        property.getSubsettedProperties().add((Object)subsettedProperty);
                        continue;
                    }
                    if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__SUBSETS_ANNOTATIONS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 3003, UML2Plugin.INSTANCE.getString("_UI_Ecore2UML2Converter_ReportSubsetsAnnotation_diagnostic", UML2Util.getMessageSubstitutions(context, property, subsettedProperty)), new Object[]{property, subsettedProperty}));
                }
            }
        }

        protected void processUnionAnnotations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.eModelElementToElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                EAnnotation unionEAnnotation;
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getKey();
                if (!(eModelElement instanceof EStructuralFeature) || (unionEAnnotation = UML2Util.getEAnnotation(eModelElement, UML2Util.ANNOTATION_SOURCE__UNION, false)) == null) continue;
                Property property = (Property)entry.getValue();
                if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__UNION_ANNOTATIONS))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 3004, UML2Plugin.INSTANCE.getString("_UI_Ecore2UML2Converter_ProcessUnionAnnotation_diagnostic", UML2Util.getMessageSubstitutions(context, property)), new Object[]{property}));
                    }
                    property.setIsDerivedUnion(true);
                    continue;
                }
                if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__UNION_ANNOTATIONS)) || diagnostics == null) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 3004, UML2Plugin.INSTANCE.getString("_UI_Ecore2UML2Converter_ReportUnionAnnotation_diagnostic", UML2Util.getMessageSubstitutions(context, property)), new Object[]{property}));
            }
        }

        protected void processOptions(EPackage ePackage, Map options, DiagnosticChain diagnostics, Map context) {
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__ECORE_TAGGED_VALUES))) {
                this.processEcoreTaggedValues(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__REDEFINES_ANNOTATIONS))) {
                this.processRedefinesAnnotations(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__SUBSETS_ANNOTATIONS))) {
                this.processSubsetsAnnotations(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__UNION_ANNOTATIONS))) {
                this.processUnionAnnotations(options, diagnostics, context);
            }
        }

        public Collection convert(Collection eObjects, Map options, DiagnosticChain diagnostics, Map context) {
            this.ePackages = EcoreUtil.getObjectsByType((Collection)eObjects, (EClassifier)EcorePackage.eINSTANCE.getEPackage());
            Iterator i = this.ePackages.iterator();
            while (i.hasNext()) {
                EPackage ePackage = (EPackage)i.next();
                this.doSwitch((EObject)ePackage);
                if (options == null) continue;
                this.processOptions(ePackage, options, diagnostics, context);
            }
            return UML2Util.getRootContainers(EcoreUtil.getObjectsByType(this.eModelElementToElementMap.values(), (EClassifier)UML2Package.eINSTANCE.getPackage()));
        }
    }

    public static class UML22EcoreConverter
    extends UML2Switch
    implements Converter {
        public static final String OPTION__ECORE_TAGGED_VALUES = "ECORE_TAGGED_VALUES";
        public static final String OPTION__REDEFINING_OPERATIONS = "REDEFINING_OPERATIONS";
        public static final String OPTION__REDEFINING_PROPERTIES = "REDEFINING_PROPERTIES";
        public static final String OPTION__SUBSETTING_PROPERTIES = "SUBSETTING_PROPERTIES";
        public static final String OPTION__UNION_PROPERTIES = "UNION_PROPERTIES";
        public static final String OPTION__DERIVED_FEATURES = "DERIVED_FEATURES";
        public static final String OPTION__DUPLICATE_OPERATIONS = "DUPLICATE_OPERATIONS";
        public static final String OPTION__DUPLICATE_OPERATION_INHERITANCE = "DUPLICATE_OPERATION_INHERITANCE";
        public static final String OPTION__DUPLICATE_FEATURES = "DUPLICATE_FEATURES";
        public static final String OPTION__DUPLICATE_FEATURE_INHERITANCE = "DUPLICATE_FEATURE_INHERITANCE";
        private static final int DIAGNOSTIC_CODE_OFFSET = 2000;
        public static final int ECORE_TAGGED_VALUE = 2001;
        public static final int REDEFINING_OPERATION = 2002;
        public static final int REDEFINING_PROPERTY = 2003;
        public static final int SUBSETTING_PROPERTY = 2004;
        public static final int UNION_PROPERTY = 2005;
        public static final int DERIVED_FEATURE = 2006;
        public static final int DUPLICATE_OPERATION = 2007;
        public static final int DUPLICATE_OPERATION_INHERITANCE = 2008;
        public static final int DUPLICATE_FEATURE = 2009;
        public static final int DUPLICATE_FEATURE_INHERITANCE = 2010;
        protected final Map elementToEModelElementMap = new HashMap();
        protected Collection packages = null;
        static /* synthetic */ java.lang.Class class$0;
        static /* synthetic */ java.lang.Class class$1;
        static /* synthetic */ java.lang.Class class$2;

        protected void setName(ENamedElement eNamedElement, String name, boolean validate) {
            eNamedElement.setName(validate ? UML2Util.getValidIdentifier(name) : name);
        }

        protected void setName(ENamedElement eNamedElement, NamedElement namedElement) {
            this.setName(eNamedElement, namedElement.getName(), true);
        }

        protected EClassifier getEType(Type type) {
            Object eType = null;
            if (type != null) {
                String typeName = type.getName();
                if (!UML2Util.isEmpty(typeName) && type instanceof PrimitiveType) {
                    eType = "Boolean".equals(typeName) ? EcorePackage.eINSTANCE.getEBoolean() : ("Integer".equals(typeName) ? EcorePackage.eINSTANCE.getEInt() : ("String".equals(typeName) ? EcorePackage.eINSTANCE.getEString() : ("UnlimitedNatural".equals(typeName) ? EcorePackage.eINSTANCE.getEInt() : ("boolean".equals(typeName) ? EcorePackage.eINSTANCE.getEBoolean() : ("byte".equals(typeName) ? EcorePackage.eINSTANCE.getEByte() : ("char".equals(typeName) ? EcorePackage.eINSTANCE.getEChar() : ("double".equals(typeName) ? EcorePackage.eINSTANCE.getEDouble() : ("float".equals(typeName) ? EcorePackage.eINSTANCE.getEFloat() : ("int".equals(typeName) ? EcorePackage.eINSTANCE.getEInt() : ("long".equals(typeName) ? EcorePackage.eINSTANCE.getELong() : ("short".equals(typeName) ? EcorePackage.eINSTANCE.getEShort() : EcorePackage.eINSTANCE.getEClassifier(typeName))))))))))));
                }
                if (eType == null) {
                    eType = (EClassifier)this.doSwitch((EObject)type);
                }
            } else {
                eType = EcorePackage.eINSTANCE.getEObject();
            }
            return eType;
        }

        protected EClassifier getEType(TypedElement typedElement) {
            return this.getEType(typedElement.getType());
        }

        protected Stereotype getAppliedEcoreStereotype(Element element, String name) {
            return element.getAppliedStereotype("Ecore::" + name);
        }

        public Object caseClass(Class class_) {
            Package package_ = class_.getNearestPackage();
            if (package_ == null) {
                return super.caseClass(class_);
            }
            EClass eClass = EcoreFactory.eINSTANCE.createEClass();
            this.elementToEModelElementMap.put(class_, eClass);
            EPackage ePackage = (EPackage)this.doSwitch((EObject)package_);
            ePackage.getEClassifiers().add((Object)eClass);
            this.setName((ENamedElement)eClass, class_);
            eClass.setAbstract(class_.isAbstract());
            this.defaultCase((EObject)class_);
            return eClass;
        }

        public Object caseComment(Comment comment) {
            Iterator annotatedElements = comment.getAnnotatedElements().iterator();
            while (annotatedElements.hasNext()) {
                EModelElement eModelElement = (EModelElement)this.doSwitch((EObject)((Element)annotatedElements.next()));
                if (eModelElement == null) continue;
                UML2Util.addDocumentation(eModelElement, comment.getBody());
            }
            return super.caseComment(comment);
        }

        public Object caseConstraint(Constraint constraint) {
            String name = constraint.getName();
            String specification = constraint.getSpecification().stringValue();
            Iterator constrainedElements = constraint.getConstrainedElements().iterator();
            while (constrainedElements.hasNext()) {
                EModelElement eModelElement = (EModelElement)this.doSwitch((EObject)((Element)constrainedElements.next()));
                if (eModelElement == null) continue;
                if (DEBUG) {
                    System.out.println(String.valueOf(UML2Util.getQualifiedText((EObject)eModelElement)) + " is constrained as '" + specification + "'");
                }
                UML2Util.addConstraint(eModelElement, name);
                UML2Util.addDocumentation(eModelElement, specification);
            }
            return super.caseConstraint(constraint);
        }

        public Object caseEModelElement(EModelElement eModelElement) {
            return eModelElement;
        }

        public Object caseEnumeration(Enumeration enumeration) {
            Package package_ = enumeration.getNearestPackage();
            if (package_ == null) {
                return super.caseEnumeration(enumeration);
            }
            EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
            this.elementToEModelElementMap.put(enumeration, eEnum);
            EPackage ePackage = (EPackage)this.doSwitch((EObject)package_);
            ePackage.getEClassifiers().add((Object)eEnum);
            this.setName((ENamedElement)eEnum, enumeration);
            this.defaultCase((EObject)enumeration);
            return eEnum;
        }

        public Object caseEnumerationLiteral(EnumerationLiteral enumerationLiteral) {
            Enumeration enumeration = enumerationLiteral.getEnumeration();
            if (enumeration == null) {
                return super.caseEnumerationLiteral(enumerationLiteral);
            }
            EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
            this.elementToEModelElementMap.put(enumerationLiteral, eEnumLiteral);
            EEnum eEnum = (EEnum)this.doSwitch((EObject)enumeration);
            eEnum.getELiterals().add((Object)eEnumLiteral);
            this.setName((ENamedElement)eEnumLiteral, enumerationLiteral);
            eEnumLiteral.setValue(enumeration.getOwnedLiterals().indexOf((Object)enumerationLiteral));
            this.defaultCase((EObject)enumerationLiteral);
            return eEnumLiteral;
        }

        public Object caseGeneralization(Generalization generalization) {
            EClassifier specificEClassifier;
            Classifier specific = generalization.getSpecific();
            if (specific != null && (specificEClassifier = (EClassifier)this.doSwitch((EObject)specific)) instanceof EClass) {
                EClass generalEClass;
                EClassifier generalEClassifier;
                EClass specificEClass = (EClass)specificEClassifier;
                Classifier general = generalization.getGeneral();
                if (general != null && (generalEClassifier = (EClassifier)this.doSwitch((EObject)general)) instanceof EClass && !specificEClass.isSuperTypeOf(generalEClass = (EClass)generalEClassifier)) {
                    EList eSuperTypes = specificEClass.getESuperTypes();
                    eSuperTypes.add(generalization.hasKeyword("extend") ? 0 : eSuperTypes.size(), generalEClass);
                }
            }
            return super.caseGeneralization(generalization);
        }

        public Object caseImplementation(Implementation implementation) {
            EClassifier implementingEClassifier;
            BehavioredClassifier implementingClassifier = implementation.getImplementingClassifier();
            if (implementingClassifier != null && (implementingEClassifier = (EClassifier)this.doSwitch((EObject)implementingClassifier)) instanceof EClass) {
                EClass contractEClass;
                EClass implementingEClass = (EClass)implementingEClassifier;
                Interface contract = implementation.getContract();
                if (contract != null && (contractEClass = (EClass)this.doSwitch((EObject)contract)) != null) {
                    implementingEClass.getESuperTypes().add((Object)contractEClass);
                }
            }
            return super.caseImplementation(implementation);
        }

        public Object caseInterface(Interface interface_) {
            Package package_ = interface_.getNearestPackage();
            if (package_ == null) {
                return super.caseInterface(interface_);
            }
            EClass eClass = EcoreFactory.eINSTANCE.createEClass();
            this.elementToEModelElementMap.put(interface_, eClass);
            EPackage ePackage = (EPackage)this.doSwitch((EObject)package_);
            ePackage.getEClassifiers().add((Object)eClass);
            this.setName((ENamedElement)eClass, interface_);
            eClass.setAbstract(true);
            eClass.setInterface(true);
            this.defaultCase((EObject)interface_);
            return eClass;
        }

        public Object caseOperation(Operation operation) {
            Namespace namespace = operation.getNamespace();
            java.lang.Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = java.lang.Class.forName("org.eclipse.uml2.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(namespace)) {
                java.lang.Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = java.lang.Class.forName("org.eclipse.uml2.Interface");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.isInstance(namespace)) {
                    return super.caseOperation(operation);
                }
            }
            EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
            this.elementToEModelElementMap.put(operation, eOperation);
            EClass eClass = (EClass)this.doSwitch((EObject)namespace);
            eClass.getEOperations().add((Object)eOperation);
            this.setName((ENamedElement)eOperation, operation);
            Type type = operation.getType();
            if (type != null) {
                eOperation.setEType(this.getEType(type));
            }
            EList eExceptions = eOperation.getEExceptions();
            Iterator raisedExceptions = operation.getRaisedExceptions().iterator();
            while (raisedExceptions.hasNext()) {
                eExceptions.add((Object)this.getEType((Type)raisedExceptions.next()));
            }
            this.defaultCase((EObject)operation);
            return eOperation;
        }

        public Object casePackage(Package package_) {
            Package nestingPackage;
            EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
            this.elementToEModelElementMap.put(package_, ePackage);
            if (!this.packages.contains(package_) && (nestingPackage = package_.getNestingPackage()) != null) {
                ((EPackage)this.doSwitch((EObject)nestingPackage)).getESubpackages().add((Object)ePackage);
            }
            this.setName((ENamedElement)ePackage, package_);
            if (UML2Util.isEmpty(ePackage.getNsPrefix())) {
                EPackage eSuperPackage = ePackage.getESuperPackage();
                ePackage.setNsPrefix(String.valueOf(eSuperPackage == null ? UML2Util.EMPTY_STRING : String.valueOf(eSuperPackage.getNsPrefix()) + '.') + ePackage.getName());
            }
            if (UML2Util.isEmpty(ePackage.getNsURI())) {
                ePackage.setNsURI("http:///" + ePackage.getNsPrefix().replace('.', '/') + ".ecore");
            }
            this.defaultCase((EObject)package_);
            return ePackage;
        }

        public Object caseParameter(Parameter parameter) {
            Operation operation = parameter.getOperation();
            if (operation == null) {
                return super.caseParameter(parameter);
            }
            EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
            this.elementToEModelElementMap.put(parameter, eParameter);
            EOperation eOperation = (EOperation)this.doSwitch((EObject)operation);
            eOperation.getEParameters().add((Object)eParameter);
            this.setName((ENamedElement)eParameter, parameter);
            eParameter.setEType(this.getEType(parameter));
            this.defaultCase((EObject)parameter);
            return eParameter;
        }

        public Object casePrimitiveType(PrimitiveType primitiveType) {
            Package package_ = primitiveType.getNearestPackage();
            if (package_ == null) {
                return super.casePrimitiveType(primitiveType);
            }
            EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
            this.elementToEModelElementMap.put(primitiveType, eDataType);
            EPackage ePackage = (EPackage)this.doSwitch((EObject)package_);
            ePackage.getEClassifiers().add((Object)eDataType);
            this.setName((ENamedElement)eDataType, primitiveType);
            eDataType.setInstanceClassName(eDataType.getName());
            this.defaultCase((EObject)primitiveType);
            return eDataType;
        }

        public Object caseProperty(Property property) {
            int lower;
            int upper;
            Namespace namespace = property.getNamespace();
            java.lang.Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = java.lang.Class.forName("org.eclipse.uml2.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isInstance(namespace)) {
                java.lang.Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = java.lang.Class.forName("org.eclipse.uml2.Interface");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.isInstance(namespace)) {
                    return super.caseProperty(property);
                }
            }
            EAttribute eStructuralFeature = null;
            java.lang.Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = java.lang.Class.forName("org.eclipse.uml2.DataType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3.isInstance(property.getType())) {
                EAttribute eAttribute = eStructuralFeature = EcoreFactory.eINSTANCE.createEAttribute();
                this.elementToEModelElementMap.put(property, eAttribute);
                String default_ = property.getDefault();
                if (!UML2Util.isEmpty(default_)) {
                    EDataType eDataType = (EDataType)this.getEType(property);
                    try {
                        eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, default_);
                        eAttribute.setDefaultValueLiteral(default_);
                    }
                    catch (Exception exception) {}
                }
            } else {
                eStructuralFeature = EcoreFactory.eINSTANCE.createEReference();
                EReference eReference = eStructuralFeature;
                this.elementToEModelElementMap.put(property, eStructuralFeature);
                eReference.setContainment(property.isComposite());
            }
            EClass eClass = (EClass)this.doSwitch((EObject)namespace);
            eClass.getEStructuralFeatures().add((Object)eStructuralFeature);
            this.setName((ENamedElement)eStructuralFeature, property);
            eStructuralFeature.setChangeable(!property.isReadOnly());
            eStructuralFeature.setDerived(property.isDerived());
            if (property.getOpposite() != null) {
                EReference eOpposite = (EReference)this.doSwitch((EObject)property.getOpposite());
                if (property.isComposite() && !eOpposite.isTransient()) {
                    eOpposite.setTransient(true);
                    if (DEBUG) {
                        System.out.println("Made container " + UML2Util.getQualifiedText((EObject)eOpposite) + " transient");
                    }
                }
                if (property.isDerived() && !eOpposite.isDerived()) {
                    eOpposite.setDerived(true);
                    if (DEBUG) {
                        System.out.println("Made opposite " + UML2Util.getQualifiedText((EObject)eOpposite) + " derived");
                    }
                }
                ((EReference)eStructuralFeature).setEOpposite(eOpposite);
            }
            if ((upper = property.getUpper()) != eStructuralFeature.getUpperBound()) {
                eStructuralFeature.setUpperBound(upper);
            }
            if ((lower = property.getLower()) != eStructuralFeature.getLowerBound()) {
                eStructuralFeature.setLowerBound(lower);
            }
            eStructuralFeature.setUnique(property.isUnique());
            eStructuralFeature.setEType(this.getEType(property));
            this.defaultCase((EObject)property);
            return eStructuralFeature;
        }

        public Object defaultCase(EObject eObject) {
            Iterator eContents = eObject.eContents().iterator();
            while (eContents.hasNext()) {
                this.doSwitch((EObject)eContents.next());
            }
            return super.defaultCase(eObject);
        }

        public Object doSwitch(EObject eObject) {
            Object eModelElement = this.elementToEModelElementMap.get(eObject);
            return eModelElement == null ? super.doSwitch(eObject) : eModelElement;
        }

        protected void processEcoreTaggedValue(EModelElement eModelElement, EStructuralFeature eStructuralFeature, Element element, Stereotype stereotype, String propertyName, Map options, DiagnosticChain diagnostics, Map context) {
            if (element.hasValue(stereotype, propertyName)) {
                Object value = element.getValue(stereotype, propertyName);
                if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__ECORE_TAGGED_VALUES))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 2001, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ProcessEcoreTaggedValue_diagnostic", UML2Util.getMessageSubstitutions(context, eModelElement, UML2Util.getTaggedValueDefinition(stereotype, propertyName), value)), new Object[]{eModelElement}));
                    }
                    if (eStructuralFeature != null) {
                        eModelElement.eSet(eStructuralFeature, EcorePackage.eINSTANCE.getENamedElement_Name() == eStructuralFeature ? UML2Util.getValidIdentifier((String)value) : value);
                    } else if (UML2Util.PROPERTY_NAME__XML_CONTENT_KIND == propertyName) {
                        Enumeration contentKindEnumeration = ((EnumerationLiteral)value).getEnumeration();
                        if (contentKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__EMPTY) == value) {
                            ExtendedMetaData.INSTANCE.setContentKind((EClass)eModelElement, 1);
                        } else if (contentKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__SIMPLE) == value) {
                            ExtendedMetaData.INSTANCE.setContentKind((EClass)eModelElement, 2);
                        } else if (contentKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__MIXED) == value) {
                            ExtendedMetaData.INSTANCE.setContentKind((EClass)eModelElement, 3);
                        } else if (contentKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__ELEMENT_ONLY) == value) {
                            ExtendedMetaData.INSTANCE.setContentKind((EClass)eModelElement, 4);
                        }
                    } else if (UML2Util.PROPERTY_NAME__XML_FEATURE_KIND == propertyName) {
                        Enumeration featureKindEnumeration = ((EnumerationLiteral)value).getEnumeration();
                        if (featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__SIMPLE) == value) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 1);
                        } else if (featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__ATTRIBUTE) == value) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 2);
                        } else if (featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__ATTRIBUTE_WILDCARD) == value) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 3);
                        } else if (featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__ELEMENT) == value) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 4);
                        } else if (featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__ELEMENT_WILDCARD) == value) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 5);
                        } else if (featureKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__GROUP) == value) {
                            ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eModelElement, 6);
                        }
                    } else if (UML2Util.PROPERTY_NAME__XML_NAME == propertyName) {
                        if (eModelElement instanceof EClassifier) {
                            ExtendedMetaData.INSTANCE.setName((EClassifier)eModelElement, (String)value);
                        } else if (eModelElement instanceof EStructuralFeature) {
                            ExtendedMetaData.INSTANCE.setName((EStructuralFeature)eModelElement, (String)value);
                        }
                    } else if (UML2Util.PROPERTY_NAME__XML_NAMESPACE == propertyName) {
                        ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)eModelElement, (String)value);
                    } else if (UML2Util.PROPERTY_NAME__VISIBILITY == propertyName) {
                        eStructuralFeature = (EStructuralFeature)eModelElement;
                        boolean isChangeable = eStructuralFeature.isChangeable();
                        boolean isMany = eStructuralFeature.isMany();
                        boolean isUnsettable = eStructuralFeature.isUnsettable();
                        Enumeration visibilityKindEnumeration = ((EnumerationLiteral)value).getEnumeration();
                        if (visibilityKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__NONE) == value) {
                            EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)0, (boolean)true);
                            if (isChangeable && !isMany) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)true);
                            }
                            if (isUnsettable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)true);
                                if (isChangeable) {
                                    EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                                }
                            }
                        } else if (visibilityKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__READ_ONLY) == value) {
                            if (!isMany && isChangeable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)true);
                            }
                            if (isUnsettable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)true);
                                if (isChangeable) {
                                    EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                                }
                            }
                        } else if (visibilityKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__READ_WRITE) == value) {
                            if (isUnsettable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2, (boolean)true);
                                if (isChangeable) {
                                    EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                                }
                            }
                        } else if (visibilityKindEnumeration.getOwnedLiteral(UML2Util.ENUMERATION_LITERAL_NAME__READ_ONLY_UNSETTABLE) == value) {
                            if (!isMany && isChangeable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1, (boolean)true);
                            }
                            if (isUnsettable && isChangeable) {
                                EcoreUtil.setSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3, (boolean)true);
                            }
                        }
                    }
                } else if (UML2Util.OPTION__REPORT.equals(options.get(OPTION__ECORE_TAGGED_VALUES)) && diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2001, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ReportEcoreTaggedValue_diagnostic", UML2Util.getMessageSubstitutions(context, eModelElement, UML2Util.getTaggedValueDefinition(stereotype, propertyName), value)), new Object[]{eModelElement}));
                }
            }
        }

        protected void processEcoreTaggedValues(EClassifier eClassifier, Classifier classifier, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eClassifierStereotype = (Stereotype)new EcoreSwitch(this, classifier, options, diagnostics, context){
                final /* synthetic */ UML22EcoreConverter this$1;
                private final /* synthetic */ Classifier val$classifier;
                private final /* synthetic */ Map val$options;
                private final /* synthetic */ DiagnosticChain val$diagnostics;
                private final /* synthetic */ Map val$context;
                {
                    this.this$1 = uML22EcoreConverter;
                    this.val$classifier = classifier;
                    this.val$options = map;
                    this.val$diagnostics = diagnosticChain;
                    this.val$context = map2;
                }

                public Object caseEClass(EClass eClass) {
                    Stereotype eClassStereotype = this.this$1.getAppliedEcoreStereotype(this.val$classifier, "EClass");
                    if (eClassStereotype != null) {
                        this.this$1.processEcoreTaggedValue((EModelElement)eClass, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), this.val$classifier, eClassStereotype, "className", this.val$options, this.val$diagnostics, this.val$context);
                        this.this$1.processEcoreTaggedValue((EModelElement)eClass, null, this.val$classifier, eClassStereotype, "xmlContentKind", this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eClassStereotype;
                }

                public Object caseEDataType(EDataType eDataType) {
                    Stereotype eDataTypeStereotype = this.this$1.getAppliedEcoreStereotype(this.val$classifier, "EDataType");
                    if (eDataTypeStereotype != null) {
                        this.this$1.processEcoreTaggedValue((EModelElement)eDataType, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), this.val$classifier, eDataTypeStereotype, "dataTypeName", this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eDataTypeStereotype;
                }
            }.doSwitch((EObject)eClassifier);
            if (eClassifierStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eClassifier, null, classifier, eClassifierStereotype, UML2Util.PROPERTY_NAME__XML_NAME, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eClassifier, (EStructuralFeature)EcorePackage.eINSTANCE.getEClassifier_InstanceClassName(), classifier, eClassifierStereotype, UML2Util.PROPERTY_NAME__INSTANCE_CLASS_NAME, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EEnum eEnum, Enumeration enumeration, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eEnumStereotype = this.getAppliedEcoreStereotype(enumeration, UML2Util.STEREOTYPE_NAME__E_ENUM);
            if (eEnumStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eEnum, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), enumeration, eEnumStereotype, UML2Util.PROPERTY_NAME__ENUM_NAME, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eEnum, null, enumeration, eEnumStereotype, UML2Util.PROPERTY_NAME__XML_NAME, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EEnumLiteral eEnumLiteral, EnumerationLiteral enumerationLiteral, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eEnumLiteralStereotype = this.getAppliedEcoreStereotype(enumerationLiteral, UML2Util.STEREOTYPE_NAME__E_ENUM_LITERAL);
            if (eEnumLiteralStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eEnumLiteral, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), enumerationLiteral, eEnumLiteralStereotype, UML2Util.PROPERTY_NAME__ENUM_LITERAL_NAME, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EOperation eOperation, Operation operation, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eOperationStereotype = this.getAppliedEcoreStereotype(operation, UML2Util.STEREOTYPE_NAME__E_OPERATION);
            if (eOperationStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eOperation, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), operation, eOperationStereotype, UML2Util.PROPERTY_NAME__OPERATION_NAME, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EPackage ePackage, Package package_, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype ePackageStereotype = this.getAppliedEcoreStereotype(package_, UML2Util.STEREOTYPE_NAME__E_PACKAGE);
            if (ePackageStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), package_, ePackageStereotype, UML2Util.PROPERTY_NAME__PACKAGE_NAME, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsPrefix(), package_, ePackageStereotype, UML2Util.PROPERTY_NAME__NS_PREFIX, options, diagnostics, context);
                if (UML2Util.isEmpty(ePackage.getNsPrefix())) {
                    this.processEcoreTaggedValue((EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsPrefix(), package_, ePackageStereotype, UML2Util.PROPERTY_NAME__BASE_PACKAGE, options, diagnostics, context);
                    String nsPrefix = ePackage.getNsPrefix();
                    if (!UML2Util.isEmpty(nsPrefix)) {
                        ePackage.setNsPrefix(String.valueOf(nsPrefix) + '.' + ePackage.getName());
                    }
                }
                this.processEcoreTaggedValue((EModelElement)ePackage, (EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_NsURI(), package_, ePackageStereotype, UML2Util.PROPERTY_NAME__NS_URI, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EParameter eParameter, Parameter parameter, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eParameterStereotype = this.getAppliedEcoreStereotype(parameter, UML2Util.STEREOTYPE_NAME__E_PARAMETER);
            if (eParameterStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eParameter, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), parameter, eParameterStereotype, UML2Util.PROPERTY_NAME__PARAMETER_NAME, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(EStructuralFeature eStructuralFeature, Property property, Map options, DiagnosticChain diagnostics, Map context) {
            Stereotype eStructuralFeatureStereotype = (Stereotype)new EcoreSwitch(this, property, options, diagnostics, context){
                final /* synthetic */ UML22EcoreConverter this$1;
                private final /* synthetic */ Property val$property;
                private final /* synthetic */ Map val$options;
                private final /* synthetic */ DiagnosticChain val$diagnostics;
                private final /* synthetic */ Map val$context;
                {
                    this.this$1 = uML22EcoreConverter;
                    this.val$property = property;
                    this.val$options = map;
                    this.val$diagnostics = diagnosticChain;
                    this.val$context = map2;
                }

                public Object caseEAttribute(EAttribute eAttribute) {
                    Stereotype eAttributeStereotype = this.this$1.getAppliedEcoreStereotype(this.val$property, "EAttribute");
                    if (eAttributeStereotype != null) {
                        this.this$1.processEcoreTaggedValue((EModelElement)eAttribute, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), this.val$property, eAttributeStereotype, "attributeName", this.val$options, this.val$diagnostics, this.val$context);
                        this.this$1.processEcoreTaggedValue((EModelElement)eAttribute, (EStructuralFeature)EcorePackage.eINSTANCE.getEAttribute_ID(), this.val$property, eAttributeStereotype, "isID", this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eAttributeStereotype;
                }

                public Object caseEReference(EReference eReference) {
                    Stereotype eReferenceStereotype = this.this$1.getAppliedEcoreStereotype(this.val$property, "EReference");
                    if (eReferenceStereotype != null) {
                        this.this$1.processEcoreTaggedValue((EModelElement)eReference, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name(), this.val$property, eReferenceStereotype, "referenceName", this.val$options, this.val$diagnostics, this.val$context);
                        this.this$1.processEcoreTaggedValue((EModelElement)eReference, (EStructuralFeature)EcorePackage.eINSTANCE.getEReference_ResolveProxies(), this.val$property, eReferenceStereotype, "isResolveProxies", this.val$options, this.val$diagnostics, this.val$context);
                    }
                    return eReferenceStereotype;
                }
            }.doSwitch((EObject)eStructuralFeature);
            if (eStructuralFeatureStereotype != null) {
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Transient(), property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__IS_TRANSIENT, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Unsettable(), property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__IS_UNSETTABLE, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, (EStructuralFeature)EcorePackage.eINSTANCE.getEStructuralFeature_Volatile(), property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__IS_VOLATILE, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, null, property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__XML_NAME, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, null, property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__XML_NAMESPACE, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, null, property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__XML_FEATURE_KIND, options, diagnostics, context);
                this.processEcoreTaggedValue((EModelElement)eStructuralFeature, null, property, eStructuralFeatureStereotype, UML2Util.PROPERTY_NAME__VISIBILITY, options, diagnostics, context);
            }
        }

        protected void processEcoreTaggedValues(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                new EcoreSwitch(this, entry, options, diagnostics, context){
                    final /* synthetic */ UML22EcoreConverter this$1;
                    private final /* synthetic */ Map.Entry val$entry;
                    private final /* synthetic */ Map val$options;
                    private final /* synthetic */ DiagnosticChain val$diagnostics;
                    private final /* synthetic */ Map val$context;
                    {
                        this.this$1 = uML22EcoreConverter;
                        this.val$entry = entry;
                        this.val$options = map;
                        this.val$diagnostics = diagnosticChain;
                        this.val$context = map2;
                    }

                    public Object caseEClassifier(EClassifier eClassifier) {
                        this.this$1.processEcoreTaggedValues(eClassifier, (Classifier)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eClassifier;
                    }

                    public Object caseEEnum(EEnum eEnum) {
                        this.this$1.processEcoreTaggedValues(eEnum, (Enumeration)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eEnum;
                    }

                    public Object caseEEnumLiteral(EEnumLiteral eEnumLiteral) {
                        this.this$1.processEcoreTaggedValues(eEnumLiteral, (EnumerationLiteral)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eEnumLiteral;
                    }

                    public Object caseEOperation(EOperation eOperation) {
                        this.this$1.processEcoreTaggedValues(eOperation, (Operation)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eOperation;
                    }

                    public Object caseEPackage(EPackage ePackage) {
                        this.this$1.processEcoreTaggedValues(ePackage, (Package)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return ePackage;
                    }

                    public Object caseEParameter(EParameter eParameter) {
                        this.this$1.processEcoreTaggedValues(eParameter, (Parameter)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eParameter;
                    }

                    public Object caseEStructuralFeature(EStructuralFeature eStructuralFeature) {
                        this.this$1.processEcoreTaggedValues(eStructuralFeature, (Property)this.val$entry.getKey(), this.val$options, this.val$diagnostics, this.val$context);
                        return eStructuralFeature;
                    }
                }.doSwitch((EObject)eModelElement);
            }
        }

        protected void processRedefiningOperations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                if (!(eModelElement instanceof EOperation)) continue;
                Operation operation = (Operation)entry.getKey();
                Iterator redefinedOperations = operation.getRedefinedOperations().iterator();
                while (redefinedOperations.hasNext()) {
                    Operation redefinedOperation = (Operation)redefinedOperations.next();
                    EOperation eOperation = (EOperation)this.elementToEModelElementMap.get(redefinedOperation);
                    if (DEBUG) {
                        System.out.println(String.valueOf(UML2Util.getQualifiedText((EObject)eModelElement)) + " redefines " + UML2Util.getQualifiedText((EObject)eOperation));
                    }
                    if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__REDEFINING_OPERATIONS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 2002, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ProcessRedefiningOperation_diagnostic", UML2Util.getMessageSubstitutions(context, eModelElement, eOperation)), new Object[]{eModelElement, eOperation}));
                        }
                        UML2Util.getEAnnotation(eModelElement, UML2Util.ANNOTATION_SOURCE__REDEFINES, true).getReferences().add((Object)eOperation);
                        continue;
                    }
                    if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__REDEFINING_OPERATIONS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2002, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ReportRedefiningOperation_diagnostic", UML2Util.getMessageSubstitutions(context, eModelElement, eOperation)), new Object[]{eModelElement, eOperation}));
                }
            }
        }

        protected void processRedefiningProperties(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                if (!(eModelElement instanceof EStructuralFeature)) continue;
                Property property = (Property)entry.getKey();
                Iterator redefinedProperties = property.getRedefinedProperties().iterator();
                while (redefinedProperties.hasNext()) {
                    Property redefinedProperty = (Property)redefinedProperties.next();
                    if (redefinedProperty.getAssociation() != null && !redefinedProperty.isNavigable()) continue;
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)this.elementToEModelElementMap.get(redefinedProperty);
                    if (DEBUG) {
                        System.out.println(String.valueOf(UML2Util.getQualifiedText((EObject)eModelElement)) + " redefines " + UML2Util.getQualifiedText((EObject)eStructuralFeature));
                    }
                    if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__REDEFINING_PROPERTIES))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 2003, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ProcessRedefiningProperty_diagnostic", UML2Util.getMessageSubstitutions(context, eModelElement, eStructuralFeature)), new Object[]{eModelElement, eStructuralFeature}));
                        }
                        UML2Util.getEAnnotation(eModelElement, UML2Util.ANNOTATION_SOURCE__REDEFINES, true).getReferences().add((Object)eStructuralFeature);
                        continue;
                    }
                    if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__REDEFINING_PROPERTIES)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2003, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ReportRedefiningProperty_diagnostic", UML2Util.getMessageSubstitutions(context, eModelElement, eStructuralFeature)), new Object[]{eModelElement, eStructuralFeature}));
                }
            }
        }

        protected void processSubsettingProperties(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                if (!(eModelElement instanceof EStructuralFeature)) continue;
                Property property = (Property)entry.getKey();
                Iterator subsettedProperties = property.getSubsettedProperties().iterator();
                while (subsettedProperties.hasNext()) {
                    Property subsettedProperty = (Property)subsettedProperties.next();
                    if (subsettedProperty.getAssociation() != null && !subsettedProperty.isNavigable()) continue;
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)this.elementToEModelElementMap.get(subsettedProperty);
                    if (DEBUG) {
                        System.out.println(String.valueOf(UML2Util.getQualifiedText((EObject)eModelElement)) + " subsets " + UML2Util.getQualifiedText((EObject)eStructuralFeature));
                    }
                    if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__SUBSETTING_PROPERTIES))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 2004, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ProcessSubsettingProperty_diagnostic", UML2Util.getMessageSubstitutions(context, eModelElement, eStructuralFeature)), new Object[]{eModelElement, eStructuralFeature}));
                        }
                        UML2Util.getEAnnotation(eModelElement, UML2Util.ANNOTATION_SOURCE__SUBSETS, true).getReferences().add(this.elementToEModelElementMap.get(subsettedProperty));
                        continue;
                    }
                    if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__SUBSETTING_PROPERTIES)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2004, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ReportSubsettingProperty_diagnostic", UML2Util.getMessageSubstitutions(context, eModelElement, eStructuralFeature)), new Object[]{eModelElement, eStructuralFeature}));
                }
            }
        }

        protected void processUnionProperties(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.elementToEModelElementMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                EModelElement eModelElement = (EModelElement)entry.getValue();
                if (!(eModelElement instanceof EStructuralFeature) || !((Property)entry.getKey()).isDerivedUnion()) continue;
                if (DEBUG) {
                    System.out.println(String.valueOf(UML2Util.getQualifiedText((EObject)eModelElement)) + " is a union");
                }
                if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__UNION_PROPERTIES))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 2005, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ProcessUnionProperty_diagnostic", UML2Util.getMessageSubstitutions(context, eModelElement)), new Object[]{eModelElement}));
                    }
                    UML2Util.getEAnnotation(eModelElement, UML2Util.ANNOTATION_SOURCE__UNION, true);
                    ((EStructuralFeature)eModelElement).setChangeable(false);
                    continue;
                }
                if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__UNION_PROPERTIES)) || diagnostics == null) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2005, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ReportUnionProperty_diagnostic", UML2Util.getMessageSubstitutions(context, eModelElement)), new Object[]{eModelElement}));
            }
        }

        protected void processDerivedFeatures(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator eModelElements = this.elementToEModelElementMap.values().iterator();
            while (eModelElements.hasNext()) {
                EStructuralFeature eStructuralFeature;
                EModelElement eModelElement = (EModelElement)eModelElements.next();
                if (!(eModelElement instanceof EStructuralFeature) || !(eStructuralFeature = (EStructuralFeature)eModelElement).isDerived() || (!(eStructuralFeature instanceof EReference) || !((EReference)eStructuralFeature).isContainment()) && eStructuralFeature.isTransient() && eStructuralFeature.isVolatile()) continue;
                if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__DERIVED_FEATURES))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 2006, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ProcessDerivedFeature_diagnostic", UML2Util.getMessageSubstitutions(context, eStructuralFeature)), new Object[]{eStructuralFeature}));
                    }
                    if (eStructuralFeature instanceof EReference) {
                        ((EReference)eStructuralFeature).setContainment(false);
                    }
                    eStructuralFeature.setTransient(true);
                    eStructuralFeature.setVolatile(true);
                    continue;
                }
                if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__DERIVED_FEATURES)) || diagnostics == null) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2006, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ReportDerivedFeature_diagnostic", UML2Util.getMessageSubstitutions(context, eStructuralFeature)), new Object[]{eStructuralFeature}));
            }
        }

        protected void ensureConformity(ETypedElement eTypedElement, ETypedElement otherETypedElement) {
            boolean otherIsMany;
            boolean isMany;
            if (eTypedElement.isRequired() != otherETypedElement.isRequired()) {
                int lowerBound = eTypedElement.getLowerBound();
                int otherLowerBound = otherETypedElement.getLowerBound();
                int lesserLowerBound = UML2Util.getLesserLowerBound(otherLowerBound, lowerBound);
                if (lesserLowerBound != otherLowerBound) {
                    if (DEBUG) {
                        System.err.println("Changed lower bound of " + UML2Util.getQualifiedText((EObject)otherETypedElement) + " from " + otherLowerBound + " to " + lesserLowerBound);
                    }
                    otherETypedElement.setLowerBound(lesserLowerBound);
                }
                if (lesserLowerBound != lowerBound) {
                    if (DEBUG) {
                        System.out.println("Changed lower bound of " + UML2Util.getQualifiedText((EObject)eTypedElement) + " from " + lowerBound + " to " + lesserLowerBound);
                    }
                    eTypedElement.setLowerBound(lesserLowerBound);
                }
            }
            if ((isMany = eTypedElement.isMany()) != (otherIsMany = otherETypedElement.isMany())) {
                int upperBound = eTypedElement.getUpperBound();
                int otherUpperBound = otherETypedElement.getUpperBound();
                int greaterUpperBound = UML2Util.getGreaterUpperBound(otherUpperBound, upperBound);
                if (greaterUpperBound != otherUpperBound) {
                    if (DEBUG) {
                        System.err.println("Changed upper bound of " + UML2Util.getQualifiedText((EObject)otherETypedElement) + " from " + otherUpperBound + " to " + greaterUpperBound);
                    }
                    otherETypedElement.setUpperBound(greaterUpperBound);
                }
                if (greaterUpperBound != upperBound) {
                    if (DEBUG) {
                        System.out.println("Changed upper bound of " + UML2Util.getQualifiedText((EObject)eTypedElement) + " from " + upperBound + " to " + greaterUpperBound);
                    }
                    eTypedElement.setUpperBound(greaterUpperBound);
                }
            }
            if (!isMany && !otherIsMany) {
                EClassifier eType = eTypedElement.getEType();
                EClassifier otherEType = otherETypedElement.getEType();
                EClassifier commonEType = UML2Util.getCommonEType(otherEType, eType);
                if (commonEType != otherEType) {
                    if (DEBUG) {
                        System.err.println("Changed type of " + UML2Util.getQualifiedText((EObject)otherETypedElement) + " from " + UML2Util.getQualifiedText((EObject)otherEType) + " to " + UML2Util.getQualifiedText((EObject)commonEType));
                    }
                    otherETypedElement.setEType(commonEType);
                }
                if (commonEType != eType) {
                    if (DEBUG) {
                        System.out.println("Changed type of " + UML2Util.getQualifiedText((EObject)eTypedElement) + " from " + UML2Util.getQualifiedText((EObject)eType) + " to " + UML2Util.getQualifiedText((EObject)commonEType));
                    }
                    eTypedElement.setEType(commonEType);
                }
            }
            eTypedElement.setOrdered(otherETypedElement.isOrdered());
            eTypedElement.setUnique(otherETypedElement.isUnique());
        }

        protected void qualifyName(ENamedElement eNamedElement) {
            EObject eContainer = eNamedElement.eContainer();
            if (eContainer instanceof ENamedElement) {
                String qualifiedName = String.valueOf(((ENamedElement)eContainer).getName()) + '_' + eNamedElement.getName();
                if (DEBUG) {
                    System.err.println("Qualified " + UML2Util.getQualifiedText((EObject)eNamedElement) + " as " + qualifiedName);
                }
                eNamedElement.setName(qualifiedName);
            }
        }

        protected void processDuplicateOperations(Map options, DiagnosticChain diagnostics, Map context) {
            UniqueEList operationsToDuplicate = new UniqueEList();
            Iterator eModelElements = this.elementToEModelElementMap.values().iterator();
            while (eModelElements.hasNext()) {
                EModelElement eModelElement = (EModelElement)eModelElements.next();
                if (!(eModelElement instanceof EClass)) continue;
                EClass eClass = (EClass)eModelElement;
                Iterator eOperations = eClass.getEOperations().iterator();
                block1: while (eOperations.hasNext()) {
                    EOperation eOperation = (EOperation)eOperations.next();
                    Iterator eAllOperations = eClass.getEAllOperations().iterator();
                    while (eAllOperations.hasNext()) {
                        EOperation eAllOperation = (EOperation)eAllOperations.next();
                        if (eOperation == eAllOperation) continue block1;
                        if (!new SignatureMatcher(eOperation).matches((EObject)eAllOperation)) continue;
                        if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__DUPLICATE_OPERATIONS))) {
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 2007, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ProcessDuplicateOperation_diagnostic", UML2Util.getMessageSubstitutions(context, eOperation, eAllOperation)), new Object[]{eClass, eAllOperation}));
                            }
                            operationsToDuplicate.add(eOperation);
                            this.ensureConformity((ETypedElement)eOperation, (ETypedElement)eAllOperation);
                            EList redefinedOperations = UML2Util.getEAnnotation((EModelElement)eOperation, UML2Util.ANNOTATION_SOURCE__REDEFINES, true).getReferences();
                            if (redefinedOperations.contains(eAllOperation)) continue;
                            redefinedOperations.add(eAllOperation);
                            continue;
                        }
                        if (UML2Util.OPTION__DISCARD.equals(options.get(OPTION__DUPLICATE_OPERATIONS))) {
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2007, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_DiscardDuplicateOperation_diagnostic", UML2Util.getMessageSubstitutions(context, eOperation, eAllOperation)), new Object[]{eClass, eAllOperation}));
                            }
                            eOperations.remove();
                            continue block1;
                        }
                        if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__DUPLICATE_OPERATIONS)) || diagnostics == null) continue;
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 2007, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ReportDuplicateOperation_diagnostic", UML2Util.getMessageSubstitutions(context, eOperation, eAllOperation)), new Object[]{eOperation, eAllOperation}));
                    }
                }
            }
            Iterator eOperations = operationsToDuplicate.iterator();
            while (eOperations.hasNext()) {
                EOperation eOperation = (EOperation)eOperations.next();
                UML2Util.getEAnnotation((EModelElement)eOperation.getEContainingClass(), UML2Util.ANNOTATION_SOURCE__DUPLICATES, true).getContents().add((Object)eOperation);
            }
        }

        protected void processDuplicateOperationInheritance(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator eModelElements = this.elementToEModelElementMap.values().iterator();
            while (eModelElements.hasNext()) {
                EClass eClass;
                EModelElement eModelElement = (EModelElement)eModelElements.next();
                if (!(eModelElement instanceof EClass) || (eClass = (EClass)eModelElement).getESuperTypes().size() <= 1) continue;
                Iterator eSuperTypes = eClass.getESuperTypes().iterator();
                eSuperTypes.next();
                block1: while (eSuperTypes.hasNext()) {
                    EClass mixinEClass = (EClass)eSuperTypes.next();
                    Iterator mixinEOperations = mixinEClass.getEAllOperations().iterator();
                    block2: while (mixinEOperations.hasNext()) {
                        EOperation mixinEOperation = (EOperation)mixinEOperations.next();
                        Iterator eOperations = eClass.getEAllOperations().iterator();
                        while (eOperations.hasNext()) {
                            EOperation eOperation = (EOperation)eOperations.next();
                            if (mixinEOperation == eOperation) continue block2;
                            if (!new SignatureMatcher(mixinEOperation).matches((EObject)eOperation)) continue;
                            if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__DUPLICATE_OPERATION_INHERITANCE))) {
                                if (diagnostics != null) {
                                    diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 2008, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ProcessDuplicateOperationInheritance_diagnostic", UML2Util.getMessageSubstitutions(context, eClass, eOperation, mixinEOperation)), new Object[]{eClass, eOperation, mixinEOperation}));
                                }
                                this.qualifyName((ENamedElement)mixinEOperation);
                                EList redefinedOperations = UML2Util.getEAnnotation((EModelElement)mixinEOperation, UML2Util.ANNOTATION_SOURCE__REDEFINES, true).getReferences();
                                if (redefinedOperations.contains(eOperation)) continue;
                                redefinedOperations.add(eOperation);
                                continue;
                            }
                            if (UML2Util.OPTION__DISCARD.equals(options.get(OPTION__DUPLICATE_OPERATION_INHERITANCE))) {
                                if (diagnostics != null) {
                                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2008, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_DiscardDuplicateOperationInheritance_diagnostic", UML2Util.getMessageSubstitutions(context, eClass, eOperation, mixinEOperation)), new Object[]{eClass, eOperation, mixinEOperation}));
                                }
                                eSuperTypes.remove();
                                continue block1;
                            }
                            if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__DUPLICATE_OPERATION_INHERITANCE)) || diagnostics == null) continue;
                            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 2008, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ReportDuplicateOperationInheritance_diagnostic", UML2Util.getMessageSubstitutions(context, eClass, eOperation, mixinEOperation)), new Object[]{eClass, eOperation, mixinEOperation}));
                        }
                    }
                }
            }
        }

        protected void processDuplicateFeatures(Map options, DiagnosticChain diagnostics, Map context) {
            EStructuralFeature eStructuralFeature;
            UniqueEList featuresToDuplicate = new UniqueEList();
            UniqueEList featuresToRemove = new UniqueEList();
            Iterator eModelElements = this.elementToEModelElementMap.values().iterator();
            while (eModelElements.hasNext()) {
                EModelElement eModelElement = (EModelElement)eModelElements.next();
                if (!(eModelElement instanceof EClass)) continue;
                EClass eClass = (EClass)eModelElement;
                Iterator eStructuralFeatures = eClass.getEStructuralFeatures().iterator();
                block1: while (eStructuralFeatures.hasNext()) {
                    EStructuralFeature eStructuralFeature2 = (EStructuralFeature)eStructuralFeatures.next();
                    Iterator eAllStructuralFeatures = eClass.getEAllStructuralFeatures().iterator();
                    while (eAllStructuralFeatures.hasNext()) {
                        EStructuralFeature eAllStructuralFeature = (EStructuralFeature)eAllStructuralFeatures.next();
                        if (eStructuralFeature2 == eAllStructuralFeature) continue block1;
                        if (!new NameMatcher((ENamedElement)eStructuralFeature2).matches((EObject)eAllStructuralFeature)) continue;
                        if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__DUPLICATE_FEATURES))) {
                            EList redefinedFeatures;
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 2009, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ProcessDuplicateFeature_diagnostic", UML2Util.getMessageSubstitutions(context, eStructuralFeature2, eAllStructuralFeature)), new Object[]{eStructuralFeature2, eAllStructuralFeature}));
                            }
                            if (!featuresToDuplicate.contains(eStructuralFeature2)) {
                                EReference eOpposite;
                                EStructuralFeature duplicateEStructuralFeature = eAllStructuralFeature.isDerived() && !eStructuralFeature2.isDerived() ? eAllStructuralFeature : eStructuralFeature2;
                                featuresToDuplicate.add(duplicateEStructuralFeature);
                                this.ensureConformity((ETypedElement)eStructuralFeature2, (ETypedElement)eAllStructuralFeature);
                                if (duplicateEStructuralFeature instanceof EReference && (eOpposite = ((EReference)duplicateEStructuralFeature).getEOpposite()) != null) {
                                    featuresToDuplicate.add(eOpposite);
                                }
                            }
                            if ((redefinedFeatures = UML2Util.getEAnnotation((EModelElement)eStructuralFeature2, UML2Util.ANNOTATION_SOURCE__REDEFINES, true).getReferences()).contains(eAllStructuralFeature)) continue;
                            redefinedFeatures.add(eAllStructuralFeature);
                            continue;
                        }
                        if (UML2Util.OPTION__DISCARD.equals(options.get(OPTION__DUPLICATE_FEATURES))) {
                            EReference eOpposite;
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2009, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_DiscardDuplicateFeature_diagnostic", UML2Util.getMessageSubstitutions(context, eStructuralFeature2, eAllStructuralFeature)), new Object[]{eClass, eAllStructuralFeature}));
                            }
                            if (eStructuralFeature2 instanceof EReference && (eOpposite = ((EReference)eStructuralFeature2).getEOpposite()) != null) {
                                featuresToRemove.add(eOpposite);
                            }
                            eStructuralFeatures.remove();
                            continue block1;
                        }
                        if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__DUPLICATE_FEATURES)) || diagnostics == null) continue;
                        diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 2009, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ReportDuplicateFeature_diagnostic", UML2Util.getMessageSubstitutions(context, eStructuralFeature2, eAllStructuralFeature)), new Object[]{eStructuralFeature2, eAllStructuralFeature}));
                    }
                }
            }
            Iterator eStructuralFeatures = featuresToDuplicate.iterator();
            while (eStructuralFeatures.hasNext()) {
                eStructuralFeature = (EStructuralFeature)eStructuralFeatures.next();
                UML2Util.getEAnnotation((EModelElement)eStructuralFeature.getEContainingClass(), UML2Util.ANNOTATION_SOURCE__DUPLICATES, true).getContents().add((Object)eStructuralFeature);
            }
            eStructuralFeatures = featuresToRemove.iterator();
            while (eStructuralFeatures.hasNext()) {
                eStructuralFeature = (EStructuralFeature)eStructuralFeatures.next();
                EClass eContainingClass = eStructuralFeature.getEContainingClass();
                if (eContainingClass == null) continue;
                eContainingClass.getEStructuralFeatures().remove((Object)eStructuralFeature);
            }
        }

        protected void processDuplicateFeatureInheritance(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator eModelElements = this.elementToEModelElementMap.values().iterator();
            while (eModelElements.hasNext()) {
                EClass eClass;
                EModelElement eModelElement = (EModelElement)eModelElements.next();
                if (!(eModelElement instanceof EClass) || (eClass = (EClass)eModelElement).getESuperTypes().size() <= 1) continue;
                Iterator eSuperTypes = eClass.getESuperTypes().iterator();
                eSuperTypes.next();
                block1: while (eSuperTypes.hasNext()) {
                    EClass mixinEClass = (EClass)eSuperTypes.next();
                    Iterator mixinEStructuralFeatures = mixinEClass.getEAllStructuralFeatures().iterator();
                    block2: while (mixinEStructuralFeatures.hasNext()) {
                        EStructuralFeature mixinEStructuralFeature = (EStructuralFeature)mixinEStructuralFeatures.next();
                        Iterator eStructuralFeatures = eClass.getEAllStructuralFeatures().iterator();
                        while (eStructuralFeatures.hasNext()) {
                            EStructuralFeature eStructuralFeature = (EStructuralFeature)eStructuralFeatures.next();
                            if (mixinEStructuralFeature == eStructuralFeature) continue block2;
                            if (!new NameMatcher((ENamedElement)mixinEStructuralFeature).matches((EObject)eStructuralFeature)) continue;
                            if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__DUPLICATE_FEATURE_INHERITANCE))) {
                                if (diagnostics != null) {
                                    diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 2010, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ProcessDuplicateFeatureInheritance_diagnostic", UML2Util.getMessageSubstitutions(context, eClass, eStructuralFeature, mixinEStructuralFeature)), new Object[]{eClass, eStructuralFeature, mixinEStructuralFeature}));
                                }
                                this.qualifyName((ENamedElement)mixinEStructuralFeature);
                                EList redefinedFeatures = UML2Util.getEAnnotation((EModelElement)mixinEStructuralFeature, UML2Util.ANNOTATION_SOURCE__REDEFINES, true).getReferences();
                                if (redefinedFeatures.contains(eStructuralFeature)) continue;
                                redefinedFeatures.add(eStructuralFeature);
                                continue;
                            }
                            if (UML2Util.OPTION__DISCARD.equals(options.get(OPTION__DUPLICATE_FEATURE_INHERITANCE))) {
                                if (diagnostics != null) {
                                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 2010, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_DiscardDuplicateFeatureInheritance_diagnostic", UML2Util.getMessageSubstitutions(context, eClass, eStructuralFeature, mixinEStructuralFeature)), new Object[]{eClass, eStructuralFeature, mixinEStructuralFeature}));
                                }
                                eSuperTypes.remove();
                                continue block1;
                            }
                            if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__DUPLICATE_FEATURE_INHERITANCE)) || diagnostics == null) continue;
                            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 2010, UML2Plugin.INSTANCE.getString("_UI_UML22EcoreConverter_ReportDuplicateFeatureInheritance_diagnostic", UML2Util.getMessageSubstitutions(context, eClass, eStructuralFeature, mixinEStructuralFeature)), new Object[]{eClass, eStructuralFeature, mixinEStructuralFeature}));
                        }
                    }
                }
            }
        }

        protected void processOptions(Map options, DiagnosticChain diagnostics, Map context) {
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__ECORE_TAGGED_VALUES))) {
                this.processEcoreTaggedValues(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__REDEFINING_OPERATIONS))) {
                this.processRedefiningOperations(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__REDEFINING_PROPERTIES))) {
                this.processRedefiningProperties(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__SUBSETTING_PROPERTIES))) {
                this.processSubsettingProperties(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__UNION_PROPERTIES))) {
                this.processUnionProperties(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__DERIVED_FEATURES))) {
                this.processDerivedFeatures(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__DUPLICATE_OPERATIONS))) {
                this.processDuplicateOperations(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__DUPLICATE_OPERATION_INHERITANCE))) {
                this.processDuplicateOperationInheritance(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__DUPLICATE_FEATURES))) {
                this.processDuplicateFeatures(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__DUPLICATE_FEATURE_INHERITANCE))) {
                this.processDuplicateFeatureInheritance(options, diagnostics, context);
            }
        }

        public Collection convert(Collection eObjects, Map options, DiagnosticChain diagnostics, Map context) {
            this.packages = EcoreUtil.getObjectsByType((Collection)eObjects, (EClassifier)UML2Package.eINSTANCE.getPackage());
            Iterator i = this.packages.iterator();
            while (i.hasNext()) {
                this.doSwitch((EObject)((Package)i.next()));
            }
            if (options != null) {
                this.processOptions(options, diagnostics, context);
            }
            return UML2Util.getRootContainers(EcoreUtil.getObjectsByType(this.elementToEModelElementMap.values(), (EClassifier)EcorePackage.eINSTANCE.getEPackage()));
        }

        protected class NameMatcher
        extends EClassMatcher {
            protected NameMatcher(ENamedElement eNamedElement) {
                super((EObject)eNamedElement);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && (this.eObject == null && otherEObject == null || ((ENamedElement)this.eObject).getName().equalsIgnoreCase(((ENamedElement)otherEObject).getName()));
            }
        }

        protected class ETypeMatcher
        extends NameMatcher {
            protected ETypeMatcher(ETypedElement eTypedElement) {
                super((ENamedElement)eTypedElement);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && (this.eObject == null && otherEObject == null || UML2Util.safeEquals(((ETypedElement)this.eObject).getEType(), ((ETypedElement)otherEObject).getEType()));
            }
        }

        protected class SignatureMatcher
        extends ETypeMatcher {
            protected SignatureMatcher(EOperation eOperation) {
                super((ETypedElement)eOperation);
            }

            public boolean matches(EObject otherEObject) {
                EList otherEParameters;
                EList eParameters;
                int eParametersSize;
                if (super.matches(otherEObject) && (eParametersSize = (eParameters = ((EOperation)this.eObject).getEParameters()).size()) == (otherEParameters = ((EOperation)otherEObject).getEParameters()).size()) {
                    int i = 0;
                    while (i < eParametersSize) {
                        if (!new ETypeMatcher((ETypedElement)eParameters.get(i)).matches((EObject)otherEParameters.get(i))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    public static interface EObjectMatcher {
        public boolean matches(EObject var1);
    }

    protected static class EClassMatcher
    implements EObjectMatcher {
        protected final EObject eObject;

        protected EClassMatcher(EObject eObject) {
            this.eObject = eObject;
        }

        public boolean matches(EObject otherEObject) {
            return this.eObject == null || otherEObject == null ? this.eObject == null && otherEObject == null : this.eObject.eClass() == otherEObject.eClass();
        }
    }

    public static class PackageMerger
    extends EcoreUtil.Copier {
        public static final String OPTION__DIFFERENT_PROPERTY_STATICITY = "DIFFERENT_PROPERTY_STATICITY";
        public static final String OPTION__DIFFERENT_PROPERTY_UNIQUENESS = "DIFFERENT_PROPERTY_UNIQUENESS";
        public static final String OPTION__REDUNDANT_GENERALIZATIONS = "REDUNDANT_GENERALIZATIONS";
        public static final String OPTION__IMPLICIT_REDEFINITIONS = "IMPLICIT_REDEFINITIONS";
        public static final String OPTION__INVALID_REDEFINITIONS = "INVALID_REDEFINITIONS";
        public static final String OPTION__INVALID_SUBSETS = "INVALID_SUBSETS";
        public static final String OPTION__EMPTY_UNIONS = "EMPTY_UNIONS";
        private static final int DIAGNOSTIC_CODE_OFFSET = 1000;
        public static final int DIFFERENT_PROPERTY_STATICITY = 1001;
        public static final int DIFFERENT_PROPERTY_UNIQUENESS = 1002;
        public static final int REDUNDANT_GENERALIZATION = 1003;
        public static final int IMPLICIT_REDEFINITION = 1004;
        public static final int INVALID_REDEFINITION = 1005;
        public static final int INVALID_SUBSET = 1006;
        public static final int EMPTY_UNION = 1007;
        protected static final String ANNOTATION_SOURCE__STEREOTYPE = "stereotype";
        protected Package receivingPackage = null;
        protected Collection mergedPackages = null;
        protected final Map resultingToMergedEObjectMap = new HashMap();

        protected List getMatchCandidates(EObject eObject) {
            EStructuralFeature eContainingFeature = eObject.eContainingFeature();
            return eContainingFeature.isMany() ? (List<Object>)((EObject)this.get(eObject.eContainer())).eGet(eContainingFeature) : Collections.singletonList(((EObject)this.get(eObject.eContainer())).eGet(eContainingFeature));
        }

        protected EObject getPreviouslyMergedEObject(EObject eObject) {
            List mergedEObjects = (List)this.resultingToMergedEObjectMap.get(eObject);
            return mergedEObjects == null ? eObject : (EObject)mergedEObjects.get(0);
        }

        protected String getResultingQName(EObject eObject) {
            StringBuffer resultingQName = this.appendResultingQName(new StringBuffer(), eObject, QualifiedTextProvider.DEFAULT);
            return resultingQName.toString();
        }

        private StringBuffer appendResultingQName(StringBuffer resultingQName, EObject eObject, QualifiedTextProvider qualifiedTextProvider) {
            EObject eContainer = (eObject = this.mergedPackages.contains(eObject) ? this.receivingPackage : eObject).eContainer();
            if (eContainer != null) {
                this.appendResultingQName(resultingQName, eContainer, qualifiedTextProvider);
                if (resultingQName.length() > 0) {
                    resultingQName.append(qualifiedTextProvider.getSeparator());
                }
            }
            return UML2Util.appendQualifiedTextSegment(resultingQName, eObject, qualifiedTextProvider);
        }

        protected void mergeAssociation_IsDerived(Association receivingAssociation, Association mergedAssociation) {
            receivingAssociation.setIsDerived(receivingAssociation.isDerived() || mergedAssociation.isDerived());
        }

        protected void mergeClassifier_IsAbstract(Classifier receivingClassifier, Classifier mergedClassifier) {
            receivingClassifier.setIsAbstract(receivingClassifier.isAbstract() && mergedClassifier.isAbstract());
        }

        protected void mergeLiteralInteger_Value(LiteralInteger receivingLiteralInteger, LiteralInteger mergedLiteralInteger) {
            receivingLiteralInteger.setValue(UML2Util.getLesserLowerBound(receivingLiteralInteger.getValue(), mergedLiteralInteger.getValue()));
        }

        protected void mergeLiteralUnlimitedNatural_Value(LiteralUnlimitedNatural receivingLiteralUnlimitedNatural, LiteralUnlimitedNatural mergedLiteralUnlimitedNatural) {
            receivingLiteralUnlimitedNatural.setValue(UML2Util.getGreaterUpperBound(receivingLiteralUnlimitedNatural.getValue(), mergedLiteralUnlimitedNatural.getValue()));
        }

        protected void mergeMultiplicityElement_IsOrdered(MultiplicityElement receivingMultiplicityElement, MultiplicityElement mergedMultiplicityElement) {
            receivingMultiplicityElement.setIsOrdered(receivingMultiplicityElement.isOrdered() || mergedMultiplicityElement.isOrdered());
        }

        protected void mergeMultiplicityElement_IsUnique(MultiplicityElement receivingMultiplicityElement, MultiplicityElement mergedMultiplicityElement) {
            receivingMultiplicityElement.setIsUnique(receivingMultiplicityElement.isUnique() && mergedMultiplicityElement.isUnique());
        }

        protected void mergeNamedElement_Visibility(NamedElement receivingNamedElement, NamedElement mergedNamedElement) {
            receivingNamedElement.setVisibility(VisibilityKind.PRIVATE_LITERAL == receivingNamedElement.getVisibility() && VisibilityKind.PRIVATE_LITERAL == mergedNamedElement.getVisibility() ? VisibilityKind.PRIVATE_LITERAL : VisibilityKind.PUBLIC_LITERAL);
        }

        protected void mergePackageableElement_PackageableElement_visibility(PackageableElement receivingPackageableElement, PackageableElement mergedPackageableElement) {
            receivingPackageableElement.setPackageableElement_visibility(VisibilityKind.PRIVATE_LITERAL == receivingPackageableElement.getPackageableElement_visibility() && VisibilityKind.PRIVATE_LITERAL == mergedPackageableElement.getPackageableElement_visibility() ? VisibilityKind.PRIVATE_LITERAL : VisibilityKind.PUBLIC_LITERAL);
        }

        protected void mergeProperty_IsDerived(Property receivingProperty, Property mergedProperty) {
            receivingProperty.setIsDerived(receivingProperty.isDerived() || mergedProperty.isDerived());
        }

        protected void mergeProperty_IsDerivedUnion(Property receivingProperty, Property mergedProperty) {
            receivingProperty.setIsDerivedUnion(receivingProperty.isDerivedUnion() || mergedProperty.isDerivedUnion());
        }

        protected void mergeStructuralFeature_IsReadOnly(StructuralFeature receivingStructuralFeature, StructuralFeature mergedStructuralFeature) {
            receivingStructuralFeature.setIsReadOnly(receivingStructuralFeature.isReadOnly() && mergedStructuralFeature.isReadOnly());
        }

        protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
            if (this.receivingPackage == copyEObject) {
                return;
            }
            if (this.resultingToMergedEObjectMap.containsKey(copyEObject)) {
                if (UML2Package.eINSTANCE.getAssociation_IsDerived() == eAttribute) {
                    this.mergeAssociation_IsDerived((Association)copyEObject, (Association)eObject);
                } else if (UML2Package.eINSTANCE.getClassifier_IsAbstract() == eAttribute) {
                    this.mergeClassifier_IsAbstract((Classifier)copyEObject, (Classifier)eObject);
                } else if (UML2Package.eINSTANCE.getLiteralInteger_Value() == eAttribute && UML2Package.eINSTANCE.getMultiplicityElement_LowerValue() == copyEObject.eContainingFeature()) {
                    this.mergeLiteralInteger_Value((LiteralInteger)copyEObject, (LiteralInteger)eObject);
                } else if (UML2Package.eINSTANCE.getLiteralUnlimitedNatural_Value() == eAttribute && UML2Package.eINSTANCE.getMultiplicityElement_UpperValue() == copyEObject.eContainingFeature()) {
                    this.mergeLiteralUnlimitedNatural_Value((LiteralUnlimitedNatural)copyEObject, (LiteralUnlimitedNatural)eObject);
                } else if (UML2Package.eINSTANCE.getMultiplicityElement_IsOrdered() == eAttribute) {
                    this.mergeMultiplicityElement_IsOrdered((MultiplicityElement)copyEObject, (MultiplicityElement)eObject);
                } else if (UML2Package.eINSTANCE.getMultiplicityElement_IsUnique() == eAttribute) {
                    this.mergeMultiplicityElement_IsUnique((MultiplicityElement)copyEObject, (MultiplicityElement)eObject);
                } else if (UML2Package.eINSTANCE.getNamedElement_Visibility() == eAttribute) {
                    this.mergeNamedElement_Visibility((NamedElement)copyEObject, (NamedElement)eObject);
                } else if (UML2Package.eINSTANCE.getPackageableElement_PackageableElement_visibility() == eAttribute) {
                    this.mergePackageableElement_PackageableElement_visibility((PackageableElement)copyEObject, (PackageableElement)eObject);
                } else if (UML2Package.eINSTANCE.getProperty_IsDerived() == eAttribute) {
                    this.mergeProperty_IsDerived((Property)copyEObject, (Property)eObject);
                } else if (UML2Package.eINSTANCE.getProperty_IsDerivedUnion() == eAttribute) {
                    this.mergeProperty_IsDerivedUnion((Property)copyEObject, (Property)eObject);
                } else if (UML2Package.eINSTANCE.getStructuralFeature_IsReadOnly() == eAttribute) {
                    this.mergeStructuralFeature_IsReadOnly((StructuralFeature)copyEObject, (StructuralFeature)eObject);
                } else {
                    super.copyAttribute(eAttribute, eObject, copyEObject);
                }
            } else {
                super.copyAttribute(eAttribute, eObject, copyEObject);
            }
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet((EStructuralFeature)eReference) && eReference.isMany()) {
                List targetList = (List)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                Iterator i = ((List)eObject.eGet((EStructuralFeature)eReference)).iterator();
                while (i.hasNext()) {
                    targetList.add(this.copy((EObject)i.next()));
                }
            } else {
                super.copyContainment(eReference, eObject, copyEObject);
            }
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eObject.eIsSet((EStructuralFeature)eReference) && eReference.isMany()) {
                InternalEList targetList = (InternalEList)copyEObject.eGet(this.getTarget((EStructuralFeature)eReference));
                boolean isBidirectional = eReference.getEOpposite() != null;
                int index = 0;
                Iterator i = ((List)eObject.eGet((EStructuralFeature)eReference)).iterator();
                while (i.hasNext()) {
                    Object referencedEObject = i.next();
                    Object copyReferencedEObject = this.get(referencedEObject);
                    if (copyReferencedEObject == null) {
                        if (isBidirectional || targetList.contains(referencedEObject)) continue;
                        targetList.add(index++, referencedEObject);
                        continue;
                    }
                    if (isBidirectional) {
                        int position = targetList.indexOf(copyReferencedEObject);
                        if (position == -1) {
                            targetList.addUnique(index++, copyReferencedEObject);
                            continue;
                        }
                        if (index == position) continue;
                        targetList.move(index < targetList.size() ? index++ : --index, copyReferencedEObject);
                        continue;
                    }
                    if (targetList.contains(copyReferencedEObject)) continue;
                    targetList.add(index++, copyReferencedEObject);
                }
            } else {
                super.copyReference(eReference, eObject, copyEObject);
            }
        }

        protected EObject createCopy(EObject eObject) {
            return (EObject)new UML2Switch(this){
                final /* synthetic */ PackageMerger this$1;
                {
                    this.this$1 = packageMerger;
                }

                public Object caseAssociation(Association association) {
                    Association matchingAssociation = (Association)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)association), new NameMatcher(this, this.this$1, association){
                        final /* synthetic */ 7 this$2;
                        {
                            super($anonymous0);
                            this.this$2 = var1_1;
                        }

                        public boolean matches(EObject otherEObject) {
                            if (super.matches(otherEObject)) {
                                otherEObject = 7.access$0(this.this$2).getPreviouslyMergedEObject(otherEObject);
                                EList memberEnds = ((Association)this.eObject).getMemberEnds();
                                EList otherMemberEnds = ((Association)otherEObject).getMemberEnds();
                                if (memberEnds.size() == otherMemberEnds.size()) {
                                    Iterator<E> i = memberEnds.iterator();
                                    while (i.hasNext()) {
                                        if (UML2Util.findEObject((Collection)otherMemberEnds, 7.access$0(this.this$2).new TypeMatcher((TypedElement)i.next())) != null) continue;
                                        return false;
                                    }
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                    return matchingAssociation == null ? super.caseAssociation(association) : matchingAssociation;
                }

                public Object caseClass(Class class_) {
                    Class matchingClass = (Class)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)class_), this.this$1.new NameMatcher(class_));
                    return matchingClass == null ? super.caseClass(class_) : matchingClass;
                }

                public Object caseComment(Comment comment) {
                    Comment matchingComment = (Comment)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)comment), this.this$1.new BodyMatcher(comment));
                    return matchingComment == null ? super.caseComment(comment) : matchingComment;
                }

                public Object caseConstraint(Constraint constraint) {
                    Constraint matchingConstraint = (Constraint)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)constraint), new NameMatcher(this, this.this$1, constraint){
                        final /* synthetic */ 7 this$2;
                        {
                            super($anonymous0);
                            this.this$2 = var1_1;
                        }

                        public boolean matches(EObject otherEObject) {
                            return super.matches(otherEObject) && 7.access$0(this.this$2).new StringValueMatcher(((Constraint)this.eObject).getSpecification()).matches((EObject)((Constraint)otherEObject).getSpecification());
                        }
                    });
                    return matchingConstraint == null ? super.caseConstraint(constraint) : matchingConstraint;
                }

                public Object caseDataType(DataType dataType) {
                    DataType matchingDataType = (DataType)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)dataType), this.this$1.new NameMatcher(dataType));
                    return matchingDataType == null ? super.caseDataType(dataType) : matchingDataType;
                }

                public Object caseDirectedRelationship(DirectedRelationship directedRelationship) {
                    DirectedRelationship matchingDirectedRelationship = (DirectedRelationship)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)directedRelationship), new EClassMatcher(this, (EObject)directedRelationship){
                        final /* synthetic */ 7 this$2;
                        {
                            super($anonymous0);
                            this.this$2 = var1_1;
                        }

                        public boolean matches(EObject otherEObject) {
                            if (super.matches(otherEObject)) {
                                otherEObject = 7.access$0(this.this$2).getPreviouslyMergedEObject(otherEObject);
                                EList targets = ((DirectedRelationship)this.eObject).getTargets();
                                EList otherTargets = ((DirectedRelationship)otherEObject).getTargets();
                                if (targets.size() == otherTargets.size()) {
                                    Iterator<E> i = targets.iterator();
                                    while (i.hasNext()) {
                                        if (UML2Util.findEObject((Collection)otherTargets, 7.access$0(this.this$2).new ResultingQNameMatcher((EObject)i.next())) != null) continue;
                                        return false;
                                    }
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                    return matchingDirectedRelationship == null ? super.caseDirectedRelationship(directedRelationship) : matchingDirectedRelationship;
                }

                public Object caseEnumerationLiteral(EnumerationLiteral enumerationLiteral) {
                    EnumerationLiteral matchingEnumerationLiteral = (EnumerationLiteral)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)enumerationLiteral), this.this$1.new NameMatcher(enumerationLiteral));
                    return matchingEnumerationLiteral == null ? super.caseEnumerationLiteral(enumerationLiteral) : matchingEnumerationLiteral;
                }

                public Object caseOperation(Operation operation) {
                    Operation matchingOperation = (Operation)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)operation), new NameMatcher(this, this.this$1, operation){
                        final /* synthetic */ 7 this$2;
                        {
                            super($anonymous0);
                            this.this$2 = var1_1;
                        }

                        public boolean matches(EObject otherEObject) {
                            if (super.matches(otherEObject)) {
                                otherEObject = 7.access$0(this.this$2).getPreviouslyMergedEObject(otherEObject);
                                EList ownedParameters = ((Operation)this.eObject).getOwnedParameters();
                                EList otherOwnedParameters = ((Operation)otherEObject).getOwnedParameters();
                                if (ownedParameters.size() == otherOwnedParameters.size()) {
                                    int i = 0;
                                    while (i < ownedParameters.size()) {
                                        if (!7.access$0(this.this$2).new TypeMatcher((TypedElement)ownedParameters.get(i)).matches((EObject)otherOwnedParameters.get(i))) {
                                            return false;
                                        }
                                        ++i;
                                    }
                                    return true;
                                }
                            }
                            return false;
                        }
                    });
                    return matchingOperation == null ? super.caseOperation(operation) : matchingOperation;
                }

                public Object casePackage(Package package_) {
                    Package matchingPackage = null;
                    matchingPackage = this.this$1.mergedPackages.contains(package_) ? this.this$1.receivingPackage : (Package)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)package_), this.this$1.new NameMatcher(package_));
                    return matchingPackage == null ? super.casePackage(package_) : matchingPackage;
                }

                public Object caseParameter(Parameter parameter) {
                    Parameter matchingParameter = (Parameter)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)parameter), this.this$1.new NameMatcher(parameter));
                    return matchingParameter == null ? super.caseParameter(parameter) : matchingParameter;
                }

                public Object caseProperty(Property property) {
                    Property matchingProperty = (Property)UML2Util.findEObject(this.this$1.getMatchCandidates((EObject)property), this.this$1.new NameMatcher(property));
                    return matchingProperty == null ? super.caseProperty(property) : matchingProperty;
                }

                public Object defaultCase(EObject eObject) {
                    return PackageMerger.access$0(this.this$1, eObject);
                }

                protected Object doSwitch(EClass theEClass, EObject theEObject) {
                    if (UML2Switch.modelPackage != theEClass.eContainer()) {
                        EObject matchingEObject;
                        if (EcorePackage.eINSTANCE.getEAnnotation() == theEClass) {
                            EAnnotation matchingEAnnotation = (EAnnotation)UML2Util.findEObject(this.this$1.getMatchCandidates(theEObject), this.this$1.new SourceMatcher((EAnnotation)theEObject));
                            if (matchingEAnnotation != null) {
                                return matchingEAnnotation;
                            }
                        } else if (EcorePackage.eINSTANCE.getEStringToStringMapEntry() == theEClass) {
                            BasicEMap.Entry matchingEntry = (BasicEMap.Entry)UML2Util.findEObject(this.this$1.getMatchCandidates(theEObject), this.this$1.new KeyMatcher((BasicEMap.Entry)theEObject));
                            if (matchingEntry != null) {
                                return matchingEntry;
                            }
                        } else if (UML2Util.getEAnnotation((EModelElement)theEClass, "stereotype", false) != null && (matchingEObject = UML2Util.findEObject(this.this$1.getMatchCandidates(theEObject), new EClassMatcher(theEObject))) != null) {
                            return matchingEObject;
                        }
                    }
                    return super.doSwitch(theEClass, theEObject);
                }

                static /* synthetic */ PackageMerger access$0(7 var0) {
                    return var0.this$1;
                }
            }.doSwitch(eObject);
        }

        public EObject copy(EObject eObject) {
            EObject copyEObject = super.copy(eObject);
            ArrayList<EObject> mergedEObjects = (ArrayList<EObject>)this.resultingToMergedEObjectMap.get(copyEObject);
            if (mergedEObjects == null) {
                mergedEObjects = new ArrayList<EObject>(1);
                this.resultingToMergedEObjectMap.put(copyEObject, mergedEObjects);
            }
            mergedEObjects.add(eObject);
            if (DEBUG) {
                System.out.println(String.valueOf(UML2Util.getQualifiedText(eObject)) + "->" + UML2Util.getQualifiedText(copyEObject));
            }
            return copyEObject;
        }

        protected Collection getAllMergedPackages(Package package_) {
            ArrayList allMergedPackages = new ArrayList();
            this.getAllMergedPackagesHelper(package_, allMergedPackages);
            return allMergedPackages;
        }

        protected void getAllMergedPackagesHelper(Package package_, Collection allMergedPackages) {
            Iterator packageMerges = package_.getPackageMerges().iterator();
            while (packageMerges.hasNext()) {
                Package mergedPackage = ((PackageMerge)packageMerges.next()).getMergedPackage();
                if (mergedPackage == null) continue;
                this.getAllMergedPackagesHelper(mergedPackage, allMergedPackages);
                if (allMergedPackages.contains(mergedPackage)) continue;
                allMergedPackages.add(mergedPackage);
            }
        }

        protected void processDifferentPropertyStaticity(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.resultingToMergedEObjectMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object key = entry.getKey();
                if (!(key instanceof Property)) continue;
                Property property = (Property)key;
                Iterator mergedProperties = ((List)entry.getValue()).iterator();
                while (mergedProperties.hasNext()) {
                    Property mergedProperty = (Property)mergedProperties.next();
                    if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__DIFFERENT_PROPERTY_STATICITY)) || diagnostics == null || property.isStatic() == mergedProperty.isStatic()) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 1001, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_ReportDifferentPropertyStaticity_diagnostic", UML2Util.getMessageSubstitutions(context, property, mergedProperty)), new Object[]{property, mergedProperty}));
                }
            }
        }

        protected void processDifferentPropertyUniqueness(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator entries = this.resultingToMergedEObjectMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                Object key = entry.getKey();
                if (!(key instanceof Property)) continue;
                Property property = (Property)key;
                Iterator mergedProperties = ((List)entry.getValue()).iterator();
                while (mergedProperties.hasNext()) {
                    Property mergedProperty = (Property)mergedProperties.next();
                    if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__DIFFERENT_PROPERTY_UNIQUENESS)) || diagnostics == null || property.isUnique() == mergedProperty.isUnique()) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.uml2", 1002, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_ReportDifferentPropertyUniqueness_diagnostic", UML2Util.getMessageSubstitutions(context, property, mergedProperty)), new Object[]{property, mergedProperty}));
                }
            }
        }

        protected Set getImplicitlyRedefinedProperties(Set redefinedProperties, Property redefiningProperty, Classifier redefinitionContext) {
            Property redefinedProperty = (Property)UML2Util.findEObject((Collection)redefinitionContext.getAttributes(), new NameMatcher(redefiningProperty));
            if (redefinedProperty == null) {
                Iterator generals = redefinitionContext.getGenerals().iterator();
                while (generals.hasNext()) {
                    this.getImplicitlyRedefinedProperties(redefinedProperties, redefiningProperty, (Classifier)generals.next());
                }
            } else if (!redefiningProperty.getRedefinedProperties().contains((Object)redefinedProperty)) {
                redefinedProperties.add(redefinedProperty);
            }
            return redefinedProperties;
        }

        protected void processImplicitRedefinitions(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator resultingEObjects = this.resultingToMergedEObjectMap.keySet().iterator();
            while (resultingEObjects.hasNext()) {
                EObject resultingEObject = (EObject)resultingEObjects.next();
                if (!(resultingEObject instanceof Property)) continue;
                Property redefiningProperty = (Property)resultingEObject;
                EList redefiningRedefinedProperties = redefiningProperty.getRedefinedProperties();
                Iterator redefinitionContexts = redefiningProperty.getRedefinitionContexts().iterator();
                while (redefinitionContexts.hasNext()) {
                    Iterator generals = ((Classifier)redefinitionContexts.next()).getGenerals().iterator();
                    while (generals.hasNext()) {
                        Iterator redefinedProperties = this.getImplicitlyRedefinedProperties(new HashSet(), redefiningProperty, (Classifier)generals.next()).iterator();
                        while (redefinedProperties.hasNext()) {
                            Property redefinedProperty = (Property)redefinedProperties.next();
                            if (redefiningRedefinedProperties.contains((Object)redefinedProperty)) continue;
                            if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__IMPLICIT_REDEFINITIONS))) {
                                if (diagnostics != null) {
                                    diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 1004, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_ProcessImplicitRedefinition_diagnostic", UML2Util.getMessageSubstitutions(context, redefiningProperty, redefinedProperty)), new Object[]{redefiningProperty, redefinedProperty}));
                                }
                                redefiningRedefinedProperties.add((Object)redefinedProperty);
                                continue;
                            }
                            if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__IMPLICIT_REDEFINITIONS)) || diagnostics == null) continue;
                            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 1004, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_ReportImplicitRedefinition_diagnostic", UML2Util.getMessageSubstitutions(context, redefiningProperty, redefinedProperty)), new Object[]{redefiningProperty, redefinedProperty}));
                        }
                    }
                }
            }
        }

        protected boolean isRedefinitionValid(Property redefiningProperty, Property redefinedProperty) {
            return (!redefinedProperty.isNavigable() || redefiningProperty.isNavigable()) && redefinedProperty.isConsistentWith(redefiningProperty);
        }

        protected void processInvalidRedefinitions(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator resultingEObjects = this.resultingToMergedEObjectMap.keySet().iterator();
            while (resultingEObjects.hasNext()) {
                EObject resultingEObject = (EObject)resultingEObjects.next();
                if (!(resultingEObject instanceof Property)) continue;
                Property redefiningProperty = (Property)resultingEObject;
                Iterator redefinedProperties = redefiningProperty.getRedefinedProperties().iterator();
                while (redefinedProperties.hasNext()) {
                    Property redefinedProperty = (Property)redefinedProperties.next();
                    if (this.isRedefinitionValid(redefiningProperty, redefinedProperty)) continue;
                    if (UML2Util.OPTION__DISCARD.equals(options.get(OPTION__INVALID_REDEFINITIONS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 1005, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_DiscardInvalidRedefinition_diagnostic", UML2Util.getMessageSubstitutions(context, redefiningProperty, redefinedProperty)), new Object[]{redefiningProperty, redefinedProperty}));
                        }
                        redefinedProperties.remove();
                        continue;
                    }
                    if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__INVALID_REDEFINITIONS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 1005, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_ReportInvalidRedefinition_diagnostic", UML2Util.getMessageSubstitutions(context, redefiningProperty, redefinedProperty)), new Object[]{redefiningProperty, redefinedProperty}));
                }
            }
        }

        protected boolean isSubsetValid(Property subsettingProperty, Property subsettedProperty) {
            if (subsettedProperty.isNavigable() && !subsettingProperty.isNavigable()) {
                return false;
            }
            Iterator subsettingContexts = subsettingProperty.subsettingContext().iterator();
            while (subsettingContexts.hasNext()) {
                Classifier subsettingContext = (Classifier)subsettingContexts.next();
                Iterator subsettedContexts = subsettedProperty.subsettingContext().iterator();
                while (subsettedContexts.hasNext()) {
                    if (subsettingContext.conformsTo((Classifier)subsettedContexts.next())) continue;
                    return false;
                }
            }
            return true;
        }

        protected void processInvalidSubsets(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator resultingEObjects = this.resultingToMergedEObjectMap.keySet().iterator();
            while (resultingEObjects.hasNext()) {
                EObject resultingEObject = (EObject)resultingEObjects.next();
                if (!(resultingEObject instanceof Property)) continue;
                Property subsettingProperty = (Property)resultingEObject;
                Iterator subsettedProperties = subsettingProperty.getSubsettedProperties().iterator();
                while (subsettedProperties.hasNext()) {
                    Property subsettedProperty = (Property)subsettedProperties.next();
                    if (this.isSubsetValid(subsettingProperty, subsettedProperty)) continue;
                    if (UML2Util.OPTION__DISCARD.equals(options.get(OPTION__INVALID_SUBSETS))) {
                        if (diagnostics != null) {
                            diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 1006, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_DiscardInvalidSubset_diagnostic", UML2Util.getMessageSubstitutions(context, subsettingProperty, subsettedProperty)), new Object[]{subsettingProperty, subsettedProperty}));
                        }
                        subsettedProperties.remove();
                        continue;
                    }
                    if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__INVALID_SUBSETS)) || diagnostics == null) continue;
                    diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 1006, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_ReportInvalidSubset_diagnostic", UML2Util.getMessageSubstitutions(context, subsettingProperty, subsettedProperty)), new Object[]{subsettingProperty, subsettedProperty}));
                }
            }
        }

        protected void processEmptyUnions(Map options, DiagnosticChain diagnostics, Map context) {
            HashMap unionToSubsettingPropertyMap = new HashMap();
            Iterator resultingEObjects = this.resultingToMergedEObjectMap.keySet().iterator();
            while (resultingEObjects.hasNext()) {
                EObject resultingEObject = (EObject)resultingEObjects.next();
                if (!(resultingEObject instanceof Property)) continue;
                Property property = (Property)resultingEObject;
                if (property.isDerivedUnion() && !unionToSubsettingPropertyMap.containsKey(property)) {
                    unionToSubsettingPropertyMap.put(property, new HashSet());
                }
                Iterator subsettedProperties = property.getSubsettedProperties().iterator();
                while (subsettedProperties.hasNext()) {
                    Property subsettedProperty = (Property)subsettedProperties.next();
                    if (!subsettedProperty.isDerivedUnion()) continue;
                    HashSet<Property> subsettingProperties = (HashSet<Property>)unionToSubsettingPropertyMap.get(subsettedProperty);
                    if (subsettingProperties == null) {
                        subsettingProperties = new HashSet<Property>();
                        unionToSubsettingPropertyMap.put(subsettedProperty, subsettingProperties);
                    }
                    subsettingProperties.add(property);
                }
            }
            Iterator entries = unionToSubsettingPropertyMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (!((Set)entry.getValue()).isEmpty()) continue;
                Property unionProperty = (Property)entry.getKey();
                if (UML2Util.OPTION__PROCESS.equals(options.get(OPTION__EMPTY_UNIONS))) {
                    if (diagnostics != null) {
                        diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 1007, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_ProcessEmptyUnion_diagnostic", UML2Util.getMessageSubstitutions(context, unionProperty)), new Object[]{unionProperty}));
                    }
                    unionProperty.setIsDerivedUnion(false);
                    continue;
                }
                if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__EMPTY_UNIONS)) || diagnostics == null) continue;
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 1007, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_ReportEmptyUnion_diagnostic", UML2Util.getMessageSubstitutions(context, unionProperty)), new Object[]{unionProperty}));
            }
        }

        protected void processRedundantGeneralizations(Map options, DiagnosticChain diagnostics, Map context) {
            Iterator resultingEObjects = this.resultingToMergedEObjectMap.keySet().iterator();
            while (resultingEObjects.hasNext()) {
                EObject resultingEObject = (EObject)resultingEObjects.next();
                if (!(resultingEObject instanceof Classifier)) continue;
                Classifier classifier = (Classifier)resultingEObject;
                EList generalizations = classifier.getGeneralizations();
                Iterator i = new ArrayList(generalizations).iterator();
                block1: while (i.hasNext()) {
                    Classifier general = ((Generalization)i.next()).getGeneral();
                    if (general == null) continue;
                    Set generalAllParents = general.allParents();
                    Iterator j = generalizations.iterator();
                    while (j.hasNext()) {
                        Classifier otherGeneral = ((Generalization)j.next()).getGeneral();
                        if (general == otherGeneral || !generalAllParents.contains(otherGeneral)) continue;
                        if (UML2Util.OPTION__DISCARD.equals(options.get(OPTION__REDUNDANT_GENERALIZATIONS))) {
                            if (diagnostics != null) {
                                diagnostics.add((Diagnostic)new BasicDiagnostic(1, "org.eclipse.uml2", 1003, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_DiscardRedundantGeneralization_diagnostic", UML2Util.getMessageSubstitutions(context, classifier, otherGeneral, general)), new Object[]{classifier, otherGeneral}));
                            }
                            j.remove();
                            continue block1;
                        }
                        if (!UML2Util.OPTION__REPORT.equals(options.get(OPTION__REDUNDANT_GENERALIZATIONS)) || diagnostics == null) continue block1;
                        diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 1003, UML2Plugin.INSTANCE.getString("_UI_PackageMerger_ReportRedundantGeneralization_diagnostic", UML2Util.getMessageSubstitutions(context, classifier, otherGeneral, general)), new Object[]{classifier, otherGeneral}));
                        continue block1;
                    }
                }
            }
        }

        protected void processOptions(Map options, DiagnosticChain diagnostics, Map context) {
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__DIFFERENT_PROPERTY_STATICITY))) {
                this.processDifferentPropertyStaticity(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__DIFFERENT_PROPERTY_UNIQUENESS))) {
                this.processDifferentPropertyUniqueness(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__REDUNDANT_GENERALIZATIONS))) {
                this.processRedundantGeneralizations(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__IMPLICIT_REDEFINITIONS))) {
                this.processImplicitRedefinitions(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__INVALID_REDEFINITIONS))) {
                this.processInvalidRedefinitions(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__INVALID_SUBSETS))) {
                this.processInvalidSubsets(options, diagnostics, context);
            }
            if (!UML2Util.OPTION__IGNORE.equals(options.get(OPTION__EMPTY_UNIONS))) {
                this.processEmptyUnions(options, diagnostics, context);
            }
        }

        public void merge(Package package_, Map options, DiagnosticChain diagnostics, Map context) {
            this.receivingPackage = package_;
            this.mergedPackages = this.getAllMergedPackages(package_);
            this.copyAll(this.mergedPackages);
            this.copyReferences();
            this.receivingPackage.getPackageMerges().clear();
            if (options != null) {
                this.processOptions(options, diagnostics, context);
            }
        }

        static /* synthetic */ EObject access$0(PackageMerger packageMerger, EObject eObject) {
            return super.createCopy(eObject);
        }

        protected class BodyMatcher
        extends EClassMatcher {
            protected BodyMatcher(Comment comment) {
                super((EObject)comment);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && (this.eObject == null && otherEObject == null || ((Comment)this.eObject).getBody().equals(((Comment)otherEObject).getBody()));
            }
        }

        protected class NameMatcher
        extends EClassMatcher {
            protected NameMatcher(NamedElement namedElement) {
                super((EObject)namedElement);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && (this.eObject == null && otherEObject == null || ((NamedElement)this.eObject).getName().equals(((NamedElement)otherEObject).getName()));
            }
        }

        protected class KeyMatcher
        extends EClassMatcher {
            protected KeyMatcher(BasicEMap.Entry entry) {
                super((EObject)entry);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && (this.eObject == null && otherEObject == null || ((BasicEMap.Entry)this.eObject).getKey().equals(((BasicEMap.Entry)otherEObject).getKey()));
            }
        }

        protected class ResultingQNameMatcher
        extends EClassMatcher {
            protected ResultingQNameMatcher(EObject eObject) {
                super(eObject);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && (this.eObject == null && otherEObject == null || PackageMerger.this.getResultingQName(this.eObject).equals(PackageMerger.this.getResultingQName(otherEObject)));
            }
        }

        protected class StringValueMatcher
        extends EClassMatcher {
            protected StringValueMatcher(ValueSpecification valueSpecification) {
                super((EObject)valueSpecification);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && (this.eObject == null && otherEObject == null || ((ValueSpecification)this.eObject).stringValue().equals(((ValueSpecification)otherEObject).stringValue()));
            }
        }

        protected class SourceMatcher
        extends EClassMatcher {
            protected SourceMatcher(EAnnotation eAnnotation) {
                super((EObject)eAnnotation);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && (this.eObject == null && otherEObject == null || ((EAnnotation)this.eObject).getSource().equals(((EAnnotation)otherEObject).getSource()));
            }
        }

        protected class TypeMatcher
        extends NameMatcher {
            protected TypeMatcher(TypedElement typedElement) {
                super(typedElement);
            }

            public boolean matches(EObject otherEObject) {
                return super.matches(otherEObject) && (this.eObject == null && otherEObject == null || new ResultingQNameMatcher((EObject)((TypedElement)this.eObject).getType()).matches((EObject)((TypedElement)otherEObject).getType()));
            }
        }
    }
}

