/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.util.UML2Util;
import org.osgi.framework.Bundle;

class UML2Operations
extends UML2Util {
    private static final URIConverter DEFAULT_URI_CONVERTER = new URIConverterImpl();
    private static final Map RESOURCE_BUNDLES = Collections.synchronizedMap(new HashMap());

    UML2Operations() {
    }

    protected static EAnnotation safeGetEAnnotation(EModelElement eModelElement, String source) {
        EAnnotation eAnnotation = eModelElement == null ? null : UML2Operations.getEAnnotation(eModelElement, source, false);
        return eAnnotation == null ? EcoreFactory.eINSTANCE.createEAnnotation() : eAnnotation;
    }

    private static List getResourceBundleURIs(URI baseURI, String baseSegment, Locale locale) {
        ArrayList<URI> resourceBundleURIs = new ArrayList<URI>();
        String language = locale.getLanguage();
        if (language.length() > 0) {
            baseSegment = String.valueOf(baseSegment) + '_' + language;
            resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension("properties"));
            String country = locale.getCountry();
            if (country.length() > 0) {
                baseSegment = String.valueOf(baseSegment) + '_' + country;
                resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension("properties"));
                String variant = locale.getVariant();
                if (variant.length() > 0) {
                    baseSegment = String.valueOf(baseSegment) + '_' + variant;
                    resourceBundleURIs.add(0, baseURI.appendSegment(baseSegment).appendFileExtension("properties"));
                }
            }
        }
        return resourceBundleURIs;
    }

    protected static List getResourceBundleURIs(URI uri, Locale locale) {
        ArrayList<URI> resourceBundleURIs = new ArrayList<URI>();
        URI baseURI = uri.trimSegments(1);
        String baseSegment = uri.trimFileExtension().lastSegment();
        resourceBundleURIs.add(baseURI.appendSegment(baseSegment).appendFileExtension("properties"));
        if (locale != null) {
            Locale defaultLocale = Locale.getDefault();
            resourceBundleURIs.addAll(0, UML2Operations.getResourceBundleURIs(baseURI, baseSegment, defaultLocale));
            if (!defaultLocale.equals(locale)) {
                resourceBundleURIs.addAll(0, UML2Operations.getResourceBundleURIs(baseURI, baseSegment, locale));
            }
        }
        return resourceBundleURIs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static ResourceBundle getResourceBundle(EObject eObject, Locale locale) {
        ResourceBundle resourceBundle;
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        Map<Locale, ResourceBundle> resourceBundles = (Map<Locale, ResourceBundle>)RESOURCE_BUNDLES.get(resource);
        if (resourceBundles == null) {
            resourceBundles = Collections.synchronizedMap(new HashMap());
            RESOURCE_BUNDLES.put(resource, resourceBundles);
        }
        if ((resourceBundle = (ResourceBundle)resourceBundles.get(locale)) == null) {
            ResourceSet resourceSet = resource.getResourceSet();
            URIConverter uriConverter = resourceSet == null ? DEFAULT_URI_CONVERTER : resourceSet.getURIConverter();
            URI uri = resource.getURI();
            List resourceBundleURIs = UML2Operations.getResourceBundleURIs(uri, locale);
            if (EcorePlugin.IS_ECLIPSE_RUNNING) {
                Bundle[] fragments;
                Bundle bundle;
                URI normalizedURI = uriConverter.normalize(uri);
                int segmentCount = normalizedURI.segmentCount();
                if ("platform".equals(normalizedURI.scheme()) && segmentCount > 2 && "plugin".equals(normalizedURI.segment(0)) && (bundle = Platform.getBundle((String)normalizedURI.segment(1))) != null && (fragments = Platform.getFragments((Bundle)bundle)) != null) {
                    String[] trailingSegments = normalizedURI.segmentsList().subList(2, segmentCount).toArray(new String[0]);
                    int i = 0;
                    while (i < fragments.length) {
                        resourceBundleURIs.addAll(0, UML2Operations.getResourceBundleURIs(normalizedURI.trimSegments(segmentCount - 1).appendSegment(fragments[i].getSymbolicName()).appendSegments(trailingSegments), locale));
                        ++i;
                    }
                }
            }
            Iterator i = resourceBundleURIs.iterator();
            while (i.hasNext()) {
                try {
                    Object var11_12;
                    InputStream inputStream = uriConverter.createInputStream((URI)i.next());
                    try {
                        resourceBundle = new PropertyResourceBundle(inputStream);
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    {
                        var11_12 = null;
                        inputStream.close();
                        break;
                    }
                }
                catch (IOException iOException) {}
            }
            resourceBundles.put(locale, resourceBundle);
        }
        return resourceBundle;
    }

    protected static ResourceBundle getResourceBundle(EObject eObject, boolean localize) {
        return UML2Operations.getResourceBundle(eObject, localize ? Locale.getDefault() : null);
    }

    protected static String getString(EObject eObject, String key, String defaultString, boolean localize) {
        String string = defaultString;
        if (eObject != null) {
            try {
                ResourceBundle resourceBundle = UML2Operations.getResourceBundle(eObject, localize);
                if (resourceBundle != null) {
                    string = resourceBundle.getString(key);
                }
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string;
    }

    protected static class FilteredECrossReferenceEList
    extends ECrossReferenceEList {
        private final FilteredUsageCrossReferencer.Filter filter;

        protected FilteredECrossReferenceEList(EObject eObject, FilteredUsageCrossReferencer.Filter filter) {
            super(eObject);
            this.filter = filter;
        }

        protected FilteredECrossReferenceEList(EObject eObject, EStructuralFeature[] eStructuralFeatures, FilteredUsageCrossReferencer.Filter filter) {
            super(eObject, eStructuralFeatures);
            this.filter = filter;
        }

        protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
            return super.isIncluded(eStructuralFeature) && this.filter.accept(eStructuralFeature);
        }

        protected ListIterator newListIterator() {
            return this.resolve() ? new FilteredResolvingFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.filter) : new FilteredFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.filter);
        }

        public List basicList() {
            return new FilteredECrossReferenceEList(this, this.eObject, this.eStructuralFeatures, this.filter){
                final /* synthetic */ FilteredECrossReferenceEList this$1;
                {
                    this.this$1 = filteredECrossReferenceEList;
                }

                protected boolean resolve() {
                    return false;
                }
            };
        }

        public Iterator basicIterator() {
            if (this.eStructuralFeatures == null) {
                return FilteredFeatureIteratorImpl.EMPTY_ITERATOR;
            }
            return new FilteredFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.filter);
        }

        public ListIterator basicListIterator() {
            if (this.eStructuralFeatures == null) {
                return ECrossReferenceEList.FeatureIteratorImpl.EMPTY_ITERATOR;
            }
            return new FilteredFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.filter);
        }

        public ListIterator basicListIterator(int index) {
            if (this.eStructuralFeatures == null) {
                if (index < 0 || 1 < index) {
                    throw new IndexOutOfBoundsException("index = " + index + ", size = 0");
                }
                return FilteredFeatureIteratorImpl.EMPTY_ITERATOR;
            }
            FilteredFeatureIteratorImpl result = new FilteredFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.filter);
            int i = 0;
            while (i < index) {
                result.next();
                ++i;
            }
            return result;
        }

        protected static class FilteredFeatureIteratorImpl
        extends ECrossReferenceEList.FeatureIteratorImpl {
            private final FilteredUsageCrossReferencer.Filter filter;

            public FilteredFeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures, FilteredUsageCrossReferencer.Filter filter) {
                super(eObject, eStructuralFeatures);
                this.filter = filter;
            }

            protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
                return super.isIncluded(eStructuralFeature) && this.filter.accept(eStructuralFeature);
            }

            protected boolean isIncludedEntry(EStructuralFeature eStructuralFeature) {
                return super.isIncludedEntry(eStructuralFeature) && this.filter.accept(eStructuralFeature);
            }
        }

        protected static class FilteredResolvingFeatureIteratorImpl
        extends FilteredFeatureIteratorImpl {
            public FilteredResolvingFeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures, FilteredUsageCrossReferencer.Filter filter) {
                super(eObject, eStructuralFeatures, filter);
            }

            protected boolean resolve() {
                return true;
            }
        }
    }

    protected static class FilteredUsageCrossReferencer
    extends EcoreUtil.UsageCrossReferencer {
        private final Filter filter;

        public static Collection find(EObject eObject, ResourceSet resourceSet, Filter filter) {
            return new FilteredUsageCrossReferencer(resourceSet, filter).findUsage(eObject);
        }

        protected static Collection find(EObject eObject, Resource resource, Filter filter) {
            return new FilteredUsageCrossReferencer(resource, filter).findUsage(eObject);
        }

        protected FilteredUsageCrossReferencer(ResourceSet resourceSet, Filter filter) {
            super(resourceSet);
            this.filter = filter;
        }

        protected FilteredUsageCrossReferencer(Resource resource, Filter filter) {
            super(resource);
            this.filter = filter;
        }

        protected void handleCrossReference(EObject eObject) {
            FilteredECrossReferenceEList filteredCrossReferences = new FilteredECrossReferenceEList(eObject, this.filter);
            EContentsEList.FeatureIterator crossReferences = (EContentsEList.FeatureIterator)(this.resolve() ? filteredCrossReferences.iterator() : filteredCrossReferences.basicIterator());
            while (crossReferences.hasNext()) {
                EObject crossReferencedEObject = (EObject)crossReferences.next();
                EReference eReference = (EReference)crossReferences.feature();
                if (!this.crossReference(eObject, eReference, crossReferencedEObject)) continue;
                this.getCollection(crossReferencedEObject).add(((InternalEObject)eObject).eSetting((EStructuralFeature)eReference));
            }
        }

        protected static interface Filter {
            public boolean accept(EStructuralFeature var1);
        }
    }
}

