/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metabase.internal.platform;

import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.platform.RemoteResourceImpl;
import com.metamatrix.common.comm.platform.server.MessageServiceAgent;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.core.factory.FactoryStrategy;
import com.metamatrix.core.factory.ThreadLocalFactoryStrategy;
import com.metamatrix.core.proxy.SecurityContextFactory;
import com.metamatrix.core.proxy.ServerSecurityServiceInterceptor;
import com.metamatrix.core.proxy.ServiceInterceptor;
import com.metamatrix.core.proxy.ServiceProxyFactory;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;
import com.metamatrix.metabase.internal.platform.ConnectionPoolImpl;
import com.metamatrix.metabase.internal.platform.DirectoryServiceSecurityInterceptor;
import com.metamatrix.metabase.internal.platform.PlatformRepositoryAuthorizationService;
import com.metamatrix.metabase.platform.DirectoryService;
import com.metamatrix.metabase.platform.MetabasePlatformPlugin;
import com.metamatrix.metabase.repository.RepositoryCommandFactory;
import com.metamatrix.metabase.repository.api.IRepository;
import com.metamatrix.metabase.repository.internal.interceptor.AuthorizationInterceptor;
import com.metamatrix.metabase.repository.internal.interceptor.IndexingServiceInterceptor;
import com.metamatrix.metabase.repository.internal.interceptor.JdbcConnectionContextFactory;
import com.metamatrix.metabase.repository.internal.interceptor.JdbcConnectionInterceptor;
import com.metamatrix.metabase.repository.internal.interceptor.JdbcRepositoryInterceptor;
import com.metamatrix.metabase.repository.internal.interceptor.JdbcRepositoryInterceptorAdapter;
import com.metamatrix.metabase.repository.internal.interceptor.JdbcTransactionInterceptor;
import com.metamatrix.metabase.repository.internal.interceptor.RepositoryAuthorizationService;
import com.metamatrix.metabase.repository.jdbc.ConnectionPool;
import com.metamatrix.metabase.repository.jdbc.commands.JDBCCommandFactory;
import com.metamatrix.platform.resource.RemoteResource;
import java.sql.Connection;
import java.util.Properties;

public class DirectoryServiceComponent {
    private ConnectionPoolImpl connectionPool;
    private RemoteResource remoteObject;
    private DirectoryService legacyRemoteObject;
    private IRepository localObject;
    private String dbmsString;
    private ServiceInterceptor[] serviceInterceptor;
    private TerminalServiceInterceptor terminalServiceInterceptor;
    private boolean useLocalConfiguration = false;
    static /* synthetic */ Class class$com$metamatrix$metabase$platform$DirectoryService;
    static /* synthetic */ Class class$com$metamatrix$metabase$repository$api$IRepository;

    public void initialize(Properties env) throws ConfigurationException {
        this.connectionPool = new ConnectionPoolImpl(env);
        this.loadComponents(env);
    }

    void setUseLocalConfiguration() {
        this.useLocalConfiguration = true;
    }

    void loadComponents(Properties env) throws ConfigurationException {
        this.dbmsString = this.getDbmsString(env);
        JdbcConnectionContextFactory connectionContextFactory = new JdbcConnectionContextFactory((FactoryStrategy)new ThreadLocalFactoryStrategy());
        JDBCCommandFactory commandFactory = new JDBCCommandFactory(this.dbmsString, connectionContextFactory);
        SecurityContextFactory serverSecurityContextFactory = new SecurityContextFactory((FactoryStrategy)new ThreadLocalFactoryStrategy());
        SecurityContextFactory hardCodedServerSecurityContextFactory = new SecurityContextFactory((FactoryStrategy)new ThreadLocalFactoryStrategy(), "MetaMatrixAdmin");
        JdbcConnectionInterceptor connectionInterceptor = new JdbcConnectionInterceptor((ConnectionPool)this.connectionPool, serverSecurityContextFactory, connectionContextFactory);
        JdbcConnectionInterceptor hardCodedConnectionInterceptor = new JdbcConnectionInterceptor((ConnectionPool)this.connectionPool, hardCodedServerSecurityContextFactory, connectionContextFactory);
        JdbcTransactionInterceptor transactionInterceptor = new JdbcTransactionInterceptor(connectionContextFactory);
        String prop = CurrentConfiguration.getProperty((String)"metamatrix.authorization.metabase.CheckingEnabled");
        boolean checkingAuthorization = prop != null && prop.equalsIgnoreCase(Boolean.TRUE.toString());
        AuthorizationInterceptor authorizationInterceptor = new AuthorizationInterceptor(serverSecurityContextFactory, (RepositoryAuthorizationService)new PlatformRepositoryAuthorizationService(), checkingAuthorization, (RepositoryCommandFactory)commandFactory);
        this.configureRemoteObject(commandFactory, serverSecurityContextFactory, connectionInterceptor, transactionInterceptor, authorizationInterceptor);
        this.configureLegacyRemoteObject(commandFactory, serverSecurityContextFactory, connectionInterceptor, transactionInterceptor, authorizationInterceptor);
        this.configureLocalObject(commandFactory, hardCodedServerSecurityContextFactory, hardCodedConnectionInterceptor, transactionInterceptor);
    }

    void configureLegacyRemoteObject(JDBCCommandFactory commandFactory, SecurityContextFactory serverSecurityContextFactory, JdbcConnectionInterceptor connectionInterceptor, JdbcTransactionInterceptor transactionInterceptor, AuthorizationInterceptor authorizationInterceptor) {
        IndexingServiceInterceptor indexingServiceInterceptor = new IndexingServiceInterceptor(serverSecurityContextFactory);
        ServiceInterceptor[] interceptors = new ServiceInterceptor[]{new DirectoryServiceSecurityInterceptor(serverSecurityContextFactory), connectionInterceptor, indexingServiceInterceptor, authorizationInterceptor, transactionInterceptor};
        JdbcRepositoryInterceptorAdapter adapter = new JdbcRepositoryInterceptorAdapter((RepositoryCommandFactory)commandFactory);
        this.legacyRemoteObject = (DirectoryService)new ServiceProxyFactory().create(class$com$metamatrix$metabase$platform$DirectoryService == null ? (class$com$metamatrix$metabase$platform$DirectoryService = DirectoryServiceComponent.class$("com.metamatrix.metabase.platform.DirectoryService")) : class$com$metamatrix$metabase$platform$DirectoryService, interceptors, (TerminalServiceInterceptor)adapter);
    }

    void configureRemoteObject(JDBCCommandFactory commandFactory, SecurityContextFactory serverSecurityContextFactory, JdbcConnectionInterceptor connectionInterceptor, JdbcTransactionInterceptor transactionInterceptor, AuthorizationInterceptor authorizationInterceptor) {
        IndexingServiceInterceptor indexingServiceInterceptor = new IndexingServiceInterceptor(serverSecurityContextFactory);
        ServiceInterceptor[] interceptors = new ServiceInterceptor[]{new ServerSecurityServiceInterceptor(serverSecurityContextFactory), connectionInterceptor, indexingServiceInterceptor, authorizationInterceptor, transactionInterceptor};
        this.serviceInterceptor = interceptors;
        JdbcRepositoryInterceptor terminalInterceptor = new JdbcRepositoryInterceptor((RepositoryCommandFactory)commandFactory, serverSecurityContextFactory);
        this.terminalServiceInterceptor = terminalInterceptor;
        MessageServiceAgent serviceAgent = new MessageServiceAgent(class$com$metamatrix$metabase$repository$api$IRepository == null ? (class$com$metamatrix$metabase$repository$api$IRepository = DirectoryServiceComponent.class$("com.metamatrix.metabase.repository.api.IRepository")) : class$com$metamatrix$metabase$repository$api$IRepository, interceptors, (TerminalServiceInterceptor)terminalInterceptor);
        this.remoteObject = new RemoteResourceImpl((ServerListener)serviceAgent);
    }

    void configureLocalObject(JDBCCommandFactory commandFactory, SecurityContextFactory serverSecurityContextFactory, JdbcConnectionInterceptor connectionInterceptor, JdbcTransactionInterceptor transactionInterceptor) {
        ServiceInterceptor[] interceptors = new ServiceInterceptor[]{connectionInterceptor, transactionInterceptor};
        JdbcRepositoryInterceptor terminalInterceptor = new JdbcRepositoryInterceptor((RepositoryCommandFactory)commandFactory, serverSecurityContextFactory);
        this.localObject = (IRepository)new ServiceProxyFactory().create(class$com$metamatrix$metabase$repository$api$IRepository == null ? (class$com$metamatrix$metabase$repository$api$IRepository = DirectoryServiceComponent.class$("com.metamatrix.metabase.repository.api.IRepository")) : class$com$metamatrix$metabase$repository$api$IRepository, interceptors, (TerminalServiceInterceptor)terminalInterceptor);
    }

    public void stop() {
        this.connectionPool = null;
    }

    public String getDbmsString() {
        return this.dbmsString;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDbmsString(Properties env) throws ConfigurationException {
        Connection conn;
        String driverName;
        block22: {
            JDBCPlatform platform;
            block21: {
                block20: {
                    block19: {
                        driverName = this.getDriverName(env);
                        if (driverName.indexOf("oracle") > -1) {
                            this.dbmsString = "oracle";
                            return this.dbmsString;
                        }
                        if (driverName.indexOf("db2") > -1) {
                            this.dbmsString = "db2";
                            return this.dbmsString;
                        }
                        if (driverName.indexOf("sybase") > -1) {
                            this.dbmsString = "sybase";
                            return this.dbmsString;
                        }
                        if (driverName.indexOf("sqlserver") > -1) {
                            this.dbmsString = "sqlserver";
                            return this.dbmsString;
                        }
                        if (driverName.indexOf("derby") > -1) {
                            this.dbmsString = "derby";
                            return this.dbmsString;
                        }
                        if (driverName.indexOf("sequelink") <= -1) throw new ConfigurationException(MetabasePlatformPlugin.Util.getString("DirectoryServiceImpl.Unsupported_driver__{0}._2", (Object)driverName));
                        conn = null;
                        conn = this.connectionPool.getConnection("DirectoryService");
                        platform = JDBCPlatformFactory.getPlatform((Connection)conn);
                        if (!platform.isOracle()) break block19;
                        String string = this.dbmsString = "oracle";
                        Object var7_10 = null;
                        if (conn == null) return string;
                        try {
                            conn.close();
                            return string;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        return string;
                    }
                    if (!platform.isDB2()) break block20;
                    String string = this.dbmsString = "db2";
                    Object var7_11 = null;
                    if (conn == null) return string;
                    try {
                        conn.close();
                        return string;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return string;
                }
                if (!platform.isSybase()) break block21;
                String string = this.dbmsString = "sybase";
                Object var7_12 = null;
                if (conn == null) return string;
                try {
                    conn.close();
                    return string;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return string;
            }
            if (!platform.isMSSQL()) break block22;
            String string = this.dbmsString = "sqlserver";
            Object var7_13 = null;
            if (conn == null) return string;
            try {
                conn.close();
                return string;
            }
            catch (Exception e) {
                // empty catch block
            }
            return string;
        }
        try {
            Object var7_14 = null;
            if (conn == null) throw new ConfigurationException(MetabasePlatformPlugin.Util.getString("DirectoryServiceImpl.Unsupported_driver__{0}._2", (Object)driverName));
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            conn.close();
            throw new ConfigurationException(MetabasePlatformPlugin.Util.getString("DirectoryServiceImpl.Unsupported_driver__{0}._2", (Object)driverName));
        }
        catch (Exception e) {}
        throw new ConfigurationException(MetabasePlatformPlugin.Util.getString("DirectoryServiceImpl.Unsupported_driver__{0}._2", (Object)driverName));
        {
            catch (Exception err) {
                throw new ConfigurationException(MetabasePlatformPlugin.Util.getString("DirectoryServiceImpl.Unsupported_driver__{0}._2", (Object)driverName));
            }
        }
    }

    private String getDriverName(Properties env) throws ConfigurationException {
        String driverName = null;
        if (this.useLocalConfiguration || CurrentConfiguration.getConfiguration() == null) {
            driverName = ((String)env.get("metamatrix.common.pooling.jdbc.Driver")).toLowerCase();
        } else {
            String poolName;
            ResourceDescriptor descr;
            Properties props = CurrentConfiguration.getResourceProperties((String)"DirectoryService");
            if (props != null && (descr = CurrentConfiguration.getResourceDescriptor((String)(poolName = props.getProperty("metamatrix.common.pooling.resource.name")))) != null) {
                driverName = descr.getProperty("metamatrix.common.pooling.jdbc.Driver");
            }
        }
        if (driverName == null) {
            throw new ConfigurationException(MetabasePlatformPlugin.Util.getString("DirectoryServiceImpl.No_driver_name_provided._1"));
        }
        return driverName;
    }

    public ConnectionPoolImpl getConnectionPool() {
        return this.connectionPool;
    }

    public DirectoryService getLegacyRemoteObject() {
        return this.legacyRemoteObject;
    }

    public RemoteResource getRemoteObject() {
        return this.remoteObject;
    }

    public IRepository getLocalObject() {
        return this.localObject;
    }

    public ServiceInterceptor[] getServiceInterceptors() {
        return this.serviceInterceptor;
    }

    public TerminalServiceInterceptor getTerminalServiceInterceptor() {
        return this.terminalServiceInterceptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

