/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xa.atomikos;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.jdbc.JdbcTransactionalResource;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.ExportingTransactionManager;
import com.atomikos.icatch.Extent;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.ImportingTransactionManager;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TSInitInfo;
import com.atomikos.icatch.UnavailableException;
import com.atomikos.icatch.UserTransactionService;
import com.atomikos.icatch.UserTransactionServiceImp;
import com.atomikos.icatch.admin.LogAdministrator;
import com.atomikos.icatch.jta.ExtendedSystemException;
import com.atomikos.icatch.jta.UserTransactionServer;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.CommonXAPlugin;
import com.metamatrix.common.xa.ConnectorTransactionManager;
import com.metamatrix.common.xa.MMTransactionManager;
import com.metamatrix.common.xa.MMUserTransactionServer;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.common.xa.atomikos.TransactionContextImpl;
import com.metamatrix.common.xa.atomikos.TransactionIDImpl;
import com.metamatrix.common.xa.atomikos.TransactionResultImpl;
import com.metamatrix.common.xa.atomikos.UserTransactionServerWrapper;
import com.metamatrix.common.xa.atomikos.xaresource.XALogAdministrator;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.StringUtil;
import java.io.File;
import java.net.UnknownHostException;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class MMTransactionManagerImpl
implements MMTransactionManager,
ConnectorTransactionManager {
    private static final String CTX = "XA_TXN";
    private static MMTransactionManagerImpl ourInstance;
    private LogAdministrator logAdministrator;
    private static Map xaresourceToTranresource;
    private transient UserTransactionServer txnServer;
    private static UserTransactionService txnSvc;
    private int defaultTxnTimeout;
    private String initialContextFactory;
    private String txnMgrUniqueName;
    private String vmID = new VMID().toString();
    static /* synthetic */ Class class$com$atomikos$icatch$jta$UserTransactionServer;

    public static synchronized MMTransactionManagerImpl getInstance(String vmName) throws XATransactionException {
        if (ourInstance == null) {
            MMTransactionManagerImpl thisInstance = new MMTransactionManagerImpl();
            xaresourceToTranresource = new HashMap();
            thisInstance.init(vmName);
            ourInstance = thisInstance;
        }
        return ourInstance;
    }

    private MMTransactionManagerImpl() {
    }

    private void init(String vmName) throws XATransactionException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.init(" + vmName + ")"));
        Properties tmProps = new Properties();
        LogManager.logInfo((String)CTX, (String)CommonXAPlugin.Util.getString("MSG.003.031.0002", (Object)vmName));
        try {
            tmProps = this.getTRMIProps(vmName);
            if (LogManager.isMessageToBeRecorded((String)CTX, (int)5) || LogManager.isMessageToBeRecorded((String)CTX, (int)6)) {
                tmProps.setProperty("com.atomikos.icatch.console_log_level", "DEBUG");
            } else {
                tmProps.setProperty("com.atomikos.icatch.console_log_level", "WARN");
            }
            this.printProps(tmProps, "XA Transaction Manager Property");
            this.checkForLockFile(tmProps);
            txnSvc = new UserTransactionServiceImp(tmProps);
            this.logAdministrator = new XALogAdministrator();
            LogManager.logDetail((String)CTX, (String)"Registering log admin...");
            txnSvc.registerLogAdministrator(this.logAdministrator);
            LogManager.logDetail((String)CTX, (String)"Log admin registerd.");
        }
        catch (SysException e2) {
            String msg = MMTransactionManagerImpl.flattenSysException(e2);
            XATransactionException te = new XATransactionException(msg.toString());
            LogManager.logError((String)CTX, (Throwable)te, (String)CommonXAPlugin.Util.getString("ERR.003.031.0002"));
            throw te;
        }
        catch (Throwable e3) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0001", (Object)e3.getMessage());
            XATransactionException te = new XATransactionException(e3, msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        try {
            TSInitInfo tmInfo = txnSvc.createTSInitInfo();
            txnSvc.init(tmInfo);
        }
        catch (SysException e4) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0001", (Object)MMTransactionManagerImpl.flattenSysException(e4));
            XATransactionException te = new XATransactionException((Throwable)e4, msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        catch (Throwable e5) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0001", (Object)e5.getMessage());
            XATransactionException te = new XATransactionException(e5, msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        try {
            txnSvc.getTransactionManager().setTransactionTimeout(this.defaultTxnTimeout);
        }
        catch (SystemException e6) {
            String msg = e6.getMessage();
            LogManager.logError((String)CTX, (Throwable)e6, (String)CommonXAPlugin.Util.getString("ERR.003.031.0003"));
            throw new XATransactionException(msg.toString());
        }
        this.testTxnMgr();
        LogManager.logInfo((String)CTX, (String)CommonXAPlugin.Util.getString("MSG.003.031.0003", (Object)vmName));
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.init(" + vmName + ")"));
    }

    public static boolean isInitialized() {
        return ourInstance != null;
    }

    public static synchronized void shutdown(boolean force) throws XATransactionException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.shutdown(" + (force ? "force" : "no-force") + ")"));
        if (ourInstance != null) {
            try {
                txnSvc.shutdown(force);
            }
            catch (IllegalStateException e2) {
                String msg = CommonXAPlugin.Util.getString("ERR.003.031.0004");
                LogManager.logError((String)CTX, (Throwable)e2, (String)msg);
                throw new XATransactionException((Throwable)e2, msg);
            }
            catch (Throwable e3) {
                String msg = CommonXAPlugin.Util.getString("ERR.003.031.0004");
                LogManager.logError((String)CTX, (Throwable)e3, (String)msg);
                throw new XATransactionException(e3, msg);
            }
        }
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.shutdown(" + (force ? "force" : "no-force") + ")"));
    }

    public TransactionContext resumeTransaction(TransactionContext context, XAResource res) throws XATransactionException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.resumeTransaction(" + context + ")"));
        CompositeTransactionManager ctm = txnSvc.getCompositeTransactionManager();
        CompositeTransaction ct = null;
        String txnID = ((TransactionContextImpl)context).getTransactionID(this.vmID, res);
        try {
            ct = ctm.getCompositeTransaction(txnID);
        }
        catch (SysException e2) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0005", (Object)MMTransactionManagerImpl.flattenSysException(e2).toString());
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        if (ct == null) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0006");
            LogManager.logError((String)CTX, (String)msg);
            throw new XATransactionException(msg);
        }
        try {
            ctm.resume(ct);
        }
        catch (IllegalStateException e3) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0005", (Object)e3.getMessage());
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        catch (SysException e4) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0005", (Object)MMTransactionManagerImpl.flattenSysException(e4).toString());
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.resumeTransaction(" + context + ")"));
        return context;
    }

    public TransactionContext resumeTransaction(String txnID) throws XATransactionException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.resumeTransaction(" + txnID + ")"));
        CompositeTransactionManager ctm = txnSvc.getCompositeTransactionManager();
        CompositeTransaction ct = null;
        try {
            ct = ctm.getCompositeTransaction(txnID);
        }
        catch (SysException e2) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0005", (Object)MMTransactionManagerImpl.flattenSysException(e2).toString());
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        if (ct == null) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0006");
            LogManager.logError((String)CTX, (String)msg);
            throw new XATransactionException(msg);
        }
        try {
            ctm.resume(ct);
        }
        catch (IllegalStateException e3) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0005", (Object)e3.getMessage());
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        catch (SysException e4) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0005", (Object)MMTransactionManagerImpl.flattenSysException(e4).toString());
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.resumeTransaction(" + txnID + ")"));
        return new TransactionContextImpl((TransactionID)new TransactionIDImpl(txnID));
    }

    public TransactionContext startSubTransaction(TransactionContext context, XAResource res) throws XATransactionException {
        this.resumeTransaction(context, null);
        LogManager.logDetail((String)CTX, (String)("TxnMgr.startSubTransaction(" + context + ")"));
        String txnID = null;
        try {
            TransactionManager tm = this.getTransactionManager();
            tm.begin();
            txnID = tm.getTransaction().toString();
            LogManager.logDetail((String)CTX, (String)("TxnMgr.startSubTransaction( New TID: " + txnID + ")"));
        }
        catch (NotSupportedException e2) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0046");
            XATransactionException xax = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)xax, (String)msg);
            throw xax;
        }
        catch (ExtendedSystemException e3) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0048");
            String errorMsgs = this.flattenExtendedSystemException(e3, msg);
            XATransactionException ex2 = new XATransactionException(errorMsgs);
            I18nLogManager.logError((String)CTX, (String)errorMsgs);
            throw ex2;
        }
        catch (SystemException e4) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0048");
            XATransactionException xax = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)xax, (String)msg);
            throw xax;
        }
        if (txnID == null) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0047");
            XATransactionException xax = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)xax, (String)msg);
            throw xax;
        }
        ((TransactionContextImpl)context).addSubTxnID(txnID, res);
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.startSubTransaction(" + context + ")"));
        return context;
    }

    public TransactionContext suspendTransaction(TransactionContext context) throws XATransactionException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.suspendTransaction(" + context + ")"));
        CompositeTransactionManager ctm = txnSvc.getCompositeTransactionManager();
        String txnID = ctm.getCompositeTransaction().getTid();
        LogManager.logDetail((String)CTX, (String)("TxnMgr.suspendTransaction( suspending TID: " + txnID + ")"));
        try {
            ctm.suspend();
        }
        catch (SysException e2) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0007", (Object)MMTransactionManagerImpl.flattenSysException(e2).toString());
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.suspendTransaction(" + context + ")"));
        return context;
    }

    public TransactionContext exportTransaction(TransactionContext context) throws XATransactionException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.exportTransaction(" + context + ")"));
        ExportingTransactionManager exptm = txnSvc.getExportingTransactionManager();
        Propagation propagation = null;
        try {
            propagation = exptm.getPropagation();
        }
        catch (SysException e2) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0008", (Object)MMTransactionManagerImpl.flattenSysException(e2).toString());
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        if (propagation == null) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0009");
            LogManager.logError((String)CTX, (String)msg);
            throw new XATransactionException(msg);
        }
        ((TransactionContextImpl)context).setPropagation(propagation);
        ((TransactionContextImpl)context).setExportingVmID(this.vmID);
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.exportTransaction(" + context + ")"));
        return context;
    }

    public TransactionContext importTransaction(TransactionContext context, XAResource res) throws XATransactionException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.importTransaction(" + context + ")"));
        if (this.vmID.equals(((TransactionContextImpl)context).getExportingVmID())) {
            this.startSubTransaction(context, res);
        } else {
            Propagation propagation = ((TransactionContextImpl)context).getPropagation();
            if (propagation == null) {
                String msg = CommonXAPlugin.Util.getString("ERR.003.031.0044");
                LogManager.logError((String)CTX, (String)msg);
                throw new XATransactionException(msg);
            }
            ImportingTransactionManager imptm = txnSvc.getImportingTransactionManager();
            if (imptm == null) {
                String msg = CommonXAPlugin.Util.getString("ERR.003.031.0010");
                LogManager.logError((String)CTX, (String)msg);
                throw new XATransactionException(msg);
            }
            try {
                CompositeTransaction ct = imptm.importTransaction(propagation, false, false);
                LogManager.logDetail((String)CTX, (String)("TxnMgr.importTransaction() - New TID: " + ct.getTid()));
                ((TransactionContextImpl)context).setVMTxnID(this.vmID, ct.getTid());
                ((TransactionContextImpl)context).addSubTxnID(ct.getTid(), res);
            }
            catch (SysException e2) {
                String msg = CommonXAPlugin.Util.getString("ERR.003.031.0011", (Object)MMTransactionManagerImpl.flattenSysException(e2).toString());
                XATransactionException te = new XATransactionException(msg);
                LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                throw te;
            }
        }
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.importTransaction(" + context + ")"));
        return context;
    }

    public TransactionContext addTransactionResult(TransactionContext context) throws XATransactionException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.addTransactionResult(" + context + ")"));
        if (context == null) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0012");
            LogManager.logError((String)CTX, (String)msg);
            throw new XATransactionException(msg);
        }
        if (context.hasResult()) {
            Extent theExtent = (Extent)context.getTransactionResult().getExtent();
            if (theExtent == null) {
                String msg = CommonXAPlugin.Util.getString("ERR.003.031.0013");
                LogManager.logError((String)CTX, (String)msg);
                throw new XATransactionException(msg);
            }
            ExportingTransactionManager exptm = txnSvc.getExportingTransactionManager();
            try {
                exptm.addExtent(theExtent);
            }
            catch (SysException e2) {
                String msg = MMTransactionManagerImpl.flattenSysException(e2);
                XATransactionException te = new XATransactionException(CommonXAPlugin.Util.getString("ERR.003.031.0011", (Object)msg.toString()));
                LogManager.logError((String)CTX, (Throwable)te, (String)msg.toString());
                throw te;
            }
        }
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.addTransactionResult(" + context + ")"));
        return context;
    }

    /*
     * Loose catch block
     */
    public TransactionContext terminateSubTransaction(TransactionContext context, boolean success) throws XATransactionException {
        block29: {
            Extent extent;
            String txnID;
            block26: {
                block28: {
                    LogManager.logDetail((String)CTX, (String)("TxnMgr.terminateSubTransaction(" + context + ", " + (success ? "success" : "failed") + ")"));
                    if (!this.vmID.equals(((TransactionContextImpl)context).getExportingVmID())) break block28;
                    CompositeTransactionManager ctm = txnSvc.getCompositeTransactionManager();
                    CompositeTransaction ct = ctm.getCompositeTransaction();
                    String txnID2 = ct.getTid();
                    if (success) {
                        try {
                            LogManager.logDetail((String)CTX, (String)("TxnMgr.terminateSubTransaction( Committing TID: " + txnID2 + ")"));
                            ct.getTransactionControl().getTerminator().commit();
                            ((TransactionContextImpl)context).removeSubTxnID(txnID2);
                        }
                        catch (IllegalStateException err) {
                            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0016", new Object[]{context});
                            XATransactionException te = new XATransactionException((Throwable)err, msg);
                            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                            throw te;
                        }
                        catch (SecurityException err) {
                            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0016", new Object[]{context});
                            XATransactionException te = new XATransactionException((Throwable)err, msg);
                            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                            throw te;
                        }
                        catch (SysException err) {
                            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0016", new Object[]{context});
                            String errorMsgs = this.flattenSysException(err, msg);
                            XATransactionException te = new XATransactionException(errorMsgs);
                            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                            throw te;
                        }
                        catch (UnavailableException err) {
                            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0016", new Object[]{context});
                            XATransactionException te = new XATransactionException((Throwable)err, msg);
                            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                            throw te;
                        }
                        catch (HeurRollbackException err) {
                            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0016", new Object[]{context});
                            XATransactionException te = new XATransactionException((Throwable)err, msg);
                            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                            throw te;
                        }
                        catch (HeurMixedException err) {
                            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0016", new Object[]{context});
                            XATransactionException te = new XATransactionException((Throwable)err, msg);
                            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                            throw te;
                        }
                        catch (HeurHazardException err) {
                            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0016", new Object[]{context});
                            XATransactionException te = new XATransactionException((Throwable)err, msg);
                            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                            throw te;
                        }
                        catch (RollbackException err) {
                            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0016", new Object[]{context});
                            XATransactionException te = new XATransactionException((Throwable)err, msg);
                            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                            throw te;
                        }
                    }
                    try {
                        LogManager.logDetail((String)CTX, (String)("TxnMgr.terminateSubTransaction( Rolling back TID: " + txnID2 + ")"));
                        ct.getTransactionControl().getTerminator().rollback();
                        ((TransactionContextImpl)context).removeSubTxnID(txnID2);
                    }
                    catch (IllegalStateException err) {
                        String msg = CommonXAPlugin.Util.getString("ERR.003.031.0017", new Object[]{context});
                        XATransactionException te = new XATransactionException((Throwable)err, msg);
                        LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                        throw te;
                    }
                    catch (SecurityException err) {
                        String msg = CommonXAPlugin.Util.getString("ERR.003.031.0017", new Object[]{context});
                        XATransactionException te = new XATransactionException((Throwable)err, msg);
                        LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                        throw te;
                    }
                    this.suspendTransaction(context);
                    break block29;
                }
                txnID = txnSvc.getCompositeTransactionManager().getCompositeTransaction().getTid();
                LogManager.logDetail((String)CTX, (String)("TxnMgr.terminateSubTransaction( Txn ID=" + txnID + ")"));
                ImportingTransactionManager imptm = txnSvc.getImportingTransactionManager();
                extent = null;
                boolean error = true;
                extent = imptm.terminated(success);
                error = false;
                Object var11_49 = null;
                if (!error) break block26;
                success = false;
                try {
                    extent = imptm.terminated(false);
                }
                catch (SysException e2) {
                    String msg = MMTransactionManagerImpl.flattenSysException(e2);
                    LogManager.logError((String)CTX, (String)CommonXAPlugin.Util.getString("ERR.003.031.0017", (Object)msg));
                }
                catch (RollbackException e3) {
                    String msg = CommonXAPlugin.Util.getString("ERR.003.031.0017", (Object)e3.getMessage());
                    LogManager.logError((String)CTX, (String)msg);
                }
                break block26;
                {
                    catch (SysException e4) {
                        String msg = CommonXAPlugin.Util.getString("ERR.003.031.0016", (Object)MMTransactionManagerImpl.flattenSysException(e4).toString());
                        XATransactionException te = new XATransactionException(msg);
                        LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                        throw te;
                    }
                    catch (RollbackException e5) {
                        String msg = CommonXAPlugin.Util.getString("ERR.003.031.0015", (Object)e5.getMessage());
                        XATransactionException te = new XATransactionException((Throwable)e5, msg);
                        LogManager.logError((String)CTX, (Throwable)te, (String)msg);
                        throw te;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_50 = null;
                    if (error) {
                        success = false;
                        try {
                            extent = imptm.terminated(false);
                        }
                        catch (SysException e2) {
                            String msg = MMTransactionManagerImpl.flattenSysException(e2);
                            LogManager.logError((String)CTX, (String)CommonXAPlugin.Util.getString("ERR.003.031.0017", (Object)msg));
                        }
                        catch (RollbackException e3) {
                            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0017", (Object)e3.getMessage());
                            LogManager.logError((String)CTX, (String)msg);
                        }
                    }
                    throw throwable;
                }
            }
            TransactionContextImpl theContext = (TransactionContextImpl)context;
            TransactionResultImpl result = null;
            if (theContext.hasResult()) {
                result = (TransactionResultImpl)theContext.getTransactionResult();
                result.addExtent(extent, success);
            } else {
                result = new TransactionResultImpl(extent, success);
            }
            theContext.setTransactionResult(result);
            theContext.removeSubTxnID(txnID);
        }
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.terminateSubTransaction(" + context + ", " + (success ? "success" : "failed") + ")"));
        return context;
    }

    public Object getLogAdministrator() throws XATransactionException {
        return this.logAdministrator;
    }

    public synchronized void registerResource(Object resource) throws XATransactionException {
        RecoverableResource recoverableResource = (RecoverableResource)resource;
        LogManager.logDetail((String)CTX, (String)("TxnMgr.registerResource(" + recoverableResource.getName() + ")"));
        JdbcTransactionalResource tr = (JdbcTransactionalResource)resource;
        tr.useWeakCompare(false);
        XAResource xaRes = tr.getXAResource();
        txnSvc.registerResource(recoverableResource);
        xaresourceToTranresource.put(xaRes, tr);
        LogManager.logTrace((String)CTX, (String)("END TxnMgr.registerResource(" + recoverableResource.getName() + ")"));
    }

    public void begin() throws SystemException, NotSupportedException {
        LogManager.logDetail((String)CTX, (String)"TxnMgr.begin()");
        this.getTransactionManager().begin();
    }

    public void commit() throws SystemException, IllegalStateException, SecurityException, HeuristicRollbackException, HeuristicMixedException, javax.transaction.RollbackException {
        LogManager.logDetail((String)CTX, (String)"TxnMgr.commit()");
        this.getTransactionManager().commit();
    }

    public int getStatus() throws SystemException {
        LogManager.logDetail((String)CTX, (String)"TxnMgr.getStatus()");
        return this.getTransactionManager().getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        LogManager.logDetail((String)CTX, (String)"TxnMgr.getTransaction()");
        return this.getTransactionManager().getTransaction();
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.resume(" + transaction + ")"));
        this.getTransactionManager().resume(transaction);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        LogManager.logDetail((String)CTX, (String)"TxnMgr.rollback()");
        this.getTransactionManager().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        LogManager.logDetail((String)CTX, (String)"TxnMgr.setRollbackOnly()");
        this.getTransactionManager().setRollbackOnly();
    }

    public void setTransactionTimeout(int i2) throws SystemException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.setTransactionTimeout(" + i2 + ")"));
        this.getTransactionManager().setTransactionTimeout(i2);
    }

    public Transaction suspend() throws SystemException {
        LogManager.logDetail((String)CTX, (String)"TxnMgr.suspend()");
        return this.getTransactionManager().suspend();
    }

    private synchronized TransactionManager getTransactionManager() {
        return txnSvc.getTransactionManager();
    }

    private Properties getTRMIProps(String vmName) throws XATransactionException {
        Properties trmiProps = new Properties();
        trmiProps.setProperty("com.atomikos.icatch.trmi.no_file", "true");
        trmiProps.setProperty("com.atomikos.icatch.rmi_export_class", "UnicastRemoteObject");
        Host host = null;
        try {
            host = CurrentConfiguration.getHost();
        }
        catch (UnknownHostException e2) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0045");
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        catch (ConfigurationException err) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0018");
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        if (host == null) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0045");
            XATransactionException xax = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)xax, (String)msg);
            throw xax;
        }
        this.txnMgrUniqueName = "txnmgr-" + MMTransactionManagerImpl.removeDots(host.getFullName()) + "-" + vmName;
        trmiProps.setProperty("com.atomikos.icatch.tm_unique_name", this.txnMgrUniqueName);
        Properties env = null;
        try {
            env = CurrentConfiguration.getResourceProperties((String)"XATransactionManager");
        }
        catch (ConfigurationException e3) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0018");
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        this.initialContextFactory = env.getProperty("metamatrix.xatxnmgr.naming.factory.initial");
        if (this.initialContextFactory == null || this.initialContextFactory.trim().length() == 0) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0020", (Object)"metamatrix.xatxnmgr.naming.factory.initial");
            XATransactionException te = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)te, (String)msg);
            throw te;
        }
        trmiProps.put("java.naming.factory.initial", this.initialContextFactory);
        String hostLogDir = host.getLogDirectory();
        String txnLogDir = env.getProperty("metamatrix.xatxnmgr.log_base_dir", "txnlog");
        String logDir = FileUtils.buildDirectoryPath((String[])new String[]{hostLogDir, txnLogDir});
        if (logDir == null || logDir.trim().length() == 0) {
            String msg = CommonXAPlugin.Util.getString("ERR.003.031.0020", (Object)"metamatrix.log.dir");
            XATransactionException xe = new XATransactionException(msg);
            LogManager.logError((String)CTX, (Throwable)xe, (String)msg);
            throw xe;
        }
        trmiProps.setProperty("com.atomikos.icatch.output_dir", logDir);
        trmiProps.setProperty("com.atomikos.icatch.no_file", "true");
        trmiProps.setProperty("com.atomikos.icatch.service", "com.atomikos.icatch.trmi.UserTransactionServiceFactory");
        trmiProps.setProperty("com.atomikos.icatch.automatic_resource_registration", "false");
        trmiProps.setProperty("com.atomikos.icatch.console_file_name", this.txnMgrUniqueName + ".out");
        trmiProps.setProperty("com.atomikos.icatch.log_base_dir", logDir);
        trmiProps.setProperty("com.atomikos.icatch.log_base_name", this.txnMgrUniqueName + "TxnLog");
        trmiProps.setProperty("com.atomikos.icatch.trust_client_tm", env.getProperty("metamatrix.xatxnmgr.trust_client_tm") != null ? env.getProperty("metamatrix.xatxnmgr.trust_client_tm") : "false");
        trmiProps.setProperty("com.atomikos.icatch.client_demarcation", env.getProperty("metamatrix.xatxnmgr.client_demarcation") != null ? env.getProperty("metamatrix.xatxnmgr.client_demarcation") : "true");
        trmiProps.setProperty("com.atomikos.icatch.serial_jta_transactions", "true");
        trmiProps.setProperty("com.atomikos.icatch.checkpoint_interval", env.getProperty("metamatrix.xatxnmgr.checkpoint_interval") != null ? env.getProperty("metamatrix.xatxnmgr.checkpoint_interval") : "500");
        trmiProps.setProperty("com.atomikos.icatch.max_actives", env.getProperty("metamatrix.xatxnmgr.max_actives") != null ? env.getProperty("metamatrix.xatxnmgr.max_actives") : "50");
        trmiProps.setProperty("com.atomikos.icatch.max_timeout", env.getProperty("metamatrix.xatxnmgr.max_timeout") != null ? env.getProperty("metamatrix.xatxnmgr.max_timeout") : "120000");
        String timeoutStr = trmiProps.getProperty("com.atomikos.icatch.max_timeout");
        this.defaultTxnTimeout = Integer.parseInt(timeoutStr);
        this.defaultTxnTimeout /= 1000;
        return trmiProps;
    }

    private static String removeDots(String hostName) {
        if (hostName != null && hostName.length() > 0) {
            if (hostName.indexOf(46) >= 0) {
                StringBuffer buf = new StringBuffer(hostName.length());
                char[] hostChars = hostName.toCharArray();
                for (int i2 = 0; i2 < hostChars.length; ++i2) {
                    if (hostChars[i2] == '.') {
                        buf.append('_');
                        continue;
                    }
                    buf.append(hostChars[i2]);
                }
                return buf.toString();
            }
            return hostName;
        }
        return "";
    }

    private boolean checkForLockFile(Properties props) {
        boolean fileRemoved = false;
        StringBuffer buf = new StringBuffer();
        buf.append(props.getProperty("com.atomikos.icatch.log_base_dir"));
        buf.append(File.separatorChar);
        buf.append(props.getProperty("com.atomikos.icatch.log_base_name"));
        buf.append(".lck");
        String lockFileStr = buf.toString();
        File lockFile = new File(lockFileStr);
        if (lockFile.exists()) {
            lockFile.delete();
            fileRemoved = true;
        }
        return fileRemoved;
    }

    private static String flattenSysException(SysException e2) {
        StringBuffer msg = new StringBuffer(StringUtil.getStackTrace((Throwable)e2));
        Stack errors = e2.getErrors();
        if (errors != null) {
            Iterator errorItr = errors.iterator();
            while (errorItr.hasNext()) {
                Throwable anError = (Throwable)errorItr.next();
                if (anError instanceof SysException) {
                    msg.append(StringUtil.getStackTrace((Throwable)anError));
                    msg.append(MMTransactionManagerImpl.flattenSysException((SysException)anError));
                    continue;
                }
                msg.append(StringUtil.getStackTrace((Throwable)anError));
            }
        }
        return msg.toString();
    }

    private String flattenExtendedSystemException(ExtendedSystemException exception, String msg) {
        Stack errors;
        StringBuffer errorBuf = new StringBuffer();
        if (msg != null) {
            errorBuf.append(msg);
            errorBuf.append('\n');
        }
        if ((errors = exception.getErrors()) != null) {
            Iterator errorItr = errors.iterator();
            while (errorItr.hasNext()) {
                Throwable anError = (Throwable)errorItr.next();
                if (anError instanceof ExtendedSystemException) {
                    errorBuf.append(StringUtil.getStackTrace((Throwable)anError));
                    errorBuf.append(this.flattenExtendedSystemException((ExtendedSystemException)anError, null));
                    continue;
                }
                errorBuf.append(StringUtil.getStackTrace((Throwable)anError));
            }
        }
        return errorBuf.toString();
    }

    private String flattenSysException(SysException exception, String msg) {
        Stack errors;
        StringBuffer errorBuf = new StringBuffer();
        if (msg != null) {
            errorBuf.append(msg);
            errorBuf.append('\n');
        }
        if ((errors = exception.getErrors()) != null) {
            Iterator errorItr = errors.iterator();
            while (errorItr.hasNext()) {
                Throwable anError = (Throwable)errorItr.next();
                if (anError instanceof SysException) {
                    errorBuf.append(StringUtil.getStackTrace((Throwable)anError));
                    errorBuf.append(this.flattenSysException((SysException)anError, null));
                    continue;
                }
                errorBuf.append(StringUtil.getStackTrace((Throwable)anError));
            }
        }
        return errorBuf.toString();
    }

    private void testTxnMgr() throws XATransactionException {
        UserTransactionService uts = null;
        try {
            uts = txnSvc;
        }
        catch (Throwable e2) {
            XATransactionException te = new XATransactionException(e2, CommonXAPlugin.Util.getString("ERR.003.031.0002"));
            LogManager.logError((String)CTX, (Throwable)te, (String)te.getMessage());
            throw te;
        }
        if (uts == null) {
            XATransactionException te = new XATransactionException(CommonXAPlugin.Util.getString("ERR.003.031.0002"));
            LogManager.logError((String)CTX, (Throwable)te, (String)te.getMessage());
            throw te;
        }
    }

    private void printProps(Properties props, String prefix) {
        ArrayList<Object> keys = new ArrayList<Object>(props.keySet());
        Collections.sort(keys);
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            LogManager.logInfo((String)CTX, (String)(prefix + ": <" + key + "> - <" + props.getProperty(key) + ">"));
        }
        LogManager.logInfo((String)CTX, (String)(prefix + ": <VMID> - <" + this.vmID + ">"));
    }

    public void enlistResource(XAResource resource) throws XATransactionException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.enlistResource(" + resource + ")"));
        ArgCheck.isNotNull((Object)resource);
        if (this.xaResourceRegistered(resource)) {
            TransactionManager tm = this.getTransactionManager();
            try {
                tm.getTransaction().enlistResource(resource);
            }
            catch (IllegalStateException e2) {
                String msg = CommonXAPlugin.Util.getString("MMTMI.enlistResourceFailed", (Object)resource.toString());
                CommonXAPlugin.Util.log(4, (Throwable)e2, msg);
                throw new XATransactionException((Throwable)e2, msg);
            }
            catch (javax.transaction.RollbackException e3) {
                String msg = CommonXAPlugin.Util.getString("MMTMI.enlistResourceFailed", (Object)resource.toString());
                CommonXAPlugin.Util.log(4, (Throwable)e3, msg);
                throw new XATransactionException((Throwable)e3, msg);
            }
            catch (ExtendedSystemException e4) {
                String msg = CommonXAPlugin.Util.getString("MMTMI.enlistResourceFailed", (Object)resource.toString());
                String errorMsgs = this.flattenExtendedSystemException(e4, msg);
                XATransactionException ex2 = new XATransactionException(errorMsgs);
                I18nLogManager.logError((String)CTX, (String)"MMTMI.enlistResourceFailed", (Object)errorMsgs);
                throw ex2;
            }
            catch (SystemException e5) {
                String msg = CommonXAPlugin.Util.getString("MMTMI.enlistResourceFailed", (Object)resource.toString());
                I18nLogManager.logError((String)CTX, (String)"MMTMI.enlistResourceFailed", (Object)msg);
                throw new XATransactionException((Throwable)e5, msg);
            }
        } else {
            CompositeTransaction ct = txnSvc.getCompositeTransactionManager().getCompositeTransaction();
            JdbcTransactionalResource theResource = this.getTransactionalResource(resource);
            if (theResource == null) {
                throw new XATransactionException(CommonXAPlugin.Util.getString("MMTransactionManagerImpl.Can_not_get_transaction_resource_for_XAResource__9", (Object)resource));
            }
            ResourceTransaction restx = theResource.getResourceTransaction(ct);
            XAResourceTransaction xarestx = (XAResourceTransaction)restx;
            xarestx.setXAResource(resource);
            restx.resume();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delistResource(XAResource resource) throws XATransactionException {
        LogManager.logDetail((String)CTX, (String)("TxnMgr.delistResource(" + resource + ")"));
        ArgCheck.isNotNull((Object)resource);
        if (this.xaResourceRegistered(resource)) {
            TransactionManager tm = this.getTransactionManager();
            try {
                Transaction txn = tm.getTransaction();
                if (txn == null) return;
                txn.delistResource(resource, 0x4000000);
                return;
            }
            catch (IllegalStateException e2) {
                String errorMsg = e2.getMessage();
                String wrongState = "TERMINATED";
                if (errorMsg.indexOf("TERMINATED") != -1) return;
                String msg = CommonXAPlugin.Util.getString("MMTMI.delistResourceFailed", (Object)resource.toString());
                CommonXAPlugin.Util.log(4, (Throwable)e2, msg);
                throw new XATransactionException((Throwable)e2, msg);
            }
            catch (ExtendedSystemException e3) {
                String msg = CommonXAPlugin.Util.getString("MMTMI.delistResourceFailed", (Object)resource.toString());
                String errorMsgs = this.flattenExtendedSystemException(e3, msg);
                XATransactionException ex2 = new XATransactionException(errorMsgs);
                I18nLogManager.logError((String)CTX, (String)"MMTMI.delistResourceFailed", (Object)errorMsgs);
                throw ex2;
            }
            catch (SystemException e4) {
                String msg = CommonXAPlugin.Util.getString("MMTMI.delistResourceFailed", (Object)resource.toString());
                I18nLogManager.logError((String)CTX, (String)"MMTMI.delistResourceFailed", (Object)msg);
                throw new XATransactionException((Throwable)e4, msg);
            }
        } else {
            CompositeTransaction ct = txnSvc.getCompositeTransactionManager().getCompositeTransaction();
            JdbcTransactionalResource theResource = this.getTransactionalResource(resource);
            if (theResource == null) {
                throw new XATransactionException(CommonXAPlugin.Util.getString("MMTransactionManagerImpl.Can_not_get_transaction_resource_for_XAResource__9", (Object)resource));
            }
            ResourceTransaction restx = theResource.getResourceTransaction(ct);
            restx.suspend();
        }
    }

    public int getDefaultTxnTimeout() {
        return this.defaultTxnTimeout;
    }

    public MMUserTransactionServer getUserTransactionService() throws SystemException {
        if (this.txnServer == null) {
            String utsUniqueName = this.txnMgrUniqueName + "UserTransactionServer";
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", this.initialContextFactory);
                env.put("java.naming.provider.url", "mm://fakeURL:12345");
                InitialContext ctx = new InitialContext(env);
                this.txnServer = (UserTransactionServer)PortableRemoteObject.narrow((Object)ctx.lookup(utsUniqueName), (Class)(class$com$atomikos$icatch$jta$UserTransactionServer == null ? (class$com$atomikos$icatch$jta$UserTransactionServer = MMTransactionManagerImpl.class$("com.atomikos.icatch.jta.UserTransactionServer")) : class$com$atomikos$icatch$jta$UserTransactionServer));
            }
            catch (NamingException e2) {
                throw new SystemException(CommonXAPlugin.Util.getString("MMTransactionManagerImpl.MMTransactionManager_unable_to_communicate_with_JNDI_server") + utsUniqueName + ": " + e2.getExplanation());
            }
            catch (Throwable e3) {
                throw new SystemException(CommonXAPlugin.Util.getString("MMTransactionManagerImpl.MMTransactionManager_unable_to_communicate_with_JNDI_server") + utsUniqueName + ": " + e3.getMessage());
            }
            if (this.txnServer == null) {
                throw new SystemException(CommonXAPlugin.Util.getString("MMTransactionManagerImpl.MMTransactionManager_no_RMI_server_found") + utsUniqueName);
            }
        }
        return new UserTransactionServerWrapper(this.txnServer, this.defaultTxnTimeout);
    }

    private synchronized JdbcTransactionalResource getTransactionalResource(XAResource resource) throws XATransactionException {
        JdbcTransactionalResource theResource = null;
        Iterator iter = xaresourceToTranresource.keySet().iterator();
        while (iter.hasNext()) {
            XAResource xaResource = (XAResource)iter.next();
            try {
                if (!xaResource.isSameRM(resource)) continue;
                theResource = (JdbcTransactionalResource)xaresourceToTranresource.get(xaResource);
                break;
            }
            catch (XAException e2) {
                throw new XATransactionException((Throwable)e2);
            }
        }
        return theResource;
    }

    private boolean xaResourceRegistered(XAResource xaResource) throws XATransactionException {
        JdbcTransactionalResource theResource = this.getTransactionalResource(xaResource);
        return theResource != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

