/*
 * Copyright (c) 2014 Red Hat, Inc. and others
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.ext.sql;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;

/**
 * Converter for {@link io.vertx.ext.sql.SQLOptions}.
 *
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLOptions} original class using Vert.x codegen.
 */
public class SQLOptionsConverter {

  public static void fromJson(JsonObject json, SQLOptions obj) {
    if (json.getValue("autoGeneratedKeys") instanceof Boolean) {
      obj.setAutoGeneratedKeys((Boolean)json.getValue("autoGeneratedKeys"));
    }
    if (json.getValue("autoGeneratedKeysIndexes") instanceof JsonArray) {
      obj.setAutoGeneratedKeysIndexes(((JsonArray)json.getValue("autoGeneratedKeysIndexes")).copy());
    }
    if (json.getValue("catalog") instanceof String) {
      obj.setCatalog((String)json.getValue("catalog"));
    }
    if (json.getValue("fetchDirection") instanceof String) {
      obj.setFetchDirection(io.vertx.ext.sql.FetchDirection.valueOf((String)json.getValue("fetchDirection")));
    }
    if (json.getValue("fetchSize") instanceof Number) {
      obj.setFetchSize(((Number)json.getValue("fetchSize")).intValue());
    }
    if (json.getValue("queryTimeout") instanceof Number) {
      obj.setQueryTimeout(((Number)json.getValue("queryTimeout")).intValue());
    }
    if (json.getValue("readOnly") instanceof Boolean) {
      obj.setReadOnly((Boolean)json.getValue("readOnly"));
    }
    if (json.getValue("resultSetConcurrency") instanceof String) {
      obj.setResultSetConcurrency(io.vertx.ext.sql.ResultSetConcurrency.valueOf((String)json.getValue("resultSetConcurrency")));
    }
    if (json.getValue("resultSetType") instanceof String) {
      obj.setResultSetType(io.vertx.ext.sql.ResultSetType.valueOf((String)json.getValue("resultSetType")));
    }
    if (json.getValue("schema") instanceof String) {
      obj.setSchema((String)json.getValue("schema"));
    }
    if (json.getValue("transactionIsolation") instanceof String) {
      obj.setTransactionIsolation(io.vertx.ext.sql.TransactionIsolation.valueOf((String)json.getValue("transactionIsolation")));
    }
  }

  public static void toJson(SQLOptions obj, JsonObject json) {
    json.put("autoGeneratedKeys", obj.isAutoGeneratedKeys());
    if (obj.getAutoGeneratedKeysIndexes() != null) {
      json.put("autoGeneratedKeysIndexes", obj.getAutoGeneratedKeysIndexes());
    }
    if (obj.getCatalog() != null) {
      json.put("catalog", obj.getCatalog());
    }
    if (obj.getFetchDirection() != null) {
      json.put("fetchDirection", obj.getFetchDirection().name());
    }
    json.put("fetchSize", obj.getFetchSize());
    json.put("queryTimeout", obj.getQueryTimeout());
    json.put("readOnly", obj.isReadOnly());
    if (obj.getResultSetConcurrency() != null) {
      json.put("resultSetConcurrency", obj.getResultSetConcurrency().name());
    }
    if (obj.getResultSetType() != null) {
      json.put("resultSetType", obj.getResultSetType().name());
    }
    if (obj.getSchema() != null) {
      json.put("schema", obj.getSchema());
    }
    if (obj.getTransactionIsolation() != null) {
      json.put("transactionIsolation", obj.getTransactionIsolation().name());
    }
  }
}