/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionBuilderIF;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ConnectionPoolDefinitionIF;
import org.logicalcobwebs.proxool.DefaultConnectionBuilder;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxyConnection;

public class Prototyper {
    private ConnectionPool connectionPool;
    private Log log = LogFactory.getLog(Prototyper.class);
    private long connectionCount;
    private final Object lock = new Integer(1);
    private boolean sweepNeeded = true;
    private long nextConnectionId = 1L;
    private boolean cancel;
    private int connectionsBeingMade;
    private ConnectionBuilderIF connectionBuilder = new DefaultConnectionBuilder();

    public Prototyper(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        this.log = connectionPool.getLog();
    }

    protected boolean isSweepNeeded() {
        return this.sweepNeeded;
    }

    protected void triggerSweep() {
        this.sweepNeeded = true;
    }

    protected boolean sweep() {
        boolean somethingDone = false;
        try {
            while (!this.cancel && this.connectionPool.isConnectionPoolUp()) {
                String reason = null;
                if (this.connectionCount >= (long)this.getDefinition().getMaximumConnectionCount()) break;
                if (this.connectionCount < (long)this.getDefinition().getMinimumConnectionCount()) {
                    reason = "to achieve minimum of " + this.getDefinition().getMinimumConnectionCount();
                } else {
                    if (this.connectionPool.getAvailableConnectionCount() >= this.getDefinition().getPrototypeCount()) break;
                    reason = "to keep " + this.getDefinition().getPrototypeCount() + " available";
                }
                ProxyConnection freshlyBuiltProxyConnection = null;
                try {
                    if (!this.connectionPool.isConnectionPoolUp()) break;
                    freshlyBuiltProxyConnection = this.buildConnection(1, reason);
                    somethingDone = true;
                }
                catch (Throwable e) {
                    this.log.error((Object)"Prototype", e);
                    break;
                }
                if (freshlyBuiltProxyConnection != null) continue;
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Unexpected error", t);
        }
        return somethingDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProxyConnection buildConnection(int status, String creator) throws SQLException, ProxoolException {
        long id = 0L;
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionCount >= (long)this.getDefinition().getMaximumConnectionCount()) {
                throw new ProxoolException("ConnectionCount is " + this.connectionCount + ". Maximum connection count of " + this.getDefinition().getMaximumConnectionCount() + " cannot be exceeded.");
            }
            this.checkSimultaneousBuildThrottle();
            ++this.connectionsBeingMade;
            ++this.connectionCount;
            id = this.nextConnectionId++;
        }
        ProxyConnection proxyConnection = null;
        Connection realConnection = null;
        try {
            ConnectionPoolDefinition definition = this.connectionPool.getDefinition();
            realConnection = this.connectionBuilder.buildConnection(definition);
            String url = definition.getUrl();
            proxyConnection = new ProxyConnection(realConnection, id, url, this.connectionPool, definition, status);
            try {
                this.connectionPool.onBirth(realConnection);
            }
            catch (Exception e) {
                this.log.error((Object)"Problem during onBirth (ignored)", (Throwable)e);
            }
            boolean added = this.connectionPool.addProxyConnection(proxyConnection);
            if (this.log.isDebugEnabled()) {
                StringBuffer out = new StringBuffer(this.connectionPool.displayStatistics());
                out.append(" - Connection #");
                out.append(proxyConnection.getId());
                if (this.getDefinition().isVerbose()) {
                    out.append(" (");
                    out.append(Integer.toHexString(proxyConnection.hashCode()));
                    out.append(")");
                }
                out.append(" created ");
                out.append(creator);
                out.append(" = ");
                out.append(ConnectionPool.getStatusDescription(proxyConnection.getStatus()));
                if (this.getDefinition().isVerbose()) {
                    out.append(" -> ");
                    out.append(this.getDefinition().getUrl());
                    out.append(" (");
                    out.append(Integer.toHexString(proxyConnection.getConnection().hashCode()));
                    out.append(") by thread ");
                    out.append(Thread.currentThread().getName());
                }
                this.log.debug((Object)out);
                if (!added) {
                    out = new StringBuffer(this.connectionPool.displayStatistics());
                    out.append(" - Connection #");
                    out.append(proxyConnection.getId());
                    out.append(" has been discarded immediately because the definition it was built with is out of date");
                    this.log.debug((Object)out);
                }
            }
            if (!added) {
                proxyConnection.reallyClose();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Prototyping problem", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Prototyping problem", t);
            }
            throw new ProxoolException("Unexpected prototyping problem", t);
        }
        finally {
            Object object2 = this.lock;
            synchronized (object2) {
                if (proxyConnection == null) {
                    --this.connectionCount;
                }
                --this.connectionsBeingMade;
            }
        }
        return proxyConnection;
    }

    protected void connectionRemoved() {
        --this.connectionCount;
    }

    protected void checkSimultaneousBuildThrottle() throws SQLException {
        if (this.connectionsBeingMade > this.getDefinition().getSimultaneousBuildThrottle()) {
            throw new SQLException("We are already in the process of making " + this.connectionsBeingMade + " connections and the number of simultaneous builds has been throttled to " + this.getDefinition().getSimultaneousBuildThrottle());
        }
    }

    public long getConnectionCount() {
        return this.connectionCount;
    }

    private ConnectionPoolDefinitionIF getDefinition() {
        return this.connectionPool.getDefinition();
    }

    public void cancel() {
        this.cancel = true;
    }

    public String getAlias() {
        return this.getDefinition().getAlias();
    }

    public void quickRefuse() throws SQLException {
        if (this.connectionCount >= (long)this.getDefinition().getMaximumConnectionCount() && this.connectionPool.getAvailableConnectionCount() < 1) {
            throw new SQLException("Couldn't get connection because we are at maximum connection count (" + this.connectionCount + "/" + this.getDefinition().getMaximumConnectionCount() + ") and there are none available");
        }
    }
}

