/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v3.filecache;

import com.mchange.v1.io.InputStreamUtils;
import com.mchange.v1.io.ReaderUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLogger;
import com.mchange.v3.filecache.URLFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum URLFetchers implements URLFetcher
{
    DEFAULT{

        public InputStream openStream(URL u, MLogger logger) throws IOException {
            return u.openStream();
        }
    }
    ,
    BUFFERED_WGET{

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public InputStream openStream(URL u, MLogger logger) throws IOException {
            p = new ProcessBuilder(new String[]{"wget", "-O", "-", u.toString()}).start();
            is = null;
            is = new BufferedInputStream(p.getInputStream(), 0x100000);
            baos = new ByteArrayOutputStream(0x100000);
            b = is.read();
            while (b >= 0) {
                baos.write(b);
                b = is.read();
            }
            var6_7 = new ByteArrayInputStream(baos.toByteArray());
            var8_8 = null;
            InputStreamUtils.attemptClose(is);
            if (logger.isLoggable(MLevel.FINER)) {
                errReader = null;
                try {
                    errReader = new BufferedReader(new InputStreamReader(p.getErrorStream()), 0x100000);
                    writer = new StringWriter(0x100000);
                    c = errReader.read();
                    while (c >= 0) {
                        writer.write(c);
                        c = errReader.read();
                    }
                    logger.log(MLevel.FINER, "wget error stream for '" + u + "':\n " + writer.toString());
                    var13_18 = null;
                    ReaderUtils.attemptClose(errReader);
                }
                catch (Throwable var12_22) {
                    var13_19 = null;
                    ReaderUtils.attemptClose(errReader);
                    throw var12_22;
                }
            }
            try {
                check = p.waitFor();
                if (check == 0) return var6_7;
                throw new IOException("wget process terminated abnormally [return code: " + check + "]");
            }
            catch (InterruptedException e) {
                if (logger.isLoggable(MLevel.FINER) == false) throw new IOException("Interrupted while waiting for wget to complete: " + e);
                logger.log(MLevel.FINER, "InterruptedException while waiting for wget to complete.", e);
                throw new IOException("Interrupted while waiting for wget to complete: " + e);
            }
            catch (Throwable var7_24) {
                block14: {
                    var8_9 = null;
                    InputStreamUtils.attemptClose(is);
                    if (logger.isLoggable(MLevel.FINER)) {
                        errReader = null;
                        ** try [egrp 1[TRYBLOCK] [2 : 145->254)] { 
lbl51:
                        // 1 sources

                        errReader = new BufferedReader(new InputStreamReader(p.getErrorStream()), 0x100000);
                        writer = new StringWriter(0x100000);
                        c = errReader.read();
                        while (c >= 0) {
                            writer.write(c);
                            c = errReader.read();
                        }
                        logger.log(MLevel.FINER, "wget error stream for '" + u + "':\n " + writer.toString());
                        var13_20 = null;
                        ReaderUtils.attemptClose(errReader);
                        break block14;
lbl63:
                        // 1 sources

                        catch (Throwable var12_23) {
                            var13_21 = null;
                            ReaderUtils.attemptClose(errReader);
                            throw var12_23;
                        }
                    }
                }
                try {}
                catch (InterruptedException e) {
                    if (logger.isLoggable(MLevel.FINER) == false) throw new IOException("Interrupted while waiting for wget to complete: " + e);
                    logger.log(MLevel.FINER, "InterruptedException while waiting for wget to complete.", e);
                    throw new IOException("Interrupted while waiting for wget to complete: " + e);
                }
                check = p.waitFor();
                if (check == 0) throw var7_24;
                throw new IOException("wget process terminated abnormally [return code: " + check + "]");
            }
        }
    };

}

