/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import sun.misc.Unsafe;

public class PriorityBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = 5595510919245408276L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private transient Object[] queue;
    private transient int size;
    private transient Comparator<? super E> comparator;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private volatile transient int allocationSpinLock;
    private PriorityQueue<E> q;
    private static final Unsafe UNSAFE;
    private static final long allocationSpinLockOffset;

    public PriorityBlockingQueue() {
    }

    public PriorityBlockingQueue(int n) {
    }

    public PriorityBlockingQueue(int n, Comparator<? super E> comparator) {
    }

    public PriorityBlockingQueue(Collection<? extends E> collection) {
    }

    @Override
    public boolean add(E e) {
        return false;
    }

    @Override
    public boolean offer(E e) {
        return false;
    }

    @Override
    public void put(E e) {
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) {
        return false;
    }

    @Override
    public E poll() {
        return null;
    }

    @Override
    public E take() throws InterruptedException {
        return null;
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return null;
    }

    @Override
    public E peek() {
        return null;
    }

    public Comparator<? super E> comparator() {
        return null;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return false;
    }

    @Override
    public Object[] toArray() {
        return null;
    }

    @Override
    public String toString() {
        return null;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return 0;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    @Override
    public Spliterator<E> spliterator() {
        return null;
    }

    final class PBQSpliterator
    implements Spliterator<E> {
        Object[] array;
        int index;
        int fence;

        PBQSpliterator() {
        }

        PBQSpliterator(Object[] array, int index, int fence) {
            this.array = array;
            this.index = index;
            this.fence = fence;
        }

        private int getFence() {
            if (this.array == null) {
                this.array = PriorityBlockingQueue.this.toArray();
                this.fence = this.array.length;
            }
            return this.fence;
        }

        public PBQSpliterator trySplit() {
            PBQSpliterator pBQSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid) {
                pBQSpliterator = null;
            } else {
                this.index = mid;
                PBQSpliterator pBQSpliterator2 = new PBQSpliterator(this.array, lo, this.index);
                pBQSpliterator = pBQSpliterator2;
            }
            return pBQSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int hi = this.getFence();
            int lo = this.index;
            Object[] es = this.array;
            this.index = hi;
            for (int i = lo; i < hi; ++i) {
                action.accept(es[i]);
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            if (this.getFence() > this.index && this.index >= 0) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16704;
        }
    }

    final class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor++;
            return this.array[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            PriorityBlockingQueue.this.removeEq(this.array[this.lastRet]);
            this.lastRet = -1;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int i;
            Objects.requireNonNull(action);
            Object[] es = this.array;
            if (i < es.length) {
                this.lastRet = -1;
                this.cursor = es.length;
                for (i = this.cursor; i < es.length; ++i) {
                    action.accept(es[i]);
                }
                this.lastRet = es.length - 1;
            }
        }
    }
}

