/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.beanvalidator;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelBeanvalidatorSinkConnectorConfig
        extends
            CamelSinkConnectorConfig {

    public static final String CAMEL_SINK_BEANVALIDATOR_PATH_LABEL_CONF = "camel.sink.path.label";
    public static final String CAMEL_SINK_BEANVALIDATOR_PATH_LABEL_DOC = "Where label is an arbitrary text value describing the endpoint";
    public static final String CAMEL_SINK_BEANVALIDATOR_PATH_LABEL_DEFAULT = null;
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_GROUP_CONF = "camel.sink.endpoint.group";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_GROUP_DOC = "To use a custom validation group";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_GROUP_DEFAULT = "javax.validation.groups.Default";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_IGNORE_XML_CONFIGURATION_CONF = "camel.sink.endpoint.ignoreXmlConfiguration";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_IGNORE_XML_CONFIGURATION_DOC = "Whether to ignore data from the META-INF/validation.xml file.";
    public static final Boolean CAMEL_SINK_BEANVALIDATOR_ENDPOINT_IGNORE_XML_CONFIGURATION_DEFAULT = false;
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_BEANVALIDATOR_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.sink.endpoint.basicPropertyBinding";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_BEANVALIDATOR_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_CONSTRAINT_VALIDATOR_FACTORY_CONF = "camel.sink.endpoint.constraintValidatorFactory";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_CONSTRAINT_VALIDATOR_FACTORY_DOC = "To use a custom ConstraintValidatorFactory";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_CONSTRAINT_VALIDATOR_FACTORY_DEFAULT = null;
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_MESSAGE_INTERPOLATOR_CONF = "camel.sink.endpoint.messageInterpolator";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_MESSAGE_INTERPOLATOR_DOC = "To use a custom MessageInterpolator";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_MESSAGE_INTERPOLATOR_DEFAULT = null;
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SINK_BEANVALIDATOR_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_TRAVERSABLE_RESOLVER_CONF = "camel.sink.endpoint.traversableResolver";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_TRAVERSABLE_RESOLVER_DOC = "To use a custom TraversableResolver";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_TRAVERSABLE_RESOLVER_DEFAULT = null;
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATION_PROVIDER_RESOLVER_CONF = "camel.sink.endpoint.validationProviderResolver";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATION_PROVIDER_RESOLVER_DOC = "To use a a custom ValidationProviderResolver";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATION_PROVIDER_RESOLVER_DEFAULT = null;
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATOR_FACTORY_CONF = "camel.sink.endpoint.validatorFactory";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATOR_FACTORY_DOC = "To use a custom ValidatorFactory";
    public static final String CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATOR_FACTORY_DEFAULT = null;
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_IGNORE_XML_CONFIGURATION_CONF = "camel.component.bean-validator.ignoreXmlConfiguration";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_IGNORE_XML_CONFIGURATION_DOC = "Whether to ignore data from the META-INF/validation.xml file.";
    public static final Boolean CAMEL_SINK_BEANVALIDATOR_COMPONENT_IGNORE_XML_CONFIGURATION_DEFAULT = false;
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.bean-validator.lazyStartProducer";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_BEANVALIDATOR_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.bean-validator.basicPropertyBinding";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SINK_BEANVALIDATOR_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_CONSTRAINT_VALIDATOR_FACTORY_CONF = "camel.component.bean-validator.constraintValidatorFactory";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_CONSTRAINT_VALIDATOR_FACTORY_DOC = "To use a custom ConstraintValidatorFactory";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_CONSTRAINT_VALIDATOR_FACTORY_DEFAULT = null;
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_MESSAGE_INTERPOLATOR_CONF = "camel.component.bean-validator.messageInterpolator";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_MESSAGE_INTERPOLATOR_DOC = "To use a custom MessageInterpolator";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_MESSAGE_INTERPOLATOR_DEFAULT = null;
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_TRAVERSABLE_RESOLVER_CONF = "camel.component.bean-validator.traversableResolver";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_TRAVERSABLE_RESOLVER_DOC = "To use a custom TraversableResolver";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_TRAVERSABLE_RESOLVER_DEFAULT = null;
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATION_PROVIDER_RESOLVER_CONF = "camel.component.bean-validator.validationProviderResolver";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATION_PROVIDER_RESOLVER_DOC = "To use a a custom ValidationProviderResolver";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATION_PROVIDER_RESOLVER_DEFAULT = null;
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATOR_FACTORY_CONF = "camel.component.bean-validator.validatorFactory";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATOR_FACTORY_DOC = "To use a custom ValidatorFactory";
    public static final String CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATOR_FACTORY_DEFAULT = null;

    public CamelBeanvalidatorSinkConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelBeanvalidatorSinkConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_BEANVALIDATOR_PATH_LABEL_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_PATH_LABEL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_BEANVALIDATOR_PATH_LABEL_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_ENDPOINT_GROUP_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_GROUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_GROUP_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_ENDPOINT_IGNORE_XML_CONFIGURATION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_IGNORE_XML_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_IGNORE_XML_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_ENDPOINT_CONSTRAINT_VALIDATOR_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_CONSTRAINT_VALIDATOR_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_CONSTRAINT_VALIDATOR_FACTORY_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_ENDPOINT_MESSAGE_INTERPOLATOR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_MESSAGE_INTERPOLATOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_MESSAGE_INTERPOLATOR_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_ENDPOINT_TRAVERSABLE_RESOLVER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_TRAVERSABLE_RESOLVER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_TRAVERSABLE_RESOLVER_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATION_PROVIDER_RESOLVER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATION_PROVIDER_RESOLVER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATION_PROVIDER_RESOLVER_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATOR_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATOR_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_ENDPOINT_VALIDATOR_FACTORY_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_COMPONENT_IGNORE_XML_CONFIGURATION_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BEANVALIDATOR_COMPONENT_IGNORE_XML_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_COMPONENT_IGNORE_XML_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BEANVALIDATOR_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_COMPONENT_LAZY_START_PRODUCER_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SINK_BEANVALIDATOR_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_COMPONENT_CONSTRAINT_VALIDATOR_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_COMPONENT_CONSTRAINT_VALIDATOR_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_COMPONENT_CONSTRAINT_VALIDATOR_FACTORY_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_COMPONENT_MESSAGE_INTERPOLATOR_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_COMPONENT_MESSAGE_INTERPOLATOR_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_COMPONENT_MESSAGE_INTERPOLATOR_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_COMPONENT_TRAVERSABLE_RESOLVER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_COMPONENT_TRAVERSABLE_RESOLVER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_COMPONENT_TRAVERSABLE_RESOLVER_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATION_PROVIDER_RESOLVER_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATION_PROVIDER_RESOLVER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATION_PROVIDER_RESOLVER_DOC);
        conf.define(CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATOR_FACTORY_CONF, ConfigDef.Type.STRING, CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATOR_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_BEANVALIDATOR_COMPONENT_VALIDATOR_FACTORY_DOC);
        return conf;
    }
}