/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.awssqs;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelAwssqsSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_AWSSQS_PATH_QUEUE_NAME_OR_ARN_CONF = "camel.source.path.queueNameOrArn";
    public static final String CAMEL_SOURCE_AWSSQS_PATH_QUEUE_NAME_OR_ARN_DOC = "Queue name or ARN";
    public static final String CAMEL_SOURCE_AWSSQS_PATH_QUEUE_NAME_OR_ARN_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_AWSHOST_CONF = "camel.source.endpoint.amazonAWSHost";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_AWSHOST_DOC = "The hostname of the Amazon AWS cloud.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_AWSHOST_DEFAULT = "amazonaws.com";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_SQSCLIENT_CONF = "camel.source.endpoint.amazonSQSClient";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_SQSCLIENT_DOC = "To use the AmazonSQS as client";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_SQSCLIENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_CREATE_QUEUE_CONF = "camel.source.endpoint.autoCreateQueue";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_CREATE_QUEUE_DOC = "Setting the autocreation of the queue";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_CREATE_QUEUE_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_DISCOVER_CLIENT_CONF = "camel.source.endpoint.autoDiscoverClient";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_DISCOVER_CLIENT_DOC = "Setting the autoDiscoverClient mechanism, if true, the component will look for a client instance in the registry automatically otherwise it will skip that checking.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_DISCOVER_CLIENT_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_HEADER_FILTER_STRATEGY_CONF = "camel.source.endpoint.headerFilterStrategy";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_HEADER_FILTER_STRATEGY_DOC = "To use a custom HeaderFilterStrategy to map headers to/from Camel.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROTOCOL_CONF = "camel.source.endpoint.protocol";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROTOCOL_DOC = "The underlying protocol used to communicate with SQS";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROTOCOL_DEFAULT = "https";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PROTOCOL_CONF = "camel.source.endpoint.proxyProtocol";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PROTOCOL_DOC = "To define a proxy protocol when instantiating the SQS client One of: [HTTP] [HTTPS]";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PROTOCOL_DEFAULT = "HTTPS";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_OWNER_AWSACCOUNT_ID_CONF = "camel.source.endpoint.queueOwnerAWSAccountId";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_OWNER_AWSACCOUNT_ID_DOC = "Specify the queue owner aws account id when you need to connect the queue with different account owner.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_OWNER_AWSACCOUNT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_REGION_CONF = "camel.source.endpoint.region";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_REGION_DOC = "Specify the queue region which could be used with queueOwnerAWSAccountId to build the service URL. When using this parameter, the configuration will expect the capitalized name of the region (for example AP_EAST_1) You'll need to use the name Regions.EU_WEST_1.name()";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_REGION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_ATTRIBUTE_NAMES_CONF = "camel.source.endpoint.attributeNames";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_ATTRIBUTE_NAMES_DOC = "A list of attribute names to receive when consuming. Multiple names can be separated by comma.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_ATTRIBUTE_NAMES_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_CONCURRENT_CONSUMERS_CONF = "camel.source.endpoint.concurrentConsumers";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_CONCURRENT_CONSUMERS_DOC = "Allows you to use multiple threads to poll the sqs queue to increase throughput";
    public static final Integer CAMEL_SOURCE_AWSSQS_ENDPOINT_CONCURRENT_CONSUMERS_DEFAULT = 1;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DEFAULT_VISIBILITY_TIMEOUT_CONF = "camel.source.endpoint.defaultVisibilityTimeout";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DEFAULT_VISIBILITY_TIMEOUT_DOC = "The default visibility timeout (in seconds)";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DEFAULT_VISIBILITY_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_AFTER_READ_CONF = "camel.source.endpoint.deleteAfterRead";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_AFTER_READ_DOC = "Delete message from SQS after it has been read";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_AFTER_READ_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_IF_FILTERED_CONF = "camel.source.endpoint.deleteIfFiltered";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_IF_FILTERED_DOC = "Whether or not to send the DeleteMessage to the SQS queue if an exchange fails to get through a filter. If 'false' and exchange does not make it through a Camel filter upstream in the route, then don't send DeleteMessage.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_IF_FILTERED_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_EXTEND_MESSAGE_VISIBILITY_CONF = "camel.source.endpoint.extendMessageVisibility";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_EXTEND_MESSAGE_VISIBILITY_DOC = "If enabled then a scheduled background task will keep extending the message visibility on SQS. This is needed if it takes a long time to process the message. If set to true defaultVisibilityTimeout must be set. See details at Amazon docs.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_EXTEND_MESSAGE_VISIBILITY_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_CONF = "camel.source.endpoint.kmsDataKeyReusePeriodSeconds";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_DOC = "The length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again. An integer representing seconds, between 60 seconds (1 minute) and 86,400 seconds (24 hours). Default: 300 (5 minutes).";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_MASTER_KEY_ID_CONF = "camel.source.endpoint.kmsMasterKeyId";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_MASTER_KEY_ID_DOC = "The ID of an AWS-managed customer master key (CMK) for Amazon SQS or a custom CMK.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_MASTER_KEY_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MAX_MESSAGES_PER_POLL_CONF = "camel.source.endpoint.maxMessagesPerPoll";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MAX_MESSAGES_PER_POLL_DOC = "Gets the maximum number of messages as a limit to poll at each polling. Is default unlimited, but use 0 or negative number to disable it as unlimited.";
    public static final Integer CAMEL_SOURCE_AWSSQS_ENDPOINT_MAX_MESSAGES_PER_POLL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_ATTRIBUTE_NAMES_CONF = "camel.source.endpoint.messageAttributeNames";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_ATTRIBUTE_NAMES_DOC = "A list of message attribute names to receive when consuming. Multiple names can be separated by comma.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_ATTRIBUTE_NAMES_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_CONF = "camel.source.endpoint.sendEmptyMessageWhenIdle";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DOC = "If the polling consumer did not poll any files, you can enable this option to send an empty message (no body) instead.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SERVER_SIDE_ENCRYPTION_ENABLED_CONF = "camel.source.endpoint.serverSideEncryptionEnabled";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SERVER_SIDE_ENCRYPTION_ENABLED_DOC = "Define if Server Side Encryption is enabled or not on the queue";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_SERVER_SIDE_ENCRYPTION_ENABLED_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_VISIBILITY_TIMEOUT_CONF = "camel.source.endpoint.visibilityTimeout";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_VISIBILITY_TIMEOUT_DOC = "The duration (in seconds) that the received messages are hidden from subsequent retrieve requests after being retrieved by a ReceiveMessage request to set in the com.amazonaws.services.sqs.model.SetQueueAttributesRequest. This only make sense if its different from defaultVisibilityTimeout. It changes the queue visibility timeout attribute permanently.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_VISIBILITY_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_WAIT_TIME_SECONDS_CONF = "camel.source.endpoint.waitTimeSeconds";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_WAIT_TIME_SECONDS_DOC = "Duration in seconds (0 to 20) that the ReceiveMessage action call will wait until a message is in the queue to include in the response.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_WAIT_TIME_SECONDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_POLL_STRATEGY_CONF = "camel.source.endpoint.pollStrategy";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_POLL_STRATEGY_DOC = "A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing you to provide your custom implementation to control error handling usually occurred during the poll operation before an Exchange have been created and being routed in Camel.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_POLL_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_QUEUE_CONF = "camel.source.endpoint.delayQueue";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_QUEUE_DOC = "Define if you want to apply delaySeconds option to the queue or on single messages";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_QUEUE_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_URL_CONF = "camel.source.endpoint.queueUrl";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_URL_DOC = "To define the queueUrl explicitly. All other parameters, which would influence the queueUrl, are ignored. This parameter is intended to be used, to connect to a mock implementation of SQS, for testing purposes.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_URL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_HOST_CONF = "camel.source.endpoint.proxyHost";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_HOST_DOC = "To define a proxy host when instantiating the SQS client";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PORT_CONF = "camel.source.endpoint.proxyPort";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PORT_DOC = "To define a proxy port when instantiating the SQS client";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MAXIMUM_MESSAGE_SIZE_CONF = "camel.source.endpoint.maximumMessageSize";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MAXIMUM_MESSAGE_SIZE_DOC = "The maximumMessageSize (in bytes) an SQS message can contain for this queue.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MAXIMUM_MESSAGE_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_RETENTION_PERIOD_CONF = "camel.source.endpoint.messageRetentionPeriod";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_RETENTION_PERIOD_DOC = "The messageRetentionPeriod (in seconds) a message will be retained by SQS for this queue.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_RETENTION_PERIOD_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_POLICY_CONF = "camel.source.endpoint.policy";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_POLICY_DOC = "The policy for this queue";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_POLICY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_CONF = "camel.source.endpoint.receiveMessageWaitTimeSeconds";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_DOC = "If you do not specify WaitTimeSeconds in the request, the queue attribute ReceiveMessageWaitTimeSeconds is used to determine how long to wait.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_REDRIVE_POLICY_CONF = "camel.source.endpoint.redrivePolicy";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_REDRIVE_POLICY_DOC = "Specify the policy that send message to DeadLetter queue. See detail at Amazon docs.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_REDRIVE_POLICY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_ERROR_THRESHOLD_CONF = "camel.source.endpoint.backoffErrorThreshold";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DOC = "The number of subsequent error polls (failed due some error) that should happen before the backoffMultipler should kick-in.";
    public static final Integer CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_IDLE_THRESHOLD_CONF = "camel.source.endpoint.backoffIdleThreshold";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DOC = "The number of subsequent idle polls that should happen before the backoffMultipler should kick-in.";
    public static final Integer CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_MULTIPLIER_CONF = "camel.source.endpoint.backoffMultiplier";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_MULTIPLIER_DOC = "To let the scheduled polling consumer backoff if there has been a number of subsequent idles/errors in a row. The multiplier is then the number of polls that will be skipped before the next actual attempt is happening again. When this option is in use then backoffIdleThreshold and/or backoffErrorThreshold must also be configured.";
    public static final Integer CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_MULTIPLIER_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_CONF = "camel.source.endpoint.delay";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_DOC = "Milliseconds before the next poll.";
    public static final Long CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_DEFAULT = 500L;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_GREEDY_CONF = "camel.source.endpoint.greedy";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_GREEDY_DOC = "If greedy is enabled, then the ScheduledPollConsumer will run immediately again, if the previous run polled 1 or more messages.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_GREEDY_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_INITIAL_DELAY_CONF = "camel.source.endpoint.initialDelay";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_INITIAL_DELAY_DOC = "Milliseconds before the first poll starts.";
    public static final Long CAMEL_SOURCE_AWSSQS_ENDPOINT_INITIAL_DELAY_DEFAULT = 1000L;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_REPEAT_COUNT_CONF = "camel.source.endpoint.repeatCount";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_REPEAT_COUNT_DOC = "Specifies a maximum limit of number of fires. So if you set it to 1, the scheduler will only fire once. If you set it to 5, it will only fire five times. A value of zero or negative means fire forever.";
    public static final Long CAMEL_SOURCE_AWSSQS_ENDPOINT_REPEAT_COUNT_DEFAULT = 0L;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_RUN_LOGGING_LEVEL_CONF = "camel.source.endpoint.runLoggingLevel";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_RUN_LOGGING_LEVEL_DOC = "The consumer logs a start/complete log line when it polls. This option allows you to configure the logging level for that. One of: [TRACE] [DEBUG] [INFO] [WARN] [ERROR] [OFF]";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_RUN_LOGGING_LEVEL_DEFAULT = "TRACE";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_CONF = "camel.source.endpoint.scheduledExecutorService";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DOC = "Allows for configuring a custom/shared thread pool to use for the consumer. By default each consumer has its own single threaded thread pool.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_CONF = "camel.source.endpoint.scheduler";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_DOC = "To use a cron scheduler from either camel-spring or camel-quartz component. Use value spring or quartz for built in scheduler";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_DEFAULT = "none";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_PROPERTIES_CONF = "camel.source.endpoint.schedulerProperties";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_PROPERTIES_DOC = "To configure additional properties when using a custom scheduler or any of the Quartz, Spring based scheduler.";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_START_SCHEDULER_CONF = "camel.source.endpoint.startScheduler";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_START_SCHEDULER_DOC = "Whether the scheduler should be auto started.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_START_SCHEDULER_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_TIME_UNIT_CONF = "camel.source.endpoint.timeUnit";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_TIME_UNIT_DOC = "Time unit for initialDelay and delay options. One of: [NANOSECONDS] [MICROSECONDS] [MILLISECONDS] [SECONDS] [MINUTES] [HOURS] [DAYS]";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_TIME_UNIT_DEFAULT = "MILLISECONDS";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_USE_FIXED_DELAY_CONF = "camel.source.endpoint.useFixedDelay";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_USE_FIXED_DELAY_DOC = "Controls if fixed delay or fixed rate is used. See ScheduledExecutorService in JDK for details.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_ENDPOINT_USE_FIXED_DELAY_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_ACCESS_KEY_CONF = "camel.source.endpoint.accessKey";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_ACCESS_KEY_DOC = "Amazon AWS Access Key";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SECRET_KEY_CONF = "camel.source.endpoint.secretKey";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SECRET_KEY_DOC = "Amazon AWS Secret Key";
    public static final String CAMEL_SOURCE_AWSSQS_ENDPOINT_SECRET_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_AWSHOST_CONF = "camel.component.aws-sqs.amazonAWSHost";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_AWSHOST_DOC = "The hostname of the Amazon AWS cloud.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_AWSHOST_DEFAULT = "amazonaws.com";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_SQSCLIENT_CONF = "camel.component.aws-sqs.amazonSQSClient";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_SQSCLIENT_DOC = "To use the AmazonSQS as client";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_SQSCLIENT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_CREATE_QUEUE_CONF = "camel.component.aws-sqs.autoCreateQueue";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_CREATE_QUEUE_DOC = "Setting the autocreation of the queue";
    public static final Boolean CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_CREATE_QUEUE_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_DISCOVER_CLIENT_CONF = "camel.component.aws-sqs.autoDiscoverClient";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_DISCOVER_CLIENT_DOC = "Setting the autoDiscoverClient mechanism, if true, the component will look for a client instance in the registry automatically otherwise it will skip that checking.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_DISCOVER_CLIENT_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_CONFIGURATION_CONF = "camel.component.aws-sqs.configuration";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_CONFIGURATION_DOC = "The component configuration";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROTOCOL_CONF = "camel.component.aws-sqs.protocol";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROTOCOL_DOC = "The underlying protocol used to communicate with SQS";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROTOCOL_DEFAULT = "https";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PROTOCOL_CONF = "camel.component.aws-sqs.proxyProtocol";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PROTOCOL_DOC = "To define a proxy protocol when instantiating the SQS client One of: [HTTP] [HTTPS]";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PROTOCOL_DEFAULT = "HTTPS";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_OWNER_AWSACCOUNT_ID_CONF = "camel.component.aws-sqs.queueOwnerAWSAccountId";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_OWNER_AWSACCOUNT_ID_DOC = "Specify the queue owner aws account id when you need to connect the queue with different account owner.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_OWNER_AWSACCOUNT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_REGION_CONF = "camel.component.aws-sqs.region";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_REGION_DOC = "Specify the queue region which could be used with queueOwnerAWSAccountId to build the service URL. When using this parameter, the configuration will expect the capitalized name of the region (for example AP_EAST_1) You'll need to use the name Regions.EU_WEST_1.name()";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_REGION_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_ATTRIBUTE_NAMES_CONF = "camel.component.aws-sqs.attributeNames";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_ATTRIBUTE_NAMES_DOC = "A list of attribute names to receive when consuming. Multiple names can be separated by comma.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_ATTRIBUTE_NAMES_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.aws-sqs.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_CONCURRENT_CONSUMERS_CONF = "camel.component.aws-sqs.concurrentConsumers";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_CONCURRENT_CONSUMERS_DOC = "Allows you to use multiple threads to poll the sqs queue to increase throughput";
    public static final Integer CAMEL_SOURCE_AWSSQS_COMPONENT_CONCURRENT_CONSUMERS_DEFAULT = 1;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_DEFAULT_VISIBILITY_TIMEOUT_CONF = "camel.component.aws-sqs.defaultVisibilityTimeout";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_DEFAULT_VISIBILITY_TIMEOUT_DOC = "The default visibility timeout (in seconds)";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_DEFAULT_VISIBILITY_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_AFTER_READ_CONF = "camel.component.aws-sqs.deleteAfterRead";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_AFTER_READ_DOC = "Delete message from SQS after it has been read";
    public static final Boolean CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_AFTER_READ_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_IF_FILTERED_CONF = "camel.component.aws-sqs.deleteIfFiltered";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_IF_FILTERED_DOC = "Whether or not to send the DeleteMessage to the SQS queue if an exchange fails to get through a filter. If 'false' and exchange does not make it through a Camel filter upstream in the route, then don't send DeleteMessage.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_IF_FILTERED_DEFAULT = true;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_EXTEND_MESSAGE_VISIBILITY_CONF = "camel.component.aws-sqs.extendMessageVisibility";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_EXTEND_MESSAGE_VISIBILITY_DOC = "If enabled then a scheduled background task will keep extending the message visibility on SQS. This is needed if it takes a long time to process the message. If set to true defaultVisibilityTimeout must be set. See details at Amazon docs.";
    public static final Boolean CAMEL_SOURCE_AWSSQS_COMPONENT_EXTEND_MESSAGE_VISIBILITY_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_CONF = "camel.component.aws-sqs.kmsDataKeyReusePeriodSeconds";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_DOC = "The length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages before calling AWS KMS again. An integer representing seconds, between 60 seconds (1 minute) and 86,400 seconds (24 hours). Default: 300 (5 minutes).";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_MASTER_KEY_ID_CONF = "camel.component.aws-sqs.kmsMasterKeyId";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_MASTER_KEY_ID_DOC = "The ID of an AWS-managed customer master key (CMK) for Amazon SQS or a custom CMK.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_MASTER_KEY_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_ATTRIBUTE_NAMES_CONF = "camel.component.aws-sqs.messageAttributeNames";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_ATTRIBUTE_NAMES_DOC = "A list of message attribute names to receive when consuming. Multiple names can be separated by comma.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_ATTRIBUTE_NAMES_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_SERVER_SIDE_ENCRYPTION_ENABLED_CONF = "camel.component.aws-sqs.serverSideEncryptionEnabled";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_SERVER_SIDE_ENCRYPTION_ENABLED_DOC = "Define if Server Side Encryption is enabled or not on the queue";
    public static final Boolean CAMEL_SOURCE_AWSSQS_COMPONENT_SERVER_SIDE_ENCRYPTION_ENABLED_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_VISIBILITY_TIMEOUT_CONF = "camel.component.aws-sqs.visibilityTimeout";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_VISIBILITY_TIMEOUT_DOC = "The duration (in seconds) that the received messages are hidden from subsequent retrieve requests after being retrieved by a ReceiveMessage request to set in the com.amazonaws.services.sqs.model.SetQueueAttributesRequest. This only make sense if its different from defaultVisibilityTimeout. It changes the queue visibility timeout attribute permanently.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_VISIBILITY_TIMEOUT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_WAIT_TIME_SECONDS_CONF = "camel.component.aws-sqs.waitTimeSeconds";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_WAIT_TIME_SECONDS_DOC = "Duration in seconds (0 to 20) that the ReceiveMessage action call will wait until a message is in the queue to include in the response.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_WAIT_TIME_SECONDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.aws-sqs.basicPropertyBinding";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_AWSSQS_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_DELAY_QUEUE_CONF = "camel.component.aws-sqs.delayQueue";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_DELAY_QUEUE_DOC = "Define if you want to apply delaySeconds option to the queue or on single messages";
    public static final Boolean CAMEL_SOURCE_AWSSQS_COMPONENT_DELAY_QUEUE_DEFAULT = false;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_URL_CONF = "camel.component.aws-sqs.queueUrl";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_URL_DOC = "To define the queueUrl explicitly. All other parameters, which would influence the queueUrl, are ignored. This parameter is intended to be used, to connect to a mock implementation of SQS, for testing purposes.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_URL_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_HOST_CONF = "camel.component.aws-sqs.proxyHost";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_HOST_DOC = "To define a proxy host when instantiating the SQS client";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PORT_CONF = "camel.component.aws-sqs.proxyPort";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PORT_DOC = "To define a proxy port when instantiating the SQS client";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_MAXIMUM_MESSAGE_SIZE_CONF = "camel.component.aws-sqs.maximumMessageSize";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_MAXIMUM_MESSAGE_SIZE_DOC = "The maximumMessageSize (in bytes) an SQS message can contain for this queue.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_MAXIMUM_MESSAGE_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_RETENTION_PERIOD_CONF = "camel.component.aws-sqs.messageRetentionPeriod";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_RETENTION_PERIOD_DOC = "The messageRetentionPeriod (in seconds) a message will be retained by SQS for this queue.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_RETENTION_PERIOD_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_POLICY_CONF = "camel.component.aws-sqs.policy";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_POLICY_DOC = "The policy for this queue";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_POLICY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_CONF = "camel.component.aws-sqs.receiveMessageWaitTimeSeconds";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_DOC = "If you do not specify WaitTimeSeconds in the request, the queue attribute ReceiveMessageWaitTimeSeconds is used to determine how long to wait.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_REDRIVE_POLICY_CONF = "camel.component.aws-sqs.redrivePolicy";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_REDRIVE_POLICY_DOC = "Specify the policy that send message to DeadLetter queue. See detail at Amazon docs.";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_REDRIVE_POLICY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_ACCESS_KEY_CONF = "camel.component.aws-sqs.accessKey";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_ACCESS_KEY_DOC = "Amazon AWS Access Key";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_ACCESS_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_SECRET_KEY_CONF = "camel.component.aws-sqs.secretKey";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_SECRET_KEY_DOC = "Amazon AWS Secret Key";
    public static final String CAMEL_SOURCE_AWSSQS_COMPONENT_SECRET_KEY_DEFAULT = null;

    public CamelAwssqsSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelAwssqsSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_AWSSQS_PATH_QUEUE_NAME_OR_ARN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_PATH_QUEUE_NAME_OR_ARN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_AWSSQS_PATH_QUEUE_NAME_OR_ARN_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_AWSHOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_AWSHOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_AWSHOST_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_SQSCLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_SQSCLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_AMAZON_SQSCLIENT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_CREATE_QUEUE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_CREATE_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_CREATE_QUEUE_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_DISCOVER_CLIENT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_DISCOVER_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_AUTO_DISCOVER_CLIENT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_HEADER_FILTER_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_OWNER_AWSACCOUNT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_OWNER_AWSACCOUNT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_OWNER_AWSACCOUNT_ID_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_REGION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_REGION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_REGION_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_ATTRIBUTE_NAMES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_ATTRIBUTE_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_ATTRIBUTE_NAMES_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_CONCURRENT_CONSUMERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AWSSQS_ENDPOINT_CONCURRENT_CONSUMERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_CONCURRENT_CONSUMERS_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_DEFAULT_VISIBILITY_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_DEFAULT_VISIBILITY_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_DEFAULT_VISIBILITY_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_AFTER_READ_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_AFTER_READ_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_AFTER_READ_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_IF_FILTERED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_IF_FILTERED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_DELETE_IF_FILTERED_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_EXTEND_MESSAGE_VISIBILITY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_EXTEND_MESSAGE_VISIBILITY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_EXTEND_MESSAGE_VISIBILITY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_MASTER_KEY_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_MASTER_KEY_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_KMS_MASTER_KEY_ID_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_MAX_MESSAGES_PER_POLL_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AWSSQS_ENDPOINT_MAX_MESSAGES_PER_POLL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_MAX_MESSAGES_PER_POLL_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_ATTRIBUTE_NAMES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_ATTRIBUTE_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_ATTRIBUTE_NAMES_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_SEND_EMPTY_MESSAGE_WHEN_IDLE_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_SERVER_SIDE_ENCRYPTION_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_SERVER_SIDE_ENCRYPTION_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_SERVER_SIDE_ENCRYPTION_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_VISIBILITY_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_VISIBILITY_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_VISIBILITY_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_WAIT_TIME_SECONDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_WAIT_TIME_SECONDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_WAIT_TIME_SECONDS_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_POLL_STRATEGY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_POLL_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_POLL_STRATEGY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_QUEUE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_QUEUE_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_URL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_QUEUE_URL_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_HOST_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_PROXY_PORT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_MAXIMUM_MESSAGE_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_MAXIMUM_MESSAGE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_MAXIMUM_MESSAGE_SIZE_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_RETENTION_PERIOD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_RETENTION_PERIOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_MESSAGE_RETENTION_PERIOD_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_POLICY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_REDRIVE_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_REDRIVE_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_REDRIVE_POLICY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_ERROR_THRESHOLD_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_ERROR_THRESHOLD_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_IDLE_THRESHOLD_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_IDLE_THRESHOLD_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_MULTIPLIER_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_MULTIPLIER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_BACKOFF_MULTIPLIER_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_DELAY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_GREEDY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_GREEDY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_GREEDY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_INITIAL_DELAY_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AWSSQS_ENDPOINT_INITIAL_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_INITIAL_DELAY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_REPEAT_COUNT_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_AWSSQS_ENDPOINT_REPEAT_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_REPEAT_COUNT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_RUN_LOGGING_LEVEL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_RUN_LOGGING_LEVEL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_RUN_LOGGING_LEVEL_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULED_EXECUTOR_SERVICE_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_SCHEDULER_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_START_SCHEDULER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_START_SCHEDULER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_START_SCHEDULER_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_TIME_UNIT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_TIME_UNIT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_TIME_UNIT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_USE_FIXED_DELAY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_ENDPOINT_USE_FIXED_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_USE_FIXED_DELAY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_ACCESS_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_ACCESS_KEY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_ENDPOINT_SECRET_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_ENDPOINT_SECRET_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_ENDPOINT_SECRET_KEY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_AWSHOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_AWSHOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_AWSHOST_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_SQSCLIENT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_SQSCLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_AMAZON_SQSCLIENT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_CREATE_QUEUE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_CREATE_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_CREATE_QUEUE_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_DISCOVER_CLIENT_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_DISCOVER_CLIENT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_AUTO_DISCOVER_CLIENT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PROTOCOL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PROTOCOL_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_OWNER_AWSACCOUNT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_OWNER_AWSACCOUNT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_OWNER_AWSACCOUNT_ID_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_REGION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_REGION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_REGION_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_ATTRIBUTE_NAMES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_ATTRIBUTE_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_ATTRIBUTE_NAMES_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_CONCURRENT_CONSUMERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_AWSSQS_COMPONENT_CONCURRENT_CONSUMERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_CONCURRENT_CONSUMERS_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_DEFAULT_VISIBILITY_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_DEFAULT_VISIBILITY_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_DEFAULT_VISIBILITY_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_AFTER_READ_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_AFTER_READ_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_AFTER_READ_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_IF_FILTERED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_IF_FILTERED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_DELETE_IF_FILTERED_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_EXTEND_MESSAGE_VISIBILITY_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_COMPONENT_EXTEND_MESSAGE_VISIBILITY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_EXTEND_MESSAGE_VISIBILITY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_DATA_KEY_REUSE_PERIOD_SECONDS_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_MASTER_KEY_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_MASTER_KEY_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_KMS_MASTER_KEY_ID_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_ATTRIBUTE_NAMES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_ATTRIBUTE_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_ATTRIBUTE_NAMES_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_SERVER_SIDE_ENCRYPTION_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_COMPONENT_SERVER_SIDE_ENCRYPTION_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_SERVER_SIDE_ENCRYPTION_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_VISIBILITY_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_VISIBILITY_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_VISIBILITY_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_WAIT_TIME_SECONDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_WAIT_TIME_SECONDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_WAIT_TIME_SECONDS_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_DELAY_QUEUE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_AWSSQS_COMPONENT_DELAY_QUEUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_DELAY_QUEUE_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_URL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_URL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_QUEUE_URL_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_HOST_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_PROXY_PORT_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_MAXIMUM_MESSAGE_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_MAXIMUM_MESSAGE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_MAXIMUM_MESSAGE_SIZE_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_RETENTION_PERIOD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_RETENTION_PERIOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_MESSAGE_RETENTION_PERIOD_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_POLICY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_RECEIVE_MESSAGE_WAIT_TIME_SECONDS_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_REDRIVE_POLICY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_REDRIVE_POLICY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_REDRIVE_POLICY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_ACCESS_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_ACCESS_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_ACCESS_KEY_DOC);
        conf.define(CAMEL_SOURCE_AWSSQS_COMPONENT_SECRET_KEY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_AWSSQS_COMPONENT_SECRET_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_AWSSQS_COMPONENT_SECRET_KEY_DOC);
        return conf;
    }
}