/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.facebook;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelFacebookSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_FACEBOOK_PATH_METHOD_NAME_CONF = "camel.source.path.methodName";
    public static final String CAMEL_SOURCE_FACEBOOK_PATH_METHOD_NAME_DOC = "What operation to perform";
    public static final String CAMEL_SOURCE_FACEBOOK_PATH_METHOD_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_ACHIEVEMENT_URLCONF = "camel.source.endpoint.achievementURL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_ACHIEVEMENT_URLDOC = "The unique URL of the achievement";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_ACHIEVEMENT_URLDEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_ID_CONF = "camel.source.endpoint.albumId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_ID_DOC = "The album ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_UPDATE_CONF = "camel.source.endpoint.albumUpdate";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_UPDATE_DOC = "The facebook Album to be created or updated";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_UPDATE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_APP_ID_CONF = "camel.source.endpoint.appId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_APP_ID_DOC = "The ID of the Facebook Application";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_APP_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CENTER_CONF = "camel.source.endpoint.center";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CENTER_DOC = "Location latitude and longitude";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CENTER_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_ID_CONF = "camel.source.endpoint.checkinId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_ID_DOC = "The checkin ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_UPDATE_CONF = "camel.source.endpoint.checkinUpdate";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_UPDATE_DOC = "The checkin to be created. Deprecated, instead create a Post with an attached location";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_UPDATE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_URLCONF = "camel.source.endpoint.clientURL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_URLDOC = "Facebook4J API client URL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_URLDEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_VERSION_CONF = "camel.source.endpoint.clientVersion";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_VERSION_DOC = "Facebook4J client API version";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_VERSION_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_ID_CONF = "camel.source.endpoint.commentId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_ID_DOC = "The comment ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_UPDATE_CONF = "camel.source.endpoint.commentUpdate";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_UPDATE_DOC = "The facebook Comment to be created or updated";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_UPDATE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DEBUG_ENABLED_CONF = "camel.source.endpoint.debugEnabled";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DEBUG_ENABLED_DOC = "Enables deubg output. Effective only with the embedded logger";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DEBUG_ENABLED_DEFAULT = "false";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DESCRIPTION_CONF = "camel.source.endpoint.description";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DESCRIPTION_DOC = "The description text";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DESCRIPTION_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DISTANCE_CONF = "camel.source.endpoint.distance";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DISTANCE_DOC = "Distance in meters";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DISTANCE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_ID_CONF = "camel.source.endpoint.domainId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_ID_DOC = "The domain ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAME_CONF = "camel.source.endpoint.domainName";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAME_DOC = "The domain name";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAMES_CONF = "camel.source.endpoint.domainNames";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAMES_DOC = "The domain names";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAMES_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_ID_CONF = "camel.source.endpoint.eventId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_ID_DOC = "The event ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_UPDATE_CONF = "camel.source.endpoint.eventUpdate";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_UPDATE_DOC = "The event to be created or updated";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_UPDATE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_ID_CONF = "camel.source.endpoint.friendId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_ID_DOC = "The friend ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_ID_CONF = "camel.source.endpoint.friendlistId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_ID_DOC = "The friend list ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_NAME_CONF = "camel.source.endpoint.friendlistName";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_NAME_DOC = "The friend list Name";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_USER_ID_CONF = "camel.source.endpoint.friendUserId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_USER_ID_DOC = "The friend user ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_USER_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_GROUP_ID_CONF = "camel.source.endpoint.groupId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_GROUP_ID_DOC = "The group ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_GROUP_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_GZIP_ENABLED_CONF = "camel.source.endpoint.gzipEnabled";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_GZIP_ENABLED_DOC = "Use Facebook GZIP encoding";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_GZIP_ENABLED_DEFAULT = "true";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_CONNECTION_TIMEOUT_CONF = "camel.source.endpoint.httpConnectionTimeout";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_CONNECTION_TIMEOUT_DOC = "Http connection timeout in milliseconds";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_CONNECTION_TIMEOUT_DEFAULT = "20000";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_DEFAULT_MAX_PER_ROUTE_CONF = "camel.source.endpoint.httpDefaultMaxPerRoute";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_DEFAULT_MAX_PER_ROUTE_DOC = "HTTP maximum connections per route";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_DEFAULT_MAX_PER_ROUTE_DEFAULT = "2";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_MAX_TOTAL_CONNECTIONS_CONF = "camel.source.endpoint.httpMaxTotalConnections";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_MAX_TOTAL_CONNECTIONS_DOC = "HTTP maximum total connections";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_MAX_TOTAL_CONNECTIONS_DEFAULT = "20";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_READ_TIMEOUT_CONF = "camel.source.endpoint.httpReadTimeout";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_READ_TIMEOUT_DOC = "Http read timeout in milliseconds";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_READ_TIMEOUT_DEFAULT = "120000";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_COUNT_CONF = "camel.source.endpoint.httpRetryCount";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_COUNT_DOC = "Number of HTTP retries";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_COUNT_DEFAULT = "0";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_INTERVAL_SECONDS_CONF = "camel.source.endpoint.httpRetryIntervalSeconds";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_INTERVAL_SECONDS_DOC = "HTTP retry interval in seconds";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_INTERVAL_SECONDS_DEFAULT = "5";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_STREAMING_READ_TIMEOUT_CONF = "camel.source.endpoint.httpStreamingReadTimeout";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_STREAMING_READ_TIMEOUT_DOC = "HTTP streaming read timeout in milliseconds";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_STREAMING_READ_TIMEOUT_DEFAULT = "40000";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_IDS_CONF = "camel.source.endpoint.ids";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_IDS_DOC = "The ids of users";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_IDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_IN_BODY_CONF = "camel.source.endpoint.inBody";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_IN_BODY_DOC = "Sets the name of a parameter to be passed in the exchange In Body";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_IN_BODY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_INCLUDE_READ_CONF = "camel.source.endpoint.includeRead";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_INCLUDE_READ_DOC = "Enables notifications that the user has already read in addition to unread ones";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_INCLUDE_READ_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_IS_HIDDEN_CONF = "camel.source.endpoint.isHidden";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_IS_HIDDEN_DOC = "Whether hidden";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_IS_HIDDEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_JSON_STORE_ENABLED_CONF = "camel.source.endpoint.jsonStoreEnabled";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_JSON_STORE_ENABLED_DOC = "If set to true, raw JSON forms will be stored in DataObjectFactory";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_JSON_STORE_ENABLED_DEFAULT = "false";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_CONF = "camel.source.endpoint.link";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_DOC = "Link URL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_ID_CONF = "camel.source.endpoint.linkId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_ID_DOC = "Link ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_LOCALE_CONF = "camel.source.endpoint.locale";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_LOCALE_DOC = "Desired FQL locale";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_LOCALE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MBEAN_ENABLED_CONF = "camel.source.endpoint.mbeanEnabled";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MBEAN_ENABLED_DOC = "If set to true, Facebook4J mbean will be registerd";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MBEAN_ENABLED_DEFAULT = "false";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_CONF = "camel.source.endpoint.message";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_DOC = "The message text";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_ID_CONF = "camel.source.endpoint.messageId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_ID_DOC = "The message ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_METRIC_CONF = "camel.source.endpoint.metric";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_METRIC_DOC = "The metric name";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_METRIC_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MILESTONE_ID_CONF = "camel.source.endpoint.milestoneId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MILESTONE_ID_DOC = "The milestone id";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_MILESTONE_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_NAME_CONF = "camel.source.endpoint.name";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_NAME_DOC = "Test user name, must be of the form 'first last'";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTE_ID_CONF = "camel.source.endpoint.noteId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTE_ID_DOC = "The note ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTE_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTIFICATION_ID_CONF = "camel.source.endpoint.notificationId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTIFICATION_ID_DOC = "The notification ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTIFICATION_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OBJECT_ID_CONF = "camel.source.endpoint.objectId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OBJECT_ID_DOC = "The insight object ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OBJECT_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OFFER_ID_CONF = "camel.source.endpoint.offerId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OFFER_ID_DOC = "The offer id";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OFFER_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OPTION_DESCRIPTION_CONF = "camel.source.endpoint.optionDescription";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OPTION_DESCRIPTION_DOC = "The question's answer option description";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OPTION_DESCRIPTION_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PAGE_ID_CONF = "camel.source.endpoint.pageId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PAGE_ID_DOC = "The page id";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PAGE_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSION_NAME_CONF = "camel.source.endpoint.permissionName";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSION_NAME_DOC = "The permission name";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSION_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSIONS_CONF = "camel.source.endpoint.permissions";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSIONS_DOC = "Test user permissions in the format perm1,perm2,...";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PHOTO_ID_CONF = "camel.source.endpoint.photoId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PHOTO_ID_DOC = "The photo ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PHOTO_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_CONF = "camel.source.endpoint.pictureId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_DOC = "The picture id";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_2CONF = "camel.source.endpoint.pictureId2";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_2DOC = "The picture2 id";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_2DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_SIZE_CONF = "camel.source.endpoint.pictureSize";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_SIZE_DOC = "The picture size One of: [square] [small] [normal] [large] [thumbnail] [album]";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PLACE_ID_CONF = "camel.source.endpoint.placeId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PLACE_ID_DOC = "The place ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PLACE_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_ID_CONF = "camel.source.endpoint.postId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_ID_DOC = "The post ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_UPDATE_CONF = "camel.source.endpoint.postUpdate";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_UPDATE_DOC = "The post to create or update";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_UPDATE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PRETTY_DEBUG_ENABLED_CONF = "camel.source.endpoint.prettyDebugEnabled";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PRETTY_DEBUG_ENABLED_DOC = "Prettify JSON debug output if set to true";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_PRETTY_DEBUG_ENABLED_DEFAULT = "false";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERIES_CONF = "camel.source.endpoint.queries";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERIES_DOC = "FQL queries";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERY_CONF = "camel.source.endpoint.query";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERY_DOC = "FQL query or search terms for search endpoints";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERY_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUESTION_ID_CONF = "camel.source.endpoint.questionId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUESTION_ID_DOC = "The question id";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUESTION_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_CONF = "camel.source.endpoint.reading";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_DOC = "Optional reading parameters. See Reading Options(#reading)";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_OPTIONS_CONF = "camel.source.endpoint.readingOptions";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_OPTIONS_DOC = "To configure Reading using key/value pairs from the Map.";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_OPTIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_REST_BASE_URLCONF = "camel.source.endpoint.restBaseURL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_REST_BASE_URLDOC = "API base URL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_REST_BASE_URLDEFAULT = "https://graph.facebook.com/";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SCORE_VALUE_CONF = "camel.source.endpoint.scoreValue";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SCORE_VALUE_DOC = "The numeric score with value";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SCORE_VALUE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SIZE_CONF = "camel.source.endpoint.size";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SIZE_DOC = "The picture size, one of large, normal, small or square One of: [square] [small] [normal] [large] [thumbnail] [album]";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SIZE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SOURCE_CONF = "camel.source.endpoint.source";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SOURCE_DOC = "The media content from either a java.io.File or java.io.Inputstream";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SOURCE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SUBJECT_CONF = "camel.source.endpoint.subject";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SUBJECT_DOC = "The note of the subject";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SUBJECT_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAB_ID_CONF = "camel.source.endpoint.tabId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAB_ID_DOC = "The tab id";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAB_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAG_UPDATE_CONF = "camel.source.endpoint.tagUpdate";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAG_UPDATE_DOC = "Photo tag information";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAG_UPDATE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_1CONF = "camel.source.endpoint.testUser1";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_1DOC = "Test user 1";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_1DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_2CONF = "camel.source.endpoint.testUser2";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_2DOC = "Test user 2";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_2DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_ID_CONF = "camel.source.endpoint.testUserId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_ID_DOC = "The ID of the test user";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TITLE_CONF = "camel.source.endpoint.title";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TITLE_DOC = "The title text";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TITLE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_ID_CONF = "camel.source.endpoint.toUserId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_ID_DOC = "The ID of the user to tag";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_IDS_CONF = "camel.source.endpoint.toUserIds";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_IDS_DOC = "The IDs of the users to tag";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_IDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_CONF = "camel.source.endpoint.userId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_DOC = "The Facebook user ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_1CONF = "camel.source.endpoint.userId1";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_1DOC = "The ID of a user 1";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_1DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_2CONF = "camel.source.endpoint.userId2";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_2DOC = "The ID of a user 2";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_2DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_IDS_CONF = "camel.source.endpoint.userIds";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_IDS_DOC = "The IDs of users to invite to event";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_IDS_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_LOCALE_CONF = "camel.source.endpoint.userLocale";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_LOCALE_DOC = "The test user locale";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_LOCALE_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USE_SSLCONF = "camel.source.endpoint.useSSL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USE_SSLDOC = "Use SSL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_USE_SSLDEFAULT = "true";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_BASE_URLCONF = "camel.source.endpoint.videoBaseURL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_BASE_URLDOC = "Video API base URL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_BASE_URLDEFAULT = "https://graph-video.facebook.com/";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_ID_CONF = "camel.source.endpoint.videoId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_ID_DOC = "The video ID";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_FACEBOOK_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_BASIC_PROPERTY_BINDING_CONF = "camel.source.endpoint.basicPropertyBinding";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_BASIC_PROPERTY_BINDING_DOC = "Whether the endpoint should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_FACEBOOK_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_FACEBOOK_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_HOST_CONF = "camel.source.endpoint.httpProxyHost";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_HOST_DOC = "HTTP proxy server host name";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_HOST_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PASSWORD_CONF = "camel.source.endpoint.httpProxyPassword";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PASSWORD_DOC = "HTTP proxy server password";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PORT_CONF = "camel.source.endpoint.httpProxyPort";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PORT_DOC = "HTTP proxy server port";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PORT_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_USER_CONF = "camel.source.endpoint.httpProxyUser";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_USER_DOC = "HTTP proxy server user name";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_USER_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_CONF = "camel.source.endpoint.oAuthAccessToken";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_DOC = "The user access token";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_URLCONF = "camel.source.endpoint.oAuthAccessTokenURL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_URLDOC = "OAuth access token URL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_URLDEFAULT = "https://graph.facebook.com/oauth/access_token";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_ID_CONF = "camel.source.endpoint.oAuthAppId";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_ID_DOC = "The application Id";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_ID_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_SECRET_CONF = "camel.source.endpoint.oAuthAppSecret";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_SECRET_DOC = "The application Secret";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_SECRET_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_AUTHORIZATION_URLCONF = "camel.source.endpoint.oAuthAuthorizationURL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_AUTHORIZATION_URLDOC = "OAuth authorization URL";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_AUTHORIZATION_URLDEFAULT = "https://www.facebook.com/dialog/oauth";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_PERMISSIONS_CONF = "camel.source.endpoint.oAuthPermissions";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_PERMISSIONS_DOC = "Default OAuth permissions. Comma separated permission names. See https://developers.facebook.com/docs/reference/login/#permissions for the detail";
    public static final String CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_PERMISSIONS_DEFAULT = null;
    public static final String CAMEL_SOURCE_FACEBOOK_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.facebook.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_FACEBOOK_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_FACEBOOK_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_FACEBOOK_COMPONENT_BASIC_PROPERTY_BINDING_CONF = "camel.component.facebook.basicPropertyBinding";
    public static final String CAMEL_SOURCE_FACEBOOK_COMPONENT_BASIC_PROPERTY_BINDING_DOC = "Whether the component should use basic property binding (Camel 2.x) or the newer property binding with additional capabilities";
    public static final Boolean CAMEL_SOURCE_FACEBOOK_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT = false;
    public static final String CAMEL_SOURCE_FACEBOOK_COMPONENT_CONFIGURATION_CONF = "camel.component.facebook.configuration";
    public static final String CAMEL_SOURCE_FACEBOOK_COMPONENT_CONFIGURATION_DOC = "To use the shared configuration";
    public static final String CAMEL_SOURCE_FACEBOOK_COMPONENT_CONFIGURATION_DEFAULT = null;

    public CamelFacebookSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelFacebookSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_FACEBOOK_PATH_METHOD_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_PATH_METHOD_NAME_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_FACEBOOK_PATH_METHOD_NAME_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_ACHIEVEMENT_URLCONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_ACHIEVEMENT_URLDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_ACHIEVEMENT_URLDOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_UPDATE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_UPDATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_ALBUM_UPDATE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_APP_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_APP_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_APP_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_CENTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_CENTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_CENTER_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_UPDATE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_UPDATE_DEFAULT, ConfigDef.Importance.LOW, CAMEL_SOURCE_FACEBOOK_ENDPOINT_CHECKIN_UPDATE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_URLCONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_URLDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_URLDOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_VERSION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_VERSION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_CLIENT_VERSION_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_UPDATE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_UPDATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_COMMENT_UPDATE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_DEBUG_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DEBUG_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DEBUG_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_DESCRIPTION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DESCRIPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DESCRIPTION_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_DISTANCE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DISTANCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DISTANCE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAME_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAMES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_DOMAIN_NAMES_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_UPDATE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_UPDATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_EVENT_UPDATE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIENDLIST_NAME_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_USER_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_USER_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_FRIEND_USER_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_GROUP_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_GROUP_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_GROUP_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_GZIP_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_GZIP_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_GZIP_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_CONNECTION_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_CONNECTION_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_CONNECTION_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_DEFAULT_MAX_PER_ROUTE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_DEFAULT_MAX_PER_ROUTE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_DEFAULT_MAX_PER_ROUTE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_MAX_TOTAL_CONNECTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_MAX_TOTAL_CONNECTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_MAX_TOTAL_CONNECTIONS_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_READ_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_READ_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_READ_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_COUNT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_COUNT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_COUNT_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_INTERVAL_SECONDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_INTERVAL_SECONDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_RETRY_INTERVAL_SECONDS_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_STREAMING_READ_TIMEOUT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_STREAMING_READ_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_STREAMING_READ_TIMEOUT_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_IDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_IDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_IDS_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_IN_BODY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_IN_BODY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_IN_BODY_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_INCLUDE_READ_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_INCLUDE_READ_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_INCLUDE_READ_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_IS_HIDDEN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_IS_HIDDEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_IS_HIDDEN_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_JSON_STORE_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_JSON_STORE_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_JSON_STORE_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_LINK_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_LOCALE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_LOCALE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_LOCALE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_MBEAN_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_MBEAN_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_MBEAN_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_MESSAGE_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_METRIC_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_METRIC_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_METRIC_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_MILESTONE_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_MILESTONE_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_MILESTONE_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_NAME_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTE_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTE_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTE_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTIFICATION_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTIFICATION_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_NOTIFICATION_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_OBJECT_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OBJECT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OBJECT_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_OFFER_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OFFER_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OFFER_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_OPTION_DESCRIPTION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OPTION_DESCRIPTION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OPTION_DESCRIPTION_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_PAGE_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PAGE_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PAGE_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSION_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSION_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSION_NAME_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PERMISSIONS_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_PHOTO_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PHOTO_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PHOTO_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_2CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_2DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_ID_2DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PICTURE_SIZE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_PLACE_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PLACE_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PLACE_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_UPDATE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_UPDATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_POST_UPDATE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_PRETTY_DEBUG_ENABLED_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PRETTY_DEBUG_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_PRETTY_DEBUG_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERIES_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUERY_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUESTION_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUESTION_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_QUESTION_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_OPTIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_OPTIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_READING_OPTIONS_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_REST_BASE_URLCONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_REST_BASE_URLDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_REST_BASE_URLDOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_SCORE_VALUE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_SCORE_VALUE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_SCORE_VALUE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_SIZE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_SIZE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_SIZE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_SOURCE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_SOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_SOURCE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_SUBJECT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_SUBJECT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_SUBJECT_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAB_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAB_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAB_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAG_UPDATE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAG_UPDATE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TAG_UPDATE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_1CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_1DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_1DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_2CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_2DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_2DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TEST_USER_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_TITLE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TITLE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TITLE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_IDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_IDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_TO_USER_IDS_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_1CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_1DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_1DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_2CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_2DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_ID_2DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_IDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_IDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_IDS_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_LOCALE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_LOCALE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USER_LOCALE_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_USE_SSLCONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USE_SSLDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_USE_SSLDOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_BASE_URLCONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_BASE_URLDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_BASE_URLDOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_VIDEO_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_FACEBOOK_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_FACEBOOK_ENDPOINT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_FACEBOOK_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_HOST_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_HOST_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_HOST_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PASSWORD_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PORT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PORT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_PORT_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_USER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_USER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_HTTP_PROXY_USER_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_URLCONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_URLDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_ACCESS_TOKEN_URLDOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_ID_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_ID_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_ID_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_SECRET_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_SECRET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_APP_SECRET_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_AUTHORIZATION_URLCONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_AUTHORIZATION_URLDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_AUTHORIZATION_URLDOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_PERMISSIONS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_PERMISSIONS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_ENDPOINT_OAUTH_PERMISSIONS_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_FACEBOOK_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_COMPONENT_BASIC_PROPERTY_BINDING_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_FACEBOOK_COMPONENT_BASIC_PROPERTY_BINDING_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_COMPONENT_BASIC_PROPERTY_BINDING_DOC);
        conf.define(CAMEL_SOURCE_FACEBOOK_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_FACEBOOK_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_FACEBOOK_COMPONENT_CONFIGURATION_DOC);
        return conf;
    }
}