
    CREATE OR REPLACE PROCEDURE execute_if_exists(statement VARCHAR) AUTHID CURRENT_USER AS 
        table_does_not_exist exception;  
        PRAGMA EXCEPTION_INIT(table_does_not_exist, -00942);
        sequence_does_not_exist exception;  
        PRAGMA EXCEPTION_INIT(sequence_does_not_exist, -02289);
        name_already_in_use exception;  
        PRAGMA EXCEPTION_INIT(name_already_in_use, -00955);
    BEGIN
        EXECUTE IMMEDIATE statement;
    EXCEPTION
        WHEN table_does_not_exist THEN
            NULL;
        WHEN sequence_does_not_exist THEN
            NULL;
        WHEN name_already_in_use THEN
            NULL;
    END; 
    /

    CREATE OR REPLACE PROCEDURE execute_if_not_exists(statement VARCHAR) AUTHID CURRENT_USER AS 
        name_already_in_use exception;  
        PRAGMA EXCEPTION_INIT(name_already_in_use, -00955);
    BEGIN
        EXECUTE IMMEDIATE statement;
    EXCEPTION
        WHEN name_already_in_use THEN
            NULL;
    END; 
    /
