/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.Annotated;
import net.sourceforge.plantuml.AnnotatedBuilder;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.klimt.UGroup;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.svek.DecorateEntityImage;

public class AnnotatedWorker {
    private final Annotated annotated;
    private final AnnotatedBuilder builder;

    public AnnotatedWorker(Annotated annotated, AnnotatedBuilder builder) {
        this.annotated = annotated;
        this.builder = builder;
    }

    public TextBlock addAdd(TextBlock result) {
        result = this.builder.decoreWithFrame(result);
        result = this.addLegend(result);
        result = this.addTitle(result);
        result = this.addCaption(result);
        result = this.builder.addHeaderAndFooter(result);
        return result;
    }

    public TextBlock addLegend(TextBlock original) {
        DisplayPositioned legend = this.annotated.getLegend();
        if (legend.isNull()) {
            return original;
        }
        UGroup group = new UGroup(legend.getLineLocation());
        group.put(UGroupType.CLASS, "legend");
        return DecorateEntityImage.add(group, original, this.builder.getLegend(), legend.getHorizontalAlignment(), legend.getVerticalAlignment());
    }

    public TextBlock addTitle(TextBlock original) {
        DisplayPositioned title = (DisplayPositioned)this.annotated.getTitle();
        if (title.isNull()) {
            return original;
        }
        UGroup group = new UGroup(title.getLineLocation());
        group.put(UGroupType.CLASS, "title");
        return DecorateEntityImage.addTop(group, original, this.builder.getTitle(), HorizontalAlignment.CENTER);
    }

    private TextBlock addCaption(TextBlock original) {
        DisplayPositioned caption = this.annotated.getCaption();
        if (caption.isNull()) {
            return original;
        }
        UGroup group = new UGroup(caption.getLineLocation());
        group.put(UGroupType.CLASS, "caption");
        return DecorateEntityImage.addBottom(group, original, this.builder.getCaption(), HorizontalAlignment.CENTER);
    }
}

