/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.plugins;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mockito.internal.configuration.plugins.DefaultMockitoPlugins;
import org.mockito.internal.configuration.plugins.PluginInitializer;
import org.mockito.plugins.PluginSwitch;

class PluginLoader {
    private final DefaultMockitoPlugins plugins;
    private final PluginInitializer initializer;

    PluginLoader(DefaultMockitoPlugins plugins, PluginInitializer initializer) {
        this.plugins = plugins;
        this.initializer = initializer;
    }

    PluginLoader(PluginSwitch pluginSwitch) {
        this(new DefaultMockitoPlugins(), new PluginInitializer(pluginSwitch, null, new DefaultMockitoPlugins()));
    }

    @Deprecated
    PluginLoader(PluginSwitch pluginSwitch, String alias) {
        this(new DefaultMockitoPlugins(), new PluginInitializer(pluginSwitch, alias, new DefaultMockitoPlugins()));
    }

    <T> T loadPlugin(Class<T> pluginType) {
        return (T)this.loadPlugin(pluginType, null);
    }

    <PreferredType, AlternateType> Object loadPlugin(final Class<PreferredType> preferredPluginType, final Class<AlternateType> alternatePluginType) {
        try {
            AlternateType alternatePlugin;
            PreferredType preferredPlugin = this.initializer.loadImpl(preferredPluginType);
            if (preferredPlugin != null) {
                return preferredPlugin;
            }
            if (alternatePluginType != null && (alternatePlugin = this.initializer.loadImpl(alternatePluginType)) != null) {
                return alternatePlugin;
            }
            return this.plugins.getDefaultPlugin(preferredPluginType);
        }
        catch (Throwable t) {
            return Proxy.newProxyInstance(preferredPluginType.getClassLoader(), new Class[]{preferredPluginType}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    throw new IllegalStateException("Could not initialize plugin: " + preferredPluginType + " (alternate: " + alternatePluginType + ")", t);
                }
            });
        }
    }
}

