/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.spi;

import jakarta.persistence.AttributeConverter;
import java.lang.annotation.Annotation;
import java.util.Objects;
import org.hibernate.models.spi.AnnotationDescriptor;

public class ConversionRegistration {
    private final Class<?> explicitDomainType;
    private final Class<? extends AttributeConverter<?, ?>> converterType;
    private final boolean autoApply;
    private final AnnotationDescriptor<? extends Annotation> source;

    public ConversionRegistration(Class<?> explicitDomainType, Class<? extends AttributeConverter<?, ?>> converterType, boolean autoApply, AnnotationDescriptor<? extends Annotation> source) {
        assert (converterType != null);
        this.explicitDomainType = explicitDomainType;
        this.converterType = converterType;
        this.autoApply = autoApply;
        this.source = source;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConversionRegistration)) {
            return false;
        }
        ConversionRegistration that = (ConversionRegistration)object;
        return this.autoApply == that.autoApply && Objects.equals(this.explicitDomainType, that.explicitDomainType) && this.converterType.equals(that.converterType);
    }

    public int hashCode() {
        return Objects.hash(this.explicitDomainType, this.converterType);
    }

    public Class<?> getExplicitDomainType() {
        return this.explicitDomainType;
    }

    public Class<? extends AttributeConverter<?, ?>> getConverterType() {
        return this.converterType;
    }

    public boolean isAutoApply() {
        return this.autoApply;
    }

    public AnnotationDescriptor<? extends Annotation> getSource() {
        return this.source;
    }

    public String toString() {
        return "ConversionRegistration( " + this.converterType.getName() + ", " + this.source.getAnnotationType().getSimpleName() + ", " + this.autoApply + ")";
    }
}

