/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;

public final class CharSequenceIterator
implements CharacterIterator {
    @NotNull
    private final CharSequence myText;
    private final int myStart;
    private final int myEnd;
    private int myIndex;

    public CharSequenceIterator(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            CharSequenceIterator.$$$reportNull$$$0(0);
        }
        this.myText = text;
        this.myStart = start;
        this.myEnd = end;
        this.myIndex = this.myStart;
    }

    @Override
    public char first() {
        this.myIndex = this.myStart;
        return this.current();
    }

    @Override
    public char last() {
        this.myIndex = this.myStart == this.myEnd ? this.myEnd : this.myEnd - 1;
        return this.current();
    }

    @Override
    public char current() {
        return this.myIndex < this.myEnd ? this.myText.charAt(this.myIndex) : (char)'\uffff';
    }

    @Override
    public char next() {
        this.myIndex = Math.min(this.myEnd, this.myIndex + 1);
        return this.current();
    }

    @Override
    public char previous() {
        if (this.myIndex == this.myStart) {
            return '\uffff';
        }
        --this.myIndex;
        return this.current();
    }

    @Override
    public char setIndex(int position) {
        if (position < this.myStart || position > this.myEnd) {
            throw new IllegalArgumentException("Position: " + position + ", start: " + this.myStart + ", end: " + this.myEnd);
        }
        this.myIndex = position;
        return this.current();
    }

    @Override
    public int getBeginIndex() {
        return this.myStart;
    }

    @Override
    public int getEndIndex() {
        return this.myEnd;
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public CharSequenceIterator clone() {
        try {
            return (CharSequenceIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/CharSequenceIterator", "<init>"));
    }
}

