/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenEventHandler;
import org.jetbrains.idea.maven.server.MavenArtifactEvent;
import org.jetbrains.idea.maven.server.MavenServerConsoleEvent;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenLogEventHandler;", "Lorg/jetbrains/idea/maven/buildtool/MavenEventHandler;", "<init>", "()V", "handleConsoleEvents", "", "consoleEvents", "", "Lorg/jetbrains/idea/maven/server/MavenServerConsoleEvent;", "handleDownloadEvents", "downloadEvents", "Lorg/jetbrains/idea/maven/server/MavenArtifactEvent;", "intellij.maven"})
public final class MavenLogEventHandler
implements MavenEventHandler {
    @NotNull
    public static final MavenLogEventHandler INSTANCE = new MavenLogEventHandler();

    private MavenLogEventHandler() {
    }

    @Override
    public void handleConsoleEvents(@NotNull List<? extends MavenServerConsoleEvent> consoleEvents) {
        Intrinsics.checkNotNullParameter(consoleEvents, (String)"consoleEvents");
        for (MavenServerConsoleEvent mavenServerConsoleEvent : consoleEvents) {
            Throwable throwable;
            String message = mavenServerConsoleEvent.getMessage();
            switch (mavenServerConsoleEvent.getLevel()) {
                case 0: {
                    MavenLog.LOG.debug(message);
                    break;
                }
                case 1: {
                    MavenLog.LOG.info(message);
                    break;
                }
                default: {
                    MavenLog.LOG.warn(message);
                }
            }
            if ((throwable = mavenServerConsoleEvent.getThrowable()) == null) continue;
            MavenLog.LOG.warn(throwable);
        }
    }

    @Override
    public void handleDownloadEvents(@NotNull List<? extends MavenArtifactEvent> downloadEvents) {
        Intrinsics.checkNotNullParameter(downloadEvents, (String)"downloadEvents");
        block5: for (MavenArtifactEvent mavenArtifactEvent : downloadEvents) {
            String id = mavenArtifactEvent.getDependencyId();
            switch (WhenMappings.$EnumSwitchMapping$0[mavenArtifactEvent.getArtifactEventType().ordinal()]) {
                case 1: {
                    MavenLog.LOG.debug("Download started: " + id);
                    continue block5;
                }
                case 2: {
                    MavenLog.LOG.debug("Download completed: " + id);
                    continue block5;
                }
                case 3: {
                    MavenLog.LOG.debug("Download failed: " + id + " \n" + mavenArtifactEvent.getErrorMessage() + " \n" + mavenArtifactEvent.getStackTrace());
                    continue block5;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MavenArtifactEvent.ArtifactEventType.values().length];
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_COMPLETED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MavenArtifactEvent.ArtifactEventType.DOWNLOAD_FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

