/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.treeview;

import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.context.IndexingContext;
import org.sonatype.nexus.index.treeview.DefaultTreeNode;
import org.sonatype.nexus.index.treeview.IndexTreeView;
import org.sonatype.nexus.index.treeview.TreeNode;
import org.sonatype.nexus.index.treeview.TreeNodeFactory;

public class DefaultTreeNodeFactory
implements TreeNodeFactory {
    private IndexingContext context;

    public DefaultTreeNodeFactory(IndexingContext ctx) {
        this.context = ctx;
    }

    public IndexingContext getIndexingContext() {
        return this.context;
    }

    public TreeNode createGNode(IndexTreeView tview, String path, String groupName) {
        TreeNode result = this.createNode(tview, path, false, groupName, TreeNode.Type.G);
        return this.decorateGNode(tview, path, groupName, result);
    }

    protected TreeNode decorateGNode(IndexTreeView tview, String path, String groupName, TreeNode node) {
        return node;
    }

    public TreeNode createANode(IndexTreeView tview, ArtifactInfo ai, String path) {
        TreeNode result = this.createNode(tview, path, false, ai.artifactId, TreeNode.Type.A);
        result.setGroupId(ai.groupId);
        result.setArtifactId(ai.artifactId);
        return this.decorateANode(tview, ai, path, result);
    }

    protected TreeNode decorateANode(IndexTreeView tview, ArtifactInfo ai, String path, TreeNode node) {
        return node;
    }

    public TreeNode createVNode(IndexTreeView tview, ArtifactInfo ai, String path) {
        TreeNode result = this.createNode(tview, path, false, ai.version, TreeNode.Type.V);
        result.setGroupId(ai.groupId);
        result.setArtifactId(ai.artifactId);
        result.setVersion(ai.version);
        return this.decorateVNode(tview, ai, path, result);
    }

    protected TreeNode decorateVNode(IndexTreeView tview, ArtifactInfo ai, String path, TreeNode node) {
        return node;
    }

    public TreeNode createArtifactNode(IndexTreeView tview, ArtifactInfo ai, String path) {
        StringBuffer sb = new StringBuffer(ai.artifactId).append("-").append(ai.version);
        if (ai.classifier != null) {
            sb.append("-").append(ai.classifier);
        }
        sb.append(".").append(ai.fextension == null ? "jar" : ai.fextension);
        TreeNode result = this.createNode(tview, path, true, sb.toString(), TreeNode.Type.artifact);
        result.setGroupId(ai.groupId);
        result.setArtifactId(ai.artifactId);
        result.setVersion(ai.version);
        return this.decorateArtifactNode(tview, ai, path, result);
    }

    protected TreeNode decorateArtifactNode(IndexTreeView tview, ArtifactInfo ai, String path, TreeNode node) {
        return node;
    }

    protected TreeNode createNode(IndexTreeView tview, String path, boolean leaf, String nodeName, TreeNode.Type type) {
        TreeNode result = this.instantiateNode(tview, path, leaf, nodeName);
        result.setPath(path);
        result.setType(type);
        result.setLeaf(leaf);
        result.setNodeName(nodeName);
        result.setRepositoryId(this.getIndexingContext().getRepositoryId());
        return result;
    }

    protected TreeNode instantiateNode(IndexTreeView tview, String path, boolean leaf, String nodeName) {
        return new DefaultTreeNode(tview, this);
    }
}

