package File::Extension; 

use strict;
use Carp ();
use Data::Dumper;

{
  package Data::Dumper;
  no strict 'vars';
  $Terse = $Indent = $Useqq = $Deparse = $Sortkeys = 1;
  $Quotekeys = 0;
}

# populated in BEGIN block
my %ext;



sub explain {
  my $extension = uc(shift);
  return $ext{$extension};
}


#< begin
BEGIN {
  use Exporter;
  use vars qw($VERSION @ISA @EXPORT_OK %EXPORT_TAGS);
  @ISA = qw(Exporter);

  $VERSION = '0.002';

  @EXPORT_OK = qw(explain);
  %EXPORT_TAGS = [ qw() ];

  %ext = (
    '7Z'           => "7-Zip Compressed File",
    '3GP'          => "3GPP Multimedia File",
    '3DS'          => "3D Studio Scene",
    '3G2'          => "3GPP2 Multimedia File",
    '3DM'          => "Rhino 3D Model",
    '001'          => "Split Archive File",
    '3DR'          => "3DMark Results File",
    '!BT'          => "BitTorrent Incomplete Download File",
    '3DC'          => "iGO 3D Building File",
    '3MF'          => "3D Manufacturing File",
    '123'          => "Lotus 1-2-3 Spreadsheet",
    '8SVX'         => "Amiga 8-Bit Sound File",
    '3DF'          => "3D Format",
    '8BA'          => "Photoshop Plug-in",
    '8BI'          => "Photoshop Plug-in",
    '8BS'          => "Photoshop 5.0 Selection Plug-in",
    '8BX'          => "PhotoDeluxe Plug-in",
    '3GPP'         => "3GPP Media File",
    '3GP2'         => "3GPP Multimedia File",
    '3DT'          => "3D Topicscape File",
    '$ER'          => "GroupWise Database",
    '4MP'          => "4-MP3 Database File",
    '3DA'          => "3D Assembly File",
    '3DX'          => "Rhino 3D Model File",
    '8BF'          => "Filter Factory Image Filter",
    '8XP'          => "TI-83 Plus Calculator File",
    '83P'          => "TI-83 Calculator File",
    '8LI'          => "Photoshop Scripting Plug-in",
    '3DL'          => "LightConverse 3D Model File",
    '000'          => "Windows CE Installation Data File",
    '001'          => "Norton Ghost Disk Backup",
    '!UT'          => "uTorrent Incomplete Download",
    '2BP'          => "Pocket PC Bitmap Image File",
    '0'            => "Hacha Split Archive File",
    '0'            => "M3 DS Real Save File",
    '4DB'          => "4th Dimension Database Structure File",
    '4DD'          => "4th Dimension Database Data File",
    '4DV'          => "4D View Ultrasound File",
    '123'          => "PCB123 Circuit Board Design",
    '0XE'          => "F-Secure Renamed Virus File",
    '001'          => "Snes9x Slot 2 Saved State",
    '3DXML'        => "Dassault Systemes 3D XML File",
    '3P2'          => "3GPP Multimedia File",
    '1'            => "Unix Section 1 Man Page",
    '3DD'          => "ArcGlobe Document",
    '__B'          => "File Splitter & Joiner Encrypted Archive File",
    '4UI'          => "ForeUI Plot File",
    '360'          => "360desktop Panorama File",
    '3DR'          => "3D Rad Project File",
    '3DC'          => "RacerMate 3D Course File",
    '3DL'          => "iGO Landmark File",
    '002'          => "Split Archive Part 2 File",
    '_EML'         => "Windows Live Mail Email File",
    '3FR'          => "Hasselblad 3F RAW Image",
    '123D'         => "Autodesk 123D Drawing",
    '7Z.001'       => "7-Zip Split Archive Part 1 File",
    '7Z.002'       => "7-Zip Split Archive Part 2 File",
    '73K'          => "TI-73 Application",
    '89K'          => "TI-89 Application",
    '3DMK'         => "123D Make Project File",
    '3DP'          => "123D Catch Photo Scene Data File",
    '2FS'          => "Puppy Linux Save State File",
    '3GA'          => "3GPP Audio File",
    '890'          => "Cavena Subtitles File",
    '3DW'          => "3D World Studio File",
    '123DX'        => "123D Design Model File",
    '3DS'          => "Nintendo 3DS ROM",
    '4FS'          => "Puppy Linux Save State File",
    '4TH'          => "Forth Language File",
    '_SYS.LFO'     => "Adware File",
    '5XS'          => "Line 6 POD HD500X Edit Setlist File",
    '5XB'          => "Line 6 POD HD500X Edit Bundle",
    '5XE'          => "Line 6 POD HD500X Edit Preset File",
    '003'          => "Split Archive Part 3 File",
    '68K'          => "SEGA Mega Drive & Genesis Classics ROM File",
    '3DSX'         => "Homebrew Launcher File",
    '3W'           => "XYZprinting Sliced Model File",
    '3DL'          => "3D Lookup Table File",
    '3DMF'         => "QuickDraw 3D Metafile",
    '2D'           => "VersaCAD 2D Drawing File",
    '3MM'          => "3D Movie Maker Movie Project",
    '$DB'          => "dBASE Temporary File",
    '1ST'          => "Readme File",
    '8BF'          => "Photoshop Filter Plug-in",
    '8BI8'         => "Photoshop Plug-in",
    '8BL'          => "Photoshop Plug-in",
    '8BY'          => "PhotoDeluxe Plug-in",
    '669'          => "UNIS Composer 669 Module",
    '60D'          => "CCTV Video Clip",
    '000'          => "Virtual CD Disc Image File",
    '3D4'          => "Stereo CAD-3D 2.0 Image File",
    '^^^'          => "Pervasive.SQL Database File",
    '3DV'          => "3D VRML World",
    '~HM'          => "HostMonitor TestList Backup File",
    '4DL'          => "4th Dimension Database Log File",
    '001'          => "Multimedia Fusion Backup File",
    '8XU'          => "TI-83 and TI-84 Plus Operating System File",
    '8XK'          => "TI-83 Plus Application Upgrade File",
    '3ME'          => "TurboTax Form File",
    '3PE'          => "TurboTax 2008 Form File",
    '8XI'          => "TI-83/84 Plus Picture File",
    '8XG'          => "TI-83/84 Plus Group File",
    '8XV'          => "TI-83/84 Plus Variable File",
    '3GPP2'        => "3GPP2 Multimedia File",
    '__A'          => "File Splitter & Joiner Encrypted File",
    '0'            => "Shared Library Link File",
    '264'          => "Ripped Video Data File",
    '3DC'          => "RoboCell Cell Setup File",
    '3DC'          => "3DCT 3D Image",
    '_NWS'         => "Windows Live Mail Newsgroup Copy File",
    '3D'           => "Survex 3D Cavern File",
    '123C'         => "Autodesk 123C Drawing",
    '3DC'          => "3DCrafter Scene File",
    '73B'          => "TI-73 Backup File",
    '73I'          => "TI-73 Screenshot File",
    '73U'          => "TI-73 Explorer Operating System File",
    '32X'          => "Sega 32X ROM",
    '~CW'          => "Circuit Wizard Backup File",
    '3DP'          => "3DMark2011 SE Project File",
    '9.PNG'        => "NinePatchDrawable Image",
    '3FS'          => "Puppy Linux Save State File",
    '3DMDEF'       => "3DMark Definition File",
    '!SYNC'        => "BitTorrent Partially Synced File",
    '8CA'          => "TI-84 Plus C Image Var Format",
    '8CI'          => "TI-84 Plus C Pic Vars Format",
    '8CU'          => "TI-84 Plus C Operating System File",
    '8CK'          => "TI-84 Plus C Silver Edition Application File",
    '208'          => "ASUS Notebook BIOS 208 Update File",
    '3GPA'         => "3GPP Multimedia File",
    '0CC'          => "0CC-FamiTracker Module",
    '3DZ'          => "Easy 3D Creator Project",
    '3DZ'          => "Nintendo 3DS ROM",
    '5VW'          => "5View Packet Capture File",
    '3DW'          => "Studio Store Visualizer 3D Environment File",
    '12M'          => "Lotus 1-2-3 SmartMaster File",
    '_DOCX'        => "Renamed Microsoft Word Open XML Document",
    '_DOC'         => "Renamed Microsoft Word Document",
    '_XLS'         => "Renamed Microsoft Excel Spreadsheet",
    '_XLSX'        => "Renamed Microsoft Excel Open XML Spreadsheet",
    '602'          => "Text602 Document",
    '17T'          => "2017 StudioTax Return File",
    '_PLAYMUSICID' => "Google Play Music ID File",
    '$$$'          => "Temporary File",
    '$01'          => "DOS Pipe File",
    '000'          => "DoubleSpace Compressed File",
    '001'          => "Fax File",
    '6CM'          => "Six Channel Module",
    '8CM'          => "Eight Channel Module",
    '1PE'          => "TurboTax Form File",
    '1PH'          => "TurboTax File",
    '113'          => "Iomega Backup File",
    '8BC'          => "Photoshop 5.0 Plug-in",
    '8BE'          => "PhotoDeluxe Plug-in",
    '8MED'         => "Amiga OctaMed Music File",
    '3D'           => "Stereo CAD-3D Image File",
    '3D2'          => "Stereo CAD-3D 2.0 Image File",
    '8PBS'         => "Adobe Photoshop Macintosh File",
    '386'          => "Windows Virtual Device Driver",
    '2MG'          => "Apple IIGS Disk Image",
    '8ST'          => "8start Launcher File",
    '{PB'          => "Corel WordPerfect Document Index File",
    '411'          => "Mavica Thumbnail Image",
    '256'          => "Descent 2 Color Palette File",
    '8XS'          => "TI-83/84 Plus String File",
    '555'          => "Black & White Weather Settings File",
    '787'          => "AVTECH CCTV Video File",
    '3DON'         => "Scrutinize 3D Mesh File",
    '000'          => "Indexing Service Data File",
    '477'          => "MNS Shape Definition Companion File",
    '3DL'          => "Sierra LandDesigner 3D File",
    '!QB'          => "qBittorrent Partial Download File",
    '73C'          => "TI-73 Constant File",
    '73L'          => "TI-73 Data List File",
    '8LD'          => "Overlord 2 Language File",
    '2SF'          => "Nintendo DS Sound File",
    '2SFLIB'       => "Nintendo DS Audio Library File",
    '323'          => "H.323 Internet Telephony File",
    '00'           => "The Ur-Quan Masters Saved Game Slot 0 File",
    'AI'           => "Adobe Illustrator File",
    'AIF'          => "Audio Interchange File Format",
    'ASF'          => "Advanced Systems Format File",
    'ASP'          => "Active Server Page",
    'ASPX'         => "Active Server Page Extended File",
    'AVI'          => "Audio Video Interleave File",
    'APP'          => "Mac OS X Application",
    'APK'          => "Android Package File",
    'AZW'          => "Amazon Kindle eBook File",
    'ACCDB'        => "Access 2007 Database File",
    'ASMX'         => "ASP.NET Web Service File",
    'ADP'          => "Access Project",
    'ANI'          => "Windows Animated Cursor",
    'AVS'          => "AviSynth Script File",
    'AMR'          => "Adaptive Multi-Rate Codec File",
    'APE'          => "Monkey's Audio Lossless Audio File",
    'ATOM'         => "Atom Syndication Format",
    'AA'           => "Audible Audio Book File",
    'ACD'          => "ACID Project File",
    'ALZ'          => "ALZip Archive",
    'AS'           => "ActionScript File",
    'ABW'          => "AbiWord Document",
    'AA3'          => "ATRAC Audio File",
    'ABM'          => "Photo Album",
    'ADT'          => "ACT! Document Template",
    'AHK'          => "AutoHotkey Script",
    'ALX'          => "ActiveX Layout Control File",
    'ASD'          => "Word AutoSave File",
    'AMZ'          => "Amazon MP3 Downloader File",
    'AFX'          => "Auto FX PhotoGraphic Edges Image",
    'ACROBATSECUR' => "T'YSETTINGS  Adobe Acrobat Security Settings File",
    'APPLICATION'  => "ClickOnce Deployment Manifest File",
    'APPREF-MS'    => "Microsoft Application Reference File",
    'ARW'          => "Sony Digital Camera Image",
    'AW'           => "Answer Wizard File",
    'AXD'          => "ASP.NET Web Handler File",
    'ACSM'         => "Adobe Content Server Message File",
    'ACM'          => "Interplay Audio File",
    'ATT'          => "Web Form Post Data File",
    'AVX'          => "ArcView Extension File",
    'AFC'          => "Mass Effect 2 Audio File",
    'ASC'          => "ActionScript Communication File",
    'AT3'          => "ATRAC3 Audio File",
    'AVASTLIC'     => "Avast! License File",
    'ASAX'         => "ASP.NET Server Application File",
    'ASC'          => "PGP ASCII Armored File",
    'ARX'          => "AutoCAD Runtime Extension File",
    'ASE'          => "Adobe Swatch Exchange File",
    'ACROPLUGIN'   => "Adobe Acrobat Plug-in",
    'ACD-ZIP'      => "Sony ACID Project With Embedded Media File",
    'AEPX'         => "After Effects XML Project",
    'ARC'          => "Symbian OS Backup File",
    'AUX'          => "LaTeX Auxiliary File",
    'AZW1'         => "Amazon Topaz eBook",
    'ASY'          => "Asymptote Module",
    'AS3PROJ'      => "FlashDevelop ActionScript 3 Project File",
    'ALE'          => "Avid Log Exchange File",
    'AVP'          => "Avid Project File",
    'A5W'          => "Alpha Five Webpage File",
    'ALS'          => "Ableton Live Set File",
    'AMXD'         => "Ableton Max Patch File",
    'A2C'          => "Alice Object File",
    'ADCP'         => "Adobe Device Central Project File",
    'AZW3'         => "Amazon KF8 eBook File",
    'AZW4'         => "Amazon Print Replica eBook",
    'A2L'          => "ASAP2 ECU Description File",
    'AQM'          => "AlpineQuest Map File",
    'ADF'          => "ESRI ArcInfo Binary Grid Format",
    'AAXPLUGIN'    => "Avid Audio eXtension Plugin File",
    'AO'           => "ActionOutline Outline File",
    'AMF'          => "Additive Manufacturing File",
    'AAC'          => "Advanced Audio Coding File",
    'ARC'          => "Compressed File Archive",
    'AIFF'         => "Audio Interchange File Format",
    'ACE'          => "WinAce Compressed File",
    'ANS'          => "ANSI Text File",
    'ART'          => "AOL Compressed Image File",
    'AU'           => "Audio File",
    'AIFC'         => "Compressed Audio Interchange File",
    'ADE'          => "Access Project Extension",
    'ASC'          => "ASCII Text File",
    'ASM'          => "Assembly Language Source Code File",
    'ADF'          => "Amiga Disk File",
    'ASX'          => "Microsoft ASF Redirector File",
    'ADR'          => "Opera Bookmarks File",
    'ABK'          => "Automatic Backup File",
    'AXX'          => "AxCrypt Encrypted File",
    'AIP'          => "Illustrator Plug-in",
    'A2W'          => "Alice World",
    'ATN'          => "Photoshop Actions File",
    'ASL'          => "Photoshop Style",
    'AWK'          => "AWK Script",
    'ASK'          => "askSam Database",
    'A'            => "Static Library",
    'AFT'          => "Ancestry.com Family Tree Database",
    'AX'           => "DirectShow Filter",
    'AWD'          => "Microsoft Fax Document",
    'ABC'          => "ABC Music Notation",
    'AJP'          => "CCTV Video File",
    'APP'          => "FoxPro Generated Application",
    'ASM'          => "Solid Edge Assembly File",
    'ACT'          => "ADPCM Compressed Audio File",
    'AUD'          => "Video Game Compressed Audio File",
    'ADX'          => "Approach Index File",
    'ADM'          => "Administrative Template File",
    'ABBU'         => "Address Book Backup",
    'APP'          => "Symbian OS Application",
    'ASCX'         => "ASP.NET User Control File",
    'AKP'          => "Akai Sampler File",
    'AMS'          => "Adobe Monitor Setup File",
    'AMS'          => "Extreme Tracker Module",
    'AMS'          => "Velvet Studio Module",
    'A6P'          => "Authorware 6 Program",
    'AB3'          => "PhotoImpact 3 Album File",
    'AR'           => "Unix Static Library",
    'AGE3SAV'      => "Age of Empires 3 Save File",
    'ASA'          => "ASP Configuration File",
    'ACFM'         => "Adobe Composite Font Metrics File",
    'AMFM'         => "Adobe Multiple Font Metrics File",
    'AHL'          => "eMule Metadata File",
    'AU3'          => "AutoIt v3 Script",
    'AFP'          => "FileProtector Encrypted File",
    'AC'           => "Autoconf Script",
    'AVB'          => "Avid Bin File",
    'AEP'          => "After Effects Project",
    'ACL'          => "AutoCorrect List File",
    'AMV'          => "Anime Music Video File",
    'AWG'          => "Activeworlds Object Group File",
    'AB1'          => "DNA Electropherogram File",
    'ABI'          => "DNA Chromatogram File",
    'ACR'          => "ACRobot Script",
    'AGI'          => "Asterisk Gateway Interface File",
    'AGP'          => "ArtGem Project File",
    'APPLESCRIPT'  => "AppleScript File",
    'ANM'          => "3D Animation File",
    'AFP'          => "Advanced Function Presentation File",
    'ACD'          => "RSLogix 5000 Program",
    'ASE'          => "Autodesk ASCII Scene Export File",
    'ABCD'         => "AudioVisual Book Data File",
    'AHS'          => "Adobe Halftone Screen File",
    'ADS'          => "Ada Specification File",
    'AP'           => "Active Page",
    'ARCH00'       => "F.E.A.R. Game Archive",
    'AUP'          => "Audacity Project File",
    'ADZ'          => "Compressed Amiga Disk File",
    'AST'          => "Adobe Color Separations Table",
    'ARO'          => "SteelArrow Web Application File",
    'A2M'          => "Adlib Tracker II File",
    'A2M'          => "TS-AudioToMIDI Settings File",
    'AIM'          => "AIMMS ASCII Model File",
    'ARD'          => "ArtiosCAD Workspace File",
    'APA'          => "RSView Development Project Archive",
    'ACC'          => "Graphics Accounts Data File",
    'APNG'         => "Animated Portable Network Graphic",
    'AIR'          => "Adobe AIR Installation Package",
    'ACTION'       => "Automator Action",
    'ADG'          => "Ableton Device Group",
    'AFPLOC'       => "Apple Filing Protocol Location",
    'ABP'          => "AVS Barcode Profile",
    'AIF'          => "Symbian Application Information File",
    'AIFB'         => "AIF Builder Project File",
    'AM6'          => "AutoPlay Media Studio 6 Project",
    'AM7'          => "AutoPlay Media Studio 7 Project",
    'AC$'          => "AutoCAD Temporary File",
    'AM4'          => "AutoPlay Media Studio 4 Project File",
    'AM5'          => "AutoPlay Media Studio 5 Project File",
    'ALD'          => "Dynamics AX Application Label Data File",
    'ALI'          => "Dynamics AX Label Index File",
    'ADD'          => "Dynamics AX Developer Documentation File",
    'AHD'          => "Dynamics AX Online Help Data File",
    'AHI'          => "Dynamics AX Online Help Index File",
    'ALT'          => "Dynamics AX Temporary File",
    'AOD'          => "Dynamics AX Object Data File",
    'APZ'          => "Autoplay Media Studio Exported Project",
    'AMX'          => "Adobe Motion Exchange File",
    'AMX'          => "AMX Mod Plugin File",
    'AMXX'         => "AMX Mod X Plugin File",
    'AOB'          => "DVD-Audio Audio Object File",
    'AXM'          => "AXMEDIS Object",
    'ARR'          => "Advanced RAR Password Recovery Project",
    'ACS'          => "Agent Character File",
    'AVL'          => "ArcView Legend File",
    'APR'          => "ArcView Project File",
    'AGIF'         => "Active GIF Creator Project",
    'AAWDEF'       => "Ad-Aware Definitions File",
    'ATZ'          => "Aston Compiled Theme",
    'AN8'          => "Anim8or File",
    'ARF'          => "WebEx Advanced Recording File",
    'APE'          => "AVS Plugin Effects File",
    'AVS'          => "AVS Preset File",
    'AAX'          => "Audible Enhanced Audiobook File",
    'ASR'          => "ActionScript Remote Document",
    'ASHX'         => "ASP.NET Web Handler File",
    'ABR'          => "Adobe Photoshop Brushes File",
    'ABM'          => "Music Album",
    'AMF'          => "Advanced Module File",
    'ANME'         => "Anime Studio Document",
    'ARTPROJ'      => "Artifacts Project",
    'AMSORM'       => "OnLine Ringman Auction Client File",
    'ALB'          => "Alpha Five Library",
    'ADB'          => "Alpha Five Database File",
    'ASI'          => "Alpha Five Variable File",
    'ALX'          => "BlackBerry Application Loader XML File",
    'ABA'          => "Palm Address Book Archive",
    'ABY'          => "AOL Address Book File",
    'AGM'          => "DTS Multi-channel Pro Packer File",
    'AM1'          => "Adventure Maker",
    'AT5'          => "Lowrance Map File",
    'APF'          => "Adobe Profile File",
    'AAM'          => "Authorware Map File",
    'AEX'          => "Alpha Five Compiled Global Functions File",
    'AAO'          => "America's Army Map File",
    'AIT'          => "Adobe Illustrator Template",
    'ASND'         => "Adobe Sound Document",
    'AZZ'          => "AZZ Cardfile Database File",
    'AXE'          => "AutoRoute Map File",
    'APL'          => "Monkey's Audio Track Information File",
    'ACV'          => "Photoshop Curves File",
    'ADI'          => "Active@ Disk Image Backup File",
    'ASM'          => "Visual Studio Assembler Source Code File",
    'ADDIN'        => "Visual Studio Add-in Definition File",
    'AVATAR'       => "Google Talk Avatar File",
    'ACB'          => "Adobe Photoshop Color Book File",
    'ABC'          => "ActionScript Byte Code File",
    'ARC'          => "Norton Backup Archive",
    'ACCDT'        => "Microsoft Access Database Template",
    'ATC'          => "AutoCAD Tool Catalog File",
    'AVC'          => "Kaspersky Virus Database",
    'ACO'          => "Adobe Photoshop Color Swatch File",
    'ACT'          => "Adobe Color Table File",
    'AHU'          => "Adobe Photoshop HSL File",
    'ALV'          => "Adobe Photoshop Levels File",
    'AXT'          => "Adobe Photoshop Extract File",
    'AWDB'         => "Access Walker Database File",
    'AEA'          => "AdWords Editor Archive",
    'AGE3SCN'      => "Age of Empires 3 Scenario File",
    'AIA'          => "Adobe Illustrator Action File",
    'AWM'          => "AllWebMenus Project File",
    'ACD-BAK'      => "MAGIX ACID Project Backup File",
    'ATM'          => "Vue Atmospheres File",
    'ASS'          => "Aegisub Advanced Substation Alpha File",
    'ASW'          => "ACDSee Slideshow Wizard File",
    'APD'          => "ACDSee Photo Document",
    'AFD'          => "Alphacam Flame Drawing",
    'ASHDISC'      => "Ashampoo Burning Studio Image",
    'ASHPRJ'       => "Ashampoo Burning Studio Project",
    'ASHBAK'       => "Ashampoo Backup Archive",
    'ABKPRJ'       => "Ashampoo Backup Project",
    'ADF'          => "ACT! Data File",
    'ALF'          => "ACT! Lookup File",
    'ADT'          => "World of Warcraft Map File",
    'ANY'          => "AnyRail Layout Plan",
    'ARG'          => "AutoCAD Profile",
    'AETX'         => "After Effects XML Project Template",
    'AGGR'         => "Adobe Captivate Aggregate File",
    'ADMX'         => "Group Policy Administrative Template File",
    'AAF'          => "Advanced Authoring Format File",
    'AUX'          => "Auxiliary File",
    'APS'          => "Visual C++ Resource File",
    'ASY'          => "LTspice Symbol File",
    'ASC'          => "LTspice Circuit Schematic File",
    'AS2PROJ'      => "FlashDevelop ActionScript 2 Project File",
    'AIN'          => "Source Engine Compiled AI Nodegraph File",
    'ABF'          => "Analysis Services Backup File",
    'ACP'          => "Alfresco Content Package",
    'AC3'          => "Audio Codec 3 File",
    'ADTS'         => "Audio Data Transport Stream File",
    'ADT'          => "ADTS Audio File",
    'ARSC'         => "Android Package Resource File",
    'ACCDE'        => "Access Execute Only Database",
    'ACCDR'        => "Access Runtime Application",
    'ACCDA'        => "Access Add-in File",
    'ACCDC'        => "Microsoft Access Signed Package",
    'A2THEME'      => "Aston 2 Theme File",
    'AVS'          => "Avid Project Preferences File",
    'AVX'          => "Avid Plugin File",
    'ASEC'         => "Android Secure Application File",
    'APNX'         => "Amazon Page Number Index File",
    'AUTOPLAY'     => "AutoPlay Media Studio Project File",
    'ANIM'         => "Maya Animation File",
    'ANIM'         => "Unity Animation File",
    'AVGDX'        => "AVG Diagnostics File",
    'ANX'          => "HotDocs Answer File",
    'AFF'          => "AFF Disk Image",
    'ALP'          => "Ableton Live Pack File",
    'ASD'          => "Ableton Live Sample Analysis File",
    'ALC'          => "Ableton Live Clip File",
    'AUZ'          => "Ableton Authorization File",
    'AVP'          => "AntiVir Profile",
    'ATS'          => "Advanced ETL Transformation Script",
    'ACF'          => "Steam Application Cache File",
    'AWW'          => "Ability Write Document",
    'AWS'          => "Ability Spreadsheet File",
    'APX'          => "Ability Photopaint Studio Image",
    'ANIMSET'      => "FaceFX Animation Set File",
    'ATF'          => "Axon Text File",
    'ATH'          => "Alienware AlienFX Theme File",
    'A3D'          => "Alternativa Player 3D Export File",
    'AVERY'        => "Avery Design & Print Label File",
    'AB'           => "Android ADB Backup File",
    'ARP'          => "Audition Replay File",
    'AMC'          => "AMC Video File",
    'ADPP'         => "Adobe Device Profile Package",
    'ADVS'         => "Adobe Device Central Device Set",
    'APPUP'        => "Erlang Application Upgrade File",
    'AML'          => "ACPI Machine Language File",
    'AOI'          => "Art of Illusion 3D Scene",
    'ART'          => "ArtCAM Model",
    'ARI'          => "ARRIRAW Image",
    'ARCUT'        => "Prelude Rough Cut File",
    'ARS'          => "After Effects Render Settings File",
    'AOM'          => "After Effects Output Module",
    'A4P'          => "A4Desk Pro Project File",
    'APLG'         => "Audials Plug-in",
    'APLP'         => "Audials Plug-in Package",
    'AP_'          => "ADT Android Developer Package",
    'ADV'          => "Nortek Acoustic Doppler Velocimeter File",
    'ACCFT'        => "Microsoft Access Data Type Template",
    'AEC'          => "Cinema 4D After Effects Composition",
    'AGR'          => "Ableton Groove File",
    'AOF'          => "Artlantis Object File",
    'ATL'          => "Artlantis 3D Scene File",
    'ACORN'        => "Acorn Image",
    'ARFF'         => "Attribute-Relation File Format",
    'ATX'          => "ArcGIS Attribute Index File",
    'AVHD'         => "Hyper-V SnapShot File",
    'AVV'          => "Avid Volume Bin File",
    'ANE'          => "Adobe AIR Native Extension",
    'APPDOWNLOAD'  => "Mac App Store Partially Downloaded App",
    'ACT'          => "Alma CAD/CAM Document",
    'AN'           => "Adobe Edge Animate Project File",
    'AZW2'         => "Kindle Active Content App File",
    'AES'          => "AES Crypt Encrypted File",
    'APPX'         => "Windows 8 App Package",
    'APPXUPLOAD'   => "Windows 8 App Upload Package",
    'ACCOUNTPICTU' => "E'-MS        Windows 8 Account Picture File",
    'ARTB'         => "Artboard Document",
    'AAUI'         => "Acrobat User Interface File",
    'AEPKEY'       => "Advanced Encryption Package Key File",
    'AEP'          => "Advanced Encryption Package Encrypted File",
    'AMM'          => "All My Movies Database File",
    'AMB'          => "All My Books Database File",
    'ACG'          => "Audio Comparer Group File",
    'ACR'          => "Audio Comparer Results File",
    'AVCHD'        => "High Definition Video File",
    'ASVF'         => "Asphyre Sphinx Archive File",
    'APLIBRARY'    => "Aperture Library",
    'ASI'          => "Grand Theft Auto Mod Library",
    'A2I'          => "Adlib Tracker II Instrument File",
    'A2B'          => "Adlib Tracker II Instrument Bank",
    'ATF'          => "Alternativa Texture File",
    'ASV'          => "Finale Auto-save File",
    'ASVX'         => "Finale Auto-save File",
    'ASEF'         => "Adobe Swatch Exchange File",
    'ASP'          => "Adobe Color Separation Setup File",
    'ANH'          => "Project ROME File",
    'AVB'          => "Microsoft Comic Chat Character",
    'ARCHIVER'     => "Archiver Compressed File Archive",
    'AGE3XSAV'     => "Age of Empires 3: The WarChiefs Save File",
    'AGE3YSAV'     => "Age of Empires 3: The Asian Dynasties Save",
    'AGE3REC'      => "Age of Empires 3 Recording",
    'AGE3XREC'     => "Age of Empires 3: The WarChiefs Recording",
    'AGE3YREC'     => "Age of Empires 3: The Asian Dynasties",
    'ASR'          => "Audio Streaming Resource Archive",
    'APPCACHE'     => "HTML5 Cache Manifest File",
    'ACZ'          => "AppCraft Project",
    'A7P'          => "Authorware 7 Project",
    'A7R'          => "Authorware 7 Runtime File",
    'ANG'          => "Anghami Audio File",
    'AP'           => "ArtPro File",
    'AFDESIGN'     => "Affinity Design Document",
    'ACWW'         => "Animal Crossing Wild World Pattern File",
    'AIA'          => "MIT App Inventor Source Code File",
    'ACF'          => "X-Plane Aircraft File",
    'AIDL'         => "Android Interface Definition Language File",
    'AN8'          => "Vector NTI DNA File",
    'ARIA2'        => "aria2 Control File",
    'AFI'          => "AOMEI Backupper File Backup File",
    'ARTICLE'      => "Twixl Publisher Article",
    'ADOC'         => "AsciiDoc File",
    'AIP'          => "Advanced Installer Project",
    'AC'           => "AC3D 3D File",
    'ALBUM'        => "GLC_Player Album File",
    'ARN'          => "Autoruns Data File",
    'AWBR'         => "WriteOnline WordBar File",
    'ADDISM'       => "Addism Data File",
    'ALDF'         => "Aldfaer Genealogy File",
    'AVHDX'        => "Automatic Virtual Hard Drive File",
    'ARDUBOY'      => "Arduboy Game Package",
    'ACQ'          => "AcqKnowledge Data Graph File",
    'AEX'          => "After Effects Plug-in",
    'ACTC'         => "Action(s) Collection File",
    'ANIME'        => "Anime Studio Document",
    'ADF'          => "ARIS Express Document",
    'ASEPRITE'     => "Aseprite Sprite File",
    'ATOMSVC'      => "Atom Service Document",
    'AURORA'       => "Aurora Ransomware Encrypted File",
    'AFPHOTO'      => "Affinity Photo Document",
    'AAR'          => "Android Archive",
    'ACB'          => "AOL Cab Launcher",
    'ARJ'          => "ARJ Compressed File Archive",
    'AD'           => "After Dark Screensaver",
    'ART'          => "Art Document",
    'AFM'          => "Adobe Font Metrics File",
    'ABF'          => "Adobe Binary Screen Font File",
    'ANN'          => "Help Annotations",
    'ALAW'         => "A-Law Compressed Sound Format",
    'API'          => "Acrobat Plug-in",
    'AXT'          => "Microsoft AutoRoute Template",
    'AHX'          => "WinAHX Tracker Module",
    'ABC'          => "ABC Source File",
    'ACT'          => "FoxPro Documenting Wizard Action Diagram",
    'ADA'          => "Ada Source Code",
    'ATY'          => "Association Type Placeholder",
    'ABK'          => "Need for Speed Underground Audio File",
    'AC5'          => "ArtCut 5 Document",
    'AC6'          => "ArtCut 6 Document",
    'ALL'          => "Cubasis Project File",
    'AIS'          => "ACDSee Image Sequence File",
    'AIS'          => "Velvet Studio Instrument",
    'ASE'          => "Velvet Studio Sample",
    'ADM'          => "Portfolio Admin-Level Access Flag",
    'A5L'          => "Authorware 5 Library",
    'A5W'          => "Authorware 5 Windows File",
    'A65'          => "Authorware 6.5 File",
    'ARC'          => "African Safari Data File",
    'AEP'          => "Activ E-Book Project",
    'ATF'          => "Photoshop Transfer Function File",
    'ASC'          => "Autodesk ASCII Export File",
    'ADB'          => "Ada Body File",
    'ACT'          => "Genesis3D Actor File",
    'ATX'          => "Animation Master Plugin File",
    'AST'          => "ClarisWorks Assistant File",
    'ARXML'        => "AUTOSAR XML File",
    'AMB'          => "AIMMS Model File",
    'AVS'          => "Application Visualization System File",
    'ASAT'         => "Assemble SAT 3D Model File",
    'ALC'          => "Dynamics AX Label Description File",
    'ADI'          => "Dynamics AX Developer Documentation Index",
    'AOI'          => "Dynamics AX Application Object Index File",
    'ARP'          => "Advanced RAR Password Recovery Setup",
    'AV'           => "Video Surveillance File",
    'ACR'          => "Acer eRecovery Management Backup File",
    'ATR'          => "Atari Disk Image",
    'ADT'          => "AutoCAD Audit Log",
    'AIC'          => "Advanced Image Coding File",
    'AEA'          => "Ae Timer Alarm Document",
    'ACX'          => "Atari ST Program",
    'ACRODATA'     => "Acrobat Data File",
    'A00'          => "ALZip Second Split Archive File",
    'A01'          => "ALZip Third Split Archive File",
    'A02'          => "ALZip Fourth Split Archive File",
    'AWD'          => "Artweaver Document",
    'AN1'          => "Street Atlas USA Draw File",
    'AWB'          => "AMR-WB Audio File",
    'ACA'          => "Agent Character Animation File",
    'ACF'          => "Agent Character Data File",
    'ACG'          => "Agent Preview File",
    'AGD'          => "AgileGraph Data File",
    'ASWS'         => "Avast! Skin File",
    'ASWCS'        => "Avast! Compressed Skin File",
    'AOS'          => "ARCHOS PCtablet Firmware File",
    'ADIF'         => "Amateur Data Interchange Format",
    'APM'          => "Aldus Placeable Metafile Image",
    'ABA'          => "Avant Browser Add-on File",
    'AUT'          => "AutoIt Script File",
    'AB2'          => "Print Shop Address Book File",
    'APF'          => "Sony Ericsson Firmware Acoustics File",
    'AS4'          => "askSam Backup File",
    'ATT'          => "Alphacam Lathe Tool File",
    'AAO'          => "Agenda At Once File",
    'ARH'          => "ProTool Compressed Project File",
    'ABK'          => "Arena Opening Book File",
    'ASM'          => "Pro/ENGINEER Assembly File",
    'AXP'          => "CDBurnerXP Audio Compilation File",
    'AFS'          => "STAAD.foundation Project File",
    'APL'          => "ArcPad Layer File",
    'APL'          => "ACDSee Plugin File",
    'ATE'          => "Office Accounting Compressed Backup File",
    'ATI'          => "Office Accounting Updated Company File",
    'AVD'          => "Movie Edit Pro Video Information File",
    'ARENA'        => "Quake 3 Engine Arena File",
    'ACT'          => "DS Game Maker Action File",
    'ACTX'         => "DS Game Maker Action Description File",
    'AVENIRPROJ'   => "StoryMill Project",
    'ACCDW'        => "Microsoft Access Database Link File",
    'ACTM'         => "AutoCAD Action Macro File",
    'AWS'          => "AutoCAD Work Space File",
    'ACF'          => "Adobe Photoshop Custom Filter File",
    'ADO'          => "Adobe Photoshop Duotone Options File",
    'AMP'          => "Adobe Photoshop Curves Map File",
    'ASV'          => "Adobe Photoshop Selective Color File",
    'AVS'          => "Adobe Photoshop Variations File",
    'ACBL'         => "Adobe Color Book Legacy File",
    'ABDATA'       => "Adobe Bridge Data File",
    'AML'          => "Microsoft Assistance Markup Language File",
    'AWT'          => "AbiWord Template",
    'ABI'          => "AbiWord Plug-in",
    'APD'          => "Eclipse Plugin Descriptor File",
    'ASB'          => "Alphacam Stone VB Macro File",
    'AR'           => "Midtown Madness Data File",
    'APR'          => "Apadana Project File",
    'AY'           => "AY Chiptune File",
    'AET'          => "After Effects Project Template",
    'ADML'         => "Group Policy Language-Specific",
    'AXE'          => "Annotated XML Example File",
    'AM'           => "Automake Makefile Template",
    'ACP'          => "EditPlus Auto-Completion File",
    'ACW'          => "Windows Accessibility Wizard File",
    'A8S'          => "Anim8or Script",
    'ACB'          => "AutoCAD Color Book File",
    'ACP'          => "aacPlus Audio File",
    'APS'          => "Greeting Card Studio Project File",
    'ARIA'         => "Chipsounds Sound File",
    'ARIAX'        => "Chipsounds XML Sound File",
    'ALL'          => "Java RMI Policy File",
    'AVE'          => "Avid User File",
    'AFE'          => "Avid File Exchange File",
    'AWCAV'        => "ActiveWorlds Custom Avatar File",
    'A52'          => "Atari 5200 ROM",
    'ADU'          => "Addict User Dictionary File",
    'ASSET'        => "Unity Asset File",
    'ANS'          => "HotDocs Binary Answer File",
    'AFD'          => "AFF Disk Image Part File",
    'AFM'          => "AFF Metadata File",
    'ADV'          => "Ableton Device Preset File",
    'AVL'          => "AntiVir Status Report File",
    'AVJ'          => "AntiVir Job File",
    'ABC'          => "Micrografx ABC FlowCharter 6 File",
    'AF3'          => "Micrografx ABC FlowCharter 3/4 File",
    'AB'           => "Ambling BookPlayer MP3 File",
    'A26'          => "Atari 2600 ROM",
    'AWP'          => "Ability Write Template",
    'ADB'          => "Ability Database File",
    'AWG'          => "Ability Draw Document",
    'APH'          => "Ability Album File",
    'AST'          => "Ability Spreadsheet Template",
    'ARSCRIPT'     => "ArtRage Script",
    'ANJUTA'       => "Anjuta IDE Project File",
    'AIR'          => "M.U.G.E.N. Animation File",
    'ANIMSET_INGA' => "E'FaceFX In-Game Animation Set File",
    'AUTOMATICDES' => "I'NATIONS-MS Windows Jump List File",
    'ASH'          => "Audiosurf Audio Metadata File",
    'AZ!'          => "Vuze Partial Download File",
    'AVASTSOUNDS'  => "Avast! Soundpack File",
    'AML'          => "Arc Macro Language File",
    'AMC'          => "Ant Movie Catalog File",
    'ACCDU'        => "Access Add-in File",
    'ASCS'         => "ActionScript Communication Server File",
    'ADN'          => "Access Blank Project Template",
    'AU'           => "Audacity Audio File",
    'ANTISPAM5'    => "Personal AntiSpam Settings File",
    'A1WISH'       => "Audials Wishlist File",
    'ARA'          => "Archivaldo Resource Archive",
    'ALI'          => "RoboHelp Alias File",
    'ASK'          => "Ableton Live Skin File",
    'AZZX'         => "Uncompressed AZZ Cardfile Data File",
    'AVC'          => "Avid Media Composer Script",
    'AIMPPL'       => "AIMP Playlist File",
    'APALBUM'      => "Aperture Album File",
    'AIU'          => "Advanced Installer Updates Configuration",
    'ANSYM'        => "Adobe Edge Animate Library File",
    'APPXSYM'      => "Windows 8 App Package Symbols File",
    'ADADOWNLOAD'  => "Adobe Download Assistant Partial Download",
    'APPLET'       => "Eclipse Java Applet Policy File",
    'ABS'          => "Absolute Database File",
    'ABS'          => "TurboZIP Auto Compress Script",
    'APXL'         => "Keynote Presentation Data File",
    'APT'          => "Almost Plain Text File",
    'ART'          => "BERNINA Embroidery File",
    'AWLIVE'       => "Active Webcam Video File",
    'ALP'          => "AnyLogic Project File",
    'ASDB'         => "Asphyre Sphinx Archive File",
    'ATTR'         => "iPhoto Attributes File",
    'AZS'          => "AirZip FileSECURE File",
    'AZF'          => "AirZip FileSECURE File",
    'A2P'          => "Adlib Tracker II Pattern File",
    'A2T'          => "Adlib Tracker II Tiny Module File",
    'A2W'          => "Adlib Tracker II Instrument Bank with",
    'ANTMPL'       => "Adobe Edge Animate Template File",
    'ASS'          => "Splinter Cell Blacklist Game Data File",
    'ASSTRM'       => "Splinter Cell Blacklist Game Data File",
    'ABCDDB'       => "Apple Address Book Contact List",
    'ASX'          => "Alpha Five Library Temporary Index File",
    'ALX'          => "Alpha Five Library Index File",
    'ALM'          => "Alpha Five Library",
    'ADBLOCK'      => "Alpha Five Library Temporary File",
    'A5WCMP'       => "Alpha Five Web Components File",
    'ADB'          => "Now Contact Address Book Template",
    'AML'          => "Abstract Markup Language",
    'AGG'          => "Bulk Data File",
    'ABX'          => "WordPerfect Address Book",
    'AGX'          => "AGT Game File",
    'ABT'          => "Annotated Braille Text File",
    'AGLIB'        => "Adobe Lightroom Library",
    'AGMODULE'     => "Adobe Lightroom Module",
    'AGTEMPLATE'   => "Adobe Lightroom Template",
    'AGTOOLKIT'    => "Adobe Lightroom Toolkit",
    'ACS2'         => "AIMP Skin File",
    'ACS3'         => "AIMP Skin File",
    'AES'          => "ooVoo Log File",
    'ANN'          => "Lingvo Dictionary Annotation File",
    'A7L'          => "Authorware 7 Library",
    'A7D'          => "Authorware 7 Model",
    'APKG'         => "Exported Anki Flashcard Deck",
    'ANX'          => "Annodex Exchange Format File",
    'AXA'          => "Annodex Audio File",
    'AXV'          => "Annodex Video File",
    'A3X'          => "Compiled AutoIt v3 Script",
    'ADI'          => "AOMEI Backupper Disk Backup File",
    'ASSETPROJ'    => "Camtasia Studio Asset Information File",
    'AIP'          => "Actual Installer Project",
    'AFF'          => "Spellcheck Dictionary Description File",
    'ABCDP'        => "Address Book CoreData Person File",
    'AAN'          => "Pro Tools Elastic Audio Analysis File",
    'AUTOSAVE'     => "Fusion Auto-save File",
    'AAE'          => "Sidecar Image Edit File",
    'ABU'          => "Asus App Backup File",
    'AFZPLUG'      => "AfterShot Pro Plugin Archive",
    'AECACHE'      => "After Effects Cache File",
    'ACID'         => "ACID Encrypted File",
    'AS'           => "AngelScript File",
    'APPEX'        => "OS X Application and System Extension File",
    'ADX'          => "ADX Audio File",
    'ASSETS'       => "Unity Asset File",
    'AUDIONOTE'    => "AudioNote File",
    'ACB'          => "ADX Audio Package File",
    'ADIDAT'       => "ADInstruments Simple Data File",
    'ADICHT'       => "LabChart Data File",
    'AV'           => "Final Draft AV Script",
    'ADI'          => "Amateur Data Interchange Format",
    'AEGRAPHIC'    => "Adobe After Effects Graphic",
    'AECAP'        => "After Effects Text Template",
    'AUR'          => "Aurora Timetable File",
    'ACELIVE'      => "Acelive Broadcast File",
    'ALG'          => "AlgoBox Algorithm File",
    'ALF'          => "Alf Interactive Test",
    'ANIMEEXPORT'  => "Anime Studio Export Profile Document",
    'ASE'          => "Aseprite Sprite File",
    'AMGP'         => "antimicro Profile File",
    'A78'          => "Atari 7800 ROM",
    'AGG'          => "AggFlow 6 Project",
    'ABU1'         => "ASUS Backup File",
    'AIV'          => "Stronghold Crusader AI Village File",
    'AVE'          => "Avigilon Native Video Export File",
    'AWC'          => "Audio Wave Container File",
    'ASAR'         => "Electron Archive",
    'AV3'          => "Arbitrator Video Surveillance File",
    'AVR'          => "EverFocus Recording File",
    'AVRO'         => "Avro Data File",
    'AIML'         => "Artificial Intelligence Markup Language",
    'AWB'          => "ADX Audio Package File2",
    'ATSOFTS'      => "LetEncrypt Encrypted File",
    'ARI'          => "ARI Compressed File Archive",
    'AOL'          => "America Online File",
    'AIN'          => "AIN Compressed File Archive",
    'AIM'          => "AOL Instant Messenger Launch File",
    'ACR'          => "American College of Radiology File",
    'ADI'          => "AutoCAD Device-Independent Binary Plotter",
    'AVR'          => "Audio Visual Research File",
    'ATZ'          => "Atomic Time Zone File",
    'ADC'          => "Scanstudio 16 Color Image",
    'AL'           => "A-Law Compressed Sound Format",
    'ARR'          => "Amber Graphic File",
    'ASCII'        => "ASCII Text File",
    'AMU'          => "PictureGear Studio Photo Album File",
    'A3L'          => "Authorware 3 Library",
    'A4L'          => "Authorware 4 Library",
    'A3M'          => "Authorware 3 Macintosh File",
    'A3W'          => "Authorware 3 Windows File",
    'A4M'          => "Authorware 4 Macintosh File",
    'A4W'          => "Authorware 4 Windows File",
    'AB'           => "Applix Builder File",
    'AB'           => "DNA Sequence File",
    'AA'           => "Generic CD Image",
    'AWC'          => "Emulex AWC Firmware Update File",
    'AWD'          => "Award BIOS Update File",
    'ATRAC'        => "Sony ATRAC Audio File",
    'ARK'          => "PowerDesk Pro Archive",
    'ART'          => "Artifacts Artifact File",
    'AGD'          => "Agile Advantage E-mail Attachment",
    'ALBM'         => "HP Photo Printing Software Album File",
    'ARW'          => "ArtStudio Image",
    'ARTWORK'      => "ArtStudio Image",
    'ARC'          => "Nintendo Archive File",
    'ARL'          => "AOL Organizer File",
    'ARH'          => "ArheoStratigraf Project File",
    'AN2'          => "Croc Legend of the Gobbos Animation File",
    'ATM'          => "PSP Game Audio File",
    'ALR'          => "ADRIFT Language Resource File",
    'AWKW'         => "Awkwords Word Generator File",
    'API'          => "Adobe Photoshop Inks File",
    'ASR'          => "Adobe Photoshop Scratch File",
    'ANNOT'        => "Adobe Digital Editions Annotations File",
    'ADDON'        => "CFS Console Add-on File",
    'AOIS'         => "CFS Console Add-on Installer Settings File",
    'AIV'          => "AIVault Data File",
    'A52'          => "Dolby Digital Audio File",
    'ANIM'         => "Amiga Animation File",
    'ANIM'         => "Antibody Animation File",
    'ALAC'         => "ALAC Encoded Audio File",
    'AF2'          => "Micrografx ABC FlowCharter 2 File",
    'AS'           => "AppleSingle File",
    'ARPACK'       => "ArtRage Package",
    'AI'           => "Battlefield 2 Artificial Intelligence File",
    'ASH'          => "KoLmafia ASH Script",
    'ASH'          => "Nintendo Wii System Menu File",
    'ARS'          => "Carmageddon Saved Game",
    'AM'           => "Anark Media File",
    'ATAHD'        => "ATA Hard Drive Flag File",
    'ADOX'         => "ActivDox Document",
    'ARR'          => "MultiMedia Fusion Array File",
    'ADV'          => "Audio Driver File",
    'AQT'          => "AQTitle Subtitles File",
    'ACC'          => "GEM Accessory File",
    'ABS'          => "Avant Browser Skin File",
    'ABS'          => "AB SuDoKu Saved Game",
    'AGB'          => "Game Boy Advance ROM",
    'AVA'          => "AvaaBook eBook",
    'ADOBEBRIDGE'  => "Adobe Bridge URL FIle",
    'A5RPT'        => "Alpha Five Project Report File",
    'ARC.LH'       => "Nintendo Archive File",
    'AVM'          => "Anime Music Video",
    'AS2'          => "ActivStudio Resource Pack",
    'AZW3F'        => "Amazon eBook Metadata File",
    'ANIMEPROJ'    => "Anime Studio Document Data File",
    'ANIMESTYLE'   => "Anime Studio Style Document",
    'ANIMEACTION'  => "Anime Studio Action Document",
    'ANIMEBRUSH'   => "Anime Studio Brush Document",
    'AIX'          => "AIX Audio File",
    'AUTOSAVE.CDP' => "Sony CD Architect Project Autosave File",
    'BAT'          => "DOS Batch File",
    'BMP'          => "Bitmap Image File",
    'BAK'          => "Backup File",
    'BIN'          => "Binary Disc Image",
    'B'            => "Grand Theft Auto 3 Saved Game File",
    'BZ'           => "Bzip Compressed File",
    'BZ2'          => "Bzip2 Compressed File",
    'BIB'          => "BibTeX Bibliography Database",
    'BKP'          => "Backup File",
    'BUNDLE'       => "Mac OS X Application Bundle",
    'BLEND'        => "Blender 3D Data File",
    'BUP'          => "DVD IFO Backup File",
    'BIK'          => "Bink Video File",
    'BIN'          => "Binary Video File",
    'BR5'          => "Bryce 5 Scene File",
    'BSP'          => "Quake Engine Game Map File",
    'BMS'          => "BeatMania Song File",
    'BSF'          => "Blu-ray AVC Video File",
    'BLG'          => "Windows Binary Performance Log File",
    'BZW'          => "BZFlag World File",
    'BLD'          => "Envisioneer Building Project File",
    'BSB'          => "BioShock Saved Game File",
    'BDM'          => "AVCHD Information File",
    'BASH_HISTORY' => "Bash History File",
    'BASHRC'       => "Bash Non-Interactive Login Shell File",
    'BASH_PROFILE' => "Bash Interactive Login Shell File",
    'BVP'          => "VodaHost BlueVoda Project File",
    'BR6'          => "Bryce 6 Scene File",
    'BOOK'         => "FrameMaker Book File",
    'B3D'          => "Blitz3D Entity Model File",
    'BBPROJECTD'   => "BBEdit Project Document",
    'BIF'          => "BioWare Infinity Engine File",
    'BGL'          => "Flight Simulator Scenery File",
    'BCD'          => "Windows Boot Configuration Data File",
    'BO3'          => "Minecraft BO3 Object File",
    'BIN'          => "Macbinary Encoded File",
    'BAS'          => "BASIC Source Code File",
    'BCP'          => "Borland C++ Makefile",
    'BUP'          => "Backup File",
    'BDB'          => "Microsoft Works Database Backup File",
    'BDF'          => "Glyph Bitmap Distribution Format",
    'BCK'          => "VMX Backup File",
    'BOX'          => "E-mail Mailbox",
    'BHX'          => "BinHex Encoded File",
    'BPL'          => "AutoCAD Batch Plot File",
    'BP2'          => "AutoCAD Batch Plot File",
    'BP3'          => "AutoCAD Batch Plot File",
    'BOK'          => "TestGen Testbank File",
    'BAND'         => "GarageBand Project File",
    'BPG'          => "Borland Project Group",
    'BIK'          => "Video Game Movie File",
    'BPL'          => "Borland Package Library",
    'BWI'          => "BlindWrite CD/DVD Disc Image",
    'BWT'          => "BlindWrite 4 Track Information FIle",
    'BWF'          => "Broadcast Wave File",
    'BAK'          => "Firefox Bookmarks Backup",
    'BBC'          => "BBC BASIC Data File",
    'BIN'          => "Generic Binary File",
    'BK'           => "FrameMaker Book File",
    'BKF'          => "Windows Backup Utility File",
    'BMC'          => "Bitmap Cache File",
    'BFC'          => "Windows Briefcase File",
    'BIB'          => "Bibliography Document",
    'BST'          => "BibTeX Style Document",
    'BCM'          => "Business Contact Manager File",
    'BCMX'         => "Business Contact Manager Customization",
    'BR4'          => "Bryce 4 Scene File",
    'BOC'          => "EasyWord Big Document",
    'BC'           => "BitComet Partially Downloaded File",
    'BAP'          => "Blaze Audio Wave Information File",
    'BB'           => "Blitz Source Code File",
    'BKC'          => "Backup4all Backup Catalog",
    'BDD'          => "CARA Sound Radiation Data File",
    'BEAN'         => "Bean Rich Text Document",
    'BIG'          => "Electronic Arts Game Data File",
    'BRD'          => "EAGLE Circuit Board File",
    'BS2'          => "BASIC Stamp 2 Code File",
    'BC!'          => "BitComet Incomplete File",
    'BTM'          => "BizTalk Map File",
    'BKK'          => "BookBuddi eBook File",
    'BCI'          => "Belarc Advisor Report File",
    'BWA'          => "BlindWrite Disk Information File",
    'BWS'          => "BlindWrite Sub Code File",
    'BIP'          => "Character Studio Biped File",
    'BFA'          => "Blowfish Encrypted File",
    'BML'          => "Bean Markup Language File",
    'BACKUPDB'     => "Time Machine Backup Folder",
    'BGI'          => "BgInfo Configuration File",
    'BIN'          => "Sega Genesis Game ROM",
    'BIN'          => "Unix Executable File",
    'BCKP'         => "Ad-Aware Quarantined File",
    'BET'          => "BETA Source File",
    'BOOTSKIN'     => "Stardock Bootskin File",
    'BGL'          => "Babylon Glossary File",
    'BLKRT'        => "Block Artist Image File",
    'B'            => "BASIC Source File",
    'BPA'          => "StorageSync Backup Archive",
    'BGT'          => "Graphics Accounts Data File",
    'BAV'          => "AVG AntiVirus The Bat! Plugin File",
    'BLT'          => "AIM Buddy List",
    'BIZ'          => "Broderbund Business Card File",
    'BME'          => "BeatMania 7-Key Song File",
    'BIF'          => "Boot Information File",
    'BA'           => "Scifer External Header Archive",
    'BRO'          => "CreataCard Brochure Project",
    'BRO'          => "Broadleaf Tree Model",
    'BLB'          => "Blob Data File",
    'BLOB'         => "Valve Steam Archive",
    'BVH'          => "Biovision Hierarchy Animation File",
    'B64'          => "Base64 MIME-Encoded File",
    'BZIP'         => "Bzip Compressed Archive",
    'BOK'          => "ProStores Dynamic Web Page",
    'BDIC'         => "Chrome Dictionary File",
    'BDR'          => "Exchange Non-Delivery Report Body File",
    'BAD'          => "Exchange Badmail File",
    'BDP'          => "Exchange Diagnostic Message",
    'BNA'          => "Barna Word Processor Document",
    'BCF'          => "Business Card Designer Pro File",
    'BCP'          => "Business Card Designer Plus File",
    'BCP'          => "BlackMagic Custom Palette",
    'BTW'          => "BarTender Label",
    'BSA'          => "Bethesda Softworks Archive",
    'BLS'          => "Blockland Saved Game File",
    'BUN'          => "Cakewalk Bundle File",
    'B6I'          => "BlindWrite 6 Disc Image",
    'B6T'          => "BlindWrite 6 Track Information File",
    'BNK'          => "Test Drive Unlimited Data Package",
    'BAU'          => "Apache OpenOffice AutoText File",
    'BJO'          => "TabRite Tablature File",
    'BPW'          => "Bitser Password File",
    'BDMV'         => "Blu-ray Disc Movie Information File",
    'BAR'          => "Age of Empires 3 Data File",
    'BRW'          => "Calyx Point Borrower File",
    'BIN'          => "Nintendo DS Binary File",
    'BKS'          => "NTBackup Settings File",
    'BMK'          => "PowerDVD MovieMark File",
    'BDL'          => "CoCreate Bundle File",
    'BCC'          => "Calendar Creator File",
    'BM2'          => "Subspace Bitmap File",
    'BDC'          => "Babylon Dictionary File",
    'BMD'          => "MU Online Game Data File",
    'BTAPP'        => "uTorrent App",
    'BLZ'          => "N-Gage Mobile Video Game File",
    'BROWSER'      => "ASP.NET Browser Definition File",
    'BSC'          => "Visual Studio Source Browser Information",
    'BTSEARCH'     => "BitTorrent Search Engine File",
    'BLK'          => "AutoCAD Block Template File",
    'BLW'          => "Adobe Photoshop Black and White Presets",
    'BRX'          => "BREW Application Resource File",
    'BFS'          => "FlatOut Game Data File",
    'BZABW'        => "Compressed AbiWord Document",
    'BRAIN'        => "PersonalBrain Mind Map File",
    'BFG'          => "Big Fish Games Application File",
    'BFF'          => "Backup File Format",
    'BAK'          => "ACT! Backup File",
    'BR7'          => "Bryce 7 Scene File",
    'BLG'          => "BibTeX Log File",
    'BIN'          => "Generic Binary Executable File",
    'BBL'          => "BibTeX Generated Bibliography File",
    'BLP'          => "Blizzard Texture File",
    'BRG'          => "ProjectWise User Settings File",
    'BLF'          => "CLFS Base Log File",
    'BBPROJECT'    => "BBEdit Project File",
    'BBLM'         => "BBEdit Language Module",
    'BIDULE'       => "Bidule Layout File",
    'BBB'          => "BlackBerry Mobile Phone Backup File",
    'BLEND1'       => "Blender Document Backup File",
    'BMS'          => "BIOWRAP Multi-Layer Security File",
    'BIL'          => "ESRI BIL File",
    'BIT'          => "Xilinx Bitstream File",
    'BEAM'         => "Compiled Erlang File",
    'BRD'          => "Cadence Allegro PCB Design File",
    'BOOK'         => "iBooks Author Document",
    'B1'           => "B1 Compressed Archive",
    'BIN'          => "Router Firmware File",
    'BRN'          => "BrainStorm Data File",
    'BLOGTHIS'     => "Windows Live Writer Data File",
    'BDT3'         => "BEEDOCS Timeline 3D 3 Document",
    'BM3'          => "Sony Ericsson Backup File",
    'BDSPROJ'      => "Borland Developer Studio Project",
    'BMZ'          => "Portal Bonus Map Zip File",
    'BNS'          => "Portal Bonus Map Script",
    'BRO'          => "Design & Print Page Design File",
    'BS7'          => "Windows 7 Boot Updater Skin",
    'BVD'          => "Bitdefender Vault File",
    'BITPIM'       => "BitPim Configuration File",
    'BIO'          => "Mudbox Bio 3D File",
    'BSS'          => "Resident Evil Background Images File",
    'BAY'          => "Casio RAW Image",
    'BRS'          => "RoboHelp Browse Sequence File",
    'BBCD'         => "BobCAD-CAM Document",
    'BCD'          => "RealView Debugger Board Chip Definition",
    'BCL'          => "Illumina Base Call File",
    'BED'          => "UCSC BED Annotation Track File",
    'BHO'          => "Behold Organize File",
    'BPDX'         => "Acrobat Batch PDX File",
    'BPN'          => "ArchiCAD Project Backup File",
    'BPD'          => "Business Plan Pro Document",
    'BPDX'         => "Business Plan Pro Document",
    'BPM'          => "Trados AutoSuggest Dictionary File",
    'BQY'          => "Brio Query File",
    'BRF'          => "Braille Ready Format File",
    'BSDL'         => "Boundary Scan Description Language File",
    'BSD'          => "BSDL File",
    'BTD'          => "Business-in-a-Box Document",
    'BTM'          => "4DOS Batch File",
    'BWW'          => "Bagpipe Player File",
    'BXL'          => "Accelerated Designs PCB Library File",
    'BKZ'          => "FileFort Backup File",
    'BRRES'        => "Wii BRRES Resource Package",
    'BIONIX'       => "BioniX Wallpaper Playlist File",
    'BUP'          => "McAfee Quarantined File",
    'BMC'          => "Bolide Movie Creator Project File",
    'BACKUP'       => "Android Backup File",
    'BEJEWELED2DE' => "U'XESAVEDGAME Bejeweled 2 Deluxe Saved Game",
    'BLACKHAWKSTR' => "K'ER2         Blackhawk Striker 2 Saved Game",
    'BLASTERBALL3' => "A'VEDGAME     BlasterBall 3 Saved Game",
    'BOOKWORMDELU' => "E'SAVEDGAME   Bookworm Deluxe Saved Game",
    'BNDL'         => "Game Data Bundle File",
    'BNK'          => "Adlib Instrument Bank",
    'BLUEJ'        => "BlueJ Package File",
    'BPM'          => "Bizagi Process Modeler",
    'BPMC'         => "Bizagi Process Modeler Collaboration",
    'BUS'          => "OMSI Bus Configuration File",
    'BAKX'         => "Finale Backup File",
    'BLORB'        => "Interactive Fiction Package Game File",
    'BPS'          => "BPS Patch File",
    'BPG'          => "BPG Image",
    'BUILDSETTING' => "Twixl Publisher Builder Build Setting",
    'BIBTEX'       => "BibTeX Bibliography Database",
    'BO2'          => "Minecraft BO2 Object File",
    'BZPLUG'       => "AfterShot Pro Plugin Bundle",
    'BPL'          => "Bore Plan Log",
    'BR'           => "Brotli Compressed File",
    'BINARYCOOKIE' => " 'Safari Cookies File",
    'BA2'          => "Bethesda Softworks Archive",
    'BDOC'         => "Binary DigiDoc Signature File",
    'BIMX'         => "BIM Explorer File",
    'BOOK'         => "BookSmart Book File",
    'BBS'          => "Bulletin Board System Text",
    'BH'           => "BlakHole Archive",
    'BCM'          => "Microsoft Works Communications Script",
    'BKS'          => "Microsoft Works Spreadsheet Backup File",
    'BMF'          => "Binary Material File",
    'BOO'          => "Booasm Compressed Archive",
    'BYU'          => "Brigham Young University Movie File",
    'BMK'          => "Help Bookmarks",
    'BTF'          => "NationsBank Check Images",
    'BIC'          => "Civilization 3 Scenario File",
    'BIQ'          => "Civilization 3 Scenario File",
    'BIX'          => "Civilization 3 Scenario File",
    'BOX'          => "Kodicom Video",
    'B5I'          => "BlindWrite 5 Disk Image",
    'B5T'          => "BlindWrite 5 Disc Track Information File",
    'BR3'          => "Bryce 3 Scene File",
    'BDF'          => "Binary Data File",
    'BMF'          => "FloorPlan File",
    'BMD'          => "GameCube 3D Model File",
    'BDR'          => "Publisher Borders File",
    'BAFL'         => "BurnAware File List",
    'BPB'          => "PowerDesigner Business Process Backup",
    'BPM'          => "PowerDesigner Business Process Model",
    'BND'          => "DB2 CLI Bind File",
    'B2A'          => "Btoa Encoded File",
    'BOM'          => "Mac OS X Bill of Materials File",
    'BXX'          => "BS Contact Parameter File",
    'BTR'          => "Btrieve Database File",
    'BFX'          => "Bitware Fax Document",
    'BIO'          => "BIOS File",
    'BS4'          => "Mikogo Session Video Recording",
    'BOOT'         => "InstallShield Boot File",
    'BAR'          => "Age of Mythology Data File",
    'BM2'          => "Boardmaker Interactive Board File",
    'BK1'          => "Autodesk Backup File",
    'BNG'          => "The Bingo Maker Card File",
    'BNZ'          => "The Bingo Maker Card Template File",
    'BSH'          => "BeanShell Script",
    'BOOK'         => "Budget In Brief Book File",
    'BPK'          => "Nero SecurDisc Public Key File",
    'BSK'          => "Nero SecurDisc Private Key File",
    'BC'           => "Adobe Bridge Cache File",
    'BCT'          => "Adobe Bridge Thumbnail Cache File",
    'BIM'          => "Bytessence InstallMaker Document",
    'BAR'          => "Brew MP Binary Application Resource File",
    'BIN'          => "Atari 2600 Game ROM",
    'BMK'          => "Nokia Device Bookmark File",
    'BAK~'         => "AbiWord Auto-Saved Document",
    'BRO'          => "Bryce Plug-in",
    'BRI'          => "Bryce Plug-in File",
    'BRM'          => "Bryce Plug-in File",
    'BTO'          => "Bryce Tree File",
    'BRT'          => "Bryce Textures File",
    'BSK'          => "Bryce Skies File",
    'BPS'          => "BPS Virus File",
    'BRG'          => "Age of Mythology Model File",
    'BNP'          => "Sony Camcorder Video Data File",
    'BLF'          => "MasterWorks Working File",
    'BF'           => "CryoBF Game Data File",
    'B4S'          => "Winamp Playlist File",
    'BKZ'          => "BaKoMa TeX Installation Module",
    'BIF'          => "Get Backup Project File",
    'BIFX'         => "Get Backup Project",
    'BDC'          => "West Point Bridge Designer Design File",
    'BLEND2'       => "Blender Document Backup 2 File",
    'BTN'          => "AutoPlay Media Studio Button File",
    'BIN'          => "PCSX PlayStation BIOS Image",
    'BS1'          => "VirtualBus Vehicle Configuration File",
    'BKMK'         => "Yummy FTP Bookmark File",
    'BMK'          => "BillMinder Backup File",
    'BDAE'         => "Gameloft Game Data File",
    'BIC'          => "Neverwinter Nights Character File",
    'BMI'          => "3ds Max Plug-in",
    'BRSTM'        => "BRSTM Audio Stream File",
    'BRX'          => "Beam Report Document",
    'BLN'          => "Golden Software Blanking File",
    'BOOKTEMPLATE' => "iBooks Author Document Template",
    'BIN'          => "BlackBerry IT Policy File",
    'BRN'          => "Cube Graphics File",
    'BKUP'         => "Backup File",
    'BDT2'         => "BEEDOCS Timeline 3D 2 Document",
    'BMX'          => "Siemens Mobile Animations File",
    'BTI'          => "Nintendo Texture File",
    'BMZ'          => "Compressed Bitmap Image",
    'BPNUEB'       => "PNU eBook File",
    'BUILDPATH'    => "Eclipse Build Path File",
    'BCS'          => "Batch Compiler Specification File",
    'BCP'          => "Batch Compiler Preset File",
    'BOX'          => "Microsoft Store Download File",
    'BPF'          => "Baan ERP Document",
    'BPR'          => "Borland C++Builder Project File",
    'BPW'          => "Bitmap World File",
    'BT'           => "Binary Terrain File",
    'BVR'          => "Blue Iris Video",
    'BWG'          => "BrainWave Generator Audio File",
    'BLB'          => "Dreamworks Resource File",
    'BRD'          => "KiCad PCB Design File",
    'BRMDL'        => "Wii BRMDL Model File",
    'BRSAR'        => "Wii BRSAR Audio Archive",
    'BASERPROJ'    => "DNA Baser Project File",
    'BASEX'        => "BaseX Data File",
    'BT!'          => "BitSpirit Incomplete Download File",
    'BFM'          => "Terminal Reality Model File",
    'BB3'          => "BlasterBall 3 Level File Support",
    'BLI'          => "Thomson Speedtouch Firmware File",
    'BUD'          => "Binary Printer Description File",
    'BPD'          => "Binary Printer Description File",
    'BNK'          => "Spotify Playlist File",
    'BCM'          => "Adobe Bridge Cache File",
    'BYTES'        => "Binary Text Asset Data File",
    'BAK'          => "Finale Backup File",
    'BU'           => "Samsung CCTV Video File",
    'BDF'          => "Bulk Data Input File",
    'BLB'          => "Interactive Fiction Package Game File",
    'BRL'          => "MicroBraille File",
    'BML'          => "Braille 2000 Braille File",
    'BMML'         => "Braille Music Markup Language File",
    'BAK2'         => "Backup File",
    'BAK3'         => "Backup File",
    'BUNDLE'       => "Game Data Bundle File",
    'BIO'          => "Fallout 2 Character Biography File",
    'BRTEX'        => "Wii BRTEX Texture File",
    'BLK'          => "ABBYY FineReader Area Template",
    'BRUSHLIBRARY' => "Painter Brush Library",
    'BRUSHCATEGOR' => " 'Painter Brush Category File",
    'BRUSHVARIANT' => "Painter Brush Variant File",
    'BDF'          => "BSDiff Patch File",
    'BMQ'          => "Re-Volt Mipmap File",
    'BPHYS'        => "Blender Cache File",
    'BW'           => "Black and White SGI Image File",
    'BRR'          => "SNES Sample File",
    'BC5B'         => "Ransomware Encrypted File",
    'BPJ'          => "Boxsim Simulation Project",
    'BCSTM'        => "BCSTM Audio Stream File",
    'BOOKEXPORT'   => "BookSmart Backup Book File",
    'BOOKTEMPLATE' => "BookSmart Template",
    'BOS'          => "Build Options Specification File",
    'BMML'         => "Balsamiq Mockups Markup Language File",
    'BLD'          => "Skyscraper Simulator Building Script",
    'BUL'          => "I4 Bullseye Data File",
    'BLUEBUTTON'   => "VA Blue Button Data File",
    'BSW'          => "StruWalker 3D Model",
    'BSWX'         => "BIMReview 3D Model",
    'B6Z'          => "B6Z Archive",
    'BSXP'         => "BimSens Project Configuration File",
    'BSXC'         => "BimSens Component Configuration File",
    'BIT'          => "FinalCrypt Encrypted Data File",
    'BRV'          => "Brick Rigs Vehicle File",
    'BPLX'         => "Bore Plan XML File",
    'BAK'          => "MobileTrans Backup File",
    'BIP'          => "Dharma Ransomware Encrypted File",
    'BAK2'         => "Starbound Backup File",
    'BAK3'         => "Starbound Backup File",
    'BNK'          => "ExamView Question Bank File",
    'BFSTM'        => "BFSTM Audio Stream File",
    'BINARY'       => "PC Building Simulator Save File",
    'BLK'          => "BLK360 Data File",
    'BIN'          => "Nintendo Wii Data File",
    'BLZ'          => "TeamViewer Blizz Session File",
    'BSG'          => "Besiege Machine File",
    'BPS'          => "Works Document Backup",
    'BAC'          => "Backup File",
    'BUF'          => "Buffer File",
    'BTIF'         => "NationsBank Check Image File",
    'BLZ'          => "Compressed Bitmap Image",
    'BLU'          => "FileMaker Pro Runtime Extension",
    'BIX'          => "Kodicom Video File",
    'BMC'          => "Embroidery Image File",
    'BOX'          => "CARA Loudspeaker Design File",
    'BDF'          => "MIDAS BDF Disk Image File",
    'BZIP2'        => "Bzip2 Compressed Archive",
    'BTOA'         => "Binary-to-ASCII Encoded File",
    'BRK'          => "Brooktrout Fax Document",
    'BK1'          => "ERwin Backup File",
    'BGZ'          => "Blood Frontier Map File",
    'BKP'          => "Zapback Backup File",
    'BZA'          => "IZArc BGA Archive",
    'BLP'          => "Speedy Eggbert Game Data File",
    'BK1'          => "Windows Indexing Service File",
    'BK2'          => "Windows Indexing Service Data File",
    'BUS'          => "VirtualBus Board Parameters File",
    'BTINSTALL'    => "uTorrent Installer File",
    'BWA'          => "Bookworm Adventures Player File",
    'BWZ'          => "WinImage Batch Configuration File",
    'BA_'          => "Renamed BAT File",
    'BCS'          => "Boland Calibration Settings File",
    'BRN'          => "Gabriel Knight Barn File",
    'BUR'          => "BuRg3r Source Code File",
    'B'            => "BuRg3r Definition File",
    'BWP'          => "BuRg3r Web Page",
    'BCS'          => "Sonic Foundry Batch Converter Script",
    'BMG'          => "Nintendo DS On-Screen Text File",
    'BBZ'          => "BerryBuzz Backup File",
    'BRLYT'        => "Wii Textures and Material Lists File",
    'BONK'         => "Bonk Audio File",
    'BLOCKPLT'     => "LEGO MINDSTORMS NXT Block Palette File",
    'BPZ'          => "Easy Blue Print Symbol Library",
    'BRIDGECACHE'  => "Adobe Bridge Cache Export File",
    'BREFF'        => "Wii Effect Controls File",
    'BREFT'        => "Wii Effects File",
    'BSDIFF'       => "BSDiff Patch File",
    'BA6'          => "TaxAct 2016 Tax Return Backup File",
    'BA7'          => "TaxAct 2016 Tax Return Backup File",
    'BAK1'         => "Starbound Backup File",
    'CER'          => "Internet Security Certificate",
    'CGI'          => "Common Gateway Interface Script",
    'CSS'          => "Cascading Style Sheet",
    'CSV'          => "Comma Separated Values File",
    'CAB'          => "Windows Cabinet File",
    'CBR'          => "Comic Book RAR Archive",
    'COM'          => "DOS Command File",
    'CPP'          => "C++ Source Code File",
    'C'            => "C/C++ Source Code File",
    'CFM'          => "ColdFusion Markup File",
    'CUR'          => "Windows Cursor",
    'CPL'          => "Windows Control Panel Item",
    'CFG'          => "Configuration File",
    'CLASS'        => "Java Class File",
    'CUE'          => "Cue Sheet File",
    'CS'           => "C# Source Code File",
    'CRX'          => "Chrome Extension",
    'CSR'          => "Certificate Signing Request File",
    'CRDOWNLOAD'   => "Chrome Partially Downloaded File",
    'CDR'          => "CorelDRAW Image File",
    'CGM'          => "Computer Graphics Metafile",
    'CDA'          => "CD Audio Track Shortcut",
    'CHM'          => "Compiled HTML Help File",
    'CMD'          => "Windows Command File",
    'CRT'          => "Security Certificate",
    'CPT'          => "Corel Photo-Paint Image",
    'CVX'          => "Canvas Drawing File",
    'CSF'          => "Adobe Color Settings File",
    'CATPART'      => "CATIA V5 Part File",
    'CRD'          => "Windows CardSpace File",
    'CPR'          => "Cubase Project",
    'CCD'          => "CloneCD Disc Image",
    'CDI'          => "DiscJuggler Disc Image",
    'CR2'          => "Canon Raw Image File",
    'CBZ'          => "Comic Book Zip Archive",
    'CONF'         => "Unix Configuration File",
    'CAF'          => "Core Audio File",
    'CTF'          => "AVG Update Control File",
    'CKD'          => "Kubotek Design Container",
    'CP'           => "Xcode C++ Source File",
    'CSPROJ'       => "Visual Studio C# Project",
    'CSH'          => "Photoshop Custom Shapes File",
    'CONTACT'      => "Windows Contact File",
    'CPG'          => "Manga Studio Page File",
    'CTB'          => "AutoCAD Color-Based Plot Style File",
    'C2R'          => "Windows Media Center Click-To-Record File",
    'CVA'          => "HP System Software Manager Information File",
    'CDD'          => "ConceptDraw PRO Document",
    'CDB'          => "Symbian Phonebook Database",
    'CPI'          => "AVCHD Video Clip Information File",
    'CATPRODUCT'   => "CATIA V5 Assembly File",
    'CLG'          => "Windows Catalog File",
    'CHR'          => "3ds Max Characters File",
    'CDMM'         => "ConceptDraw MINDMAP Document",
    'CHD'          => "MAME Hard Disk Image",
    'CAMPROJ'      => "Camtasia Studio Project",
    'CLS'          => "LaTeX Document Class File",
    'CUB'          => "Analysis Services Cube File",
    'CDX'          => "ChemDraw Exchange File",
    'CEL'          => "Affymetrix Probe Results File",
    'CELX'         => "Celestia Script",
    'CEL'          => "Celestia Script File",
    'CDF'          => "Computable Document Format File",
    'CNF'          => "MySQL Configuration File",
    'CSHTML'       => "ASP.NET Razor Web Page",
    'CST'          => "Manga Studio Story File",
    'CGFX'         => "CgFX Shader File",
    'CG'           => "Cg Program",
    'CLP'          => "CrazyTalk Clip File",
    'CCP'          => "CopperCube JavaScript File",
    'CDDZ'         => "ConceptDraw PRO Document",
    'CRP'          => "Cities: Skylines Colossal Raw Asset Package",
    'CAPT'         => "Capito Data File",
    'CMA'          => "Coach Activity File",
    'CDOC'         => "Clicker Document",
    'CLIP'         => "Clip Studio Format File",
    'CRYPT12'      => "WhatsApp Encrypted Database File",
    'CBL'          => "COBOL Source Code File",
    'COB'          => "COBOL Source Code File",
    'CC'           => "C++ Source Code File",
    'CHK'          => "Saved File Fragment",
    'CIN'          => "Kodak Cineon Bitmap File",
    'CWK'          => "ClarisWorks Document",
    'CSH'          => "C Shell Script",
    'CDF'          => "Common Data Format",
    'CDX'          => "Compound Index File",
    'CNT'          => "Help Contents File",
    'CSF'          => "Content Sealed Format",
    'CIL'          => "Clip Gallery Packaged File",
    'C01'          => "WinAce Split Archive Part 1 File",
    'CWP'          => "Cakewalk SONAR Project",
    'CDT'          => "CorelDRAW Image Template",
    'CVI'          => "Canvas Image File",
    'CV5'          => "Canvas 5 Drawing File",
    'CP'           => "Captivate Source File",
    'CHA'          => "IRC Chat Configuration File",
    'CHAT'         => "IRC Chat Configuration File",
    'COD'          => "Compiled Source Code",
    'CONFIG'       => "Configuration File",
    'CEL'          => "Audition Loop",
    'CACHE'        => "Cache File",
    'CRZ'          => "Compressed Poser Character Rigging File",
    'CLKK'         => "Clicker Keyboard",
    'CLKT'         => "Clicker Template",
    'CLKW'         => "Clicker Word Bank",
    'CLKX'         => "Clicker Grid Set",
    'COMPONENT'    => "Mac OS X System Component",
    'CTF'          => "WhereIsIt Catalog File",
    'CP9'          => "ChoicePoint Encrypted File",
    'COPY'         => "Sony Ericsson Protected Content File",
    'CSH'          => "Cubase Waveform File",
    'CHARSET'      => "Character Set",
    'CDR'          => "Raw Audio CD Data",
    'CHORD'        => "Song Chords File",
    'CLS'          => "Program Class File",
    'CGF'          => "Crytek Geometry Format File",
    'CMX'          => "Corel Metafile Exchange Image File",
    'CAM'          => "Gerber CAM Job File",
    'CKT'          => "CircuitMaker File",
    'C4D'          => "Cinema 4D Model File",
    'CFG'          => "Citrix Server Connection File",
    'CSI'          => "ContentServ Include File",
    'CHW'          => "Compiled Help Index File",
    'CTT'          => "Messenger Contact List",
    'CYI'          => "Clustify Input File",
    'CYO'          => "Clustify Output File",
    'CAMREC'       => "Camtasia Studio Screen Recording",
    'CR2'          => "Poser Character Rigging File",
    'CP3'          => "Grand Prix 3 Cockpit Shape File",
    'CSO'          => "Compressed ISO Disk Image",
    'CPC'          => "CPC Compressed Image File",
    'CTG'          => "Canon Digital Camera Catalog File",
    'CHK'          => "StarCraft Chunk File",
    'CPGZ'         => "Compressed CPIO Archive",
    'CPIO'         => "Unix CPIO Archive",
    'CFL'          => "IMVU Product File",
    'C00'          => "WinAce Split Archive File",
    'CTY'          => "SimCity City File",
    'CTL'          => "Visual Basic UserControl Object File",
    'CON'          => "Concept Application Source File",
    'CSA'          => "PNA Code Calset File",
    'CLD'          => "Canon CD Label Template",
    'CPH'          => "Corel Print House File",
    'CPS'          => "Corel Photo House File",
    'CVG'          => "Calamus Vector Graphic File",
    'CIDB'         => "iTunes CD Information File",
    'CHL'          => "WinFast PVR2 Channel List",
    'CAP'          => "Packet Capture File",
    'CIT'          => "Intergraph Bitmap Image File",
    'COMICDOC'     => "Comic Life Document",
    'CCF'          => "CryptLoad Container File",
    'CM2'          => "Poser Camera Set File",
    'CMZ'          => "Compressed Poser Camera Set File",
    'CLR'          => "Animate Color Set",
    'CLR'          => "CryptLoad Router Information File",
    'CD2'          => "Click'N Design 3D File",
    'CSD'          => "Compact Shared Document",
    'CVN'          => "CineVision Encoding Session",
    'CL5'          => "Easy CD Creator 5 Saved Project",
    'CSI'          => "EdLog Program Data File",
    'CD'           => "Visual Studio Class Diagram",
    'CSM'          => "Character Studio Marker File",
    'CRWL'         => "Windows Crawl File",
    'CCN'          => "Compressed Multimedia Fusion File",
    'CAN'          => "Canon Navigator Fax Document",
    'CUI'          => "Autodesk Custom Workspace File",
    'CD5'          => "Chasys Draw Image File",
    'CGZ'          => "Linux Drivers Archive",
    'CGZ'          => "Cube Map File",
    'CELTX'        => "Celtx Project File",
    'CPI'          => "Codepage Information File",
    'CPT'          => "Ccrypt Encrypted Archive",
    'C'            => "Lite-C Script",
    'CNA'          => "Catena Project File",
    'CBT'          => "Comic Book TAR File",
    'CURXPTHEME'   => "CursorXP Theme File",
    'CURSORFX'     => "CursorFX Theme File",
    'CVD'          => "ClamAV Virus Definitions File",
    'CDP'          => "Trainz Simulator Content Dispatcher Pack",
    'CDP2'         => "Trainz Classics Content Dispatcher Pack 2",
    'CAD'          => "BobCAD-CAM File",
    'CT'           => "Cheat Engine Cheat Table",
    'CRTX'         => "Office 2007 Chart Template File",
    'CDG'          => "Compact Disc Plus Graphics Image",
    'CPT'          => "DTS Compact Audio File",
    'CAMP'         => "WCS Color Appearance Model Profile File",
    'CRC'          => "Total Commander Checksum File",
    'CLM'          => "MagicJack Call Log File",
    'CDB'          => "Pocket Access Database",
    'CDB'          => "CardScan Contacts Database",
    'CTP'          => "CakePHP Template",
    'CRASH'        => "Mac OS X Crash Log File",
    'CPX'          => "Oracle ADF Binding Context File",
    'CLPI'         => "Blu-ray Clip Information File",
    'CBF'          => "Calendar Builder File",
    'CLB'          => "COM+ Catalog File",
    'CAV'          => "Comodo Virus Definitions File",
    'CDL'          => "CADKEY Wireframe Design File",
    'CTM'          => "CrazyTalk Model File",
    'CLG'          => "Collage Maker Project File",
    'CLK'          => "Corel R.A.V.E Project File",
    'CPN'          => "Age of Mythology Campaign File",
    'CUIX'         => "AutoCAD Custom User Interface File",
    'CAF'          => "Class Action Gradebook File",
    'CDR'          => "Macintosh DVD/CD Master",
    'CBDS'         => "Comic Book DS File",
    'CFC'          => "ColdFusion Component File",
    'CFA'          => "Adobe Conformed Audio File",
    'CONTOUR'      => "Contour Screenplay File",
    'CXX'          => "C++ Source Code File",
    'CFS'          => "Compact File Set Archive",
    'CUL'          => "Windows Cursor Library",
    'COMPOSITEFON' => " 'Windows Composite Font File",
    'CDDA'         => "CD Digital Audio File",
    'CLASSLIST'    => "SMART Notebook Class List File",
    'CHX'          => "AutoCAD Standards Check File",
    'CPA'          => "CADSTAR PCB Archive File",
    'CSN'          => "Adobe Code Snippet Document",
    'CLX'          => "Standard Dictionary File",
    'CDMT'         => "ConceptDraw MINDMAP Template",
    'CDMTZ'        => "Compressed ConceptDraw MINDMAP Template",
    'CDMZ'         => "Compressed ConceptDraw MINDMAP Document",
    'CSY'          => "Canvas Symbol File",
    'CVA'          => "Canvas Sequence Set",
    'CMPROJ'       => "Camtasia Project File",
    'CMREC'        => "Camtasia Recording",
    'CONF'         => "Generic Configuration File",
    'CARC'         => "Nintendo DS Compressed Archive File",
    'CMMTPL'       => "Camtasia MenuMaker Template",
    'CMMP'         => "Camtasia MenuMaker Project",
    'CML'          => "Chemical Markup Language File",
    'CPTX'         => "Adobe Captivate Project File",
    'CREV'         => "Adobe Captivate Commentable SWF File",
    'CRDS'         => "Windows CardSpace Backup File",
    'CRY'          => "CryENGINE Map File",
    'CDPZ'         => "ConceptDraw PROJECT Document",
    'CRL'          => "Certificate Revocation List File",
    'CCA'          => "Multimedia Fusion File",
    'CPY'          => "3ds Max Copy Track File",
    'CAL'          => "3ds Max Pose Adjustment File",
    'CAS'          => "Autodesk Cascade License File",
    'CMAP'         => "CmapTools Concept Map File",
    'CLEO'         => "CLEO Grand Theft Auto Mod File",
    'CUB'          => "ISIS Cube File",
    'CST'          => "Director External Cast File",
    'CBP'          => "Code::Blocks Project File",
    'CVR'          => "Microsoft Crash Report File",
    'CLW'          => "Visual C++ ClassWizard File",
    'CTV3'         => "Citavi 3 Project File",
    'CTV'          => "Citavi Project",
    'CPK'          => "DTM Test Log File",
    'CDXML'        => "ChemDraw XML File",
    'CPG'          => "ESRI Code Page File",
    'COF'          => "MPLAB COFF File",
    'C3D'          => "Coordinate 3D File",
    'CRF'          => "Cal3D Binary Materials File",
    'CMF'          => "Cal3D Binary Mesh File",
    'CFG'          => "Cal3D Model Configuration File",
    'CAF'          => "Cal3D Binary Animation File",
    'CU'           => "CUDA Source Code File",
    'CDF'          => "Affymetrix Chip Definition File",
    'CNC'          => "PartMaster CNC File",
    'CSAPLAN'      => "SPSS Analysis Plan File",
    'CMOD'         => "Celestia Model",
    'CMP'          => "HotDocs Clause Component File",
    'CMP'          => "Windows Connection Manager Profile",
    'COMMAND'      => "Terminal Command File",
    'CPR'          => "Windows Phone Display Settings File",
    'CGR'          => "CATIA Graphical Representation File",
    'CPF'          => "Cognos Project File",
    'CAT'          => "Windows Catalog File",
    'CEX'          => "SolidWorks Enterprise PDM Vault Export File",
    'CCGAME'       => "XNA Creators Club Game Package",
    'CZIP'         => "ZipGenius CryptoZip File",
    'CLT'          => "Clarity Legal Transcript File",
    'CBA'          => "Comic Book ACE Archive",
    'CYS'          => "Cytoscape Session File",
    'CBU'          => "Comodo Backup File",
    'CBS'          => "Comodo Backup Script",
    'CXP'          => "CX-Programmer Project File",
    'CS'           => "ColorSchemer Studio Color Scheme",
    'CDO'          => "Crescendo Music Notation File",
    'COLZ'         => "Adobe Collage File",
    'CAFF'         => "Core Audio File",
    'COV'          => "Fax Cover Page File",
    'CPE'          => "Fax Cover Page File",
    'CDDX'         => "Circuit Diagram Document",
    'C32'          => "Syslinux COM32 Module",
    'CDLX'         => "Audition CD Layout File",
    'CINE'         => "Phantom Digital Video File",
    'CRV'          => "VCarve Pro Design File",
    'CVD'          => "Bitdefender Virus Definition File",
    'CNG'          => "CryptoNG Encrypted Archive",
    'CCIP'         => "Curse Client Install Package",
    'CWW'          => "Crossword Weaver Puzzle File",
    'CODASITE'     => "Coda Site File",
    'CLIPS'        => "Coda Clips File",
    'CODAPLUGIN'   => "Coda Plug-in",
    'CSKIN'        => "CD Art Display Skin File",
    'CIP'          => "Cavena Subtitles File",
    'COS'          => "Capture One Settings File",
    'COSTYLE'      => "Capture One Style File",
    'COPRESET'     => "Capture One Preset File",
    'CG3'          => "Cabri 3D Document",
    'CTPROJECT'    => "CrazyTalk Animator Project File",
    'CTP'          => "CrazyTalk Project File",
    'CTS'          => "CrazyTalk Script File",
    'CPD'          => "RoboHelp Cache Project Database",
    'CHR'          => "CryENGINE Character File",
    'CAF'          => "CryENGINE Character Animation File",
    'CDF'          => "CryENGINE Character Definition File",
    'CGA'          => "Crytek Geometry Animation File",
    'CHRPARAMS'    => "CryENGINE Character Parameters File",
    'CYP'          => "Home Designer Pro Project File",
    'CDW'          => "KOMPAS Document",
    'CAPX'         => "Construct Compressed Project File",
    'CAPROJ'       => "Construct Project File",
    'CBH'          => "ChessBase Database Header File",
    'CBV'          => "ChessBase Database File",
    'CBG'          => "ChessBase Game Moves File",
    'CBZ'          => "ChessBase Encrypted Database Archive",
    'CCP'          => "CodeCharge Studio Page File",
    'CCS'          => "CodeCharge Studio Project File",
    'CCH'          => ".NET Security Resolution Cache File",
    'CEF'          => "CenturionMail Encrypted Package",
    'CED'          => "JVC Camera Video Data File",
    'CW'           => "CardWorks Template",
    'CKP'          => "SQL Server Checkpoint File",
    'CKB'          => "Cricket Audio Bank File",
    'CLD'          => "ClamAV Virus Definitions File",
    'CNDX'         => "Avery DesignPro for Mac Label File",
    'CND'          => "Melco Condensed Embroidery File",
    'CAR'          => "Car Explorer Data File",
    'CRTR'         => "MultiAd Creator Pro Document",
    'CSX'          => "Visual C# Script",
    'CSP'          => "Caché Server Page",
    'CTX'          => "Valve ICE Encoded Script",
    'CWB'          => "Cakewalk Bundle",
    'CXF'          => "Picasa Collage File",
    'CXD'          => "SimplePCI Data Document",
    'CZD'          => "CAD Zone Drawing",
    'CZI'          => "Carl Zeiss Image Data File",
    'CL2ARC'       => "Comic Life 2 Document Archive",
    'C4P'          => "CrossOver Software Installer File",
    'CNM'          => "NoteMap Outline File",
    'CM10'         => "CaseMap 10 Case File",
    'CONFORM'      => "Conformalizer Change List File",
    'CDF-MS'       => "ClickOnce Compiled Manifest File",
    'CAPX'         => "Capella CapXML File",
    'CGRP'         => "Pro Tools Clip Group File",
    'CLARIFY'      => "Clarify Document",
    'CML'          => "CryptoMailer Encrypted File",
    'CONFIGPROFIL' => " 'Apple Configuration Profile",
    'CTXT'         => "BlueJ Context File",
    'CXARCHIVE'    => "CrossOver Bottle Archive",
    'CSO'          => "Compiled Shader Object File",
    'CVSRC'        => "CVS Command File",
    'CLP'          => "Finale Clip File",
    'CRYPT'        => "WhatsApp Encrypted Database File",
    'CBMAP'        => "Containment Breach Map File",
    'CDI'          => "INTEX Output File",
    'CCB'          => "CopperCube 3D Scene",
    'CIF'          => "Crystallographic Information File",
    'CWT'          => "Cakewalk SONAR Template",
    'COMPOSITIONT' => "M'PLATE   Invantive Composition Template",
    'COMPPKG.HAUP' => "W'ERK.RAR Hauptwerk Component Package",
    'CATDRAWING'   => "CATIA V5 Drawing",
    'CDS'          => "ConceptDraw SlideShow",
    'CXI'          => "FMAT RAW Image",
    'CXA'          => "FMAT Listmode File",
    'CXR'          => "FMAT Plate Results File",
    'CSF'          => "GeoMedia Coordinate System File",
    'CWS'          => "ChordWizard Song",
    'CWT'          => "ChordWizard Template",
    'CPAA'         => "Captivate Shared Action File",
    'CPS'          => "Captivate Styles File",
    'CPTM'         => "Captivate Theme File",
    'CALCA'        => "Calca Document",
    'CM5'          => "Clone Manager File",
    'CRYPT8'       => "WhatsApp Encrypted Database File",
    'COMICLIFE'    => "Comic Life Document",
    'CISO'         => "Compact ISO File",
    'CCLD'         => "Construction Clouds Data File",
    'CMR'          => "Coach Results File",
    'COMPILED'     => "Compiled Game Resource File",
    'CAJ'          => "Chinese Academic Journal File",
    'CPVC'         => "Adobe Captivate Video Composition",
    'COMP'         => "Fusion Composition File",
    'CMATE'        => "ControllerMate File",
    'CLIP'         => "Grand Theft Auto 5 Clip",
    'CUBE'         => "Gaussian Cube File",
    'CIRC'         => "Logisim Circuit File",
    'CRAM'         => "Compressed Alignment File",
    'CENON~'       => "Cenon Backup File",
    'CLKS'         => "Clicker Sentences File",
    'CLKD'         => "Clicker Docs File",
    'CLKB'         => "Clicker Books File",
    'CLKC'         => "Clicker Connect Set File",
    'CLKTK'        => "Clicker Talk Set File",
    'CLKM'         => "Clicker Matching Set File",
    'CLKV'         => "Clicker Communicator Vocabulary Set File",
    'CDML'         => "Creately Diagram File",
    'CONSIS'       => "Sciral Consistency Document",
    'COSESSIONDB'  => "Capture One Session File",
    'CERBER3'      => "Cerber Ransomware Virus File",
    'CFX'          => "Flow-Cal Data File",
    'CRYPT9'       => "WhatsApp Encrypted Database File",
    'CFA'          => "ComProbe Analyzer Capture File",
    'COLLAB'       => "Blackboard Collaborate Session File",
    'CERBER'       => "Cerber Ransomware Encrypted File",
    'CERBER2'      => "Cerber2 Ransomware Encrypted File",
    'CDOC'         => "Encrypted DigiDoc File",
    'CELL'         => "Thinkfree Office NEO Cell Workbook",
    'CID'          => "Navigator Chart Image Description File",
    'CFB'          => "Compound Binary File",
    'COURSE'       => "Super Mario ReMaker Course File",
    'CPDX'         => "Adobe Captivate Storyboard Project",
    'CEBX'         => "Apabi XML eBook File",
    'CRYPT'        => "CryptXXX Ransomware Encrypted File",
    'CR3'          => "Canon Raw 3 Image File",
    'CIF'          => "Easy CD Creator Disk Image",
    'CRW'          => "Canon Raw CIFF Image File",
    'CAL'          => "Calendar File",
    'CALS'         => "CALS Raster Graphic File",
    'CWS'          => "Claris Works Template",
    'CAG'          => "ClipArt Gallery Package",
    'CBT'          => "Computer Based Training File",
    'CLP'          => "Windows Clipboard File",
    'CMF'          => "Creative Music Format",
    'C02'          => "WinAce Split Archive Part 1 File",
    'CCX'          => "Click & Create Extension",
    'COX'          => "Click & Create Extension",
    'CVS'          => "Canvas 3 Drawing File",
    'CNV'          => "Canvas 6-8 Drawing File",
    'CNF'          => "Telnet Configuration File",
    'CRD'          => "Guitar Tabs",
    'CAL'          => "CALS Raster Graphic",
    'CEL'          => "MicroStation Cell Library",
    'CNC'          => "CNC Machine Tool Path",
    'CCR'          => "ASTM Continuity of Care Record",
    'CBG'          => "CyberGauge Data File",
    'CAT'          => "Advanced Disk Catalog Database",
    'C01'          => "Typhoon Wave Audio File",
    'CPT'          => "Compact Pro Archive",
    'CMM'          => "Corel Multimedia Manager Album",
    'CST'          => "ContentServ Template",
    'CVI'          => "CassiniVision Map Image File",
    'CEB'          => "Apabi eBook File",
    'CWF'          => "CorelDRAW Workspace File",
    'CTX'          => "Visual Basic Control Binary File",
    'CAP'          => "Construct Game Development File",
    'CGR'          => "Quest3D Channel Group File",
    'CMP'          => "Solid Edge Wire Harness File",
    'CDF'          => "Content Definition File",
    'CTF'          => "Content Transformation File",
    'COL'          => "Grand Theft Auto Collision File",
    'CLX'          => "Ceelox SecureMail Secure Message",
    'CHA'          => "Photoshop Channel Mixture",
    'CHA'          => "Character Layout File",
    'CWZ'          => "Circuit Wizard File",
    'CHT'          => "Emulator Cheat File",
    'CXT'          => "Director Protected Cast File",
    'CCT'          => "Director Protected Cast Resource",
    'CHK'          => "InterCheck Checksum Database",
    'CPD'          => "Compressed PhotoDefiner Image File",
    'CLIX'         => "CLIX Command File",
    'COLORPICKER'  => "Color Picker Plugin",
    'CGP'          => "PixelCryptor Encrypted File",
    'CB7'          => "Comic Book 7-Zip Archive",
    'CPG'          => "StarCraft Campaign File",
    'CPMZ'         => "Miradi/ConPro Project File",
    'CM'           => "CLEO Custom Mission",
    'CS'           => "CLEO Custom Script",
    'CDP'          => "CD/Spectrum Pro File",
    'CEL'          => "Battery 3 Drum Cell File",
    'CT'           => "Scitex Continuous Tone File",
    'CHML'         => "Chameleon Encrypted Database File",
    'CMBL'         => "Logger Pro Data File",
    'CK9'          => "Cook'n Cookbook Backup File",
    'CPX'          => "Corel CMX Compressed File",
    'CL2'          => "HY-TEK Meet Results File",
    'CBF'          => "ChessBase Game Information File",
    'CLB'          => "ICQ Contact List",
    'CL4'          => "Easy CD Creator 4 Project File",
    'CTM'          => "Star Wars Republic Commando Map File",
    'CPY'          => "eCopy Desktop File",
    'CFGE'         => "Jewel Quest Configuration File",
    'CDX'          => "CorelDRAW Compressed File",
    'COS2'         => "Pinnacle Studio Cache File",
    'COD'          => "Atlantis Word Processor Encrypted Document",
    'CFML'         => "ColdFusion Markup Language File",
    'CFR'          => "Cross Fire Replay File",
    'CVF'          => "CPU-Z Validation File",
    'CDF'          => "Nominal Small Business Accounting Company",
    'CUS'          => "AutoCAD Custom Dictionary File",
    'CDC'          => "AutoCAD DesignCenter Preview Cache File",
    'CIMG'         => "CImg Image File",
    'COLLECTION'   => "Adobe Bridge Collection File",
    'CAR'          => "Brew Component Application Resource File",
    'CRASHED'      => "AbiWord Crash-Saved Document",
    'CLR'          => "Vue Color Maps File",
    'CDL'          => "ConceptDraw PRO Library File",
    'CDT'          => "ConceptDraw PRO Template",
    'CDX'          => "ConceptDraw PRO XML Document",
    'CST'          => "Canvas Custom Set File",
    'CVT'          => "Canvas External Tool File",
    'CFG'          => "MAME Configuration File",
    'CON'          => "Battlefield 1942 Configuration File",
    'CTL'          => "StepMania SMZIP Package Description File",
    'CRS'          => "StepMania Course File",
    'CEDPRJ'       => "Ashampoo CoverEditor Project",
    'CPTL'         => "Adobe Captivate Project Template File",
    'CCSCC'        => "ClearCase Source Control Info File",
    'CDMP'         => "WCS Device Model Profile",
    'CCP'          => "RIB Import Converter Profile",
    'C4K'          => "Clonk Key File",
    'CDP'          => "ConceptDraw PROJECT File",
    'CDPX'         => "ConceptDraw PROJECT XML File",
    'CCA'          => "cc:Mail Archive File",
    'CAS'          => "Total War Model File",
    'CFG'          => "Wesnoth Markup Language File",
    'CIRCUIT'      => "KTechlab Circuit Design File",
    'CDT'          => "CD-Text File",
    'CPK'          => "CRI Middleware Package",
    'CPG'          => "Cool Page Project File",
    'CSF'          => "Cal3D Binary Skeleton File",
    'CFG'          => "LightWave Configuration File",
    'CL'           => "Cursor Library",
    'CI'           => "Windows Content Indexer Catalog File",
    'CYBERDUCKPRO' => "I'LE      Cyberduck Connection Profile",
    'CYBERDUCKLIC' => "N'SE      Cyberduck Donation Key",
    'CSPLAN'       => "SPSS Sampling Plan File",
    'CFG'          => "Celestia Configuration File",
    'CMS'          => "Connection Manager Service Profile",
    'CME'          => "Crazy Machines Experiment File",
    'CRYPTRA'      => "Cryptra Encrypted File",
    'CPB'          => "Comicino Studio Project File",
    'CHG'          => "Windows Net Logon File",
    'CCX'          => "Corel Clipart File",
    'CPR'          => "Adobe Captivate Preferences File",
    'CDM'          => "NTI CD-Maker Image",
    'CPF'          => "Cab Provisioning Format File",
    'CNS'          => "M.U.G.E.N. Character States File",
    'C10'          => "WinAce Split Archive Part 10",
    'CDF'          => "NetCDF Format File",
    'CSD'          => "Manga Studio Scene File",
    'CHK'          => "Netgear Router Firmware File",
    'CPS'          => "The Powder Toy Save File",
    'CMMTHEME'     => "CleanMyMac Theme File",
    'CAMV'         => "Camtasia Video File",
    'CDXML'        => "Cmdlet Definition XML File",
    'C3Z'          => "OpenQwaq 3D Model File",
    'CPQ'          => "Compaq OEM Disc Configuration File",
    'COL'          => "Capture One Session File",
    'CTBODYFITTIN' => " 'CrazyTalk Animator Actor Fitting File",
    'CBA'          => "CryENGINE Resource Compiler Settings File",
    'CAL'          => "CryENGINE Character Animation List",
    'CRYPTED'      => "WinOptimizer Encrypted File",
    'CEF'          => "Class Action Gradebook Elementary File",
    'CF2'          => "Common File Format File",
    'CFS'          => "Lucene Compound Index File",
    'CKF'          => "Casio Keyboard File",
    'CKBX'         => "Cricket Audio XML Bank Description File",
    'CMA'          => "TM1 Exported Cube File",
    'CMA'          => "OCaml Library",
    'CVW'          => "CaseView Document",
    'CXF'          => "Chemical Exchange Format File",
    'CXF'          => "Cuttlefish Extended Format File",
    'CX3'          => "CMS Recorded Video File",
    'CZP'          => "ClozePro Archive",
    'CL2DOC'       => "Comic Life 2 Document",
    'CL2TPL'       => "Comic Life 2 Template",
    'CL2LYT'       => "Comic Life 2 Layout File",
    'CALIBRE'      => "Calibre Device Data File",
    'CHUNK001'     => "File Splitter Split Archive Part 1",
    'CAWR'         => "Espresso workreport Document",
    'COR'          => "CorelDRAW Drawing",
    'COS'          => "Creatures CAOS File",
    'CAMM'         => "espresso Mind Map Document",
    'CADC'         => "Corpatla Data Container File",
    'CAA'          => "CleanApp Archive",
    'CIV5SAVE'     => "Civilization 5 Saved Game",
    'CLT'          => "VisualBoyAdvance Cheat List File",
    'CHC'          => "HCFR Colormeter Data File",
    'CPBITMAP'     => "iOS Wallpaper Image",
    'COFFEE'       => "CoffeeScript JavaScript File",
    'CDZ'          => "Compressed CD Image File",
    'CWT'          => "ClarisWorks Texture File",
    'CHART'        => "Guitar Rhythm Chart File",
    'CBC'          => "Comic Book Collection",
    'CTC'          => "Visual Studio Command Table Configuration",
    'CTO'          => "Visual Studio Binary Command Table Output",
    'CTSYM'        => "Visual Studio Command Table Output File",
    'CLK'          => "ClickView Video File",
    'CCBJS'        => "CopperCube JavaScript File",
    'CERTSIGNINGR' => "Q'UEST    Apple Developer Signing Certificate Request",
    'COLOURSCHEME' => "Speedy Browser Colour Scheme File",
    'CLI'          => "Grand Theft Auto Clip Data File",
    'CIV5MOD'      => "Civilization 5 Mod File",
    'CIV5MAP'      => "Civilization 5 Map",
    'CIB'          => "Luminaire Data File",
    'CAT4D'        => "Cinema 4D Catalog",
    'CBXML'        => "CodeBox Library",
    'CCS'          => "CCS Script File",
    'COMPOSITIONM' => "D'EL      Invantive Composition Data Model File",
    'CHKSPLIT'     => "Archiver Split Checksum File",
    'COMPPKG_HAUP' => "W'ERK_RAR Hauptwerk Component Package",
    'CAR'          => "Gary Gadget Car File",
    'CST'          => "Gary Gadget Plug-in",
    'CDTX'         => "ConceptDraw PRO XML Template",
    'CDSX'         => "ConceptDraw PRO XML SlideShow File",
    'CDLX'         => "ConceptDraw PRO XML Library File",
    'CXP'          => "FMAT Assay File",
    'CRYPT7'       => "WhatsApp Encrypted Database File",
    'CRYPT6'       => "WhatsApp Encrypted Database File",
    'CRYPT5'       => "WhatsApp Encrypted Database File",
    'CWD'          => "Nonogram Puzzle File",
    'CWY'          => "ChordWizard Style",
    'CBOARD'       => "Final Cut Pro Color Board Preset",
    'CX5'          => "Clone Manager XML File",
    'CMV'          => "CorelMOVE Animation",
    'CAP'          => "ASUS BIOS Update File",
    'CCC'          => "Dev-C++ Code Completion Cache",
    'CPHD'         => "CloudChan Pre-processed Hypertext Document",
    'C4'           => "JEDMICS Image File",
    'CSD'          => "Steam Game Data Backup File",
    'CSM'          => "Steam Game Backup File",
    'CUB'          => "Gaussian Cube File",
    'CENON'        => "Cenon Project",
    'CROP'         => "Crick Software Options File",
    'CLKP'         => "Clicker Object Palette File",
    'CLKBD'        => "Clicker Board Set",
    'CADOC'        => "Clicker App Document",
    'CMAKE'        => "CMake File",
    'CIV5SLN'      => "Civilization 5 Solution File",
    'CIA'          => "CTR Importable Archive",
    'CANNEDSEARCH' => "Apple Predefined Search",
    'COMIC'        => "Comic Life Comic",
    'CUSTOMDESTIN' => "T'IONS-MS Windows 7 Jump List File",
    'CETRAINER'    => "Cheat Engine Trainer File",
    'CMR'          => "U.S. Sectional Chart Map File",
    'CHAI'         => "Chaimera Artwork File",
    'CHAIT'        => "Chaimera Artwork Template",
    'CREC'         => "Lync Video File",
    'COVERAGE'     => "Visual Studio Code Coverage Report",
    'C3D'          => "C3D Model File",
    'CHR'          => "Doki Doki Literature Club! Character File",
    'CAA'          => "Chinese Academic Article Link File",
    'CTB'          => "Cherrytree SQLite Document",
    'CTX'          => "Cherrytree Password-protected SQLite Document",
    'CTD'          => "Cherrytree XML Document",
    'CTZ'          => "Cherrytree Password-protected XML Document",
    'CMO'          => "ASUS BIOS File",
    'CSG'          => "CounterSketch Design Project",
    'CMAP'         => "The Escapists Custom Prison Map File",
    'CMPKG'        => "craftersmine Package",
    'CDP'          => "Sony CD Architect Project",
    'CAM'          => "FastCAM CAM File",
    'CME'          => "Command Multimedia Evidence File",
    'CTF'          => "PSP Custom Theme File",
    'CDM'          => "Conceptual Data Model File",
    'CML'          => "OGC Web Map Context Document",
    'CAD'          => "Autodesk QuickCAD File",
    'CON'          => "COW System Settings File",
    'CALB'         => "Coolect Album File",
    'CAM'          => "CASIO Digital Camera Picture File",
    'CDF'          => "Channel Definition Format",
    'CE'           => "ComputerEyes Image",
    'CUT'          => "Dr. Halo Bitmap Image File",
    'CBK'          => "Backup Configuration File",
    'CAR'          => "CAR Archive",
    'CHG'          => "Quicken Online Data File",
    'CA'           => "Initial Telnet Cache",
    'CMS'          => "Content Management System",
    'CHR'          => "Borland Character Set File",
    'CM'           => "Cable Modem Configuration File",
    'CHN'          => "Ethnograph Data",
    'CVC'          => "cVideo",
    'CPT'          => "Pocket Slides Presentation",
    'CUE'          => "CDRWIN Cue Sheet",
    'C2D'          => "WinOnCD Disc Image",
    'CD'           => "CD-i OptImage",
    'CYS'          => "Clustify Summary File",
    'CSP'          => "Concept Server Page",
    'CCH'          => "Corel Chart File",
    'CMP'          => "Generic CADD Component File",
    'CYW'          => "Rbot.CYW Worm File",
    'CDR'          => "Crash Data Retrieval Data File",
    'CH3'          => "Harvard Graphics DOS Chart File",
    'CLM'          => "GenePattern CEL Descriptor File",
    'CPX'          => "Rise of Rome Campaign File",
    'COR'          => "Trimble Corrected SSF File",
    'CBS'          => "Code Breaker PS2 Save File",
    'CN1'          => "CNR Modem Initialization Data File",
    'CHEF'         => "Chef Source Code File",
    'CFS'          => "CFS Console File",
    'COMPRESSED'   => "WordCompress Compacted Web File",
    'CFXR'         => "Cocoa Sfxr File",
    'CI'           => "PolySpace Preprocessed Code File",
    'CASE'         => "SlipCover Case Template",
    'CML'          => "Crazy Machines Lab File",
    'COMFYCAKESSA' => "E'-MS     Comfy Cakes Saved Game",
    'CEM'          => "Children of the Nile Model File",
    'CF'           => "Sendmail Configuration File",
    'CMF'          => "Connected Backup File",
    'CHS'          => "Windows Chinese Noise-Word List File",
    'CHT'          => "Windows Chinese Traditional Noise-Word List",
    'CMD'          => "M.U.G.E.N. Character Commands File",
    'CHESSTITANSS' => "V'E-MS    Microsoft Chess Titans Saved Game",
    'CHAM'         => "Compiled HAM File",
    'CRAFT'        => "KSP Spacecraft File",
    'CXT'          => "CX-Programmer Project Text File",
    'CHV'          => "ChView Interactive Star Map File",
    'CEL'          => "FLIC Animation",
    'CXF'          => "Coordinates Export Format",
    'CRYSISJMSF'   => "Crysis Saved Game",
    'CRYSISPSF'    => "Crysis Warhead Saved Game",
    'CSL'          => "CineStyle Color Lookup File",
    'CFF'          => "Common File Format",
    'CONTROLS'     => "OpenBVE Keyboard Shortcuts File",
    'C2U'          => "Texas Instruments CBL 2 OS File",
    'CACTION'      => "Automator Converter Action",
    'CPR'          => "CPC Plus Cartridge",
    'CSUTIL'       => "ColorSync Utility Folder",
    'CDX'          => "Alpha Five Table Index File",
    'CHR0'         => "Wii Model Animation File",
    'CLR0'         => "Wii Color Swapping Animation File",
    'CPU'          => "Virtual CPU File",
    'CAMERROR'     => "Camtasia Studio Error File",
    'CV'           => "CodeView Data File",
    'CIS'          => "CheckInbox Settings File",
    'CS1'          => "CaptureShop 1-shot Raw Image",
    'CM0013'       => "Samsung Smart TV Index File",
    'CLP'          => "Clipper Compiler Instructions File",
    'CPN'          => "Grim Dawn Default Character File",
    'DAT'          => "Data File",
    'DB'           => "Database File",
    'DLL'          => "Dynamic Link Library",
    'DMG'          => "Mac OS X Disk Image",
    'DOC'          => "Microsoft Word Document",
    'DRV'          => "Device Driver",
    'DNG'          => "Digital Negative Image File",
    'DWG'          => "AutoCAD Drawing Database File",
    'DXF'          => "Drawing Exchange Format File",
    'DBF'          => "Database File",
    'DEM'          => "Video Game Demo File",
    'DDS'          => "DirectDraw Surface",
    'DTD'          => "Document Type Definition File",
    'DMP'          => "Windows Memory Dump",
    'DOCX'         => "Microsoft Word Open XML Document",
    'DEB'          => "Debian Software Package",
    'DCR'          => "Shockwave Media File",
    'DESKTHEMEPAC' => " 'Windows 8 Desktop Theme Pack File",
    'DBX'          => "Outlook Express E-mail Folder",
    'DSS'          => "Digital Speech Standard File",
    'DOT'          => "Word Document Template",
    'DIB'          => "Device Independent Bitmap File",
    'DRW'          => "Drawing File",
    'DPX'          => "Digital Picture Exchange File",
    'DWT'          => "Dreamweaver Web Page Template",
    'DVR-MS'       => "Microsoft Digital Video Recording",
    'DGN'          => "MicroStation Design File",
    'DIVX'         => "DivX-Encoded Movie File",
    'DCM'          => "DICOM Image",
    'DCF'          => "DRM Content Format File",
    'DPR'          => "Delphi Project",
    'DIF'          => "Data Interchange Format",
    'DB'           => "Windows Thumbnail Cache",
    'DOTX'         => "Word Open XML Document Template",
    'DAT'          => "Exchange E-mail Attachment",
    'DAE'          => "Digital Asset Exchange File",
    'DBB'          => "Skype User Information File",
    'DWF'          => "Design Web Format File",
    'DEX'          => "Dalvik Executable File",
    'DT1'          => "DTED Level 1 File",
    'DT2'          => "Windows Live Messenger Emoticon Image File",
    'DREAM'        => "Dream Animated Wallpaper File",
    'DSN'          => "Database Source Name File",
    'DBA'          => "Palm Datebook Backup File",
    'DBK'          => "Sony Ericsson Mobile Phone Backup File",
    'DMSM'         => "VideoWave Movie Project File",
    'DMSP'         => "PhotoSuite Project File",
    'DMSE'         => "Sound Editor Project File",
    'DMSA'         => "Music Disc Creator Project File",
    'DVDMEDIA'     => "RipIt DVD Package",
    'DAT'          => "Minecraft Data File",
    'DXE'          => "AutoCAD Data Extraction Template",
    'DST'          => "AutoCAD Sheet Set File",
    'DCP'          => "Adobe DNG Camera Profile",
    'DZM'          => "DirectorZone Menu Template",
    'DZP'          => "DirectorZone Particle Effect File",
    'DMGPART'      => "Mac OS X Disk Image Part",
    'DEK'          => "Magic: The Gathering Deck File",
    'DLX'          => "DIALux Document",
    'DISC'         => "Toast Document",
    'DRA'          => "OrCAD Drawing File",
    'DTX'          => "Documented LaTeX File",
    'DCPROJ'       => "Dashcode Project",
    'DAZ'          => "DAZ Studio 3D Scene",
    'DSF'          => "DAZ Studio Asset File",
    'DPROJ'        => "Delphi Project",
    'DSB'          => "Wondershare DVD Slideshow Builder Project",
    'DWD'          => "DavkaWriter File",
    'DASH'         => "MPEG-DASH Video File",
    'DUF'          => "DAZ User File",
    'DB.CRYPT8'    => "WhatsApp Encrypted Database File",
    'DB.CRYPT12'   => "WhatsApp Encrypted Database File",
    'DSK'          => "Disk Image",
    'DV'           => "Digital Video File",
    'DIC'          => "Dictionary File",
    'DFONT'        => "Mac OS X Data Fork Font",
    'DXB'          => "Drawing Exchange Binary",
    'DCR'          => "Kodak RAW Image File",
    'DIR'          => "Adobe Director Movie",
    'DXR'          => "Protected Macromedia Director Movie",
    'DBT'          => "Database Text File",
    'DCS'          => "Desktop Color Separation File",
    'DLG'          => "Digital Line Graph",
    'DMS'          => "Disk Masher Image",
    'DVI'          => "Device Independent Format File",
    'DO'           => "Java Servlet",
    'DJVU'         => "DjVu Image",
    'DIZ'          => "Description in Zip File",
    'DST'          => "Tajima Embroidery Format",
    'DSP'          => "Visual C++ 6 Project",
    'DSW'          => "Visual C++ 6 Workspace File",
    'DSC'          => "Nikon Disk Identification File",
    'DOWNLOAD'     => "Partially Downloaded File",
    'DAA'          => "PowerISO Direct-Access-Archive",
    'DVF'          => "Sony Digital Voice File",
    'DCE'          => "DriveCam Video File",
    'DESKLINK'     => "Desktop Shortcut",
    'DBC'          => "FoxPro Database",
    'DBF'          => "FoxPro Table",
    'DBG'          => "Visual FoxPro Debugger Configuration File",
    'DCX'          => "FoxPro Database Index",
    'DNE'          => "Netica Text File",
    'DFT'          => "Solid Edge Draft Document",
    'DCT'          => "Dictionary File",
    'DCX'          => "FAXserve Fax Document",
    'DCTMP'        => "DC++ Partially Downloaded File",
    'DII'          => "Summation Batch Load File",
    'DEF'          => "Module-Definition File",
    'DOC'          => "WordPad Document",
    'DM'           => "DRM Delivery Message",
    'DR'           => "DRM Rights Object",
    'DRC'          => "DRM Rights Object",
    'DCU'          => "Delphi Compiled Unit",
    'DFM'          => "Delphi Form",
    'DCP'          => "Delphi Compiled Package",
    'DPK'          => "Delphi Package",
    'DPL'          => "Delphi Package Library",
    'D64'          => "Commodore 64 Disk Image",
    'DCM'          => "DCM Audio Module",
    'DEWF'         => "SoundEdit Recorded Instrument",
    'DF2'          => "Defractor 2 Instrument",
    'DFC'          => "Defractor Instrument",
    'DIG'          => "Digilink Audio File",
    'DIG'          => "Sound Designer Audio File",
    'DLS'          => "Downloadable Sounds File",
    'DMF'          => "Delusion Digital Music File",
    'DSF'          => "Delusion Digital Sound File",
    'DSM'          => "Digital Sound Module",
    'DTM'          => "DigiTrakker Module",
    'DWD'          => "DiamondWare Digital Audio File",
    'DCT'          => "Dictation Audio File",
    'DOCM'         => "Word Open XML Macro-Enabled Document",
    'DOTM'         => "Word Open XML Macro-Enabled Document Template",
    'DAR'          => "DAR Disk Archive",
    'DGC'          => "DGCA File Archive",
    'DIST'         => "Mac OS X Distribution Script",
    'DOB'          => "Visual Basic UserDocument",
    'DOX'          => "Visual Basic Binary UserDocument",
    'DS_STORE'     => "Mac OS X Folder Settings File",
    'DC4'          => "ViaThinkSoft (De)Coder 4 File",
    'DRW'          => "DESIGNER Drawing",
    'DF1'          => "Omnis Native Datafile",
    'DP1'          => "DataPower Database File",
    'DPD'          => "Ovation Pro File",
    'DES'          => "Corel Designer File",
    'D2V'          => "DVD2AVI File",
    'DEC'          => "Declaration File",
    'DHTML'        => "Dynamic HTML file",
    'DAT'          => "VCD Video File",
    'DPG'          => "Nintendo DS Movie File",
    'DGB'          => "FlashCAD Drawing Database",
    'DRM'          => "Cubase Drum Map File",
    'DBV'          => "Database Variable Field",
    'DOWNLOADHOST' => "MSN Download Settings File",
    'DDC'          => "DivX Descriptor File",
    'DISKDEFINES'  => "Linux LiveCD Information File",
    'DDCX'         => "DivX Descriptor 2 File",
    'DISCO'        => "DISCO Discovery Document",
    'DISCOMAP'     => "DISCO Discovery Output File",
    'DAM'          => "DeltaMaster Analysis Model",
    'DAS'          => "DeltaMaster Analysis Session",
    'DVD'          => "CloneCD DVD Information File",
    'DM2'          => "Toad Data Modeler 2 File",
    'DM2'          => "Quake 2 Demo File",
    'D'            => "D Source Code File",
    'DPR'          => "Digital InterPlot File",
    'DPP'          => "DrawPlus Drawing File",
    'DLL'          => "DLL Dynamic Web Page",
    'DESKTOP'      => "Desktop Entry File",
    'DFP'          => "Fusion Plugin File",
    'D3V'          => "Datel Video File",
    'DOL'          => "GameCube Executable File",
    'DM_84'        => "Wolfenstein 2.06 Demo Movie File",
    'DTP'          => "Publish-iT Document",
    'DVX'          => "DivX Video File",
    'DAP'          => "Access Data Access Page",
    'DVL'          => "Dalim Virtual Library File",
    'DC'           => "DesignCAD Design File",
    'DCD'          => "DesignCAD Drawing",
    'DSY'          => "Directory Synchronizer Project File",
    'DSZ'          => "Orchida (OES) Embroidery File",
    'DVDPROJ'      => "iDVD Project File",
    'DISK'         => "Linux Virtual Hard Disk",
    'DWI'          => "Dance With Intensity Song File",
    'DLM'          => "Akamai Download Manager File",
    'DFF'          => "RenderWare Model File",
    'DAX'          => "PSP Compressed ISO Disc Image",
    'DAP'          => "Download Accelerator Plus Partial Download",
    'DOCKZIP'      => "ObjectDock File",
    'DLD'          => "EdLog Compiled Program",
    'DTS'          => "DTS Encoded Audio File",
    'DAL'          => "Download Accelerator Plus URL List",
    'DAL'          => "DVD-lab Project File",
    'DM_82'        => "Wolfenstein 1.00 Demo Movie File",
    'DM_83'        => "Wolfenstein 1.02 Demo Movie File",
    'DSTUDIO'      => "DownloadStudio Incomplete Download",
    'DOLPHINVIEW'  => "Dolphin Folder View Settings File",
    'DIRECTORY'    => "KDE Folder View Properties File",
    'DRWDOT'       => "SolidWorks Drawing Template",
    'DFX'          => "Drafix CAD File",
    'DCM'          => "DiskCatalogMaker Catalog File",
    'DCMD'         => "DiskCatalogMaker Thumbnail-Enabled Catalog",
    'DBD'          => "DemoShield Project",
    'DCF'          => "Safetica Free Encrypted Archive",
    'DCO'          => "Safetica Free Encrypted Virtual Disk Archive",
    'DRL'          => "Gerber Drill Rack File",
    'DESIGN'       => "Microsoft Expression Design Drawing",
    'DLC'          => "Download Link Container File",
    'DPM'          => "Pro Tools Plugin File",
    'DFPROJ'       => "DVD Flick Project",
    'DCD'          => "DisCryptor Encrypted Database",
    'DPN'          => "Depiction Data File",
    'DFM'          => "Midas ViewPoint Display Form",
    'DTR'          => "DATroniC Data Recording",
    'DTW'          => "Desktop Wallpaper",
    'DCF'          => "Document Computation Format",
    'DWFX'         => "Design Web Format XPS File",
    'DBO'          => "DarkBASIC Object",
    'DT2'          => "DTED Level 2 File",
    'DT0'          => "DTED Level 0 File",
    'DNA'          => "CA Backup and Migration Backup File",
    'DTSHD'        => "DTS-HD Master Audio File",
    'DNL'          => "DNAML eBook File",
    'DCK'          => "Resolume Deck File",
    'DL'           => "Zoo Tycoon 2 Data File",
    'DDF'          => "Diamond Directive File",
    'DDT'          => "Football Manager Keep Player Data File",
    'DB3'          => "SQLite Database File",
    'DVO'          => "Cook'n Cookbook File",
    'DMSS'         => "VideoWave SlideShow Project File",
    'DLV'          => "CATIA 4 Export File",
    'DXP'          => "CDBurnerXP Data Compilation File",
    'DRG'          => "I-Doser Audio Drug File",
    'DGK'          => "Delcam 3D Model File",
    'DCOVER'       => "Disc Cover File",
    'DMC'          => "Datamartist Data Canvas File",
    'DWLIBRARY'    => "Paperless Document Library",
    'DBPROJ'       => "Visual Studio Database Project File",
    'DBML'         => "Visual Studio OR Design File",
    'DV-AVI'       => "Microsoft DV-AVI Video File",
    'DAZIP'        => "Dragon Age: Origins Game File",
    'DLU'          => "3ds Max Utility Plug-in File",
    'DBX'          => "AutoCAD Database Extension File",
    'DSD'          => "AutoCAD Drawing Set Description File",
    'DWS'          => "AutoCAD Drawing Standards File",
    'DCL'          => "AutoCAD Dialog Definition File",
    'DWT'          => "AutoCAD Drawing Template",
    'DXX'          => "AutoCAD Drawing Interchange Attribute File",
    'DCPR'         => "Adobe DNG Camera Profile Recipe File",
    'DWS'          => "Adobe Dreamweaver Site Cache File",
    'DCST'         => "Adobe InDesign Document Presets File",
    'DZT'          => "DirectorZone Title File",
    'DIF'          => "MAME CHD Diff File",
    'DIF'          => "Torque Game Engine Model File",
    'DIV'          => "DIVA-GIS Project File",
    'DIX'          => "DIVA-GIS Export File",
    'DIAGCAB'      => "Troubleshooting Pack Cabinet File",
    'DVDS'         => "DVDStyler Project File",
    'DC2'          => "DesignCAD 2D ASCII Drawing",
    'DC3'          => "DesignCAD 3D ASCII Drawing",
    'DMO'          => "Duke Nukem 3D Demo File",
    'DV2'          => "Divinity 2 Data File",
    'DIA'          => "Dia Diagram File",
    'DER'          => "DER Certificate File",
    'DEK'          => "Yugioh Virtual Desktop Deck File",
    'DEK'          => "LackeyCCG Card Deck File",
    'DBS'          => "SQLBase Database File",
    'DRA'          => "Nuance Dragon Voice Recording File",
    'DAT'          => "Windows Registry Hive File",
    'DSGM'         => "DS Game Maker Project",
    'DBR'          => "DeepBurner Disc Project",
    'DCMF'         => "DiskCatalogMaker Catalog",
    'DL_'          => "Compressed DLL File",
    'DTAPART'      => "DownThemAll! Partially Downloaded File",
    'DTSX'         => "DTS Settings File",
    'DIT'          => "Active Directory Information Tree File",
    'DXL'          => "Domino XML Language File",
    'DRA'          => "Dolphin PartMaster Drawing File",
    'DRF'          => "VIZ Render File",
    'DITA'         => "DITA Document",
    'DITAMAP'      => "DITA Topic Map File",
    'DITAVAL'      => "DITA Conditions File",
    'DNF'          => "Duke Nukem Forever Map File",
    'DNS'          => "Duke Nukem Forever Save File",
    'DPA'          => "DrawPlus Animation File",
    'DUCK'         => "Cyberduck Bookmark",
    'DVR'          => "Microsoft Recorded TV Show",
    'DCB'          => "Concordance Database File",
    'DBA'          => "DarkBASIC Source Code File",
    'DBPRO'        => "DarkBASIC Professional Project File",
    'DB'           => "Mobile Device Database File",
    'DMSD'         => "Roxio MyDVD Project",
    'DMSD3D'       => "Roxio MyDVD 3D Project",
    'DPS'          => "Kingsoft Presentation File",
    'DSN'          => "OrCAD Design File",
    'DS2'          => "Olympus DSS Pro Audio File",
    'DASCHEMA'     => "RemObjects Data Abstract Schema File",
    'DACONNECTION' => " 'RemObjects Data Abstract Connections File",
    'DUC'          => "Action Replay Max DS Save File",
    'DMM'          => "iMindQ Mind Map File",
    'DMMX'         => "iMindQ XML Map Bundle",
    'DSB'          => "Dell DataSafe Backup File",
    'DS'           => "DAZ Studio 1/2 Script",
    'DSA'          => "DAZ Studio 3+ Script",
    'DSB'          => "DAZ Studio Binary Script",
    'DSI'          => "DAZ Studio Layered Image Set",
    'DACPAC'       => "SQL Server Data Tier Application Package",
    'DCR'          => "Digital Court Recorder Video File",
    'DCR'          => "Liberty Video Recording File",
    'DM3'          => "DigitalMicrograph Image",
    'DCUIL'        => "Delphi .NET Compiled Unit File",
    'DPKW'         => "Delphi Package",
    'DNA'          => "SnapGene DNA File",
    'DPB'          => "DataPilot Backup File",
    'DMR'          => "BrainVoyager Diffusion Weighted Project File",
    'DMX'          => "Source Filmmaker Project File",
    'DBA'          => "CryENGINE Animation Database File",
    'DWDOC'        => "DrawWell Document",
    'DMPR'         => "Direct Mail Project File",
    'DEPROJ'       => "Disketch Project File",
    'DMC'          => "Mimic Configuration File",
    'DVC'          => "Dragon Voice Command File",
    'DB1'          => "Tekla Structures Model File",
    'DDL'          => "Data Definition Language File",
    'DHS'          => "HyperSnap Drawing",
    'DRPM'         => "Delta RPM File",
    'DGML'         => "Visual Studio Directed Graph Document",
    'DGSL'         => "Visual Shader Graph File",
    'DRAWING'      => "Artboard Drawing",
    'DM1'          => "ER/Studio Data Model File",
    'DMD'          => "SQL Developer Data Modeler File",
    'DMT'          => "DeLorme Transfer File",
    'DMI'          => "BYOND Dream Maker Icon File",
    'DMB'          => "BYOND Game Executable",
    'DOWNLOADING'  => "Pando Incomplete Download File",
    'DUN'          => "Dungeon Defenders Saved Game File",
    'DAT_NEW'      => "Minecraft World Level File",
    'DASH'         => "Dashlane Profile",
    'DRMZ'         => "Drumlin Fully Secure Mobile PDF File",
    'DEVICEIDS'    => "Device Identification FIle",
    'DEVICEINFO'   => "Device Record",
    'DSC'          => "Debian Source Control File",
    'DICT'         => "Dictionary File",
    'DLT'          => "DELTA Binary Dataset File",
    'DLR'          => "finalRender Plugin",
    'DIFF'         => "Patch File",
    'DVTCOLORTHEM' => " 'Xcode Color Theme File",
    'DSL'          => "Lingvo Dictionary File",
    'DAT'          => "Porteus Save Container File",
    'DEFT'         => "Juice Grinder Defaults File",
    'DB'           => "Skype Chat History File",
    'DSG'          => "Doom Saved Game",
    'DIM'          => "Active@ Raw Disk Image Backup File",
    'DUPEGURU'     => "dupeGuru Duplicate File List",
    'DOK'          => "DesktopOK Icons Layout File",
    'DTSCONFIG'    => "SSIS Package Configuration File",
    'DART'         => "Dart Source Code File",
    'DAR'          => "DVD Architect Project",
    'DLIS'         => "DLIS Well Log Data File",
    'DIAGSESSION'  => "Diagnostics Session File",
    'DLTEMP'       => "UC Browser Temporary Download File",
    'DDOC'         => "DigiDoc Signature File",
    'DR5'          => "Dramatica Story Expert Project",
    'DSF'          => "Dramatica Pro Project",
    'DE'           => "DrawExpress Diagram File",
    'DVB'          => "AutoCAD VBA Project File",
    'DWS'          => "Dyalog Workspace File",
    'DIP'          => "DipTrace Printed Circuit Board File",
    'DEC'          => "Magic: The Gathering Online Deck File",
    'DWN'          => "Firmware Update File",
    'DSK'          => "Borland Project Desktop File",
    'DBK'          => "dBASE Database Backup",
    'DIM'          => "DIME File",
    'DIME'         => "Direct Internet Message Encapsulation File",
    'DD'           => "DiskDoubler Archive",
    'DEK'          => "Memorize-It Flashcard Deck",
    'DSS'          => "DCC Active Designer File",
    'DEV'          => "Windows Device Driver File",
    'DEX'          => "DEXIS Digital X-ray File",
    'DES'          => "Pro/DESKTOP CAD File",
    'DA0'          => "Windows Registry Backup File",
    'DLO'          => "3ds Max Plug-in",
    'DQY'          => "Excel Query File",
    'DXS'          => "Deus Ex Saved Game",
    'DYLIB'        => "Mach-O Dynamic Library",
    'DMO'          => "Derive Demo",
    'DSK'          => "Simple IDs Database",
    'DCT'          => "FoxPro Database Memo",
    'DMS'          => "Dream Maker Script",
    'DDRW'         => "ClarisDraw Drawing",
    'DEF'          => "SmartWare II Data File",
    'DIF'          => "Digital Interface Format",
    'DAO'          => "Disk at Once CD/DVD Image",
    'DEM'          => "Digital Elevation Model",
    'DEV'          => "Dev-C++ Project File",
    'DES'          => "QuickBooks Forms Template",
    'DBM'          => "ColdFusion Server File",
    'DCL'          => "DumpSec Report File",
    'DGS'          => "Dagesh Pro Document",
    'DMB'          => "Digital Multimedia Broadcasting File",
    'DAF'          => "Digital Anchor File",
    'D88'          => "Toshiba Pasopia 7 Disk File",
    'DWC'          => "Emulex DWC Firmware Update File",
    'DSB'          => "Orchida Embroidery File",
    'DMO'          => "Movienizer Database File",
    'DB'           => "X-Ray Engine Database",
    'DSYM'         => "Xcode Debug Symbols File",
    'DSKIN'        => "DockX Skin",
    'DAV'          => "DVR365 Video File",
    'DSD'          => "Diet Studio Data File",
    'DML'          => "DynaScript File",
    'DSV'          => "DeSmuME Save File",
    'DPX'          => "VASCO DIGIPASS File",
    'DDAT'         => "DivX Temporary Video File",
    'DINFO'        => "DivX Temporary Video Info File",
    'DMSK'         => "DivX Temporary Video Data File",
    'DICPROOF'     => "Microsoft Dictionary Proofing File",
    'DCX'          => "Zsoft Multi-Page Paintbrush File",
    'DNC'          => "Windows Dancer File",
    'DATA'         => "Analysis Studio Offline Data File",
    'DDT'          => "Diagram Designer Template",
    'DJV'          => "DjVu Image",
    'DOX'          => "Doxygen Documentation File",
    'DWP'          => "DarkWave Studio Project File",
    'DWZ'          => "DVD MovieFactory Project File",
    'DJM'          => "Dynojet Map File",
    'DTD'          => "Design Tools Draw File",
    'DSF'          => "Designer File",
    'DTF'          => "Domino Temporary File",
    'DRG'          => "AllyCAD Drawing File",
    'DED'          => "Dr. Engrave Document",
    'DLX'          => "Sony VDU Video File",
    'DWL'          => "TurboCAD Drawing Lock File",
    'DV4'          => "Bosch Security Systems CCTV Video File",
    'DMF'          => "Geosystem Digitals Map File",
    'DCT'          => "AutoCAD Dictionary File",
    'DGS'          => "3D Screen Creator Scene File",
    'DSX'          => "Diet Studio XML File",
    'DAT'          => "SimCity 4 Game Data File",
    'DSG'          => "Control Studio Document",
    'DA2'          => "DeepAnalysis Save File",
    'DA2'          => "Ad-Aware License File",
    'DMSM3D'       => "VideoWave 3D Movie Project File",
    'DCPF'         => "Disc Copier Project File",
    'D3D'          => "Game Maker 3D File",
    'DIAGCFG'      => "Troubleshooting Pack Configuration File",
    'DIAGPKG'      => "Troubleshooting Pack File",
    'DS'           => "LMMS DrumSynth File",
    'DC2'          => "Kodak Photo-Enhancer File",
    'DMO'          => "Cube 2: Sauerbraten Demo File",
    'DBGSYM'       => "Debug Symbols File",
    'DIA'          => "Do It Again Task File",
    'DDT'          => "Age of Mythology Textures File",
    'DBS'          => "GAMBIT Mesh File",
    'DEP'          => "Windows Dependency File",
    'DHCD'         => "DHCD Computing Application Data File",
    'DSI'          => "Double-Precision Spectral Image",
    'DIS'          => "Oracle Discoverer Workbook",
    'DXL'          => "Rational DOORS Script",
    'DXLS'         => "DashXL Skin Set File",
    'DICOM'        => "DICOM Image File",
    'DZ'           => "Dzip File",
    'DZIP'         => "The Witcher 2 Game Archive",
    'DRF'          => "Dynojet Run File",
    'DPX'          => "DrawPlus Template",
    'DRAWIT'       => "DrawIt Drawing",
    'DSC'          => "Celestia Deep Space Catalog File",
    'DAM'          => "DAME Project",
    'DAP'          => "Diet Analysis Profile",
    'D00'          => "VirtualDrive Disc Image Part File",
    'D01'          => "VirtualDrive Disc Image Part 2 File",
    'DPB'          => "DVD Profiler Backup File",
    'DDB'          => "Digidesign Database",
    'DDB'          => "Command & Conquer: Renegade Data File",
    'DC1'          => "DevCad Document",
    'DC2'          => "DevCad Cam Pro Document",
    'DBQ'          => "AutoCAD Query Set",
    'DFK'          => "Dark Flow Project File",
    'DPT'          => "Kingsoft Presentation Template",
    'DDD'          => "GLBasic 3D Data File",
    'DB'           => "QQ Account Database File",
    'DESC'         => "Battlefield 2 Map Description File",
    'DABRIEFCASE'  => "RemObjects Data Abstract File Briefcase",
    'DACONFIG'     => "RemObjects Data Abstract Configuration File",
    'DADIAGRAMS'   => "RemObjects Data Abstract Data Diagrams File",
    'DAD'          => "RemObjects Data Abstract Driver File",
    'DNA'          => "GenePool DNA File",
    'D3DBSP'       => "Call of Duty Map File",
    'DSE'          => "DAZ Studio Encrypted Script",
    'DSX'          => "DAZ Studio XML File",
    'DSO'          => "DAZ Studio Object File",
    'DSD'          => "DAZ Studio Object Morph File",
    'DSV'          => "DAZ Studio UV Mapping File",
    'DBM'          => "DAZ Brick Material File",
    'DBC'          => "DAZ Brick Camera File",
    'DBL'          => "DAZ Brick Light File",
    'DMX-INFO'     => "DriverMax Driver Information File",
    'DISABLED'     => "Spybot - Search & Destroy Disabled File",
    'DUN'          => "Dial Up Network File",
    'DM3'          => "Quake 3 Demo File",
    'DM_68'        => "Quake 3 Demo File",
    'DRES'         => "Delphi Compiled Resource File",
    'DPV'          => "Siemens NX Drafting Standard File",
    'DJR'          => "Ringtone Media Studio DJ Ringtone Project",
    'DFU'          => "iOS DFU File",
    'DIVA'         => "Project DIVA Song File",
    'DRSCAN'       => "Data Rescue Scans File",
    'D2S'          => "Diablo 2 Save File",
    'DAT_OLD'      => "Minecraft Level.dat Backup File",
    'DRZ'          => "PyDrizzle Data File",
    'DOC#'         => "LibreOffice Document Lock File",
    'DS'           => "Furcadia DragonSpeak File",
    'DRM'          => "Deus Ex Data File",
    'DB-SHM'       => "SQLite Database Shared Memory File",
    'DB-WAL'       => "SQLite Database Write-Ahead Log File",
    'DEX'          => "Disketch Project File",
    'DFG'          => "Data Flask Grid File",
    'DAT'          => "Inno Setup Uninstaller Data File",
    'DXP'          => "Dexpot Profile File",
    'DMC'          => "DPCM Sample File",
    'DDP'          => "Delphi Diagram Portfolio File",
    'DFS'          => "BrainSuite Surface File",
    'DGT'          => "DST Thumbnail File",
    'DEVELOPERPRO' => "I'LE  Xcode Developer Profile",
    'DAT_MCR'      => "Minecraft Level.dat Backup File",
    'DECRYPT'      => "Decrypted Microsoft ESD File",
    'DKT'          => "DiGiTIAL THUNDER Drum Kit File",
    'DT'           => "Drum Station Machine State File",
    'DET'          => "Sage ACT! 5 Email Message",
    'DOCSET'       => "Doxygen Document Set File",
    'DPF'          => "Dargon Package",
    'DEVELVE'      => "Develve Data File",
    'DFF'          => "DSD Audio File",
    'DRMX'         => "Drumlin Fully Secure PDF File",
    'DW'           => "David Whittaker Audio File",
    'DEFS'         => "BlueJ Settings File",
    'DRU'          => "EAGLE Design Rules File",
    'DDX'          => "Alpha Five Data Dictionary Index File",
    'DDD'          => "Alpha Five Data Dictionary File",
    'DDM'          => "Alpha Five Data Dictionary Memo File",
    'DTL'          => "Now Contact Detail Template",
    'DB.JOU'       => "Patran Journal File",
    'DLC'          => "DIALux Light Control File",
    'D$$'          => "AGT Game Encrypted Message File",
    'DA1'          => "AGT Game Data File",
    'DA3'          => "AGT Game Data File",
    'DA4'          => "AGT Game Data File",
    'DA5'          => "AGT Game Data File",
    'DXB'          => "Duxbury Braille File",
    'DXP'          => "Duxbury Print File",
    'DLG'          => "Dialogue File",
    'D3MD'         => "DART Metadata File",
    'DVTPLUGIN'    => "Xcode DVT Plug-in",
    'DROPBOX'      => "Dropbox Shared Folder Tracker",
    'DDE'          => "Lingvo Dictionary Error Log File",
    'DAT'          => "Piriform DAT File",
    'DAT'          => "Piriform Key File",
    'DCR'          => "Delphi Component Resource File",
    'DNG'          => "Virtual Dongle Image",
    'DFT'          => "eJuice Me Up Default Settings File",
    'DWL2'         => "AutoCAD Drawing Lock File",
    'DEMO'         => "Pokémon Type Wild Data File",
    'DSPL'         => "Modern Warfare 3 Dedicated Server Playlist",
    'DSR'          => "Modern Warfare 3 Dedicated Server Recipe File",
    'DEOS'         => "Driver Easy Offline Scan File",
    'DSC'          => "Kingsoft Design Science Equation File",
    'DST'          => "DeSmuME Save State",
    'DCT'          => "DeSmuME ROM Cheats File",
    'DFC'          => "DeSmuME Firmware Configuration File",
    'DIC'          => "DICOM Image",
    'DTM'          => "Dolphin TAS Movie",
    'DEVICEMETADA' => "A'-MS Device Metadata Package",
    'DSS'          => "DiskStation Backup Configuration File",
    'DONE'         => "Marker File",
    'DJA'          => "Dundjinni Module File",
    'DSET'         => "Kratos Dataset File",
    'DB-JOURNAL'   => "SQLite Rollback Journal File",
    'DAD'          => "IMS200 Video Record File",
    'DRA'          => "Scriptor Script File",
    'D'            => "Source Dependency File",
    'DRW'          => "ANVIL Drawing File",
    'DTP'          => "dotTrace Profile File",
    'DBX'          => "Dropbox Encrypted Database File",
    'DB.CRYPT'     => "WhatsApp Encrypted Database File",
    'DSG'          => "Stitch Era Design File",
    'DB2'          => "dBASE II Database",
    'DEK'          => "Eavesdropper Batch File",
    'DVD'          => "DOS Device Driver",
    'DOV'          => "Temp File",
    'DDB'          => "Device Dependent Bitmap",
    'DGC'          => "TurboTax Tax Form",
    'D00'          => "OPL2 FM Audio File",
    'D01'          => "OPL2 FM Audio File",
    'DPB'          => "FaxMaster Document",
    'DT_'          => "Macintosh Data Fork",
    'DC1'          => "Bloomba E-mail Message",
    'DUS'          => "Readiris Font Dictionary",
    'DS'           => "TWAIN Data Source",
    'DX'           => "DEC WPS Plus File",
    'DSP'          => "Dynamic Studio Professional Module",
    'DEX'          => "Excel Spreadsheet",
    'DCF'          => "Disk Copy Fast Disk Image File",
    'DMC'          => "Medical Manager Script",
    'DSY'          => "Besta Video File",
    'DTA'          => "Chain Engineering Database",
    'DPS'          => "DivX Player 2 Skin File",
    'DOX'          => "MultiMate Document",
    'DNC'          => "Dance Database File",
    'DDT'          => "Jill of the Jungle Music File",
    'DKE'          => "DriveLock FDE Disk Key File",
    'DYC'          => "Xerox Printer Driver Configuration File",
    'DLX'          => "Renamed DLL File",
    'DTHUMB'       => "Android Data Thumbnail",
    'DOCHTML'      => "Microsoft Word HTML Document",
    'DOCMHTML'     => "Microsoft Word MIME HTML Document",
    'DOTHTML'      => "Microsoft Word HTML Document Template",
    'DSG'          => "Decker Saved Game",
    'DB-'          => "Norton Nprotect Database File",
    'DIS'          => "DisSharp Project File",
    'DRF'          => "Delphi Resource File",
    'DOCZ'         => "ThinkFree Online Note Document",
    'DN1'          => "Duke Nukem 1 Game Data File",
    'DN2'          => "Duke Nukem Episode 2 Game File",
    'DN3'          => "Duke Nukem Episode 3 Game File",
    'DOT'          => "Graphviz Graph File",
    'DVDR'         => "DVD/CD-R Master Image",
    'DEF'          => "M.U.G.E.N. Character Definition File",
    'DWP'          => "Darwin Pond Save File",
    'DEPEND'       => "Code::Blocks Dependencies File",
    'DSC'          => "Text Description File",
    'DIY'          => "My Drivers Backup Setup File",
    'DWA'          => "Digital Waveform Archiver Audio File",
    'DAT'          => "Nonimmigrant Visa Application Data File",
    'DZ'           => "Land of the Dead Level File",
    'DAY'          => "Day of the Zombie Map File",
    'DOCXML'       => "Microsoft Word XML Document",
    'DIMAX'        => "DiMAX Firmware Image File",
    'DRZ'          => "Draz Paint File",
    'DEVICESALT'   => "NOOK Device Salt File",
    'DUMP'         => "Google BreakPad Crash Log File",
    'DMTEMPLATE'   => "Direct Mail Template",
    'DEF'          => "IOBit Malware Fighter Definitions File",
    'DVC'          => "IDRISI Vector Definition File",
    'DCA'          => "DisplayWrite Document",
    'DFU'          => "LaTeX Font Encoding File",
    'DHT'          => "GAUSS Data Set Header File",
    'DVG'          => "Graphic Works Vector Graphic",
    'DNH'          => "Danmakufu Script",
    'DL'           => "Dynamic Library",
    'DB2'          => "Samsung CCTV Video Information File",
    'DA2'          => "AGT Game Data File",
    'DA6'          => "AGT Game Data File",
    'DFTI'         => "FlexiWrite Document",
    'DGE'          => "Enterprise Test Server Declaration Generator File",
    'DRW'          => "Personal Designer Drawing File",
    'DR'           => "My Dark Diary Backup File",
    'EPS'          => "Encapsulated PostScript File",
    'EXE'          => "Windows Executable File",
    'EPUB'         => "Open eBook File",
    'EML'          => "E-Mail Message",
    'EMF'          => "Enhanced Windows Metafile",
    'ENC'          => "Encoded File",
    'EMZ'          => "Windows Compressed Enhanced Metafile",
    'EXIF'         => "Exchangeable Image Information File",
    'EXE'          => "PortableApps.com Application",
    'EPW'          => "EnergyPlus Weather Data File",
    'EDRW'         => "SolidWorks eDrawings File",
    'EFX'          => "eFax Document",
    'EMP'          => "eMusic Music Download File",
    'EMX'          => "eMusic Download File",
    'ERF'          => "BioWare Entity Resource File",
    'EXP'          => "Symbols Export File",
    'ELF'          => "Executable and Linkable Format File",
    'EDJ'          => "Enlightenment Theme File",
    'ESM'          => "Elder Scrolls Master File",
    'ECM'          => "ECM Disc Image",
    'EDL'          => "Edit Decision List File",
    'ENEX'         => "Evernote Archive",
    'EAR'          => "Java Enterprise Archive File",
    'ENL'          => "EndNote Library",
    'ERB'          => "Ruby ERB Script",
    'EDI'          => "Electronic Data Interchange File",
    'EX01'         => "EnCase Evidence Image File",
    'EX5'          => "MetaTrader 5 Program File",
    'ERR'          => "Error Log File",
    'EXD'          => "Control Information Cache File",
    'ENT'          => "External Entity",
    'EV'           => "Echoview File",
    'EQP'          => "MathType Preferences",
    'EQL'          => "MathType Settings",
    'ECF'          => "Outlook Add-in",
    'EQL'          => "Embedded SQL File",
    'EMD'          => "ChessBase Tablebase",
    'EAP'          => "Enterprise Architect Project",
    'EYE'          => "Eyemail Video Recording File",
    'EMLX'         => "Mail Message",
    'EMLXPART'     => "Mail Message Attachment",
    'EX'           => "Euphoria Source Code",
    'ETF'          => "ENIGMA Transportable File",
    'EDA'          => "Ensoniq ASR Disk Image",
    'EDE'          => "Ensoniq EPS Disk Image",
    'EDK'          => "Ensoniq KT Disk Image",
    'EDS'          => "Ensoniq SQ-80 Disk Image",
    'EDV'          => "Ensoniq VFX-SD Disk Image",
    'EFA'          => "Ensoniq ASR File",
    'EFK'          => "Ensoniq KT File",
    'EFQ'          => "Ensoniq SQ1/SQ2/KS-32 File",
    'EFS'          => "Ensoniq SQ-80 File",
    'EFV'          => "Ensoniq VFX-SD File",
    'EMB'          => "Wilcom Embroidery Design File",
    'EMD'          => "ABT Extended Module",
    'ESPS'         => "ESPS Sampled Data File",
    'EUI'          => "Ensoniq EPS Compacted Disk Image",
    'EBM'          => "EXTRA! Basic Macro",
    'ERB'          => "Evil Genius Resource File",
    'EDB'          => "Exchange Information Store Database",
    'ENG'          => "Chess Engine",
    'EFW'          => "Renamed Zip or Executable File",
    'ECS'          => "Sony Ericsson Phone Backup File",
    'ELF'          => "PlayStation Executable File",
    'EFL'          => "Encryptafile Encrypted File",
    'EXP'          => "Export File",
    'EBUILD'       => "Portage eBuild Script",
    'EBN'          => "Philips Firmware Update File",
    'EXX'          => "IBM Linkway MsgPut File",
    'EQF'          => "Winamp Equalizer Preset File",
    'ECO'          => "ECCO Database File",
    'ECX'          => "ECCO Corrupted Database File",
    'EVO'          => "HD DVD Video File",
    'ELF'          => "Nintendo Wii Game File",
    'EST'          => "Streets & Trips Map File",
    'EUM'          => "Enterprise User Monitor Configuration File",
    'EGM'          => "Enigmo Custom Game File",
    'ESG'          => "Enigmo Saved Game File",
    'ESPROJ'       => "Espresso Project File",
    'ECF'          => "SageCRM Component File",
    'EPIBRW'       => "Web File Location",
    'ER1'          => "ERWin Entity Relationship Diagram",
    'EGG'          => "Panda3D Model File",
    'EMULECOLLECT' => "O'N   eMule Data File",
    'EFTX'         => "Office 2007 Theme Effect File",
    'EX4'          => "MetaTrader 4 Program File",
    'ETD'          => "Adobe Reader EBX Transfer Data File",
    'ETL'          => "Microsoft Event Trace Log File",
    'EGP'          => "Easy Grade Pro Gradebook File",
    'EXE4J'        => "Exe4j Configuration File",
    'EVT'          => "Windows Event Viewer Log File",
    'ESX'          => "Xactimate Insurance Claims Estimate",
    'EPF'          => "Edgecam Educational Part File",
    'EPSF'         => "Encapsulated PostScript Format File",
    'EXP'          => "CATIA 4 Export File",
    'ERF'          => "Epson RAW File",
    'EZW'          => "easyOFFER Real Estate Form File",
    'EBK'          => "eBook Pro eBook File",
    'ECW'          => "Enhanced Compression Wavelet Image",
    'ENC'          => "Encore Musical Notation File",
    'EDMX'         => "ADO.NET Entity Data Model Designer File",
    'E2GM'         => "Pangea Enigmo 2 Custom Game File",
    'EMC'          => "Striata Reader Encrypted Document",
    'EX_'          => "Compressed Executable File",
    'EAZ'          => "ArcGIS Explorer Add-in File",
    'ECL'          => "Management-Ware Mass Mailing News E-Campaign List",
    'EXR'          => "OpenEXR Image",
    'EXW'          => "Euphoria Source code File",
    'EDML'         => "Adobe Extension Data Markup Language Document",
    'EFI'          => "Extensible Firmware Interface File",
    'ESM'          => "Fallout 3 Master File",
    'EVTX'         => "Windows 7 Event Log File",
    'EDRWX'        => "XPS Drawing Document",
    'EPP'          => "Canon Easy-PhotoPrint Image File",
    'ESP'          => "Fallout 3 Plugin File",
    'EFP'          => "Exchange Forms Designer Template",
    'EWP'          => "Ewisoft Website Project File",
    'EASM'         => "eDrawings Assembly File",
    'ESB'          => "Es-Builder Book File",
    'E01'          => "EnCase Image File",
    'EDAT'         => "E-DataAid 1.x File",
    'EDAT2'        => "E-DataAid 2.0 File",
    'ES2'          => "E-Studio 2.0 Experiment File",
    'ES'           => "E-Studio 1.x Experiment File",
    'EBS2'         => "E-Run 2.0 Script File",
    'EDGE'         => "Adobe Edge Project File",
    'ESS'          => "The Elder Scrolls Saved Game",
    'EDN'          => "EDIF Implementation Netlist File",
    'EDF'          => "Edificius Project",
    'EDG'          => "Edge Diagrammer File",
    'ET'           => "Kingsoft Spreadsheets File",
    'E57'          => "LIDAR Point Cloud Data File",
    'ERL'          => "Erlang Source Code File",
    'ENLX'         => "Archived EndNote Library",
    'ENF'          => "EndNote Filter File",
    'ENS'          => "EndNote Style File",
    'ENZ'          => "EndNote Connection File",
    'ERS'          => "ER Mapper Data File",
    'ESP'          => "Elder Scrolls Plugin File",
    'EM'           => "Encore Menu Template",
    'EFIRES'       => "EFI Image File",
    'EXPORTEDFAVO' => "I'TES Transmit Exported Favorites File",
    'EZT'          => "EZTitles Subtitles File",
    'ENTITLEMENTS' => "Mac App Sandboxing Entitlements File",
    'EGG'          => "ALZip Archive",
    'EWD'          => "EasyWOOD Design File",
    'EP'           => "Pencil Document",
    'EHI'          => "HTTP Injector Config File",
    'EIP'          => "Enhanced Image Package File",
    'ESD'          => "Windows Electronic Software Download File",
    'EZDRAW'       => "EazyDraw Graphic",
    'EBD'          => "Windows EBD System File",
    'EGC'          => "EximiousSoft GIF Creator Document",
    'EDX'          => "Edraw XML FIle",
    'EDXZ'         => "Edraw Compressed XML FIle",
    'EIO'          => "Yozo Office File",
    'ENX'          => "Max PC Safe Encrypted File",
    'EV3'          => "LEGO MINDSTORMS EV3 Project",
    'ENV'          => "Now Contact Envelope Template",
    'EXPORTEDUI'   => "Microsoft Office Exported UI Customization File",
    'ELD'          => "Eulumdat Formatted Luminaire Data File",
    'ESF'          => "Password Manager Container File",
    'EPF'          => "EAGLE Project",
    'ESCOPY'       => "ES Explorer Temporary File",
    'EF'           => "Diploma Exam File",
    'EPIM'         => "EssentialPIM Database File",
    'EPP'          => "Elmedia Player Playlist",
    'EYETV'        => "EyeTV Recording File",
    'EVO'          => "SeeVogh Player Video Recording",
    'ESLOCK'       => "ES File Explorer File Manager Encrypted File",
    'ESCAPE'       => "Prison Architect Escape Mode Save File",
    'ESC'          => "EasySignCut Pro Project",
    'EXS'          => "EXS Instrument",
    'EDZ'          => "EPLAN Electric P8 Data Archive Zipped File",
    'EDDX'         => "Edraw XML FIle",
    'EWPRJ'        => "Ultiboard Layout Project",
    'EMM'          => "MindMaple Map",
    'EPRT'         => "eDrawings File",
    'ELS'          => "EasyLanguage Storage File",
    'ECW'          => "EclipseCrossword Word List File",
    'ETNG'         => "Easiteach Next Generation Document",
    'EXP'          => "Melco Embroidery File",
    'EDOC'         => "Electronically Certified Document",
    'EYB'          => "Microsoft Encarta Yearbook Update File",
    'E00'          => "ArcInfo Coverage Export File",
    'ESP'          => "ACD/Labs Dataset",
    'EFE'          => "Ensoniq EPS File",
    'EOT'          => "Embedded OpenType Font",
    'ERR'          => "FoxPro Compilation Error",
    'EPP'          => "TalaPhoto Project",
    'EPP'          => "EditPad Pro Project",
    'ECE'          => "Escenic Dynamic Web Page",
    'EFL'          => "External Format Language File",
    'EFR'          => "Encryptafile Private Key File",
    'EFU'          => "Encryptafile Public Key File",
    'EXP'          => "Aurora Expert Trace File",
    'EXP'          => "SonicWALL Preference File",
    'EPP'          => "Efficient PPC Project File",
    'ENC'          => "Copysafe Protected PDF File",
    'ENC'          => "Electronic Navigation Chart File",
    'ES'           => "SageCRM Script File",
    'EEP'          => "EEPROM Data File",
    'EMERALD'      => "Emerald Theme",
    'E4A'          => "Encrypt4all Archive",
    'EPK'          => "Metin2 Game Data Package",
    'EXS'          => "Blades of Exile Scenario",
    'EST'          => "Construction Cost Estimate File",
    'ET'           => "Easiteach Lesson File",
    'EC0'          => "MetroCount Traffic Data File",
    'ETA'          => "Google Earth Placemark File",
    'EDF'          => "ESRF Data File",
    'EZT'          => "EZT Malicious Worm File",
    'EV3'          => "Team Manager Meet Event File",
    'EPI'          => "EclipsePackager2000 Compressed File",
    'EXOPC'        => "ExoPC Application",
    'EDAT'         => "Sony Encrypted Data File",
    'EDC'          => "Kryptel Lite Encrypted File",
    'EAS'          => "RSLogix Symbol File",
    'EX_'          => "Renamed Windows Executable File",
    'ERR'          => "AutoCAD Error Log File",
    'EAP'          => "Adobe Photoshop Exposure File",
    'EDM'          => "Adobe Extension Data Markup Language File",
    'ENV'          => "Adobe Dictionary Data File",
    'EL'           => "Emacs Lisp Code File",
    'ELC'          => "Emacs Compiled Lisp File",
    'ENV'          => "Vue Environment File",
    'EXPRESSIONMA' => " 'Cubase Expression Map File",
    'ELM'          => "Office Theme File",
    'ELM'          => "Eternal Lands Map File",
    'EQN'          => "GAL Equation File",
    'ERP'          => "Alter Ego Game Archive",
    'EXL'          => "Export Lister File",
    'ECC'          => "dvdisaster Error Correction File",
    'EZLOG'        => "Skype Extras Manager Log File",
    'EMB'          => "Pfaff Embroidery Design File",
    'EXT'          => "Generic Email Attachment",
    'EMRG2'        => "E-Merge 2.0 Data File",
    'EMRG'         => "E-Merge 1.x Data File",
    'EBS'          => "E-Run 1.x Script",
    'EPK2'         => "E-Prime 2.0 Package File",
    'ECP'          => "EasyC Project File",
    'EDN'          => "Adobe eBook Activation File",
    'EWS'          => "EasyWorship Schedule File",
    'ETT'          => "Kingsoft Spreadsheets Template",
    'ERL'          => "GameGuard Error Log File",
    'EF2'          => "Internet Download Manager Export File",
    'EZP'          => "AutoCAD Ecscad Project Backup File",
    'ENQ'          => "EndNote Search Options File",
    'ETX'          => "TeX Font Encoding File",
    'E_E'          => "Renamed EXE File",
    'EMY'          => "eMelody Ringtone File",
    'EPR'          => "Photoshop AME Preset File",
    'ENML'         => "Evernote for Android Note",
    'ERSX'         => "Eraser Task List File",
    'EC3'          => "EPSON Print CD File",
    'EC4'          => "EPSON Print CD File",
    'EBM'          => "Embla Recording",
    'EWB'          => "Electronics Workbench Circuit Design File",
    'EXM'          => "Boson Exam File",
    'EUF'          => "Private Character Editor File",
    'EVENT'        => "Corel Cataloged Folder File",
    'EST_UAX'      => "Spanish Unreal Audio Package",
    'EXAMPLE'      => "Example Configuration File",
    'EXB'          => "CAXA Draft",
    'EMF'          => "Jasspa MicroEmacs Macro File",
    'EIT'          => "Yozo Office Template File",
    'ECT'          => "Yozo Office Chart Template File",
    'EV3P'         => "LEGO MINDSTORMS EV3 Program",
    'EV3S'         => "LEGO MINDSTORMS EV3 Shared File",
    'EOP'          => "EveryonePiano Music Score File",
    'EFX'          => "Jedi Knight Effects File",
    'ERB'          => "Braille Music Reader File",
    'EA'           => "Kindle End Actions File",
    'EAL'          => "Kindle End Actions File",
    'EBA'          => "Emergence BASIC Source Code File",
    'EGT'          => "EagleGet Temporary File",
    'EYETVSCHED'   => "EyeTV Schedule File",
    'EYETVP'       => "EyeTV Recording Metadata File",
    'EXO'          => "YouTube Video Chunk File",
    'EKX'          => "Encrypted 3DS Pokémon Save File",
    'EK6'          => "Generation 6 Pokémon Save File",
    'EVX'          => "SeeVogh Player Remote Recording",
    'EMBL'         => "EMBL Sequence Data File",
    'EMBR'         => "Spatial Geodatabase File",
    'ENX'          => "eDataSecurity Management Encrypted File",
    'EXC'          => "eDataSecurity Management Self-extracting File",
    'EVP'          => "Talisman Online Game Data File",
    'EL4'          => "Easy-PhotoPrint EX Calendar File",
    'EPK'          => "LG Firmware Package",
    'E2P'          => "PonyProg Device File",
    'EWL'          => "EclipseCrossword Word List File",
    'EWNET'        => "Ultiboard Netlist File",
    'EMMT'         => "MindMaple Map Template",
    'ECFG'         => "ArcGIS Component Configuration File",
    'ERD'          => "Entity Relation Diagram",
    'ERD'          => "Engineering Research Division Data File",
    'EXP'          => "DX Series Exported Video File",
    'ERP'          => "Ego Engine Game Archive",
    'EXP'          => "Bernina Embroidery File",
    'ERG'          => "CompuTrainer Workout File",
    'ETE'          => "Exam Testing Engine File",
    'ECD'          => "Encrypted Cryptee Document",
    'EWW'          => "Embedded Workbench Workspace",
    'EFT'          => "Logitech Lighting Effect File",
    'EXTR'         => "COW App Extractor File",
    'ENV'          => "WordPerfect Environment",
    'EQN'          => "WordPerfect Equation",
    'EXT'          => "Norton Commander Extension",
    'ESH'          => "Extended Shell Batch File",
    'ETX'          => "Structure Enhanced Text (Setext) File",
    'EUC'          => "Extended Unix Code File",
    'EMAIL'        => "Outlook Express Email Message",
    'EVY'          => "Envoy File",
    'ESS'          => "EasySpreadsheet Spreadsheet",
    'EZS'          => "EZ-R Stats Batch Script",
    'EAR'          => "Eyemail Audio Recording",
    'EDQ'          => "Ensoniq SQ1/SQ2/KS32 Disk Image",
    'EMB'          => "Everest Embedded Bank File",
    'EDF'          => "Estimator Data File",
    'EIX'          => "Metin2 Game Data File",
    'EV3'          => "Everlock Options File",
    'ENW'          => "EndNote Import File",
    'EDFX'         => "Estimator.NET Estimate File",
    'EXC'          => "Black & White Zone File",
    'ETFF'         => "Encrypt4all Theme File",
    'EPC'          => "Doctor Who Game Data File",
    'ESE'          => "Millions Email Generator Email List File",
    'EXL'          => "JSDAI Inclusion or Exclusion List",
    'ESQ'          => "Embroidery Sequence File",
    'ENC'          => "Cabal Online Data File",
    'EZC'          => "AutoCAD Ecscad Components Backup File",
    'EHAM'         => "ExtraHAM Executable File",
    'ENP'          => "EndNote Preferences File",
    'EEPF'         => "EmuOS Exchangeable Packet File",
    'EXV'          => "Adobe Extension Script",
    'EXTRA'        => "Google BreakPad Crash Log Extra File",
    'EEK'          => "Arachne Network-Enabled Script",
    'EXE1'         => "Renamed EXE File",
    'ECL'          => "Touhou Stage Script",
    'EVR'          => "Enhanced Variable Rate Audio File",
    'ERP'          => "Encarta Researcher File",
    'EGLIB'        => "Adobe Edge Animate Library File",
    'EKB'          => "ZMC Visual Tablet Data",
    'EVRC'         => "Enhanced Variable Rate Codec File",
    'FNT'          => "Windows Font File",
    'FON'          => "Generic Font File",
    'FLA'          => "Adobe Animate Animation",
    'FLV'          => "Animate Video File",
    'FM'           => "FrameMaker Document",
    'FLAC'         => "Free Lossless Audio Codec File",
    'FB2'          => "FictionBook 2.0 File",
    'FPBF'         => "Mac OS X Burn Folder",
    'FDB'          => "Portfolio Catalog",
    'FP7'          => "FileMaker Pro 7+ Database",
    'FBX'          => "Autodesk FBX Interchange File",
    'FBR'          => "FlashBack Screen Recording",
    'FRM'          => "MySQL Database Format File",
    'F4V'          => "Flash MP4 Video File",
    'FXG'          => "Flash XML Graphics File",
    'FPF'          => "IKEA Home Planner File",
    'FBW'          => "HP Recovery Manager Backup File",
    'FDX'          => "Final Draft Document",
    'FS'           => "Visual F# Source File",
    'FSX'          => "Visual F# Script File",
    'FSPROJ'       => "Visual F# Project File",
    'FXP'          => "Adobe Flex Project File",
    'FTL'          => "FreeMarker Template File",
    'FMV'          => "FME Desktop Viewspace File",
    'FMW'          => "FME Workbench File",
    'FTM'          => "FamiTracker Module",
    'FLT'          => "OpenFlight Scene Description File",
    'FCPROJECT'    => "Final Cut Pro X Project File",
    'FCGI'         => "FastCGI File",
    'FACEFX'       => "FaceFX Actor File",
    'FMP12'        => "FileMaker Pro 12 Database",
    'FCDT'         => "FormsCentral Design Template",
    'FMAT'         => "FMAT Runfile",
    'FCPEVENT'     => "Final Cut Pro Event File",
    'FMC'          => "FormConnect Form File",
    'FUN'          => "Cubify Invention File",
    'FPPX'         => "Microsoft Fresh Paint Painting File",
    'FREEWAY'      => "Freeway Document",
    'FETCHMIRROR'  => "Fetch Mirror Document",
    'FCS'          => "Flow Cytometry Standard File",
    'FPT'          => "FileMaker Pro Database Memo File",
    'FRM'          => "Form File",
    'FLC'          => "FLIC Animation",
    'FLI'          => "FLIC Animation",
    'FPX'          => "FlashPix Bitmap Image File",
    'FXP'          => "FoxPro Compiled Program",
    'FXP'          => "FX Preset File",
    'F'            => "Fortran Source Code",
    'FITS'         => "Flexible Image Transport System File",
    'FMX'          => "FileMaker Plug-in",
    'FIC'          => "WinDev Hyper File Database",
    'F90'          => "Fortran 90 Source Code File",
    'FOR'          => "Fortran 77 Source File",
    'FTW'          => "Family Tree Maker File",
    'FLP'          => "FruityLoops Project",
    'FPD'          => "Front Panel Designer Project",
    'FXC'          => "FilePackager Configuration",
    'FNC'          => "QuickCAM 3D CNC File",
    'FPT'          => "FoxPro Table Memo",
    'FRT'          => "FoxPro Report Memo",
    'FKY'          => "FoxPro Macro",
    'FLL'          => "FoxPro Dynamic-Link Library",
    'FMT'          => "FoxPro Format File",
    'FH9'          => "FreeHand 9 Drawing File",
    'FTPLOC'       => "FTP Location",
    'FS'           => "FlexiSIGN Document",
    'FPFV'         => "File Protected From Virus",
    'FCD'          => "Virtual CD Format",
    'FRAMEWORK'    => "Mac OS X Application Framework",
    'FRO'          => "dBASE IV Compiled Report",
    'F32'          => "Raw 32-Bit Audio File",
    'F64'          => "Raw 64-Bit Audio File",
    'F2R'          => "Farandoyle Linear Module File",
    'F3R'          => "Farandoyle Blocked Module File",
    'FSM'          => "Farandole Composer WaveSample File",
    'FZF'          => "Casio FZ-1 Full Dump",
    'FZV'          => "Casio FZ-1 Voice Dump",
    'FDB'          => "Art Explosion Catalog",
    'FDR'          => "Final Draft Document",
    'F'            => "Freeze Compressed File",
    'FRX'          => "Visual Basic Binary Form File",
    'FML'          => "WWE RAW Character File",
    'FCP'          => "Final Cut Project",
    'FSC'          => "Practical Scriptwriter File",
    'FLO'          => "iGrafx FlowCharter File",
    'FLX'          => "FelixCAD Drawing",
    'FO'           => "XSL-FO Form",
    'FLT'          => "Adobe Audition Filter",
    'FLT'          => "Flight Simulator Saved Flight",
    'FCC'          => "Forms Credential Collector File",
    'FA'           => "FASTA Formatted Sequence File",
    'FASTA'        => "FASTA Sequence File",
    'FLAME'        => "Fractal Flames File",
    'FBF'          => "Free Backup Fix Backup File",
    'FOP'          => "InfoZoom Protected Data File",
    'FOX'          => "InfoZoom Data File",
    'FLP'          => "ActivPrimary Flipchart File",
    'FSPROJ'       => "FireStarter Project File",
    'FLP'          => "Floppy Disk Image",
    'FBL'          => "CADfix Command Level Log File",
    'FGL'          => "Fifth Generation Language Source File",
    'FPM'          => "FPS Creator Map File",
    'FDI'          => "Amiga Disk Image",
    'FDR'          => "Windows Error Report File",
    'FOB'          => "Dynamics NAV Object Container File",
    'FDB'          => "Microsoft Dynamics NAV Database File",
    'FBK'          => "Microsoft Dynamics NAV Backup File",
    'FLF'          => "Microsoft Dynamics NAV License File",
    'FBP'          => "wxFormBuilder Project",
    'FRS'          => "Flash Renamer Script",
    'FUL'          => "Microsoft Backup File List",
    'FD2'          => "PictureMate Borders File",
    'FC2'          => "Poser Face Pose File",
    'FCZ'          => "Compressed Poser Face Pose File",
    'FCW'          => "FastCAD Windows Drawing",
    'FS2'          => "FreeSpace 2 Saved Mission File",
    'FSM'          => "FreeSpace Mission File",
    'FLH'          => "FLIC Animation File",
    'FHC'          => "FHC Data File",
    'FIG'          => "Xfig Drawing",
    'FF'           => "Call of Duty 4 Fast File",
    'FST'          => "Crazy Machines 2 Object File",
    'FIL'          => "Files List Object File",
    'FBZ'          => "FlashBack Screen Recorder Movie",
    'FAR'          => "The Sims Archive File",
    'FFWP'         => "FormsForWeb Packet",
    'FSM'          => "Splitty Master Split File",
    'FBC'          => "Family Tree Maker for DOS Backup File",
    'FBK'          => "Family Tree Maker for Windows Backup File",
    'FS'           => "Mac OS X File System Plug-in",
    'FILE'         => "Generic Windows File",
    'FLO'          => "RFFlow Flowchart File",
    'FWT'          => "FacetWin Configuration File",
    'FBU'          => "FEBE Firefox Backup File",
    'FW'           => "Firmware Update File",
    'FSB'          => "FMOD Sample Bank File",
    'FAS'          => "Compiled Fast-Load AutoLISP File",
    'FLR'          => "Flare Decompiled ActionScript File",
    'FORGE'        => "Assassin's Creed Game Data File",
    'FPI'          => "FPS Creator Intelligence Script",
    'FPE'          => "FPS Creator Entity File",
    'FPS'          => "FPS Creator Segment File",
    'FPG'          => "FPS Creator Game Project File",
    'FX'           => "Direct3D Effects File",
    'FL'           => "Freelancer Saved Game File",
    'FH10'         => "FreeHand 10 Drawing File",
    'FH11'         => "FreeHand 11 Drawing File",
    'FRZ'          => "Snes9x Saved State",
    'FPSL'         => "FileMaker Pro Snapshot Link",
    'FD'           => "LaTeX Font Definition File",
    'FT'           => "Edgecam Feature Template",
    'FGD'          => "Forge Game Data File",
    'FSSCRIPT'     => "Visual F# Script",
    'FSI'          => "Visual F# Signature File",
    'FXA'          => "OC3 Entertainment FaceFX Actor File",
    'FRG'          => "Sound Forge Pro Project File",
    'FMP'          => "AutoCAD Font Map File",
    'FLST'         => "Adobe InDesign Flattener Presets File",
    'F4P'          => "Adobe Flash Protected Media File",
    'F4A'          => "Adobe Flash Protected Audio File",
    'FXPL'         => "Adobe Flash FXP Library",
    'FLB'          => "FileMaker Pro Label File",
    'FMPLUGIN'     => "FileMaker Plug-in",
    'FTH'          => "FileMaker Theme File",
    'FNC'          => "Vue Functions File",
    'FMI'          => "FME Include File",
    'FME'          => "FME Mapping File",
    'FDS'          => "FME Custom Format File",
    'FMELIC'       => "FME License File",
    'FFS'          => "FME Desktop Feature Store File",
    'FG'           => "FaceGen Project File",
    'FLK'          => "Folder Lock File",
    'FOS'          => "Fallout 3 Saved Game",
    'FFX'          => "After Effects Preset File",
    'FLIPCHART'    => "ActivInspire Flipchart File",
    'FIG'          => "3ds Max Figure File",
    'FH'           => "Symantec Backup Exec File",
    'FDM'          => "Exchange Forms Designer Form Message",
    'FRY'          => "fryrender Scene File",
    'FAMILYFILE'   => "Reunion Family File",
    'FSSAVE'       => "Flight Simulator Save File",
    'FB!'          => "FlashGet Incomplete Download File",
    'FSH'          => "Fragment Shader File",
    'FOT'          => "Font Resource File",
    'FDT'          => "Final Draft 5-7 Template",
    'FDXT'         => "Final Draft 8 Template",
    'FCF'          => "Final Draft Converter File",
    'FPOS'         => "Photo Pos Pro Image",
    'FP'           => "Fragment Program File",
    'FNRECIPES'    => "Food Network Recipe File",
    'FZ'           => "Fritzing Project File",
    'FIT'          => "Garmin Activity File",
    'FR3'          => "FastReport Form File",
    'FP3'          => "FastReport Prepared Report File",
    'FTN'          => "Fortran Source Code File",
    'FLOW'         => "Expression SketchFlow Data File",
    'FEEDBACK'     => "Expression SketchFlow Feedback File",
    'FWP'          => "Microsoft Expression Web Package",
    'FXT'          => "FaceFX Actor Template File",
    'FACEFX_INGAM' => " 'FaceFX In-Game Actor File",
    'FXL'          => "FaceFX Language File",
    'FOMOD'        => "Fallout Mod Archive",
    'FCSTD'        => "FreeCAD Document",
    'FLKA'         => "Folder Lock Portable Locker File",
    'FLKB'         => "Folder Lock Basic Locker File",
    'FLWA'         => "Folder Lock Wallet File",
    'FMZ'          => "Form•Z Project File",
    'FAN'          => "Form•Z Animation File",
    'FZP'          => "Fritzing Part File",
    'FXS'          => "messiahStudio Scene File",
    'FXM'          => "messiahStudio Motion File",
    'FMPSL'        => "FileMaker Pro 12 Snapshot Link",
    'FFF'          => "Hasselblad RAW Image",
    'FOTA'         => "Firmware Over-the-Air File",
    'FBZ7'         => "Compressed FinalBuilder 7 Project",
    'FCT'          => "FolderClone Task List",
    'FXG'          => "FX Graph File",
    'FXCPROJ'      => "FX Composer Project File",
    'FCM'          => "fCraft World File",
    'FDP'          => "FMOD Project File",
    'FEV'          => "FMOD Audio Events File",
    'FSQ'          => "CryENGINE Facial Editor Sequence File",
    'FPJ'          => "CryENGINE Facial Editor Project File",
    'FXL'          => "CryENGINE Facial Expression Library",
    'FODS'         => "OpenDocument Flat XML Spreadsheet",
    'FODT'         => "OpenDocument Flat XML Document",
    'FODP'         => "OpenDocument Flat XML Presentation",
    'FBK'          => "AutoCAD Civil 3D Field Book File",
    'FAS'          => "FASTA Sequence File",
    'FTC'          => "FluxTime Clip File",
    'FPSX'         => "Nokia Firmware Format File",
    'FCS'          => "FCEUX Save State File",
    'F3D'          => "Fusion 3D Design",
    'FXML'         => "FXML Source Code File",
    'FORM'         => "NetBeans Java GUI Designer Form",
    'FTM'          => "Finale Template File",
    'FTMX'         => "Finale Template File",
    'FTMB'         => "Family Tree Maker Backup File",
    'FPA'          => "Finale Performance Assessment File",
    'FORTH'        => "Forth Language File",
    'FUK'          => "Postal 2 Map File",
    'FBQ'          => "Trine 2 Data File",
    'FKB'          => "Flipkart eBook File",
    'FAX'          => "Now Contact Fax Template",
    'FLM'          => "Adobe Scout Session",
    'FOUNTAIN'     => "Fountain Script File",
    'FADEIN'       => "Fade In Document",
    'FC'           => "FirstClass Settings File",
    'FPDX'         => "Utilius Fairplay Project",
    'FSTAB'        => "File Systems Table File",
    'FOLIO'        => "Adobe Folio File",
    'FFM'          => "FFmpeg Stream File",
    'FCPXML'       => "Final Cut Pro XML File",
    'FCPBUNDLE'    => "Final Cut Pro Library",
    'FSC'          => "FL Studio Score File",
    'FLM'          => "FL Studio Mobile Song File",
    'FLP'          => "FL Studio Project File",
    'FSD'          => "Flowsheet Document",
    'FLW'          => "Fusion Flow File",
    'FINGNET'      => "Overlook Fing Saved Network File",
    'FRDOC'        => "FineReader Document",
    'FWDICT'       => "Freeway User Dictionary File",
    'FWBACKUP'     => "Freeway Backup",
    'FWTEMPLATE'   => "Freeway Template",
    'FWTB'         => "Freeway Template Bundle",
    'FWACTIONB'    => "Freeway Action Bundle File",
    'FETCHSHORTCU' => "S'Fetch Shortcut List FIle",
    'FVP'          => "File Viewer Plus Batch Presets File",
    'FPR'          => "Audit Workbench Project",
    'FGC'          => "Greeting Card Factory Card File",
    'FLOWCHART'    => "PureFlow Flowchart",
    'FEY'          => "FCS Express Layout File",
    'FTP'          => "FlashFXP XML File",
    'FPE'          => "Free PDF Editor Document",
    'FILEBOLT'     => "Filebolt Encrypted File",
    'FM'           => "FileMaker Database",
    'FDF'          => "Acrobat Forms Data Format",
    'FFA'          => "Find Fast Status File",
    'FFL'          => "Find Fast Document List",
    'FFO'          => "Find Fast Document Properties Cache",
    'FFX'          => "Microsoft Find Fast Index",
    'FAX'          => "Fax Document",
    'FP5'          => "FileMaker Pro 5 Database",
    'FP'           => "FileMaker Pro Spreadsheet",
    'FHD'          => "FreeHand Drawing File",
    'FTS'          => "Full Text Search",
    'FTG'          => "Full Text Group",
    'FPP'          => "Fortran Source Code",
    'FLX'          => "FLIC Animation",
    'FFD'          => "Flat File Descriptor",
    'FXB'          => "FX Bank File",
    'FRK'          => "Macintosh Resource or Data Fork",
    'FRX'          => "FoxPro Report",
    'FRZ'          => "Locked FormFlow File",
    'FAR'          => "Farandole Composer Module",
    'FPP'          => "Front Panel Project",
    'FPA'          => "Front Panel Encrypted Order File",
    'FES'          => "Fileless Occurrence Placeholder",
    'FDP'          => "MySafe Encrypted Data",
    'FRM'          => "ADL Form",
    'FXT'          => "Grand Theft Auto Fake Text File",
    'FDS'          => "Final Draft Secure Copy",
    'FRM'          => "Visual Basic Text Form",
    'FLT'          => "Image Filter",
    'FP3'          => "FloorPlan 3D Design File",
    'FNC'          => "Frogans Player Network Certificate",
    'FIL'          => "Symbian Application Logo File",
    'FID'          => "File Expander Engine Descriptions Database",
    'FSS'          => "Splitty Data Split File",
    'FTM'          => "Family Tree Maker for DOS File",
    'FMP'          => "123 Flash Menu Project",
    'FEV'          => "FLAMES Environment Variable File",
    'FC2MAP'       => "Far Cry 2 User Map",
    'FFIL'         => "Mac Font Suitcase",
    'FTIL'         => "e-Hastakshar Contract Note",
    'FLS'          => "Flash Lite Sound Bundle",
    'FAS'          => "QuickSilver Fast Save Lisp File",
    'FZIP'         => "Foxit Reader Add-on",
    'FRC'          => "FS Recorder File",
    'FH7'          => "FreeHand 7 Drawing File",
    'FBL'          => "iGO Map File",
    'FPMB'         => "FPS Creator Mab Buffer File",
    'FPMO'         => "FPS Creator Map Overlay File",
    'FPID'         => "FPS Creator AI Wizard Data File",
    'FPP'          => "FPS Creator Prefab File",
    'FXM'          => "WinFax Document",
    'FSG'          => "FreeCol Saved Game File",
    'FH8'          => "FreeHand 8 Drawing File",
    'FAT'          => "Zinf Theme File",
    'FD'           => "DataFlex Data File",
    'FDD'          => "Parallels Desktop Floppy Disk Image File",
    'FT11'         => "FreeHand 11 Drawing Template",
    'FIF'          => "Fractal Image File",
    'FMV'          => "Frame Vector Metafile",
    'FLG'          => "IsoPuzzle Flag File",
    'FRC'          => "Mandelbrot Explorer Color Settings File",
    'FRR'          => "Mandelbrot Explorer Fractal Region Settings File",
    'FBR'          => "Mercury Screen Recording",
    'FRM'          => "Painter Frame Stack File",
    'FILTERS'      => "Visual C++ Project Filters File",
    'FXF'          => "BigFix Action File",
    'FDC'          => "AutoCAD Field Catalog File",
    'FTL'          => "Family Tree Legends File",
    'FMOD'         => "Adobe Illustrator Flattening Module",
    'FLT'          => "Vue Filters File",
    'FCL'          => "ForeUI Custom Library File",
    'FCE'          => "ForeUI Custom Element File",
    'FTH'          => "Foobar2000 Theme File",
    'FRJ'          => "FreeForm-J Project File",
    'FPOP'         => "Spider-Man: Shattered Dimensions Saved Game",
    'FND'          => "Windows Saved Search",
    'FOLX'         => "Folx Download File",
    'FDT'          => "FormDocs Template",
    'FDD'          => "FormDocs Document",
    'FDT'          => "Lucene Field Data File",
    'FPK'          => "Civilization 4 Data File",
    'FNBK'         => "Food Network Recipe Manager Data File",
    'FFT'          => "Adobe Audition Noise Print File",
    'FZZ'          => "Fritzing Shareable Project File",
    'FRF'          => "Free Report Form File",
    'FTN'          => "Flowton Diagram File",
    'FHF'          => "Free Hide Folder Backup File",
    'FTPQUOTA'     => "Ftpquota File",
    'FZB'          => "Form•Z Project Backup File",
    'FZA'          => "Form•Z Autosave File",
    'FSL'          => "Form•Z Script",
    'FSB'          => "Form•Z Compiled Script",
    'FZP'          => "Form•Z Plug-in",
    'FBRB'         => "Battlefield Bad Company 2 Data File",
    'FBP7'         => "FinalBuilder 7 Project",
    'FAVORITEMETA' => "A'TA Transmit Favorites Data File",
    'FLAM3'        => "Fractal Flames File",
    'FG3'          => "FX Graph 3 File",
    'FLD'          => "YSFLIGHT Field File",
    'FOX'          => "Furcadia Art File",
    'FDS'          => "Nintendo FDS ROM",
    'FEATURE'      => "SharePoint Feature File",
    'FFD'          => "ffDiaporama Project File",
    'FCP'          => "Phantasy Star Online 2 Female Cast File",
    'FX'           => "ReadyBoot Trace File",
    'FTL'          => "Faster Than Light Mod File",
    'FNLF'         => "Scarlett Plug-in Suite License File",
    'FREECELLSAVE' => "M'S  Microsoft FreeCell Saved Game",
    'FRAMES'       => "xScope Frames File",
    'FBT'          => "ABBYY FineReader Document Options File",
    'F4F'          => "Flash Video Fragment",
    'FH6'          => "FreeHand 6 Drawing File",
    'FAN'          => "Finale Font Annotation File",
    'FRD'          => "Frequency Response Data File",
    'FPT'          => "Alpha Five Table Memo File",
    'FP8'          => "FP8 (= Fast PAQ8) Compressed File",
    'F06'          => "Nastran Output File",
    'F04'          => "Nastran Execution Summary File",
    'FADEIN.TEMPL' => "T'E  Fade In Template",
    'FFINDEX'      => "FFmpegSource2 Media Index",
    'FLK'          => "AccountEdge Company Lock File",
    'FRM'          => "AccountEdge Form",
    'FPP'          => "Flow Chart Visual Programming Language Project",
    'FRM'          => "Fallout Graphics File",
    'FLOWMAPLIBRA' => "Y'Painter Flowmap Library",
    'FWD'          => "RollerCoaster Tycoon 3 Fireworks Display File",
    'FC1'          => "FCEUX Save State File",
    'FZB'          => "Fritzing Bin File",
    'FZPZ'         => "Fritzing Bundled Part File",
    'FZBZ'         => "Fritzing Bundled Bin File",
    'FCPPROJECT'   => "Final Cut Pro Project File",
    'FCPXDEST'     => "Final Cut Pro Share Destination File",
    'FCARCH'       => "Final Cut Pro Archive",
    'FLEXOLIBRARY' => "Final Cut Pro Library Database",
    'FST'          => "FL Studio State File",
    'FFU'          => "Full Flash Update Image File",
    'FTI'          => "FamiTracker Instrument File",
    'FWTEMPLATEB'  => "Freeway Template Bundle",
    'FWACTION'     => "Freeway Action File",
    'FL1'          => "Lenovo BIOS Update File",
    'F95'          => "Fortran 95 Source Code File",
    'FUZ'          => "Bethesda Softworks Voice File",
    'FGS'          => "Fig Figure Settings File",
    'FPI'          => "Foxit Reader Plugin",
    'FLIC'         => "FLIC Animation",
    'FTF'          => "FlashTool Firmware File",
    'FSA'          => "Fragment Analysis Data File",
    'FNM'          => "Fannie Mae 1003 Data File",
    'FLIF'         => "Free Lossless Image Format File",
    'F4M'          => "Adobe Flash Media Manifest File",
    'FILM'         => "Filmkey Player Media File",
    'FDX'          => "Food Data Exchange File",
    'FPR'          => "Humanize Preset File",
    'FORM'         => "PreForm Job File",
    'FIG'          => "MATLAB Figure File",
    'FP'           => "FinePrint File",
    'FLO'          => "Automate Flowchart File",
    'FTC'          => "Dream League Soccer Asset File",
    'FDF'          => "Origin Fitting Function Definition File",
    'FIRM'         => "Boot9Strap 3DS Firmware File",
    'FBM'          => "Marine Vessel Model File",
    'FAR'          => "FARO Zone File",
    'FB2K-COMPONE' => "T'Foobar2000 Component Install File",
    'FCE'          => "Need for Speed Mesh File",
    'FLW'          => "Kivio Flow Chart",
    'FRAMESET'     => "Frame Painter for LGS Frame Set File",
    'FRW'          => "RollerCoaster Tycoon 3 Fireworks Effects File",
    'F3Z'          => "Fusion 360 Shared Project Archive",
    'FAQ'          => "Frequently Asked Questions Document",
    'FAL'          => "Bitmap Graphic Header Information",
    'FM5'          => "FileMaker 5 Database",
    'FP3'          => "FileMaker Pro 3 Database",
    'FP4'          => "FileMaker Pro 4 Database",
    'FMP'          => "FileMaker Pro Database",
    'FAC'          => "FACE Image File",
    'FACE'         => "FACE Graphic File",
    'FBM'          => "Fuzzy Bitmap Image",
    'FLP'          => "Flash Project",
    'FPK'          => "JetForm FormFlow File",
    'FXT'          => "Finale Plug-in",
    'FRL'          => "Electronic Form Loader File",
    'FCD'          => "First Choice Database",
    'FCS'          => "First Choice Spreadsheet",
    'FFF'          => "Gravis UltraSound Sound Bank",
    'FZB'          => "Casio FZ-1 Bank Dump",
    'FCD'          => "FastCAD DOS Drawing",
    'FLS'          => "ArcView GIS Windows Help Supporting File",
    'FPENC'        => "FileProtect Encrypted File",
    'FOL'          => "PFS First Choice Database File",
    'FFT'          => "Final Form Text File",
    'FNTA'         => "Aleph One Font File",
    'FT7'          => "FreeHand 7 Drawing Template",
    'FT8'          => "FreeHand 8 Template",
    'FT9'          => "FreeHand 9 Drawing Template",
    'FT10'         => "FreeHand 10 Drawing Template",
    'FFO'          => "Adobe Photoshop File Information File",
    'FPG'          => "Fenix Graphics Collection File",
    'FILA'         => "Aleph One Replay File",
    'FM3'          => "Lotus 1-2-3 Spreadsheet Format File",
    'FID'          => "Microsoft Catalog Indexing Service File",
    'FDT'          => "Impromptu Function Description Table File",
    'FFD'          => "SharePoint FFDDumper Log",
    'FFD'          => "FATE Saved Game",
    'FQC'          => "FAQ Creator File",
    'FFL'          => "Fetion Emoticons Package",
    'FMT'          => "WinRAR Format File",
    'FDA'          => "Dawn of War Audio File",
    'FWDN'         => "fWriter Document",
    'FFF'          => "MAGGI Face File",
    'F3F'          => "Crazy Machines Font File",
    'FSIF'         => "MyLabel Designer Deluxe Data File",
    'FL3'          => "Flash 3D File",
    'FIMPP'        => "FiM++ Source Code File",
    'FLG'          => "HP System Recovery Flags File",
    'FLG'          => "Puppy Linux Partition Flag File",
    'FH3'          => "FreeHand 3 Drawing File",
    'FH4'          => "FreeHand 4 Drawing File",
    'FH5'          => "FreeHand 5 Drawing File",
    'FLASH'        => "Frictional Games Flashback File",
    'FZM'          => "Fritzing Module File",
    'F2K'          => "Fortran Source Code File",
    'FILM_CPK'     => "Sega FILM Multimedia File",
    'FE_LAUNCH'    => "FCS Express Launch File",
    'FVT'          => "FAST Search & Transfer Video File",
    'FEA'          => "AFDKO Feature Definitions File",
    'GIF'          => "Graphical Interchange Format File",
    'GZ'           => "Gnu Zipped Archive",
    'GAM'          => "Saved Game File",
    'GED'          => "GEDCOM Genealogy Data File",
    'GPX'          => "GPS Exchange File",
    'GADGET'       => "Windows Gadget",
    'GBA'          => "Game Boy Advance ROM",
    'GHO'          => "Norton Ghost Backup File",
    'GRAFFLE'      => "OmniGraffle Drawing",
    'GRF'          => "DPlot Graph File",
    'GMK'          => "Game Maker Project File",
    'GCF'          => "Game Cache File",
    'GML'          => "Geography Markup Language File",
    'GEM'          => "RubyGems Package",
    'GBX'          => "Nadeo Game File",
    'GPI'          => "Garmin Point of Interest File",
    'GROUP'        => "Windows Contacts Group File",
    'GPX'          => "Guitar Pro 6 Document",
    'GCW'          => "Microsoft Mathematics Worksheet",
    'GROUPPROJ'    => "Delphi Project Group File",
    'GDOC'         => "Google Drive Document",
    'GSLIDES'      => "Google Drive Presentation",
    'GSHEET'       => "Google Drive Spreadsheet",
    'GS'           => "Google Apps Script",
    'GFAR'         => "Greenfoot Archive",
    'GMW'          => "Global Mapper Workspace File",
    'GDT'          => "gretl Datafile",
    'GDCB'         => "GandCrab Ransomware Encrypted File",
    'GID'          => "Windows Help Global Index File",
    'GZIP'         => "Gnu Zipped File",
    'GEM'          => "Ventura Publisher Document",
    'GRA'          => "Microsoft Graph File",
    'GBC'          => "Game Boy Color ROM",
    'GDS'          => "Graphic Data System File",
    'GI'           => "Global Image",
    'GP4'          => "Guitar Pro 4 Tablature",
    'GMD'          => "Game Maker Program Code",
    'GBX'          => "Gerber PCB File",
    'GORM'         => "Gorm Interface Resource File",
    'GSM'          => "Global System for Mobile Audio File",
    'GIG'          => "Tascam GigaSampler File",
    'G721'         => "G.721 Audio File",
    'G723'         => "G.723 Audio File",
    'G726'         => "G.726 Audio File",
    'GKH'          => "Ensoniq EPS Family Disk Image",
    'GCA'          => "GCA File Archive",
    'GM6'          => "GameMaker 6 Project File",
    'GAU'          => "Flight Simulator Gauge File",
    'GNE'          => "Flickr Web Page",
    'GCX'          => "Grapher Graph File",
    'GST'          => "MapInfo Geoset File",
    'GG'           => "Google Desktop Gadget File",
    'GRF'          => "Ragnarok Client Archive",
    'GP5'          => "Guitar Pro 5 Tablature File",
    'GC'           => "GraphClick File",
    'GDR'          => "Symbian OS Font File",
    'GED'          => "Game Editor Project File",
    'GB1'          => "Game Maker Backup File",
    'GS3'          => "GameStarter File",
    'GROWLREGDICT' => "Growl Temp File",
    'GPE'          => "GP2X Video Game",
    'GPU'          => "GP2X Utility Program",
    'GRK'          => "Gradekeeper Class Gradebook File",
    'GRR'          => "Gradekeeper Class Roster File",
    'GWK'          => "GraphiCode PCB Job File",
    'GB'           => "Game Boy ROM File",
    'GEDCOM'       => "GEDCOM Genealogy File",
    'G'            => "BRL-CAD Geometry File",
    'GSD'          => "General Station Description File",
    'GV'           => "Graphviz DOT File",
    'GPK'          => "WaveLab Audio Peak File",
    'GHS'          => "Norton Ghost Image Segment",
    'GTP'          => "Guitar Pro File",
    'GWS'          => "GeoMedia GeoWorkspace File",
    'GRADE'        => "GradeStat Document",
    'GROWLTICKET'  => "Growl Notification File",
    'GGB'          => "GeoGebra Document",
    'GAN'          => "GanttProject Project File",
    'GMO'          => "GNU Machine Object File",
    'GTHR'         => "Gather Log File",
    'GBR'          => "Gerber File",
    'GXD'          => "General CADD Pro Drawing",
    'GXC'          => "General CADD Pro Component",
    'GCD'          => "Generic CADD Drawing File",
    'GBI'          => "gBurner Project File",
    'GS'           => "GemStone Document",
    'GR2'          => "Granny 3D File",
    'GTS'          => "CaptiveWorks PVR Video File",
    'GSP'          => "IMail Error Message File",
    'GRD'          => "Photoshop Gradient File",
    'GWI'          => "GroupWise Database Shortcut File",
    'GRV'          => "Office Groove File",
    'GNO'          => "GenoPro Genealogy Tree File",
    'GMRES'        => "GameMaker Resource File",
    'GXT'          => "Grand Theft Auto Text File",
    'GIN'          => "GEMS Engine Control Unit File",
    'G3X'          => "RealFlight Content File",
    'GIM'          => "PlayStation Portable Image File",
    'GLS'          => "Babylon Glossary File",
    'GLD'          => "MPLAB C Compiler Linker Script File",
    'GLD'          => "Ground Loop Design Work File",
    'GIH'          => "GIMP Image Hose File",
    'GBR'          => "GIMP Brush File",
    'GPF'          => "GRAVITY Ragnarok Online Patch File",
    'GALAXY'       => "Blizzard Galaxy File",
    'GBP'          => "Genie Timeline Backup Index File",
    'GALLERY'      => "SMART Notebook Gallery File",
    'GALLERYCOLLE' => "T'ION SMART Notebook Gallery Collection File",
    'GALLERYITEM'  => "SMART Notebook Gallery Item File",
    'GPS'          => "GOM Player Skin File",
    'GROOVE'       => "ACID Groove File",
    'GPF'          => "Geosoft Project File",
    'GPBANK'       => "Guitar Pro Sound Bank File",
    'GFP'          => "GreenForce-Player Protected Media File",
    'GRP'          => "SmarterMail Group File",
    'GBS'          => "GameBoy Sound File",
    'GRB'          => "GRIB Meteorological Data File",
    'GCDP'         => "Greeting Card Studio Design Project",
    'GRF'          => "CloverDX Data Transformation Graph",
    'GSTENCIL'     => "OmniGraffle Stencil",
    'GLB'          => "STK Globe File",
    'GM81'         => "Game Maker 8.1 Project File",
    'GAL'          => "GenePix Array List File",
    'GPR'          => "GenePix Results File",
    'GUI'          => "Dr.Explain Project File",
    'GRAPHML'      => "GraphML File",
    'GSC'          => "Call of Duty Game Script",
    'GRF'          => "Grapher Graph File",
    'GPJ'          => "Grapher Project File",
    'GRD'          => "Surfer Grid File",
    'GSM'          => "MapViewer Project File",
    'GSB'          => "Golden Software Boundary File",
    'GSI'          => "Golden Software Interchange File",
    'GML'          => "Graph Modeling Language File",
    'GLA'          => "Sothink SWF Easy Project File",
    'GTKRC'        => "GTK+ Theme File",
    'GDRAW'        => "Google Drive Drawing",
    'GTABLE'       => "Google Drive Fusion Table",
    'GFORM'        => "Google Drive Form",
    'GLINK'        => "Google Drive External File Shortcut",
    'GPP'          => "Guitar Practiced Perfectly 2 Data File",
    'GITIGNORE'    => "Git Ignore File",
    'GAMEPROJ'     => "GameSalad Project File",
    'GSZIP'        => "GameSalad Marketplace Asset File",
    'GAME'         => "GameSalad Exported Game File",
    'GXK'          => "Galaxkey Secured File",
    'GCG'          => "GCG DNA Sequence File",
    'GMF'          => "Leadwerks Game Model File",
    'GSPROJ'       => "GameSalad Windows Project File",
    'G3D'          => "GOM 3D File",
    'GINSPECT_PRJ' => "GOM Inspect Project File",
    'GEOJSON'      => "GeoJSON File",
    'GEN'          => "Sega Genesis ROM",
    'GMAP'         => "Garmin Map File",
    'GBK'          => "GenBank Data File",
    'GEMSPEC'      => "Gem Specification File",
    'GEDATA'       => "Qlucore Data File",
    'GFX'          => "GFx Scaleform File",
    'GCS'          => "Cineform Studio Video Project",
    'GROOVY'       => "Groovy Source Code File",
    'GPD'          => "Generic Printer Description File",
    'GREENFOOT'    => "Greenfoot Project Archive",
    'GDI'          => "Dreamcast Gigabyte Disc Image",
    'GDB'          => "GPS Database File",
    'GCH'          => "Precompiled Header File",
    'GITATTRIBUTE' => " 'Git Attributes File",
    'GTL'          => "Gerber Top Layer Data File",
    'GBL'          => "Gerber Bottom Layer Data File",
    'GBASKIN'      => "Game Boy Advance Controller Skin File",
    'GBCSKIN'      => "Game Boy Color Controller Skin File",
    'GMA'          => "Garry's Mod Addon File",
    'GMZ'          => "Compressed GameMaker File",
    'GMX'          => "GameMaker File",
    'GSF'          => "Game Boy Advance Sound File",
    'GSFLIB'       => "Game Boy Advance Song Library",
    'GNUMERIC'     => "Gnumeric Spreadsheet",
    'GNM'          => "Gnumeric Spreadsheet",
    'GCPROJ'       => "Genome Compiler Project",
    'GB'           => "GenBank Data File",
    'GIFV'         => "GIF Video File",
    'GRIND'        => "Juice Grinder Recipe File",
    'GMP'          => "Global Mapper Package File",
    'GRINDX'       => "Juice Grinder Recipe File",
    'GDTB'         => "gretl Binary Datafile",
    'GPSCAN'       => "GrandPerspective Scan File",
    'GMBL'         => "Logger Lite Document",
    'GA3'          => "Graphical Analysis 3 Document",
    'GXF'          => "General eXchange Format File",
    'GDG'          => "GDevelop Project File",
    'GRIB2'        => "GRIB2 Meteorological Data File",
    'G2M'          => "GoToMeeting Recording File",
    'GMAP'         => "Google Drive My Map",
    'GWD'          => "Gear Watchface Design File",
    'GWB'          => "Interwrite Presentation File",
    'GITKEEP'      => "Git Keep File",
    'G64X'         => "Genetec Video File",
    'GVDESIGN'     => "Gravit Designer File",
    'GLTF'         => "GL Transmission Format File",
    'GLB'          => "Binary GL Transmission Format File",
    'GSP'          => "Groovy Server Page",
    'GRADLE'       => "Gradle Script",
    'GP4'          => "CCITT Group 4 Fax File",
    'GLY'          => "Word Glossary File",
    'GRP'          => "Windows Program Manager Group",
    'GMF'          => "Geology Multi-File",
    'GRIB'         => "Gridded Binary File",
    'GCD'          => "Prassi CD Image",
    'GDB'          => "InterBase Database File",
    'GPG'          => "GNU Privacy Guard Public Keyring",
    'GVP'          => "Google Video Pointer",
    'GPN'          => "GlidePlan Map Document",
    'GEM'          => "GEM Metafile",
    'GSM'          => "Graphic Description Language File",
    'GSD'          => "Graphtec Vector Graphics File",
    'GXL'          => "Graph Exchange Language File",
    'GEO'          => "VRML Geography File",
    'GZI'          => "Unix Gzip File",
    'GP3'          => "Guitar Pro 3 File",
    'GAME'         => "Apple Chess Saved Game",
    'GEN'          => "ArcView ARC/INFO UnGenerate file",
    'GRO'          => "Graphic Object Bitmap",
    'GLS'          => "GLScript Game Script",
    'GCM'          => "GameCube ROM",
    'GCI'          => "GameCube Save File",
    'GPD'          => "Graphic PhotoDefiner Image File",
    'GRN'          => "Granny 3D File",
    'GLADE'        => "Glade Project File",
    'GTP'          => "GNOME Theme Package File",
    'GSP'          => "Geometer's Sketchpad File",
    'GPS'          => "GenePix Settings File",
    'GPS'          => "Survey Pro Coordinate File",
    'GML'          => "GameMaker Language File",
    'GWP'          => "Greetings Workshop Project File",
    'GPR'          => "Babylon Glossary Builder Project File",
    'GPF'          => "Gecko Patch File",
    'GPF'          => "Grant Agreement Preparation Form",
    'GBAS'         => "GLBasic Source File",
    'GBAP'         => "GLBasic Project File",
    'GMBCK'        => "Game Maker Background Image File",
    'GS'           => "Geosoft Script",
    'GWS'          => "Geosoft Workspace File",
    'GMMP'         => "WCS Gamut Map Model Profile",
    'GBPROJ'       => "GarageBand Project",
    'GRF'          => "Transport Tycoon Graphics Resource File",
    'GRP'          => "StarCraft Graphics Group File",
    'GDRIVE'       => "Gizmo Virtual Drive File",
    'GG'           => "Sega Game Gear ROM",
    'GAR'          => "GridGain Archive",
    'GAR'          => "Farming Simulator Game Archive File",
    'GPRX'         => "Geoxa Project File",
    'GFIE'         => "Greenfish Icon Editor Pro Graphic",
    'GF'           => "METAFONT Bitmap File",
    'GOOMOD'       => "World of Goo Add-on",
    'GMT'          => "rFactor Model File",
    'GTEMPLATE'    => "OmniGraffle Template",
    'GDF'          => "GUESS Graph Data Format File",
    'GLB'          => "Glulx Blorb Game File",
    'GME'          => "DexDrive Game Card File",
    'GLOX'         => "Microsoft Office SmartArt Graphics Layout File",
    'GCSX'         => "Microsoft Office SmartArt Color File",
    'GQSX'         => "Microsoft Office SmartArt Styles File",
    'GMMOD'        => "Game Maker 3D Model File",
    'GZ2'          => "Misnamed BZ2 File",
    'GPJ'          => "MULTI IDE Project File",
    'GRT'          => "Grapher Template",
    'GSR'          => "Golden Software Reference File",
    'GSR2'         => "Golden Software Reference File",
    'GEXF'         => "Graph Exchange XML Format File",
    'GRAPHMLZ'     => "Zip Compressed GraphML File",
    'GLS'          => "Sothink SWF Easy Shape File",
    'GXF'          => "General CADD Pro Font File",
    'GXM'          => "General CADD Pro Macro File",
    'GXH'          => "General CADD Pro Hatch Pattern File",
    'GDFMAKERPROJ' => "C'T   GDF Editor Project File",
    'GLO'          => "RoboHelp Glossary File",
    'GMSPR'        => "Game Maker Sprite File",
    'GFW'          => "GIF World File",
    'GSX'          => "Sega Genesis Emulator Saved State File",
    'GS0'          => "Sega Genesis Emulator Quick Slot 0 Save File",
    'GOD'          => "God Configuration File",
    'GTA'          => "Microsoft Groove Tool Archive",
    'GADGEPRJ'     => "Gadge It Project",
    'GVIMRC'       => "GVim Runtime Configuration File",
    'GTM'          => "GreekToMe Translation File",
    'G3A'          => "Casio Prizm Add-in File",
    'GCZ'          => "Compressed GameCube/Wii ROM",
    'GUIDES'       => "xScope Guides File",
    'GGR'          => "GIMP Gradient File",
    'GVY'          => "Groovy Source Code File",
    'GSBA'         => "Game Save Backup Archive",
    'GLM'          => "Ghoul 2 Model File",
    'GLA'          => "Ghoul 2 Animation File",
    'GTS'          => "Gerber Top Solder Mask Data File",
    'GBS'          => "Gerber Bottom Solder Mask Data File",
    'GFE'          => "Glarysoft Encrypted File",
    'GFS'          => "Glarysoft Split File",
    'GO'           => "Go Source Code File",
    'GBLORB'       => "Glulx Blorb Game File",
    'GBO'          => "Gerber Bottom Overlay Data File",
    'GTO'          => "Gerber Top Overlay Data File",
    'GTP'          => "Gerber Top Solder Paste Data File",
    'GBP'          => "Gerber Bottom Solder Paste Data File",
    'GML'          => "Gerber Mill Layer File",
    'GPI'          => "Gerber Photoplotter Information File",
    'GMD'          => "GroupMail Message",
    'GB2'          => "Game Maker Backup File",
    'GBR'          => "Gameboy Tileset File",
    'GBM'          => "Gameboy Map File",
    'GCD'          => "Fallout 2 Character Profile File",
    'GBS'          => "Generic Build Support Metadata File",
    'GRADIENTLIBR' => "R'Y   Painter Gradient Library",
    'GMC'          => "Game Music Creator Sound File",
    'GLKSAVE'      => "Zoom Game Save Package",
    'GFI'          => "GIFI File",
    'GOD'          => "Gore Game Data File",
    'GYM'          => "Sega Genesis Sound File",
    'G64'          => "Genetec Video File",
    'GENBANK'      => "GenBank Data File",
    'GDG.AUTOSAVE' => "GDevelop Project Autosave File",
    'GPD'          => "Gamer Profile Data File",
    'GRP'          => "Ken Silverman's Build Engine Group File",
    'GSP'          => "Silhouette Studio SD Card Document",
    'GHB'          => "Lego Ghost Path File",
    'GRDB'         => "Gramps Database File",
    'GVSP'         => "Geocortex Viewer for Silverlight Project",
    'GEO'          => "TruTops Geometry File",
    'GENERICTEST'  => "Visual Studio Generic Test File",
    'GTM'          => "GPS TrackMaker Data File",
    'GENOME'       => "Cell Lab Design File",
    'GDBTABLE'     => "Geodatabase Table File",
    'GOFIN'        => "DRUKI Gofin Form File",
    'GS-BCK'       => "Genius Scan Backup File",
    'GCODE'        => "G-Code 3D Printer File",
    'GVSWATCH'     => "Gravit Designer Swatch File",
    'GZQUAR'       => "Bitdefender Antivirus Quarantine File",
    'GTWORLD'      => "Growtopia World File",
    'GFB'          => "GIFBlast Compressed Image File",
    'GVI'          => "Google Video File",
    'GRF'          => "Generic Graph File",
    'GKS'          => "Graphics Kernel System File",
    'GL'           => "GRASP Animation",
    'GRASP'        => "GRASP Animation",
    'GRY'          => "Grayscale Image",
    'GNP'          => "GNPeak Output File",
    'GLOBAL'       => "Global Makefile",
    'GIO'          => "Adagio Score",
    'GIO'          => "Nyquist MIDI File",
    'GSM'          => "US Robotics GSM Audio File",
    'GMS'          => "Gesture and Motion Signal File",
    'GROB'         => "Graphic Object Bitmap File",
    'GCS'          => "GameCube SharkSave File",
    'GRL'          => "Windows Update Status File",
    'GMV'          => "Gens Game Recording",
    'GC'           => "Galactic Conquest Saved Game",
    'GNUTAR'       => "GNU Tar Archive",
    'GTAR'         => "GNU Tar Archive",
    'GIS'          => "CFS Console Game Installer Settings File",
    'GZA'          => "IZArc BGA Archive File",
    'GCT'          => "Ocarina Cheat Code Manager File",
    'GDIAGRAMSTYL' => " 'OmniGraffle Diagram Style File",
    'G41'          => "Commodore 1541 Disk Image",
    'GDW'          => "Jaws Unleashed Data File",
    'GM'           => "GameMonkey Script",
    'GM'           => "Transport Tycoon Music File",
    'GRO'          => "Allegro MIDI File",
    'GNP'          => "GenePool Save File",
    'GPJ'          => "jGRASP Project File",
    'G3'           => "CCITT Group 3 Fax Image",
    'GJD'          => "The 7th Guest Media File",
    'GOM'          => "GOM Media File",
    'GOD'          => "Populous II Player Progress File",
    'GLF'          => "Space Engine Shader File",
    'GAMEDATA'     => "Sandlot Game Data File",
    'GNUMAKEFILE'  => "GNU Makefile",
    'GRADIENTS'    => "Painter Gradation Library",
    'GDOCX'        => "Google Drive Document",
    'GLIF'         => "Glyph Interchange Format File",
    'HTM'          => "Hypertext Markup Language File",
    'HTML'         => "Hypertext Markup Language File",
    'HQX'          => "BinHex 4.0 Encoded File",
    'H'            => "C/C++/Objective-C Header File",
    'HLP'          => "Windows Help File",
    'HDF'          => "Hierarchical Data Format File",
    'HTACCESS'     => "Apache HTACCESS File",
    'HPP'          => "C++ Header File",
    'HDP'          => "HD Photo File",
    'HPL'          => "HP-GL Plotter File",
    'HCP'          => "HydroCAD Project File",
    'HDMOV'        => "QuickTime HD Movie File",
    'HME'          => "Windows Mobile Theme File",
    'HFD'          => "HotDocs Form Document",
    'HFT'          => "HotDocs Form Template",
    'HPD'          => "HotDocs PDF Document",
    'HPT'          => "HotDocs PDF Template",
    'HYPE'         => "Hype Document",
    'H12'          => "At Home Canada 2012 Tax Return",
    'H13'          => "H&R Block Canada 2013 Tax Return",
    'H17'          => "H&R Block Canada 2017 Tax Return",
    'HH'           => "C++ Header File",
    'HTA'          => "HTML Application",
    'HTX'          => "HTML Extension File",
    'HGL'          => "HP Graphics Language File",
    'HPGL'         => "HP Graphics Language Plotter File",
    'HHC'          => "HTML Help Table of Contents",
    'HHK'          => "HTML Help Index",
    'HMX'          => "Help & Manual 4 Project",
    'HUS'          => "Husqvarna Embroidery File",
    'HLX'          => "ATI Radeon Video Driver Support File",
    'HDL'          => "HotDocs Library File",
    'HIT'          => "The Sims Sound File",
    'HOT'          => "The Sims Sound File",
    'HIP'          => "Houdini Project File",
    'HIPNC'        => "Houdini Apprentice File",
    'HKI'          => "WinHKI Archive",
    'HKI1'         => "WinHKI HKI1 Archive",
    'HKI2'         => "WinHKI HKI2 Archive",
    'HKI3'         => "WinHKI HKI3 Archive",
    'HS'           => "Haskell Script",
    'HAS'          => "Haskell Script",
    'HMK'          => "Hallmark Card Studio File",
    'HXS'          => "Help 2 Compiled Help File",
    'HDMP'         => "Windows Heap Dump",
    'HID'          => "Sony Ericsson Remote Settings File",
    'HS'           => "Motorola Flash Flex File",
    'HDR'          => "High Dynamic Range Image File",
    'HEX'          => "Hexadecimal Source File",
    'HEX'          => "BinHex Encoded File",
    'HL'           => "HeuristicLab Storage File",
    'HPI'          => "Hemera Photo Objects Image File",
    'HTT'          => "Hypertext Template File",
    'HHT'          => "Help and Support Center HHT File",
    'H3M'          => "Heroes 3 Map File",
    'HR2'          => "Poser Hair File",
    'HRZ'          => "Compressed Poser Hair File",
    'HD2'          => "Poser Hand Pose File",
    'HDZ'          => "Compressed Poser Hand Pose File",
    'H4R'          => "Heroes of Might and Magic IV Data File",
    'HS'           => "Java HelpSet File",
    'HPJ'          => "Help Project File",
    'HST'          => "History File",
    'HBC'          => "HyperBac Compressed Archive",
    'HDD'          => "Parallels Desktop Hard Disk File",
    'HML'          => "HostMonitor TestList File",
    'HMS'          => "HostMonitor Script File",
    'HKM'          => "Havok Movie File",
    'HPF'          => "High Performance Fortran File",
    'HDA'          => "HotDocs Auto-Assemble File",
    'HS2'          => "HyperRESEARCH 2 Study File",
    'HCR'          => "HydroCAD Rainfall Curve Data File",
    'HCE'          => "HydroCAD Hydrograph Data File",
    'HUH'          => "HydroCAD Unit Hydrograph Definitions File",
    'HCI'          => "HydroCAD IDF Data File",
    'HCU'          => "Hydrograph Units Definitons File",
    'HCC'          => "HydroCAD Prefab Chamber Data File",
    'HPG'          => "HPGL Plot File",
    'HYV'          => "Team Manager Meet Event File",
    'HAL'          => "HansaWorld Application Language File",
    'HDB'          => "HansaWorld Database File",
    'HXX'          => "C++ Source Code Header File",
    'HWP'          => "Hanword Document",
    'HGT'          => "SRTM Elevation Data File",
    'HSB'          => "HALion Sound Bank File",
    'HT'           => "HyperTerminal Session File",
    'HELP'         => "Mac OS X Help Book",
    'HFV'          => "HFS Disk Image",
    'HONMOD'       => "HON Modification Manager File",
    'HCL'          => "HotDocs Clause Archive",
    'HAL'          => "HotDocs Answer Library",
    'HIV'          => "Windows Registry Hive File",
    'HMXZ'         => "Help & Manual Compressed Project",
    'HMXP'         => "Help & Manual XML Project",
    'HSF'          => "HOOPS Stream Format File",
    'H10'          => "At Home Canada 2010 Tax Return",
    'HXN'          => "Hexagon Model File",
    'HOL'          => "Outlook Holidays File",
    'HDS'          => "Microsoft PlayReady Data File",
    'HDS'          => "Parallels Desktop Hard Disk File",
    'HPS'          => "HPL Script",
    'HDI'          => "Hard Disk Image",
    'HTMLZ'        => "Zipped HTML eBook",
    'H1S'          => "Windows Assistance Platform Help File",
    'HLSL'         => "High Level Shader Language File",
    'HSC'          => "Aspen HYSYS Simulation File",
    'HDRP'         => "HDRtist Pro Document",
    'H11'          => "At Home Canada 2011 Tax Return",
    'HDV'          => "High Definition Video Format",
    'HTPASSWD'     => "Apache HTACCESS File",
    'HBS'          => "Handlebars Template",
    'HUM'          => "OMSI Human Configuration File",
    'H5E'          => "Line 6 POD HD500 Edit Preset File",
    'H5B'          => "Line 6 POD HD500 Edit Bundle",
    'H5S'          => "Line 6 POD HD500 Edit Setlist File",
    'H4B'          => "Line 6 POD HD400 Edit Bundle",
    'HBE'          => "Line 6 POD HD Edit Preset File",
    'HAML'         => "Haml Source Code File",
    'HIN'          => "HyperChem Input File",
    'H14'          => "H&R Block Canada 2014 Tax Return",
    'HYPETEMPLATE' => "Hype Document Template",
    'HYPESYMBOL'   => "Hype Symbol File",
    'HYPERESOURCE' => " 'Hype Resources Folder",
    'H15'          => "H&R Block Canada 2015 Tax Return",
    'H5U'          => "Heroes of Might and Magic V Mod File",
    'H16'          => "H&R Block Canada 2016 Tax Return",
    'H5'           => "Hierarchical Data Format 5 File",
    'HEIC'         => "High Efficiency Image Format",
    'HCXS'         => "Canadian Product Incident Report Form",
    'HD3D'         => "Home Design 3D Project",
    'HCA'          => "High Compression Audio File",
    'HHH'          => "Power C Precompiled Header File",
    'HAM'          => "Descent 2 Resource File",
    'HOG'          => "Descent Mission File",
    'HZ'           => "Chinese (Hanzi) Text",
    'HM3'          => "Help & Manual 3 Project",
    'HIS'          => "FindinSite Database Definition File",
    'HBC2'         => "HyperBac Compressed File Archive",
    'HBE'          => "HyperBac Compressed and Encrypted Archive",
    'HDML'         => "Handheld Device Markup Language File",
    'HDI'          => "HotDocs Auto-Install File",
    'HTC'          => "HTML Component File",
    'HCR'          => "Half-Fold Card File",
    'HMA'          => "Sony HI-MD Audio File",
    'HTG'          => "HackTheGame Mission Pack",
    'HDP'          => "MAGIX Hard Disk Project Audio File",
    'H0'           => "Movie Edit Pro Waveform Information File",
    'HKDB'         => "Apple iTunes Library File",
    'HVPL'         => "iTunes Visual Plug-in File",
    'HYP'          => "Dictionary Information File",
    'HI'           => "MacMAME High Scores File",
    'HWMAP'        => "Hedgewars Drawn Map File",
    'H2O'          => "Battle Realms Game Data File",
    'H264'         => "H.264 Encoded Video File",
    'HDK'          => "HotDocs Registration File",
    'HDPMX'        => "HotDocs Publisher Mapping XML File",
    'HDUMX'        => "HotDocs User Mapping XML File",
    'HVC'          => "HotDocs Variable Collection File",
    'HYDRA'        => "Hydra Image Filter Program File",
    'HDR'          => "ESRI BIL Header File",
    'HWS'          => "Hedgewars Saved Game",
    'HWD'          => "Hedgewars Demo File",
    'HEARTSSAVE-M' => " 'Microsoft Hearts Save File",
    'HRL'          => "Erlang Header File",
    'HXA'          => "Microsoft Help 2 Attribute Definition File",
    'HXC'          => "Microsoft Help 2 Collection Definition File",
    'HXE'          => "Microsoft Help 2 Sample Definition File",
    'HXK'          => "Microsoft Help 2 Index File",
    'HXT'          => "Microsoft Help 2 Table of Contents File",
    'HDT'          => "Photoshop HDR Toning Preset File",
    'HPS'          => "HP Digital Sender Metadata File",
    'HTZ5'         => "HyperMaker 5 Publication",
    'HFS'          => "HFS Disk Image File",
    'HTXT'         => "Hanvon eBook File",
    'HTML0'        => "Book Designer File",
    'HJT'          => "TreePad 6 Database File",
    'HPK'          => "Tropico Game Archive",
    'HBK'          => "Mathcad Handbook File",
    'HANDLEBARS'   => "Handlebars Template",
    'HBS'          => "Line 6 POD HD Edit Setlist File",
    'H4E'          => "Line 6 POD HD400 Edit Preset File",
    'H3B'          => "Line 6 POD HD300 Edit Bundle",
    'H3E'          => "Line 6 POD HD300 Edit Preset File",
    'HBB'          => "Line 6 POD HD Edit Bundle",
    'HPS'          => "GameCube Audio File",
    'HE0'          => "Humongous Entertainment Game Archive",
    'HE1'          => "Humongous Entertainment Game Archive",
    'HE2'          => "Humongous Entertainment Game Archive",
    'H2P'          => "Zebra2 Preset",
    'HE'           => "Humongous Entertainment Game Archive",
    'H6X'          => "Soft6502 Trainer/Simulator Hex File",
    'HPR'          => "Internal RoboHelp File",
    'HCD'          => "Samsung Android Firmware File",
    'HQM'          => "Hardcore Questing Mode Data File",
    'H5M'          => "Heroes of Might and Magic V Map",
    'HAN'          => "Amazon Kindle eBook Data File",
    'HWDT'         => "Thinkfree Office NEO Word Template",
    'HCDT'         => "Thinkfree Office NEO Cell Template",
    'HSDT'         => "Thinkfree Office NEO Show Template",
    'H2W'          => "H2testw File",
    'HHP'          => "HTML Help Workshop Project",
    'H4'           => "Hierarchical Data Format File",
    'HOW2'         => "Visma Performit Player Configuration File",
    'HC'           => "VeraCrypt Container File",
    'HAT'          => "Duck Game Hat File",
    'HEIF'         => "High Efficiency Image Format",
    'HAT'          => "A Hat in Time Save File",
    'HE4'          => "Humongous Entertainment Sound Archive",
    'HOF'          => "OMSI Map Parameter File",
    'HEVC'         => "High Efficiency Video Coding File",
    'HPKG'         => "Haiku Package File",
    'HVIF'         => "Haiku Vector Icon File",
    'HA'           => "HA Compressed Archive",
    'HXM'          => "Descent 2 Resource Modification",
    'HLB'          => "VMS / VAX Help Library",
    'HPK'          => "HPack Compressed Archive",
    'HRF'          => "Hitachi Raster Format File",
    'HYP'          => "HYPER Compressed Archive",
    'HIF'          => "Quicken Online File",
    'HR'           => "TRS-80 Image",
    'HWP'          => "Hangul (Korean) Text Document",
    'HF'           => "HF Image",
    'HCX'          => "ChartXL Chart",
    'HTZ4'         => "HyperMaker 4 Publication",
    'HPF'          => "HP9100A Program File",
    'HDM'          => "HDML File",
    'H1Q'          => "Microsoft Help Merged Query Index File",
    'HSK'          => "Huskey Truss & Building Supply Import File",
    'HMT'          => "HighMAT File",
    'HBX'          => "BinHex Encoded File",
    'HHSL'         => "Hockey High Score List File",
    'HTB'          => "Audacity Help File",
    'HAM'          => "HAM Executable File",
    'HSH'          => "Windows Catalog Search Index File",
    'HPP'          => "Haluha Pearls File",
    'HS'           => "LaserTank High Scores File",
    'HMP'          => "Worms Height Map File",
    'HMI'          => "HMI Audio File",
    'HCF'          => "Compact Ham Library",
    'HDX'          => "Delphi MultiHelp Index File",
    'HELPINDEX'    => "Help Index Document",
    'HID'          => "KeepSafe File",
    'HID2'         => "KeepSafe File",
    'H2O'          => "H2OMAP Master Project",
    'H77T'         => "MGD77T Header File",
    'HAAS'         => "Everfine LED Lamp Test Results File",
    'ICO'          => "Icon File",
    'INDD'         => "Adobe InDesign Document",
    'INI'          => "Windows Initialization File",
    'ISO'          => "Disc Image File",
    'IFF'          => "Interchange File Format",
    'ICS'          => "Calendar File",
    'ICNS'         => "Mac OS X Icon Resource File",
    'IBOOKS'       => "Multi-Touch iBook",
    'IMG'          => "Macintosh Disk Image",
    'INF'          => "Setup Information File",
    'IDW'          => "Inventor Drawing",
    'ICC'          => "ICC Profile",
    'IMG'          => "Disc Image Data File",
    'INX'          => "Adobe InDesign Interchange File",
    'ICA'          => "Citrix ICA File",
    'IMOVIEPROJ'   => "iMovie Project File",
    'IAM'          => "Inventor Assembly File",
    'IPT'          => "Inventor Part File",
    'IWD'          => "Call of Duty Game Data File",
    'IML'          => "IntelliJ IDEA Module",
    'IPA'          => "iOS Application",
    'II'           => "IconWorkshop Extended Information File",
    'ID2'          => "Windows Live Messenger Emoticon File",
    'ITC2'         => "iTunes Cover Flow Data File 2",
    'ISD'          => "Flexera InstallShield Dialog Box File",
    'IPX'          => "IPIX Image",
    'IV'           => "Open Inventor Scene Graph File",
    'ISE'          => "InstallShield Express Project File",
    'IDML'         => "Adobe InDesign Markup Language File",
    'IDX'          => "Movie Subtitle File",
    'IDPP'         => "Adobe InDesign Preflight Profile",
    'INS'          => "Internet Settings File",
    'ISMV'         => "IIS Smooth Streaming Video File",
    'ISM'          => "IIS Smooth Streaming Manifest File",
    'IBA'          => "iBooks Author Document",
    'ITMSP'        => "iTunes Store Package",
    'IMA'          => "Sage ACT! Email Message",
    'IN'           => "Input File",
    'IADPROJ'      => "iAd Producer Project",
    'IPF'          => "SMS Installer Script",
    'IDX'          => "Index File",
    'INC'          => "Include File",
    'IVT'          => "Beyond 20/20 Table File",
    'IBT'          => "Texture and Model File",
    'INX'          => "Compiled Script",
    'IFO'          => "DVD-Video Disc Information File",
    'IGS'          => "IGES Drawing File",
    'IMA'          => "Disk Image",
    'IMAGE'        => "Apple Disk Image",
    'ITHMB'        => "iPod and iPhone Photo Thumbnails File",
    'IB'           => "InterBase Database",
    'INP'          => "Abaqus Input File",
    'ION'          => "File Description File",
    'ISS'          => "InstallShield Silent Response File",
    'ICS'          => "IC Recorder Sound File",
    'INDT'         => "Adobe InDesign Template",
    'IMOVIEPROJEC' => " 'iMovie Project",
    'IMAPMBOX'     => "IMAP Mailbox",
    'INETLOC'      => "Internet Location",
    'IDX'          => "HMI Historical Log Index File",
    'ING'          => "MasterCook Ingredients File",
    'IBP'          => "IsoBuster Managed Image Information File",
    'IBQ'          => "IsoBuster Managed Image File",
    'INI'          => "Gravis UltraSound Bank Setup File",
    'ITI'          => "Impulse Tracker Instrument",
    'ICE'          => "ICE File Archive",
    'IPK'          => "Itsy Package",
    'IDX'          => "Outlook Express Mailbox Index File",
    'INK'          => "Mimio Ink Data File",
    'IZZ'          => "Isadora Media Control Project",
    'IZZY'         => "Isadora Project",
    'I00'          => "DVD Shrink Part 1 File",
    'I01'          => "DVD Shrink Part 2 File",
    'I02'          => "DVD Shrink Part 3 File",
    'IDC'          => "Internet Database Connector File",
    'IPS'          => "Internal Patching System Patch File",
    'IGC'          => "Anime List Builder Input File",
    'IIF'          => "Intuit Interchange Format File",
    'INFO'         => "ZoomBrowser Image Index File",
    'ITN'          => "TomTom Navigator Itinerary File",
    'ICM'          => "Image Color Matching Profile",
    'ITW'          => "InTouch With Database File",
    'ISZ'          => "Zipped ISO Disk Image",
    'IROCK'        => "intelliRock Sensor Data File",
    'INI'          => "Symbian OS Configuration File",
    'IV2I'         => "Norton Ghost Incremental Virtual Volume Image",
    'IXA'          => "Ulead Disc Image format",
    'ITL'          => "iTunes Library File",
    'ISF'          => "Inspiration Flowchart Document",
    'ISR'          => "GoMoku Game File",
    'ISU'          => "InstallShield Uninstaller Script",
    'IN'           => "Spyware File",
    'IMY'          => "iMelody Ringtone File",
    'IPG'          => "iPod Game File",
    'I5Z'          => "IUCLID 5 Import/Export File",
    'ITC'          => "iTunes Cover Flow Data File",
    'IDX0'         => "Runescape Cache Index File",
    'IDX255'       => "Runescape Cache File",
    'ID'           => "Lotus Notes User ID File",
    'ITX'          => "ITX Form Template",
    'IDB'          => "Visual Studio Intermediate Debug File",
    'IPSW'         => "iPod and iPhone Software Update File",
    'IVR'          => "Internet Video Recording",
    'IWS'          => "IntelliJ IDEA Web Page",
    'IHX'          => "IN-HEH Timeline Database",
    'IHW'          => "IN-HEH Timeline Workspace",
    'ICS'          => "IronCAD 3D Drawing File",
    'ICD'          => "Installable Client Driver File",
    'ICD'          => "SafeDisc Encrypted Program",
    'IPD'          => "BlackBerry Backup File",
    'IP'           => "IconPackager Theme File",
    'ICL'          => "Windows Icon Library File",
    'IDLK'         => "Adobe InDesign Lock File",
    'ITDB'         => "iTunes Database File",
    'IDX'          => "Navigation POI File",
    'IIM'          => "iMacro Macro File",
    'ITM'          => "iThink Model File",
    'ICONTAINER'   => "CandyBar iContainer File",
    'IMT'          => "My Time Data File",
    'IIP'          => "Install Creator Pro Project File",
    'ISS'          => "Inno Setup Script",
    'IXB'          => "Ulead Disc Image",
    'ISM'          => "InstallShield Project File",
    'IST'          => "InstallShield Project Template File",
    'IPR'          => "InstallShield Professional Project File",
    'ICONPACKAGE'  => "IconPackager Theme File",
    'IFC'          => "Industry Foundation Classes File",
    'ITA'          => "IconTweaker Theme Archive",
    'ITT'          => "IconTweaker Theme File",
    'IES'          => "IES Photometric Data File",
    'INDS'         => "Adobe InDesign Snippet File",
    'IDMS'         => "Adobe InDesign Snippet",
    'INCA'         => "InCopy CS3 Assignment File",
    'INCX'         => "InCopy CS3 Interchange File",
    'ICMA'         => "InCopy Assignment File",
    'ICML'         => "InCopy Document",
    'ICAP'         => "InCopy Package File",
    'IDAP'         => "Adobe InDesign Assignment Package",
    'INDL'         => "Adobe InDesign Library",
    'IX2'          => "WordPerfect Address Book File",
    'IMI'          => "Magellan Map File",
    'IMG'          => "ERDAS IMAGINE Image File",
    'IPN'          => "Inventor Presentation File",
    'INX'          => "Inkscape Extension Descriptor File",
    'INL'          => "C++ Inline File",
    'IDL'          => "Interface Definition Language File",
    'IVE'          => "OpenSceneGraph Binary File",
    'IBCD'         => "InstantBingoCard Document",
    'ITE'          => "iTunes Extras File",
    'ITLP'         => "iTunes LP Album File",
    'IRS'          => "Adobe Save For Web Settings",
    'IPMETA'       => "Apple iPhoto Metadata File",
    'I'            => "Visual Studio Intermediate File",
    'INDB'         => "Adobe InDesign Book File",
    'INLK'         => "Adobe InDesign Lock File",
    'ICBU'         => "Calendar Backup File",
    'ISH1'         => "Animation-ish Wiggledoodle-ish Document",
    'ISH2'         => "Animation-ish FlipBook-ish Document",
    'ISH3'         => "Animation-ish Advanced-ish Document",
    'INFO'         => "Generic Information File",
    'IBPLUGIN'     => "Interface Builder Plug-in",
    'IPR'          => "IntelliJ IDEA Project File",
    'ICURSORFX'    => "iCursor Effect File",
    'IPF'          => "iMPACT Project File",
    'IMG'          => "Grand Theft Auto Data File",
    'IFL'          => "3ds Max Image File List",
    'IDE'          => "Inventor iFeature File",
    'IDV'          => "Inventor Design View File",
    'IPJ'          => "Inventor Project File",
    'IWDGT'        => "iWeb Widget File",
    'IWI'          => "Infinity Ward Texture File",
    'ILK'          => "Incremental Linking File",
    'IPCH'         => "Intellisense Precompiled Header File",
    'IDT'          => "Windows Installer Database Text Archive File",
    'IGP'          => "Igor Published Music Notation File",
    'I3D'          => "Houdini Image 3D File",
    'IMR'          => "Impromptu Report File",
    'INS'          => "LaTeX Installer Script",
    'ISE'          => "Xilinx ISE Project",
    'IVS'          => "Initialization Vector File",
    'IGX'          => "iGrafx Document",
    'IPL'          => "GTA Item Placement File",
    'ITEMDATA-MS'  => "Windows 8 Start Screen Item Data File",
    'ISMA'         => "IIS Smooth Streaming Audio File",
    'ISMC'         => "Smooth Streaming Client Manifest File",
    'INO'          => "Arduino Sketch File",
    'IBATEMPLATE'  => "iBooks Author Document Template",
    'IDB'          => "IDA Database File",
    'ISO'          => "Arbortext IsoDraw Document",
    'IDEA'         => "Adobe Ideas Document",
    'IUS'          => "InfoTMIC Firmware Update File",
    'IRCP'         => "SpeedGrade IRIDAS Composite File",
    'INDESIGNPLUG' => "N'Adobe InDesign Plug-in",
    'IMG3'         => "iPhone IMG3 File",
    'IVD'          => "Bitdefender Incremental Virus Definitions",
    'IGG'          => "SuiteProfiler Color Map File",
    'IFD'          => "InForm Document",
    'IIQ'          => "Phase One RAW Image",
    'ISPC'         => "Image Surfer Pro Collection File",
    'IGM'          => "Indigo Renderer Material File",
    'IGS'          => "Indigo Renderer Scene File",
    'IFS'          => "InfoSlips Package",
    'IBB'          => "ImgBurn Project File",
    'INFO'         => "Drupal Module Information File",
    'ICG'          => "Image Comparer Gallery File",
    'ICR'          => "Image Comparer Results File",
    'INF_LOC'      => "Windows Driver Information Cache File",
    'IPSPOT'       => "iPhoto Spot File",
    'ICD'          => "IronCAD 3D Drawing File",
    'IC3D'         => "IC3D Scene File",
    'INS'          => "Adlib Tracker Instrument File",
    'IPCC'         => "iPhone Carrier Bundle",
    'ICMT'         => "InCopy Template",
    'ICST'         => "InCopy Document Preset File",
    'IRRMESH'      => "Irrlicht Static Mesh File",
    'IRR'          => "Irrlicht 3D Scene",
    'IKMP'         => "IK Multimedia Preset FIle",
    'INFORM'       => "Inform Project",
    'IDI'          => "EVA Controller Event Log",
    'ISALETEMPLAT' => " 'iSale Template",
    'ISALE'        => "iSale Auction",
    'IMX'          => "iMindMap Map File",
    'IMTX'         => "iMindMap Template File",
    'IWB'          => "IWBasic Source Code File",
    'ICONSET'      => "Mac OS X Icon Set Folder",
    'IWA'          => "iWork Archive File",
    'IMOVIEMOBILE' => "iOS iMovie Project File",
    'INP'          => "gretl Script File",
    'INFO'         => "Minecraft Forge Information File",
    'ISX'          => "SimulationX Project",
    'IPYNB'        => "Jupyter Notebook",
    'IS2'          => "Thermal Image Data File",
    'IVF'          => "Indeo Video Format File",
    'INS'          => "Internet Naming Service File",
    'IGES'         => "IGES File",
    'ISP'          => "IIS Internet Service Provider Settings",
    'ISN'          => "Installer Source File",
    'INK'          => "Pantone Reference File",
    'ICN'          => "Windows Icon File",
    'ICA'          => "Image Object Content Architecture File",
    'IML'          => "ACT! Internet Mail Message",
    'ILBM'         => "Interleaved Bitmap Image",
    'IQY'          => "Internet Query",
    'IT'           => "Impulse Tracker Module",
    'IVR'          => "Image Worlds File",
    'ISC'          => "Xilinx Device Configuration File",
    'INS'          => "Sample Cell II Instrument Definition File",
    'ITS'          => "Impulse Tracker Sample",
    'I'            => "INTERCAL Source File",
    'ICON'         => "Icon Image File",
    'IPF'          => "Interchangeable Preservation File",
    'INT'          => "SGI Integer Image",
    'ISO'          => "PlayStation 2 ROM File",
    'IND'          => "Memory Stick Formatting File",
    'IIP'          => "ThinAnywhere Configuration File",
    'IRR'          => "Brewer Lamp File",
    'INS'          => "Inspiration File",
    'ILDOC'        => "QuickSilver Document",
    'IW'           => "Chain Engineering Database File",
    'IVA'          => "Surveillance Video File",
    'IMG'          => "Garmin Map File",
    'IAF'          => "Outlook Internet Account File",
    'IIT'          => "Install Creator Project File",
    'IX'           => "dtSearch Index File",
    'IWZ'          => "InstallShield Express 2 Project File",
    'IPTHEME'      => "IconPackager Raw Theme File",
    'IPP'          => "Inline Guard Macro File",
    'IMP'          => "Audition Impulse File",
    'IPROJECT'     => "iClone Project File",
    'IRP'          => "Internet Researcher Project File",
    'INCT'         => "InCopy Template",
    'INCP'         => "InCopy CS3 Package File",
    'INDP'         => "Adobe InDesign CS3 Package File",
    'IUP'          => "Fritz Update File",
    'INV'          => "INVedit File",
    'ITMS'         => "iTunes Music Store Link File",
    'ITPC'         => "iTunes Podcast Link File",
    'IROS'         => "Adobe Save For Web Settings File",
    'IDPK'         => "Adobe InDesign Package for GoLive File",
    'INCD'         => "InCopy Document",
    'INDK'         => "Adobe Shortcut Set File",
    'INMS'         => "Adobe InDesign Menu Set File",
    'INK'          => "InkML Image",
    'ICALEVENT'    => "iCal Event File",
    'ICALTODO'     => "iCal To Do File",
    'IST'          => "Inspiration Template",
    'INFO'         => "Texinfo Document",
    'INP'          => "MAME Replay File",
    'IVC'          => "InteliSea Vessel Configuration File",
    'IMG'          => "Floppy Disk Image",
    'IGR'          => "Igor Engraver File",
    'ICPR'         => "IconUtils Project File",
    'IFAITH'       => "iFaith SHSH File",
    'IBA'          => "Lectra Clothing Design Pieces File",
    'ICHAT'        => "iChat Saved Chat Log",
    'ITR'          => "Icy Tower Replay File",
    'IFP'          => "GTA Animation File",
    'IPR'          => "iProcrastinate Data File",
    'IFCZIP'       => "Compessed IFC File",
    'IFCXML'       => "Industry Foundation Classes XML File",
    'IGT'          => "iGrafx Document Template",
    'IPOD'         => "Rockbox Firmware File",
    'ICAL'         => "iCalendar File",
    'ICALENDAR'    => "iCalendar File",
    'IMZ'          => "WinImage Compressed Disk Image",
    'IMD'          => "GIS Image Metadata File",
    'IRF'          => "CCTV DVR H.264 Video File",
    'ISOZ'         => "Compressed Arbortext IsoDraw Illustration",
    'INPROGRESS'   => "Time Machine Backup Progress File",
    'IMAGE'        => "OpenQwaq Image",
    'IME'          => "Windows Input Method Editor File",
    'ICF'          => "Zoom Router Configuration File",
    'IGN'          => "RoboHelp Ignore List File",
    'IK'           => "CryENGINE IK Animation File",
    'IZE'          => "IZArc Archive",
    'IAS'          => "Intermodulation Analysis System File",
    'IFW'          => "INTUS Firmware File",
    'IKF'          => "INTUS Keyboard File",
    'IAA'          => "INTUS Audio Archive",
    'IGMA'         => "INTUS Graph Mask Archive",
    'ITLS'         => "iTunes Live Stream URL",
    'ITA'          => "VTech InnoTab Application File",
    'IWXDATA'      => "iWorx Data File",
    'IPICK'        => "iPick Football Image",
    'IPALIAS'      => "iPhoto Alias File",
    'IPHOTO'       => "iPhoto Library File",
    'INTERNETCONN' => "C'T       Apple Internet Connect Document",
    'INP'          => "Sony Camcorder Image Management File",
    'INT'          => "Sony Camcorder Image Management File",
    'INI'          => "Finale Preferences File",
    'IDEA'         => "Tresor IDEA Encrypted File",
    'IFICTION'     => "iFiction Metadata File",
    'IDE'          => "GTA Item Definition File",
    'IDEPLUGIN'    => "Xcode IDE Plug-in",
    'IMM'          => "iMindMap Map File",
    'INT'          => "Unreal International Localization File",
    'INT'          => "Fallout Compiled Script",
    'IBK'          => "IncrediMail Account Backup File",
    'IMAGEPORTFOL' => "O'LIBRARY Painter Image Portfolio Library",
    'IMOVIELIBRAR' => " 'iMovie Library File",
    'IGI'          => "Indigo Image File",
    'IGQ'          => "Indigo Queue File",
    'IBRE'         => "IncrediBots Replay File",
    'IBCH'         => "IncrediBots Challenge File",
    'IADPLUG'      => "iAd Producer Plugin",
    'IADCLASS'     => "iAd Producer Plugin Class Description File",
    'IADCOMPONENT' => "iAd Producer Plugin Component File",
    'IADPAGE'      => "iAd Producer Plugin Page Template",
    'IADACTION'    => "iAd Producer Plugin Action Template",
    'IADSTYLE'     => "iAd Producer Plugin Style Template",
    'IM4P'         => "IMG4 Payload File",
    'ILG'          => "InstallScript Log File",
    'INLX'         => "Adobe InDesign Interchange Library",
    'IFM'          => "Informed Form Data Document",
    'ILOGICVB'     => "iLogic VB File",
    'INT'          => "Intellivision Game ROM File",
    'IMP'          => "Imagine Project",
    'IBG'          => "ImgBurn Graph File",
    'ICMOD'        => "Inner Core Minecraft PE Mod File",
    'IQ4'          => "IQ4E Controller Strategy File",
    'IPF'          => "PCAN-Explorer Panel File",
    'IDF'          => "MIDI Instrument Definition File",
    'IPF'          => "OS/2 Help File",
    'ITS'          => "Internet Document Set",
    'IMJ'          => "JFIF Bitmap Image",
    'ISH'          => "ISH Compressed Archive",
    'ICB'          => "Targa ICB Bitmap Image",
    'IVA'          => "Dementia.4207 Virus File",
    'IIL'          => "CleanSweep Installation Log",
    'IWS'          => "InstallWatch Scan File",
    'INM'          => "FaxMaster Document",
    'IC1'          => "Low Resolution Imagic Graphics File",
    'IC2'          => "Medium Resolution Imagic Graphics File",
    'IC3'          => "High Resolution Imagic Graphics File",
    'IVS'          => "Internet Streaming Video",
    'INS'          => "Ensoniq Instrument",
    'INK'          => "Pocket PC Handwritten Note",
    'IVT'          => "International Volleyball 2006 Data File",
    'IIX'          => "Translation Memory Index File",
    'IND'          => "Adobe InDesign Document",
    'IRX'          => "Brewer Irradiation File",
    'IMG'          => "GEM Image",
    'IGR'          => "Quest3D Channel Group Layout File",
    'IMF'          => "Id Music File",
    'IMGA'         => "Aleph One Image File",
    'IF'           => "Procedimientos-Uno IFWin Project File",
    'IS1'          => "M3 Sakura Real-Time Save 1 File",
    'IS1'          => "Synergy/DE Data Index File",
    'IBRO'         => "IncrediBots Robot File",
    'IMMODULES'    => "GTK+ Module File",
    'INP'          => "Urdu InPage Document",
    'IMD'          => "Microsoft VisioModeler File",
    'IVUE'         => "Live Picture IVUE Image",
    'IOBIT'        => "Advanced SystemCare Rollback File",
    'IOPLIST'      => "Mac OS X IOPLIST File",
    'INFOPATHXML'  => "Microsoft InfoPath Form",
    'I3PACK'       => "Point Blank Game Data File",
    'ITK'          => "ScummVM Game Data File",
    'IB2'          => "IncrediBots 2 Saved Challenge File",
    'IB3'          => "IncrediBots 3 Saved Challenge File",
    'ISMCLIP'      => "iStopMotion Animation Clip",
    'IMP'          => "Improv Spreadsheet",
    'IPLB'         => "iPhoto Library Archive Document",
    'IPHOTOPROJEC' => " 'iPhoto Print Project",
    'IDDX'         => "Static Default File",
    'INS'          => "AGT Game Instruction File",
    'ISALLIC'      => "iSale License File",
    'IMOVIEEVENT'  => "iMovie Event File",
    'ID3TAG'       => "MP3 Skype Recorder Temporary File",
    'INJB'         => "InDesign Job Bag File",
    'ITI'          => "InterActual Skin File",
    'IMD'          => "ImageDisk Disk Image File",
    'JAR'          => "Java Archive File",
    'JPG'          => "JPEG Image",
    'JS'           => "JavaScript File",
    'JSP'          => "Java Server Page",
    'JAVA'         => "Java Source Code File",
    'JPEG'         => "JPEG Image",
    'JPX'          => "JPEG 2000 Image File",
    'JP2'          => "JPEG 2000 Core Image File",
    'JSPX'         => "XML Java Server Page",
    'JNLP'         => "Java Web Start File",
    'JSON'         => "JavaScript Object Notation File",
    'JNT'          => "Windows Journal File",
    'JRPRINT'      => "JasperReports Print File",
    'JDB'          => "Symantec Endpoint Protection Update File",
    'JPS'          => "Stereo JPEG Image",
    'JSPF'         => "Java Server Page Fragment",
    'JBC'          => "Jam STAPL Byte-Code File",
    'JSF'          => "Java Script Command File",
    'JPS'          => "Akeeba Backup Archive",
    'JSE'          => "JScript Encoded File",
    'JPC'          => "JPEG 2000 Code Stream File",
    'JPR'          => "JBuilder Project",
    'JPX'          => "JBuilder Project",
    'J2C'          => "JPEG 2000 Code Stream",
    'JPW'          => "World File for JPEG",
    'JS'           => "JScript Executable Script",
    'JBR'          => "Paint Shop Pro Brushes File",
    'JIC'          => "Java Icon File",
    'JIC'          => "JTAG Indirect Configuration File",
    'J2L'          => "Jazz Jackrabbit 2 Level File",
    'JUDE'         => "JUDE Project File",
    'JHTML'        => "Java HTML Web Page",
    'JWS'          => "Java Web Services File",
    'JWS'          => "Java Workspace Settings File",
    'JAD'          => "Java Application Descriptor File",
    'J2I'          => "Jazz 2 Internet Link File",
    'JC'           => "FlashGet Partial Download",
    'JEF'          => "Janome Embroidery Format",
    'JC!'          => "FlashGet Incomplete Download",
    'JGZ'          => "Gzipped Javascript File",
    'JNG'          => "JPEG Network Graphic",
    'JSX'          => "ExtendScript Script File",
    'JG4'          => "BigJig Jigsaw Puzzle",
    'JIA'          => "Digital Photo Navigator Album",
    'JPH'          => "JProbe Memory Snapshot",
    'JT'           => "JT Open CAD File",
    'JMP'          => "JMP Data File",
    'JOBOPTIONS'   => "Adobe Joboptions File",
    'JOINED'       => "HJ-Split Data File",
    'JRXML'        => "JasperReports Layout File",
    'JASPER'       => "JasperReports Data File",
    'JXR'          => "JPEG XR Image",
    'JSFL'         => "Animate JSFL Script File",
    'JTP'          => "Windows Journal Template",
    'JB2'          => "JBIG2 Image",
    'JBI'          => "Motoman Robot Job File",
    'JTS'          => "Cyberlink AVCHD Video File",
    'JOB'          => "Windows Task Scheduler Job File",
    'JDF'          => "Adobe Acrobat Job Definition File",
    'JVSG'         => "Video Surveillance Project",
    'JAS'          => "Cheetah3D Model File",
    'JTV'          => "JRiver TV File",
    'JAM'          => "Jam STAPL File",
    'JBIG2'        => "JBIG2",
    'JSS'          => "JACOsub Subtitle File",
    'J3O'          => "jMonkeyEngine 3D Scene",
    'JCP'          => "JCreator Project File",
    'JAP'          => "Nonogram Puzzle File",
    'JQZ'          => "JQuiz File",
    'JCL'          => "JCloze File",
    'JCW'          => "JCross File",
    'JMT'          => "JMatch File",
    'JMX'          => "JMix File",
    'JMS'          => "Masher Project",
    'JKS'          => "Java Keystore File",
    'JCEKS'        => "JCEKS Keystore File",
    'JST'          => "Jnes Save State",
    'JMF'          => "Jackhammer Project",
    'JPA'          => "Akeeba Backup Archive",
    'JMC'          => "JM-Crypt Encrypted File",
    'JMCX'         => "JM-Crypt Encrypted File",
    'JSPF'         => "JSON Playlist File",
    'JNX'          => "BirdsEye JNX Raster Map",
    'JAS'          => "Paint Shop Pro Compressed Graphic",
    'JTF'          => "JPEG Tagged Interchange Format",
    'J'            => "Java Source File",
    'JAV'          => "Java Source File",
    'JFIF'         => "JPEG File Interchange Format",
    'JPE'          => "JPEG Image",
    'JBIG'         => "Joint Bi-level Image Group File",
    'JFI'          => "JPEG File Interchange Image",
    'JIS'          => "Japanese Industry Standard Text",
    'J2K'          => "JPEG 2000 Image",
    'JBK'          => "Juno Backup File",
    'JPD'          => "Java Process Definition",
    'JIF'          => "JPEG Image File",
    'JBF'          => "Paint Shop Pro Browser Cache File",
    'JCZ'          => "Liquid Motion Animation",
    'JPF'          => "JPEG 2000 Image",
    'JED'          => "Xilinx JEDEC Programming File",
    'JAM'          => "JAM Musical Score",
    'JAM'          => "PS3 Unreal Tournament 3 Mod File",
    'JSPA'         => "Java Servlet Alias",
    'JPD'          => "Joint PhotoDefiner Image",
    'JRS'          => "Exchange Reserve Transaction Log File",
    'JSF'          => "Project64 Joystick File",
    'JOB'          => "MetaCAM Nest Job File",
    'JWL'          => "Roxio Jewel Case File",
    'JNP'          => "Java Web Start File",
    'JSXBIN'       => "Binary ExtendScript Script File",
    'JSXINC'       => "ExtendScript Included Script File",
    'JDC'          => "JDownloader Links File",
    'JST'          => "JavaServer Page Document",
    'JAM'          => "Line 6 Device Recording",
    'JTX'          => "ESE Transaction Log",
    'JGW'          => "JPEG World File",
    'JPR'          => "Fugawi Projection File",
    'JPGW'         => "JPEG World File",
    'JA'           => "Jet Archive",
    'JAG'          => "Jagex Data File",
    'JL'           => "Julia Source Code File",
    'JPG2'         => "JPEG 2000 Image",
    'JCLIC'        => "JClic Project File",
    'JSH'          => "JAWS Script Header File",
    'JSS'          => "JAWS Script",
    'JSS'          => "JavaScript Style Sheet File",
    'JKM'          => "JAWS Key Map File",
    'JOY'          => "CryENGINE Facial Editor Joystick File",
    'JNILIB'       => "JNI Library",
    'JSD'          => "Jazer Data File",
    'JCRYPT'       => "JCRYPT File",
    'JTBACKUP'     => "Just Type Backup File",
    'JGCSCS'       => "EditPad Custom Syntax Coloring Scheme File",
    'JMV'          => "Jnes Movie File",
    'JKB'          => "Jedi Knight Bot File",
    'J6I'          => "Ricoh Camera Image File",
    'JDAT'         => "J&ASoft Data File",
    'JCR'          => "Nonogram Puzzle File",
    'JSONLZ4'      => "Compressed Firefox Bookmarks Backup File",
    'JET'          => "JET Database File",
    'JBEAM'        => "BeamNG Vehicle Definition Format",
    'J01'          => "Akeeba Multi-part Backup Archive",
    'JMCP'         => "JM-Crypt Encrypted File",
    'JMCK'         => "JM-Crypt Key File",
    'JMCE'         => "JM-Crypt Encrypted File",
    'JMCR'         => "JM-Crypt Encrypted File",
    'JDP'          => "BlackBerry JDE Application Project",
    'JSL'          => "Corel PaintShop Pro Shape Library",
    'JDR'          => "IROAD Dash Cam Video File",
    'JVSGZ'        => "Compressed Video Surveillance Project",
    'JPG-LARGE'    => "Large JPEG Image",
    'JNR'          => "JoinNet Recording File",
    'JLR'          => "Juliar Source Code File",
    'JTD'          => "JustSystems Ichitaro Document",
    'JAP'          => "jAlbum Project Settings File",
    'JSD'          => "HP JetSuite Document",
    'J'            => "JPEG Image",
    'JVS'          => "JavaScript Proxy Autoconfig File",
    'JIFF'         => "JPEG Image File Format",
    'JP1'          => "Japanese (Romaji) Text File",
    'J'            => "JAR Archive",
    'JAR.PACK'     => "Pack200 Packed Jar File",
    'JRZ'          => "PSP Game Data File",
    'JRTF'         => "JAmes OS Rich Text File",
    'JBMP'         => "JAmes OS Bitmap Image",
    'JTX'          => "XPS Document",
    'JTX'          => "Jrju Text File",
    'JIGSAW'       => "Jigsaw Explorer Save File",
    'JO-7Z'        => "jo Audio File",
    'JO'           => "jo Audio File",
    'JPN'          => "Windows Japanese Noise-Word List File",
    'JSH'          => "Jsh Script",
    'JRC'          => "PCjr Cartridge ROM File",
    'JARVIS'       => "Jarvis Subscriber File",
    'JSDA'         => "Jazer Data File",
    'JAP'          => "Japanese Nintendo 64 Game ROM",
    'JOE'          => "JOE Document",
    'JAC'          => "JaStaCry Encrypted File",
    'JBG'          => "Joint Bi-level Image Group File",
    'KML'          => "Keyhole Markup Language File",
    'KEY'          => "Keynote Presentation",
    'KMZ'          => "Google Earth Placemark File",
    'KEYCHAIN'     => "Mac OS X Keychain File",
    'KDC'          => "Kaspersky Virus Database File",
    'KEY'          => "Software License Key File",
    'KFX'          => "Amazon KF10 eBook File",
    'KRAB'         => "GandCrab V4 Ransomware Encrypted File",
    'KEXT'         => "Mac OS X Kernel Extension",
    'KYS'          => "Adobe Photoshop Keyboard Shortcuts File",
    'KDC'          => "Kodak Photo-Enhancer File",
    'KEY'          => "Security Key",
    'KAR'          => "Karaoke MIDI File",
    'KBD'          => "Keyboard Layout Script",
    'KTH'          => "Keynote Theme",
    'KON'          => "Yahoo! Widget XML File",
    'KOZ'          => "Audiokoz Music File",
    'KOZ'          => "Bell Music File",
    'KLG'          => "Log File",
    'KLG'          => "KOFIA Log",
    'K26'          => "Kurzweil K2600 File",
    'KRZ'          => "Kurzweil K2000 File",
    'KSF'          => "Korg Trinity/Triton Sample File",
    'KGB'          => "KGB Archive File",
    'KWD'          => "KWord Document",
    'KDB'          => "Keypass Database File",
    'KNT'          => "KeyNote Note File",
    'KPR'          => "KPresenter Presentation",
    'KID'          => "Kidspiration Document",
    'KDEVPRJ'      => "KDevelop Project File",
    'KDEVELOP'     => "KDevelop Project Data File",
    'KIX'          => "KiXtart Script File",
    'KHD'          => "Dynamics AX Kernel Help Data File",
    'KHI'          => "Dynamics AX Kernel Help Index File",
    'KPX'          => "Kid Pix Picture",
    'KPP'          => "Kid Pix Presentation",
    'KWREPLAY'     => "Command & Conquer 3 Replay File",
    'KYR'          => "Lotus Domino Key Ring File",
    'KPF'          => "Komodo Project File",
    'KPZ'          => "Komodo Template File",
    'KMC'          => "Kinemac Animation File",
    'KMCOBJ'       => "Kinemac Sprite Object",
    'KISMAC'       => "KisMAC Webservice File",
    'KAP'          => "BSB Chart Image File",
    'KIT'          => "20-20 Design File",
    'KT3'          => "Battery 3 Drum Kit File",
    'KO'           => "Linux Kernel Module File",
    'KPL'          => "Kids Programming Language File",
    'KB2'          => "Kleo Backup File",
    'KFN'          => "KaraFun Karaoke File",
    'KDS'          => "KD Player Skin File",
    'KDI'          => "KD Player Skin Image File",
    'KDBX'         => "KeePass Password Database",
    'KELGFILE'     => "Best Free Keylogger Log File",
    'KEY'          => "LightWave License File",
    'KMY'          => "KMyMoney Data File",
    'KODU'         => "Kodu Game File",
    'KES'          => "Kurzweil 3000 Document",
    'KDE'          => "KryptoStorage Container File",
    'KWM'          => "WebMoney Key File",
    'KEY-TEF'      => "Keynote iCloud Presentation",
    'KEXI'         => "Kexi Database",
    'K25'          => "Kodak K25 Image",
    'KDENLIVE'     => "Kdenlive Project File",
    'KLQ'          => "Kaspersky Quarantine File",
    'KIT'          => "CodeKit File",
    'KS'           => "Keystore File",
    'KEYTAB'       => "Kerberos Keytab File",
    'KV'           => "Kivy Language File",
    'KMA'          => "Correlate Archive File",
    'KMS'          => "Correlate Solutions File",
    'KT'           => "Kotlin Source Code File",
    'KPG'          => "Kai's Power Goo Graphic",
    'KEY'          => "Keyboard Definition File",
    'KSH'          => "Unix Korn Shell Script",
    'KMP'          => "Korg Trinity/Triton Keymap File",
    'KSC'          => "Korg Trinity/Triton Script File",
    'KIC'          => "Kodak Compressed Image File",
    'KMM'          => "K-Meleon Macro Module",
    'KIT'          => "Battery Drum Kit File",
    'KT2'          => "Battery 2 Drum Kit File",
    'KPL'          => "Kazaa Playlist File",
    'KVTML'        => "KWordQuiz File",
    'KBD'          => "3ds Max Keyboard Shortcuts File",
    'K3G'          => "3GP Mobile Phone Video File",
    'KV6'          => "Ken's Voxlap 6 Model File",
    'KAG'          => "King Arthur's Gold Map File",
    'KFM'          => "Gamebryo 3D Model File",
    'KCL'          => "NIntendo Collision File",
    'KEB'          => "Kaspersky Virus Bases File",
    'KDZ'          => "Kaspersky Virus Bases File",
    'KTZ'          => "Kahootz Project File",
    'KMR'          => "KnowledgeMill Link File",
    'KEXIC'        => "Kexi Database Connection File",
    'KEXIS'        => "Kexi Database Shortcut File",
    'K3B'          => "K3b Disk Burning Project File",
    'KTN'          => "KTooN Animation Project File",
    'KS'           => "Kickstart File",
    'KSF'          => "KMPlayer Skin File",
    'KAR'          => "Karel Function Dictionary",
    'KSD'          => "Native Instruments Massive Sound File",
    'KFS'          => "Max Payne Model File",
    'KF2'          => "Max Payne Resource File",
    'KEYSTORE'     => "Java Keystore File",
    'KUIP'         => "Kingsoft Office Personalization File",
    'KX'           => "KiXtart Tokenized Script File",
    'KCT'          => "Keyman Developer Customization Source File",
    'KPS'          => "Keyman Developer Package Source File",
    'KVK'          => "Keyman On-Screen Keyboard File",
    'KXX'          => "Keyman Developer Encrypted Keyboard File",
    'KRC'          => "Mouse and Key Recorder Macro File",
    'KGTEMP'       => "KuGou Temporary Cache File",
    'KKK'          => "KKK Ransomware Encrypted File",
    'KBITS'        => "Bits'N'Picas Bitmap Font File",
    'KDK'          => "Kodak Proprietary Decimated TIFF File",
    'KYB'          => "Keyboard Layout",
    'KB'           => "C++ Keyboard Script",
    'KFX'          => "Kofax Image File",
    'KODAK'        => "Kodak Photo CD File",
    'KIN'          => "Kinetic Music Project",
    'KTP'          => "Kinetic Project Template",
    'K25'          => "Kurzweil K2500 File",
    'KDEVDLG'      => "KDevelop Dialog Box File",
    'KDMP'         => "Windows Crash Dump File",
    'KOOB'         => "Koob E-Book File",
    'KBS'          => "Keyboard Script File",
    'KZ'           => "KuaiZip Compressed File",
    'KOR'          => "Windows Korean Noise-Words List File",
    'K2S'          => "Kaiser 2 Saved Game",
    'KNO'          => "DigIN Serialized Break Model",
    'KSM'          => "Ken Silverman Music File",
    'KSM'          => "Pfaff Embroidery Design File",
    'KMV'          => "Mobile DJ Video File",
    'KMP'          => "Mario Kart Wii Course Description File",
    'KSD'          => "KeepSafe File",
    'KAL'          => "Kratos Vision Data File",
    'M4A'          => "MPEG-4 Audio File",
    'MDB'          => "Microsoft Access Database",
    'MID'          => "MIDI File",
    'MIM'          => "Multi-Purpose Internet Mail Message File",
    'MP3'          => "MP3 Audio File",
    'MP4'          => "MPEG-4 Video File",
    'MPG'          => "MPEG Video File",
    'MOV'          => "Apple QuickTime Movie",
    'MSG'          => "Outlook Mail Message",
    'M3U'          => "Media Playlist File",
    'MSI'          => "Windows Installer Package",
    'MPA'          => "MPEG-2 Audio File",
    'MDF'          => "Media Disc Image File",
    'M4V'          => "iTunes Video File",
    'M'            => "Objective-C Implementation File",
    'MAX'          => "3ds Max Scene File",
    'MOBI'         => "Mobipocket eBook",
    'MDI'          => "Microsoft Document Imaging File",
    'MIDI'         => "MIDI File",
    'MPEG'         => "MPEG Movie",
    'MPP'          => "Microsoft Project File",
    'MSP'          => "Windows Installer Patch",
    'MAX'          => "PaperPort Scanned Document",
    'MOD'          => "Amiga Music Module File",
    'M'            => "Mathematica Input File",
    'MST'          => "Windows Installer Setup Transform File",
    'MNG'          => "Multiple Network Graphic",
    'MKV'          => "Matroska Video File",
    'MSO'          => "Inline E-mail Attachment",
    'MPKG'         => "Meta Package File",
    'M4B'          => "MPEG-4 Audio Book File",
    'MA'           => "Maya Project File",
    'MAT'          => "MATLAB MAT-File",
    'MTS'          => "AVCHD Video File",
    'MDL'          => "MathWorks Simulink Model",
    'MDL'          => "Half-Life Model File",
    'MPX'          => "Microsoft Project Exchange File",
    'MCD'          => "Mathcad Document",
    'MPQ'          => "Blizzard Mo'PaQ File",
    'MOD'          => "Camcorder Recorded Video File",
    'MAP'          => "Quake Engine Map File",
    'M4R'          => "iPhone Ringtone File",
    'MS'           => "3ds Max Script File",
    'MEL'          => "Maya Embedded Language File",
    'MD5'          => "MD5 Checksum File",
    'MB'           => "Maya Binary Project File",
    'MXD'          => "ArcGIS Map Document",
    'MDF'          => "SQL Server Database File",
    'MW'           => "Maple Worksheet",
    'MOHO'         => "Moho Animation Project",
    'MXF'          => "Material Exchange Format File",
    'MOI'          => "MOI Video File",
    'MWX'          => "MapGuide Author Map Window XML File",
    'MWF'          => "MapGuide Author Map Window File",
    'MENC'         => "Windows Mobile Encrypted File",
    'MTD'          => "Musicnotes Digital Sheet Music File",
    'MET'          => "eMule Resource File",
    'MASSEFFECTPR' => "F'ILE    Mass Effect Player Profile",
    'MASSEFFECTSA' => "E'Mass Effect Saved Game",
    'M2P'          => "MPEG-2 Program Stream File",
    'MXL'          => "Compressed MusicXML File",
    'MONTAGE'      => "Montage Screenplay File",
    'MGT'          => "Musicnotes Guitar Guru Song File",
    'MDX'          => "Extended Media Descriptor File",
    'MMP'          => "Symbian Project Specification File",
    'MDDATA'       => "iPhone Backup File",
    'MDINFO'       => "iPhone Backup Information File",
    'MYCOLORS'     => "Stardock MyColors Theme File",
    'M'            => "MATLAB Source Code File",
    'M3U8'         => "UTF-8 M3U Playlist File",
    'MM'           => "Objective-C++ Source File",
    'MPO'          => "Multi Picture Object File",
    'MXS'          => "Maxwell Studio Scene File",
    'MWB'          => "MySQL Workbench Document",
    'MXI'          => "Maxwell Image",
    'MARKDOWN'     => "Markdown Documentation File",
    'MD'           => "Markdown Documentation File",
    'MIF'          => "MapInfo Interchange Format File",
    'MDD'          => "Point Oven Deformation Data File",
    'MSHC'         => "Microsoft Help Container File",
    'MCDX'         => "Mathcad Prime Document",
    'MOX'          => "Montax Imposer Template Document",
    'MMF'          => "Meal-Master Recipe File",
    'MPKT'         => "MOPEKS Trial File",
    'MJK'          => "Question File",
    'MPH'          => "Photostory Deluxe Project",
    'MDJ'          => "StarUML Model File",
    'MDSX'         => "MEGA Saved Session",
    'MSIM'         => "mSecure Password Manager Backup File",
    'MS14'         => "Multisim 14 Circuit Design File",
    'MP14'         => "Multisim 14 Project",
    'MIME'         => "Multi-Purpose Internet Mail Extension",
    'MME'          => "Multi-Purpose Internet Mail",
    'MP2'          => "MPEG Layer II Compressed Audio File",
    'MAQ'          => "Microsoft Access Query",
    'MAV'          => "Access View File",
    'MDA'          => "Access Add-in",
    'MDE'          => "Compiled Access Add-in File",
    'MDW'          => "Access Workgroup File",
    'MSC'          => "Microsoft Management Console Snap-in Control",
    'MPC'          => "Musepack Compressed Audio File",
    'MDX'          => "Multiple Index File",
    'MPS'          => "Pocket Streets Map File",
    'MTM'          => "MultiTracker Module",
    'MED'          => "Amiga MED Sound File",
    'M4'           => "Macro Processor Library",
    'MMF'          => "Synthetic Music Mobile Application File",
    'MANIFEST'     => "Windows Application Manifest File",
    'MHS'          => "Xilinx XPS Hardware Specification File",
    'MSS'          => "Microprocessor Software Specification File",
    'MTF'          => "Motorola Theme File",
    'MDMP'         => "Windows Minidump",
    'MAK'          => "Makefile",
    'MBOX'         => "E-mail Mailbox File",
    'MSF'          => "Mail Summary File",
    'MD2'          => "Quake 2 Player Model",
    'MTH'          => "Derive Math File",
    'MSP'          => "Microsoft Paint Bitmap Image",
    'M4P'          => "iTunes Music Store Audio File",
    'MAPIMAIL'     => "Send To Mail Recipient",
    'MYDOCS'       => "Send To My Documents",
    'MEM'          => "FoxPro Variable File",
    'MNT'          => "FoxPro Menu Memo",
    'MNX'          => "FoxPro Menu",
    'MPR'          => "FoxPro Generated Menu Program",
    'MPX'          => "FoxPro Compiled Menu Program",
    'M2V'          => "MPEG-2 Video",
    'MAB'          => "Mozilla Address Book",
    'MPM'          => "Max Payne Modfication File",
    'MXP'          => "Adobe Extension Package",
    'MA1'          => "Monarch Audio File",
    'MK'           => "Makefile",
    'MUS'          => "Finale Notation File",
    'MSWMM'        => "Windows Movie Maker Project",
    'MD1'          => "GEAR CD/DVD Disc Image",
    'MJP'          => "MJPEG Video File",
    'MMP'          => "MindManager Mind Map",
    'MMP'          => "MixMeister Playlist",
    'MMP'          => "Master Album Maker Project",
    'MP'           => "Maya PLE Project File",
    'MTE'          => "MadTracker 2 Envelope",
    'MTI'          => "MadTracker Instrument",
    'MTP'          => "MadTracker 2 Pattern",
    'MTX'          => "MadTracker 2 Extension",
    'MRW'          => "Minolta Raw Image File",
    'MIX'          => "Microsoft Image Exchange File",
    'MSM'          => "Windows Installer Merge Module",
    'MBX'          => "Outlook Express Mailbox",
    'MDL'          => "Flight Simulator Airplane Model",
    'MDL'          => "Rational Rose Model File",
    'MSO'          => "Microsoft Office Macro Reference File",
    'MEB'          => "PRO100 3D Interior Catalog Element",
    'MDC'          => "Multi Dimension Cube File",
    'MAX'          => "OmniPage Scanned Document",
    'MDS'          => "Media Descriptor Sidecar File",
    'MD0'          => "Alcohol Disk Image Segment 1",
    'MD1'          => "Alcohol Disk Image Segment 2",
    'MD2'          => "Alcohol Disk Image Segment 2",
    'MHT'          => "MHTML Web Archive",
    'MLK'          => "MasterCook Look File",
    'MILK'         => "MilkDrop Winamp Plugin Preset",
    'MDE'          => "ArchiCAD Educational Version Module File",
    'MSSTYLES'     => "Windows XP Style",
    'MMAP'         => "MindManager Map File",
    'MDF'          => "Measurement Data Format File",
    'MBG'          => "Mailbag Assistant Mailbox File",
    'MBG'          => "Microsoft Mailbag",
    'MAI'          => "Microsoft Mail File",
    'MNC'          => "My Notes Center Notebook",
    'MLS'          => "Milestones Simplicity File",
    'MNK'          => "My Notes Keeper Notebook",
    'MM'           => "FreeMind Mind Map",
    'MFX'          => "Multimedia Fusion Extension",
    'MHTML'        => "MIME HTML File",
    'MUI'          => "Multilingual User Interface File",
    'MINIUSF'      => "Nintendo 64 Song File",
    'MD'           => "Moneydance Financial Data File",
    'MC1'          => "MedCalc Data File",
    'MBM'          => "Multi Bitmap File",
    'MC9'          => "Mastercam 9 Geometry File",
    'MCX'          => "MICRO CADAM-X/6000 Model Data File",
    'MKA'          => "Matroska Audio File",
    'MOD'          => "Fortran Module File",
    'MLS'          => "CrystalPlayer Playlist",
    'MIS'          => "Saved Game Mission File",
    'MIS'          => "Marble Blast Gold Mission File",
    'MFO'          => "Perl ModInfo Descriptor File",
    'MINT'         => "Linux Mint Installer File",
    'MRK'          => "DPOF Auto Print Order File",
    'MVI'          => "AutoCAD Movie Command File",
    'MAILHOST'     => "MSN Mailhost Settings File",
    'M21'          => "MPEG-21 File",
    'MP21'         => "MPEG-21 Multimedia File",
    'M2P'          => "Maxthon 2 Browser Plugin File",
    'M2S'          => "Maxthon 2 Browser Skin File",
    'MCO'          => "Live Messenger Winks File",
    'MMO'          => "Memory Map Overlay File",
    'MELL'         => "Mellel Word Processing File",
    'MELLEL'       => "Mellel Word Processing Document",
    'MPGA'         => "MPEG-1 Layer 3 Audio File",
    'MQV'          => "Sony Movie Format File",
    'MSKN'         => "MediaMonkey Skin File",
    'MWP'          => "Lotus Word Pro SmartMaster File",
    'MP2M'         => "Max Payne 2 Mod File",
    'MMC'          => "Microsoft Media Catalog",
    'MF'           => "Java Manifest File",
    'M1PG'         => "iFinish Video Clip",
    'MER'          => "RSView Development Runtime File",
    'MBP'          => "Mobipocket Notes File",
    'MC5'          => "Poser 5 Material File",
    'MC6'          => "Poser Material Collection File",
    'MCZ'          => "Compressed Poser Material File",
    'MYI'          => "MySQL MyISAM Index File",
    'MRS'          => "GunZ Game Data File",
    'MTS'          => "MadTracker 2 Sample File",
    'M2TS'         => "Blu-ray BDAV Video File",
    'M2T'          => "HDV Video File",
    'MSPX'         => "Microsoft ASP.NET Web Page",
    'MNV'          => "PlayStation Movie File",
    'MAGIK'        => "Magik Source Code File",
    'MSDVD'        => "Windows DVD Maker Project File",
    'MGX'          => "Age of Empires 2 Expansion Replay File",
    'MGX'          => "Rise of Nations Saved Game",
    'MGL'          => "Age of Empires 2 Replay File",
    'MSU'          => "Windows Vista Update Package",
    'MZP'          => "MAXScript Zip Package",
    'MCR'          => "3ds Max Macroscript File",
    'MSE'          => "3ds Max Encrypted MAXScript File",
    'MBI'          => "Multi-Bootable Information File",
    'MPT'          => "Microsoft Project Template",
    'MOSAIC'       => "MacOSaiX Mosaic File",
    'MP21'         => "AXMEDIS MPEG-21 Object",
    'M21'          => "AXMEDIS MPEG-21 File",
    'MSN'          => "Host Blocking File",
    'MGV'          => "PSP Video File",
    'MGV'          => "Yamaha MegaVoice File",
    'MODEL'        => "CATIA 3D Model FIle",
    'MTV'          => "MTV Video Format File",
    'MD3'          => "Quake 3 3D Model",
    'MYAPP'        => "Visual Studio Application XML File",
    'MOX'          => "ExtendSim Simulation Software Model",
    'MUM'          => "Windows Vista Update Package",
    'MVD'          => "Movie Edit Pro Movie File",
    'MEX'          => "Macro Express File",
    'MXE'          => "Macro Express Playable Macro",
    'MO'           => "Machine Object File",
    'MYD'          => "MySQL Database Data File",
    'MO3'          => "MO3 Audio File",
    'MP2S'         => "Max Payne 2 Saved Game",
    'MFA'          => "Multimedia Fusion Development File",
    'MDF'          => "Translation Memory Data Find File",
    'MWF'          => "Translation Memory Word Find File",
    'MRC'          => "mIRC Script File",
    'MJ2'          => "Motion JPEG 2000 Video Clip",
    'MFP'          => "MediaFACE Project File",
    'MFT'          => "MediaFACE Project Template",
    'MFO'          => "MediaFace Online Saved File",
    'MOM'          => "Managed Object Model",
    'MPCPL'        => "Media Player Classic Playlist",
    'MNO'          => "Macromedia Design Note",
    'MXML'         => "Flex MXML Component",
    'MWD'          => "Mariner Write Document",
    'MWS'          => "Maple Classic Worksheet",
    'M2'           => "World or Warcraft Model Object",
    'MS10'         => "Multisim 10 Circuit Design File",
    'MS3D'         => "MilkShape 3D Model",
    'MPZ'          => "Miradi Project File",
    'MPF'          => "Microsoft Media Package FIle",
    'MPV'          => "MPEG Elementary Stream Video File",
    'MBF'          => "Microsoft Money Backup File",
    'MMM'          => "Music Maker Arrangement File",
    'MAT'          => "Vue Material File",
    'MDX'          => "Warcraft 3 Model File",
    'MDL'          => "Warcraft 3 3D Model Text File",
    'MTW'          => "Minitab Worksheet File",
    'MDM'          => "HLM Multivariate Data Matrix File",
    'MML'          => "FrameMaker Maker Markup Language File",
    'MCL'          => "Windows Media Center Link File",
    'MOF'          => "Managed Object Format File",
    'MI4'          => "Audio Player Firmware File",
    'MPLS'         => "Blu-ray Movie Playlist File",
    'MPD'          => "Microsoft Project Database",
    'MSP'          => "MaxScript Page File",
    'MIO'          => "MioEngine Application File",
    'MPL'          => "AVCHD Playlist File",
    'MRIMG'        => "Macrium Reflect Disk Image",
    'MXC2'         => "MAGIX Cache File",
    'MVE'          => "Infinity Engine Movie File",
    'MC2'          => "MasterCook 5 Cookbook File",
    'MSCZ'         => "MuseScore Compressed Score File",
    'MVP'          => "MAGIX Video Project File",
    'MNU'          => "AutoCAD Interface Layout File",
    'MNS'          => "AutoCAD Interface Settings File",
    'MNL'          => "AutoCAD Menu LISP File",
    'MNR'          => "AutoCAD Menu Resource File",
    'MCD'          => "MiniCAD Design File",
    'MENU'         => "Quake 3 Engine Menu File",
    'MBS'          => "Opera Mailbox File",
    'MXAD'         => "Mandelbrot Explorer All Data File",
    'MV'           => "MivaScript File",
    'MVC'          => "MivaScript Compiled File",
    'MGCB'         => "Equation Illustrator Project File",
    'MII'          => "Wii Virtual Avatar File",
    'MPGINDEX'     => "Adobe MPEG Index File",
    'MJDOC'        => "MacJournal Document",
    'MGDATABASE'   => "MacGourmet Deluxe Database File",
    'MGO'          => "MacGourmet Recipe File",
    'MOBILECONFIG' => "Apple Mobile Configuration File",
    'M3'           => "Blizzard MDX3 Model File",
    'MARSHAL'      => "Marshal Data Migration Model File",
    'MX'           => "Mathematica Serialized Package File",
    'ML'           => "ML Source Code File",
    'MXT'          => "ArcGIS Map Template",
    'MPK'          => "ArcGIS Map Package",
    'MD5MESH'      => "id Tech 4 3D Mesh File",
    'MD5ANIM'      => "id Tech 4 Model Animation File",
    'MD5CAMERA'    => "id Tech 4 Model Camera File",
    'MOS'          => "Leaf Camera RAW File",
    'MTL'          => "OBJ Material File",
    'MLC'          => "Microsoft Language Interface Pack",
    'MJD'          => "Adobe Acrobat MIME Encoded Job Definition File",
    'MXI'          => "Adobe Extension Information File",
    'MAE'          => "My Avatar Editor Character File",
    'MRML'         => "3D Slicer Scene Description File",
    'MAFF'         => "Mozilla Archive Format File",
    'MDBACKUP'     => "iPhone Data Backup File",
    'MEF'          => "Mamiya RAW Image",
    'MPJ'          => "RoboHelp HTML Project",
    'MIF'          => "FrameMaker Interchange Format File",
    'MSRCINCIDENT' => "Windows Remote Assistance Invitation File",
    'MGA'          => "Manga Document",
    'MPP'          => "MobileFrame Project Publisher File",
    'MVY'          => "Video easy Project File",
    'MFA'          => "MobileFrame App File",
    'MFP'          => "MobileFrame Package",
    'MFU'          => "MobileFrame Update File",
    'MP'           => "LaTeX MetaPost File",
    'MFL'          => "Mozilla FastLoad File",
    'MOBILEPROVIS' => "O'N      Xcode Mobile Provisioning Profile",
    'MS11'         => "Multisim 11 Circuit Design File",
    'MP11'         => "Multisim 11 Project File",
    'MBD'          => "Multimedia Builder Project File",
    'MAT'          => "3ds Max Materials File",
    'MAXC'         => "3ds Max Container File",
    'MIX'          => "3ds Max Motion Mixer File",
    'MRXS'         => "MIRAX Virtual Slide File",
    'MAF'          => "Mutation Annotation Format File",
    'MINESWEEPERS' => "V'E-MS   Minesweeper Saved Game",
    'MART'         => "MartView eBook File",
    'MCR'          => "Minecraft Region File",
    'MPS'          => "Mathematical Programming System File",
    'MXMF'         => "Mobile XMF Ringtone File",
    'MDC'          => "Merkaartor Document",
    'MERLIN2'      => "Merlin Project File",
    'MMW'          => "AceMoney Money File",
    'MDB'          => "Avid Media Database",
    'MSD'          => "Map Service Definition File",
    'MOT'          => "LightWave Motion File",
    'MAPLET'       => "Maplet World File",
    'MAILTOLOC'    => "Mail Internet Location File",
    'MD8'          => "Mediator Project File",
    'MAP'          => "TECkit Mapping File",
    'MUP'          => "Music Publisher Score",
    'MINDNODE'     => "MindNode Document",
    'MCP'          => "CodeWarrior Project",
    'MSB'          => "Oracle Binary Message File",
    'MRT'          => "Stimulsoft Report File",
    'MTS'          => "MEGA Tree Session File",
    'MEG'          => "MEGA Data File",
    'MAS'          => "rFactor Track File",
    'MONEY'        => "Money Data File",
    'MBR'          => "Zune Smooth Streaming File",
    'MCWORLD'      => "Minecraft World Backup File",
    'MTF'          => "Multi Tracker File",
    'MZP'          => "WinArchiver Mountable Archive",
    'MXM'          => "Maxwell Material File",
    'MS'           => "Maxwell Script",
    'MXSKIN'       => "Maxthon Skin File",
    'MXADDON'      => "Maxthon Add-On File",
    'MAR'          => "Mozilla Archive",
    'MOL'          => "MDL Molfile",
    'MGMF'         => "MindGenius Map File",
    'MGMX'         => "MindGenius XML Map File",
    'MMIP'         => "MediaMonkey Installation Package",
    'MTA'          => "Samsung AllShare Metadata File",
    'MVP'          => "MoviePlus Project File",
    'MID'          => "MapInfo Data File",
    'MUS'          => "Minecraft Music File",
    'MCA'          => "Minecraft 'Anvil' Map File",
    'MCSP'         => "My Craft Studio Project File",
    'MBP'          => "MediaShow Burning Project File",
    'MSE'          => "MediaShow Slideshow Project File",
    'MPJ'          => "messiahStudio Project File",
    'MQO'          => "Metasequoia Document",
    'MAP'          => "Halo Map File",
    'MX5'          => "Mixcraft 5 Audio Project",
    'MK3D'         => "Matroska 3D Video File",
    'MYR'          => "Myriad Music File",
    'MUX'          => "Trackmania Music File",
    'MFIL'         => "Blizzard Software Update File",
    'MASK'         => "SpeedGrade Color Mask File",
    'MLB'          => "MyLabel Designer Deluxe Project File",
    'MYL'          => "MyLogo Maker Image",
    'MUD'          => "Mudbox 3D Scene File",
    'MPPZ'         => "MagicPlot Project File",
    'MODE'         => "Coda Syntax Mode File",
    'MGK'          => "ImageMagick Configuration File",
    'MUSE'         => "Adobe Muse Website Project",
    'MEO'          => "MEO Encrypted Archive",
    'MSHA'         => "Microsoft Help Asset File",
    'MSHI'         => "Microsoft Help Index File",
    'MUL'          => "Ultima Online Multi File",
    'MTZ'          => "MIUI Theme",
    'MPDP'         => "MixPad Project File",
    'MANI'         => "Mine-imator Project File",
    'MDZIP'        => "MagicDraw Project Archive",
    'MXV'          => "MAGIX Video File",
    'MGOURMET'     => "MacGourmet Deluxe Document",
    'MEGA'         => "Megacubo XML Metafile",
    'MAHJONGTITAN' => "S'AVE-MS Mahjong Titans Saved Game",
    'MSL'          => "Mapping Specification Language File",
    'MSL'          => "Magick Scripting Language File",
    'MODULE'       => "Drupal Module File",
    'MDC'          => "MidiCo Karaoke Audio File",
    'MD5.TXT'      => "Message Digest 5 Hash File",
    'MGOURMET4'    => "MacGourmet Deluxe 4 Document",
    'MCMAC'        => "MasterCook Mac Document",
    'MSCT'         => "MOPEKS Script File",
    'MTHD'         => "MOPEKS Method File",
    'MTXT'         => "MOPEKS Text File",
    'MMM'          => "Multiple Master Metric Data File",
    'MUSX'         => "Finale Notation File",
    'MMPZ'         => "LMMS Project File",
    'MRG'          => "Now Contact Merge Template",
    'MYO'          => "AccountEdge Company File",
    'MRP'          => "Mobile Application File",
    'MINIGSF'      => "Game Boy Advance Song File",
    'MPROJ'        => "Mine-imator Project",
    'MDS'          => "TestComplete Project File",
    'MVM'          => "Photostory Deluxe Slideshow",
    'MODFEM'       => "Femap Model",
    'MIFF'         => "Magick Image File",
    'MVG'          => "Magick Vector Graphics File",
    'MM'           => "NeXtMidas Macro File",
    'MAILSTATIONE' => "Y'Apple Mail Stationery File",
    'MLM'          => "MolMeccano File",
    'MFL'          => "ModFit LT Analysis Report File",
    'MMLP'         => "Music Macro Language Project",
    'MCSERVER'     => "Minecraft Server File",
    'MTC'          => "Make the Cut! Project",
    'MINISO'       => "Mini Image Destination File",
    'MVD'          => "MindView OS X Document",
    'MVDX'         => "MindView Windows Document",
    'MUM'          => "MATLAB Unit Operation Model File",
    'MTFF'         => "MadgeTech Data Logger Report",
    'MDR'          => "ModPlug Compressed Module",
    'MWL'          => "Super Mario World Level",
    'MAKERBOT'     => "MakerBot Print File",
    'MQ5'          => "MQL5 Source Code File",
    'M5P'          => "MachFive Preset File",
    'MPWS'         => "MathPiper Worksheet",
    'MP13'         => "Multisim 13 Project",
    'MS13'         => "Multisim 13 Circuit Design File",
    'MYNOTESBACKU' => " 'Keep My Notes Backup",
    'MCPACK'       => "Minecraft Resource Pack File",
    'MOTI'         => "Apple Motion Title Project Template",
    'MOEF'         => "Apple Motion Effect Project Template",
    'MOTN'         => "Apple Motion Generator Project Template",
    'MOTR'         => "Apple Motion Transition Project Template",
    'MF4'          => "ASAM Measurement Data Format File",
    'MCAT'         => "Adobe Lightroom CC Catalog File",
    'MOBIRISE'     => "Mobirise Project File",
    'MMG'          => "Model Master 3 Axis Flat File",
    'MSMPL_BANK'   => "Korg microSAMPLER Bank Data File",
    'MJS'          => "Node.js ES Module File",
    'MDP'          => "FireAlpaca Image",
    'MPU'          => "MPEG Layer 3 Audio File",
    'MOOV'         => "Apple QuickTime Movie",
    'MAC'          => "MacPaint Image",
    'MOVIE'        => "QuickTime Movie File",
    'MPE'          => "MPEG Movie File",
    'MAF'          => "Microsoft Access Form",
    'MAM'          => "Microsoft Access Macro",
    'MAR'          => "Microsoft Access Report",
    'MAT'          => "Microsoft Access Table Shortcut File",
    'MIC'          => "Image Composer File",
    'MAG'          => "Access Diagram Shortcut File",
    'MAS'          => "Access Stored Procedures",
    'MAW'          => "Access Data Access Page",
    'MDT'          => "GeoMedia Access Database Template",
    'MDZ'          => "Access Wizard Template",
    'MD'           => "Machine Description File",
    'MNY'          => "Microsoft Money File",
    'MVC'          => "Movie Collector Catalog",
    'MW'           => "MacWrite Text Document",
    'MSK'          => "Paint Shop Pro Mask File",
    'M1V'          => "MPEG-1 Video File",
    'MP_'          => "Mobile Phone Sound File",
    'M4U'          => "MPEG-4 Playlist",
    'MBL'          => "Logger Pro Data File",
    'MVS'          => "Microchip Verification Specification File",
    'MIF'          => "Management Information Format",
    'MSV'          => "Memory Stick Voice File",
    'MGS'          => "MGCSoft Vector Shapes File",
    'MTF'          => "MasterCook Tips",
    'MMA'          => "Master Album Maker Photo Album File",
    'MDL'          => "DigiTrakker Module",
    'MT2'          => "MadTracker 2 Module",
    'MOD'          => "ArchiCAD Module",
    'MDX'          => "Rational XDE Model File",
    'M3G'          => "Mobile 3D Graphics Program",
    'MFP'          => "Macromedia FlashPaper Document",
    'MPD'          => "File List Creator Playlist",
    'MSF'          => "Miranda IM Skin File",
    'MAX'          => "Action Replay Max Save File",
    'MP1'          => "MPEG-1 Layer 1 Audio File",
    'MED'          => "RSView Development Project",
    'MTX'          => "MetaStream Scene File",
    'MTZ'          => "Compressed MetaStream Scene File",
    'MPK'          => "Project64 Memory Pack File",
    'MZP'          => "Mozart Percussion File",
    'MAG'          => "Magic Circuit Layout File",
    'MASTER'       => "ASP.NET Master Page",
    'MNM'          => "Character Studio Marker Name File",
    'MPS'          => "Max Payne Saved Game",
    'MTF'          => "Translation Memory Translations File",
    'MUS'          => "Electronic Arts Game Music File",
    'MAP'          => "Weather Defender Map",
    'MEM'          => "Virtual Game Station Memory File",
    'MMF'          => "Microsoft Message File",
    'MEM'          => "Mnemosyne Card Collection",
    'M3D'          => "3D Model File",
    'MP2V'         => "MPEG-2 Video File",
    'M1A'          => "MPEG-1 Audio File",
    'M2A'          => "MPEG-1 Layer 2 Audio File",
    'MP4V'         => "MPEG-4 Video",
    'MQ4'          => "MQL4 Source Code File",
    'MJPG'         => "Motion JPEG Video File",
    'MUD'          => "Textease Multi User Database",
    'MIX'          => "Command & Conquer Data File",
    'MODD'         => "Sony Video Analysis File",
    'MVX'          => "Multimedia Fusion Movement Extension",
    'MSSTYLE'      => "Windows XP Unsigned Style",
    'META'         => "RealPlayer Metafile",
    'METADATA_NEV' => "R'_INDEX Spotlight Never Index File",
    'MCFI'         => "Maya Initial Fluid Cache File",
    'MCFP'         => "Maya Fluid Cache Playback File",
    'MLP'          => "Meridian Lossless Packing Audio File",
    'MOD'          => "Neverwinter Nights Module",
    'MUF'          => "Alpha Five License File",
    'MOU'          => "WinMount Compressed File",
    'MPB'          => "MyPhoneExplorer Backup File",
    'MWX'          => "MicroWorlds EX File",
    'MIG'          => "Windows Migration Backup File",
    'MATERIAL'     => "Rigs of Rods Texture Reference File",
    'MST'          => "Corel Presentations Master Template File",
    'MOFF'         => "Sony Video Data File",
    'MPJ'          => "Minitab Project File",
    'MLB'          => "Visual FoxPro Library",
    'ME2MOD'       => "Mass Effect 2 Modification File",
    'MPDCONF'      => "Music Player Daemon File",
    'MEM'          => "Parallels Desktop Memory Dump File",
    'MAP'          => "NAVIGON Map File",
    'MCF'          => "MasterCook 2 Cookbook File",
    'MSC'          => "MuseScore Composition File",
    'MSCX'         => "MuseScore Music Score File",
    'MSS'          => "MyScreenSaver Builder File",
    'MV_'          => "Movie Edit Pro Movie Backup File",
    'MYS'          => "Vineyard Captured Video File",
    'MS8'          => "Multisim 8 Circuit Design File",
    'MNU'          => "TomTom Menu File",
    'MNC'          => "AutoCAD Compiled Menu File",
    'MPZ'          => "Red Eclipse Map File",
    'MXCS'         => "Mandelbrot Explorer Color Scheme File",
    'MXFR'         => "Mandelbrot Explorer Fractal Region File",
    'MAR'          => "Mariner Calc Spreadsheet",
    'MGTHEME'      => "MacGourmet Theme File",
    'MDP'          => "Visual C++ 5 Workspace File",
    'MBB'          => "Kodak EasyShare Data File",
    'MINE'         => "Minecraft Map File",
    'MD8'          => "GarageCUBE Modul8 Project",
    'MPW'          => "Microsoft Project Workspace File",
    'MACBIN'       => "Macbinary Encoded File",
    'MFT'          => "Kaspersky File Table",
    'MNU'          => "Adobe Photoshop Menu Customization File",
    'MISSION'      => "MissionMaker Project File",
    'MCR'          => "ePSXe Memory Card File",
    'MPR'          => "FileMaker Dictionary File",
    'MMAT'         => "MindManager Map Template",
    'MMU'          => "myPM Merge Data File",
    'MTF'          => "Mortality Table File",
    'MBR'          => "Master Boot Record File",
    'MPSUB'        => "MPlayer Subtitles File",
    'MCW'          => "Monitor Calibration Wizard File",
    'MFO'          => "MobileFrame Object File",
    'MFE'          => "MobileFrame Enterprise Data File",
    'MFW'          => "MobileFrame Workflow Pack File",
    'MFV'          => "MobileFrame Device Pack File",
    'MAPX'         => "Mapjects Client Webparts File",
    'MP7'          => "Multisim 7 Project File",
    'MP9'          => "Multisim 9 Project File",
    'MS9'          => "Multisim 9 Circuit Design File",
    'MS7'          => "Multisim 7 Circuit Design File",
    'MP10'         => "Multisim 10 Project File",
    'MPZIP'        => "Multisim Pack File",
    'MIR'          => "Mini-Image Ripper Disc Image",
    'MDT'          => "Microsoft Access Data File",
    'MTM'          => "Macrofocus TreeMap File",
    'MERLINLICENS' => " 'Merlin License File",
    'MPI'          => "InstallJammer Project File",
    'MAILPLANELIC' => "N'SE     Mailplane License File",
    'MESH'         => "DirectX Mesh File",
    'MXS'          => "Painter Color Mixer Pad File",
    'MSW'          => "Painter Color Mixer Swatches File",
    'MCR'          => "Tecplot Macro",
    'MS1'          => "VirtualBus Map File",
    'M'            => "Mercury Source Code File",
    'MD'           => "Sharkport Saved Game File",
    'MAS'          => "MEGA Alignment Sequence File",
    'MF'           => "METAFONT File",
    'MXN'          => "Miinoto Exchangeable Note File",
    'MAKO'         => "Mako Template",
    'MCGAME'       => "Minecraft Game Backup File",
    'MRG'          => "MySQL Merge File",
    'MANIFEST'     => "Steam Manifest File",
    'MZZ'          => "Microsoft .NET Download Package",
    'MTT'          => "MetadataTouch Template",
    'MM6'          => "Money Manager 6 File",
    'MMM'          => "Money Manager File",
    'MGTX'         => "MindGenius XML Template File",
    'MGMT'         => "MindGenius 2-3 Template",
    'MDOWN'        => "Markdown File",
    'MD'           => "SEGA Mega Drive ROM",
    'MSH'          => "Orbiter 3D Mesh File",
    'MHP'          => "Maths Helper Plus File",
    'MMDC'         => "MediaMonkey Device Configuration File",
    'MGC'          => "Microsoft Clip Organizer Media Catalog",
    'MOD'          => "GRUB Module",
    'MLC'          => "MobaLiveCD File",
    'MCSX'         => "My Craft Studio Professional File",
    'MX5TEMPLATE'  => "Mixcraft 5 Audio Project Template",
    'MX4'          => "Mixcraft 4 Audio Project",
    'MX3'          => "Mixcraft 3 Audio Project",
    'MDX'          => "MDict Dictionary File",
    'MUI'          => "Myriad User Instrument File",
    'MXG'          => "Miinoto Exchangeable Group File",
    'MAKE'         => "Xcode Makefile Script",
    'MUX'          => "Myriad Stand-Alone Music Score",
    'MU3'          => "Myriad Packed Musical Score",
    'MML'          => "MyMailList & AddressBook File",
    'MVEX'         => "Muvee autoProducer 6 Project File",
    'MUS'          => "Doom Music File",
    'MAL'          => "MadAppLauncher Configuration File",
    'MMCOLLECTION' => "Mail Manager Collection File",
    'MPL'          => "MPL2 Subtitles File",
    'MGM'          => "MGMaps File",
    'MAP'          => "Furcadia Dream File",
    'MB'           => "Kodak EasyShare Data File",
    'MUL'          => "Deus Ex: HR Multiplexed Audio File",
    'MPR'          => "Direct Mail Project File",
    'MXDIC'        => "Maxthon Dictionary File",
    'MFCRIBBON-MS' => "MFC Ribbon Definition XML File",
    'MGOURMET3'    => "MacGourmet Deluxe 3 Document",
    'MOGG'         => "Multitrack Ogg File",
    'MEM'          => "GreekToMe Memories File",
    'MCP'          => "Megacubo Package",
    'MONEYWELL'    => "MoneyWell Account File",
    'MWLIC'        => "MoneyWell License File",
    'MIN'          => "Okuma CNC Program File",
    'MAP'          => "Leges Motus Map File",
    'MPQE'         => "Blizzard Encrypted Mo'PaQ File",
    'MOMMA'        => "Offspring Fling Replay File",
    'M12'          => "Schiller medilog ECG Raw Data File",
    'MK4'          => "Schiller medilog ECG Raw Data File",
    'MBSA'         => "Microsoft Baseline Security Analyzer File",
    'MCMETA'       => "Minecraft Animation File",
    'MP4.INFOVID'  => "Parrot AR Drone and Gyro Flyer Video",
    'MF'           => "Panda Multifile",
    'MLL'          => "Maya Plugin",
    'MAKEFILE'     => "Makefile",
    'MINIPSF'      => "Miniature PlayStation Sound Format File",
    'MINIPSF2'     => "Miniature PlayStation Sound Format File",
    'MIN'          => "Mint Source File",
    'MUI_CCCD5AE0' => "Hid User Library",
    'MMZ'          => "MiraMon Compressed Map File",
    'MMM'          => "MiraMon Maps File",
    'MDIMPORTER'   => "Metadata Importer",
    'MGSPOT'       => "MacGourmet Spotlight MetaData File",
    'MCT'          => "Windows Live Messenger Data File",
    'MMP'          => "LMMS Project File",
    'MFW'          => "Mamiya Camera Raw File",
    'MOD'          => "AMPL Model File",
    'MCUSW'        => "Nokia Firmware File",
    'MSG'          => "Fallout Message File",
    'M'            => "PC-98 Game Music File",
    'M2'           => "PC-98 Game Music File",
    'MIN'          => "MAX Interchange Notation File",
    'MTQ'          => "Mustaq Data File",
    'MODE1V3'      => "Xcode Project Data File",
    'MODE2V3'      => "Xcode Project Data File",
    'MAP'          => "Fallout Map File",
    'MX2'          => "Heroes of Might and Magic II Expansion Map",
    'MP2'          => "Heroes of Might and Magic II Map File",
    'M77T'         => "MGD77T Data File",
    'MGD77'        => "MGD77 Data File",
    'MSM'          => "Multisim Circuit Design File",
    'MOD'          => "Femap Model",
    'MDDBS'        => "Manic Digger Database",
    'MCIF'         => "MacroMolecular Crystallographic Information",
    'MAD'          => "Electronic Arts Madcow Movie File",
    'MBN'          => "Multi Boot Image",
    'MIGRATEDPHOT' => "L'IBRARY Migrated Photo Library",
    'MIGRATEDAPLI' => "R'ARY    Migrated Aperture Library",
    'MWPS'         => "Need for Speed: Most Wanted Car Attributes",
    'MAP'          => "Rigs of Rods Key Assignments File",
    'MVTX'         => "MindView Template",
    'MKS'          => "Matroska Elementary Stream File",
    'MULIB'        => "Muse Library File",
    'MPG4'         => "MPEG-4 Video File",
    'MQH'          => "MetaTrader Include File",
    'MDEX'         => "MIRCaM Data EXchange File",
    'MFD'          => "Music Finder Database",
    'MODPKG'       => "Minecraft Pocket Manager File",
    'MLPKGINSTALL' => "Support Package Installer File",
    'MAGIWOL'      => "MagiWOL File",
    'MP12'         => "Multisim 12 Project",
    'MS12'         => "Multisim 12 Circuit Design File",
    'MMV'          => "Magnex Firmware File",
    'MCFUNCTION'   => "Minecraft Commands Function File",
    'MOGRT'        => "Adobe Motion Graphics Template",
    'MCOLOR'       => "Mine-imator Interface Color File",
    'MCADDON'      => "Minecraft Pack Addon File",
    'MLX'          => "MATLAB Live Script",
    'MWL'          => "XMS Print Layout File",
    'MRF'          => "Mouse Recorder File",
    'MOHOPROJ'     => "Moho Document Data File",
    'MOHOEXPORT'   => "Moho Export Profile Document",
    'MOHOSTYLE'    => "Moho Style Document",
    'MOHOACTION'   => "Moho Action Document",
    'MOHOBRUSH'    => "Moho Action Document",
    'MOVIE'        => "Payday Movie File",
    'MCTEMPLATE'   => "Minecraft World Template",
    'MODE'         => "Ninja Kiwi Game Data File",
    'MIND'         => "MindMeister Map File",
    'MAC'          => "Application Macro File",
    'MWM'          => "Space Engineers 3D Model File",
    'MXLIFF'       => "Memsource XLIFF Localization File",
    'M3P'          => "Mach3 Plugin File",
    'MDQ'          => "Transformation Extender Database Definition",
    'MMS'          => "Transformation Extender Map Source File",
    'MSMPL_ALL'    => "Korg microSAMPLER Backup File",
    'MKD'          => "Markdown Documentation File",
    'MIO'          => "WarioWare D.I.Y. Microgame File",
    'MAP'          => "Super Mario War Map File",
    'MIN'          => "Pokemon Mini File",
    'MOZ'          => "Mozilla Cache File",
    'MCS'          => "Mathcad Image",
    'MAD'          => "Access Module Shortcut",
    'MDN'          => "Blank Access Database Template",
    'MAU'          => "Media Attachment Unit",
    'MAN'          => "Unix Manual",
    'MAP'          => "Image Map",
    'MCI'          => "Media Control Interface File",
    'MEM'          => "Macro Editor Macro",
    'MGF'          => "Materials and Geometry Format",
    'MRB'          => "Multiple Resolution Bitmap File",
    'MS-TNEF'      => "MS Transport Neutral Encapsulation Format",
    'MIP'          => "Multiple Image Print File",
    'M4E'          => "MPEG-4 Video File",
    'MPV2'         => "MPEG-2 Video Stream",
    'MM6'          => "Might and Magic 6 Saved Game",
    'MM7'          => "Might and Magic 7 Saved Game",
    'MM8'          => "Might and Magic 8 Saved Game",
    'MD'           => "MDCD Compressed Archive",
    'MVB'          => "Multimedia Viewer Book Source File",
    'MGM'          => "MGCSoft Equation Illustrator Macro",
    'MGC'          => "MGCSoft Equation Illustrator File",
    'MWS'          => "MWave DSP Synth Instrument Extract",
    'MSH'          => "Visual Communicator Project File",
    'MESH'         => "3D Mesh Model",
    'MAT'          => "V-Ray Materials File",
    'MFS'          => "MetFS Encrypted File System",
    'MPG2'         => "MPEG-2 Video File",
    'MNG'          => "Yamaha PSR Disk Manager File",
    'MATO'         => "Atomic Combat Saved Game",
    'ME'           => "Readme Text File",
    'MCRP'         => "MobyExplorer Encrypted File",
    'MCF'          => "Watchtower Library Font File",
    'MBB'          => "ManaBook Book File",
    'MBBK'         => "ManaBook Book Kit File",
    'MPF'          => "MainActor Project File",
    'M3D'          => "DIALux 3D Object File",
    'MMV'          => "MicroMV Video File",
    'MDM'          => "Mario Dash Map File",
    'MPEG4'        => "MPEG-4 File",
    'MISSION'      => "Vega Strike Mission File",
    'M15'          => "MPEG Video",
    'M75'          => "MPEG Video",
    'MET'          => "Presentation Manager Metafile",
    'MANM'         => "Vietcong Game Data File",
    'MNH'          => "Master Navigator Header File",
    'MCLEVEL'      => "Minecraft Map File",
    'MDBHTML'      => "Microsoft Access Database HTML File",
    'MD0'          => "Adobe Photoshop Metadata Cache File",
    'MT9'          => "MT9 Audio File",
    'MARS'         => "Adobe MARS File",
    'MSP'          => "ClarisWorks Dictionary File",
    'MCXE'         => "MedicinesComplete Data File",
    'MUSA'         => "Aleph One Music File",
    'MVR'          => "IBM HotMedia Multimedia File",
    'MAP'          => "Mapjects Server Webparts File",
    'MIT'          => "MineEdit Inventory Template File",
    'MAKE'         => "Drush Makefile",
    'MBW'          => "MBRWizard Archive",
    'MDL'          => "Lectra Modaris Clothing Design File",
    'MXF'          => "Maxis Font File",
    'MARKDN'       => "Markdown File",
    'MML'          => "Microsoft Clip Organizer File",
    'MMW'          => "Microsoft Clip Organizer Media Catalog File",
    'MOB'          => "MOBTV Video File",
    'MDD'          => "MDict Resource File",
    'MUZ'          => "MUZ Audio File",
    'MBK'          => "dBASE IV Multiple Index Backup File",
    'ME'           => "Puppy Linux Partition Flag File",
    'MSIF'         => "MyLabel Designer Deluxe Data File",
    'MAZ'          => "Hover! Maze File",
    'MU'           => "Kerbal Space Program Mesh File",
    'MBM'          => "Kerbal Space Program Texture File",
    'MINI2SF'      => "Nintendo DS Sound Information File",
    'MPEG1'        => "MPEG-1 Video File",
    'ME'           => "Temporary Delete Me File",
    'MSF'          => "Blue Card Manager Merit Badge Mastersheet File",
    'MBT'          => "Blue Card Manager Merit Badge Template File",
    'MCW'          => "MacWrite II Document",
    'MININCSF'     => "NCSF Nintendo DS Audio File",
    'MAPSDATA'     => "iOS Maps Data File",
    'MIX'          => "MotoGP Game File",
    'MWAND'        => "GarageBand MagicMentor Template",
    'MDL0'         => "Wii Model File",
    'MJBOOKTEMPLA' => "E'MacJournal Book Template",
    'MSBT'         => "Nintendo Wii Galaxy Dialogue File",
    'MDL'          => "Luigi's Mansion 3D Model File",
    'MPEG2'        => "MPEG-2 Video File",
    'MJPEG'        => "Motion JPEG Video File",
    'MT2S'         => "MPEG-2 Transport Stream File",
    'MP8'          => "Multisim 8 Project",
    'MRY'          => "Tomboy Industrees Memory File",
    'MYD'          => "Everfine Photomoetric Results File",
    'MSH1XML'      => "Monad Display Configuration File",
    'MRSN'         => "Mersenne Source Code File",
    'NES'          => "Nintendo (NES) ROM File",
    'N64'          => "Nintendo 64 Emulator ROM File",
    'NRG'          => "Nero CD/DVD Image File",
    'NB'           => "Mathematica Notebook",
    'NDX'          => "dBASE Index File",
    'NBK'          => "NovaBACKUP Job File",
    'NIB'          => "Interface Builder User Interface File",
    'NDS'          => "Nintendo DS Game ROM",
    'NZB'          => "NewzBin Usenet Index File",
    'NEF'          => "Nikon Electronic Format RAW Image",
    'NWP'          => "Magentic Wallpaper File",
    'NOTEBOOK'     => "SMART Notebook File",
    'NRI'          => "Nero ISO CD Compilation File",
    'NUMBERS'      => "Numbers Spreadsheet File",
    'NKI'          => "KONTAKT Instrument File",
    'NBU'          => "Nokia Phone Backup File",
    'NOT'          => "Notation File",
    'NRA'          => "Nero Audio Compilation",
    'NBA'          => "Nero BackItUp Archive",
    'NC'           => "Mastercam Numerical Control File",
    'NBP'          => "Mathematica Player Notebook File",
    'NMF'          => "ArcGIS Explorer Map File",
    'NB0'          => "Device Boot Loader Image",
    'NWD'          => "Navisworks Document",
    'NWF'          => "Navisworks File Set",
    'NBD'          => "NovaBACKUP File",
    'NOMEDIA'      => "Android No Media File",
    'NCORX'        => "Adobe Encore Project",
    'NBS'          => "Minecraft Note Block Studio File",
    'NTP'          => "Natron Project File",
    'NGRR'         => "Guitar Rig Preset",
    'NT'           => "Windows NT Startup File",
    'NITF'         => "National Imagery Transmission Format File",
    'NFO'          => "Warez Information File",
    'NCO'          => "Nero BackItUp File",
    'NCD'          => "Nero CoverDesigner File",
    'NY'           => "Audacity Nyquist Plug-in",
    'NIF'          => "Gamebryo Model File",
    'NVC'          => "NeroVision Express Project File",
    'NSF'          => "Lotus Notes Database",
    'NETA'         => "Netica Binary File",
    'NWM'          => "Sony NWM Display Screen File",
    'NWC'          => "NoteWorthy Composer File",
    'NTN'          => "NOTION Song File",
    'NP'           => "Portfolio NetPublish File",
    'NPT'          => "Portfolio NetPublish Template",
    'NET'          => "netViz Project File",
    'NET'          => "FileMaker Networking Module",
    'NVC'          => "Nikon Vignette Correction File",
    'NRT'          => "Nokia Ringtone",
    'NTH'          => "Nokia Series 40 Theme File",
    'NYF'          => "myBase Database File",
    'NMIND'        => "NovaMind Mind Map File",
    'NSS'          => "Magentic Screensaver File",
    'N3PMESH'      => "Knight Online 3D Mesh File",
    'NSA'          => "Nullsoft Streaming Audio File",
    'NSV'          => "Nullsoft Streaming Video File",
    'NAV2'         => "WinAVI Temporary Navigation File",
    'NDK'          => "Lotus Notes Design Elements File",
    'NK2'          => "Outlook 2002 Nickname File",
    'NICK'         => "Outlook 2000 Nickname File",
    'NLTRACK'      => "NoLimits Roller Coaster Track File",
    'NCF'          => "No Cache File",
    'NDC'          => "Personal Communications Settings File",
    'NFO'          => "System Information File",
    'NGAGE'        => "N-Gage Game File",
    'NOTES'        => "Memento Notes File",
    'NJB'          => "Nikon Photo Index File",
    'NWV'          => "Dragon NaturallySpeaking User Archive",
    'NDF'          => "SQL Server Secondary Database File",
    'NSBMD'        => "Nintendo DS Model File",
    'NSBTX'        => "Nintendo DS Model Texture File",
    'NSBCA'        => "Nintendo DS Model Animation File",
    'NBF'          => "Nokia Backup File",
    'ND'           => "QuickBooks Network Data File",
    'NPL'          => "Nokia Playlist File",
    'NXC'          => "Not eXactly C Source Code File",
    'NRW'          => "Nikon Raw Image File",
    'NRL'          => "Autonomy Interwoven Link File",
    'NCOR'         => "Adobe Encore Project File",
    'NBI'          => "Nero BackItUp Information File",
    'NTRK'         => "Pacific FIghters Online Track File",
    'NJI'          => "Nero Job Information File",
    'NEU'          => "Pro/ENGINEER Neutral File",
    'NLS'          => "Microsoft National Language Support File",
    'NPR'          => "Nuendo Project File",
    'NARC'         => "Nintendo DS Archive File",
    'NCX'          => "EPUB Navigation Control XML File",
    'NNI'          => "ANNI Neural Network Investing File",
    'NNP'          => "ANNI Neural Network Portfolio File",
    'NCB'          => "Visual C++ IntelliSense Database",
    'NSQ'          => "NScheduler Data File",
    'NCFG'         => "ArcGIS Explorer Configuration File",
    'NMC'          => "ArcGIS Explorer Map Content File",
    'NQC'          => "Not Quite C Source Code File",
    'NRC'          => "Nero Disc Compilation File",
    'NUV'          => "NuppelVideo File",
    'NFC'          => "Nokia Phone Backup Copy File",
    'NFB'          => "Nokia Phone Backup File",
    'NRD'          => "Nero DVD-Video Compilation File",
    'NRB'          => "Nero CD-ROM Boot Compilation",
    'NRM'          => "Nero Mixed Mode CD Compilation",
    'NRU'          => "Nero UDF CD-ROM Compilation",
    'NFS'          => "Network File System Temporary File",
    'NBC'          => "Next Byte Codes Source Code File",
    'NBM'          => "NetBeans Module",
    'NAP'          => "McAfee ePO Network Associates Package",
    'NED'          => "OMNeT++ Network Description File",
    'NPF'          => "NTI Partition File",
    'NBS'          => "NTI Backup Set",
    'NPS'          => "NTI Partition Set",
    'NFL'          => "Nokia Flash Lite Package",
    'NDL'          => "Lotus Notes Doclink File",
    'NWS'          => "Windows Live Mail Newsgroup File",
    'NSI'          => "NSIS Script",
    'NSH'          => "NSIS Header File",
    'NWC'          => "Navisworks Cache File",
    'NKX'          => "Kontakt Monolith Container File",
    'NKS'          => "Kontakt Monolith Container",
    'NKM'          => "Kontakt Multi Instrument File",
    'NKB'          => "Kontakt Audio Bank",
    'NCW'          => "Native Compressed Wave File",
    'NGP'          => "NeoGeo Pocket ROM",
    'NGC'          => "Xilinx Generated Netlist File",
    'NGD'          => "Xilinx Netlist File",
    'NESSUS'       => "Nessus Network Security Scanner File",
    'NC'           => "NetCDF File",
    'NTF'          => "Lotus Note Template",
    'NL2SCRIPT'    => "NoLimits 2 Script File",
    'NV2'          => "NewViews 2 Database File",
    'NFM'          => "Delphi .NET Form File",
    'NT'           => "theWord New Testament Text Module",
    'NTX'          => "theWord Encrypted New Testament Text Module",
    'NV2'          => "Navionics Chart File",
    'NUPKG'        => "NuGet Package",
    'NUSPEC'       => "NuGet Specification File",
    'NETSPD'       => "NetSpot Survey Project File",
    'NBK'          => "Data Backup Job File",
    'NBD'          => "Data Backup Data File",
    'NKC'          => "Kontakt Library Data File",
    'NLOGO'        => "NetLogo Model File",
    'NLOGO3D'      => "NetLogo 3D Model File",
    'NLS'          => "NetLogo Source File",
    'NJX'          => "NJStar Document",
    'NEXE'         => "Chrome Native Client Executable",
    'NUMBERS-TEF'  => "Numbers iCloud Document",
    'NOTE'         => "Notessimo Composition",
    'NEKO'         => "Neko Source Code File",
    'NML'          => "Traktor Collection File",
    'NK'           => "NUKE Script",
    'NOD'          => "NetObjects Fusion File",
    'NEX'          => "Navigator Extension",
    'NARRATIVE'    => "Narrator Document",
    'NB'           => "Nota Bene File",
    'NVV'          => "NVIDIA Vertex Shader File",
    'NOT'          => "Finale Note File",
    'NCT'          => "Now Contact File",
    'NWP'          => "Now Contact WP Document",
    'NUD'          => "Now Up-To-Date Calendar File",
    'NMSV'         => "Native Instruments Massive Sound File",
    'NBAK'         => "Neat Backup File",
    'NRMLIB'       => "Neat Cabinet File",
    'NW'           => "Node-Webkit App Package",
    'NPA'          => "Steins;Gate Archive",
    'NCSS'         => "NCSS Dataset File",
    'NAR'          => "Nexon game archive",
    'NWO'          => "NWChem Output File",
    'NPS'          => "Natron Node Presets File",
    'NS1'          => "Nestopia Save State",
    'NSX'          => "AppStudio Project",
    'NMEA'         => "NMEA Data File",
    'NC'           => "mcrypt Encrypted File",
    'N3R'          => "Panasonic Security System Video File",
    'NVP'          => "NVivo for Windows Project",
    'NUPROJ'       => "NuGet Build Project",
    'NP4'          => "NetPoint 4 Schedule File",
    'NRO'          => "Nintendo Switch Executable File",
    'NATVIS'       => "Natvis VC++ Debugger Visualization File",
    'NCA'          => "Nintendo Content Archive",
    'NS3'          => "Lotus Notes 3 Database",
    'NS4'          => "Lotus Notes 4 Database",
    'NN'           => "Nero CD File List",
    'NTX'          => "Clipper Index File",
    'NB7'          => "NovaBACKUP Output File",
    'NTC'          => "Camera Control Pro Custom Curves File",
    'NTF'          => "MediaFACE II CD Label File",
    'NCD'          => "NTI CD-Maker Disc Image",
    'NSF'          => "NES Sound Format File",
    'NWCTXT'       => "NoteWorthy Composer Text File",
    'NXG'          => "eSite Builder NXG Web Page",
    'NUP'          => "Smart Security Update File",
    'NAV'          => "Id Tech 3 Bot Navigation File",
    'NBF'          => "Backup Now Archive",
    'N-GAGE'       => "N-Gage Application",
    'NCR'          => "NCR Image",
    'NPP'          => "Art Explosion Publisher Pro Document",
    'NFO'          => "Age of Empires Player File",
    'NDB'          => "ClamAV Extended Signature File",
    'NBP'          => "NeoBook Plugin File",
    'NCT'          => "Nero CoverDesigner Template",
    'NAZ'          => "Total Overdose Game Data File",
    'NVF'          => "Creative Labs NVF Audio File",
    'NBK'          => "SMART Notebook File",
    'NDIF'         => "Nokia Data File",
    'NDIF'         => "Apple New Disk Image Format File",
    'NA2'          => "Netscape Address Book File",
    'NV'           => "MAME NVRAM File",
    'NCW'          => "Nero CoverDesigner Wizard File",
    'NMP'          => "NewsMaker Project File",
    'NGT'          => "Noni GPSPlot Track File",
    'NVDL'         => "NVDL Script",
    'NMBTEMPLATE'  => "Numbers Spreadsheet Template",
    'NWP'          => "Navisworks Presenter Material Palette File",
    'NPL'          => "Xilinx ISE 5-6 Project File",
    'NPL'          => "Cubase Library File",
    'NDOC'         => "Naver Word",
    'NKP'          => "Kontakt Presets File",
    'NAM'          => "MODFLOW Name File",
    'NVRAM'        => "VMware NVRAM File",
    'NGC'          => "NeoGeo Pocket Color ROM",
    'NBE'          => "Nessus Report File",
    'NSR'          => "Nessus Security Report File",
    'NBT'          => "Minecraft Named Binary Tag File",
    'NLELEM'       => "NoLimits Track Element File",
    'NV'           => "NewViews Database File",
    'NSBTA'        => "Nintendo DS Texture Animation File",
    'NKM'          => "Mario Kart DS Track Data File",
    'NUPKG'        => "NetUpdate Package",
    'NETSPM'       => "NetSpot Map File",
    'NVI'          => "NVIDIA Driver File",
    'NTFS'         => "NTFS Partition File",
    'N2'           => "Nitrous Minecraft GLSL Shader File",
    'NFS11SAVE'    => "Need for Speed: Hot Pursuit Save File",
    'NMAP'         => "NaviComputer Map File",
    'NML'          => "NSMB Editor Exported Level File",
    'N3D'          => "Nuclear 3D File",
    'NBH'          => "ROM Update Utility Image File",
    'NPFX'         => "Norton Internet Security Firewall Settings File",
    'NDS'          => "Nero DiscSpan Compilation File",
    'N'            => "Neko Bytecode File",
    'NIM'          => "Nim Source Code File",
    'NM2'          => "Navitel Map File",
    'NM3'          => "Navitel 5 Map File",
    'NETWORKCONNE' => "T'Apple Network Connect Document",
    'NWM'          => "Nisus Macro",
    'NGLOSS'       => "Nisus Writer Glossary",
    'NWCP'         => "Nisus Clipboard Document",
    'NAS'          => "Nastran Input File",
    'NL'           => "Note Ledge File",
    'NRBAK'        => "NeatReceipts Backup File",
    'NWBAK'        => "NeatWorks Backup File",
    'NDX'          => "Neat 5 Archive File",
    'NRX'          => "Neat Receipt Folder File",
    'NRT'          => "Neat Contact File",
    'NRF'          => "Neat Document Folder File",
    'NGS'          => "Steins;Gate Game File",
    'NVA'          => "NVA Document",
    'NOZZLELIBRAR' => " 'Painter Nozzle Library",
    'NSBVA'        => "Nintendo DS Visibility Animation File",
    'NNT'          => "Eudora Address Book File",
    'NL'           => "Natron Layout File",
    'NZ'           => "NanoZip Compressed File",
    'NDA'          => "Nero Backup File",
    'NOL'          => "Nokia Operator Logo File",
    'NLVM'         => "NoLimits Virtual Machine File",
    'NSL'          => "nsL Script",
    'NUT'          => "Squirrel Script",
    'NXL'          => "Nextlabs Encrypted Data File",
    'NUS3BANK'     => "Super Smash Bros. Audio Bank File",
    'NFV'          => "Netflix Video File",
    'NC1'          => "Mastercam Numerical Control File",
    'NST'          => "Outlook Connector for Notes File",
    'NWCAB'        => "Neat Cabinet File",
    'NWDB'         => "Neat Database File",
    'NPY'          => "Python NumPy Array File",
    'NMA'          => "NMEA Data File",
    'NPT'          => "NetPoint Schedule File",
    'NPK'          => "MikroTik Software Package",
    'NOY'          => "NOY Backup File",
    'NOTE'         => "Notability Note File",
    'NFS'          => "Netflix Subtitle File",
    'NFA'          => "Netflix Audio File",
    'NFI'          => "Netflix Information File",
    'NOP'          => "WangReal Engine Game Data Archive",
    'NMM'          => "Samsung Memo File",
    'NEW'          => "New G-Suite File",
    'NSP'          => "Nintendo Switch Package",
    'NS2'          => "Lotus Notes 2 Database",
    'NCH'          => "Outlook Express Folder File",
    'NOW'          => "Readme File",
    'NAP'          => "Napster Secured Music File",
    'NFF'          => "Neutral File Format",
    'NEO'          => "NeoChrome Bitmap Image",
    'NAV'          => "MSN Application Extension File",
    'NRS'          => "NovaBACKUP Restore Script",
    'NVL'          => "UniChem Results File",
    'NST'          => "NoiseTracker Module",
    'NTS'          => "Lotus Notes Traveler Server Config File",
    'NFI'          => "Dreambox Disc Image",
    'NFO'          => "Folio Views Infobase File",
    'NAP'          => "NAP Metafile",
    'ND5'          => "Renamed NDS File",
    'NAM'          => "G.E.C.K. Mod Data File",
    'NAM'          => "Aqua3D Network File",
    'NFTR'         => "Nintendo DS Font Type File",
    'NCGR'         => "Nintendo DS Title Graphics File",
    'NCLR'         => "Nintendo DS Color Palette File",
    'NSCR'         => "Nintendo DS Title Screen File",
    'NLM'          => "Nokia Logo File",
    'N3D'          => "Super 3D Noah's Ark Data File",
    'NUT'          => "NUT Video File",
    'NLPX'         => "NoLimits Package",
    'NM'           => "Space Engine Nebula Model File",
    'NVM'          => "PlayStation 2 BIOS Configuration File",
    'NWELICENSE'   => "Nisus License",
    'NEOSAVE'      => "Neopets Save File",
    'NAAC'         => "Namco AAC File",
    'OTF'          => "OpenType Font",
    'OBJ'          => "Wavefront 3D Object File",
    'ODT'          => "OpenDocument Text Document",
    'OCX'          => "ActiveX Control",
    'OLD'          => "Backup File",
    'OGG'          => "Ogg Vorbis Audio File",
    'OMF'          => "Open Media Framework File",
    'ODP'          => "OpenDocument Presentation",
    'ODS'          => "OpenDocument Spreadsheet",
    'OV2'          => "TomTom Points of Interest Database",
    'OPML'         => "Outline Processor Markup Language File",
    'OFX'          => "Open Financial Exchange File",
    'OGV'          => "Ogg Video File",
    'OVF'          => "Open Virtualization File",
    'OEACCOUNT'    => "Windows Mail Account File",
    'OSZ'          => "Osu! Beatmap File",
    'OUT'          => "Output File",
    'OBI'          => "Outlook RSS Subscription File",
    'ORA'          => "Oracle Database Configuration File",
    'ORIG'         => "Original File",
    'OSM'          => "OpenStreetMap Map File",
    'OSDX'         => "Search Connector Description File",
    'OTRKEY'       => "OnlineTvRecorder Encoded Video File",
    'OPDOWNLOAD'   => "Opera Partially Downloaded File",
    'OBK'          => "Backup File",
    'OMG'          => "Image File",
    'OBML16'       => "Opera Mini Saved Web Page",
    'ODIN'         => "Locky Ransomware Encrypted File",
    'OPJU'         => "Origin Unicode Project",
    'ORI'          => "Original File",
    'OEB'          => "Outlook Express Backup Wizard File",
    'OLB'          => "OLE Object Library",
    'OFT'          => "Outlook File Template",
    'OPS'          => "Office Profile Settings File",
    'OFF'          => "Object File Format",
    'ODG'          => "OpenDocument Graphic File",
    'ODF'          => "OpenDocument Formula",
    'OTT'          => "OpenDocument Document Template",
    'OTP'          => "OpenDocument Presentation Template",
    'OTH'          => "OpenDocument HTML Template",
    'OTS'          => "OpenDocument Spreadsheet Template",
    'ORF'          => "Olympus RAW File",
    'OO3'          => "OmniOutliner 3 File",
    'O'            => "Compiled Object File",
    'OBJ'          => "Relocatable Object Code",
    'ODEX'         => "Optimized Dalvik Executable",
    'OAB'          => "Offline Address Book",
    'OGM'          => "Ogg Media File",
    'OPX'          => "OrgPlus Org Chart",
    'OTA'          => "OTA Bitmap Image",
    'OYX'          => "Approach Alternate Database Index",
    'OKT'          => "Oktalyzer Module",
    'OVE'          => "Overture Musical Score",
    'OTLN'         => "Opal Outline File",
    'OMO'          => "OMake Object File",
    'OLA'          => "Online Access File",
    'OCA'          => "Custom Control Library Type File",
    'ODX'          => "BizTalk Server Orchestration File",
    'OMF'          => "OMF Interchange Image File",
    'OGNC'         => "Dynamic Web Page",
    'OMG'          => "OpenMG Audio File",
    'OPX'          => "FlipAlbum Photo Album File",
    'ODM'          => "OverDrive Media File",
    'OPT'          => "Options File",
    'OFC'          => "Open Financial Connectivity File",
    'OPD'          => "OmniPage Document",
    'ONE'          => "OneNote Document",
    'OMX'          => "OtsAV Media Library Information File",
    'OTS'          => "OtsAV Album File",
    'OFL'          => "Ots File List",
    'OB!'          => "Orbit Downloader Incomplete Download",
    'OMA'          => "Sony OpenMG Music File",
    'OND'          => "Lotus Notes Encapsulated Memo File",
    'OVPN'         => "OpenVPN Configuration File",
    'OWL'          => "OWL Source Code File",
    'OTL'          => "NoteTab Outline File",
    'OGA'          => "Ogg Vorbis Audio File",
    'OVA'          => "Open Virtual Appliance",
    'OMP'          => "Office Manager Document Archive",
    'OR6'          => "Lotus Organizer 6 File",
    'OXT'          => "Apache OpenOffice Extension",
    'ONEPKG'       => "Microsoft OneNote Package File",
    'OEM'          => "OEM Setup File",
    'OGX'          => "Ogg Vorbis Multiplexed Media File",
    'ODB'          => "OpenDocument Database",
    'ODC'          => "Office Data Connection File",
    'OPF'          => "Open Packaging Format File",
    'OTM'          => "Outlook Macro File",
    'OSS'          => "Microsoft Outlook Saved Search File",
    'ONETOC2'      => "Microsoft OneNote Table of Contents File",
    'OBML'         => "Opera Mini Saved Web Page",
    'OVW'          => "Logic Pro Overview File",
    'OGF'          => "S.T.A.L.K.E.R. Model File",
    'OLK14MESSAGE' => "Outlook Message File",
    'OBD'          => "Office Binder Document",
    'OST'          => "Outlook Offline Data File",
    'OSC'          => "OpenStreetMap Change File",
    'OUT'          => "Compiled Executable File",
    'OCT'          => "Radiance Octree File",
    'OQY'          => "Excel OLAP Query File",
    'OCTEST'       => "Xcode Objective-C Unit Test Bundle",
    'OPJ'          => "OrCAD Project File",
    'OMOD'         => "Oblivion Mod Archive",
    'OSR'          => "Osu! Replay File",
    'OSZ'          => "OpenLP Service File",
    'ONT'          => "theWord Bible Text Module",
    'OT'           => "theWord Old Testament Text Module",
    'ONTX'         => "theWord Encrypted Bible Text Module",
    'OTX'          => "theWord Encrypted Old Testament Text Module",
    'OC5'          => "openCanvas 5 Event File",
    'OCI'          => "openCanvas Image",
    'OC3'          => "openCanvas 3 Event File",
    'OC4'          => "openCanvas 4 Event File",
    'OFM'          => "Melco Embroidery File",
    'OAM'          => "Adobe Edge Animate Widget File",
    'ODL'          => "Object Description Language File",
    'OCD'          => "OCAD Map File",
    'OSK'          => "Osu! Skin File",
    'ORA'          => "OpenRaster Image File",
    'OLM'          => "Mac Outlook Database File",
    'OPLC'         => "Nokia Operator Logo File",
    'OBB'          => "Android Opaque Binary Blob File",
    'OBW'          => "Superior Drummer Sounds File",
    'OZB'          => "MU Online Image File",
    'OVH'          => "OMSI Vehicle Configuration File",
    'OL'           => "Valve Hammer Object Layout File",
    'OFFICEUI'     => "Microsoft Office UI Customization File",
    'OLP'          => "Office Live Package",
    'OIV'          => "OpenIV Mod Package File",
    'ODTTF'        => "Obfuscated OpenType Font",
    'OWX'          => "OutWit Hub Automator File",
    'OMP'          => "OpenMind Windows Document",
    'OBML15'       => "Opera Mini Saved Web Page",
    'OAT'          => "Android Optimized Application File",
    'OMS'          => "HP Printer Substrate Presets Package File",
    'OPJ'          => "Origin Project",
    'OGWU'         => "Origin Unicode Workbook File",
    'OGGU'         => "Origin Unicode Graph File",
    'OTPU'         => "Origin Unicode Graph Template",
    'OGMU'         => "Origin Unicode Matrix File",
    'ODS'          => "Outlook Express 5 Mailbox",
    'OTF'          => "OpenDocument Formula Template",
    'OCR'          => "FAXGrapper Fax Text File",
    'OS'           => "ObjectScript Source File",
    'ORX'          => "RadiantOne VDS Database Schema",
    'ORG'          => "Lotus Organizer File",
    'OTG'          => "OpenDocument Graphic Template",
    'ODC'          => "OpenDocument Chart File",
    'OTC'          => "OpenDocument Chart Template",
    'ODI'          => "OpenDocument Image",
    'OTI'          => "OpenDocument Image Template",
    'ODM'          => "OpenDocument Master Document",
    'OPF'          => "FlipAlbum File",
    'ODB'          => "ABAQUS Database",
    'OTB'          => "Nokia Over The Air Bitmap Image",
    'OVW'          => "Cubase WAVE Overview File",
    'OFM'          => "OmniForm Form",
    'OVL'          => "Rollercoaster Tycoon 3 Data File",
    'OPF'          => "FlipViewer FlipBook File",
    'OVA'          => "Octava Musical Score",
    'OTF'          => "OpenTuft Tufting Design File",
    'OWG'          => "OutWit Gear Database",
    'OWC'          => "OutWit Catch Database",
    'OWM'          => "OutWit XML Mashup File",
    'OMCS'         => "Office Manager Access File",
    'OR4'          => "IBM Lotus Organizer 97 GS File",
    'OR5'          => "Lotus Organizer 5 File",
    'OCE'          => "Open Catalog Extension Connection File",
    'ORT'          => "Rich Text Editor Document",
    'OPAX'         => "Microsoft Office User Settings File",
    'OAR'          => "OpenSimulator Archive",
    'OBZ'          => "Compressed 3D Object File",
    'OLK'          => "Outlook Address Book File",
    'OGZ'          => "Cube 2 Map File",
    'ORDEREDTEST'  => "Visual Studio Ordered Test File",
    'OPTS'         => "Linux Configuration Options File",
    'OZ'           => "Opera Job Management Compressed File",
    'OSP'          => "OpenShot Project File",
    'OEX'          => "Opera Extension",
    'OSAX'         => "AppleScript Scripting Addition",
    'OBP'          => "Bryce Object File",
    'OLK14NOTE'    => "Outlook Note File",
    'OEB'          => "Open eBook File",
    'OLK14GROUP'   => "Outlook Group File",
    'OLK14EVENT'   => "Outlook Calendar Event File",
    'OLK14CONTACT' => "Outlook Contact File",
    'OLK14SIGNATU' => "E'Outlook Signature File",
    'OLK14CATEGOR' => " 'Outlook Category File",
    'OLK14MAILACC' => "U'NT Outlook Mail Account File",
    'OLK14MSGSOUR' => "E'Outlook Email Message Data File",
    'OSB'          => "OpenStreetMap Binary Map File",
    'OVR'          => "The Overlay Maker Overlay File",
    'OVP'          => "The Overlay Maker Package File",
    'OFR'          => "OptimFROG Audio File",
    'OLB'          => "OrCAD Symbol Library File",
    'OBT'          => "Openbox Theme File",
    'OXYGENE'      => "Oxygene Project File",
    'OLT'          => "Orbit Downloads List",
    'OPD'          => "Durango Document",
    'OTZ'          => "OpenLP Theme File",
    'OCR'          => "Subtitle Workshop OCR Script",
    'OEM'          => "OEMEdit Save File",
    'OXPS'         => "OpenXPS File",
    'OCC'          => "Oceanic DataPool File",
    'OPUS'         => "Opus Audio File",
    'OSU'          => "Osu! Script",
    'OSC'          => "Obix Source Code File",
    'OZJ'          => "MU Online Image File",
    'OZT'          => "MU Online Image File",
    'OPAL'         => "Microsoft Office User Settings File",
    'OP'           => "OpenPAT Report",
    'OP2'          => "Nastran Output File",
    'OP4'          => "Nastran Output File",
    'OVOLOG'       => "ooVoo Log File",
    'OEBZIP'       => "Zipped Open eBook File",
    'OLL'          => "TrialDirector Object Load List",
    'OO3TEMPLATE'  => "OmniOutliner Template",
    'OB2'          => "Oberon-2 Source Code File",
    'OPEICO'       => "Opeico Text File",
    'ORB'          => "Original eBook Reader File",
    'OLK14MSGATTA' => "H'Outlook 2011 Email Message Attachment File",
    'OLK15MSGATTA' => "H'Outlook 2016 Email Message Attachment File",
    'OGW'          => "Origin Workbook File",
    'OTW'          => "Origin Workbook Template",
    'OTWU'         => "Origin Unicode Workbook Template",
    'OGG'          => "Origin Graph File",
    'OTP'          => "Origin Graph Template",
    'OGM'          => "Origin Matrix File",
    'OTM'          => "Origin Matrix Template",
    'OTMU'         => "Origin Unicode Matrix Template",
    'OGS'          => "Origin LabTalk Script File",
    'OCIMF'        => "OCIMF HVPQ File",
    'OPK'          => "GCW Zero Open Package",
    'OSB'          => "Osu! Storyboard File",
    'OBF'          => "OsmAnd Offline Map File",
    'ODIF'         => "Open Document Interchange Format",
    'ODF'          => "Open Document File",
    'OR2'          => "Lotus Organizer 2 File",
    'OR3'          => "IBM Lotus Organizer 97 File",
    'OSX'          => "PowerPC Executable File",
    'OPENBSD'      => "OpenBSD Readme File",
    'ODO'          => "Online Operating System Write Document",
    'OD'           => "Mascopt Graph Request File",
    'ODF'          => "Battlezone Object Definition File",
    'OLK14TASK'    => "Outlook Task File",
    'OLK14PREF'    => "Outlook Preferences File",
    'OFR'          => "SMS Offer Manager File",
    'OPT'          => "Opterecenja File",
    'ORC'          => "Voyetra Digital Orchestrator File",
    'OW'           => "Free Pascal 1.0.x Object File",
    'OGS'          => "Origons Movie Data File",
    'ORE'          => "Ore Executable File",
    'OOK'          => "Arachne Batch Script",
    'OPTIONS'      => "SE-SOFT Configuration File",
    'ORV'          => "Oracom Video File",
    'OPT'          => "AGT Game Data File",
    'ONETOC'       => "Microsoft OneNote Table of Contents File",
    'OVX'          => "Object-based Visual Application Language File",
    'OTH'          => "Origin Graph Theme File",
    'OIS'          => "Origin Analyses Theme File",
    'ODT'          => "Origin Dialog Theme File",
    'OIF'          => "Origin Import Filter File",
    'OFP'          => "Origin Function Plot Theme File",
    'PCT'          => "Picture File",
    'PDF'          => "Portable Document Format File",
    'PL'           => "Perl Script",
    'PNG'          => "Portable Network Graphic",
    'PPS'          => "PowerPoint Slide Show",
    'PPT'          => "PowerPoint Presentation",
    'PS'           => "PostScript File",
    'PSD'          => "Adobe Photoshop Document",
    'PHP'          => "PHP Source Code File",
    'PKG'          => "Mac OS X Installer Package",
    'PY'           => "Python Script",
    'PLUGIN'       => "Mac OS X Plugin",
    'PDB'          => "Program Database",
    'PSPIMAGE'     => "PaintShop Pro Image",
    'PAGES'        => "Pages Document",
    'PPTX'         => "PowerPoint Open XML Presentation",
    'PRF'          => "Outlook Profile File",
    'PART'         => "Partially Downloaded File",
    'PFC'          => "AOL Personal File Cabinet",
    'PMD'          => "PageMaker Document",
    'PST'          => "Outlook Personal Information Store File",
    'PUB'          => "Publisher Document",
    'PSP'          => "PaintShop Pro Image File",
    'PPM'          => "Portable Pixmap Image File",
    'PRF'          => "Windows System File",
    'PRG'          => "Program File",
    'PDS'          => "PowerDirector Script File",
    'PLIST'        => "Mac OS X Property List File",
    'PRX'          => "Windows Media Profile File",
    'PAS'          => "Pascal Source File",
    'P12'          => "Personal Information Exchange File",
    'PGP'          => "PGP Security Key",
    'PSF'          => "Photoshop Proof Settings File",
    'PRPROJ'       => "Premiere Pro Project",
    'PK3'          => "Quake 3 Engine Game Data File",
    'PICTCLIPPING' => "Picture Clipping File",
    'PCH'          => "Precompiled Header File",
    'PLT'          => "AutoCAD Plotter Document",
    'PPTM'         => "PowerPoint Open XML Macro-Enabled Presentation",
    'PPSX'         => "PowerPoint Open XML Slide Show",
    'PROPERTIES'   => "Java Properties File",
    'PLS'          => "Audio Playlist",
    'PLN'          => "ArchiCAD Project File",
    'PFX'          => "PKCS #12 Certificate File",
    'POD'          => "Perl POD File",
    'PTF'          => "Pro Tools 7 Session File",
    'PPP'          => "Serif PagePlus Document",
    'PACKAGE'      => "Electronic Arts Game Package File",
    'PRJ'          => "Project File",
    'PDB'          => "Palm Desktop Database File",
    'PRC'          => "Mobipocket eBook File",
    'PGN'          => "Portable Game Notation File",
    'PVM'          => "Parallels Virtual Machine",
    'PXM'          => "Pixelmator Image File",
    'PET'          => "Puppy Linux Install Package",
    'PDX'          => "Adobe Acrobat Index File",
    'PTZ'          => "E-Transcript Bundle File",
    'PVR'          => "POWERVR Texture File",
    'PAF.EXE'      => "PortableApps.com Program File",
    'PCR'          => "PCMark Vantage Benchmark File",
    'PSH'          => "Photodex Slide Show",
    'PAC'          => "Proxy Auto-Config File",
    'PCC'          => "Mass Effect Package",
    'PPF'          => "Edgecam Pathtrace Part File",
    'PRT'          => "Creo Parametric Part File",
    'PS1'          => "Windows PowerShell Cmdlet File",
    'PROFILE'      => "Bash Shell Profile",
    'PRO'          => "Qt Project File",
    'PMF'          => "ESRI Published Map File",
    'PCAST'        => "iTunes Podcast File",
    'PLUGIN'       => "Adobe Photoshop Plug-in",
    'PS1XML'       => "Windows PowerShell Display Configuration File",
    'PSM1'         => "Windows PowerShell Script Module File",
    'PSPBRUSH'     => "PaintShop Pro Brush File",
    'PBXUSER'      => "Xcode Project User Data File",
    'PBXPROJ'      => "Xcode Project Data File",
    'PCK'          => "System Center Configuration Manager Package",
    'PCL'          => "Printer Command Language Document",
    'PARTIAL'      => "Internet Explorer Partially Downloaded File",
    'PBJ'          => "Pixel Bender Bytecode File",
    'PROTO'        => "Protocol Buffer File",
    'PAS'          => "Delphi Unit Source File",
    'PCSAV'        => "Mass Effect 2 Saved Game",
    'PCAPNG'       => "Pcap-NG Packet Capture File",
    'PTX'          => "Pro Tools Session File",
    'PJ2'          => "xPlan Document",
    'PRO5PLX'      => "ProPresenter 5 Playlist Bundle",
    'PJM'          => "xPlan Model",
    'PHJ'          => "PhCNC Project File",
    'PLAYGROUND'   => "Xcode Playground File",
    'PTB'          => "Sage 50 Backup File",
    'PROP'         => "Android Build Properties File",
    'PHOTOSLIBRAR' => " 'Photos Library",
    'PMX'          => "MikuMikuDance Model File",
    'PTXT'         => "Pro Tools Session Template",
    'PZFX'         => "GraphPad Prism XML Project",
    'PRDX'         => "Presentations Document",
    'PMDX'         => "PlanMaker Spreadsheet",
    'PMVX'         => "PlanMaker Spreadsheet Template",
    'PRVX'         => "Presentations Template",
    'PRSX'         => "Presentations Slide Show",
    'P65'          => "PageMaker 6.5 Document",
    'PAB'          => "Personal Address Book",
    'PGM'          => "Portable Gray Map Image",
    'PWL'          => "Windows Password List",
    'PDD'          => "Adobe PhotoDeluxe Image",
    'PCX'          => "Paintbrush Bitmap Image File",
    'PIC'          => "Generic Picture File",
    'PICT'         => "Picture File",
    'PFA'          => "Printer Font ASCII File",
    'PFB'          => "Printer Font Binary File",
    'PFM'          => "Printer Font Metrics File",
    'PCD'          => "Kodak Photo CD Image File",
    'PBM'          => "Portable Bitmap Image",
    'POT'          => "PowerPoint Template",
    'PPA'          => "PowerPoint Add-in",
    'PAK'          => "PAK (Packed) File",
    'POL'          => "Windows Policy File",
    'POV'          => "POV-Ray Raytracing Format",
    'PCA'          => "Perfect Clarity Audio File",
    'P7S'          => "Digitally Signed Email Message",
    'PF'           => "Private File",
    'PAN'          => "Panorama Database File",
    'PNZ'          => "Panorama Database Set",
    'P7M'          => "Digitally Encrypted Message",
    'PAT'          => "Pattern File",
    'PIZ'          => "Zipped File",
    'PLY'          => "Polygon Model File",
    'PES'          => "Brother Embroidery Format",
    'PEM'          => "Privacy Enhanced Mail Certificate",
    'P'            => "Pascal Source Code",
    'PDR'          => "Windows Port Driver",
    'PREFPANE'     => "Mac OS X System Preference Pane",
    'PZ3'          => "Poser Scene File",
    'PP2'          => "Poser Prop File",
    'PRN'          => "Printable File",
    'PCAP'         => "Packet Capture Data",
    'PSS'          => "PlayStation 2 Game Video File",
    'PAE'          => "PowerArchiver Encrypted Archive",
    'PSF'          => "PhotoStudio File",
    'PSB'          => "Photoshop Large Document Format",
    'PTR'          => "Flash Intro Project File",
    'PANDO'        => "Pando File",
    'PTH'          => "4D Path Document",
    'PYC'          => "Python Compiled File",
    'PYD'          => "Python Dynamic Module",
    'PYO'          => "Python Optimized Code",
    'PNF'          => "Precompiled INF File",
    'PJT'          => "FoxPro Project Memo",
    'PJX'          => "FoxPro Project",
    'PRG'          => "Visual FoxPro Program File",
    'PDM'          => "VB Project Information File",
    'PACKAGE'      => "Linux Autopackage File",
    'PEF'          => "Pentax Electronic File",
    'P96'          => "Win96 Database File",
    'P97'          => "Win97 Database File",
    'PTB'          => "Power Tab File",
    'PWI'          => "Pocket Word Document",
    'PLT'          => "HPGL Plot File",
    'PBP'          => "PSP Firmware Update File",
    'PWA'          => "Password Agent File",
    'PWC'          => "PictureTaker File",
    'PIC'          => "Houdini Raster Image",
    'PICNC'        => "Houdini 3D Compositing Image",
    'P01'          => "GEAR CD/DVD Disc Image",
    'PDI'          => "InstantCopy Disc Image",
    'PXI'          => "PlexTools Disc Image",
    'PTM'          => "PolyTracker Module",
    'PTS'          => "Pro Tools Session",
    'PPSM'         => "PowerPoint Open XML Macro-Enabled Slide Show",
    'POTX'         => "PowerPoint Open XML Presentation Template",
    'POTM'         => "PowerPoint Open XML Macro-Enabled Presentation",
    'PPAM'         => "PowerPoint 2007 Add-In",
    'PSM'          => "Protracker Studio Module",
    'PARTIMG'      => "Partimage File",
    'PAQ6'         => "PAQ6 Data Archive",
    'PAQ7'         => "PAQ7 Data Archive",
    'PAR'          => "Parchive Index File",
    'PAR2'         => "Parchive 2 Index File",
    'PBI'          => "PC BSD Installer Package",
    'PUP'          => "PlayStation 3 Update File",
    'PM'           => "Perl Module",
    'PLA'          => "ArchiCAD Project Archive",
    'PRF'          => "Director Preferences File",
    'PLN'          => "Flight Simulator Flight Plan",
    'PE4'          => "Photo Explorer Thumbnail Archive",
    'PE4'          => "PhotoImpact Image Archive",
    'PTL'          => "Rational Rose Petal File",
    'PLA'          => "iriver iQuickList File",
    'PSA'          => "Photoshop Album Catalog File",
    'PP2'          => "PingPlotter Data File",
    'P7B'          => "PKCS #7 Certificate File",
    'PEX'          => "Merak Peep Data File",
    'PSW'          => "Pocket Word Document",
    'PROFIMAIL'    => "ProfiMail Settings File",
    'P2P'          => "FolderShare Placeholder File",
    'PRO'          => "ProPresenter Export File",
    'PUP'          => "Puppy Linux DotPup Installer Package",
    'PSSG'         => "EGO Engine Textures File",
    'PL'           => "Prolog Source Code File",
    'PEX'          => "ProBoard Executable File",
    'PC6'          => "PowerCADD 6 Drawing File",
    'PC7'          => "PowerCADD 7 Drawing File",
    'PSAR'         => "PSP Update File",
    'PVS'          => "Parallels Desktop Configuration File",
    'PSG'          => "Page Segment File",
    'PLC'          => "PL/B Source File",
    'PX'           => "Pixel Image File",
    'PRC'          => "Palm Resource Code File",
    'PIV'          => "Pivot Stickfigure Animation",
    'PNA'          => "PhatNoise Audio File",
    'PLA'          => "Sansa Playlist File",
    'PDAS'         => "PDAStore Data Store File",
    'PMC'          => "Performance Monitor Counter File",
    'PDS'          => "Planetary Data System File",
    'PKB'          => "Oracle Package Body File",
    'PKS'          => "Oracle Package Spec File",
    'PKH'          => "Oracle Package File",
    'P3T'          => "PlayStation 3 Theme File",
    'PRW'          => "Artlantis Shader Preview File",
    'PIP'          => "Office Personalized Settings File",
    'P3D'          => "Peak3D 3D Graphics File",
    'PEA'          => "PEA File Archive",
    'PXR'          => "Pixar Image File",
    'PB'           => "PureBasic Source File",
    'PCB'          => "Printed Circuit Board Design File",
    'PK2'          => "Silkroad Online Game Data File",
    'PAQ'          => "Hewlett-Packard Software Restore File",
    'PRJ'          => "AIMMS Project File",
    'PDM'          => "PowerDesigner Database File",
    'PYW'          => "Python GUI Source File",
    'PDC'          => "Lizard Safeguard Secure PDF File",
    'PSV'          => "PlayStation 2 Save File",
    'PWF'          => "Counter-Strike PODBot Waypoint File",
    'PXP'          => "Counter-Strike PODBot Experience File",
    'PSP'          => "PL/SQL Server Page",
    'PCG'          => "Korg Instrument Bank File",
    'PZZ'          => "Compressed Poser Scene File",
    'PZ2'          => "Poser Pose File",
    'P2Z'          => "Compressed Poser Pose File",
    'PPZ'          => "Compressed Poser Prop File",
    'PFR'          => "Portable Font Resource File",
    'PMF'          => "PSP Movie File",
    'PPD'          => "PostScript Printer Description File",
    'PTF'          => "PSP Theme File",
    'PSM'          => "Solid Edge Sheet Metal File",
    'PRT'          => "Solid Edge Part File",
    'PO'           => "Portable Object",
    'POT'          => "Portable Object File",
    'PTF'          => "Scrapbook Flair Template",
    'PPX'          => "Serif PagePlus Template File",
    'PRS'          => "Harvard Graphics Presentation",
    'PL'           => "Unix Color Plot File",
    'PSI'          => "PrimalScript Online Help Shortcut",
    'PRG'          => "RAPID Program File",
    'PXV'          => "Pixbend Media File",
    'PTM'          => "MapPoint Map File",
    'PTT'          => "MapPoint Map Template",
    'PRT'          => "Unigraphics Part File",
    'PKA'          => "Packet Tracer Activity File",
    'PKT'          => "Packet Tracer Network Simulation Model",
    'PLE'          => "Messenger Plus! Live Encrypted Log File",
    'PLW'          => "PicoLog Data File",
    'PDB'          => "Protein Data Bank File",
    'PL0'          => "3D Home Architect Foundation Floor Plan",
    'PL1'          => "3D Home Architect Floor Plan",
    'PL2'          => "3D Home Architect Second Level Floor Plan",
    'P21'          => "Express STEP Data Model File",
    'PK'           => "Audition Peak File",
    'PQHERO'       => "Puzzle Quest Saved Game",
    'PKG'          => "PlayStation Store Downloaded Package",
    'PFL'          => "PDFill Project File",
    'PHM'          => "Pro Home Manager Data File",
    'PI2'          => "Portrait Innovations Photo",
    'POD'          => "OpenProj Project File",
    'PSW'          => "Windows Password Reset Disk File",
    'PDN'          => "paint.net Image File",
    'PLSK'         => "Messenger Plus! Live Skin Pack",
    'PC'           => "Personal Composer File",
    'PRK'          => "Thrillville Park File",
    'PIE'          => "GlovePIE Controller Script",
    'PL1'          => "PL/I Source Code",
    'PLI'          => "PL/I Source Code File",
    'PEAK'         => "Steinberg Peak File",
    'PXJ'          => "RecordNow Project",
    'PREL'         => "Premiere Elements Project File",
    'PROPDESC'     => "Property Description",
    'PHN'          => "Algodoo Phun Phunlet",
    'PNPROJ'       => "Programmer's Notepad Project File",
    'POD'          => "Terminal Reality Game Data File",
    'PLX'          => "Perl Executable File",
    'PSF'          => "Portable Sound File",
    'PH'           => "Perl Header File",
    'PA'           => "Print Artist Project",
    'PEP'          => "TurboProject Project File",
    'PTG'          => "ArtRage Painting",
    'PTN'          => "PaperPort Thumbnail File",
    'PDX'          => "Product Data eXchange File",
    'PTX'          => "E-Transcript File",
    'PWN'          => "Pawn Source Code File",
    'PUB'          => "Public Key File",
    'PZP'          => "PhotoSuite Project File",
    'PXL'          => "Pocket Excel File",
    'POI'          => "Magellan Maestro Point of Interest File",
    'PGI'          => "Video Recording File",
    'PD4'          => "Windows Live Photo Gallery Information File",
    'PD5'          => "Windows Live Photo Gallery Information File",
    'P2M'          => "PhotoWorks Appearance File",
    'PAF'          => "Personal Ancestral File",
    'PMP'          => "AutoCAD Plot Model Parameter File",
    'PC3'          => "AutoCAD Plotter Configuration File",
    'PMO'          => "Broderbund Print Meta Object File",
    'PMJ'          => "Pegasus Mail Configuration File",
    'PHB'          => "Motorola Phone Book File",
    'PPF'          => "Transit NXT Pack Project File",
    'PXF'          => "Transit XV Pack Project File",
    'PSPD'         => "PhotoSuite 5 Project File",
    'PSK'          => "Unreal Engine Skeletal Mesh File",
    'PSA'          => "Unreal Engine Skeletal Animation File",
    'PKG'          => "Symbian Package File",
    'PPF'          => "Picture Publisher Image File",
    'PDFIG'        => "PDF Index Generator Project File",
    'PSR'          => "Powersoft Report File",
    'PMM'          => "Pegasus Mail Mailbox File",
    'PK4'          => "Doom 3 Engine Game Data File",
    'PNM'          => "Portable Any Map Image",
    'PROPS'        => "Visual Studio Project Property File",
    'PIX'          => "PCI Geomatics Database File",
    'PLS'          => "MYOB Accounting Data File",
    'PVK'          => "Private Key File",
    'PPP'          => "CyberLink PowerProducer Project",
    'PCTL'         => "Kaspersky Parental Control Settings File",
    'PGP'          => "AutoCAD Program Parameters File",
    'PWT'          => "AutoCAD Publish To Web Template",
    'P3L'          => "Adobe Photoshop Light Preset File",
    'PMG'          => "Adobe Photoshop Photomerge Panoramic",
    'PDE'          => "Processing Development Environment Source Code",
    'PDO'          => "Pepakura Designer File",
    'PRI'          => "Qt Project Include File",
    'PLAYMISSION'  => "MissionPlayer Game File",
    'PLR'          => "rFactor Player File",
    'P7C'          => "PKCS #7 Certificate File",
    'PSC1'         => "Windows PowerShell Console File",
    'PAK'          => "Video Game Package",
    'PRV'          => "Vue Preview File",
    'PMD'          => "MikuMikuDance Model File",
    'PMM'          => "MikuMikuDance PolygonMovieMaker File",
    'PBXBTREE'     => "Xcode Auto-Complete File",
    'PAD'          => "ACT! Database Pointer File",
    'PBK'          => "Dial-Up Phone Book File",
    'P7R'          => "Certificate Request Response File",
    'P10'          => "Certificate Request File",
    'PHY'          => "3ds Max Physique File",
    'PHAR'         => "PHP Archive",
    'PEK'          => "Adobe Peak Waveform File",
    'PML'          => "Process Monitor Log File",
    'PNS'          => "PNG Stereo Image",
    'PCK'          => "Perfect World Data File",
    'P2G'          => "Power2Go Project File",
    'P2I'          => "Power2Go Disc Image",
    'PUZ'          => "Across Lite Crossword Puzzle",
    'PGF'          => "Progressive Graphics File",
    'PPJ'          => "Premiere 6 Project File",
    'PRTL'         => "Premiere Pro Title File",
    'PRFPSET'      => "Premiere Pro Effect Preset File",
    'PXB'          => "Pixelmator Brush File",
    'PROFILE'      => "Citrix Application Profile",
    'PCP'          => "Windows Installer Patch Creation Properties",
    'PMR'          => "Avid Persisent Media Record File",
    'P'            => "LightWave Plug-in",
    'POR'          => "SPSS Portable File",
    'PKF'          => "Audition Peak File",
    'PREFAB'       => "Unity Prefab File",
    'PGD'          => "PGP Disk Image",
    'PLR'          => "Terraria Player File",
    'PLT'          => "Tecplot Binary Data File",
    'P3'           => "Primavera P3 Project File",
    'PRX'          => "Primavera P3 Compressed Project File",
    'PRG'          => "PC-DMIS Part Program File",
    'PAT'          => "DiskStation Manager Installation File",
    'PBK'          => "Pixel Bender Kernel File",
    'PBG'          => "Pixel Bender Graph File",
    'PRM'          => "Parameter File",
    'PBN'          => "Portable Bridge Notation File",
    'PPK'          => "PuTTY Private Key File",
    'PHOTOSHOW'    => "Roxio PhotoShow Project",
    'PPC'          => "Mobile Data Studio Project File",
    'PSE'          => "Photoshop Elements Photo Project",
    'PHO'          => "Gerber Photoplot File",
    'PPR'          => "Project Planner Reader File",
    'PRI'          => "Package Resource Index File",
    'PRO4'         => "ProPresenter 4 Document",
    'PRO4PL'       => "ProPresenter Playlist File",
    'PRO4PLX'      => "ProPresenter Playlist Bundle",
    'PRO4X'        => "ProPresenter 4 Bundle File",
    'PREF'         => "Preferences File",
    'PHL'          => "Kindle Popular Highlights File",
    'PJT'          => "Didger Project File",
    'PHD'          => "PhotoDirector Project File",
    'PBD'          => "EaseUS Todo Backup File",
    'PDM'          => "ProntoDoc for Word Mobile Display Document",
    'PAT'          => "CorelDRAW Pattern File",
    'PAT'          => "AutoCAD Hatch Pattern File",
    'PSDX'         => "Photoshop Touch Document",
    'PMD'          => "Poser Binary Morph File",
    'PEZ'          => "Prezi Desktop Presentation",
    'PIPE'         => "PIPE-FLO Project File",
    'PIPD'         => "PIPE-FLO Demo Project File",
    'PSV'          => "Pipe System Viewer File",
    'PLPROJ'       => "Adobe Prelude Project File",
    'PSP'          => "Photoshop Preferences File",
    'PBJ'          => "PowerBackup Job File",
    'PBF'          => "PowerBackup Data File",
    'PYX'          => "Pyrex Source Code File",
    'PXD'          => "Pyrex Definition File",
    'PBX5SCRIPT'   => "Personal Backup Script",
    'PASSWORDWALL' => "T'4      PasswordWallet 4 Data File",
    'PIXADEX'      => "Pixadex Icon",
    'PLY'          => "Finale Playback File",
    'PRO'          => "Adobe Proto Design File",
    'PXD'          => "Pixlr Layered Image",
    'PAC'          => "PAC Subtitles File",
    'PIKA'         => "Pika Software Builder Project File",
    'PAW'          => "Pawaa File",
    'PIGM'         => "Packaged Indigo Renderer Material File",
    'PIGS'         => "Packaged Indigo Renderer Scene File",
    'PSZ'          => "Compressed PostScript File",
    'PRINTCD2'     => "EPSON Print CD File",
    'PMATRIX'      => "Priority Matrix Project File",
    'PKPASS'       => "Passbook Pass File",
    'PLANNER'      => "Gnome Planner File",
    'PWD'          => "Pocket Word Document",
    'PSW6'         => "Password Depot 6 File",
    'PSWX'         => "Password Depot Portable File",
    'PSW'          => "Password Depot 3-5 File",
    'PRO'          => "KiCad Project",
    'PAGES-TEF'    => "Pages iCloud Document",
    'PLAN'         => "Calligra Plan Document",
    'PIM'          => "Pro Tools Controller Plug-in Mappings File",
    'PIO'          => "Pro Tools I/O Settings File",
    'PEN'          => "Logitech io2 Drawing",
    'PRT'          => "CADKEY Part File",
    'PN'           => "Powernoodle File",
    'PANDORA'      => "Pandora Android App Executable",
    'P3D'          => "Panda3D Multifile",
    'PRO5'         => "ProPresenter 5 Document",
    'PRO5X'        => "ProPresenter 5 Bundle File",
    'PRO5PL'       => "ProPresenter Playlist File",
    'PZA'          => "PhotoSuite Album File",
    'PZS'          => "PhotoSuite Slide Show File",
    'PHOTOLIBRARY' => "iPhoto Photo Library",
    'PROVISIONPRO' => "I'LE     Apple Provision Profile",
    'PVD'          => "Polygen3D Vector Descriptor",
    'PRNX'         => "XtraReports PrintingSystem Document",
    'PKGDEF'       => "Visual Studio Shell File",
    'PKGUNDEF'     => "Visual Studio Shell File",
    'P7X'          => "Packed Digital Signature File",
    'PANO'         => "Camera Panoramic Picture",
    'PAPA'         => "Game Save Backup File",
    'PMT'          => "PageMaker Template File",
    'PATCH'        => "Patch File",
    'PU'           => "PlantUML File",
    'PLANTUML'     => "PlantUML File",
    'PNH'          => "Project ROME Plug-in Archive",
    'PSC'          => "Papyrus Script",
    'PJS'          => "TestComplete Project Suite File",
    'PRO5TEMPLATE' => "ProPresenter 5 Template",
    'PDPCOMP'      => "Pdplayer Composition File",
    'PDADJ'        => "PhotoDirector Preset File",
    'PVHD'         => "Paragon Virtual Hard Drive",
    'PSPROJ'       => "The Print Shop Project File",
    'PMX'          => "PrintMaster Project File",
    'PLW'          => "32-bit Windows IDA Plugin Module",
    'PLX'          => "32-bit Linux IDA Plugin Module",
    'P64'          => "64-bit Windows IDA Plugin Module",
    'PLX64'        => "64-bit Linux IDA Plugin Module",
    'PD4'          => "Clone Manager Primer File",
    'PDB'          => "Tanida Demo Builder File",
    'PKX'          => "Decrypted 3DS Pokémon Save File",
    'PLAYER'       => "Terraria Mobile Player File",
    'PAW'          => "Paw Document",
    'PMF'          => "Partition Image File",
    'PUBLICATION'  => "Twixl Publisher Publication",
    'PVW'          => "Pronto for Windows Data View File",
    'PGS'          => "PageStream Document",
    'PISKEL'       => "Piskel Sprite",
    'PTT'          => "Pro Tools Session Template",
    'PCD'          => "Pure Component Data File",
    'PWV'          => "Password Vault Archive",
    'PDW'          => "pDRAW32 DNA File",
    'PYXEL'        => "Pyxel Image Document",
    'PLP'          => "Photo Locker Picture",
    'POPSHAPE'     => "PopChar Character Shape File",
    'PDP'          => "Palo Alto Software Plan Component File",
    'PRO'          => "TurboFloorPlan 3D Design File",
    'PRIMITIVES_P' => "O'CESSED World of Tanks 3D Model File",
    'PZF'          => "GraphPad Prism Project",
    'PTEX'         => "Ptex Texture File",
    'POLICY'       => "Java Policy Implementation File",
    'PFILE'        => "Rights Management Protected File",
    'PBIX'         => "Power BI Desktop File",
    'P5D'          => "Planner 5D Project",
    'PKG.TAR.XZ'   => "Arch Linux Package File",
    'PR'           => "Source Insight Project",
    'PFO'          => "Private Folder",
    'PM5'          => "PageMaker 5.0 Document",
    'PM6'          => "PageMaker 6.0 Document",
    'PHP3'         => "PHP 3 Web Page",
    'PIF'          => "Program Information File",
    'PHTML'        => "PHP Web Page",
    'PCM'          => "Pulse Code Modulation",
    'PNT'          => "MacPaint File",
    'PSID'         => "PostScript Image Data File",
    'PVC'          => "Panasonic VM1 Voice File",
    'PQI'          => "PowerQuest Drive Image",
    'PWP'          => "PhotoWorks Image File",
    'PCV'          => "MozBackup Profile Backup",
    'PUZ'          => "Packed Publisher File",
    'PFL'          => "Family Lawyer Document",
    'PLG'          => "Sibelius Plug-in",
    'PLN'          => "Adobe InDesign Plug-in",
    'PRM'          => "Premiere Plug-in",
    'PFR'          => "Paint Shop Pro Picture Frame File",
    'PC3'          => "Degas Elite High Res Image File",
    'PM'           => "Unix XV Graphic File",
    'PM4'          => "PageMaker 4 Document",
    'PRT'          => "Presentations Template",
    'PVM'          => "HP Photo Album",
    'PH'           => "AOL Phone Home Settings File",
    'PBPROJ'       => "Project Builder Project",
    'PWREP'        => "Password Repository File",
    'PWD'          => "Solid Edge Weldment Document",
    'PFX'          => "First Choice Word Processing Document",
    'POSTAL'       => "TomTom Postal Code File",
    'PAT'          => "3D Patch File",
    'P01'          => "Toast CD Image",
    'PAC'          => "SBStudio II Song File",
    'PBF'          => "Pinnacle Sample Bank",
    'PRG'          => "WAVmaker Patch File",
    'PHY'          => "PhyMod Physical Modeling Data",
    'PAQ8'         => "PAQ8 Data Archive",
    'PRF'          => "ClarisWorks Preference File",
    'PID'          => "Process ID File",
    'PRT'          => "Printer Output File",
    'PRX'          => "PSP Plugin File",
    'PLAYLIST'     => "CyberLink PowerDVD Playlist",
    'PAF'          => "Portable Application Installer File",
    'P'            => "Python Pickle File",
    'PTX'          => "Pentax RAW Image File",
    'PTX'          => "Paint Shop Pro Texture File",
    'PEG'          => "Peggle Replay File",
    'PEN'          => "Paint Shop Pro Pen Preset File",
    'PMR'          => "Performance Monitor Report",
    'PSM'          => "Prism Document",
    'PDB'          => "PowerDesigner Database Backup File",
    'PAR'          => "Dedicated Micros DVR Recording",
    'PIX'          => "BRL-CAD Raw Image File",
    'PAP'          => "PanoramaStudio Project File",
    'PVM'          => "Photo Video Manifest File",
    'PPF'          => "Publisher Project File",
    'PRS'          => "Batch & Print Pro Printer Settings File",
    'PLN'          => "Spaceman Planogram File",
    'PIG'          => "Descent Texture File",
    'PRF'          => "FileNet eForms Form Preferences File",
    'PRM'          => "Route 66 Map File",
    'PEB'          => "ProEST+ Buildings File",
    'PBD'          => "ProBID+ Data File",
    'PIS'          => "PS2DIS Project File",
    'PVJ'          => "ProofVision Job Ticket",
    'PSF'          => "HP-UX Product Specification File",
    'PVA'          => "PVA Video File",
    'PHZ'          => "Algodoo Phun Compressed Phunlet",
    'PNPT'         => "Programmer's Notepad Project Template",
    'PPL'          => "Free Pascal Dynamic Library",
    'PPU'          => "Free Pascal Unit File",
    'PEGN'         => "Peggle Nights Replay File",
    'PNS'          => "Popnoggin Subject File",
    'PNI'          => "Popnoggin Image File",
    'PNT'          => "Popnoggin Theme File",
    'PSA'          => "Plesk Backup File",
    'PP4'          => "Picture Publisher Bitmap File",
    'PRE'          => "Lotus Freelance Graphics File",
    'PZP'          => "Tibo Jigsaw Compressed Puzzle File",
    'PZL'          => "Tibo Jigsaw Puzzle File",
    'PFF'          => "Formatta Portable Form File",
    'PSF'          => "GPS Prediction Support File",
    'PYM'          => "PYM Macro Preprocessor File",
    'P2M'          => "Gameshark PlayStation 2 Cheats file",
    'PANIC'        => "Kernel Panic File",
    'PVR'          => "Wintal PVR Video File",
    'PMO'          => "Pegasus Saved Message File",
    'PHB'          => "PhtotoBase Album File",
    'PACK'         => "Pack200 Packed Jar File",
    'PACK.GZ'      => "Pack200 Compressed Archive",
    'PF'           => "Windows Prefetcher File",
    'POM'          => "Maven Build File",
    'PAR'          => "Solid Edge Part File",
    'PKG'          => "CoCreate OneSpace Modeling Package File",
    'PRC'          => "Product Representation Compact File",
    'PFG'          => "jEEPers Program Configuration File",
    'PDL'          => "Perl Data Language File",
    'PL1'          => "Adventure Maker Plug-in",
    'PP5'          => "Picture Publisher 5 Image File",
    'PXC'          => "Photodex Cache File",
    'PBB'          => "AT&T Phonebook File",
    'PVC'          => "Parallels Desktop Copied Configuration File",
    'PWT'          => "Pocket Word Template",
    'PRP'          => "Rational Model Properties File",
    'PROFILE'      => "Pandemic Studios Game Player Profile",
    'PWS'          => "Painter Workspace File",
    'PAGE'         => "HybridJava Web Page",
    'PRF'          => "PICS Rules File",
    'PPC'          => "Adobe Presenter Audio File",
    'PPCX'         => "Adobe Presenter Presentation Audio File",
    'PTW'          => "AutoCAD Publish To Web File",
    'PSF'          => "AutoCAD PostScript Patterns File",
    'PSS'          => "AutoCAD Plot Stamp Settings File",
    'P3M'          => "Adobe Photoshop Material Preset File",
    'P3R'          => "Adobe Photoshop Render Settings Preset File",
    'PRST'         => "Adobe InDesign Printer Presets File",
    'PSET'         => "Adobe InDesign Plug-in Set File",
    'PSD1'         => "Windows PowerShell Data File",
    'PIXELA'       => "Pixela Project",
    'PSSD'         => "PhotoSuite Slide Show File",
    'PEX'          => "West Publisher Portable Exhibit File",
    'PBA'          => "OpenOffice.org Basic Protected Module File",
    'PBF'          => "Paragon Backup File",
    'PXA'          => "XpressAccounts Data File",
    'PRS'          => "Calyx Point Prospect File",
    'PLG'          => "Visual Studio Build Log File",
    'PERFMONCFG'   => "Performance Monitor Configuration File",
    'PRINTEREXPOR' => " 'Windows Printer Migration File",
    'PSY'          => "The Psychedelic Screen Saver Settings File",
    'PSY'          => "Psycle Song File",
    'PRN'          => "Lotus 1-2-3 Formatted Text File",
    'PLF'          => "Papyrus License File",
    'PJ'           => "Project64 Saved State File",
    'PML'          => "Pyre Properties File",
    'P7'           => "PKCS #7 Digital Certificate File",
    'PNS'          => "Pelco CCTV Video File",
    'PJPG'         => "Progressive JPEG Image",
    'PGF'          => "Pokémon Mystery Gift for Black & White File",
    'PCD'          => "Pokémon Wonder Card File",
    'PGT'          => "Pokémon Gift File",
    'PROPERTIES'   => "Minecraft Properties File",
    'PP'           => "Pocket Physics Sketch File",
    'PXG'          => "Pixelmator Gradient File",
    'PAX'          => "PAX Archive",
    'P2S'          => "PCSX2 Saved State",
    'PNACH'        => "PCSX2 Patch File",
    'PAK'          => "Simutrans Object File",
    'PHD'          => "Portable Heap Dump File",
    'PAPERS'       => "Painter Paper Texture File",
    'PEF'          => "PEF Braille Book File",
    'PAL'          => "Painter Custom Palettes File",
    'PCSXSTATE'    => "PCSX Saved State File",
    'PER'          => "Age of Empires Personality File",
    'PWDP'         => "Password Pad Document",
    'PWDPL'        => "Password Pad Lite Document",
    'PSV'          => "Pipe Separated Values File",
    'PSU'          => "EMS PS2 Memory Adapter Save File",
    'PRG'          => "RPG Toolkit Program File",
    'PS2'          => "PCSX2 Memory Card File",
    'PRM'          => "Re-Volt Model File",
    'PK'           => "Packed METAFONT File",
    'PK3'          => "ZDoom Package",
    'P6'           => "Perl 6 Source Code File",
    'PSDL'         => "Midtown Madness 2 City File",
    'PPM'          => "Post Programmable Memory File",
    'PHO'          => "MBROLA Phonetic Data File",
    'PPR'          => "Cognos PowerPlay Report File",
    'PRZ'          => "Freelance Graphics Presentation File",
    'PRV'          => "Free Folder Hider Backup File",
    'PSESS'        => "Visual Studio Performance Session File",
    'PES'          => "PhysicsEditor Sheet File",
    'PDE'          => "Arduino Sketch",
    'PEKEY'        => "PhysicsEditor License Key File",
    'PC'           => "Pro*C Source Code File",
    'PRF'          => "QuarkXPress Preferences File",
    'PNO'          => "Windows 8 Piano Song",
    'PFI'          => "PhotoFiltre Studio Image",
    'PAR'          => "FMS Aircraft Parameters File",
    'PCS'          => "Pfaff Embroidery File",
    'PAQ8L'        => "PAQ8L Data Archive",
    'PBA'          => "PowerBackup Archive",
    'PLTSUITE'     => "Safari Page Load Test Suite File",
    'PXI'          => "Pyrex Include File",
    'PCF'          => "Valve Particle System File",
    'PBXSCRIPT'    => "Personal Backup Script",
    'P3E'          => "Photoshop Repousse Settings File",
    'PXICON'       => "CandyBar Icon",
    'PLST'         => "SmartMusic Playlist",
    'PROJECT'      => "Eclipse Project Settings File",
    'PACK'         => "CustoPack Tools Theme Pack",
    'PHR'          => "RoboHelp Phrase List",
    'PART00000'    => "WinOptimizer Split Archive Part 1",
    'POP'          => "Team Fortress 2 Population File",
    'PMD'          => "PlanMaker Spreadsheet",
    'PMV'          => "PlanMaker Spreadsheet Template",
    'PRD'          => "Presentations Document",
    'PRV'          => "SoftMaker Presentations Template",
    'PGX'          => "Hopedot VOS Data File",
    'PMQ'          => "Microsoft Target Analyzer File",
    'PAMP'         => "Poweramp Album Art File",
    'PRISON'       => "Prison Architect Saved Game",
    'PAW'          => "Personal Ancestry Writer II File",
    'PCE'          => "TurboGrafx-16 ROM",
    'PKEY'         => "PowerKey Encrypted File",
    'PBO'          => "Packed Bohemia Object",
    'PTCOP'        => "PxTone Audio File",
    'PFS'          => "PhotoFiltre Studio Saved Selection File",
    'PRO4DVD'      => "ProPresenter DVD Clips Document",
    'PRO5DVD'      => "ProPresenter DVD Clips Document",
    'PROQC'        => "ProPresenter Quartz Composition",
    'PSFLIB'       => "Playstation Sound Format Library",
    'PSF1'         => "PlayStation Sound Format File",
    'PSF2'         => "PlayStation Sound Format File",
    'PSFLIB2'      => "Playstation Sound Format Library",
    'PPMOD'        => "Papers Please Mod File",
    'PML'          => "Palm Markup Language File",
    'PMLZ'         => "Zipped Palm Markup Language File",
    'POBI'         => "Kindle Touch Periodical File",
    'PTS'          => "PTGui Project File",
    'PROJECTPROPE' => "T'IES    Alpha Five Project Properties File",
    'PCH'          => "Nastran Punch Output File",
    'PATRAN.HRD'   => "Patran Hardcopy File",
    'PJUNOXL'      => "Preset File",
    'PWR'          => "PowerWrite Document",
    'PTG'          => "PowerTeacher Gradebook Configuration File",
    'PRO'          => "Professional Home Design Project",
    'PXIP'         => "Pixelmator Image Preset",
    'PXS'          => "Pixelmator Shape File",
    'PXLS'         => "Pixelmator Style File",
    'P19'          => "Parchive Recovery Volume",
    'P01'          => "Parchive Recovery Volume",
    'PTP'          => "Pro Tools Preferences File",
    'PQ'           => "Picturesque Preset",
    'PKPROJ'       => "Visual CCScript Project",
    'PQB'          => "Pleco Chinese Dictionary Backup File",
    'PQB-BACKUP'   => "Pleco Chinese Dictionary Backup File",
    'PGDATA'       => "Penguin George Data File",
    'PERSPECTIVE'  => "Xcode Project Data File",
    'PERSPECTIVEV' => " 'Xcode Project Data File",
    'PB2MAP'       => "Plazma Burst 2 Custom Map file",
    'PQ'           => "Progress Quest Save File",
    'PATTERNLIBRA' => "Y'Painter Pattern Library",
    'PRO5TEMPLATE' => "U'NDLE   ProPresenter 5 Template Bundle",
    'PAPERLIBRARY' => "Painter Paper Library",
    'PDPCMD'       => "Pdplayer Command File",
    'PDLCP'        => "PhotoDirector Lens Profile File",
    'PX5'          => "Clone Manager Primer Collection File",
    'PK6'          => "Generation 6 Pokémon Save File",
    'PROF'         => "Super Smash Bros. Crusade Profile",
    'PLAYER'       => "Pokémon Type Wild Player Data File",
    'PCT'          => "Pure Compound Text File",
    'PAT'          => "Ketron Sound Pattern File",
    'PRIMITIVES'   => "World of Tanks 3D Model File",
    'PUK'          => "Pavuk Universal Kommand File",
    'PDPL'         => "Plaintext Data Processing Language File",
    'PDPLX'        => "Plaintext Data Processing Language Extensible",
    'PFI'          => "Paragon Backup Index File",
    'PCC'          => "Photocomposition Code File",
    'PDPD'         => "Product Details Page DataObject File",
    'PPDF'         => "Rights Management Protected File",
    'PBIT'         => "Power BI Desktop Template",
    'PMSETTINGS'   => "PowerMate Settings File",
    'POSB'         => "Poseidon Dive Log",
    'PKL'          => "Python Pickle File",
    'PNC'          => "Panasonic Network Camera Image",
    'PXX'          => "Keyman Developer Encrypted Customization File",
    'PTD'          => "PipeTech Data File",
    'PBS'          => "PaintShop Pro Brush Strokes",
    'PXML'         => "Pandora XML File",
    'PLS'          => "PL/SQL Stored Procedure",
    'P4D'          => "Pix4D Project",
    'PDA'          => "SoftMax Pro Microplate Data Analysis File",
    'PDEX'         => "Orient Computer Encrypted Data File",
    'PRO'          => "IDL Source Code File",
    'PGAL'         => "Photo! 3D Album Gallery",
    'PXF'          => "Pendix Firmware File",
    'PBP'          => "PulseBoy Project",
    'PIDS'         => "Snap-on Scan Data File",
    'PVMZ'         => "Parallels Compressed Virtual Machine",
    'PBW'          => "Pebble Watchface File",
    'PDMOD'        => "Payday Modification Archive",
    'PSV'          => "Pluralsight Video File",
    'PZ'           => "Panzoid Video Project",
    'PAL'          => "NES Emulator Color Palette File",
    'PDSPRJ'       => "Proteus Project",
    'P7E'          => "EQStitch 7 Project",
    'P2C'          => "Portal 2 Community Puzzle File",
    'PAGE'         => "S Note Page File",
    'PSS'          => "RoboHelp HTML Project Data File",
    'PCK'          => "Oracle Package Specification and Body File",
    'PET'          => "WangReal Engine Game Model File",
    'PLAYER'       => "Starbound Player File",
    'PKZ'          => "Video Game Package",
    'PSPSCRIPT'    => "PaintShop Pro Resource File",
    'PAF'          => "PARIS Audio File",
    'PVF'          => "Portable Voice Format",
    'PTC'          => "PANTONE Color File",
    'PDS'          => "The Print Shop Project",
    'PRB'          => "xyAlgebra Probabilities File",
    'PHP4'         => "PHP 4 Web Page",
    'PAL'          => "Dr. Halo Color Palette File",
    'PIG'          => "Pirates of the Burning Sea Data File",
    'POF'          => "Descent Robot Definition File",
    'POG'          => "Descent 2 Texture Modification",
    'PHP5'         => "PHP 5 Web Page",
    'PID'          => "Creative Driver File",
    'PIT'          => "PackIt Compressed Archive",
    'PAP'          => "Corel Painter Paper Texture",
    'PTK'          => "Quicken Online Financial Data File",
    'PPF'          => "Paint Shop Pro Soft Plastic Preset File",
    'PWS'          => "Print Workshop Image",
    'PAC'          => "STAD Graphic File",
    'PC1'          => "Degas Elite Low Res Image File",
    'PC2'          => "Degas Elite Medium Res Image File",
    'PI1'          => "Degas Low Resolution Image File",
    'PI2'          => "Degas Medium Resolution Image File",
    'PI3'          => "Degas High Resolution Image File",
    'PI4'          => "DEGAS Image",
    'PI5'          => "DEGAS Bitmap Image",
    'PI6'          => "DEGAS Bitmap Image File",
    'PHTM'         => "PHP-Based Web Page",
    'PM3'          => "PageMaker 3 Document",
    'PREF'         => "Macintosh Preferences File",
    'PRC'          => "Corel Presentation",
    'PIC'          => "QuickTime PICT Image",
    'PSS'          => "Picture and Sound Show File",
    'PI'           => "Pi Calculation Data File",
    'PVD'          => "Instalit Script",
    'PVL'          => "Instalit Library",
    'PDG'          => "Print Shop Deluxe Design File",
    'POV'          => "Prolab Object File",
    'PFL'          => "PhotoFiltre Plugin",
    'PD'           => "FlexiSIGN 5 Plotter Document",
    'PAT'          => "Gravis UltraSound GF1 Patch File",
    'PRG'          => "Akai MPC2000 Program File",
    'PIM'          => "PIM Archive",
    'PDD'          => "Medtronic Programmer Data File",
    'PRT'          => "Printer Driver File",
    'PPF'          => "PlayStation Patch Format File",
    'PSF'          => "SPI Proxy Output File",
    'PLAYSET'      => "Souptoys Playset File",
    'PLSC'         => "Messenger Plus! Live Script File",
    'PRF'          => "Plot Station Plot Request File",
    'PRS'          => "PlayStation Radio Player Location",
    'PLS'          => "PicoLog Settings File",
    'PKM'          => "Pokémon Saved Game Data File",
    'PSF'          => "PID Script File",
    'PPM_B'        => "Nokia PPM Flash File",
    'PCF'          => "PaintCAD Font",
    'PEC'          => "Brother Embroidery File",
    'POS'          => "Trimble Position File",
    'PRA'          => "Windows Media 9 Plug-in Profile File",
    'PHYA'         => "Aleph One Physics File",
    'PNTG'         => "MacPaint Graphic File",
    'PRT'          => "Crypt Edit Protected Text Format File",
    'PIX'          => "Alias PIX Image",
    'PMG'          => "PageMaker Group File",
    'PTY'          => "Rational Property Set",
    'PSX'          => "PlayStation Save File",
    'PT'           => "Panther Project File",
    'PNT'          => "Panther Project",
    'PPTHTML'      => "PowerPoint HTML Presentation",
    'PPTMHTML'     => "Microsoft PowerPoint MIME HTML Presentation",
    'PDP'          => "Adobe Portable Document Format File",
    'PDFS'         => "Adobe PDF Presets File",
    'PVPF'         => "Pet ville Save File",
    'PGPF'         => "Password Generator Password File",
    'POP'          => "Samsung Popcon Character File",
    'PJPEG'        => "Progressive JPEG Image",
    'PREFS'        => "MMORPG Tycoon Preferences File",
    'PS1'          => "Microsoft Indexing Service Data File",
    'PS2'          => "Microsoft Search Catalog Index File",
    'PIN'          => "MNS Projection Information File",
    'PSU'          => "PSU Designer Document",
    'PRG'          => "Commodore Program File",
    'PRG'          => "xBase Program File",
    'PRG'          => "GEM Application",
    'PS2'          => "Sharkport Saved Game",
    'PAKM'         => "PAKM Package File",
    'PM3'          => "Crouzet Logic Software M3 File",
    'PFD'          => "Micrografx Optima! File",
    'PSYS'         => "ZEQ2 Lite Particle Effects File",
    'PLF'          => "Mr. Bean Game Data File",
    'PPR'          => "ORF Report File",
    'PD'           => "Spore Audio Playback File",
    'PTK'          => "Puntotek Embroidery Design File",
    'PURBLEPAIRSS' => "V'E-MS   Purble Pairs Saved Game",
    'PURBLESHOPSA' => "E'-MS    Purble Place Shop Saved Game",
    'PAQ8F'        => "PAQ8F Compressed Archive",
    'PKG'          => "Midtown Madness 2 Model File",
    'POBJ'         => "Photo Pos Pro Vector Object File",
    'PDW'          => "ProntoDoc for Word Conventional Document",
    'PMV'          => "Return to Zork Video File",
    'PIT'          => "Samsung Phone Firmware File",
    'PCS'          => "Microsoft Office ClipArt File",
    'PDE'          => "ProntoDoc for Excel Document Template",
    'PDH'          => "ProntoDoc for Word Browser Display Document",
    'PDZ'          => "ProntoDoc for Word Structured Text Document",
    'PDWR'         => "ProntoDoc for Word Conventional Document",
    'PDER'         => "ProntoDoc for Excel Conventional Document",
    'PDR'          => "ProntoDoc for Word Recovered Document",
    'POST'         => "LIGHT File",
    'PICKLE'       => "Python Pickle File",
    'PJS'          => "Phoenix Subtitles File",
    'PSB'          => "PowerDivX Subtitles File",
    'PDFXML'       => "Adobe PDFXML Document",
    'PAT'          => "Kega Fusion Cheats File",
    'PFV'          => "PhotoFiltre Studio Vectorial Path",
    'PLT0'         => "Wii Color Palette File",
    'PAT0'         => "Wii Texture Pattern File",
    'PMPL'         => "PSBMusic Playlist File",
    'PAQ8P'        => "PAQ8P Data Archive",
    'PATTERNS'     => "Painter Pattern Library",
    'PHP2'         => "PHP 2 Web Page",
    'PLAIN'        => "Plain Text File",
    'PPV'          => "Pocket PowerPoint Presentation",
    'QXP'          => "QuarkXPress Project File",
    'QBW'          => "QuickBooks Data File",
    'QPW'          => "Quattro Pro Spreadsheet",
    'QDF'          => "Quicken Data File",
    'QFX'          => "Quicken Financial Exchange File",
    'QBO'          => "QuickBooks Online Bank Statement File",
    'QB2009'       => "QuickBooks 2009 File",
    'QXB'          => "QuarkXPress Book File",
    'QRC'          => "Qt Resource Collection File",
    'QVD'          => "QlikView Data File",
    'QVW'          => "QlikView Document",
    'QB2011'       => "QuickBooks 2011 File",
    'QB2012'       => "QuickBooks 2012 File",
    'QUICKENDATA'  => "Quicken Essentials for Mac Data File",
    'QB2013'       => "QuickBooks 2013 File",
    'QB2014'       => "QuickBooks 2014 File",
    'QUICKEN2015'  => "Quicken 2015 Data File",
    'QUICKEN2017'  => "Quicken 2017 Data File",
    'QUICKEN2017B' => "C'KUP Quicken 2017 Backup File",
    'QMTF'         => "Quicken Mac Transfer File",
    'QB2017'       => "QuickBooks 2017 for Mac Data File",
    'QXD'          => "QuarkXPress Document",
    'QXL'          => "QuarkXPress Library",
    'QIF'          => "Quicken Interchange Format File",
    'QIC'          => "Windows Backup File",
    'QBX'          => "QuickBooks Accountant Transfer File",
    'QBB'          => "QuickBooks Backup File",
    'QPB'          => "QuickBooks Point of Sale Data File",
    'QDFM'         => "Quicken Data File (Macintosh)",
    'QPR'          => "FoxPro Generated Query Program",
    'QWD'          => "QuakeWorld Demo File",
    'QDA'          => "Quadruple D Archive",
    'QTI'          => "QuickTime Image File",
    'QTIF'         => "QuickTime Image File",
    'QTR'          => "QuickTime Extension Resource",
    'QTX'          => "QuickTime Extension",
    'QCP'          => "PureVoice Audio File",
    'QTZ'          => "Quartz Composer File",
    'QDL'          => "QDL Program",
    'QF'           => "Qompose Web Page Template",
    'QF'           => "Nokia Maps Version File",
    'QSF'          => "Qualtrics Survey File",
    'QTL'          => "QuickTime Link File",
    'QDF'          => "Label Matrix Label Design",
    'QPF'          => "Quartus II Project File",
    'QRP'          => "QuickReport File",
    'QBM'          => "QuickBooks Portable Company File",
    'QIT'          => "QIT Trojan Horse File",
    'QMBL'         => "LabQuest Document",
    'QTP'          => "QuickTime Preferences File",
    'QSS'          => "Qt Style Sheet",
    'Q08'          => "QuickTax 2008 Tax Return",
    'Q09'          => "QuickTax 2009 Tax Return",
    'QBK'          => "QuickTax Backup File",
    'QDP'          => "Quick and Dandy Plotter File",
    'QB2010'       => "QuickBooks 2010 File",
    'QBMB'         => "QuickBooks Backup File",
    'QBMD'         => "QuickBooks Backup File",
    'QPT'          => "QuarkXPress Project Template",
    'QRC'          => "QuarkXPress Required Component File",
    'QC'           => "Half-Life Model Compiler Script",
    'QC'           => "QuakeC Source Code File",
    'QMG'          => "Samsung Theme Graphics File",
    'QVP'          => "ViewletBuilder Project File",
    'QRY'          => "Query File",
    'QPF'          => "QuickPad Encrypted Document",
    'QDFX'         => "Quicken Financial Exchange File",
    'QUICKENBACKU' => " 'Quicken Essentials for Mac Backup File",
    'QXF'          => "Quicken Essentials for Mac Exchange File",
    'QBA.TLG'      => "QBA Transaction Log File",
    'QBR'          => "QuickBooks Report Template",
    'QBY'          => "QuickBooks Accountant's Copy Import File",
    'QAT'          => "Microsoft Office Quick Access Toolbar File",
    'QUICKEN2015B' => "C'KUP Quicken 2015 Backup File",
    'QBJ'          => "QuickBooks General Journal Entry File",
    'QUICKEN2016B' => "C'KUP Quicken 2016 Backup File",
    'QUICKEN2016'  => "Quicken 2016 Data File",
    'QVF'          => "Qlik Sense Desktop App File",
    'QB2016'       => "QuickBooks 2016 for Mac Data File",
    'QRMX'         => "Quick Risk Matrix File",
    'QXW'          => "Q Light Controller+ Workspace File",
    'QT'           => "Apple QuickTime Movie",
    'QXT'          => "QuarkXPress Template",
    'QX'           => "Quexal Source Code",
    'QTCH'         => "QuickTime Cache File",
    'QDF'          => "Snapform File",
    'QPX'          => "FoxPro Compiled Query Program",
    'QPM'          => "Quick Pallet Maker Input Data",
    'QRM'          => "Qworum Message File",
    'QEL'          => "Quicken Electronic Library",
    'QPH'          => "Quicken Price History File",
    'QLGENERATOR'  => "Quick Look Generator File",
    'QVM'          => "Quake 3 Virtual Machine File",
    'QPF'          => "Quest3D Project",
    'Q3D'          => "Quest3D Project File",
    'QSD'          => "Quicken Data File",
    'Q07'          => "QuickTax 2007 Tax Return",
    'QDP'          => "MPQDraft Plugin File",
    'QTM'          => "Apple QuickTime Movie File",
    'Q3C'          => "Quick 3D Cover Project File",
    'Q2D'          => "Quick 3D Cover Design File",
    'QPH'          => "Qt Phrase Books File",
    'QM'           => "Qt Compiled Translation Source File",
    'QB2007'       => "QuickBooks 2007 File",
    'QB2006'       => "QuickBooks 2006 File",
    'QDS'          => "Windows Directory Query File",
    'QVT'          => "QlikView Theme File",
    'QAR'          => "QlikView Extension",
    'QVPP'         => "QlikView Extension Properties Page File",
    'QUA'          => "Avira AntiVir Quarantined File",
    'QV~'          => "ViewletBuilder Project Backup File",
    'QWQ'          => "OpenQwaq Auto-Launch File",
    'QPX'          => "Quattro Pro QuickColumn Settings File",
    'QTINDEX'      => "Adobe QTIndex File",
    'QUOX'         => "Question Object File Format",
    'QUIZ'         => "Quobject Quiz Package",
    'QMK'          => "YanCEyDesktop Quickmarks File",
    'QDF-BACKUP'   => "Quicken Data Backup File",
    'Q1'           => "Winamp Equalizer Presets File",
    'Q2'           => "Winamp Equalizer Auto-Load Presets File",
    'QFILTER'      => "ColorSync Utility Quartz Filter",
    'QBA'          => "QuickBooks Accountant's Copy Work File",
    'QML'          => "QT Meta Language File",
    'QUALSOFTCODE' => "J&ASoft Code Archive File",
    'QCOW'         => "QEMU Copy On Write Disk Image",
    'QCOW2'        => "QEMU Copy On Write Version 2 Disk Image",
    'QF'           => "Diploma Question Bank File",
    'QB'           => "Diploma Question Bank File",
    'QS'           => "Qt Install Script",
    'QBXML'        => "QuickBooks XML Format File",
    'QBX'          => "Blocks Landing Page File",
    'QIZ'          => "Exam Builder Quiz",
    'QCC'          => "Quilt Manager Pattern File",
    'QTPXCOMPOSIT' => "O'N   QuickTime Composition File",
    'QB2015'       => "QuickBooks 2015 for Mac Data File",
    'Q5Q'          => "SuperBladePro Presets File",
    'QSV'          => "Tibo Jigsaw Puzzle Save File",
    'QDF'          => "Quadro Design File",
    'QIF'          => "QuickTime Image File",
    'Q1Q'          => "LunarCell Photoshop Plug-in",
    'Q2Q'          => "Flexify Photoshop Plug-in",
    'Q4Q'          => "Solar Cell Photoshop Plug-in",
    'Q5R'          => "Melancholytron Photoshop Plug-in",
    'Q7Q'          => "India Ink Photoshop Plug-in",
    'Q8R'          => "Flood Photoshop Plug-in",
    'Q9R'          => "Glitterato Photoshop Plug-In",
    'Q9S'          => "Mr. Contrast Photoshop Plug-In",
    'QPX'          => "QuickTime Player Extension",
    'QVM'          => "Q Virtual Machine",
    'QDAT'         => "QuickTime Install Cache File",
    'QB2005'       => "QuickBooks 2005 File",
    'QDT'          => "Quicken 3 & 4 Data File",
    'QDB'          => "Quicken 5 & 6 Data File",
    'QKY'          => "Quirky Kernel",
    'Q9Q'          => "BladePro Presets File",
    'RAR'          => "WinRAR Compressed Archive",
    'RTF'          => "Rich Text Format File",
    'RM'           => "RealMedia File",
    'RSS'          => "Rich Site Summary",
    'ROM'          => "N64 Game ROM File",
    'RPM'          => "Red Hat Package Manager File",
    'RAM'          => "Real Audio Metadata File",
    'REG'          => "Registry File",
    'RDF'          => "Resource Description Framework File",
    'RPT'          => "Crystal Reports File",
    'RMVB'         => "RealMedia Variable Bit Rate File",
    'RB'           => "Ruby Source Code",
    'RDP'          => "Remote Desktop Configuration File",
    'RES'          => "C++ Complied Resource Script",
    'R'            => "Rez Source Code File",
    'RVT'          => "Revit Project File",
    'RCPROJECT'    => "iMovie '08 Project",
    'RNS'          => "Reason Song File",
    'RELS'         => "Open Office XML Relationships File",
    'REP'          => "Grand Theft Auto Replay File",
    'REZ'          => "Lithtech Game Engine Resource File",
    'RESX'         => ".NET Managed Resources File",
    'RMSKIN'       => "Rainmeter Skin File",
    'RW2'          => "Panasonic RAW Image",
    'RX2'          => "REX2 Audio File",
    'ROX'          => "Roxio Project File",
    'R3D'          => "REDCODE Video File",
    'RWZ'          => "Outlook Rules Wizard File",
    'RP'           => "Axure RP Project File",
    'RTD'          => "Robot Structural Analysis Design File",
    'RBW'          => "Ruby Script",
    'REXX'         => "Rexx Source File",
    'ROADTRIP'     => "Road Trip Planner File",
    'RKT'          => "Racket Source Code File",
    'RA'           => "Real Audio File",
    'RMR'          => "ResumeMaker File",
    'RAW'          => "Raw Image Data File",
    'RODZ'         => "Ancestry Genealogical Database File",
    'RLE'          => "Run Length Encoded Bitmap",
    'RMI'          => "RMID MIDI File",
    'REG'          => "Registration Information File",
    'RT'           => "RealText Streaming Text File",
    'RAS'          => "Sun Raster Graphic",
    'RIF'          => "Painter Raster Image File",
    'ROX'          => "Actuate Report Object Executable File",
    'RGS'          => "Registry Script",
    'RUL'          => "InstallShield Rules File",
    'RHP'          => "Rhino Plug-in",
    'RRR'          => "Registry Mechanic Backup File",
    'RMX'          => "RealJukebox Format",
    'R01'          => "WinRAR Split Archive Part 1",
    'RC'           => "Resource Script",
    'RSRC'         => "Macintosh Resource File",
    'RTFD'         => "Rich Text Format Directory File",
    'RTD'          => "RagTime Document",
    'RWP'          => "RapidWeaver Package",
    'README'       => "Readme File",
    'RFL'          => "Reason ReFill Sound Bank",
    'RXDATA'       => "RMXP Data File",
    'ROM'          => "Read Only Memory Image",
    'RGE'          => "Entourage File Archive",
    'RAF'          => "Fuji RAW Image File",
    'RPT'          => "Generic Report",
    'RTE'          => "RTE Encoded File",
    'RTE'          => "Navigation Route",
    'RHTML'        => "Ruby HTML Web Page",
    'RES'          => "Windows Resource File",
    'RNG'          => "Nokia Composer Ringtone",
    'RDF'          => "Report Definition File",
    'RBS'          => "Rebirth Song File",
    'ROL'          => "Ad Lib Synthesized Instrument",
    'RTI'          => "Real Tracker Instrument",
    'RZ'           => "Rzip Compressed File",
    'RDO'          => "Xerox Rawster Document Object File",
    'RNQ'          => "Renque Model File",
    'RNC'          => "RELAX NG Compact Syntax File",
    'RBP'          => "Real Studio Project File",
    'R00'          => "WinRAR Compressed Archive",
    'RGO'          => "RepliGo File",
    'RDB'          => "N64 ROM Database",
    'RDB'          => "Retrospect Backup Set",
    'RZK'          => "File Crypt Password File",
    'RSW'          => "R&R SQL Report Writer Report File",
    'RSN'          => "Reason Project File",
    'RBC'          => "Retrospect Backup Catalog File",
    'RBC'          => "Rembo-C Script",
    'RJS'          => "Ruby Javascript File",
    'RJS'          => "RealJukebox Skin File",
    'RUM'          => "Bink Video Subtitle File",
    'RMJ'          => "Real Media Jukebox Audio File",
    'REX'          => "ReCycle Loop File",
    'RST'          => "reStructuredText File",
    'R1M'          => "RealOne Streaming Media File",
    'RSO'          => "NXT Brick Audio File",
    'RZB'          => "Red Zion Book File",
    'RZN'          => "Red Zion Notes File",
    'RZK'          => "Red Zion Key File",
    'RZS'          => "Red Zion Security File",
    'RSD'          => "RealSQLDatabase File",
    'RV'           => "Real Video File",
    'ROD'          => "Actuate Report Object Design File",
    'RPK'          => "RadLight Media Player Skin",
    'RCG'          => "Recog Character Recognition Set",
    'RGN'          => "Garmin Regional Map File",
    'RPL'          => "Toribash Replay File",
    'RFM'          => "rFactor Modification File",
    'RCL'          => "Easy CD and DVD Creator 6 Project",
    'RND'          => "PGP Random Seed File",
    'RND'          => "Random Hash Data File",
    'RBT'          => "LEGO MINDSTORMS NXT Program",
    'RTS'          => "Royal TS Remote Connection File",
    'RDB'          => "Wavelet Video Images File",
    'RVPROJ'       => "RPG Maker VX Project File",
    'R'            => "R Script File",
    'ROU'          => "Gerber Route File",
    'RAL'          => "WinRail Track Design File",
    'RDL'          => "MicroStation Redline File",
    'RET'          => "BusinessObjects Template",
    'RBF'          => "Windows Installer Rollback File",
    'RBS'          => "Windows Installer Rollback Script",
    'RBXM'         => "ROBLOX Model",
    'RPS'          => "3ds Max Render Preset Settings",
    'REM'          => "BlackBerry Encrypted Data File",
    'REC'          => "Topfield PVR Recording",
    'RBXL'         => "ROBLOX Location File",
    'ROQ'          => "Id Software Game Video",
    'RXE'          => "Lego Mindstorms NXT Executable Program",
    'RFA'          => "Revit Family File",
    'RTE'          => "Revit Project Template",
    'RWSW'         => "RapidWeaver Site File",
    'RP9'          => "RetroPlatform Disk Image Archive",
    'RSM'          => "WinWay Resume Deluxe Resume File",
    'RIS'          => "Research Information Systems Citation File",
    'R'            => "REBOL Script",
    'RSC'          => "Symbian Application Compiled Resource File",
    'RSS'          => "Symbian Application Resource File",
    'RAX'          => "Real Music Store Audio File",
    'REP'          => "StarCraft Replay File",
    'RFO'          => "RoboForm Option File",
    'RMT'          => "Router Firmware File",
    'RPP'          => "REAPER Project File",
    'RTC'          => "Live Meeting Connection File",
    'RISE'         => "RISE Editor Model File",
    'RSV'          => "RSView32 Project File",
    'RLL'          => "Microsoft Resource Library",
    'RFP'          => "RoboForm Passcard File",
    'RFN'          => "RoboForm Safenote File",
    'RFQ'          => "RoboForm SearchCard File",
    'RMS'          => "Secure Real Media File",
    'RFW'          => "Rockchip Firmware File",
    'RB4'          => "Resume Builder 4 File",
    'RWLIBRARY'    => "Paperless Receipt Library",
    'RULESET'      => "Visual Studio Code Analysis Rule Set File",
    'RCT'          => "Visual Studio Resource Template",
    'RDLC'         => "Visual Studio Client Report Definition File",
    'RESOURCES'    => "Visual Studio Resource File",
    'RMP'          => "RealPlayer Metadata Package File",
    'RPY'          => "Python Script",
    'RVDATA'       => "RPG Maker VX Data File",
    'RSP'          => "RSLogix PLC Program File",
    'RIP'          => "Hit'n'Mix Audio Mashup File",
    'RUN'          => "Linux Executable File",
    'RPF'          => "Rich Pixel Format File",
    'RRD'          => "Reduced Resolution Dataset File",
    'REGTRANS-MS'  => "Registry Transaction Log File",
    'RML'          => "Redline Markup Language File",
    'RCS'          => "RandomControl Scene File",
    'RAD'          => "VRAD Lights File",
    'RAD'          => "Citrix Rapid Application Delivery File",
    'RST'          => "IDRISI Raster Image",
    'RAV'          => "Rave Reports Project File",
    'RPPRJ'        => "Axure RP Shared Project File",
    'RPLIB'        => "Axure RP Widget Library File",
    'RMD'          => "RED Metadata File",
    'RCX'          => "REDCINE-X Project File",
    'RSX'          => "RED Metadata XML File",
    'RSA'          => "RSA Certificate File",
    'RPMSG'        => "Outlook Restricted Permission Message",
    'RCF'          => "SonicWALL VPN Configuration File",
    'RWL'          => "Leica RAW Image",
    'RDATA'        => "R Workspace File",
    'RESW'         => "Windows Resources File",
    'RODL'         => "RemObjects Definition Language File",
    'RAT'          => "PICS Rating File",
    'REQ'          => "SSL Certificate Request File",
    'RADQ'         => "Need for Madness Game Archive",
    'RGMC'         => "RootsMagic Genealogy Project File",
    'RDLX'         => "Power View Project File",
    'RS'           => "RapidSketch Document",
    'RIG'          => "vRigger Design File",
    'RC2'          => "Visual Studio Resources File",
    'RDF'          => "ArcGIS Report Document File",
    'RLF'          => "ArcGIS Report Layout File",
    'RCD'          => "pcAnywhere Recorded Session File",
    'RCD'          => "LEGO MINDSTORMS Recording File",
    'RVL'          => "muvee Reveal X Project File",
    'RESJSON'      => "Windows JavaScript Resources File",
    'RWD'          => "NRG Raw Wind Data File",
    'RLI'          => "RealWorld Graphics Layered Image",
    'RELOC'        => "Windows EXE Relocation Section File",
    'RSM'          => "RouterSim Network Visualizer File",
    'RMP'          => "Magellan Raster Map File",
    'RDF'          => "Relux Project File",
    'REFRESH'      => "Visual Studio Refresh File",
    'RWZ'          => "Rawzor Compressed Image",
    'RVID'         => "Snapz Pro X Recorded Video File",
    'RGRP'         => "Pro Tools Region Group File",
    'RAW'          => "Dolphin Wii and Gamecube Emulator Game Save File",
    'RSG'          => "RaySupreme Graph",
    'RFU'          => "Remote Firmware Update",
    'RGSS3A'       => "RPG Maker VX Ace RGSS Encrypted Archive",
    'RGSSAD'       => "RPG Maker VX RGSS Encrypted Archive",
    'RFLW'         => "Edge Reflow Data File",
    'REV'          => "LiveCode Plugin",
    'RVPROJ2'      => "RPG Maker VX Ace Project File",
    'RVDATA2'      => "RPG Maker VX Ace Data File",
    'RVG'          => "RVG X-ray Image",
    'RSF'          => "Recovery State File",
    'REC'          => "eJuice Me Up Recipe File",
    'REX'          => "Rexx Source File",
    'RDW'          => "Real-DRAW Project File",
    'RPROJ'        => "R Project",
    'RPRES'        => "R Presentation File",
    'RMD'          => "R Markdown File",
    'RBF'          => "Stellar Insta Backup Image",
    'RDG'          => "RDCman Config File",
    'ROZ'          => "aSc TimeTables Schedule File",
    'RCUT'         => "Webinaria Recording Cut",
    'RCREC'        => "LogMeIn Remote Control Session Recording",
    'RWT'          => "ReadWriteThink Printing Press Draft",
    'RWT'          => "ReadWriteThink Timeline",
    'RPGPROJECT'   => "RPG Maker MV Project",
    'RVF'          => "RichView Format File",
    'RTTEX'        => "Robinson Technologies Texture File",
    'RBXMX'        => "ROBLOX Model",
    'RGD'          => "Raft Saved Game File",
    'RSS'          => "RAM Structural System Model File",
    'RAP'          => "Raptor Flowchart File",
    'RMH'          => "Rights-Managed HTML Document",
    'RTS'          => "RealPlayer Streaming Media",
    'RGB'          => "RGB Bitmap",
    'RTX'          => "Rich Text Document",
    'ROI'          => "Report Object Instance",
    'ROV'          => "Report Object Variable",
    'REZ'          => "Escape Velocity Plug-in File",
    'RPM'          => "RealPlayer Plug-in",
    'RRT'          => "Rhapzode Resource Template",
    'RP'           => "RealPix Clip",
    'R02'          => "WinRAR Split Archive Part 2",
    'R03'          => "WinRAR Split Archive Part 3",
    'RB'           => "Real Studio Project",
    'RAS'          => "Remedy Archive System File",
    'RATDVD'       => "RatDVD Disk Image",
    'RDS'          => "Ray Dream Studio Scene File",
    'RNG'          => "RELAX NG File",
    'RAW'          => "Raw Audio Data",
    'RTS'          => "Real Tracker Sample",
    'RK'           => "WinRK File Archive",
    'RPJ'          => "Real Pac Batch Job File",
    'RZX'          => "File Crypt Encrypted File",
    'RBF'          => "Retrospect Backup File",
    'RBK'          => "Windows 95 Registry Backup File",
    'RBX'          => "Rembo-C Compiled Script",
    'RNC'          => "RNC ProPack Archive",
    'RUN'          => "Rune Map File",
    'RSR'          => "Poser Model Preview File",
    'RTM'          => "LabVIEW Run-Time Menu File",
    'RUN'          => "Runscanner Scan File",
    'REV'          => "RAR Recovery Volume Set",
    'RPB'          => "Radmin Phonebook File",
    'RSDF'         => "RapidShare Download File",
    'RMM'          => "RAM Meta File",
    'RIC'          => "NXT Image File",
    'RFT'          => "Revit Family Template File",
    'RDF'          => "PowerProducer Disc Image",
    'RW3'          => "RapidWeaver 3 Site File",
    'RPY'          => "Touhou Project Replay File",
    'ROT'          => "Homeworld 2 Graphics File",
    'REB'          => "REBOL Script File",
    'R0'           => "WinRAR Compressed Archive",
    'R1'           => "WinRAR Multi-Volume Archive Part 1",
    'R2'           => "WinRAR Multi-Volume Archive Part 2",
    'REF'          => "Microsoft Train Simulator Reference File",
    'R30'          => "WinRAR Split Archive Part 30",
    'RFA'          => "Battlefield 1942 Game Package",
    'RNX'          => "RealPlayer Settings File",
    'RFT'          => "RoboForm Identity File",
    'RFC'          => "RoboForm Contact File",
    'RFB'          => "RoboForm Bookmark File",
    'RMS'          => "Java Application Settings File",
    'RCO'          => "PlayStation Portable Resource File",
    'RSB'          => "Red Storm Bitmap File",
    'RB4'          => "RobotWorks Parameters File",
    'RIFF'         => "Painter Raster Image",
    'RFD'          => "Recogniform Form Designer File",
    'RPD'          => "Roleplay Designer Data File",
    'RVX'          => "Real Protected Video File",
    'RPYC'         => "Ren'Py Compiled Script",
    'RPY'          => "Ren'Py Script",
    'R21'          => "WinRAR Split Archive Part 21",
    'RGSS2A'       => "RPG Maker VX RGSS Encrypted Archive",
    'RCY'          => "ReCycle 1.x Document",
    'RFGS_PC'      => "Red Faction: Guerilla Saved Game File",
    'ROXIO'        => "Roxio Project",
    'RBS'          => "MP3 Ringtone File",
    'RPTR'         => "RafflePrinter Document",
    'RBXS'         => "ROBLOX Script",
    'RESMONCFG'    => "Resource Monitor Configuration File",
    'ROCA'         => "RIB office Compressed Archive",
    'ROD'          => "RIB office Database File",
    'RPD'          => "RIB Project Database File",
    'RPA'          => "RIB Project Archive File",
    'RPF'          => "Grand Theft Auto Data File",
    'R'            => "Ratfor Source Code File",
    'RML'          => "Elixir Report Template File",
    'RAD'          => "Radiance Scene File",
    'RDI'          => "Rohos Disk Image File",
    'RBF'          => "Redatam Binary File",
    'RDC'          => "IDRISI Raster Documentation File",
    'REF'          => "IDRISI Raster Image Reference File",
    'RL'           => "R.viewer List File",
    'RWS'          => "Retina Wireless Scanner File",
    'RWS'          => "RenderWare Stream File",
    'RTP'          => "Gromacs Residue Topology Parameter File",
    'RMX'          => "Reference Manager Index File",
    'RMD'          => "Reference Manager Data File",
    'RXC'          => "Roxio Certificate File",
    'ROCK'         => "Rockbox Plug-in",
    'RC1'          => "Samsung Mobile Device Firmware File",
    'RC2'          => "Samsung Mobile Device Firmware File",
    'RHISTORY'     => "R History File",
    'RDA'          => "R Data File",
    'ROTEST'       => "RemObjects SDK Test File",
    'ROTESTRESULT' => "RemObjects SDK Test Results File",
    'RASKINLICENS' => " 'Raskin License File",
    'RASKINPLACE'  => "Raskin Place Layout File",
    'RED'          => "CADViewer Redline Markup File",
    'REQ'          => "Canon SD Card Version Request File",
    'RGMB'         => "RootsMagic Backup File",
    'RPL'          => "Special Force Replay",
    'RSO'          => "ARIS Report Script Object File",
    'RIM'          => "BioWare Resource Image File",
    'RWTHEME'      => "RapidWeaver Theme",
    'RWSTYLE'      => "RapidWeaver Style File",
    'RWSNIPPET'    => "RapidWeaver Snippet File",
    'RWPLUGIN'     => "RapidWeaver Plugin",
    'RRA'          => "vRigger Rigging Gear File",
    'RLS'          => "Symbian Localization File",
    'RTWSH'        => "Radiotracker Wishlist File",
    'RTSTN'        => "Audials Station File",
    'RMBAK'        => "Registry Mechanic Backup File",
    'RCU'          => "RealWorld Layered Cursor Image",
    'RSA'          => "Minecraft JAR Codesign File",
    'RRI'          => "RealWorld Image",
    'RPYB'         => "Ren'Py Bytecode File",
    'RVL'          => "Adobe Revel Library File",
    'RADIUMKEY2'   => "Radium 2 License File",
    'RMF'          => "Adobe Rights Management Document",
    'ROS'          => "BattleScribe Roster Editor File",
    'RBJ'          => "XRK Compiled Redcode Object File",
    'RBZ'          => "SketchUp Plugin",
    'RTA'          => "RoboHelp RTA Data File",
    'RTA'          => "TrueRTA Project File",
    'RWD'          => "Microsoft Flight Simulator Rewards File",
    'ROM'          => "Killing Floor Map File",
    'RS'           => "Rust Source Code File",
    'RES'          => "Valve Resource File",
    'RPI'          => "Render Plug-in",
    'RAD'          => "Reality Adlib Tracker Module",
    'RMF'          => "Hammer Rich Map Format",
    'RGF'          => "LEGO MINDSTORMS EV3 Robot Graphics File",
    'RSF'          => "LEGO MINDSTORMS EV3 Robot Sound File",
    'REL'          => "Relocatable Module File",
    'RSD'          => "Rosetta Stone Data File",
    'REZ'          => "FirstClass Resource File",
    'RTTTL'        => "Ring Tone Transfer Language File",
    'RPT'          => "AccountEdge Report",
    'RBM'          => "Real Studio Menu File",
    'RBW'          => "Real Studio Window File",
    'RDOC'         => "Ruby Document",
    'RODX'         => "Ancestry Genealogical Database File",
    'ROD'          => "Ancestry Genealogical Database File",
    'REP'          => "X-Plane Replay File",
    'RPLN'         => "InDesign Required Plug-in File",
    'RASUNSOFT'    => "Rasunsoft Game Replay File",
    'RUEL'         => "Revo Uninstaller Pro Log",
    'RTL'          => "Raster Transfer Language File",
    'RPV'          => "RealPlayer Visualization File",
    'RGT'          => "Relic Entertainment Game Texture File",
    'RPC'          => "Rich Page Content Document",
    'RPX'          => "Wii U Game",
    'RPKG'         => "Hitman Game Patch Archive",
    'R04'          => "WinRAR Split Archive Part 4",
    'RDR'          => "Remote Desktop Manager Report Settings File",
    'ROFL'         => "League of Legends Replay File",
    'REDIF'        => "ReDIF Template",
    'RDF'          => "ReDIF Template",
    'RESS'         => "Unity 3D Model Archive",
    'RBXLX'        => "ROBLOX XML Place File",
    'RWS'          => "RimWorld Game Save File",
    'RPTR'         => "Crystal Reports Read-Only File",
    'RHR'          => "Script Rehearser Script File",
    'REPLAY'       => "Fortnite Replay File",
    'R3D'          => "RISA-3D Model File",
    'RBF'          => "LEGO MINDSTORMS EV3 Robot Brick File",
    'RSDK'         => "Retro SDK Archive",
    'RCV'          => "RoofCon Viewer Project File",
    'RAY'          => "Synopsys Light Ray Data File",
    'RGRID'        => "RepGrid File",
    'RFC'          => "Ravenfield Content File",
    'RCD'          => "Arcade File",
    'RTS'          => "QuickTime Real-Time Streaming Format",
    'RAD'          => "Radar ViewPoint Radar Data",
    'RAY'          => "Rayshade Image",
    'RF1'          => "Retirement Forecast File",
    'RU'           => "Java Russian Font Properties File",
    'RTP'          => "TurboTax Update File",
    'RGP'          => "RealArcade Game Package",
    'RIX'          => "ColoRIX Image",
    'RMF'          => "Rich Music Format Audio File",
    'ROG'          => "Roger 2 Input Data File",
    'RUPAF'        => "Revo Uninstaller Pro Activation File",
    'RTM'          => "Real Tracker Module",
    'R'            => "Right Audio Channel File",
    'RGB'          => "Q0 Image File",
    'REFERENCE'    => "Budget In Brief Reference File",
    'RRR'          => "Rhapzodé Resource Repository",
    'RB'           => "Rosebud Profile",
    'RP2'          => "RetroPlatform Player Program Archive",
    'RDX'          => "Reflex Data File",
    'ROI'          => "Shark Sales System Data File",
    'RKP'          => "Rockchip MP4 Player Game",
    'RMUF'         => "Alpha Five Runtime License File",
    'RFT'          => "Revisable Form Text Document",
    'RWG'          => "Random Word Generator Project File",
    'RUF'          => "Samsung DVD and Blu-ray Player Firmware File",
    'REL'          => "Norton Internet Security Log File",
    'RFD'          => "Emperor: Battle for Dune Data File",
    'REB'          => "Reimbursement Tracker Data File",
    'RMD'          => "RealPlayer Media File",
    'RDI'          => "Red Dragon ISecure Settings File",
    'RML'          => "FTG Configuration File",
    'RIG'          => "Antibody Model Rig File",
    'RSF'          => "Riky's Soft Document",
    'RBVCP'        => "Real Studio Version Controlled Project",
    'RES'          => "Star Wars KotOR Save Resources File",
    'RDA'          => "Anno 2070 Data File",
    'RSM'          => "ARIS Report Script Model File",
    'RS2'          => "RailSim2 Saved Layout File",
    'RLE.GZ'       => "Golly Compressed Simulation Pattern File",
    'RLE'          => "Golly Simulation Pattern File",
    'RS'           => "Sun Raster Graphic",
    'RECORD'       => "GarageBand Records Audio File",
    'RS'           => "Windows Rating System File",
    'REDIR'        => "Spotify Executable Redirect File",
    'RL'           => "The 7th Guest Audio Data File",
    'RMV'          => "Radical Entertainment Video File",
    'RCL'          => "Recolored Project File",
    'RKG'          => "Mario Kart Wii Ghost Data File",
    'RCTD'         => "RabbitCT Dataset",
    'RDOC_OPTIONS' => "Ruby Document Options File",
    'RGBA'         => "RGB Bitmap",
    'RVP'          => "Sharp Blu-ray Player Firmware File",
    'RTON'         => "Plants vs Zombies 2 Data File",
    'SQL'          => "Structured Query Language Data File",
    'SWF'          => "Shockwave Flash Movie",
    'SYS'          => "Windows System File",
    'SVG'          => "Scalable Vector Graphics File",
    'SITX'         => "StuffIt X Archive",
    'SRT'          => "SubRip Subtitle File",
    'SAV'          => "Saved Game",
    'SH'           => "Bash Shell Script",
    'SLN'          => "Visual Studio Solution File",
    'SDF'          => "Standard Data File",
    'SWIFT'        => "Swift Source Code File",
    'SIG'          => "Signature File",
    'SIT'          => "StuffIt Archive",
    'SWP'          => "Swap File",
    'SPS'          => "SPSS Program File",
    'SHP'          => "Shapes File",
    'SCR'          => "Windows Screensaver",
    'SMC'          => "Super Nintendo Game ROM",
    'SND'          => "Sound File",
    'SCF'          => "Windows Explorer Command",
    'SDR'          => "SmartDraw Drawing",
    'SQZ'          => "Squeeze Project File",
    'SIS'          => "Symbian Installation File",
    'SDB'          => "Custom Application Compatibility",
    'SMIL'         => "SMIL Presentation File",
    'SRC'          => "Source Code",
    'SIB'          => "Sibelius Score",
    'SID'          => "MrSID Image",
    'SAV'          => "SPSS Data File",
    'SRF'          => "Sony RAW Image",
    'SKP'          => "SketchUp Document",
    'SWI'          => "SWiSH Project File",
    'SDB'          => "SAP2000 Model File",
    'SCM'          => "ScreenCam Screen Recording",
    'SFX'          => "Windows Self-Extracting Archive",
    'STM'          => "Exchange Streaming Media File",
    'SHP'          => "ESRI Shapefile",
    'STP'          => "STEP 3D CAD File",
    'SAT'          => "ACIS SAT 3D Model File",
    'STL'          => "Stereolithography File",
    'STYLE'        => "SketchUp Style",
    'SVGZ'         => "Compressed SVG File",
    'SPV'          => "SPSS Output Document",
    'STX'          => "Pinnacle Studio Project File",
    'STY'          => "LaTeX Style",
    'SAF'          => "Street Atlas USA Map File",
    'SM'           => "StepMania Song File",
    'SDF'          => "Spatial Data Format File",
    'SQLITE'       => "SQLite Database File",
    'SIMS3PACK'    => "The Sims 3 Package File",
    'STB'          => "AutoCAD Plot Style Table File",
    'STE'          => "Dreamweaver Site Settings File",
    'SCS'          => "SimCity Societies Saved Game File",
    'SCN'          => "Age of Mythology Scenario File",
    'SPC'          => "Software Publisher Certificate File",
    'STORYMILL'    => "StoryMill Project File",
    'SQLITEDB'     => "SQLite Database",
    'SC2MAP'       => "Blizzard StarCraft 2 Map File",
    'SC2SAVE'      => "Blizzard StarCraft 2 Saved Game",
    'SC2REPLAY'    => "Blizzard StarCraft 2 Replay File",
    'SC2ASSETS'    => "Blizzard StarCraft 2 Assets File",
    'SC2MOD'       => "Blizzard StarCraft 2 Modification File",
    'SEQ'          => "PowerTracks Pro Audio Project File",
    'SHX'          => "AutoCAD Compiled Shape File",
    'SDEF'         => "AppleScript Dictionary Document",
    'SNAG'         => "SnagIt Capture File",
    'SVF'          => "Serial Vector Format File",
    'SDF'          => "Structure Data File",
    'SC45'         => "SuperCard Project File",
    'SBN'          => "ESRI Spatial Binary File",
    'SKM'          => "SketchUp Materials File",
    'SESX'         => "Adobe Audition Session File",
    'SIS.DM'       => "Ovi Store DRM-Protected Application",
    'SISX.DM'      => "Nokia Ovi Store DRM-Protected",
    'SAV'          => "Mass Effect 3 Saved Game",
    'SLP'          => "SpectraLayers Pro Project",
    'SPUB'         => "Swift Publisher Document",
    'SQF'          => "ArmA Script File",
    'SLX'          => "MathWorks Simulink Model File",
    'SNAGPROJ'     => "Snagit Project File",
    'SBU'          => "Samsung Backup File",
    'SIMS3'        => "The Sims 3 Game Save File",
    'SSC'          => "StepMania Song File",
    'SCDOC'        => "SpaceClaim Document",
    'SAS7BDAT'     => "SAS Data Set File",
    'SPRITE2'      => "Scratch 2.0 Sprite File",
    'SPLANE'       => "Simple Planes Plane File",
    'SFZ'          => "SFZ Sample Definition File",
    'SMRAILROADSS' => "V'EDGAME        Sid Meier's Railroads! Saved Game",
    'SEC'          => "Samsung Security Video File",
    'SIG'          => "QuickTac SIG File",
    'SIMP'         => "Software Ideas Modeler Project",
    'SPECCY'       => "Speccy Snapshot",
    'SCALA'        => "Scala Source Code File",
    'STD'          => "PROMT Translator Document",
    'STENCYL'      => "Stencyl Game File",
    'SID'          => "ScanIt Document",
    'SUM'          => "Scilab Unit Operation Model File",
    'SBZ'          => "ShowBiz Project File",
    'SCWORLD'      => "Survivalcraft World File",
    'SME'          => "Samsung Mobile Backup File",
    'SE1'          => "Swiss Ephemeris Data File",
    'SC4'          => "SuperCard 4 Project File",
    'SGD'          => "GeneSnap Image File",
    'SSM'          => "Sound Clip Archive",
    'SBGF'         => "Grapher Settings File",
    'SYNW-PROJ'    => "SynWrite Project",
    'SIFZ'         => "Synfig Studio Compressed Project",
    'SCE'          => "Scilab Script",
    'SONG'         => "AudioSauna Song File",
    'SGF'          => "Smart Game Format File",
    'SCUT4'        => "Easy Cut Studio Project",
    'SOEPSX'       => "Player Studio Viewer Item File",
    'STIX'         => "Structured Threat Information",
    'SHW'          => "MagicQ Show File",
    'STUDIO3'      => "Silhouette Studio Version 3 Document",
    'SDTID'        => "SecurID Soft Token File",
    'SPL7'         => "sPlan 7 Schematic Diagram File",
    'SMMX'         => "SimpleMind Mind Map File",
    'SERVICE'      => "Systemd Service Unit File",
    'SMP'          => "PhotoImpact Gallery File",
    'SJPG'         => "Sealed JPG File",
    'SCPRESETS'    => "Snap Converter Presets File",
    'SDLPROJ'      => "SDL Trados Studio Project",
    'SOL'          => "Solidity Script",
    'SPD'          => "S Note File",
    'SCM'          => "Scheme Source Code File",
    'SRF'          => "Smaart Spectrum File",
    'SV'           => "SystemVerilog Source Code File",
    'SEGY'         => "SEG-Y Data File",
    'SAVE'         => "The Sims 4 Save File",
    'SCRIBE'       => "VideoScribe Project",
    'SOR'          => "Standard OTDR Record File",
    'SIA'          => "Sia Metadata File",
    'SPP'          => "Substance Painter Project",
    'SNGX'         => "ChordWizard Song",
    'SKETCHPAD'    => "Sketchpad Drawing File",
    'SEA'          => "Self-Extracting Archive",
    'SCA'          => "Norton AntiVirus Scan File",
    'SUIT'         => "Macintosh Font Suitcase",
    'SNG'          => "MIDI Song File",
    'SCR'          => "Script File",
    'SHW'          => "Corel Presentation",
    'SGML'         => "Standard Generalized Markup Language",
    'SHTML'        => "Server Side Include HTML File",
    'SCT'          => "Scitex Continuous Tone File",
    'S3M'          => "ScreamTracker 3 Module",
    'SHTM'         => "HTML Server Side Include File",
    'SHS'          => "Microsoft Scrap File",
    'SFV'          => "Simple File Verification File",
    'SMF'          => "Standard MIDI File",
    'SUB'          => "Subtitle File",
    'SUP'          => "Subtitle Bitmap File",
    'SXC'          => "StarOffice Calc Spreadsheet",
    'SXD'          => "StarOffice Drawing",
    'SXI'          => "StarOffice Impress Presentation",
    'SXW'          => "StarOffice Writer Document",
    'SPDF'         => "Sealed PDF File",
    'SCD'          => "TurboTax Tax Schedule List",
    'SVI'          => "Samsung Video File",
    'SD2'          => "Sound Designer II File",
    'SDC'          => "Apache OpenOffice Calc Spreadsheet",
    'SDW'          => "StarOffice Writer Text Document",
    'SWA'          => "Shockwave Audio",
    'SET'          => "Settings File",
    'SO'           => "Shared Library",
    'SPRG'         => "Synclavier Program File",
    'SCT'          => "FoxPro Form Memo",
    'SCX'          => "FoxPro Form",
    'SQM'          => "Service Quality Monitoring File",
    'SF2'          => "SoundFont 2 Sound Bank",
    'S'            => "Source Code File",
    'SKINDEX'      => "Mail Index File",
    'SEC'          => "PGP Secret Key Ring",
    'SKR'          => "PGP Private Keyring",
    'SFO'          => "CuteFTP Search File",
    'SFO'          => "PSP Game Parameters File",
    'SC4'          => "SimCity 4 Saved File",
    'SAFETEXT'     => "SafeText File",
    'STRINGS'      => "Text Strings File",
    'SYX'          => "MIDI System Exclusive Message",
    'SD'           => "Sound Designer Audio File",
    'SD'           => "ESPS Sampled Data File",
    'SOL'          => "Flash Local Shared Object File",
    'SC2'          => "Sample Cell II Instrument Definition",
    'SOU'          => "SBStudio II Sound File",
    'S3I'          => "Scream Tracker 3 Instrument",
    'SBK'          => "SWiSH Project Backup File",
    'SBI'          => "Sound Blaster Instrument",
    'SDS'          => "MIDI Sample Dump Standard File",
    'SPPACK'       => "SPPack Sound Sample",
    'SND'          => "Macintosh Sound Resource",
    'STM'          => "Scream Tracker 2 Module",
    'STX'          => "Scream Tracker Music Interface Kit File",
    'SYH'          => "Synchomatic Instrument",
    'SYW'          => "Yamaha SY99/SY85 Audio File",
    'SCW'          => "Movie Magic Screenwriter Document",
    'SCW'          => "Score Writer Document",
    'S7Z'          => "Mac OS X 7-Zip File",
    'SQX'          => "SQX Archive",
    'SQ'           => "Sysquake Program",
    'SQD'          => "SQ Data File",
    'SDS'          => "OpenOffice.org Chart",
    'STO'          => "PRO100 3D Interior Design Project",
    'SFK'          => "Sound Forge Pro Audio Peak File",
    'SGM'          => "SGML File",
    'SKB'          => "SketchUp Backup Document",
    'SPUB'         => "Disc Cover File",
    'SNIPPET'      => "Visual Studio IntelliSense Code Snippet",
    'SYS'          => "Motorola Driver File",
    'SQM'          => "Operation Flashpoint Mission File",
    'SQR'          => "SQL Program File",
    'SISX'         => "Symbian OS Installation File",
    'STA'          => "ABAQUS Status File",
    'ST'           => "Atari ST Disk Image",
    'SC'           => "SuperCollider Source Code File",
    'SUD'          => "Super Project Analyzer File",
    'SUD'          => "Sudoku Puzzle File",
    'SUP'          => "Super Project Definition File",
    'SAR'          => "Sibelius Arrange Style",
    'SL'           => "Software License File",
    'STR'          => "dBASE Structure List Object File",
    'SBK'          => "Scrapbook Factory File",
    'SHN'          => "Shorten Compressed Audio File",
    'S19'          => "Motorola S19 File Record",
    'SCF'          => "DNA Sequence Chromatogram File",
    'STK'          => "Stickfigure Animator File",
    'SSA'          => "Sub Station Alpha Subtitle File",
    'SHX'          => "Shapefile Index File",
    'SFVIDCAP'     => "Sonic Foundry Video Capture File",
    'SFL'          => "Sound Forge Pro Sound Data File",
    'SLDASM'       => "SolidWorks Assembly File",
    'SLDPRT'       => "SolidWorks Part File",
    'SLDDRW'       => "SolidWorks Drawing File",
    'S85'          => "Sabre Airline Solutions Chart",
    'SCPT'         => "AppleScript Script File",
    'SHY'          => "ShyFile Encrypted File",
    'SKV'          => "Semicolon Separated Values File",
    'SKX'          => "XLANG Schedule File",
    'SCH'          => "EAGLE Schematics File",
    'SP'           => "SignPlot Traffic Sign File",
    'SCN'          => "SimCity Scenario File",
    'SDB'          => "ServerBoss Database File",
    'SH'           => "Unix Shell Archive",
    'SHR'          => "Unix Shell Archive File",
    'SRS'          => "Outlook Send/Receive Settings File",
    'SCX'          => "Game Scenario File",
    'SCX'          => "Microsoft Game Scenario File",
    'SCAR'         => "SCAR Script",
    'SEF'          => "Encryptafile Signature File",
    'SAS'          => "SAS Program File",
    'SQFS'         => "Squash FS Bootable File",
    'S00'          => "ZipSplitter Part 1 Archive",
    'S01'          => "ZipSplitter Part 2 Archive",
    'S02'          => "ZipSplitter Part 3 Archive",
    'SEED'         => "Linux Preseed File",
    'SKI'          => "Motorola Phone Skin File",
    'SIMS2PACK'    => "Downloaded Sims 2 Package File",
    'SCV'          => "ScanVec CASmate Sign File",
    'SSC'          => "SourceSafe Status File",
    'SIG'          => "Broderbund Sign File",
    'SPP'          => "Serif PhotoPlus Picture File",
    'SFS'          => "Squashfs File Archive",
    'SDB'          => "MonKey Office SQLite Database File",
    'SHX'          => "Motorola Flash Superfile",
    'SWK'          => "StudyWorks Save File",
    'SMS'          => "Exported SMS Text Message",
    'SAVEDDECK'    => "Nokia Saved Web Page",
    'SW2'          => "Softwrap License File",
    'SAVER'        => "Mac OS X Screen Saver",
    'SRM'          => "Super Nintendo ROM Save File",
    'SQB'          => "SQL Backup SQL Server Backup File",
    'SVN-WORK'     => "Subversion Cache File",
    'SUO'          => "Visual Studio Solution User Options",
    'SMK'          => "Smacker Compressed Movie File",
    'SWD'          => "Flash Debug File",
    'SLP'          => "Sisulizer Project File",
    'SLE'          => "Sisulizer Package File",
    'SPG'          => "TCP Optimizer Backup File",
    'SAVEDSEARCH'  => "Spotlight Saved Search",
    'SPE'          => "WinSpec CCD Capture File",
    'STEP'         => "STEP 3D Model",
    'SEO'          => "SEO Note File",
    'SPT'          => "SpeedTree Tree Data File",
    'SAR'          => "Service Archive File",
    'SDT'          => "SmartDraw Template File",
    'SDT'          => "Grand Theft Auto 3 Audio File",
    'SNA'          => "Drive Snapshot Primary Backup File",
    'SN1'          => "Drive Snapshot First Differential",
    'SN2'          => "Drive Snapshot Second Differential",
    'SWC'          => "Flex Components Archive",
    'SWC'          => "Super Nintendo Wild Card ROM File",
    'SCRIPT'       => "Generic Script File",
    'SV5'          => "BigJig Saved Puzzle",
    'SVS'          => "Game Boy Advance Saved State File",
    'SMA'          => "AMX Mod Plugin Source File",
    'SPR'          => "Half-Life Sprite File",
    'SNP'          => "Access Report Snapshot",
    'SPARSEIMAGE'  => "Mac OS X Sparse Image",
    'SPARSEBUNDLE' => "Mac OS X Sparse Bundle",
    'SDP'          => "Session Description Protocol File",
    'SES'          => "Audition Session File",
    'STT'          => "Streets & Trips Map Template",
    'SAD'          => "Black & White Audio File",
    'SR0'          => "SecuROM Analysis File",
    'SSS'          => "WindowBlinds Substyle File",
    'SSD'          => "WindowBlinds Skin File List",
    'SLT'          => "Mozilla User Profile Folder",
    'SSLF'         => "HLSW Shared Server List File",
    'STH'          => "Lotus Domino Stash File",
    'SH3D'         => "Sweet Home 3D Design File",
    'SH3F'         => "Sweet Home 3D Model Library",
    'SPRITE'       => "SuperTux Sprite File",
    'SIF'          => "Windows Setup Information File",
    'SLDDRT'       => "SolidWorks Sheet File",
    'SSW'          => "Sony Ericsson Firmware File",
    'SKL'          => "Maya Skeleton File",
    'SKZ'          => "SuperKaramba Theme",
    'SRF'          => "Server Response File",
    'SDF'          => "SQL Server Compact Database File",
    'SWT'          => "Flash Generator Template",
    'SUF'          => "Ccrypt Encrypted File",
    'SCA'          => "Scala Script File",
    'SWITCH'       => "Switch Package",
    'SK2'          => "ChemSketch Drawing",
    'SMI'          => "SMIL Presentation",
    'SDC'          => "Secure Download Cabinet",
    'STYKZ'        => "Stykz Animation",
    'STYK'         => "Stykz Stick Figure",
    'SMZIP'        => "StepMania Package",
    'SCM'          => "GIMP Script-Fu Script",
    'STYLE'        => "ArcGIS Style Manager File",
    'SB'           => "Scratch Project File",
    'SNAPFIRESHOW' => "Corel SnapfireShow File",
    'SGB'          => "Dawn of War Map File",
    'SEN'          => "SenTest Data File",
    'SLK'          => "Symbolic Link File",
    'SKN'          => "Symbian OS Skin File",
    'STP'          => "Analysis Studio Project Information",
    'SBV'          => "YouTube Captions File",
    'SPF'          => "Slingplayer Favorites File",
    'SLF'          => "Symantec License File",
    'SAB'          => "ACIS SAB Model File",
    'SESSION'      => "CATIA 4 Session File",
    'STU'          => "Pinnacle Studio Project File",
    'SSF'          => "Trimble Standard Storage Format File",
    'SIM'          => "SAP Tutor File",
    'SVN-BASE'     => "Subversion Base File",
    'SV2I'         => "Symantec System Index File",
    'STG'          => "ActiveSync Backup File",
    'SBX'          => "ESRI Spatial Index File",
    'SID'          => "Steam Game Data Backup File",
    'SIS'          => "Steam Game Backup Information File",
    'SBC'          => "Office Accounting Company Shortcut File",
    'SBD'          => "Office Accounting Company Data File",
    'SDAT'         => "Nintendo DS Sound Data File",
    'SSEQ'         => "Nintendo DS Sound File",
    'SAV'          => "Nintendo DS Save File",
    'SCS'          => "Prism3D Game Data File",
    'SPC'          => "SNES Soundtrack File",
    'SETTINGS'     => "Visual Studio Settings File",
    'SITEMAP'      => "ASP.NET Site Map File",
    'SKIN'         => "ASP.NET Skin File",
    'SBW'          => "US Treasury Savings Bonds Wizard File",
    'SC2DATA'      => "Blizzard StarCraft 2 Data File",
    'SC2ARCHIVE'   => "Blizzard StarCraft 2 Archive File",
    'S2MV'         => "StarCraft 2 Map Preview File",
    'S2ML'         => "StarCraft 2 Map Localization File",
    'SC2MA'        => "StarCraft 2 Map Data File",
    'SNK'          => "Strong Name Key File",
    'SAFARIEXTZ'   => "Apple Safari Extension Package",
    'SIDX'         => "StuffIt Archive Index File",
    'SXD'          => "ArcScene Document",
    'SEQ'          => "NorPix StreamPix Sequence",
    'SC2BANK'      => "StarCraft 2 Bank File",
    'SIS'          => "Sisma Database File",
    'SCZ'          => "SmartDraw Collection Package File",
    'SC4MODEL'     => "SimCity 4 Model File",
    'SC4LOT'       => "SimCity 4 Lot File",
    'SC4DESC'      => "SimCity 4 Description File",
    'SSI'          => "Adobe Dreamweaver Server Side Include",
    'SQLITE3'      => "SQLite 3 Database File",
    'SWZ'          => "Adobe Flash Player Cache File",
    'SGM'          => "VisualBoyAdvance Saved Game",
    'STA'          => "MAME Saved State File",
    'SR2'          => "Sony RAW Image",
    'SCG'          => "myPM SCG Definition File",
    'SEARCH-MS'    => "Windows Saved Search File",
    'SCC'          => "SourceSafe Source Code Control File",
    'SLA'          => "Scribus Document",
    'SLA.GZ'       => "Scribus Compressed Document",
    'SYN'          => "SimSynth Document",
    'SBP'          => "OpenSBP CNC Program File",
    'SAP'          => "Atari SAP Music File",
    'SPS'          => "SyncBack Settings File",
    'SDSK'         => "SafeHouse Private Storage Volume",
    'SKITCH'       => "Skitch Image",
    'SLUPKG-MS'    => "XrML Digital License Package",
    'SITES2'       => "iWeb Site Design Project",
    'SWP'          => "Vi Swap File",
    'SLDTM'        => "SDL Translation Memory File",
    'SBN'          => "Cisco IP Phone Firmware File",
    'SRR'          => "ReScene Metadata File",
    'SII'          => "18 Wheels of Steel: Haulin' Truck",
    'SSP'          => "Screensaver Producer Project File",
    'SCHEMATIC'    => "MCEdit Schematic File",
    'SCM'          => "CLEO Compiled Script",
    'SNT'          => "Sticky Notes File",
    'SHD'          => "Windows Print Job Shadow File",
    'SPL'          => "Windows Print Spool File",
    'STL'          => "Spruce Technologies Subtitle File",
    'SCC'          => "ScreenFlow Screen Recording",
    'SCREENFLOW'   => "ScreenFlow Document",
    'SPB'          => "Flight Simulator Mission File",
    'SBPROJ'       => "OpenGL Shader Builder Project",
    'SFD'          => "Spline Font Database File",
    'SBS'          => "SPSS Script",
    'SMD'          => "Valve Studiomdl Data File",
    'SPARC'        => "Skype Plugin Archive",
    'SRF'          => "LightWave Surface File",
    'SCO'          => "TotalRecovery Backup Image",
    'S2Z'          => "Heroes of Newerth Game Data File",
    'SYM'          => "Symbols File",
    'STORY'        => "Storyist Document",
    'SCRIV'        => "Scrivener Document",
    'SCRIVX'       => "Scrivener XML Document",
    'SPJ'          => "Microsoft ICE Panorama Project",
    'SGT'          => "SPSS Chart Template",
    'SPD'          => "SPSS Custom Dialog File",
    'SPQ'          => "SPSS Database Query File",
    'SHSH'         => "iPhone/iPod Touch SHSH Blob File",
    'SKETCH'       => "Sketch Drawing",
    'SEARCHCONNEC' => "O'R-MS          Windows Search Connector File",
    'SUCK'         => "SiteSucker Website File",
    'SPFX'         => "Squeeze Presets File",
    'SMT'          => "Samsung Theme File",
    'STPROJ'       => "Samsung Theme Document",
    'STC'          => "Contribute Connection Key File",
    'SVX'          => "Survex Cavern Data File",
    'SDW'          => "MrSID World File",
    'SBF'          => "Android System File",
    'SCAD'         => "OpenSCAD Script",
    'SRW'          => "Samsung RAW Image",
    'SWJ'          => "SolidWorks Journal File",
    'SFC'          => "Super Nintendo ROM",
    'STDL'         => "Swift To-Do List Database",
    'SVD'          => "Roland Patch File",
    'SPK'          => "Synology Package",
    'SGA'          => "Relic Entertainment Game Archive",
    'SDZ'          => "Spring Content Package",
    'SKF'          => "AutoSketch Drawing",
    'SRF'          => "Surfer Project File",
    'SDG'          => "Strater Project File",
    'STAP'         => "Soundtrack Pro Audio Project File",
    'STY'          => "Band-in-a-Box Styles File",
    'SED'          => "IExpress Self Extraction Directive File",
    'SSV'          => "Seavus Secure Project File",
    'SQF'          => "Sothink SWF Quicker File",
    'SPA'          => "MikuMikuDance Sphere Mapping File",
    'SPH'          => "MikuMikuDance Sphere Mapping File",
    'STORYBOARD'   => "Interface Builder Storyboard Document",
    'SV$'          => "AutoCAD Automated Backup File",
    'SAH'          => "SETIathome Data File",
    'SIV'          => "Silicon Imaging Video File",
    'SCN'          => "Orbiter Scenario File",
    'SMP'          => "SmartMusic Performance File",
    'SMA'          => "SmartMusic Accompaniment File",
    'SCRIPTTERMIN' => "L'OGY           AppleScript Script Terminology File",
    'SCRIPTSUITE'  => "AppleScript Script Suite File",
    'SNAPSHOT'     => "VMware ThinApp Snapshot File",
    'SDR'          => "Dell Support File",
    'SXT'          => "Propellerhead Reason NN-XT Patch File",
    'SMI'          => "SAMI Subtitles File",
    'SPEC'         => "RPM Specification File",
    'SLX'          => "SpectraLayers Pro Project",
    'SEDPRJ'       => "Slideshow Studio Elements Project",
    'SS'           => "SilverStripe Source Code File",
    'SUB'          => "CloneCD Subchannel File",
    'SJD'          => "Scrapbook Factory Journal File",
    'SFAR'         => "Mass Effect 3 DLC File",
    'SFT'          => "Microsoft App-V Sequencer File",
    'SDLXLIFF'     => "SDL Trados XLIFF Localization File",
    'SPJ'          => "PhotoStage Slideshow Project",
    'SCS11'        => "Show Cue System Cue File",
    'SMALI'        => "Android Smali Assembly Language File",
    'SNS'          => "Save-N-Sync Project File",
    'SQLPROJ'      => "Visual Studio SQL Server Project",
    'SLD'          => "Styled Layer Descriptor File",
    'SM'           => "SMath Studio Document",
    'SFF'          => "Standard Flowgram Format File",
    'SHOW'         => "Thinkfree Office NEO Show Document",
    'SDL'          => "Scene Description Language File",
    'SCB'          => "Scrambls Encrypted File",
    'SLOGO'        => "StarLogo Project File",
    'SLTNG'        => "StarLogo TNG Project File",
    'SGP'          => "MP3 Audio Mixer Sound Group Project",
    'SAI'          => "PaintTool SAI Image",
    'SDX'          => "Kivuto Secure Download Manager File",
    'SSP'          => "SlideShow Creator Project File",
    'SD7'          => "Spring Content Package",
    'SFPACK'       => "Packed SoundFont File",
    'SX'           => "SimplexNumerica Data File",
    'SP'           => "Simplexety Parameters File",
    'SAMI'         => "Grand Theft Auto San Andres Mod",
    'SUBLIME-PROJ' => "C'T             Sublime Text Project File",
    'SUBLIME-WORK' => "P'ACE           Sublime Text Workspace File",
    'SRC.RPM'      => "Red Hat Package Manager Source File",
    'SKYPECHATSTY' => "E'Chat Style File",
    'SDV'          => "Studio DV Project File",
    'SITES'        => "iWeb Site Design Project",
    'SQD'          => "Configuration Settings File",
    'SCPTD'        => "AppleScript Script Bundle",
    'SNAGSTYLES'   => "Snagit Style Archive",
    'SNAGITSTAMPS' => "Snagit Stamp Archive",
    'STRM'         => "Stream File",
    'SLI'          => "OMSI Spline Configuration File",
    'SMPX'         => "SmartMusic Accompaniment File",
    'SB2'          => "Scratch 2.0 Project File",
    'SB3'          => "Scratch 3.0 Project File",
    'SMPKG'        => "SmartMusic Package File",
    'SMX'          => "SmartMusic XML File",
    'SAFE'         => "SIGLock Encrypted File",
    'SETTINGCONTE' => "T'-MS           Windows Settings File",
    'SGPBPRJ'      => "Baltie Project",
    'SNF'          => "Starry Night Pro Document",
    'SMPF'         => "Sprite Monkey Project",
    'SDB'          => "SparkleDB Database File",
    'SCSS'         => "Sass Cascading Style Sheet",
    'SCH'          => "gEDA Schematic File",
    'SYM'          => "gEDA Symbol File",
    'SKBA'         => "SketchBook Pro Animation File",
    'SUBLIME-PACK' => "G'E             Sublime Text Package File",
    'SG0'          => "Humongous Entertainment Game Save File",
    'SCGC'         => "myPM SCG Classic Data File",
    'SCGS'         => "myPM SCG Starter Data File",
    'SCGP'         => "myPM SCG Pro Data File",
    'SMI'          => "Self-Mounting Disk Image",
    'SPK'          => "Artspeak Source File",
    'SPO'          => "SPSS Statistical Data Output File",
    'SMG'          => "SolidWorks Composer File",
    'SAM'          => "Ami Pro Document",
    'SMA'          => "SmartPlant Enhanced Report",
    'SITE'         => "GoLive Website Project File",
    'SMS'          => "Sega Master System ROM",
    'SHB'          => "Windows Document Shortcut",
    'SNM'          => "Netscape Mail Index",
    'SAF'          => "Secure Audio File",
    'SDN'          => "Shareware Distributors Network File",
    'SFW'          => "Seattle FilmWorks Image",
    'STC'          => "StarOffice Calc Spreadsheet Template",
    'STD'          => "Apache OpenOffice Drawing Template",
    'STI'          => "StarOffice Presentation Template",
    'STW'          => "StarOffice Document Template",
    'SXM'          => "StarMath Formula",
    'SGI'          => "Silicon Graphics Image File",
    'SHAR'         => "Unix Shar Archive",
    'SHG'          => "Segmented Hyper-Graphic",
    'SPD'          => "Sealed Acrobat Document",
    'SVX'          => "8SVX Sound File",
    'SDD'          => "StarOffice Presentation",
    'SCM'          => "StarCraft Map File",
    'SPL'          => "FutureSplash Animation",
    'SVR'          => "Compressed Virtual World",
    'SHT'          => "HTML File with Server Side Includes",
    'SPT'          => "ESPL Programming File",
    'SEW'          => "Home Embroidery Format",
    'SMV'          => "VideoLink Mail Video File",
    'SSND'         => "Synclavier Sound File",
    'SIMG'         => "Synclavier Disk Image File",
    'SSEQ'         => "Synclavier Sequence File",
    'STMB'         => "Synclavier Timbre File",
    'SIDN'         => "iTunes Authorization Data File",
    'SCT'          => "Windows Scriptlet",
    'SMP'          => "SampleVision Audio Sample Format",
    'SI'           => "Softimage Image File",
    'SFD'          => "Sofdec Dreamcast Movie",
    'SHORTCUT'     => "Asutype Shortcut",
    'SZ'           => "Winamp Classic Skin Download",
    'SND'          => "Akai MPC Sample",
    'SMD'          => "Sega Mega Drive ROM",
    'SDA'          => "StarOffice Drawing",
    'SDB'          => "OpenOffice.org Base Database File",
    'SDM'          => "StarOffice Mail Message",
    'SUN'          => "Sun Raster Graphic File",
    'SCC'          => "Scenarist Closed Caption File",
    'SBK'          => "E-MU SoundFont Sound Bank",
    'STL'          => "Fireworks Style Library",
    'SEQ'          => "DNA Sequence Text File",
    'SCF'          => "SimTown Sounds File",
    'STR'          => "PlayStation Video Stream",
    'SKV'          => "XLANG Schedule Drawing File",
    'SPR'          => "FoxPro Generated Screen File",
    'SCM'          => "Schema File",
    'SCN'          => "Pinnacle Studio Scene File",
    'SVC'          => "WCF Web Service File",
    'SEN'          => "Scifer Internal Header Archive",
    'SID'          => "SID Audio File",
    'SCB'          => "Scala Published Script",
    'SOUNDPACK'    => "SoundPackager Sound Package",
    'SFCACHE'      => "ReadyBoost Cache File",
    'SDS'          => "SDS Apps Data File",
    'SDC'          => "Stardock Central Download Archive",
    'STM'          => "SSI Web Page",
    'SER'          => "GeneMapper Project File",
    'STY'          => "Yamaha/Korg Keyboard Style",
    'SST'          => "Serialized Certificate Store File",
    'SBT'          => "SBT Subtitle File",
    'STP'          => "SharePoint Template",
    'SGB'          => "Super Game Boy ROM File",
    'S'            => "Microsoft Train Simulator Shape File",
    'SKIN'         => "InstallShield Skin File",
    'SBF'          => "Superbase Database File",
    'SBD'          => "Superbase Data Definition File",
    'SBV'          => "Superbase Form Definition File",
    'SBQ'          => "Superbase QuickReports File",
    'SGN'          => "Slax Boot File",
    'SWM'          => "Split Windows Imaging Format File",
    'SDI'          => "Windows System Deployment Image",
    'SPF'          => "ShadowProtect Full Backup File",
    'SPI'          => "ShadowProtect Incremental Backup File",
    'STF'          => "Exchange 2000 Server Temporary File",
    'SPX'          => "Ogg Vorbis Speex File",
    'SB'           => "Small Basic Source Code File",
    'SAV'          => "Parallels Desktop Saved State Image",
    'SLD'          => "AutoCAD Slide File",
    'SLB'          => "AutoCAD Slide Library",
    'SBG'          => "SBaGen Binaural Beat File",
    'SML'          => "SMIL Slideshow Presentation",
    'S2M'          => "Stronghold 2 Map File",
    'SIM'          => "Steam Game Backup Information File",
    'SBB'          => "Office Accounting Company Backup File",
    'SHV'          => "Husqvarna Viking Embroidery File",
    'S10'          => "Brasfoot Saved Game File",
    'SVA'          => "Manga Browser Comic File",
    'SPS'          => "Quake 3 Engine Speaker Definition File",
    'SOUNDS'       => "Quake 3 Engine Sound Definition File",
    'SHADER'       => "Quake 3 Engine Shader File",
    'SUMO'         => "Sumo Paint Image",
    'SYLK'         => "Microsoft Symbolic Link File",
    'SPT'          => "Cypress Semiconductor Script",
    'SBR'          => "Visual Studio Source Browser",
    'SNG'          => "Korg Trinity Song File",
    'SRF'          => "Steinberg Resource File",
    'SDT'          => "Electronic Arts Sound Data File",
    'S3Z'          => "Compressed Scream Tracker 3 Module",
    'SC2LOCALE'    => "Blizzard StarCraft 2 Localization File",
    'SSC'          => "Stellarium Script",
    'S2MH'         => "StarCraft 2 Map Header File",
    'S2QL'         => "StarCraft 2 Unit Localization File",
    'S2QH'         => "StarCraft 2 Localization Header File",
    'SD2F'         => "Sound Designer 2 File",
    'STT'          => "Kaspersky Statistics File",
    'SHC'          => "Adobe Photoshop Contours File",
    'SHH'          => "Adobe Photoshop Shadow/Highlight",
    'STA'          => "Adobe Photoshop Match Color Image",
    'SPK'          => "Bright Spark Document",
    'SVF'          => "Simple Vector Format Graphic",
    'SH2'          => "Stronghold 2 Saved Game",
    'SMRD'         => "Adobe InDesign Filter File",
    'SMWT'         => "Adobe InDesign Filter",
    'SEQU'         => "Adobe Acrobat Sequence File",
    'SA1'          => "Game Boy Emulator Save File",
    'SV5'          => "Chris Sawyer's Locomotion Saved Game",
    'SEPLUGIN'     => "AppleScript Editor Plug-in",
    'SCM'          => "Samsung Channel List File",
    'SCRESULTS'    => "Spring Cleaning Results File",
    'SK1'          => "sK1 Vector Graphic File",
    'SEL'          => "LinkOne Selection List File",
    'SLL'          => "Static Link Library",
    'ST45'         => "SuperCard Trial Project File",
    'SP45'         => "SuperCard Player File",
    'SCACFG'       => "SuperCard Application Configuration",
    'SCPCFG'       => "SuperCard Project Configuration File",
    'SCH'          => "SuperCard Help Project File",
    'SCX'          => "SuperCard Help Project",
    'SO.0'         => "Unix Shared Library File",
    'SXG'          => "Apache OpenOffice Master Document",
    'SBN'          => "GT-31 Binary Data File",
    'SSP'          => "Scala Server Page",
    'SCD'          => "Data Rescue Saved Scan File",
    'SEAM'         => "Seam Framework Java Servlet File",
    'SPB'          => "Samsung Kies Phonebook File",
    'SFS'          => "SFX Sample File",
    'SED'          => "Sed Script",
    'SBS'          => "Secure Backup System File",
    'SFB'          => "PlayStation 3 Disc Data File",
    'SVW'          => "SpecView File",
    'SMP'          => "IDRISI Palette File",
    'STEAMSTART'   => "Valve Steam Start File",
    'STORYISTTHEM' => " 'Storyist Application Theme File",
    'SQUASHFS'     => "Squashfs File System File",
    'SMF'          => "Serif Metafile",
    'SMF'          => "StarMath Formula File",
    'SDP'          => "StarOffice Presentation File",
    'S5X'          => "Heritage of Kings: The Settlers Map",
    'SPE'          => "SPSS Extension",
    'SPJ'          => "SPSS Production Job File",
    'STT'          => "SPSS Table Template",
    'SC2'          => "SimCity 2000 City File",
    'SC3'          => "SimCity 3000 City File",
    'S4M'          => "SWAT 4 Map File",
    'STARTUPINFO'  => "E-Prime 2.0 Startup Info File",
    'SSC'          => "Celestia Solar System Catalog File",
    'STC'          => "Celestia Star Catalog File",
    'SDOC'         => "Sealed Word Document",
    'STTPL'        => "Samsung Theme Showcase File",
    'SPT'          => "AQW Trainer File",
    'SPS'          => "Sharkport PS2 Save File",
    'SCHEMAS'      => "GConf Schema Definition File",
    'SC2SCENE'     => "StarCraft 2 Cut Scene File",
    'SKIM'         => "Skim Notes File",
    'SREP'         => "SuperREP Compressed File",
    'SPRITE'       => "Scratch Sprite File",
    'SAM'          => "Samurize Package",
    'SFAP0'        => "Sound Forge Pro Audio Proxy File",
    'SPK'          => "Deer Hunter Map File",
    'SVE'          => "Simutrans Saved Game",
    'SFC'          => "Motic Microscope Image",
    'SVD'          => "SolidView Design File",
    'SMPD'         => "Sc2gears Mouse Print Data File",
    'SBX'          => "GLBasic Shoebox File",
    'SDF'          => "World in Conflict Game Map",
    'SFF'          => "M.U.G.E.N. Sprite File",
    'SCN'          => "OpenTTD Scenario File",
    'SCAP'         => "EFI Firmware File",
    'SZS'          => "Wii Game Data File",
    'SOLITAIRESAV' => "-'MS            Microsoft Solitaire Saved Game",
    'SPIDERSOLITA' => "R'ESAVE-MS      Microsoft Spider Solitaire Saved Game",
    'SY_'          => "Compressed SYS File",
    'SDINSTALL'    => "Speckie Dictionary Installation File",
    'SSL2'         => "Sunlight ScanLibrary 2 File",
    'SSL'          => "Sunlight ScanLibrary File",
    'SDZ'          => "NCI Compressed Database",
    'STC'          => "Shade to Manga Studio File",
    'SUM'          => "Garmin Checksum File",
    'SCH'          => "Strater Scheme File",
    'SPD'          => "Form·Z Suspended Render File",
    'SCN'          => "TreePaint Image",
    'SMF'          => "SkinMagic Toolkit File",
    'SMM'          => "Samsung Memo File",
    'SC6'          => "RollerCoaster Tycoon 2 Scenario File",
    'SPH'          => "NIST SPHERE Audio File",
    'SP3'          => "NGS SP3 File",
    'SK'           => "Safari History Index File",
    'SDT'          => "Siemens Desktop Theme File",
    'SSS'          => "Coda Style Sheet File",
    'SEESTYLE'     => "Coda Style Sheet File",
    'SKYPEEMOTICO' => "S'ET            Skype Emoticon Set File",
    'SF'           => "Minecraft JAR Signature File",
    'SHA512'       => "SHA 512 Hash File",
    'SHA1'         => "SHA-1 Hash File",
    'SGR'          => "SGR Genome Data File",
    'SYN'          => "RoboHelp Synonym List File",
    'STP'          => "RoboHelp Stop List File",
    'SBP'          => "Sketchbook Express iCloud Image",
    'SNS'          => "SNS Video Game Audio File",
    'SCH'          => "KiCad Schematic File",
    'SNX'          => "PISnoop Workspace File",
    'SMZ'          => "SMath Studio Compressed Document",
    'SDL'          => "Service Description Language File",
    'SUGAR'        => "Espresso Plug-in",
    'SB'           => "Slax Bundle",
    'SKN'          => "Avant Browser Skin File",
    'SFS'          => "Kerbal Space Program Save File",
    'SLOGT'        => "StarLogo Project Template",
    'SVT'          => "Torchlight Saved Game File",
    'STATS'        => "FreeSurfer Statistics File",
    'STS'          => "DuoS DSEMU Saved State File",
    'SMP'          => "SmilePlant Project Data File",
    'SYN'          => "TextPad Syntax File",
    'SC'           => "Space Engine Script",
    'SVG'          => "Saved Game File",
    'SIDB'         => "iTunes Authorization Data File",
    'SIDD'         => "iTunes Authorization Data File",
    'SNA'          => "NOGBA Snapshot File",
    'SY'           => "Simplexety Data File",
    'SESSION'      => "Mozilla Firefox Session File",
    'SLST'         => "Game Data File",
    'SKCARD'       => "Starfish Sidekick Card File",
    'SSII'         => "ProReveal Data File",
    'SSIS'         => "ProReveal Settings File",
    'SDO'          => "Signed Document",
    'SCLVL'        => "Scritter's Nest Data File",
    'SKSE'         => "Skyrim Script Extender Save File",
    'SM'           => "Space Engine 3D Mesh File",
    'SBX'          => "Adobe Illustrator Tsume File",
    'SCO'          => "OMSI Scenery Object Configuration File",
    'SSK'          => "SmartSketch 95 Document",
    'SPVCHAIN'     => "MultiCoin Wallet File",
    'SET'          => "Alpha Five Set Data Dictionary File",
    'SEM'          => "Alpha Five Set Data Dictionary Memo",
    'SEX'          => "Alpha Five Set Data Dictionary Index",
    'SECURITYSETT' => "N'GS            Alpha Five Security Settings File",
    'SIMS3.BACKUP' => "The Sims 3 Game Save Backup File",
    'SFERA'        => "Sfera 360° File",
    'SES'          => "Patran Session File",
    'SAM'          => "LMHOSTS Sample File",
    'SAB'          => "Saber File",
    'STN'          => "Genuine Fractals Image",
    'STIP'         => "SampleTank User Preset Instrument",
    'STFX'         => "SampleTank Effects Settings File",
    'SME'          => "SmartEncryptor Encrypted File",
    'SCONF'        => "Script Settings File",
    'SNB'          => "S Note File",
    'SGPBPR'       => "Baltie Program",
    'SGPSC'        => "Baltie Scene",
    'SHFT'         => "Shift Work Calendar Data File",
    'SSD'          => "Starry Night Pro Data File",
    'SNO'          => "Starry Night Pro Data File",
    'SE'           => "Shuttle Document",
    'SVM'          => "StarView Metafile",
    'SPLIT'        => "Archiver Split File",
    'SOE'          => "Star Wars: Shadows of the Empire Save",
    'SVE'          => "Fallout 2 Video Subtitle File",
    'SAV'          => "Fallout 2 Map Archive",
    'SSL'          => "Fallout Script",
    'S2M'          => "The Settlers 2 Map File",
    'SCRIPTLIBRAR' => " 'Painter Script Library",
    'SELECTIONPOR' => "F'OLIOLIBRARY   Painter Selection Portfolio Library",
    'SKD'          => "Max Payne Skin Data File",
    'SUBLIME-MENU' => "Sublime Text Menu File",
    'SUBLIME-OPTI' => "N'S             Sublime Text Options File",
    'SUBLIME-SETT' => "N'GS            Sublime Text Settings File",
    'SUBLIME-SNIP' => "E'T             Sublime Text Snippet File",
    'SUBLIME-SESS' => "O'N             Sublime Text Session File",
    'SUBLIME-KEYM' => "P'Sublime Text Keymap File",
    'SUBLIME-BUIL' => " 'Sublime Text Build File",
    'SUBLIME-THEM' => " 'Sublime Text Theme File",
    'SVQ'          => "Roland Sequencer File",
    'SPA'          => "Nintendo DS Particle File",
    'SWIDTAG'      => "SWID Tag File",
    'SOD'          => "Spear of Destiny Data File",
    'SBD'          => "DNASTAR SeqBuilder File",
    'SNAPPY'       => "Snappy Compressed File",
    'STAGE'        => "Pokémon Type Wild Stage Data File",
    'SPX'          => "System Profiler XML Report",
    'SPARSEFS'     => "BlueStacks Data Folder",
    'SOUNDSCRIPT'  => "Rigs of Rods Sound Script File",
    'STR'          => "X-Plane Object String File",
    'SP4'          => "SuperCard 4 Player Project",
    'ST4'          => "SuperCard Trial Project File",
    'STPROJ'       => "iAd Producer Project",
    'S3G'          => "MakerBot 3D Print File",
    'SRD'          => "Sage Report Data File",
    'SMENT'        => "StarMade Entity File",
    'SAN'          => "Smush Animation File",
    'SSM'          => "Samsung S Memo File",
    'SFI'          => "SafeFolder Encrypted File",
    'SIF'          => "Synfig Studio Project",
    'SFG'          => "Synfig Studio Compressed Project",
    'SASS'         => "Syntactically Awesome StyleSheets File",
    'STSKIN'       => "Steam Skin File",
    'SCI'          => "Scilab Script",
    'SCN'          => "TD Scan Data File",
    'SMSEC'        => "StarMade Sector File",
    'STUDIO'       => "Silhouette Studio Document",
    'SCL'          => "Sibelius Chord Diagram Library",
    'SPL'          => "sPlan Schematic Diagram File",
    'SMMSTORE'     => "Local Mind Map Store File",
    'SBX'          => "SeqBox Container File",
    'SCSKIN'       => "Survivalcraft Skin File",
    'SEB'          => "Safe Exam Browser Configuration File",
    'SGM'          => "Starpoint Gemini 2 Mod Package",
    'STXT'         => "Sealed Text File",
    'SXLS'         => "Sealed Excel Spreadsheet",
    'SXML'         => "Sealed XML File",
    'SMSKIN'       => "StarMade Skin File",
    'SASBX'        => "Space Agency Sandbox File",
    'S2ARR'        => "SynthFont2 Arrangement File",
    'SDLRPX'       => "SDL Trados Studio Return Package",
    'SDLPPX'       => "SDL Trados Studio Project Package",
    'SDLTPL'       => "SDL Trados Studio Project Template",
    'SEED'         => "SEED Data File",
    'SAFENOTEBACK' => "P'Safe Note Backup File",
    'S16'          => "Digital Voice Recorder Audio File",
    'SIM'          => "The Sims 3 Sim File",
    'SBF'          => "Septentrio Binary File",
    'SMV'          => "Smokeview Simulation Data",
    'SG'           => "SG-1000 Game ROM File",
    'STM'          => "The Powder Toy Stamp File",
    'SXCU'         => "ShareX Custom Uploader",
    'SC2'          => "World of Tanks Blitz Model File",
    'SDOC'         => "Samsung Memo",
    'SIS'          => "arivis ImageCore File",
    'SIN'          => "Sony Xperia Firmware File",
    'SBM'          => "Space Engineers Mod File",
    'SBC'          => "Space Engineers Data File",
    'SVH'          => "SystemVerilog Source Code Header File",
    'SDC'          => "Paragon Dictionary Database File",
    'SHIPWORLD'    => "Starbound Player Ship File",
    'SCB'          => "Euro Truck Simulator 2 Product Key File",
    'SERVER'       => "MySQL Server Script",
    'SGY'          => "SEG-Y Data File",
    'SPM'          => "Salt Package Manager Formula Package",
    'SRB'          => "Sonic Robo Blast 2 Data File",
    'STK'          => "Power Vision Stock File",
    'SABL'         => "Call of Duty: Black Ops II Sound",
    'SER'          => "Astronomical Capture Video File",
    'SBSAR'        => "Substance Archive",
    'SBS'          => "Substance Package",
    'STYX'         => "ChordWizard Style",
    'SIA'          => "Spin It Again Track Data File",
    'SPANISHER'    => "Spanisher Word File",
    'SIGNATURE'    => "e-Filing Digital Signature File",
    'SPARKLE'      => "Sparkle Website Project",
    'SMOD'         => "Stonehearth Mod File",
    'SHPROJ'       => "Visual Studio Code Sharing App Project",
    'SRF'          => "Samsung Smart TV Recording File",
    'SZS'          => "Nintendo Switch Game Data Archive",
    'SV4'          => "RollerCoaster Tycoon Saved Game",
    'STR'          => "Kingsoft Strings File",
    'SFX'          => "SoundFX Audio File",
    'SQZ'          => "The Master Genealogist Backup Project",
    'SYS-RESERVED' => "R'W-BITMAP.GROW Pioneer DVD Recorder Dummy File",
    'ST3'          => "Star 3 MIDI Karaoke File",
    'SAMP'         => "Nintendo ADPCM Sound Sample File",
    'SW'           => "Signed Word Audio File",
    'SMM'          => "Ami Pro Macro",
    'SDM'          => "Spatial Data Modeling Language File",
    'SF'           => "IRCAM Sound File",
    'SHK'          => "ShrinkIt Archive",
    'SPIFF'        => "Still Picture Interchange File Format",
    'SDQ'          => "SAS Data File",
    'SA9'          => "Hue and Cry Photoshop Plug-in",
    'SCG'          => "ColoRIX Image File",
    'SCI'          => "ColoRIX Graphics Image",
    'SCP'          => "ColoRIX Bitmap Graphic File",
    'SCU'          => "ColoRIX Bitmap Image",
    'SPC'          => "Spectrum 512 Compressed Image",
    'SPU'          => "Spectrum 512 Image",
    'SUNIFF'       => "Sun TAAC Image",
    'SBF'          => "SmartBroker Data",
    'SAR'          => "Saracen Paint Image",
    'SIM'          => "Aurora Image",
    'SDX'          => "Sample MIDI Dump Exchange",
    'SFF'          => "Structured Fax File",
    'SOPT'         => "Synclavier Optical Disk Image File",
    'SMP'          => "Xionics SMP Image",
    'SSM'          => "Standard Streaming Metafile",
    'SLS'          => "Image Playlist",
    'STD'          => "CD/DVD Label Template",
    'SAF'          => "SafeText File",
    'SB'           => "Signed Byte Audio File",
    'SAM'          => "MOD Edit Sample File",
    'SR'           => "Sun Raster Image File",
    'STW'          => "STATISTICA Workbook",
    'SET'          => "Document Library Property Set File",
    'STR'          => "Windows Screensaver File",
    'SBK'          => "Multimedia ToolBook System Book",
    'STL'          => "Certificate Trust List",
    'SV6'          => "RollerCoaster Tycoon 2 Saved Game",
    'SCM'          => "Super Chain Media File",
    'SPT'          => "TM File Packer Compressed Archive",
    'SUB'          => "SubTerra Level File",
    'SKC'          => "SideKick Card File",
    'SDB'          => "SocialDecks Blog File",
    'STML'         => "SSI HTML File",
    'SAVE'         => "Nano Temporary Save File",
    'SAM07'        => "SAM 2007 Package",
    'STE'          => "Samsung IPOLIS Image File",
    'SWV'          => "Microsoft Sidewinder Game Voice",
    'SBT'          => "Superbase Data Notes File",
    'SY3'          => "Harvard Graphics Symbol File",
    'STF'          => "Microsoft Setup Table File",
    'SONIC'        => "DigitalMedia Project File",
    'SEG'          => "Eragon Audio File",
    'SCEA'         => "Aleph One Map File",
    'SHPA'         => "Aleph One Shape File",
    'SNDA'         => "Aleph One Sound File",
    'SYSTEM'       => "Vega Strike Virtual System File",
    'SJAVA'        => "Synchronous Java File",
    'SEC'          => "GuinXell Video File",
    'SDII'         => "Sound Designer 2 Audio File",
    'SO-ABI'       => "Cocoa AbiWord Plug-in",
    'SCEXCLUDB'    => "Spring Cleaning Exclusions File",
    'SCRESTORELOG' => "Spring Cleaning Restore Log",
    'SGAA'         => "Aleph One Saved Game",
    'SUI'          => "StarSplatter User Interface File",
    'STY'          => "NewsMaker Story File",
    'SYB'          => "Syberia Game Data File",
    'SETTINGS'     => "Minecraft iConomy Plug-in Settings File",
    'SDOC'         => "Satra Khmer Document",
    'SP2'          => "Super Ball 2 Level File",
    'STY'          => "Aegisub Subtitle Styles File",
    'SCENE'        => "Antibody Level File",
    'SOW'          => "Descent ARJ Archive",
    'SGR'          => "SimCity 4 Graphics Rules File",
    'SSA'          => "Children of the Nile Campaign File",
    'SST'          => "Children of the Nile Textures File",
    'SFC'          => "Creatures Saved Game",
    'STSG'         => "SuperTux Saved Game",
    'STL'          => "SuperTux Level File",
    'STWM'         => "SuperTux World Map File",
    'SVD'          => "Scanning Vibrometer Data File",
    'SOB'          => "OpenOffice.org Impress Bimap Styles",
    'SPO'          => "Spore Saved Game",
    'SYN'          => "Synergy On Air Audio File",
    'SHA256'       => "FileVerifier++ SHA-256 Hashes File",
    'STR'          => "BFME2 Strings File",
    'SWW'          => "Anno Saved Game",
    'SEP'          => "Separated Image File",
    'SML'          => "ARC/INFO Simple Macro Language File",
    'SMM'          => "Map Manager Schema File",
    'SGN'          => "Signet Bureau DRM File",
    'SP3'          => "Windows XP SP3 CD File",
    'SCRATCH'      => "Scratch Project File",
    'STC'          => "Siemens Theme File",
    'S2E'          => "SWF to EXE Converter Project File",
    'SC4'          => "RollerCoaster Tycoon Scenario File",
    'SC5'          => "Chris Sawyer's Locomotion Scenario File",
    'SGZ'          => "SigzaLock Encrypted File",
    'S2A'          => "SEAL2 Application",
    'SAF'          => "McAfee Fortress File",
    'SRG'          => "Ketron Single Registration File",
    'SETUP'        => "CryENGINE Character Setup File",
    'SSF'          => "Structured Subtitle Format File",
    'SZS'          => "GameCube Data File",
    'SWAV'         => "Nintendo DS Audio File",
    'SRT0'         => "Wii Texture Animation File",
    'SMO'          => "Sumotori Dreams Arena File",
    'SYM'          => "TatukGIS Symbols File",
    'SSFSAV'       => "Super Smash Flash Saved Game File",
    'SFP'          => "Soft Font Printer File",
    'SRK'          => "Sub Rosa Client File",
    'SAVEDSTATE'   => "Virtual Router Saved State File",
    'SECURE'       => "Septium Secure Document",
    'SSCS'         => "Saropa Smart Copy Script",
    'SUPP'         => "iOS Application Archive File",
    'SVE'          => "Carmageddon: TDR 2000 Saved Game",
    'SNSF'         => "Super NES Sound Format File",
    'SIMS3.BAD'    => "The Sims 3 Failed Game Save File",
    'SINF'         => "iOS Application Archive File",
    'STH'          => "SampleTank User Preset Data File",
    'STI'          => "SampleTank User Preset Data File",
    'STW'          => "SampleTank User Preset Data File",
    'SKEIN'        => "Skein XML File",
    'SEF'          => "Password Manager Container File",
    'SNB'          => "Shanda Bambook eBook",
    'SCN0'         => "Wii Texture Animation File",
    'TAR'          => "Consolidated Unix File Archive",
    'TIFF'         => "Tagged Image File Format",
    'TGA'          => "Targa Graphic",
    'TXT'          => "Plain Text File",
    'TMP'          => "Temporary File",
    'TTF'          => "TrueType Font",
    'TIF'          => "Tagged Image File",
    'TEX'          => "LaTeX Source Document",
    'THM'          => "Thumbnail Image File",
    'TORRENT'      => "BitTorrent File",
    'TOAST'        => "Toast Disc Image",
    'TAR.GZ'       => "Compressed Tarball File",
    'TAX2016'      => "TurboTax 2016 Tax Return",
    'TAX2017'      => "TurboTax 2017 Tax Return",
    'TGZ'          => "Gzipped Tar File",
    'TSV'          => "Tab Separated Values File",
    'THEME'        => "Microsoft Plus! Desktop Theme",
    'TBK'          => "ToolBook File",
    'TCW'          => "TurboCAD Drawing File",
    'TMX'          => "Translation Memory Exchange File",
    'TRS'          => "Rosetta Stone Language Data File",
    'TPS'          => "Clarion TopSpeed Data File",
    'TS'           => "Video Transport Stream File",
    'THM'          => "Video Thumbnail File",
    'TDL'          => "Tab Delineated Format File",
    'THMX'         => "Office 2007 Theme File",
    'TOC'          => "Eudora Table of Contents",
    'THEMEPACK'    => "Windows 7 Theme Pack",
    'TRP'          => "HD Video Transport Stream",
    'TE'           => "Textease CT Database File",
    'TLG'          => "QuickBooks Transaction Log File",
    'TAX2009'      => "TurboTax 2009 Tax Return",
    'TRX'          => "Visual Studio Test Results File",
    'TIX'          => "DivX Video Download Activation File",
    'T08'          => "TaxCut 2008 Tax Return",
    'T09'          => "At Home 2009 Tax Return",
    'TRK'          => "CompeGPS Land Track File",
    'TAX2010'      => "TurboTax 2010 Tax Return",
    'T10'          => "At Home 2010 Tax Return",
    'TIF'          => "GeoTIFF Image",
    'TWB'          => "Tableau Workbook File",
    'TPZ'          => "Kindle Topaz eBook File",
    'TT10'         => "TurboTax Canada 2010 Tax Return",
    'TAX2011'      => "TurboTax 2011 Tax Return",
    'TAB'          => "MapInfo TAB File",
    'T11'          => "At Home 2011 Tax Return",
    'TOR'          => "Star Wars: The Old Republic Asset File",
    'TT12'         => "TurboTax Canada 2012 Tax Return",
    'T12'          => "At Home 2012 Tax Return",
    'TRAK'         => "Traktor Content Pack File",
    'TMV'          => "TimeMap Visual",
    'TAX2013'      => "TurboTax 2013 Tax Return",
    'T13'          => "H&R Block 2013 Tax Return",
    'TDB'          => "Android Thumbnail Cache",
    'TT13'         => "TurboTax Canada 2013 Tax Return",
    'TCP'          => "TurboCAD Mac Pro Drawing",
    'TCD'          => "TurboCAD Mac Deluxe Drawing",
    'T2D'          => "TouchDraw Document",
    'TAX2015'      => "TurboTax 2015 Tax Return",
    'T16'          => "H&R Block 2016 Tax Return",
    'T17'          => "H&R Block 2017 Tax Return",
    'TA7'          => "TaxAct 2017 Tax Return File",
    'TT17'         => "TurboTax Canada 2016 Tax Return",
    'TSCPROJ'      => "TechSmith Camtasia Project File",
    'TWH'          => "Task Wheel Project File",
    'TEXT'         => "Plain Text File",
    'TEX'          => "Texture File",
    'TTC'          => "TrueType Font Collection",
    'TLB'          => "OLE Type Library",
    'TPL'          => "Document Template",
    'TXF'          => "Tax Exchange Format",
    'TFW'          => "World File for TIFF",
    'TDL'          => "MathType Translator Definition Language",
    'TCL'          => "Tcl Script",
    'TK'           => "Tk Script",
    'TBK'          => "FoxPro Memo Backup",
    'TSK'          => "Pocket PC Skin",
    'TEF'          => "TablEdit Tablature",
    'TC'           => "TrueCrypt Volume",
    'TCN'          => "Techne Model File",
    'T64'          => "Commodore 64 Tape Image File",
    'TXW'          => "Yamaha TX16W Audio File",
    'TIVO'         => "TiVo Video File",
    'TKFL'         => "TKLinks Saver Favorite Links File",
    'TD0'          => "Teledisk Archive",
    'TD0'          => "Akai Teledisk Sound Library",
    'TOPC'         => "TopicCrunch Project File",
    'TAB'          => "Guitar Tablature File",
    'TFA'          => "TreeSoft CashFlow Analysis Data File",
    'TRD'          => "TrID Definitions Package",
    'TZX'          => "ZX Spectrum Tape Image File",
    'TFD'          => "Tape Format Requirements Document",
    'TFRD'         => "Tape Image Format Requirements Document",
    'TIB'          => "Acronis True Image File",
    'TJP'          => "TaskJuggler Project File",
    'THUMB'        => "JAlbum Thumbnail File",
    'THM'          => "Sony Ericsson Theme File",
    'TDA3MT'       => "DivX Author Template File",
    'TPU'          => "Turbo Pascal Unit",
    'TCD'          => "Technobox CAD Drawing",
    'TIM'          => "The Incredible Machine Level",
    'TJP'          => "Tiled JPEG File",
    'TST'          => "TestPoint Test File",
    'TPM'          => "Trusted Platform Module Password File",
    'TPM'          => "Transformation Parameters Model File",
    'TLC'          => "The Logo Creator File",
    'TARGETS'      => "MSBuild Targets File",
    'TXD'          => "Game Texture Dictionary",
    'TDF'          => "Guide Text Definition File",
    'TDF'          => "Xserve Test Definition File",
    'TDF'          => "Title Definition Format File",
    'TDS'          => "Turbo Debugger Symbols File",
    'TBS'          => "TuneUp Utilities Boot Screen",
    'TB'           => "Tabbery Tab File",
    'THE'          => "Microsoft Plus! Theme File",
    'TOD'          => "JVC Everio Video Capture File",
    'T'            => "Turing Source Code File",
    'TU'           => "Turing Source File",
    'TUR'          => "Turing Program Source File",
    'TTK'          => "Catalyst Translation Toolkit",
    'TCT'          => "TurboCAD Drawing Template",
    'TR3'          => "TomeRaider eBook File",
    'TSZ'          => "Trillian Skin File",
    'TP'           => "Beyond TV Transport Stream File",
    'TBM'          => "Toribash Mod File",
    'TRC'          => "Oracle Trace File",
    'T05'          => "TaxCut 2005 Tax Return",
    'T06'          => "TaxCut 2006 Tax Return",
    'T07'          => "TaxCut 2007 Tax Return",
    'T3001'        => "TARGET 3001! Circuit Design Project File",
    'TSTREAM'      => "SwarmPlayer Streaming Torrent",
    'TSM'          => "TwinCAT System Manager Configuration File",
    'TPB'          => "GROMACS Binary Input File",
    'TAZ'          => "Tar Zipped File",
    'TZ'           => "Zipped Tar Archive",
    'TBZ'          => "Bzip Compressed Tar Archive",
    'TTX'          => "Trados TagEditor File",
    'TK3'          => "TK3 Multimedia eBook",
    'TWT'          => "Carmageddon 2 Data File",
    'TCX'          => "Training Center XML File",
    'TEMP'         => "Temporary (Temp) File",
    'TRA'          => "WinTrack Railroad Track File",
    'TRS'          => "WinTrack Railroad Track Text File",
    'TE3'          => "WinTrack Object File",
    'TLS'          => "TuneUp Utilities Logon Screen",
    'TIP'          => "TuneUp Utilities Icon Package",
    'TG4'          => "Tiled Group 4 Raster Image File",
    'TAX2008'      => "TurboTax 2008 Tax Return",
    'TDA'          => "Palm To-Do File",
    'TDA'          => "Java Application Thread Dump",
    'TXA'          => "Midas ViewPoint Text Array List",
    'TPR'          => "TMPGEnc Project File",
    'TET'          => "Textease CT Template",
    'TWC'          => "TTWin Configuration File",
    'TVVI'         => "TitanTV Television Listing File",
    'TVPI'         => "TitanTV Television Listing File",
    'TDB'          => "eBay Turbo Lister Backup File",
    'TRX'          => "PASSOLO Translation List File",
    'TP0'          => "Mascom PVR Video File",
    'T3D'          => "Unreal Engine 3D Object File",
    'TVS'          => "TeamViewer Video Session File",
    'TBL'          => "StarCraft Information Table",
    'TDT'          => "THOR Data Tree File",
    'TCC'          => "TimeCalc Classic Data File",
    'TDM'          => "LabVIEW Binary Measurement File",
    'TOC'          => "World of Warcraft Add-on Table of Contents",
    'TPF'          => "Transit NXT Pack Translation File",
    'TXN'          => "MySpaceIM Conversation Log File",
    'TED'          => "Alamo Map File",
    'TPD'          => "Cyberlink TOD Video File",
    'TEXTCLIPPING' => "Mac OS X Text Clipping File",
    'TC2'          => "TurboCAD 2D Mac Drawing",
    'TC3'          => "TurboCAD 2D/3D Mac Drawing",
    'TCM'          => "TurboCAD Mac Drawing",
    'TLI'          => "Typelib Generated C/C++ Inline File",
    'TLH'          => "Typelib Generated C/C++ Header File",
    'TESTSETTINGS' => "Visual Studio Test Settings File",
    'TESTRUNCONFI' => " 'Visual Studio Test Run Configuration File",
    'TT'           => "Visual Studio Text Template",
    'TS'           => "Qt Translation Source File",
    'TEMPLATE'     => "Apple Pages Template",
    'TRI'          => "FaceGen Polygonal Model File",
    'TTA'          => "True Audio File",
    'TG'           => "TuxGuitar Document",
    'TDE'          => "Tableau Data Extract File",
    'TWBX'         => "Tableau Packaged Workbook",
    'TIG'          => "TI Connect Backup File",
    'TTBK'         => "Canadian TurboTax 2010 Backup File",
    'TOP'          => "TopSolid Design Document",
    'TOPVIW'       => "TopSolid'Viewer Document",
    'TCR'          => "Psion Series 3 eBook File",
    'TMPROJ'       => "TextMate Project File",
    'TEXTFACTORY'  => "BBEdit Text Factory",
    'TMBUNDLE'     => "TextMate Bundle File",
    'TMLANGUAGE'   => "TextMate Language Grammar File",
    'TRN'          => "SQL Server Transaction Log Backup File",
    'TLD'          => "Tag Library Descriptor File",
    'TAK'          => "Tom's Lossless Audio Kompressor File",
    'TL5'          => "Timeliner 5 File",
    'TPF'          => "SPSS Text Wizard Document",
    'TEC'          => "TECkit Compiled Mapping File",
    'T3D'          => "Swift 3D Document",
    'TFM'          => "TeX Font Metric File",
    'TSP'          => "Digital TV DVR Recording",
    'TBP'          => "Tekla BIMsight Project",
    'TRM'          => "FTR Media File",
    'TT11'         => "TurboTax Canada 2011 Tax Return",
    'TAR.LZMA'     => "LZMA Compressed Tarball",
    'TD'           => "Thunder Incomplete Download File",
    'TNE'          => "Manga Studio Tone File",
    'TGF'          => "Trivial Graph Format File",
    'TPS'          => "TexturePacker Sprite Sheet File",
    'TNS'          => "TI-Nspire Document",
    'TNSP'         => "TI-Nspire PublishView Document",
    'TARDIST'      => "TAR Distribution Archive",
    'TFIL'         => "Blizzard Software Update File",
    'TWM'          => "theWord Module",
    'TPF'          => "TexMod Package File",
    'TN'           => "LG Phone Image",
    'TBN'          => "Kodi Thumbnail Image",
    'TTXT'         => "MPEG-4 Timed Text Subtitles File",
    'THP'          => "Wii/GameCube Video File",
    'TIS'          => "True Image Script",
    'TTARCH'       => "Telltale Games Archive",
    'TIE'          => "CrossTie Installer File",
    'TAX2012'      => "TurboTax 2012 Tax Return",
    'TT2012STATE'  => "TurboTax 2012 State Tax Form",
    'TTKGP'        => "TatukGIS Project File",
    'TPX'          => "DeLorme Topo Project File",
    'TPD'          => "TreePad 7 Database File",
    'TSI'          => "Traktor Settings File",
    'TOTALSDB'     => "Totals Database File",
    'TOTALSBACKUP' => "Totals Database Backup File",
    'TOTALSSYNCDB' => "Totals Synchronized Database File",
    'T65'          => "PageMaker Template File",
    'TIGER'        => "Tomb Raider Game Data Archive",
    'THL'          => "Total 3D Home Design File",
    'TWIG'         => "Twig Template",
    'TRK'          => "Finale Track Mapping File",
    'TAR.MD5'      => "Android System File",
    'TGD'          => "Terragen Project File",
    'TT2013STATE'  => "TurboTax 2013 State Tax Form",
    'TVSHOW'       => "mimoLive Show",
    'TVLAYER'      => "mimoLive TV Layer",
    'TREC'         => "TechSmith Recording File",
    'TDL'          => "ToDoList Tasklist File",
    'TAX2014'      => "TurboTax 2014 Tax Return",
    'TAR.BZ2'      => "Compressed Tarball File",
    'TT14'         => "TurboTax Canada 2014 Tax Return",
    'T14'          => "H&R Block 2014 Tax Return",
    'TIBKP'        => "Titanium Backup File",
    'TVM'          => "TV3D Model",
    'TT15'         => "TurboTax Canada 2015 Tax Return",
    'T15'          => "H&R Block 2015 Tax Return",
    'TA4'          => "TaxAct 2014 Tax Return File",
    'TA5'          => "TaxAct 2015 Tax Return File",
    'THING'        => "MakerBot Thing File",
    'TABLECONTENT' => "SMART Table Activity Pack File",
    'TS'           => "TypeScript File",
    'TVC'          => "Turbo View & Convert Batch Presets File",
    'TSR'          => "Tracker Status Report",
    'TPK'          => "Gear Watchface Design Build File",
    'TEXTEXPANDER' => "E'TTINGS  TextExpander Settings File",
    'TEXTEXPANDER' => "TextExpander Settings File",
    'TA6'          => "TaxAct 2016 Tax Return File",
    'TT16'         => "TurboTax Canada 2016 Tax Return",
    'TVTEMPLATE'   => "mimoLive Template",
    'TTMD'         => "Trail Tracker Trail Map",
    'TDMS'         => "Technical Data Management Streaming File",
    'TCX'          => "TestComplete Script Extension Package",
    'TAX17'        => "TurboTax 2017 Tax Return File",
    'TMDX'         => "TextMaker Document",
    'TMB'          => "Timbuktu Pro Connection Document",
    'TAB'          => "Tab Separated Data File",
    'THX'          => "Amiga THX Tracker Music File",
    'TNEF'         => "Transport Neutral Encapsulation Format",
    'TAX'          => "TurboTax Tax Return",
    'TUB'          => "PaintShop Pro Picture Tube",
    'TSP'          => "TrueSpeech Audio File",
    'TAG'          => "DataFlex Data File",
    'TLB'          => "VAX Text Library",
    'TOC'          => "PSP Audio File",
    'TPC'          => "Topic Connection Placeholder",
    'TAO'          => "Track at Once CD/DVD Image",
    'TBZ2'         => "Tar BZip 2 Compressed File",
    'TLZ'          => "Tar LZMA Compressed File",
    'TPS'          => "Multi Channel Measurement File",
    'T$M'          => "AVG Internet Security Temporary File",
    'TCX'          => "TurboCAD 3D Model Text File",
    'TED'          => "Tribes 2 Game Data File",
    'TMW'          => "Translation Memory Data File",
    'THM'          => "Thermwood Macro File",
    'TLA'          => "TuneUp Utilities Startup Logo",
    'TVJ'          => "TrueView Job Ticket",
    'TM'           => "TeXmacs Document",
    'T2'           => "Textease 2000 File",
    'TLZMA'        => "LZMA Compressed Tar Archive",
    'TOC'          => "Brasero Table of Contents File",
    'TAP'          => "Commodore 64 Cassette Tape Image",
    'THEME'        => "GTK Theme Index File",
    'TRUCK'        => "Rigs of Rods Truck Definition File",
    'TRX'          => "Firmware Image File",
    'TRX'          => "WebAuthorize Batch File",
    'TEACHER'      => "SMART Response Teacher Database File",
    'TYPEIT4ME'    => "TypeIt4Me Clippings File",
    'TXZ'          => "XZ Compressed Tar Archive",
    'TAR.XZ'       => "XZ Compressed Tar Archive",
    'TDT'          => "FirstBreak Concrete Test File",
    'TCC'          => "C++ Source Code File",
    'TRK'          => "Pacific Fighters Offline Track File",
    'T3D'          => "TicTacTi Advertisement Definition File",
    'TXF'          => "Transit XV Pack Translation File",
    'TIPROGRAM'    => "TI-Basic Program File",
    'TPI'          => "EDIUS Plugin File",
    'TCP'          => "Tally Compiled Program File",
    'TMD'          => "TextMaker Document",
    'TMD'          => "MySQL Temporary Database File",
    'TST'          => "TagScanner Text Transform Script",
    'TC'           => "Tellico Collection File",
    'TPL'          => "Adobe Photoshop Tool Presets File",
    'T2B'          => "CyBook Thumbnail Image",
    'TLX'          => "Standard Dictionary File",
    'TPL'          => "Canvas Template",
    'TPS'          => "Bryce Tree Shape File",
    'TMR'          => "Apimac Timer Document",
    'TRI'          => "Triangle Mesh File",
    'THEME'        => "Comodo Theme File",
    'TAX10'        => "TurboTax 2010 Tax Return File",
    'TTS'          => "ToolBook Translation System File",
    'TOPPRJ'       => "TopSolid Project File",
    'TCR'          => "TouchMagix Creative Suite Published File",
    'TED'          => "TouchMagix Editable Document Template",
    'TMPROJECT'    => "TextMate Project",
    'TMTHEME'      => "TextMate Theme File",
    'TKR'          => "Tinker Custom Level File",
    'TAK'          => "Music Maker Take File",
    'TLO'          => "SPSS TableLooks File",
    'TXF'          => "Celestia Font Texture File",
    'TS1'          => "VirtualBus Texture Description File",
    'TOP'          => "Gromacs Topology File",
    'TH'           => "Therion Data File",
    'T2K'          => "Teach2000 Document",
    'T2KS'         => "Teach2000 Exam Results File",
    'T2KT'         => "Teach2000 Exam File",
    'TBP'          => "Autodesk Topobase File",
    'TRM'          => "Oracle Trace Map File",
    'TPARK'        => "ThemePark Project File",
    'TMD'          => "PlayStation Game Model File",
    'TAX11'        => "TurboTax 2011 Tax Return File",
    'TAR.GZ2'      => "Misnamed BZ2 Tarball",
    'TSF'          => "Strater Template File",
    'TPKEY'        => "TexturePacker License Key File",
    'TMR'          => "Free Countdown Timer Backup File",
    'TLK'          => "BioWare Aurora Engine Talk Table File",
    'TERMINAL'     => "Terminal Settings File",
    'TFC'          => "Unreal Engine 3 Texture File Cache",
    'TR'           => "TomeRaider 2 eBook File",
    'TWZIP'        => "theWord Compressed Archive Module",
    'TWZ'          => "theWord Compressed Archive Module",
    'TMO'          => "3DCG Animation and Pose File",
    'TRACE'        => "VMware ThinApp Trace Log File",
    'TD6'          => "RollerCoaster Tycoon Track Design File",
    'TX_'          => "Compressed Text File",
    'TMZIP'        => "Theme Manager Zip File",
    'TM2'          => "PlayStation 2 Graphic",
    'TAC'          => "ActiCalc Data File",
    'TMV'          => "TextMaker Template",
    'TTE'          => "Private Character Editor File",
    'TAX12'        => "TurboTax 2012 Tax Return File",
    'TDZ'          => "Drobo Firmware File",
    'TSC'          => "TINA Design File",
    'TOTALSLAYOUT' => "Totals Invoice Layout File",
    'TLP'          => "Tulip Software Graph Format File",
    'TRS'          => "Linear Saw Component Information Archive",
    'TRX_DLL'      => "Windows Startup File",
    'TYSET'        => "Typinator Set File",
    'TAB'          => "Typinator Set File",
    'TMPL'         => "BlueJ Default Template",
    'TIMER'        => "Systemd Unit Configuration File",
    'TMVT'         => "TimeMap Template",
    'TBD'          => "Visual Studio Toolbox Data File",
    'TDT'          => "Sim Tower Game File",
    'TDT'          => "AVCHD Thumbnail File",
    'TID'          => "AVCHD Thumbnail File",
    'TER'          => "Terragen Terrain File",
    'TGO'          => "Terragen Object File",
    'TGC'          => "Terragen Node Clip File",
    'TPL'          => "Wii Image File",
    'TAX13'        => "TurboTax 2013 Tax Return File",
    'TRELBY'       => "Trelby File",
    'TTL'          => "AGT Game Title File",
    'TVRECORDING'  => "BoinxTV TV recording",
    'TRC'          => "SQL Server Trace File",
    'TCLS'         => "TestComplete Configuration File",
    'TCLOGS'       => "TestComplete Log Configuration File",
    'TCCFGEXTENDE' => " 'TestComplete Project Suite Settings File",
    'THEATER'      => "iMovie Theater File",
    'TT2014STATE'  => "TurboTax 2014 State Tax Form",
    'TSR'          => "TIFF Simple Rare File",
    'TERRN'        => "Rigs of Rods Terrain File",
    'TERRN2'       => "Rigs of Rods Terrain 2 File",
    'TAR.LZ'       => "Lzip Compressed Tarball",
    'TSL'          => "Tracker Status Log",
    'TARGA'        => "Targa Graphic",
    'TAR.Z'        => "Zipped Tarball File",
    'TAX16'        => "TurboTax 2016 Tax Return File",
    'TAX15'        => "TurboTax 2015 Tax Return File",
    'TT2015STATE'  => "TurboTax 2015 State Tax Form",
    'TT2016STATE'  => "TurboTax 2016 State Tax Form",
    'TTSKEY'       => "Tech Tool Store License File",
    'TMOD'         => "Terraria Mod File",
    'TRF'          => "TorrentRover File",
    'TGP'          => "Terragen Plugin",
    'TEE'          => "TeeChart Template",
    'TIM'          => "Vixen Timed Sequence File",
    'TPL'          => "Phorum Template",
    'TPL'          => "HTTP File Server Template",
    'TEXTURE'      => "Diesel Engine Game Texture File",
    'TFX'          => "Pro Tools Eleven Rack Plugin Preset File",
    'THUMBDATA3-1' => "6'7290299 Thumbnail Index File",
    'THUMBDATA3-1' => "6'3508120 Thumbnail Index File",
    'TQS'          => "Trivia Quiz Shell Program File",
    'TTD'          => "Tinytag Explorer Data File",
    'TT2017STATE'  => "TurboTax 2017 State Tax Form",
    'TMVX'         => "TextMaker Document Template",
    'TRF'          => "Smaart Transfer Function File",
    'TSK'          => "Top Silkscreen File",
    'TIMELINE'     => "Timeline Data File",
    'TRASHES'      => "macOS USB Flash Drive Trash Folder",
    'TBD'          => "Apple Xcode Text-based Definition File",
    'TS4SCRIPT'    => "The Sims 4 Script Archive",
    'TBX'          => "ArcGIS for Desktop Toolbox File",
    'TSV'          => "Digital Receiver Video Recording File",
    'TBX'          => "TermBase eXchange File",
    'TZARC'        => "Trainz Archive",
    'TIAPP'        => "TiTanium App",
    'TDDD'         => "3D Data Description File",
    'TRIF'         => "Tiled Raster Interchange Format",
    'T01'          => "TaxCut 2001 File",
    'T02'          => "TaxCut 2002 File",
    'T03'          => "TaxCut 2003 File",
    'T04'          => "TaxCut 2004 File",
    'THP'          => "TurboTax Text String",
    'TVL'          => "TurboTax File",
    'TOL'          => "AOL Tool File",
    'TN1'          => "Tiny Low Resolution Image",
    'TN2'          => "Tiny Medium Resolution Image",
    'TN3'          => "Tiny High Resolution Image",
    'TNY'          => "Atari Tiny Image",
    'TAAC'         => "Sun TAAC Image File",
    'TMS'          => "Telemate Script",
    'TFMX'         => "Final Music System Tracker Module",
    'T3X'          => "TYPO3 Compressed Extension",
    'TPX'          => "Turbo Pascal 7 Unit",
    'TG'           => "Gzip Compressed Tar Archive",
    'TAP'          => "Tap Tap Revenge Tap File",
    'TP3'          => "Harvard Graphics DOS Template File",
    'TRK'          => "Garmin Track File",
    'TPI'          => "TrueVision Bitmap Image",
    'TAF'          => "ADRIFT Text Adventure File",
    'TAX09'        => "TurboTax 2009 Tax Return File",
    'TAX08'        => "TurboTax 2008 Tax Return File",
    'TB0'          => "Adobe Photoshop Thumbnail Cache File",
    'TMPL'         => "Xfire User Interface Template",
    'TME'          => "Bryce Time File",
    'TKO'          => "Win32/Oficla Trojan File",
    'TKO'          => "AMX Software Module File",
    'TJA'          => "Taikojiro Song Map File",
    'TAK'          => "TAK 2000 Thermal Model File",
    'TDX'          => "D-TEG CCTV Video Information File",
    'TJC'          => "Taikojiro Song Map Sequence File",
    'TUT'          => "Children of the Nile Tutorial File",
    'THA'          => "Windows Thai Noise-Words List File",
    'TUN'          => "LEGO Racers Audio File",
    'TRAY'         => "Corel CONNECT Tray File",
    'TTM'          => "Tower Toppler Mission File",
    'TD4'          => "RollerCoaster Tycoon Track File",
    'TP4'          => "RollerCoaster Tycoon Track Picture File",
    'TDB'          => "Transcendence Game Data File",
    'TM8'          => "Theta Music Composer 1.x Audio File",
    'TMC'          => "Theta Music Composer 1.x Audio File",
    'TM2'          => "Theta Music Composer 2.x Audio File",
    'TFR'          => "TIE Fighter Pilot File",
    'TIME'         => "LIGHT File",
    'TPL'          => "TatukGIS Editor Print Template File",
    'TEX0'         => "Wii Texture File",
    'TLL'          => "LG TV Link-Loader File",
    'TSC'          => "Cave Story Script",
    'TXTRPT'       => "CommScope Teletilt Control System Report",
    'TYIMPORT'     => "Typinator Set Import File",
    'TCZ'          => "Tiny Core File",
    'TMP'          => "Finale Temporary File",
    'TGW'          => "Terragen World File",
    'TVC'          => "TeamViewer Configuration File",
    'TCNET'        => "TestComplete Configuration Reference File",
    'TVDOWNLOAD'   => "TeamViewer Download File",
    'TSK'          => "TTPod Skin",
    'TIMESTAMP'    => "Geodatabase Timestamp File",
    'TA'           => "Sony Firmware File",
    'TRIM.3DS'     => "Trimmed 3DS ROM",
    'TRIM.CIA'     => "Trimmed CTR Importable Archive",
    'UUE'          => "Uuencoded File",
    'U3D'          => "Universal 3D File",
    'UCCAPILOG'    => "Microsoft UCC API Log File",
    'UCF'          => "WebEx Media File",
    'UWL'          => "User Word List File",
    'UNITY'        => "Unity Scene File",
    'UNITY3D'      => "Unity Web Player File",
    'UPK'          => "Unreal Engine 3 Package",
    'UTZ'          => "UIQ Theme Package",
    'UDK'          => "Unreal Engine Map File",
    'U10'          => "UFile 2010 Tax Return",
    'USR'          => "SmartMusic Custom File",
    'UNF'          => "UNIF ROM File",
    'UU'           => "Uuencoded File",
    'URL'          => "Internet Shortcut",
    'UNX'          => "Unix Text File",
    'UTF8'         => "Unicode UTF8-Encoded Text Document",
    'USX'          => "Unreal Static Meshes",
    'UT2'          => "Unreal Tournament Map",
    'UTX'          => "Unreal Texture Package",
    'UAX'          => "Unreal Audio Package",
    'UMX'          => "Unreal Music Package",
    'UNR'          => "Unreal Level Map",
    'UXX'          => "Unreal Tournament Cache",
    'U'            => "Unreal Tournament Class Package",
    'UC'           => "UnrealScript Class",
    'UVF'          => "Uncertain Value Format",
    'UHA'          => "UHarc Compressed Archive",
    'UIF'          => "Universal Image Format Disc Image",
    'UTXT'         => "Unicode Text File",
    'UW'           => "Unsigned Word Audio File",
    'ULT'          => "UltraTracker Module",
    'UNI'          => "MikMod UniMOD Module",
    'UWF'          => "UltraTracker Wave File",
    'UNAUTH'       => "SiteMinder Unauthorized Message File",
    'U'            => "AU Audio File",
    'USF'          => "Nintendo 64 Music File",
    'USFLIB'       => "Nintendo 64 Song Library",
    'U3P'          => "U3 Smart Application",
    'UI'           => "User Interface File",
    'ULZ'          => "USBlyzer Data Capture File",
    'ULF'          => "Universal List File",
    'ULS'          => "NetMeeting User Location Service File",
    'UCI'          => "UFS Explorer Backup File",
    'U3I'          => "U3 Application Information File",
    'UTC'          => "Bioware Creature File",
    'UDB'          => "Dynamics AX User Database File",
    'UIBAK'        => "UltraISO Backup Disk Image",
    'USA'          => "Unreal Saved Game File",
    'UIS'          => "WindowBlinds User Interface Specification",
    'UMOD'         => "Unreal Tournament Module File",
    'UT2MOD'       => "Unreal Tournament 2003/2004 Module File",
    'UT3'          => "Unreal Tournament 3 Map File",
    'UKX'          => "Unreal Animation Package",
    'UVX'          => "Unreal Tournament 2003 Saved Game",
    'UPOI'         => "iGO Points of Interest File",
    'UNKNOWN'      => "Unknown File Type",
    'UT4MOD'       => "Unreal Tournament 2004 Module",
    'USR'          => "FileMaker Pro Database File",
    'USERPROFILE'  => "Norton AntiVirus User Profile File",
    'UDCX'         => "Universal Data Connection File",
    'UNITYPACKAGE' => "Unity Package File",
    'UDL'          => "Microsoft Universal Data Link File",
    'UDC'          => "Adobe InDesign User Dictionary",
    'UML'          => "UML Data Object Model",
    'UCT'          => "UC Browser Theme File",
    'UFR'          => "Ultra Fractal File",
    'UPR'          => "Fractal Parameters File",
    'UBOX'         => "Universe Sandbox Data File",
    'USM'          => "USM Game Video File",
    'UOT'          => "Uniform Office Document",
    'UOP'          => "Uniform Office Presentation",
    'UOS'          => "Uniform Office Spreadsheet",
    'UPG'          => "Upgrade File",
    'USEQ'         => "USeq Genome Data File",
    'USF'          => "Universal Subtitles Format File",
    'U11'          => "UFile 2011 Tax Return",
    'U12'          => "UFile 2012 Tax Return",
    'UST'          => "UTAU Sequence Text File",
    'UVW'          => "UVW Coordinates File",
    'UMD'          => "Splinter Cell Blacklist Game Data File",
    'UNITYPROJ'    => "Unity 3D Project",
    'ULP'          => "EAGLE User Language Program",
    'UWRF'         => "Universal Web Radio File",
    'UPS'          => "UPS Patch File",
    'UASSET'       => "Unreal Asset File",
    'U8'           => "Mario Kart Wii Archive",
    'UFO'          => "Unified Font Object File",
    'UB'           => "Unsigned Byte Audio File",
    'UUD'          => "UUDecoded File",
    'UFO'          => "Ulead File Object",
    'ULAW'         => "Raw u-Law Audio File",
    'UOP'          => "Ultima Online Patch File",
    'UD'           => "OmniPage User Dictionary",
    'UDEB'         => "Debian Package File",
    'UDS'          => "Sierra Generations File",
    'UPDATE'       => "ISAPI Update File",
    'UPX'          => "Ultimate Packer for eXecutables File",
    'UZIP'         => "FreeBSD Compressed Disk Image",
    'UFS.UZIP'     => "Compressed Unix File System File",
    'UNL'          => "Garmin Unlock File",
    'UTW'          => "Unity Whirld File",
    'USER'         => "Visual Studio Project User Options File",
    'UDF'          => "Universal Disk Format File",
    'UNT'          => "AutoCAD Unit Definition File",
    'UPR'          => "FileMaker User Dictionary",
    'UMLCLASS'     => "UML Class Model",
    'UMF'          => "MediaHolder Universal Media Format File",
    'UHTML'        => "UC Browser Saved Webpage",
    'UPF'          => "MicroStation User Preferences File",
    'UPF'          => "Unified Power Format File",
    'UBJ'          => "Universal Binary JSON File",
    'UOF'          => "Uniform Office Document",
    'USF'          => "EVGA Precision X Skin File",
    'UCL'          => "Killing Floor System File",
    'UEA'          => "Protector Suite QL Encrypted Archive",
    'UCE'          => "Windows UCE System File",
    'UGA'          => "Ulead GIF Animator File",
    'ULX'          => "Glulx Game File",
    'ULD'          => "Unified Luminaire Data File",
    'UGR'          => "Apophysis Ultra Fractal Gradient File",
    'UNIF'         => "UNIF ROM File",
    'UGOIRA'       => "Ugoira Animated Image File",
    'UFT'          => "Torque Font Cache File",
    'UMAP'         => "Unreal Engine Map File",
    'USR'          => "Lowrance GPS Data File",
    'UPF'          => "Panono Unstitched Panorama Format",
    'UXF'          => "UML eXchange Format",
    'UPD'          => "Program Update Information",
    'U'            => "Subsampled Raw YUV Image",
    'UC2'          => "UltraCompressor 2 Archive",
    'URT'          => "Utah Raster Toolkit File",
    'ULW'          => "u-Law Audio File",
    'UDF'          => "Excel User Defined Function",
    'UDS'          => "Uniform Data System File",
    'UNK'          => "Unknown File",
    'UFS'          => "FreeBSD Unix File System File",
    'URR'          => "Uniface Signatures File",
    'USTAR'        => "Uniform Standard Tape Archive Format File",
    'UPDATR'       => "iConomy Update File",
    'UQM'          => "The Ur-Quan Masters Game Data File",
    'UDS'          => "NetBackup UNIX Domain Socket File",
    'UCM'          => "Crazy Machines Model File",
    'USERTILE-MS'  => "Windows 8 User Tile File",
    'U8'           => "3D Lemmings Audio File",
    'UMS'          => "Rune 3D Mesh File",
    'UT8'          => "Ghost Master Language File",
    'VB'           => "Visual Basic Project Item File",
    'VCD'          => "Virtual CD",
    'VOB'          => "DVD Video Object File",
    'VCF'          => "vCard File",
    'VCXPROJ'      => "Visual C++ Project",
    'VSD'          => "Visio Drawing File",
    'VBS'          => "VBScript File",
    'VRO'          => "DVD Video Recording Format",
    'VTF'          => "Valve Texture File",
    'VUE'          => "Vue Scene File",
    'VCPROJ'       => "Visual C++ Project File",
    'VDPROJ'       => "Visual Studio Setup and Deployment Project",
    'VMX'          => "VMware Configuration File",
    'VF'           => "VEGAS Movie Studio Project File",
    'VHD'          => "Virtual PC Virtual Hard Disk",
    'VEG'          => "VEGAS Video Project",
    'VST'          => "VST Audio Plugin",
    'VMDK'         => "Virtual Machine Disk File",
    'VWX'          => "Vectorworks Design File",
    'VDI'          => "VirtualBox Virtual Disk Image",
    'VDX'          => "Visio Drawing XML File",
    'VBPROJ'       => "Visual Studio Visual Basic Project",
    'VXML'         => "VoiceXML File",
    'VBT'          => "Spyware Doctor Temporary Scan File",
    'VDB'          => "Symantec Virus Database File",
    'V'            => "Verilog Source Code File",
    'VTM'          => "Visual Tool Markup Language Document",
    'VMC'          => "Windows Virtual Machine Configuration File",
    'VBOX'         => "Oracle VM VirtualBox Settings File",
    'VBOX-EXTPACK' => "Oracle VM VirtualBox Extension Pack",
    'VPK'          => "Valve Pak",
    'VDF'          => "AntiVir Virus Definitions File",
    'VSDX'         => "Visio Drawing",
    'VXD'          => "Virtual Device Driver",
    'VRML'         => "VRML File",
    'VOC'          => "Creative Labs Audio File",
    'VBX'          => "Visual Basic Custom Control",
    'VC4'          => "Virtual CD Disc Image",
    'VBP'          => "Visual Basic Project File",
    'VBE'          => "VBScript Encoded Script File",
    'VSS'          => "Visio Stencil File",
    'VIEWLET'      => "Qarbon Viewlet",
    'VOX'          => "Dialogic Voice Audio File",
    'VPC7'         => "Virtual Machine Package",
    'VBSCRIPT'     => "Visual Basic Script",
    'VCT'          => "Visual Class Library Memo",
    'VRF'          => "Ventrilo Audio Recording",
    'VIR'          => "Virus-Infected File",
    'VMX'          => "Cubase Mixer Settings File",
    'VCD'          => "FarStone Virtual Drive",
    'VAPORCD'      => "Norum Vapor CD",
    'VDI'          => "Virtuo CD Manager Disk Image",
    'VMD'          => "Covox Raw Sample",
    'VOL'          => "Video Game Archive",
    'VOL'          => "Volfs File System Directory",
    'VDM'          => "VDM Specification File",
    'VDO'          => "VDOLive Media File",
    'VDO'          => "Heathen Virus File",
    'VBG'          => "Visual Basic Project Group File",
    'VST'          => "Visio Drawing Template",
    'VBZ'          => "Visual Basic Project Template",
    'VQF'          => "TwinVQ Audio File",
    'VMTM'         => "VMware Team Data File",
    'V64'          => "Nintendo 64 ROM Dump",
    'VOR'          => "StarOffice Template",
    'VAG'          => "PlayStation Compressed Sound File",
    'VSI'          => "Visual Studio Content Installer File",
    'VSCONTENT'    => "Visual Studio Content File",
    'V2I'          => "Norton Ghost Virtual Volume Image",
    'VDF'          => "VirtualDub Video Filter",
    'V3D'          => "Visual3D.NET Data File",
    'VP6'          => "TrueMotion VP6 Video File",
    'VP7'          => "TrueMotion VP7 Video File",
    'VMF'          => "Valve Map File",
    'VCM'          => "Vice City Mod Manager File",
    'VSDISCO'      => "DISCO Dynamic Discovery Document",
    'VOK'          => "PocketVok Vocabulary File",
    'VPA'          => "VPchat Chat Gestures File",
    'VGC'          => "ViziGen Code Generation Template",
    'VYF'          => "Samsung Digital Voice Recorder File",
    'VHD'          => "VHDL Source File",
    'VC3'          => "VSampler Soundbank File",
    'VB'           => "Virtual Boy ROM File",
    'VC'           => "Verge Code File",
    'VCD'          => "Value Change Dump File",
    'VLAB'         => "VisionLab Studio Project File",
    'VI'           => "LabVIEW Virtual Instrument File",
    'VFS'          => "Virtual File System Index",
    'VCE'          => "Visual CertExam Exam File",
    'VRD'          => "Visio Report Definition File",
    'VSX'          => "Visio Stencil XML File",
    'VTX'          => "Visio Template XML File",
    'VTX'          => "Anim8or 3D Model",
    'VVD'          => "Vivid 3D Scanner Element File",
    'VMG'          => "Nokia Text Message",
    'VMT'          => "Valve Material File",
    'VSSSCC'       => "Visual Studio Solution Source Control File",
    'VSPSCC'       => "Visual Studio Project Source Control File",
    'VNC'          => "VNC Configuration File",
    'VPL'          => "Karaoke Player Playlist",
    'VMWAREVM'     => "VMware Fusion Virtual Machine",
    'VCS'          => "vCalendar Event File",
    'VBD'          => "Visual Basic ActiveX Document",
    'VGZ'          => "DigitalVDO Compressed Video File",
    'VLX'          => "Compiled AutoLISP File",
    'VC1'          => "VC-1 Video File",
    'VEM'          => "Virtual Expander Compressed File",
    'VTF'          => "3DESIGN CAD File",
    'VBPF1'        => "Virtual Business - Personal Finance Data File",
    'VCV'          => "ViewCave Video File",
    'VCPREF'       => "Norton Antivirus Preferences File",
    'VOB'          => "Live for Speed Car File",
    'VPM'          => "Garmin Voice File",
    'VFZ'          => "Creative Webcam Video Effects File",
    'VDR'          => "VirtualDub Signpost File",
    'VBT'          => "iAntiVirus Temporary Scan File",
    'VML'          => "Vector Markup Language File",
    'VSP'          => "VideoStudio Project File",
    'VBR'          => "GIMP Parametric Brush File",
    'VSPROPS'      => "Visual Studio Project Property File",
    'VDP'          => "Visual Studio Deployment Project",
    'VCP'          => "eMbedded Visual C++ Project File",
    'VSMACROS'     => "Visual Studio Binary Macro Project",
    'VSMPROJ'      => "Visual Studio Text Macro Project",
    'VSMDI'        => "Visual Studio Test Metadata File",
    'VSSETTINGS'   => "Visual Studio Settings File",
    'VLT'          => "VLC Media Player Skin File",
    'VP'           => "Ventura Publication File",
    'VTML'         => "Visual Tool Markup Language File",
    'VTV'          => "Adobe Dreamweaver Validator Configuration File",
    'VPJ'          => "VideoPad Video Editor Project File",
    'VOB'          => "Vue Objects File",
    'VEG'          => "Vue Vegetation file",
    'VCPF'         => "VideoConvert Project File",
    'V'            => "Coq Source Code File",
    'VAP'          => "Dialogic Indexed Voice Audio File",
    'VPX'          => "Avast! Virus Update File",
    'VMCX'         => "Virtual Machine Shell Information File",
    'VSV'          => "Virtual Machine Saved State File",
    'VUD'          => "Virtual Machine Undo Drive File",
    'VBW'          => "Visual Basic Workspace File",
    'VOI'          => "VOI Group File",
    'VBOX-PREV'    => "Oracle VM VirtualBox Settings Backup File",
    'VM'           => "Velocity Template",
    'VSH'          => "Vertex Shader File",
    'VCT'          => "IDRISI Vector Image",
    'VDC'          => "IDRISI Vector Documentation File",
    'VIMRC'        => "Vim Runtime Configuration File",
    'VIM'          => "Vim Settings File",
    'VP'           => "Vertex Program File",
    'VPP'          => "Visual Paradigm Project File",
    'VIS'          => "Visual Importer Script",
    'VNCLOC'       => "Screen Sharing VNC Internet Location",
    'VFD'          => "Virtual Floppy Disk",
    'VMXF'         => "VMware Team Member File",
    'VMSN'         => "VMware Snapshot State File",
    'VMSS'         => "VMware Suspended State File",
    'VSIX'         => "Visual Studio Extension",
    'VHDX'         => "Windows 8 Virtual Hard Drive File",
    'VSP'          => "Visual Studio Performance Report File",
    'VSPS'         => "Visual Studio Serialized Performance Report",
    'VSPX'         => "Visual Studio Performance Report Data File",
    'VBHTML'       => "ASP.NET Razor Web Page",
    'VEP'          => "AVS Video Editor Project File",
    'VOXB'         => "Voxler Network File",
    'VCX'          => "Virtual Disc Definition File",
    'VPS'          => "Virtual CD Copy Template",
    'VQC'          => "Virtual CD Quick Copy File",
    'VCO'          => "Virtual CD Collection File",
    'VLC'          => "VLC Playlist",
    'VMO'          => "Siemens Voice Memo File",
    'VPD'          => "MikuMikuDance Vocaloid Pose Data File",
    'VSQ'          => "VOCALOID2 Project File",
    'VBK'          => "VitalSource eBook",
    'VDF'          => "Valve Data File",
    'VMV'          => "VirtuaNES Recording",
    'VMV'          => "VisualBoyAdvance Recording",
    'VCD'          => "Valve Choreography Data File",
    'VOXAL'        => "Voxal Project File",
    'VSZ'          => "Visual Studio Wizard File",
    'VDW'          => "Visio Web Drawing",
    'VSDM'         => "Visio Macro-Enabled Drawing",
    'VSTX'         => "Visio Drawing Template",
    'VSSX'         => "Visio Stencil File",
    'VSTM'         => "Visio Macro-Enabled Drawing Template",
    'VSSM'         => "Visio Macro-Enabled Stencil File",
    'VSL'          => "Visio Add-on",
    'VBK'          => "Veeam Backup File",
    'VRB'          => "Veeam Incremental Backup File",
    'VFB'          => "FontLab Studio Font File",
    'VRPHOTO'      => "VR Photo Image",
    'VPE'          => "Photoshop Vanishing Point Export File",
    'VPC6'         => "Virtual Machine Package",
    'VSO'          => "Compiled Vertex Shader File",
    'VPW'          => "VoxPro Wave File",
    'VBC'          => "VodBurner Crude Video File",
    'VSTPRESET'    => "VST Preset File",
    'VRIMG'        => "V-Ray Image File",
    'VSQX'         => "VOCALOID3 Project File",
    'V11.SUO'      => "Visual Studio 2012 Solution User Options File",
    'V12.SUO'      => "Visual Studio 2013 Solution User Options File",
    'VIIVO'        => "Viivo Encrypted File",
    'VTT'          => "Web Video Text Tracks File",
    'VFS0'         => "Metro 2033 Sound File",
    'VIP'          => "MAGIX Samplitude Music Studio Project",
    'VCOMPS'       => "V-Comp Setup File",
    'VSHOST.EXE'   => "Visual Studio Hosting Process File",
    'VOCA'         => "PhotoVOCA Communication Board File",
    'VR'           => "VR Studio Project File",
    'VJSPROJ'      => "Visual Studio J# Project",
    'VJP'          => "Visual Studio J++ Project",
    'VIP'          => "Virtual Instrument Package",
    'VTPR'         => "Studio Store Visualizer Project",
    'VGA'          => "VGA Display Driver",
    'VGD'          => "Generic CADD VGA Driver",
    'VID'          => "Generic Video File",
    'VDA'          => "Targa Bitmap Image File",
    'VST'          => "Targa Bitmap Image",
    'VSW'          => "Visio Workspace File",
    'VC4'          => "Visual C++ 4 File",
    'VCX'          => "Visual Fox Pro Class Library",
    'VAR'          => "Variable Data",
    'VIC'          => "VICAR Image",
    'VIFF'         => "Visualization Image File Format",
    'VMF'          => "Vocaltec Media File",
    'VFW'          => "Video for Windows",
    'VUE'          => "FoxPro 2.x View Settings",
    'VPH'          => "VirtualPhotographer Custom Settings",
    'VMF'          => "Covox Speech Thing Sample",
    'VLT'          => "WinVault File Archive",
    'VNT'          => "Mobile Phone vNote File",
    'VIC'          => "ViziGen Code Import Mappings File",
    'VPC'          => "ViziGen Configuration File",
    'VAL'          => "Valodas Dictionary File",
    'VND'          => "Type3 Design File",
    'VDF'          => "Gothic Game Data File",
    'VEM'          => "Meta Media Video E-Mail File",
    'VNF'          => "Vision Numeric Font",
    'VCR'          => "ATI Video Card Recording",
    'VIP'          => "Stitch Pattern File",
    'VPM'          => "Vox Proxy Macro File",
    'VDM'          => "VEDIT Macro File",
    'VEXE'         => "Virus Executable File",
    'VMX'          => "Valve Map Backup File",
    'VCW'          => "eMbedded Visual C++ Workspace File",
    'V3O'          => "Emergency 3 and 4 Model File",
    'VP'           => "Verilog Encrypted Source Code File",
    'VP'           => "Volition Package File",
    'VMF_AUTOSAVE' => "Valve Hammer Editor Autosave File",
    'VMD'          => "Vocaloid Motion Data File",
    'VGM'          => "Video Game Music File",
    'VGZ'          => "Video Game Music Compressed File",
    'VTX'          => "VTX Chiptune File",
    'VSE'          => "AVTECH CCTV Video",
    'VS4'          => "AVTECH CCTV Video Surveillance File",
    'VPCBACKUP'    => "Windows Virtual PC Backup File",
    'VCT'          => "VISE Installer Project",
    'VSL'          => "Velocity Template File",
    'VB'           => "Grand Theft Auto Audio File",
    'VS'           => "Vertex Shader File",
    'VET'          => "Lectra Cutter's Must File",
    'VFT'          => "VideoStudio Filter File",
    'VIDEO'        => "aTube Catcher Video File",
    'VBX6SETTINGS' => "VirusBarrier X6 Settings File",
    'VOLARCHIVE'   => "CopyCatX Volume Archive",
    'VAC'          => "MikuMikuDance Accessory Settings File",
    'VDJ'          => "VirtualDJ Audio Sample File",
    'VX_'          => "Compressed Virtual Device Driver File",
    'VMSD'         => "VMware Snapshot Metadata File",
    'VMHF'         => "VMware Hot Fix File",
    'VMHR'         => "VMware Hot Fix Request File",
    'VOX'          => "Voxlap Voxel Model File",
    'VSPF'         => "Visual Studio Performance Filter File",
    'VIV'          => "Need for Speed Car Archive",
    'VMO'          => "Virtools Media Object File",
    'V2M'          => "V2 Synthesizer Audio File",
    'VLW'          => "Processing Font File",
    'VMPL'         => "VMware Policy File",
    'VSCT'         => "Visual Studio Command Table",
    'VEC'          => "CX-Designer Shape File",
    'VYM'          => "VYM Mind Map File",
    'VS'           => "GreekToMe Verse List File",
    'VBM'          => "Veeam Backup Metadata File",
    'VVVVVV'       => "VVVVVV Game Level File",
    'VMDK-CONVERT' => "M'P   VMWare Fusion Temporary File",
    'VSCH'         => "Windows Vault Schema File",
    'VPOL'         => "Windows Vault Policy File",
    'VCRD'         => "Windows Vault Credentials File",
    'VEGASWINDOWL' => "Y'OUT MAGIX VEGAS Window Layout File",
    'VALA'         => "Vala Source Code File",
    'VDATA'        => "Vaulty Vault File",
    'VSIXMANIFEST' => "VSIX Manifest",
    'VPD'          => "VoxPro Database File",
    'VIX'          => "Lightworks Video Index File",
    'VWP'          => "Vehicle Weapon File",
    'VEH'          => "Vehicle File",
    'VXP'          => "Mobile Application File",
    'VCE'          => "Yamaha Voice File",
    'VMLT'         => "VAIO Video File",
    'VMLF'         => "VAIO Video File",
    'VICAR'        => "VICAR Image File",
    'VISUAL_PROCE' => "S'ED  World of Tanks 3D Model Surface File",
    'VHDL'         => "VHDL Source File",
    'VVV'          => "Virtual Volumes View Catalog",
    'VWL'          => "Vuforia Word List",
    'VOC'          => "RCA Voice Recorder File",
    'VERT'         => "Vertex Shader File",
    'VZM'          => "Verizon Message File",
    'VMDL'         => "Valve Source 2 Model File",
    'VMAP'         => "Valve Source 2 Uncompiled Map File",
    'VMAP_C'       => "Valve Source 2 Compiled Map File",
    'VDB'          => "OpenVDB Volume Database File",
    'VFS'          => "Animated Slide File",
    'V3V'          => "Vector Art 3D Model File",
    'VEC'          => "Vectrex Game ROM File",
    'VPP'          => "VisionPro Job File",
    'VX2'          => "Space Engineers Voxel Object Data File",
    'VIBE'         => "VibePlayer Haptic File",
    'VCXITEMS'     => "VC++ Project Items File",
    'VOI'          => "Voyetra Voice File",
    'VAL'          => "Values List",
    'V'            => "Subsampled Raw YUV Image",
    'VIS'          => "Visibility Image File",
    'VER'          => "Version Record",
    'VFF'          => "Sun TAAC Graphic File",
    'VAC'          => "Oc2.316s Cakit File",
    'VIV'          => "VivoActive Video File",
    'VIVO'         => "VivoActive Video File",
    'VS'           => "Vivid Include File",
    'VAL'          => "Olympus Voice Recording",
    'VNA'          => "JVC JLIP Image",
    'VRL'          => "VRML Virtual World",
    'VIV'          => "PlayStation Video File",
    'VLP'          => "LiveSite Project",
    'VFC'          => "VentaFax Cover Page File",
    'VLG'          => "VentaFax Logbook File",
    'VFS'          => "VentaFax Schedule File",
    'VW'           => "Volkswriter Text File",
    'VP3'          => "On2 Streaming Video File",
    'VLE'          => "Virtual Labs Electricity Circuit File",
    'V12'          => "All The Right Type Database File",
    'VVF'          => "Voc Vocabulary File",
    'VNI'          => "Dell Webcam Central Application Configuration",
    'VDI'          => "StepMania Debug Resource File",
    'VBF'          => "City Interactive Game Data File",
    'VAULT'        => "Fontcase Vault File",
    'VLCL'         => "VMware Localization File",
    'VMSG'         => "VMware Application Message File",
    'VGI'          => "Vista Game Explorer Editor Game File",
    'VC6'          => "Virtual CD 6 CD Image",
    'VC8'          => "Virtual CD 8 Disc Image",
    'VDJSEND'      => "VirtualDJ Send File",
    'VHV'          => "Valve Source Lighting File",
    'VDX'          => "The 7th Guest Video File",
    'VMAC'         => "VMware Configuration File",
    'VMBA'         => "VMware Configuration File",
    'VMT'          => "VMware Configuration File",
    'VEC'          => "IDRISI Vector File",
    'VEC'          => "Orbiter Vector Map File",
    'VRT'          => "Virtual World",
    'VISUAL'       => "World of Tanks 3D Model Surface File",
    'V264'         => "v264 IPROBOT3 Video File",
    'WAV'          => "WAVE Audio File",
    'WMA'          => "Windows Media Audio File",
    'WMV'          => "Windows Media Video File",
    'WPD'          => "WordPerfect Document",
    'WPS'          => "Microsoft Works Word Processor Document",
    'WSF'          => "Windows Script File",
    'WPT'          => "WordPerfect Template",
    'WKS'          => "Works Spreadsheet",
    'WS'           => "Windows Script",
    'WAB'          => "Windows Address Book",
    'WML'          => "Wireless Markup Language File",
    'WDGT'         => "Dashboard Widget",
    'WEBARCHIVE'   => "Safari Web Archive",
    'WAR'          => "Java Web Archive",
    'WAD'          => "Doom WAD File",
    'W3M'          => "Warcraft 3 Map File",
    'W3X'          => "Warcraft 3 Expansion Map FIle",
    'WZ'           => "MapleStory Game Data File",
    'WSDL'         => "Web Services Description Language File",
    'WPS'          => "Kingsoft Writer Document",
    'WGT'          => "Opera Widget File",
    'WINDOWSLIVEC' => "N'TACT Windows Live Contacts File",
    'WIZ'          => "Microsoft Wizard File",
    'WBZ'          => "Webshots Download Picture File",
    'WBC'          => "Webshots Collection File",
    'WFC'          => "Windows Wireless Network Settings File",
    'WB3'          => "Corel Quattro Pro 7 and 8 File",
    'WTV'          => "Windows Recorded TV Show File",
    'W3N'          => "Warcraft 3 Expansion Campaign Map File",
    'WLMP'         => "Windows Live Movie Maker Project File",
    'WDF'          => "Workshare Compare DeltaFile",
    'WWF'          => "World Wide Fund Non-Printable Document",
    'WCX'          => "RemoteApp and Desktop Connections Configuration",
    'WEBM'         => "WebM Video File",
    'WOFF'         => "Web Open Font Format File",
    'WLX'          => "Windows Live Mesh Sync File",
    'WIXPROJ'      => "WiX Project File",
    'WTT'          => "Write! Document",
    'WB2'          => "Webshots Picture File",
    'WOFF2'        => "Web Open Font Format 2.0 File",
    'WMF'          => "Windows Metafile",
    'WPM'          => "WordPerfect Macro File",
    'WPG'          => "WordPerfect Graphic File",
    'WORKFLOW'     => "Automator Workflow",
    'WAVE'         => "WAVE Sound File",
    'WDB'          => "Microsoft Works Database",
    'WSC'          => "Windows Script Component",
    'WSH'          => "Windows Script Host Settings",
    'WEB'          => "Xara Web Document",
    'WBK'          => "Word Document Backup",
    'WRK'          => "Cakewalk Music Project",
    'WAX'          => "Windows Media Audio Redirect",
    'WMZ'          => "Compressed Windows Media Player Skin",
    'WPL'          => "Windows Media Player Playlist",
    'WMX'          => "Windows Media Redirector File",
    'WMD'          => "Windows Media Download Package",
    'WMS'          => "Windows Media Skin",
    'WVX'          => "Windows Media Video Redirector",
    'WRF'          => "WebEx Recording",
    'WNK'          => "Wink Presentation",
    'WEBLOC'       => "Mac OS X Website Location",
    'WDGT'         => "Opera Widget",
    'WGT'          => "XNBC Synaptic Weights File",
    'WGT'          => "IMPS Data File",
    'WUS'          => "WUTG Tagged Audio File",
    'WUT'          => "WUTG Tag File",
    'WAL'          => "Quake 2 Texture File",
    'WAL'          => "Winamp Modern Skin",
    'WSZ'          => "Winamp Classic Skin",
    'WPA'          => "ACT! Word Processing Document",
    'WPD'          => "ACT! 2 Word Processing Document",
    'W01'          => "Yamaha SY Series Wave File",
    'WFB'          => "WaveFront Sound Bank",
    'WFD'          => "WaveFront Drum Kit File",
    'WFP'          => "WaveFront Program File",
    'WOW'          => "Grave Composer Music Module",
    'WCM'          => "WordPerfect Macro",
    'WPK'          => "Nero Wave Editor File",
    'WWU'          => "Wwise Work Unit",
    'WPROJ'        => "Wwise Project File",
    'WV'           => "WavPack Audio File",
    'WVC'          => "WavPack Correction File",
    'WBA'          => "WindowBlinds Compressed Skin",
    'WAGAME'       => "Worms Armageddon Game Recording",
    'WCP'          => "WinDVD Creator Project File",
    'WBMP'         => "Wireless Bitmap Image File",
    'WOR'          => "MapInfo Workspace File",
    'WRP'          => "Geomagic 3D Wrap File",
    'WIM'          => "Windows Imaging Format File",
    'W3G'          => "Warcraft 3 Replay File",
    'W3Z'          => "Warcraft 3 Saved Game File",
    'WJR'          => "ReGet Deluxe Data File",
    'WTF'          => "World of Warcraft Text File",
    'WMMP'         => "Windows Movie Maker Project File",
    'WPP'          => "WebPlus Project File",
    'WBT'          => "Toribash Help File",
    'WOA'          => "WebObjects Application",
    'WTB'          => "Win-Test Binary Log File",
    'WTD'          => "Grand Theft Auto IV Textures File",
    'WGZ'          => "S60 Web Runtime Widget Package",
    'WDL'          => "World Definition Language Script",
    'WHTT'         => "HTTrack Website Copier File",
    'WWD'          => "Works Wizard File",
    'WZ'           => "Warzone 2100 Data File",
    'WEA'          => "Ecotect Weather File",
    'WJF'          => "WinZip Job File",
    'WB1'          => "Webshots Picture File",
    'WB2'          => "Corel Quattro Pro File",
    'WP3'          => "Microsoft Photo Story Project File",
    'W'            => "OpenEdge Architect Source Code File",
    'WPC'          => "WordPad Converter File",
    'WCZ'          => "Chameleon Clock Wallpaper File",
    'WCD'          => "Works Calendar File",
    'WSI'          => "Wise Package Studio Installer Package",
    'WSM'          => "Wise Package Studio Merge Module",
    'WDF'          => "Windows Driver Foundation File",
    'WPT'          => "Works Template",
    'WLZ'          => "Winamp Language Pack",
    'WORDLIST'     => "Desktop Poet Word List File",
    'WJE'          => "WinJournal Entry",
    'WIDGET'       => "Microsoft Windows Mobile Widget",
    'WDB'          => "Blizzard World of Warcraft Database File",
    'WEBSITE'      => "Internet Explorer Pinned Site Shortcut",
    'WMT'          => "WinMount Virtual Disk File",
    'WVE'          => "WaveEditor Project File",
    'WBCAT'        => "Windows Backup Catalog File",
    'WPH'          => "Phoenix BIOS File",
    'WDGT'         => "Adobe Captivate Widget File",
    'WEBPNP'       => "Web Point and Print File",
    'WMGA'         => "Web Manga Document",
    'WAD'          => "Nintendo Wii Game Data File",
    'WEBHISTORY'   => "Safari Web History File",
    'WEBBOOKMARK'  => "Safari Web Bookmark File",
    'WORKSPACE'    => "Code::Blocks Workspace File",
    'WCAT'         => "WinCatalog Collection File",
    'WEBP'         => "WebP Image",
    'WSP'          => "SharePoint Solution Package",
    'W64'          => "Sony Wave64 Audio File",
    'WEBDOC'       => "Box.net Web Document",
    'WLD'          => "ESRI World File",
    'WLD'          => "Terraria World File",
    'WLX'          => "MapSource Web Link File",
    'WDGTPROJ'     => "Dashcode Widget Project",
    'WTC'          => "Logitech Webcam File",
    'WDP'          => "AutoCAD Electrical Project File",
    'WMZ'          => "Compressed Windows Metafile",
    'WFM'          => "Tektronix Waveform Data File",
    'WID'          => "SAP BusinessObjects Web Intelligence File",
    'W32'          => "Win32 Makefile",
    'WPP'          => "WavePad Project File",
    'WFT'          => "GTA 4 Car Model File",
    'WVP'          => "MagicHTML Web Video Player Project",
    'WORLD'        => "WorldPainter File",
    'WORLD'        => "The Sims 3 Create a World Tool File",
    'W3D'          => "Adobe Shockwave 3D File",
    'WDW'          => "WinDev Window File",
    'WPW'          => "WinDev Mobile Window File",
    'WDP'          => "Windev Project File",
    'WS'           => "1-2-3 Word Search Maker Puzzle File",
    'WPOST'        => "Windows Live Writer Post File",
    'WOTREPLAY'    => "World of Tanks Replay File",
    'WIQ'          => "Visual Studio Work Item Query File",
    'WHIRLD'       => "Unity Whirld Package",
    'WLL'          => "Microsoft Word Add-in",
    'WVE'          => "Wondershare Filmora Project File",
    'WBM'          => "Webmin Module",
    'WFM'          => "Pro Tools Wave Cache File",
    'WIXLIB'       => "WiX Library File",
    'WEBTHEME'     => "iWeb Theme Template",
    'WEBTEMPLATE'  => "iWeb Template",
    'WXL'          => "WiX Localization File",
    'WXI'          => "WiX Include File",
    'WXS'          => "WiX Source File",
    'WIXOBJ'       => "WiX Object File",
    'WIXOUT'       => "WiX XML Output File",
    'WIXPDB'       => "WiX Debug File",
    'WIXMSP'       => "WiX XML Patch File",
    'WIXMST'       => "WiX Transform File",
    'WALLET'       => "MultiBit Wallet File",
    'WC'           => "Valve Hammer Configuration File",
    'WPI'          => "Inkling Sketch Binary File",
    'WLX'          => "WinList Analysis Protocol File",
    'WAM'          => "Worms Armageddon Mission File",
    'WBP'          => "Webshots Collection File",
    'WORLD'        => "Terraria Mobile World File",
    'WXP'          => "Wax 2.0 Project",
    'WRTS'         => "Wrts File",
    'WSVE'         => "Wondershare Filmora for Mac Project File",
    'WFSP'         => "Wondershare Fantashow Project",
    'WIE'          => "WordPress Widget Export File",
    'WEBAPP'       => "Firefox Web App Manifest File",
    'WALLETX'      => "Enpass Data File",
    'WIF'          => "Weaving Interchange Format File",
    'WME'          => "Windows Media Encoder Session File",
    'WVM'          => "Google Play Video File",
    'WRYPT'        => "Panwrypter Depleted Storage Volume File",
    'WALLET'       => "Wallet Ransomware",
    'WNCRY'        => "Wana Decrypt0r 2.0 Encrypted File",
    'WLU'          => "Jaff Ransomware Encrypted File",
    'WCRY'         => "WannaCry Virus Encrypted File",
    'WDZ'          => "WDZip Compressed Archive",
    'WU8'          => "Wiimm U8 Mario Kart Wii Archive",
    'WHL'          => "Python Wheel Package",
    'WUD'          => "Wii U Disk Image File",
    'WOWSREPLAY'   => "World of Warships Replay File",
    'WASM'         => "WebAssembly Binary File",
    'WK1'          => "Lotus Worksheet",
    'WPF'          => "WordPerfect Form",
    'WP'           => "WordPerfect Document",
    'WRI'          => "Microsoft Write Document",
    'WCM'          => "Microsoft Works Communications Script",
    'WP4'          => "WordPerfect 4 Document",
    'WP5'          => "WordPerfect 5 Document",
    'WRL'          => "VRML World",
    'WRZ'          => "Compressed VRML World File",
    'WKS'          => "Lotus 1-2-3 Spreadsheet",
    'WBK'          => "WordPerfect Workbook",
    'WFM'          => "dBASE Form",
    'WK3'          => "Lotus 3 Worksheet",
    'WK4'          => "Lotus 4 Worksheet",
    'WK5'          => "Lotus 5 Worksheet",
    'WP7'          => "WordPerfect 7 Document",
    'WM'           => "Windows Media File",
    'WIDGET'       => "Yahoo! Widget",
    'WCF'          => "WebEx Saved Chat Session",
    'WI'           => "Wavelet Image",
    'WX'           => "Flight Simulator Weather File",
    'W32'          => "WinCAPs Subtitle File",
    'WDP'          => "Windows Media Photo File",
    'WMDB'         => "Windows Media Database File",
    'WZMUL'        => "WinZip Registration File",
    'WGP'          => "Web Gallery Project",
    'WER'          => "Windows Error Report",
    'WL6'          => "Wolfenstein 3D Data File",
    'WMO'          => "World of Warcraft World Map Object",
    'WDQ'          => "Offline Explorer Queue File",
    'WBD'          => "Webshots Picture File",
    'WB1'          => "Corel Quattro Pro File",
    'WAV'          => "DTS-WAV File",
    'WPO'          => "HOLUX Waypoint File",
    'WVL'          => "Wavelet Image",
    'WPC'          => "Pazzles Cutting File",
    'WDF'          => "Wiimm Disc File",
    'WBFS'         => "Wii Backup File System File",
    'WEAP'         => "Quake 3 Engine Weapon File",
    'WOLFQUEST'    => "WolfQuest Saved Game",
    'WJF'          => "WinJournal Journal File",
    'WIDGET'       => "HybridJava Widget",
    'WLP'          => "Worldlabel.com Label Designer File",
    'WORKSPACE'    => "Adobe Bridge Workspace File",
    'WPS'          => "Translator's Workbench Project File",
    'WBM'          => "Wireless Bitmap Image",
    'WPM'          => "Warcraft 3 Path Map File",
    'WZCONFIG'     => "WinZip Configuration File",
    'WLVS'         => "Windows Movie Maker Video Settings File",
    'WORKSHEET'    => "BBEdit Shell Worksheet File",
    'WN'           => "WN Web File",
    'WTPL'         => "WireTap Studio Library",
    'WTPT'         => "WireTap Studio Packaged Track",
    'WBXML'        => "WAP Binary XML File",
    'WOWPROJ'      => "AddOn Studio Project File",
    'WOT'          => "WebEx Recording File",
    'WRK'          => "SQL Server Log Shipping File",
    'WEBZ'         => "WEBZ Compressed eBook File",
    'WPL'          => "GTA Binary Item Placement File",
    'WID'          => "Visual Studio Widget File",
    'WPT'          => "Kingsoft Writer Template",
    'WLZ'          => "WinImage Compressed Disk Image Set",
    'WPX'          => "WebPlus Project Template",
    'WORK'         => "Bibble Work Queue File",
    'WEBARCHIVEXM' => " 'Android Web Browser Archive",
    'WPE'          => "openCanvas 1.1 Event File",
    'WPB'          => "openCanvas 1.1 Image",
    'WEM'          => "Wwise Encoded Media File",
    'WSPAK'        => "WebsitePanel Backup File",
    'WLD'          => "SMBX World File",
    'WINCLONE'     => "Winclone Image",
    'WD3'          => "Offline Explorer Data File",
    'W'            => "Google Toolbar Search History File",
    'WSC'          => "WonderSwan Color Game ROM",
    'WDSEML'       => "Thunderbird Searchable Email File",
    'WOWSL'        => "WOW Slider",
    'WA2'          => "Wonderland Adventures Custom Adventure File",
    'WINMD'        => "Windows Metadata File",
    'WBS'          => "WebBlender Project File",
    'WXN'          => "Waixing Famicom Game ROM",
    'WEAVELIBRARY' => "Painter Weave Library",
    'WAC'          => "Inkling Sketch XML File",
    'WLB'          => "WinList Protocol Bundle",
    'WA'           => "Windows Addon Archive",
    'WAFF'         => "Internet Explorer for Mac Web Archive",
    'WLDX'         => "World Map File",
    'WBI'          => "Compact ISO File",
    'WB0'          => "Webshots Picture File",
    'WHF'          => "Wing Helper File",
    'WX'           => "Wanam Xposed Backup File",
    'WGI'          => "Wildgame Innovations Video File",
    'W01'          => "Samsung Recovery File",
    'WFW'          => "Windows Firewall Policy File",
    'WTML'         => "WorldWide Telescope Data File",
    'WEBTEST'      => "Visual Studio Web Test File",
    'WAPPROJ'      => "Windows Application Packaging Project File",
    'WDF'          => "Wintech Drawing File",
    'WUX'          => "Compressed Wii U Disk Image File",
    'WS'           => "WonderSwan Game ROM File",
    'WOTMOD'       => "World of Tanks Modification File",
    'WORLD'        => "Starbound World File",
    'WPG'          => "Ironsight Game Data File",
    'WR1'          => "Lotus Symphony Worksheet File",
    'WALLET'       => "MultiDoge Wallet File",
    'WP6'          => "WordPerfect 6 Document",
    'WIN'          => "Windows Backup File",
    'WN'           => "WriteNow Text Document",
    'WPK'          => "WordPerfect Macro",
    'WOT'          => "Web Of Trust File",
    'WPP'          => "WordPerfect Color Palette",
    'WK2'          => "Lotus 2 Worksheet",
    'WKI'          => "Lotus 2 Worksheet",
    'WKU'          => "Lotus 1-2-3 Spreadsheet",
    'WTR'          => "Encarta File",
    'WGS'          => "Walk-Graph Segment File",
    'WIN'          => "FoxPro Window Settings",
    'WMP'          => "Windows Media Photo File",
    'WPL'          => "DEC WPS Plus Text Document",
    'WIC'          => "J Wavelet Image",
    'WPX'          => "Printer Description File",
    'WPD'          => "602Text Word Processing Document",
    'WSD'          => "WordStar Document",
    'WPO'          => "Technopress Waypoint 2D File",
    'WPW'          => "WP Works Word Processor File",
    'WQ1'          => "Quattro Pro for DOS Spreadsheet File",
    'WQ2'          => "Quattro Pro for DOS Spreadsheet File",
    'WKE'          => "Lotus 1-2-3 Educational Version Worksheet",
    'W02'          => "Split Archive File",
    'WFD'          => "Wayfinder Map File",
    'WGF'          => "Widelands Game File",
    'WRPL'         => "Widelands Saved Game File",
    'WRPL.WGF'     => "Widelands Initial Saved Game File",
    'WMF'          => "Widelands Map File",
    'WDF'          => "WinGenea Genealogy File",
    'WPT'          => "Cube 2 Waypoint File",
    'WPK'          => "GuinXell Package File",
    'WBB'          => "WinBackup Archive",
    'WYZ'          => "WYZTracker File",
    'WTX'          => "Text Document",
    'WIL'          => "WinImage Disk Image List",
    'WPB'          => "Windows Phone Device Manager Backup File",
    'WII'          => "Scrambled Wii Disc Image",
    'WPE'          => "WordPerfect Entrust Document",
    'WUL'          => "WinUHA Language File",
    'WL1'          => "Wolfenstein 3D Data File",
    'WAND'         => "GarageBand Magic Template",
    'WDF'          => "Wonderland Adventures Media File",
    'WOP'          => "Wonderland Object Preset",
    'WCP_SETTINGS' => "Alpha Five Settings File",
    'WEBPUBLISHHI' => "T'ORY  Alpha Five Web Publish History File",
    'WLS'          => "R-Link Update File",
    'WCINV'        => "Windows Meeting Space Invitation File",
    'WKQ'          => "Quattro Pro for DOS Spreadsheet File",
    'XLS'          => "Excel Spreadsheet",
    'XML'          => "XML File",
    'XHTML'        => "Extensible Hypertext Markup Language File",
    'XCODEPROJ'    => "Xcode Project",
    'XLSX'         => "Microsoft Excel Open XML Spreadsheet",
    'XLR'          => "Works Spreadsheet",
    'XLL'          => "Excel Add-In File",
    'XAR'          => "Xara Xtreme Drawing",
    'XPI'          => "Cross-platform Installer Package",
    'XSL'          => "XML Style Sheet",
    'XSLT'         => "XSL Transformation File",
    'XSD'          => "XML Schema Definition",
    'XCF'          => "GIMP Image File",
    'XLTX'         => "Excel Open XML Spreadsheet Template",
    'XLTM'         => "Excel Open XML Macro-Enabled Spreadsheet",
    'XLSB'         => "Excel Binary Spreadsheet",
    'XEX'          => "Xbox 360 Executable File",
    'XPS'          => "XML Paper Specification File",
    'XVID'         => "Xvid-Encoded Video File",
    'XAP'          => "Silverlight Application Package",
    'XFDL'         => "XFDL File",
    'XFD'          => "XFD File",
    'XDB'          => "Symantec Virus Database File",
    'XHTM'         => "Extensible Hypertext Markup Language Document",
    'XFDF'         => "Adobe Acrobat XFDF File",
    'XBAP'         => "XAML Browser Application File",
    'XPJ'          => "RoboHelp HTML Project File",
    'XQ'           => "XQuery File",
    'XISE'         => "Xilinx ISE Project File",
    'XVA'          => "XenServer Virtual Appliance File",
    'XTODVD'       => "ConvertXtoDVD Project File",
    'XDNA'         => "DNA Strider Sequence File",
    'X3G'          => "3D Print File",
    'XRDML'        => "XRDML Data File",
    'XLT'          => "Excel Template",
    'XXE'          => "XXEncoded File",
    'XM'           => "Fasttracker 2 Extended Module",
    'XLA'          => "Excel Add-In File",
    'XLB'          => "Excel Toolbars File",
    'XLC'          => "Excel Chart",
    'XLM'          => "Excel Macro",
    'XLK'          => "Excel Backup File",
    'XDP'          => "XML Data Package",
    'XPM'          => "X11 Pixmap Graphic",
    'XOL'          => "Swiss Map Overlay",
    'X32'          => "Adobe Xtra File",
    'XSI'          => "Softimage XSI 3D Image",
    'XMLPER'       => "LeCroy Binary Waveform File",
    'XY3'          => "XYWrite III Document",
    'XYP'          => "XYWrite Plus Document",
    'XYW'          => "XYWrite for Windows Document",
    'XPT'          => "Mozilla Firefox Component",
    'XPT'          => "SAS Transport File",
    'XFS'          => "eRacer Sound File",
    'XUL'          => "XML User Interface Language File",
    'XEF'          => "WinAce Encrypted File",
    'XPD'          => "XML Pipeline Document",
    'X64'          => "Commodore 64 Disk Image",
    'XLSM'         => "Excel Open XML Macro-Enabled Spreadsheet",
    'XLAM'         => "Excel Open XML Macro-Enabled Add-In",
    'XBE'          => "Xbox Executable File",
    'XDL'          => "XML Schema File",
    'XDL'          => "Oracle Expert Definition Language File",
    'XFN'          => "Ventura Printer Font",
    'XFT'          => "Adobe Form Designer 5.0 File",
    'XIF'          => "ScanSoft Pagis File",
    'XNK'          => "Exchange Shortcut",
    'XQT'          => "SuperCalc Macro File",
    'XWP'          => "XMLwriter Project",
    'XLV'          => "Excel Visual Basic Module",
    'XPK'          => "WWE RAW Model File",
    'XMD'          => "Extended Media Disc Image",
    'XOL'          => "PowerDesigner Object Language File",
    'XFO'          => "XSL-FO Formatted Form",
    'XPJ'          => "Micro Planner X-Pert Project File",
    'XAML'         => "XAML File",
    'XMB'          => "Age of Empires Game Data File",
    'XMB'          => "X-Wing Mission Briefing File",
    'XHT'          => "XHTML File",
    'XDW'          => "Fuji Xerox DocuWorks File",
    'XLF'          => "XLIFF Document",
    'XSN'          => "InfoPath Form Template File",
    'XLNK'         => "XML Shortcut File",
    'XEN'          => "Guitar Hero III Data File",
    'XPD'          => "PlayStation Store PSP License File",
    'XDB'          => "PowerDesigner Database Definition File",
    'XEM'          => "PowerDesigner Model definition File",
    'XSPF'         => "XSPF Playlist File",
    'XWF'          => "OmniPage Workflow File",
    'XT'           => "Xdebug Trace File",
    'XMP'          => "Extensible Metadata Platform File",
    'XPG'          => "Autoplay Media Studio Exported Page",
    'XIB'          => "Interface Builder File",
    'XTREME'       => "Winstep Xtreme Theme Pack",
    'XRP'          => "RationalPlan Project File",
    'XPADDERCONTR' => "L'LER   Xpadder Controller Profile",
    'XS'           => "Age of Empires 3 Map AI Generator",
    'XMCD'         => "Mathcad Worksheet File",
    'XMCDZ'        => "Mathcad Compressed Worksheet File",
    'XRNS'         => "Renoise Song File",
    'XAP'          => "XACT Project",
    'XYS'          => "XYplorer Script File",
    'XTM'          => "CmapTools Exported Topic Map",
    'X_T'          => "Parasolid Model Part File",
    'X_B'          => "Parasolid Model Part File",
    'XOM'          => "Worms 3D Object File",
    'XDS'          => "DS Game Maker Project File",
    'XA'           => "The Sims Audio File",
    'XPR'          => "Pro/ENGINEER Part Instance Accelerator File",
    'XV3'          => "Lattice XVL Geometry File",
    'XCU'          => "OpenOffice.org Configuration File",
    'XFL'          => "Animate Movie Archive",
    'XRY'          => "XRY Data File",
    'XLW'          => "Excel Workspace File",
    'XOML'         => "Windows Workflow File",
    'XPR'          => "SyncRO Soft oXygen XML Editor Project",
    'XBC'          => "SMART Notebook File",
    'XTP'          => "AutoCAD Exported Tool Palettes File",
    'X3F'          => "SIGMA X3F Camera RAW File",
    'XNT'          => "QuarkXPress Extension File",
    'XSVF'         => "Xilinx Serial Vector Format File",
    'XMMAP'        => "MindManager XML Map File",
    'XAF'          => "3ds Max XML Animation File",
    'XQUERY'       => "XQuery Source Code File",
    'XQL'          => "XML Query Language File",
    'XQM'          => "XQuery Module",
    'XMI'          => "XML Metadata Interchange File",
    'XP3'          => "KiriKiri Package File",
    'XRF'          => "Cal3D XML Materials File",
    'XMF'          => "Cal3D XML Mesh File",
    'XPDL'         => "XPDL Module",
    'XBEL'         => "XBEL Bookmarks File",
    'XNB'          => "XNA Game Studio Binary Package",
    'X'            => "DirectX Model File",
    'XUI'          => "Xbox 360 User Interface File",
    'XUR'          => "Xbox 360 Binary User Interface File",
    'XER'          => "Primavera P6 Project File",
    'XBDOC'        => "Xiosis Scribe Document",
    'XCARCHIVE'    => "Xcode Archive",
    'XCSNAPSHOTS'  => "Xcode Snapshot",
    'XCWORKSPACE'  => "Xcode Workspace File",
    'XBK'          => "XenServer Backup File",
    'XSLIC'        => "XenServer License File",
    'XVM'          => "VMware Console Configuration File",
    'XEJ'          => "Expression Encoder Job File",
    'XEL'          => "Expression Encoder Live Encoding File",
    'XESC'         => "Expression Encoder Screen Capture File",
    'XLMV'         => "Xunlei Movie File",
    'XAPPL'        => "Spoon XML Application Configuration File",
    'XMIND'        => "XMind Workbook File",
    'XPP'          => "X++ Source Code File",
    'XDI'          => "WinArchiver Extended Disc Image File",
    'XSF'          => "InfoPath Form Definition File",
    'XRFF'         => "Extensible Attribute-Relation File Format",
    'XCAPPDATA'    => "Xcode App Data File",
    'XCDATAMODELD' => "Xcode Core Data Model File",
    'XAMLX'        => "Visual Studio Workflow Service File",
    'XSC'          => "Visual Studio Dataset Internal Info File",
    'XAR'          => "Excel Auto-Recovery File",
    'XTP'          => "xTime Project Document",
    'X86'          => "Linux Executable File",
    'XAR'          => "Extensible Archive Format File",
    'XBRL'         => "XBRL Document",
    'XCCONFIG'     => "Xcode Configuration Settings File",
    'XMU'          => "Expressive Music Container File",
    'XML'          => "Cinelerra Video Project",
    'XUM'          => "Excel Unit Operation Model File",
    'XFLOW'        => "FlowExchange Data File",
    'XVD'          => "Xbox Virtual Disk",
    'XMS'          => "Music Studio Project",
    'XMLFF'        => "XML Flat File",
    'XMDX'         => "ExamSoft Answer File",
    'XMZX'         => "ExamSoft Exam File",
    'XMT'          => "XMind Template",
    'XTBL'         => "XTBL Ransomware Encrypted File",
    'XAPK'         => "Compressed Android Package File",
    'XLE'          => "Levelogger Software XML Data File",
    'XXX'          => "Extractor Ransomware Encrypted File",
    'XCI'          => "Nintendo Switch Game Backup File",
    'XLW'          => "Excel Workbook",
    'XMI'          => "Extended MIDI File",
    'XX'           => "XXEncoded File",
    'X3D'          => "Xara3D Project",
    'XBM'          => "X11 Bitmap Graphic",
    'XWD'          => "X Windows Dump Image",
    'XWS'          => "Xara Web Designer Graphic",
    'XCODE'        => "Xcode Project",
    'XL'           => "Excel Spreadsheet",
    'XPR'          => "PressIt Disc Label",
    'XMF'          => "Extensible Music File",
    'XPM'          => "Micro Planner Manager File",
    'XSB'          => "XACT Sound Bank",
    'XWB'          => "XACT Wave Bank",
    'XGS'          => "XACT Global Settings File",
    'XLGC'         => "ExpressK Database File",
    'XTM'          => "Xtremsplit Data File",
    'XRM-MS'       => "Microsoft Security Certificate",
    'XMZ'          => "FastTracker 2 Extended Module",
    'XST'          => "WebSphere Query Template",
    'XBK'          => "SMART Notebook File",
    'XXX'          => "Compucon Singer Embroidery File",
    'XPL'          => "LcdStudio Playlist File",
    'XDS'          => "LcdStudio Design File",
    'XZ'           => "XZ Compressed Archive",
    'XDR'          => "XML-Data Reduced File",
    'XBSAV'        => "Mass Effect 2 Xbox Saved Game",
    'XA'           => "PlayStation Audio File",
    'XAS'          => "Pro/ENGINEER Assembly Instance Accelerator File",
    'XV0'          => "Lattice XVL Structure File",
    'XYZ'          => "Molecule Specification File",
    'XBT'          => "SMART Notebook Template File",
    'XFD'          => "FormFlow 99 Form Data File",
    'XSX'          => "Visual Studio XML Schema Layout File",
    'XTG'          => "Extensible TreeGraph File",
    'XSIADDON'     => "Softimage Add-on File",
    'XLB'          => "OpenOffice.org Module Information File",
    'XBA'          => "OpenOffice.org Basic Module File",
    'XBL'          => "Extensible Binding Language File",
    'XMM'          => "3ds Max XML Animation Map File",
    'XQY'          => "XQuery Source File",
    'XP4'          => "KiriKiri Package",
    'XSS'          => "XML Style Sheet",
    'XSF'          => "Cal3D XML Skeleton File",
    'XAF'          => "Cal3D XML Animation File",
    'XFR'          => "iProcess Process Definition File",
    'XVCT'         => "VISE XML Project File",
    'XYZV'         => "Celestia Sampled Trajectory File",
    'XYZ'          => "Celestia Sampled Trajectory Data File",
    'XBPLATE'      => "Xiosis Scribe Template",
    'XAF'          => "Affirm Deposition Transcript",
    'XPR'          => "Microsoft Expression Design Graphic",
    'XADD'         => "Expression Web Add-in",
    'XAN'          => "Worms Map File",
    'XGML'         => "Graph Modeling Language XML File",
    'XGMML'        => "XGMML Graph File",
    'XMAP'         => "XMind 2007/2008 Workbook",
    'XMD'          => "Bitdefender Plugin File",
    'XVMCONF'      => "World of Tanks XVM Configuration File",
    'XTP'          => "InfoPath Template Part File",
    'XLIFF'        => "XLIFF Localization File",
    'XCDATAMODEL'  => "Xcode Core Data Model File",
    'XSP'          => "Kodi Smart Playlist File",
    'XENSEARCH'    => "XenCenter Saved Search File",
    'XMV'          => "Xbox Media Video File",
    'XMCT'         => "Mathcad XML Worksheet Template",
    'XBF'          => "XAML Binary File",
    'XPF'          => "LMMS Preset File",
    'XFB'          => "Xserve RAID Firmware Binary File",
    'XBMML'        => "Braille Music Markup Language File",
    'XCCOLORTHEME' => "Xcode Color Theme File",
    'XCSCHEME'     => "Xcode Scheme File",
    'XCODEPLUGIN'  => "Xcode Plug-in",
    'XCPLUGIN'     => "Xcode Plug-in",
    'XZM'          => "Porteus Module",
    'XMS'          => "XMS-Tracker Music Module",
    'XMD'          => "ExamSoft Answer File",
    'XGDW'         => "GDevelop Extension File",
    'XCCRASHPOINT' => "Xcode Crash Point File",
    'XMP'          => "XMind Markers Package",
    'XRB'          => "XMind Resource Bundle",
    'XPLL'         => "Pull-Planner Data File",
    'XCT'          => "XVI32 Character Conversion Table File",
    'XBD'          => "DocuWorks Binder File",
    'XIP'          => "macOS Signed Archive",
    'XTB'          => "Angular Translation File",
    'X'            => "Lex Source Code File",
    'XEF'          => "eManager Form Data",
    'XEP'          => "eManager File Packaging Information",
    'XEM'          => "eManager Metered Units",
    'XES'          => "eManager Skins Definition",
    'XET'          => "eManager Process Definition",
    'XEV'          => "eManager Auto-Update File",
    'XEZ'          => "eManager Template Package",
    'XY'           => "XYWrite Document",
    'XA'           => "GEAR CD/DVD Disc Image",
    'XI'           => "Fasttracker 2 Extended Instrument File",
    'XP'           => "Fastracker 2 Pattern",
    'XT'           => "Fastracker 2 Track",
    'XFT'          => "ChiWriter Printer Font",
    'XOF'          => "Reality Lab 3D Image File",
    'XTP'          => "XTree Data File",
    'XWK'          => "Crosstalk Communicator Keyboard Mapping File",
    'XWP'          => "Xerox Writer Text Document",
    'XWP'          => "Crosstalk Session File",
    'XMF'          => "GameJack Disc Image File",
    'XXD'          => "Brixx Planner Calendar",
    'XMPZ'         => "Miradi XML Project File",
    'X4K'          => "XML4King Configuration File",
    'XZFX'         => "ZipLogix ZipForm File",
    'XTL'          => "Vietcong Data File",
    'XLSHTML'      => "Microsoft Excel HTML Spreadsheet",
    'XLSMHTML'     => "Microsoft Excel MIME HTML Spreadsheet",
    'XLTHTML'      => "Microsoft Excel HTML Spreadsheet Template",
    'XLD'          => "Excel Database File",
    'XGP'          => "Xfire Game Patcher File",
    'XCSL'         => "CineStyle Color Correction File",
    'XP'           => "XPilot Map",
    'XP2'          => "XPilot NG",
    'XAIML'        => "XAIML Chatterbot Database File",
    'XCPLUGINDATA' => "Xcode Plug-in Data File",
    'XMWX'         => "ExamSoft Working File",
    'YUV'          => "YUV Encoded Image File",
    'YKCOL'        => "Locky Ransomware Encrypted File",
    'YML'          => "YAML Document",
    'YUV'          => "YUV Video File",
    'YCM'          => "Yugioh Card Maker File",
    'YMP'          => "YaST Metapackage File",
    'YDR'          => "Yu-Gi-Oh! Power of Chaos Replay File",
    'YNC'          => "yEnc Encoded File",
    'YDC'          => "Yu-Gi-Oh! Card Deck File",
    'Y'            => "Yacc Source File",
    'YPR'          => "BYOB Project File",
    'YBK'          => "YanCEyWare eBook",
    'YAML'         => "YAML Document",
    'YDK'          => "Yu-Gi-Oh! Deck File",
    'Y4M'          => "YUV4MPEG2 Video File",
    'YKA'          => "Yenka Model File",
    'YGF'          => "Y Graph Format File",
    'YOOKOO'       => "Yookoo Player Playlist File",
    'YOG'          => "Outerra Captured Video File",
    'YTF'          => "Google Picasa Font Cache",
    'YSP'          => "BYOB Sprite File",
    'Y3A'          => "Yu-Gi-Oh! ONLINE 3 Avatar File",
    'Y3D'          => "Yu-Gi-Oh! ONLINE 3 Deck File",
    'YBD'          => "YobiDrive Link File",
    'YFS'          => "YSFLIGHT Mission File",
    'YCHAT'        => "Yahoo! Messenger Chat Log",
    'YPS'          => "Yahoo! Messenger Data File",
    'Y'            => "Amiga Yabba Compressed File",
    'Y'            => "Subsampled Raw YUV Image",
    'YRCDAT'       => "YRC Software Data Script",
    'YAL'          => "Arts & Letters Clipart Library",
    'YBK'          => "Microsoft Encarta Yearbook File",
    'YTD'          => "Grand Theft Auto 5 Texture File",
    'YUMTX'        => "YUM Transaction File",
    'YENC'         => "yEnc File",
    'YRCBKM'       => "YRC Bookmarks Archive",
    'YAB'          => "Yabasic Source Code",
    'YRCBCK'       => "YRC Backup Archive",
    'YMG'          => "Yahoo! Messenger File",
    'YZ1'          => "Yamazaki ZIPPER File",
    'YDT'          => "Yu-Gi-Oh! Power of Chaos Data File",
    'YM'           => "Atari ST Audio File",
    'YML2'         => "YML Script",
    'YDL'          => "PowerFlip YAODL 3D Image File",
    'YAODL'        => "PowerFlip 3D Image File",
    'YAM'          => "Yahoo! Auctions Data",
    'YZ'           => "YAC Compressed File",
    'ZIP'          => "Zipped File",
    'ZIPX'         => "Extended Zip File",
    'ZAP'          => "Zero Administration Package File",
    'ZIP'          => "MAME Game ROM",
    'Z'            => "Unix Compressed File",
    'ZAP'          => "ZoneAlarm Pro Data File",
    'ZFSENDTOTARG' => "T'Compressed Folder",
    'ZVD'          => "ZyXEL Voice File",
    'ZZ'           => "Zzip Compressed Archive",
    'ZVZ'          => "Possible Virus File",
    'Z64'          => "Nintendo 64 Game ROM",
    'ZFO'          => "XSL-FO Online Form",
    'ZNO'          => "Zinio Electronic Magazine File",
    'ZTF'          => "DVD Label Template File",
    'ZTR'          => "DVD Label Template Media File",
    'ZT'           => "Mental Ray Image Depth File",
    'ZST'          => "ZSNES Save File",
    'ZMV'          => "ZSNES Movie File",
    'ZDC'          => "CD Catalog Expert Database File",
    'ZMAP'         => "Zombies Ate My Neighbors Map File",
    'ZM1'          => "ZSNES Movie #1 File",
    'ZM2'          => "ZSNES Movie #2 File",
    'ZM3'          => "ZSNES Movie #3 File",
    'ZM1'          => "ZoneAlarm Renamed MDA File",
    'ZM2'          => "ZoneAlarm Renamed MDZ File",
    'ZM3'          => "ZoneAlarm Renamed NCH File",
    'ZIF'          => "Zooming Image Format File",
    'ZML'          => "Zooming Markup Language File",
    'ZDS'          => "GZDoom Save File",
    'Z01'          => "WinZip First Split Zip File",
    'ZTD'          => "Zoo Tycoon Data Archive",
    'ZHTML'        => "Secure IE Zipped HTML File",
    'ZDP'          => "Avery DesignPro Label File",
    'ZMC'          => "ZoneAlarm Quarantine File",
    'ZS0'          => "ZSNES Slot 0 Saved State File",
    'ZS1'          => "ZSNES Slot 1 Saved State File",
    'ZS2'          => "ZSNES Slot 2 Saved State File",
    'ZS3'          => "ZSNES Slot 3 Saved State File",
    'ZS4'          => "ZSNES Slot 4 Saved State File",
    'ZS5'          => "ZSNES Slot 5 Saved State File",
    'ZS6'          => "ZSNES Slot 6 Saved State File",
    'ZS7'          => "ZSNES Slot 7 Saved State File",
    'ZS8'          => "ZSNES Slot 8 Saved State File",
    'ZS9'          => "ZSNES Slot 9 Saved State File",
    'Z2F'          => "Zoo Tycoon 2 Object File",
    'ZUL'          => "ZK User Interface File",
    'ZTMP'         => "Steam Compressed Game Resource File",
    'ZXP'          => "Extension Manager Package",
    'ZABW'         => "Compressed AbiWord Document File",
    'Z3D'          => "ZModeler 3D File",
    'ZVPL'         => "Visual Paradigm License File",
    'ZDB'          => "Zimbra Database File",
    'ZPL'          => "Zune Playlist",
    'Z80'          => "TI-83 and 84 Plus Calculator File",
    'ZONE.IDENTIF' => "E'Windows Zone Identifier File",
    'ZDS'          => "DesignPro Label File",
    'ZLB'          => "Form•Z Symbol Library File",
    'ZZZ'          => "CCleaner Securely Deleted File",
    'ZIM'          => "OpenZIM Wiki Archive",
    'ZPS'          => "Zebra Portable Safe File",
    'ZHTML'        => "RabbitWeb Webpage",
    'ZON'          => "OmniPage Zone Template File",
    'ZRTF'         => "Nisus Compressed Rich Text File",
    'Z3'           => "Z-machine Z-code Version 3 File",
    'Z4'           => "Z-machine Z-code Version 4 File",
    'Z5'           => "Z-machine Z-code Version 5 File",
    'ZBLORB'       => "Z-machine Package Game File",
    'ZW'           => "Zooper Widget Template",
    'ZEPTO'        => "Zepto Virus File",
    'ZZZZZ'        => "Ransomware Encrypted File",
    'Z1'           => "ZoneAlarm Renamed VB File",
    'ZOO'          => "Zoo Compressed File",
    'ZIX'          => "WinZix Compressed File",
    'ZON'          => "Collection Building Custom Zone File",
    'ZPL'          => "Zoom Player Play List",
    'Z02'          => "WinZip Second Split Zip File",
    'Z03'          => "WinZip Third Split Zip File",
    'Z04'          => "WinZip Fourth Split Zip File",
    'ZM9'          => "ZoneAlarm MailSafe Renamed Zip File",
    'ZDL'          => "Avery DesignPro Label File",
    'ZFX'          => "ZipForm File",
    'ZPI'          => "PDF Converter Index File",
    'ZL9'          => "ZoneAlarm Quarantined EXE File",
    'ZPA'          => "Vielklang Audio Metadata File",
    'ZPF'          => "Form•Z Preferences File",
    'ZVT'          => "Photoshop Zoomify Preset File",
    'Z8'           => "Z-machine Z-code Version 8 File",
    'ZMA'          => "Impedance File",
    'ZLB'          => "Z-machine Package Game File",
    'ZAD'          => "Carmageddon Game Data File",
    'ZSPLIT'       => "Archiver Compressed Split File",
    'ZGR'          => "BeatSlicer Groove File",
    'Z2S'          => "Zoo Tycoon 2 Saved Game",
    'ZVI'          => "Zeiss Vision Image",
    'ZBFX'         => "zebNet Backup File Extended",
    'ZSM'          => "Raven Software Game Sound Archive",
    'ZI_'          => "Renamed Zip File",
    'ZAP'          => "FileWrangler Archive",
    'ZDB'          => "Quicken Online File",
    'ZIX'          => "Quicken Online File",
    'ZSD'          => "Dave Mirra Freestyle BMX Data File",
    'ZDB'          => "EPSQ Database",
    'ZGM'          => "Zenographics Image File",
    'ZOO'          => "Zoo Tycoon Saved Game",
    'ZW'           => "Chinese Text File",
    'ZVR'          => "SAFA Media Audio File",
    'ZPI'          => "Zipped File",
    'ZL'           => "Zlib Compressed File",
    'ZI'           => "Renamed Zip File",
    'ZZZ'          => "Black & White Game Data File",
    'ZDCT'         => "Adobe Language File",
    'ZEG'          => "ZeroG Subtitles File",
    'ZAB'          => "Zipped Audio Book",
    'Z1'           => "Z-machine Z-code File",
    'Z2'           => "Z-machine Z-code Version 2 File",
    'Z6'           => "Z-machine Z-code Version 6 File",
    'Z7'           => "Z-machine Z-code Version 7 File",
  );
}
#>

=pod

=head1 NAME

File::Extension - explain file extensions

=head1 SYNOPSIS

    use File::Extension qw(explain);

    for my $what(@ARGV) {
      printf("%-10s %s\n", lc($what), explain($what);
    }

=head1 DESCRIPTION

L</File::Extension> provides functionality for explaining file extensions.

This is useful in cases where libmagic doesn't work, i.e on empty or
corrupted files.

=head1 EXPORTS

None by default.

=head1 FUNCTIONS

=head2 explain()

Parameters: $file_extension

Returns:    $explanation

  my $explanation = explain('nes'); # Nintendo (NES) ROM File

=head1 SEE ALSO

L<https://github.com/trapd00r/LS_COLORS>

=head1 AUTHOR

  Magnus Woldrich
  CPAN ID: WOLDRICH
  m@japh.se
  http://japh.se

=head1 CONTRIBUTORS

None required yet.

=head1 COPYRIGHT

Copyright 2018 the B<File::Extension>s L</AUTHOR> and
L</CONTRIBUTORS> as listed above.

=head1 LICENSE

This library is free software; you may redistribute it and/or modify it under
the same terms as Perl itself.

=cut
