# Generated by default/object.tt
package Paws::XRay::InsightImpactGraphService;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str');
  has Edges => (is => 'ro', isa => 'ArrayRef[Paws::XRay::InsightImpactGraphEdge]');
  has Name => (is => 'ro', isa => 'Str');
  has Names => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ReferenceId => (is => 'ro', isa => 'Int');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::XRay::InsightImpactGraphService

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::XRay::InsightImpactGraphService object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::XRay::InsightImpactGraphService object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Information about an application that processed requests, users that
made requests, or downstream services, resources, and applications that
an application used.

=head1 ATTRIBUTES


=head2 AccountId => Str

Identifier of the AWS account in which the service runs.


=head2 Edges => ArrayRef[L<Paws::XRay::InsightImpactGraphEdge>]

Connections to downstream services.


=head2 Name => Str

The canonical name of the service.


=head2 Names => ArrayRef[Str|Undef]

A list of names for the service, including the canonical name.


=head2 ReferenceId => Int

Identifier for the service. Unique within the service map.


=head2 Type => Str

Identifier for the service. Unique within the service map.

=over

=item *

AWS Resource - The type of an AWS resource. For example,
AWS::EC2::Instance for an application running on Amazon EC2 or
AWS::DynamoDB::Table for an Amazon DynamoDB table that the application
used.

=item *

AWS Service - The type of an AWS service. For example, AWS::DynamoDB
for downstream calls to Amazon DynamoDB that didn't target a specific
table.

=item *

AWS Service - The type of an AWS service. For example, AWS::DynamoDB
for downstream calls to Amazon DynamoDB that didn't target a specific
table.

=item *

remote - A downstream service of indeterminate type.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::XRay>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

