# Generated by default/object.tt
package Paws::SageMaker::Tag;
  use Moose;
  has Key => (is => 'ro', isa => 'Str', required => 1);
  has Value => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::Tag

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::Tag object:

  $service_obj->Method(Att1 => { Key => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::Tag object:

  $result = $service_obj->Method(...);
  $result->Att1->Key

=head1 DESCRIPTION

A tag object that consists of a key and an optional value, used to
manage metadata for Amazon SageMaker Amazon Web Services resources.

You can add tags to notebook instances, training jobs, hyperparameter
tuning jobs, batch transform jobs, models, labeling jobs, work teams,
endpoint configurations, and endpoints. For more information on adding
tags to Amazon SageMaker resources, see AddTags.

For more information on adding metadata to your Amazon Web Services
resources with tagging, see Tagging Amazon Web Services resources
(https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html). For
advice on best practices for managing Amazon Web Services resources
with tagging, see Tagging Best Practices: Implement an Effective Amazon
Web Services Resource Tagging Strategy
(https://d1.awsstatic.com/whitepapers/aws-tagging-best-practices.pdf).

=head1 ATTRIBUTES


=head2 B<REQUIRED> Key => Str

The tag key. Tag keys must be unique per resource.


=head2 B<REQUIRED> Value => Str

The tag value.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

