/*
 * Decompiled with CFR 0.152.
 */
package opennlp.common;

import java.io.File;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import opennlp.common.PipelineException;
import opennlp.common.preprocess.Pipelink;
import opennlp.common.xml.NLPDocument;
import opennlp.common.xml.NLPDocumentBuilder;

public class Pipeline {
    Pipelink[] links;

    public Pipeline() {
        this.links = new Pipelink[0];
    }

    public Pipeline(String[] s) throws PipelineException {
        this.links = new Pipelink[s.length];
        try {
            int i = 0;
            while (i < s.length) {
                this.links[i] = (Pipelink)Class.forName(s[i]).newInstance();
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Error in creating Pipeline:");
            System.out.println(e);
        }
        this.verify();
    }

    public Pipeline(Pipelink[] l) throws PipelineException {
        this.links = l;
        this.verify();
    }

    private static void exit(String message) throws PipelineException {
        throw new PipelineException(message);
    }

    private static Collection interfacesOf(Class c) {
        HashSet set = new HashSet();
        Pipeline.interfacesOf(c, set);
        return set;
    }

    private static void interfacesOf(Class o, Set set) {
        Class<?>[] interfaces = o.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            set.add(interfaces[i]);
            Pipeline.interfacesOf(interfaces[i], set);
            ++i;
        }
        Class superClass = o.getSuperclass();
        if (superClass != null) {
            Pipeline.interfacesOf(superClass, set);
        }
    }

    public NLPDocument run(Object input) throws PipelineException {
        NLPDocumentBuilder builder = new NLPDocumentBuilder();
        NLPDocument doc = null;
        if (input instanceof String) {
            doc = builder.build((String)input);
        } else if (input instanceof File) {
            doc = builder.build((File)input);
        } else if (input instanceof Reader) {
            doc = builder.build((Reader)input);
        } else {
            Pipeline.exit("Invalid input type to Pipeline");
        }
        int i = 0;
        while (i < this.links.length) {
            this.links[i].process(doc);
            ++i;
        }
        return doc;
    }

    public void verify() throws PipelineException {
        HashSet modules = new HashSet();
        int i = 0;
        while (i < this.links.length) {
            Pipelink pl = this.links[i];
            if (!modules.containsAll(pl.requires())) {
                Pipeline.exit("Pipeline does not meet requirements of " + pl);
            }
            modules.addAll(Pipeline.interfacesOf(pl.getClass()));
            ++i;
        }
    }

    public static void verify(List l) throws PipelineException {
        HashSet modules = new HashSet();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            String pl = (String)i.next();
            Set set = null;
            Class<?> c = null;
            try {
                c = Class.forName(pl);
                set = ((Pipelink)c.newInstance()).requires();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Pipeline.exit("Not a valid class: " + pl);
            }
            catch (InstantiationException instantiationException) {
                Pipeline.exit("Cannot instantiate: " + pl);
            }
            catch (IllegalAccessException illegalAccessException) {
                Pipeline.exit("Cannot Access: " + pl);
            }
            if (!modules.containsAll(set)) {
                Pipeline.exit("Pipeline does not meet requirements of " + pl);
            }
            modules.addAll(Pipeline.interfacesOf(c));
        }
    }
}

