/*
 * Decompiled with CFR 0.152.
 */
package gma.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ByteInputFileHandler {
    private FileInputStream reader;
    private int nextByte = 0;
    private ArrayList nextLine;

    public ByteInputFileHandler(String fileName) {
        try {
            this.reader = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            this.close();
            System.exit(1);
        }
    }

    public boolean hasByte() {
        this.nextByte = -1;
        try {
            this.nextByte = this.reader.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close();
            System.exit(1);
        }
        return this.nextByte != -1;
    }

    public int nextByte() {
        return this.nextByte;
    }

    public boolean hasLine() {
        this.nextLine = new ArrayList();
        while (this.hasByte()) {
            String tempString = Integer.toString(this.nextByte);
            if (this.nextByte != 10) {
                this.nextLine.add(new Integer(this.nextByte));
                continue;
            }
            return true;
        }
        return false;
    }

    public List nextLine() {
        return this.nextLine;
    }

    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List strip(List inList) {
        ArrayList<Integer> outList = new ArrayList<Integer>();
        int start = 0;
        int end = inList.size();
        while ((Integer)inList.get(start) == 32) {
            ++start;
        }
        while ((Integer)inList.get(end - 1) == 32) {
            --end;
        }
        for (int i = start; i < end; ++i) {
            outList.add((Integer)inList.get(i));
        }
        return outList;
    }

    public List readWordList() {
        ArrayList<List> words = new ArrayList<List>();
        while (this.hasLine()) {
            List wordList = this.nextLine();
            words.add(this.strip(wordList));
        }
        this.close();
        return words;
    }
}

