/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.logging.Logger;
import org.apache.sis.util.logging.DualLogger;
import org.apache.sis.util.logging.LoggerFactory;

final class DualLoggerFactory
extends LoggerFactory<DualLogger> {
    private final LoggerFactory<?> first;
    private final LoggerFactory<?> second;

    DualLoggerFactory(LoggerFactory<?> loggerFactory, LoggerFactory<?> loggerFactory2) {
        super(DualLogger.class);
        this.first = loggerFactory;
        this.second = loggerFactory2;
    }

    @Override
    public String getName() {
        return this.first.getName() + ", " + this.second.getName();
    }

    @Override
    protected DualLogger getImplementation(String string) {
        return new DualLogger(string, this.first.getLogger(string), this.second.getLogger(string));
    }

    @Override
    protected Logger wrap(String string, DualLogger dualLogger) {
        return dualLogger;
    }

    @Override
    protected DualLogger unwrap(Logger logger) {
        if (logger instanceof DualLogger) {
            return (DualLogger)logger;
        }
        return null;
    }
}

