/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.referencing.Code;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.ImmutableIdentifier;
import org.apache.sis.referencing.NameIterator;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.PropertiesConverter;
import org.apache.sis.referencing.SubTypes;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.datum.AbstractDatum;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

@XmlType(name="IdentifiedObjectType", propOrder={"description", "identifier", "names", "remarks"})
@XmlSeeAlso(value={AbstractCRS.class, AbstractDatum.class, DefaultEllipsoid.class, DefaultPrimeMeridian.class, AbstractCS.class})
public class AbstractIdentifiedObject
extends FormattableObject
implements IdentifiedObject,
LenientComparable,
Deprecable,
Serializable {
    private static final long serialVersionUID = -5173281694258483264L;
    public static final String LOCALE_KEY = "locale";
    public static final String DEPRECATED_KEY = "deprecated";
    private ReferenceIdentifier name;
    private Collection<GenericName> alias;
    private Set<ReferenceIdentifier> identifiers;
    private InternationalString remarks;
    private final boolean deprecated;
    private transient int hashCode;

    public AbstractIdentifiedObject(Map<String, ?> map) throws IllegalArgumentException {
        GenericName[] genericNameArray;
        ArgumentChecks.ensureNonNull("properties", map);
        Object obj = map.get("name");
        if (obj == null || obj instanceof String) {
            if (obj == null && map.get("code") == null) {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)89, "name"));
            }
            this.name = new NamedIdentifier(PropertiesConverter.convert(map));
        } else if (obj instanceof ReferenceIdentifier) {
            this.name = (ReferenceIdentifier)obj;
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(map, "name", obj);
        }
        obj = map.get("alias");
        try {
            DefaultNameFactory defaultNameFactory = DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class);
            genericNameArray = defaultNameFactory.toGenericNames(obj);
        }
        catch (ClassCastException classCastException) {
            throw (IllegalArgumentException)AbstractIdentifiedObject.illegalPropertyType(map, "alias", obj).initCause(classCastException);
        }
        this.alias = CollectionsExt.immutableSet(true, genericNameArray);
        obj = map.get("identifiers");
        if (obj == null) {
            this.identifiers = null;
        } else if (obj instanceof ReferenceIdentifier) {
            this.identifiers = Collections.singleton((ReferenceIdentifier)obj);
        } else if (obj instanceof ReferenceIdentifier[]) {
            this.identifiers = CollectionsExt.immutableSet(true, (ReferenceIdentifier[])obj);
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(map, "identifiers", obj);
        }
        this.remarks = Types.toInternationalString(map, "remarks");
        obj = map.get(DEPRECATED_KEY);
        if (obj == null) {
            this.deprecated = false;
        } else if (obj instanceof Boolean) {
            this.deprecated = (Boolean)obj;
        } else {
            throw AbstractIdentifiedObject.illegalPropertyType(map, DEPRECATED_KEY, obj);
        }
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> map, String string, Object object) {
        return new IllegalArgumentException(Errors.getResources(map).getString((short)58, string, object.getClass()));
    }

    protected AbstractIdentifiedObject(IdentifiedObject identifiedObject) {
        ArgumentChecks.ensureNonNull("object", identifiedObject);
        this.name = identifiedObject.getName();
        this.alias = CollectionsExt.nonEmpty(identifiedObject.getAlias());
        this.identifiers = CollectionsExt.nonEmpty(identifiedObject.getIdentifiers());
        this.remarks = identifiedObject.getRemarks();
        this.deprecated = identifiedObject instanceof Deprecable ? ((Deprecable)((Object)identifiedObject)).isDeprecated() : false;
    }

    public static AbstractIdentifiedObject castOrCopy(IdentifiedObject identifiedObject) {
        return SubTypes.castOrCopy(identifiedObject);
    }

    public Class<? extends IdentifiedObject> getInterface() {
        return IdentifiedObject.class;
    }

    @Override
    public ReferenceIdentifier getName() {
        return this.name;
    }

    @Override
    public Collection<GenericName> getAlias() {
        return CollectionsExt.nonNull(this.alias);
    }

    @Override
    public Set<ReferenceIdentifier> getIdentifiers() {
        return CollectionsExt.nonNull(this.identifiers);
    }

    @XmlElement(name="description")
    public InternationalString getDescription() {
        ReferenceIdentifier referenceIdentifier = this.getName();
        if (referenceIdentifier instanceof ImmutableIdentifier) {
            return ((ImmutableIdentifier)referenceIdentifier).getDescription();
        }
        if (referenceIdentifier instanceof DefaultIdentifier) {
            return ((DefaultIdentifier)((Object)referenceIdentifier)).getDescription();
        }
        return null;
    }

    @Override
    @XmlElement(name="remarks")
    public InternationalString getRemarks() {
        return this.remarks;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean isHeuristicMatchForName(String string) {
        return NameToIdentifier.isHeuristicMatchForName(this.name, this.alias, string, NameToIdentifier.Simplifier.DEFAULT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == null) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                int n;
                int n2;
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                AbstractIdentifiedObject abstractIdentifiedObject = (AbstractIdentifiedObject)object;
                if (comparisonMode == ComparisonMode.STRICT && (n2 = this.hashCode) != 0 && (n = abstractIdentifiedObject.hashCode) != 0 && n2 != n) {
                    return false;
                }
                return Objects.equals(this.name, abstractIdentifiedObject.name) && CollectionsExt.nonNull(this.alias).equals(CollectionsExt.nonNull(abstractIdentifiedObject.alias)) && CollectionsExt.nonNull(this.identifiers).equals(CollectionsExt.nonNull(abstractIdentifiedObject.identifiers)) && Objects.equals(this.remarks, abstractIdentifiedObject.remarks);
            }
            case BY_CONTRACT: {
                if (!this.implementsSameInterface(object)) {
                    return false;
                }
                IdentifiedObject identifiedObject = (IdentifiedObject)object;
                return Utilities.deepEquals(this.getName(), identifiedObject.getName(), comparisonMode) && Utilities.deepEquals(this.getAlias(), identifiedObject.getAlias(), comparisonMode) && Utilities.deepEquals(this.getIdentifiers(), identifiedObject.getIdentifiers(), comparisonMode) && Utilities.deepEquals(this.getRemarks(), identifiedObject.getRemarks(), comparisonMode);
            }
            case IGNORE_METADATA: 
            case APPROXIMATIVE: 
            case ALLOW_VARIANT: 
            case DEBUG: {
                return this.implementsSameInterface(object);
            }
        }
        throw new IllegalArgumentException(Errors.format((short)146, ComparisonMode.class, (Object)comparisonMode));
    }

    private boolean implementsSameInterface(Object object) {
        Class<? extends IdentifiedObject>[] classArray;
        Class<? extends IdentifiedObject> clazz = this.getInterface();
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).getInterface() == clazz;
        }
        return clazz.isInstance(object) && (classArray = Classes.getLeafInterfaces(object.getClass(), clazz)).length == 1 && classArray[0] == clazz;
    }

    @Override
    public final boolean equals(Object object) {
        boolean bl = this.equals(object, ComparisonMode.STRICT);
        assert (!bl || this.hashCode() == object.hashCode()) : this;
        return bl;
    }

    public final int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            n = Numerics.hashCode(this.computeHashCode());
            if (n == 0) {
                n = -1;
            }
            this.hashCode = n;
        }
        assert (n == -1 || n == Numerics.hashCode(this.computeHashCode())) : n;
        return n;
    }

    protected long computeHashCode() {
        return Objects.hash(this.name, CollectionsExt.nonNull(this.alias), CollectionsExt.nonNull(this.identifiers), this.remarks) ^ this.getInterface().hashCode();
    }

    @Override
    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendName(this, formatter, ElementKind.forType(this.getClass()));
        return null;
    }

    AbstractIdentifiedObject() {
        this.deprecated = false;
    }

    @XmlID
    @XmlSchemaType(name="ID")
    @XmlAttribute(name="id", namespace="http://www.opengis.net/gml/3.2", required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    final String getID() {
        return NameIterator.getID(Context.current(), this, this.name, this.alias, this.identifiers);
    }

    private void setID(String string) {
        Context context = Context.current();
        if (!Context.setObjectForID(context, this, string)) {
            Context.warningOccured(context, this.getClass(), "setID", Errors.class, (short)25, string);
        }
    }

    @XmlElement(required=true)
    final Code getIdentifier() {
        return Code.forIdentifiedObject(this.getClass(), this.identifiers);
    }

    private void setIdentifier(Code code) {
        if (this.identifiers == null) {
            ReferenceIdentifier referenceIdentifier;
            if (code != null && (referenceIdentifier = code.getIdentifier()) != null) {
                this.identifiers = Collections.singleton(referenceIdentifier);
            }
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractIdentifiedObject.class, "setIdentifier", "identifier");
        }
    }

    @XmlElement(name="name", required=true)
    final Collection<ReferenceIdentifier> getNames() {
        return new Names();
    }

    private void setRemarks(InternationalString internationalString) {
        if (this.remarks == null) {
            this.remarks = internationalString;
        } else {
            MetadataUtilities.propertyAlreadySet(AbstractIdentifiedObject.class, "setRemarks", "remarks");
        }
    }

    private final class Names
    extends AbstractCollection<ReferenceIdentifier> {
        private Names() {
        }

        @Override
        public void clear() {
        }

        @Override
        public int size() {
            return NameIterator.count(AbstractIdentifiedObject.this);
        }

        @Override
        public Iterator<ReferenceIdentifier> iterator() {
            return new NameIterator(AbstractIdentifiedObject.this);
        }

        @Override
        public boolean add(ReferenceIdentifier referenceIdentifier) {
            if (NameIterator.isUnnamed(AbstractIdentifiedObject.this.name)) {
                AbstractIdentifiedObject.this.name = referenceIdentifier;
            } else {
                GenericName genericName;
                GenericName genericName2 = genericName = referenceIdentifier instanceof GenericName ? (GenericName)((Object)referenceIdentifier) : new NamedIdentifier(referenceIdentifier);
                if (AbstractIdentifiedObject.this.alias == null) {
                    AbstractIdentifiedObject.this.alias = Collections.singleton(genericName);
                } else {
                    int n = AbstractIdentifiedObject.this.alias.size();
                    GenericName[] genericNameArray = AbstractIdentifiedObject.this.alias.toArray(new GenericName[n + 1]);
                    genericNameArray[n] = genericName;
                    AbstractIdentifiedObject.this.alias = UnmodifiableArrayList.wrap(genericNameArray);
                }
            }
            return true;
        }
    }
}

