/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.Utf8;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class IsoTypeWriter {
    public static void writeUInt64(ByteBuffer bb, long u) {
        IsoTypeWriter.writeUInt32(bb, u >> 32 & 0xFFFFFFFFL);
        IsoTypeWriter.writeUInt32(bb, u & 0xFFFFFFFFL);
    }

    public static void writeUInt32(ByteBuffer bb, long u) {
        assert (u >= 0L && u <= 0x100000000L) : "The given long is not in the range of uint32 (" + u + ")";
        IsoTypeWriter.writeUInt16(bb, (int)(u >> 16 & 0xFFFFL));
        IsoTypeWriter.writeUInt16(bb, (int)u & 0xFFFF);
    }

    public static void writeUInt24(ByteBuffer bb, int i) {
        IsoTypeWriter.writeUInt16(bb, (i &= 0xFFFFFF) >> 8);
        IsoTypeWriter.writeUInt8(bb, i);
    }

    public static void writeUInt16(ByteBuffer bb, int i) {
        IsoTypeWriter.writeUInt8(bb, (i &= 0xFFFF) >> 8);
        IsoTypeWriter.writeUInt8(bb, i & 0xFF);
    }

    public static void writeUInt8(ByteBuffer bb, int i) {
        bb.put(IsoTypeWriter.int2byte(i));
    }

    public static void writeFixedPont1616(ByteBuffer bb, double v) throws IOException {
        int result = (int)(v * 65536.0);
        bb.put((byte)((result & 0xFF000000) >> 24));
        bb.put((byte)((result & 0xFF0000) >> 16));
        bb.put((byte)((result & 0xFF00) >> 8));
        bb.put((byte)(result & 0xFF));
    }

    public static void writeFixedPont88(ByteBuffer bb, double v) throws IOException {
        short result = (short)(v * 256.0);
        bb.put((byte)((result & 0xFF00) >> 8));
        bb.put((byte)(result & 0xFF));
    }

    public static byte int2byte(int i) {
        return (byte)((i &= 0xFF) > 127 ? i - 256 : i);
    }

    public static void writeIso639(ByteBuffer bb, String language) {
        int bits = 0;
        int i = 0;
        while (i < 3) {
            bits += language.getBytes()[i] - 96 << (2 - i) * 5;
            ++i;
        }
        IsoTypeWriter.writeUInt16(bb, bits);
    }

    public static void writeUtf8String(ByteBuffer bb, String string) {
        bb.put(Utf8.convert(string));
        IsoTypeWriter.writeUInt8(bb, 0);
    }
}

